import copy
import pymysql
from sqlalchemy import func, desc, or_
from flask import current_app, request, jsonify
from apps.models import Induzone, Industry, CompanyIndustryPoint
from apps.utils.response_code import RET
from apps.view_choose_address import api_address


# 选址评估，选择建议
@api_address.route("/advice", methods=["POST"])
def advice():
    req_dict = request.get_json()
    industry = req_dict.get("industry")  # 所属行业选择 nid（必填）
    product = req_dict.get("product")  # 主营产品 "药" （必填）
    budget = req_dict.get('budget')  # 落地投资预算 "22" # 大于 （必填）
    preference = req_dict.get("preference")  # 选址偏好 [f,f,t,f,f,f]

    revenue = req_dict.get("revenue")  # 去年营收 "2" （非必填）
    tax = req_dict.get("tax")  # 去年税收 "1" （非必填）
    address = req_dict.get("address")  # 意向选址  "小店区"  （非必填）
    # print(address)
    if not all([industry, product, budget, preference]):
        return jsonify(code=RET.DATAERR, msg="数据不全")

    try:
        indu = Industry.query.filter_by(nid=industry).first()
        if not indu:
            return jsonify(code=RET.DATAERR, msg="参数错误")
        industry_name = indu.oname
        # zone = Induzone.query.outerjoin(CompanyIndustryPoint, Induzone.name == CompanyIndustryPoint.district). \
        #     filter(or_(Induzone.navigat.like("%{}%".format(industry_name)),
        #                Induzone.navigator.like("%{}%".format(industry_name)))). \
        #     filter(Induzone.invest_power <= budget)
        zone = Induzone.query.filter(or_(Induzone.navigat.like("%{}%".format(industry_name)),
                                         Induzone.navigator.like("%{}%".format(industry_name)))). \
            filter(Induzone.invest_power <= budget)
        if address:  # 选址
            zone = zone.filter(or_(Induzone.region == address, Induzone.development_zone == address))
        if tax:  # 税收
            zone = zone.filter(Induzone.tax <= tax)
        if preference[0] == "true":  # 政府扶持力度 --- 政策数的打分
            zone = zone.order_by(Induzone.policy_point.desc())
        if preference[1] == "true":  # 产业聚集度 --- 产业的打分
            zone = zone.outerjoin(CompanyIndustryPoint, Induzone.name == CompanyIndustryPoint.district).filter(
                CompanyIndustryPoint.f_type == industry).order_by(CompanyIndustryPoint.point.desc())
            # zone = zone.order_by(CompanyIndustryPoint.point.desc())
        if preference[2] == "true":  # 交通 -----交通打分
            zone = zone.order_by(Induzone.electricity_point.desc())
        if preference[3] == "true":  # 生活配套 -------水电打分、最低、普工、中级人员薪资
            zone = zone.order_by(Induzone.warter_point.desc()).order_by(Induzone.wagelevel.desc()).order_by(
                Induzone.worker.desc()).order_by(Induzone.middlemag.desc())
        if preference[4] == "true":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
            zone = zone.order_by(Induzone.mall_point.desc(), Induzone.hotel_point.desc(), Induzone.school_point.desc())
        if preference[5] == "true":  # 地区经济发展 ---GDP的打分
            zone = zone.order_by(Induzone.gdp_point.desc())
        zone = zone.group_by(Induzone.name)
        result = zone.limit(3).all()
        data = [{"id": i.id,
                 "name": i.name,
                 "charge": i.charge if i.charge else "-",
                 "phone": i.phone if i.phone else "-",
                 "jwd": {"lng": i.lng, "lat": i.lat}} for i in result]
        # print(data)
        # 没有查询结果的查找
        # if not result:
        #     # 在第一条建议显示
        #     data = [{"name": "对不起，没有找到合适的园区！"}]
        new_preference = copy.deepcopy(preference)
        # del new_preference[2]
        for i in range(0, len(data)):
            if "true" in new_preference:
                grade = 0
                list_info = []
                info = "根据{}算出结果，得分为{}"
                s1 = Induzone.query.get(data[i]["id"])

                if preference[5] != "false":  # 地区经济发展 ---GDP的打分
                    grade += s1.gdp_point if s1.gdp_point else 0
                    list_info.append("地区经济发展")

                if preference[1] != "false":  # 产业聚集度 --- 产业的打分
                    # sum_list.append("IFNULL(company_industry_point,0)")
                    ss = CompanyIndustryPoint.query.filter_by(district=data[i]["name"], f_type=industry).first()
                    grade += ss.point if ss else 0
                    list_info.append("产业聚集度")
                if preference[0] != "false":  # 征服扶持力度 --- 政策数的打分
                    grade += s1.policy_point if s1.policy_point else 0
                    list_info.append("政府扶持力度")
                if preference[3] != "false":  # 生活配套 -------水电打分
                    grade += s1.warter_point if s1.warter_point else 0
                    list_info.append("生活配套")
                # if preference[2] :  # 交通 -----交通打分
                #     sum_list.append("IFNULL(induzone.electricity_point,0)")
                if preference[2] != "false":
                    grade += s1.electricity_point if s1.electricity_point else 0
                    list_info.append("交通")
                if preference[4] != "false":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
                    list_info.append("园区配套服务")
                    grade += s1.mall_point if s1.mall_point else 0
                    grade += s1.hotel_point if s1.hotel_point else 0
                    grade += s1.school_point if s1.school_point else 0

                list_info = ",".join(list_info)
                grade = grade / (0.2 * new_preference.count("true")) * 100
                info = info.format(list_info, int(grade))
            else:
                info = "请选择选址偏好后得到更为精确定位"
            data[i]["info"] = info
        # 没有查询结果的查找
        if not result:
            # 在第一条建议显示
            data = [{"name": "对不起，没有找到合适的园区！"}]
        return jsonify(code=RET.OK, msg="选址成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 地图的处理
@api_address.route("/map", methods=["POST"])
def map():
    req_dict = request.get_json()
    district = req_dict.get("district")

    try:
        if not district:
            # 获取所有的园区值
            district_list = Induzone.query.filter_by().all()
            data = [{"name": j.name, "jwd": {"lat": j.lat, "lng": j.lng}} for j in district_list]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        district_list = Induzone.query.filter_by(region=district)
        data = [{"name": i.name, "jwd": {"lat": i.lat, "lng": i.lng}} for i in district_list]
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取行业筛选条件
@api_address.route("/downList", methods=["GET"])
def downlist():
    """一级二级行业分类"""
    try:
        industry = Industry.query.filter_by(statu=1).all()
        data = [{
            "name": i.name,
            "id": i.nid,
        } for i in industry]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    return jsonify(code=RET.OK, msg="查找成功", data=data)
