from flask import current_app, request, jsonify
from apps.models import *
from apps.utils.response_code import RET
from apps.view_choose_address import api_address
import copy
import pymysql


# 选址评估，选择建议
@api_address.route("/advice", methods=["POST"])
def advice():
    req_dict = request.get_json()
    company = req_dict.get("company")  # 企业名称（无作用）
    industry = req_dict.get("industry")  # 行业选择 nid
    revenue = req_dict.get("revenue")  # 营收 "2"
    tax = req_dict.get("tax")  # 税收 "1"
    product = req_dict.get("product")  # 主营产品 "药"
    budget = req_dict.get('budget')  # 预算 "22" # 大于
    address = req_dict.get("address")  # 地址  "小店区"
    preference = req_dict.get("preference")  # 选址偏好 [f,f,t,f,f,f]

    if not all([company, industry, revenue, tax, product, budget, preference]):
        return jsonify(code=RET.DATAERR, msg="数据不全")

    list_zone = []  # 拼接sql的列表
    if address:
        list_zone.append("(region='{}'or development_zone = '{}')".format(address, address))  # 太原园区的字段 Induzone

    list_zone.append(" (f_type is Null or f_type = {}) ".format(industry))  # 企业聚合度 CompanyIndustryPoint
    list_zone.append("IFNULL(induzone.tax,0)<={}".format(tax))  # 园区税收要求 Induzone
    list_zone.append("IFNULL(induzone.invest_power,0)<={}".format(budget))  # 投资强度 Induzone
    list_zone = " and ".join(list_zone)  # 拼接

    sum_list = []
    if preference[5] != "false":  # 地区经济发展 ---GDP的打分
        sum_list.append("IFNULL(induzone.gdp_point,0)")

    if preference[1] != "false":  # 产业聚集度 --- 产业的打分
        # sum_list.append("IFNULL(company_industry_point,0)")
        sum_list.append("IFNULL(company_industry_point.point,0)")

    if preference[0] != "false":  # 征服扶持力度 --- 政策数的打分
        sum_list.append("IFNULL(induzone.policy_point,0)")

    if preference[3] != "false":  # 生活配套 -------水电打分
        sum_list.append("IFNULL(induzone.warter_point,0)")

    if preference[2] != "false":  # 交通 -----交通打分
        sum_list.append("IFNULL(induzone.electricity_point,0)")

    if preference[4] != "false":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
        sum_list.append("IFNULL(induzone.mall_point,0)")
        sum_list.append("IFNULL(induzone.hotel_point,0)")
        sum_list.append("IFNULL(induzone.school_point,0)")

    # 拼接where请求
    if list_zone:
        list_zone = "where " + list_zone

    # 拼接排序请求
    sum_list = " + ".join(sum_list)
    # print(sum_list, "-" * 10)

    if sum_list:
        sum_list = " order by " + sum_list + " desc"
    # sql语句
    sql = "select * from induzone " \
          "LEFT OUTER JOIN company_industry_point on induzone.name = company_industry_point.district " \
          + list_zone + sum_list
    print(sql)
    try:
        conn = pymysql.connect(host='39.100.39.50',
                               user='root',
                               password='Root@2020',
                               db='indutyty',
                               charset='utf8mb4')

        cursor = conn.cursor()
        data_num = cursor.execute(sql)
        data_list = cursor.fetchall()

        # print(sql)
        if data_num > 3:
            data_list = data_list[0:3]
        data = [{"id": i[0],
                 "name": i[1],
                 "charge": i[9] if i[9] else "-",
                 "phone": i[10] if i[10] else "-",
                 "jwd": {"lng": i[13], "lat": i[14]}} for i in data_list]
        # 没有查询结果的查找
        if not data_list:
            # 在第一条建议显示
            data = [{"name": "对不起，没有找到合适的园区！"}]
        cursor.close()
        conn.close()

        new_preference = copy.deepcopy(preference)
        # del new_preference[2]
        for i in range(0, len(data)):
            if "true" in new_preference:
                grade = 0
                list_info = []
                info = "根据{}算出结果，得分为{}"
                s1 = Induzone.query.get(data[i]["id"])

                if preference[5] != "false":  # 地区经济发展 ---GDP的打分
                    grade += s1.gdp_point if s1.gdp_point else 0
                    list_info.append("地区经济发展")

                if preference[1] != "false":  # 产业聚集度 --- 产业的打分
                    # sum_list.append("IFNULL(company_industry_point,0)")
                    ss = CompanyIndustryPoint.query.filter_by(district=data[i]["name"], f_type=industry).first()
                    grade += ss.point if ss else 0
                    list_info.append("产业聚集度")
                if preference[0] != "false":  # 征服扶持力度 --- 政策数的打分
                    grade += s1.policy_point if s1.policy_point else 0
                    list_info.append("政府扶持力度")
                if preference[3] != "false":  # 生活配套 -------水电打分
                    grade += s1.warter_point if s1.warter_point else 0
                    list_info.append("生活配套")
                # if preference[2] :  # 交通 -----交通打分
                #     sum_list.append("IFNULL(induzone.electricity_point,0)")
                if preference[2] !="false":
                    grade += s1.electricity_point if s1.electricity_point else 0
                    list_info.append("交通")
                if preference[4] != "false":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
                    list_info.append("园区配套服务")
                    grade += s1.mall_point if s1.mall_point else 0
                    grade += s1.hotel_point if s1.hotel_point else 0
                    grade += s1.school_point if s1.school_point else 0

                list_info = ",".join(list_info)
                grade = grade / (0.2 * new_preference.count("true")) * 100
                info = info.format(list_info, int(grade))
            else:
                info = "请选择选址偏好后得到更为精确定位"
            data[i]["info"] = info

        return jsonify(code=RET.OK, msg="选址成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 地图的处理
@api_address.route("/map", methods=["POST"])
def map():
    req_dict = request.get_json()
    district = req_dict.get("district")

    try:
        if not district:
            # 获取所有的园区值
            district_list = Induzone.query.filter_by().all()
            data = [{"name": j.name, "jwd": {"lat": j.lat, "lng": j.lng}} for j in district_list]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        district_list = Induzone.query.filter_by(region=district)
        data = [{"name": i.name, "jwd": {"lat": i.lat, "lng": i.lng}} for i in district_list]
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取行业筛选条件
@api_address.route("/downList", methods=["GET"])
def downlist():
    """一级二级行业分类"""
    try:
        industry = Industry.query.filter_by(statu=1).all()
        data = [{
            "name": i.name,
            "id": i.nid,
        } for i in industry]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    return jsonify(code=RET.OK, msg="查找成功", data=data)
