import json
from flask import request, jsonify, session, current_app
from sqlalchemy import func, desc, or_
from apps.models import *
from apps.view_attract import api_attract
from apps.utils.response_code import RET
from apps import db, constants, redis_store


# 改变城市数据
@api_attract.route("/changeCityData", methods=["POST"])
def changeCityData():
    req_dic = request.get_json()
    year = req_dic.get("年份")
    district = req_dic.get("区县名称")
    GDP = req_dic.get("地区生产总值")
    size = req_dic.get("面积")
    people = req_dic.get("人口")
    investment = req_dic.get("固定资产投资")
    retail = req_dic.get("社会消费品零售额")
    public = req_dic.get("一般公共预算支出")
    addscale = req_dic.get("规上工业增加值增速")
    in_out = req_dic.get("进出口总额")
    people_out = req_dic.get("居民人均可支配收入")
    people_per = req_dic.get("居民消费价格指数")
    info = req_dic.get("区县介绍")
    if not all([year, district]):
        return jsonify(code=RET.PARAMERR, msg="省份和年份是必填参数")
    try:
        city = City.query.filter_by(area=district, year=2020).first()
        if GDP:
            city.GDP = GDP
        if size:
            city.GDP = size
        if people:
            city.people = people
        if investment:
            city.investment = investment
        if retail:
            city.retail = retail
        if public:
            city.public = public
        if addscale:
            city.addscale = addscale
        if in_out:
            city.in_out = in_out
        if people_out:
            city.people_out = people_out
        if people_per:
            city.people_per = people_per
        if info:
            city.info = info
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


@api_attract.route("/addCityData", methods=["POST"])
def addCityData():
    req_dic = request.get_json()
    year = req_dic.get("年份")
    district = req_dic.get("区县名称")
    GDP = req_dic.get("地区生产总值")
    size = req_dic.get("面积")
    people = req_dic.get("人口")
    investment = req_dic.get("固定资产投资")
    retail = req_dic.get("社会消费品零售额")
    public = req_dic.get("一般公共预算支出")
    addscale = req_dic.get("规上工业增加值增速")
    in_out = req_dic.get("进出口总额")
    people_out = req_dic.get("居民人均可支配收入")
    people_per = req_dic.get("居民消费价格指数")
    info = req_dic.get("区县介绍")

    if not all([year, district]):
        return jsonify(code=RET.PARAMERR, msg="省份和年份是必填参数")
    try:
        city = City(area=district, year=year)
        if GDP:
            city.GDP = GDP
        if size:
            city.GDP = size
        if people:
            city.people = people
        if investment:
            city.investment = investment
        if retail:
            city.retail = retail
        if public:
            city.public = public
        if addscale:
            city.addscale = addscale
        if in_out:
            city.in_out = in_out
        if people_out:
            city.people_out = people_out
        if people_per:
            city.people_per = people_per
        if info:
            city.info = info
        db.session.add(city)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


@api_attract.route("/updateExamdata", methods=["POST"])
def updateExamdata():
    req_dic = request.get_json()
    year = req_dic.get("年份")
    district = req_dic.get("区县名称")
    month = req_dic.get("月份")

    sign_finnish = req_dic.get("签约项目投资额完成额")
    sign_grade = req_dic.get("签约项目投资额完成率")
    start_finish = req_dic.get("开工项目计划投资额完成额")
    start_grade = req_dic.get("开工项目计划投资额完成率")
    invest_finish = req_dic.get("开工项目到位金额完成额")
    invest_grade = req_dic.get("开工项目到位金额完成率")
    if not all([district]):
        return jsonify(code=RET.PARAMERR, msg="缺少必要参数")
    try:
        examine = Examine.query.filter_by(district=district)
        if sign_finnish:
            examine.sign_finnish = sign_finnish * 100
        if sign_grade:
            examine.sign_grade = sign_grade
        if start_finish:
            examine.start_finish = start_finish
        if start_grade:
            examine.start_grade = start_grade
        if invest_finish:
            examine.invest_finish = invest_finish * 10
        if invest_grade:
            examine.invest_grade = invest_grade
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Examine as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据库错误')


# 更新饼图数据
@api_attract.route("/updateNewProject", methods=["POST"])
def updateNewProject():
    req_dic = request.get_json()
    district = req_dic.get("区县")
    type = req_dic.get("行业")
    number = req_dic.get("项目个数")
    money = req_dic.get("金额")
    if not all([district, type]):
        return jsonify(code=RET.PARAMERR, msg="缺少必要参数")
    try:
        newproject = NewProject.query.filter_by(district=district, type=type).first()
        if number:
            newproject.number = number
        if money:
            newproject.money = money
        db.session.commit()
    except Exception as e:
        db.session.rollbakck()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 添加饼图数据
@api_attract.route("/addNewProject", methods=["POST"])
def addNewProject():
    req_dic = request.get_json()
    district = req_dic.get("区县")
    type = req_dic.get("行业")
    number = req_dic.get("项目个数")
    money = req_dic.get("金额")
    if not all([district, type, number, money]):
        return jsonify(code=RET.PARAMERR, msg="缺少必要参数")
    try:
        newproject = NewProject.query.filter_by(district=district, type=type).first()
        if newproject:
            return jsonify(code=RET.DATAEXIST, msg="数据已存在")
        newproject = NewProject(district=district, type=type, number=number, money=money)
        db.session.add(newproject)
        db.session.commit()
    except Exception as e:
        db.session.rollbakck()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
