from flask import current_app, request, jsonify
from apps.view_mobile import api_mobile
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
from apps.models import *
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from datetime import datetime, timedelta
import datetime


# 太原市企业列表
@api_mobile.route('/tycompany', methods=['POST'])
@login_required
def enterprise():
    '''太原市企业列表'''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id
    # user_id = 5  # 用户id

    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    district = req_dict.get("district")  # 太原市下区县
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == "1":
            company = Company.query.filter_by(f_type=inid, city="太原市")
        else:
            company = Company.query.filter_by(c_type=inid, city="太原市")
        # 企业类型
        if entype:
            company = company.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                company = company.filter_by(high_new=1)
            if qualificat == 2:
                company = company.filter_by(tbe=1)
            if qualificat == 3:
                company = company.filter_by(quoted_company=1)
            if qualificat == 4:
                company = company.filter_by(sxonhun=1)
            if qualificat == 5:
                company = company.filter_by(isfive=1)
            if qualificat == 6:
                company = company.filter_by(unicorn=1)
            if qualificat == 7:
                company = company.filter_by(dengl=1)
            if qualificat == 8:
                company = company.filter_by(zjtg=1)
            if qualificat == 9:
                company = company.filter_by(scale=1)
            if qualificat == 10:
                company = company.filter_by(serve=1)
        # 注册资本
        if capital:
            company = company.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            company = company.filter_by(public_id=quoted)
        # 区域选择
        if district:
            company = company.filter_by(district=district)
        # 成立时间id
        if yearid:
            company = company.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            company = company.filter_by(roundid=roundid)

        size = company.count()
        companys = company.order_by(Company.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        user = User.query.get(user_id)  # 获取关注列表
        if user:
            company_ids = [coms.id for coms in user.company]
        else:
            company_ids = []

        df = [{"id": com.id,
               "company_name": com.company_name,
               "legal": com.legal if com.legal else "",
               "capital": com.capital if com.capital else "",
               "build_date": str(com.build_date)[:10] if com.build_date else "",
               "collect": "1" if com.id in company_ids else "2",  # 关注状态码1关注，2未关注
               "choice": "1"  # 1太原企业，2全国企业
               } for com in companys]
        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="参数错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 全国企业列表
@api_mobile.route('/view_map/enterprise', methods=['POST'])
# @login_required
def att_enterprise():
    '''
    太原市企业列表
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:  # 子行业分类
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 企业类型
        if entype:
            enterprise = enterprise.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                enterprise = enterprise.filter_by(high_new=1)
            if qualificat == 2:
                enterprise = enterprise.filter_by(tbe=1)
            if qualificat == 3:
                enterprise = enterprise.filter_by(quoted_company=1)
            if qualificat == 4:
                enterprise = enterprise.filter_by(isfive=1)
            if qualificat == 5:
                enterprise = enterprise.filter_by(unicorn=1)
            if qualificat == 6:
                enterprise = enterprise.filter_by(dengl=1)

        # 注册资本
        if capital:
            enterprise = enterprise.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            enterprise = enterprise.filter_by(public_id=quoted)
        # 区域选择
        if province:
            enterprise = enterprise.filter_by(province=province)
            if city:
                enterprise = enterprise.filter_by(city=city)
                if district:
                    enterprise = enterprise.filter_by(district=district)
        # 成立时间id
        if yearid:
            enterprise = enterprise.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            enterprise = enterprise.filter_by(roundid=roundid)

        size = enterprise.count()
        enterprise = enterprise.order_by(Enterprise.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": com.id,
               "company_name": com.company_name,  # 企业名称
               "status": com.status if com.status else "",  # 企业状态
               "legal": com.legal if com.legal else "",  # 法人
               "capital": com.capital if com.capital else "",  # 注册资本
               "build_date": str(com.build_date)[:10] if com.build_date else "",  # 时间
               "telephone": str(com.telephone) if com.telephone else "",  # 电话
               "address": str(com.address) if com.address else "",  # 地址
               "lng":com.lng if com.lng else "",
               "lat":com.lat if com.lat else "",
               # "collect": "1" if com.id in company_ids else "2",  # 关注状态码1关注，2未关注
               "choice": "2"  # 1太原企业，2全国企业
               } for com in enterprise]

        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# ty+全国企业信息详情
@api_mobile.route('/companyDetail', methods=['POST'])
@login_required
def company_detail():
    '''
    企业信息详情
    :return:
    '''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id
    # user_id = 5

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id
    choice = req_dict.get("choice")  # 企业选择

    # 校验参数完整性
    if not all([_id, choice]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if choice == "1":
            company = Company.query.get(_id)
            user = User.query.get(user_id)  # 获取关注列表
            if user:
                company_ids = [coms.id for coms in user.company]
            else:
                company_ids = []
            if company:
                data = {"id": company.id,
                        "company_name": company.company_name,
                        "legal": company.legal if company.legal else "",  # 法人
                        "status": company.status if company.status else "",  # 状态
                        "build_date": str(company.build_date)[:10] if company.build_date else "",  # 成立日期
                        "capital": company.capital if company.capital else "",  # 注册资本
                        "telephone": company.telephone if company.telephone else "",  # 电话
                        "address": company.address if company.address else "",  # 地址
                        "email": company.email if company.email else "-",  # 邮箱
                        # "web_site": company.web_site if company.web_site else "-", # 网址
                        "company_info": company.company_info if company.company_info else "",  # 简介
                        "social_code": company.social_code if company.social_code else "",  # 社会统一信用代码
                        "tax_code": company.tax_code if company.tax_code else "",  # 纳税人识别号
                        "register_code": company.register_code if company.register_code else "",  # 注册号
                        "company_code": company.company_code if company.company_code else "",  # 组织机构代码
                        "bao": company.bao_num if company.bao_num else 0,  # 组织机构代码
                        "entype": company.entype if company.entype else "",  # 企业类型
                        "industry": company.company_industry if company.company_industry else "",  # 所属行业
                        "scope": company.business_scope if company.business_scope else "",  # 经营范围
                        "taking": company.takingn if company.takingn else "",  # 营收
                        "jwd": {"lng": company.lng if company.lng else "-",
                                "lat": company.lat if company.lat else "-"},
                        # "high_new": "高新技术企业" if company.high_new else "-",
                        "collect": "1" if company.id in company_ids else "2",  # 关注状态码1关注，2未关注
                        "choice": "1"  # 1太原企业，2全国企业
                        }
            else:
                return jsonify(code=RET.NODATA, msg="查无数据")
            return jsonify(code=RET.OK, msg="获取成功", data=data)
        else:
            enterprise = Enterprise.query.get(_id)
            user = User.query.get(user_id)  # 获取关注列表
            if user:
                company_ids = [coms.id for coms in user.enterprise]
            else:
                company_ids = []
            if enterprise:
                data = {"id": enterprise.id,
                        "company_name": enterprise.company_name,
                        "legal": enterprise.legal if enterprise.legal else "",  # 法人
                        "status": enterprise.status if enterprise.status else "",  # 状态
                        "build_date": str(enterprise.build_date)[:10] if enterprise.build_date else "",  # 成立日期
                        "capital": enterprise.capital if enterprise.capital else "",  # 注册资本
                        "telephone": enterprise.telephone if enterprise.telephone else "",  # 电话
                        "address": enterprise.address if enterprise.address else "",  # 地址
                        "email": enterprise.email if enterprise.email else "-",  # 邮箱
                        # "web_site": company.web_site if company.web_site else "-", # 网址
                        "company_info": enterprise.company_info if enterprise.company_info else "",  # 简介
                        "social_code": enterprise.social_code if enterprise.social_code else "",  # 社会统一信用代码
                        "tax_code": enterprise.tax_code if enterprise.tax_code else "",  # 纳税人识别号
                        "register_code": enterprise.register_code if enterprise.register_code else "",  # 注册号
                        "company_code": enterprise.company_code if enterprise.company_code else "",  # 组织机构代码
                        "bao": enterprise.bao_num if enterprise.bao_num else 0,  # 组织机构代码
                        "entype": enterprise.entype if enterprise.entype else "",  # 企业类型
                        "industry": enterprise.company_industry if enterprise.company_industry else "",  # 所属行业
                        "scope": enterprise.business_scope if enterprise.business_scope else "",  # 经营范围
                        "taking": enterprise.takingn if enterprise.takingn else "",  # 营收
                        "jwd": {"lng": enterprise.lng if enterprise.lng else "-",
                                "lat": enterprise.lat if enterprise.lat else "-"},
                        # "high_new": "高新技术企业" if company.high_new else "-",
                        "collect": "1" if enterprise.id in company_ids else "2",  # 关注状态码1关注，2未关注
                        "choice": "2"  # 1太原企业，2全国企业
                        }
            else:
                return jsonify(code=RET.NODATA, msg="查无数据")
            return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 太原市创新资源机构列表（高等院校和告高职转告合并，高职专高作为第二分类，合并两个表）
@api_mobile.route('/innovate/orgs', methods=['POST'])
# @login_required
def orgs():
    '''创新资源机构列表'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）

    cateone = req_dict.get("cateone")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4
    catetwo = req_dict.get("catetwo")  # 机构类型2 id

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([cateone, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="创新资源机构一类参数不完整")

    if (inid and not cate) or (cate and not inid):
        return jsonify(code=RET.PARAMERR, msg="行业参数不完整")
    # if cate and not inid:
    #     return jsonify(code=RET.PARAMERR, msg="行业参数不完整")

    if cateone == 1:  # 高等院校
        try:
            if inid:
                name = Industry.query.filter_by(nid=inid).first().oname
                if cate == "1":
                    college = College.query.filter(College.navigator.like("%{}%".format(name)))
                else:
                    college = College.query.filter(College.navigat.like("%{}%".format(name)))
            else:
                college = College.query.filter_by()
            if catetwo:
                college = college.filter_by(cateid=catetwo)

            size = college.count()
            college = college.paginate(page, perpage).items

            data = {"df": [{"id": i.id,
                            "name": i.name,
                            "nature": i.nature if i.nature else "-",  # 办学性质
                            "build_date": i.buildate if i.buildate else "-",  # 时间
                            "clas": i.clas if i.clas else "-",  # 类别
                            "cateone": cateone} for i in college],
                    "size": size}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="参数错误")
    elif cateone == 2:  # 科研机构
        if inid:
            name = Industry.query.filter_by(nid=inid).first().oname
            if cate == "1":
                scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
            else:
                scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
        else:
            scientific = Scientific.query.filter_by()
        size = scientific.count()
        scientific = scientific.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "telephone": str(i.telephone) if i.telephone else "-",  # 电话
                        "address": i.address if i.address else "-",  # 地址
                        "cateone": cateone} for i in scientific],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    elif cateone == 3:  # 创新平台3
        if inid:
            name = Industry.query.filter_by(nid=inid).first().oname
            if cate == "1":
                lab = Lab.query.filter(Lab.navigator.like("%{}%".format(name)))
            else:
                lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        else:
            lab = Lab.query.filter_by()
        if catetwo:
            lab = lab.filter_by(cateid=catetwo)

        size = lab.count()
        lab = lab.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        # "cate": i.cate,
                        "address": i.address if i.address else "-",  # 地址
                        "cateone": cateone} for i in lab],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    elif cateone == 4:  # 产业服务平台
        if inid:
            name = Industry.query.filter_by(nid=inid).first().oname
            if cate == "1":
                platform = Platform.query.filter(Platform.navigator.like("%{}%".format(name)))
            else:
                platform = Platform.query.filter(Platform.navigat.like("%{}%".format(name)))
        else:
            platform = Platform.query.filter_by()
        if catetwo:
            platform = platform.filter_by(cateid=catetwo)

        size = platform.count()
        platform = platform.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        # "cate": cateone,
                        "address": i.address if i.address else "-",  # 地址
                        "cateone": cateone} for i in platform],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)

    else:
        return jsonify(code=RET.PARAMERR, msg="参数错误")


# 太原园区列表
@api_mobile.route('/carrier/garden', methods=['POST'])
# @login_required
def garden():
    '''创新资源机构列表'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    cate = req_dict.get("cate")  # 行业等级,（高端设备等五个为"1",子行业为"2"）

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    keyword = req_dict.get("keyword")  # 搜索园区姓名
    level = req_dict.get("level")  # 园区级别

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
            if cate == "1":
                induzone = Induzone.query.filter(Induzone.navigator.like("%{}%".format(name)))
            else:
                induzone = Induzone.query.filter(Induzone.navigat.like("%{}%".format(name)))
        else:
            induzone = Induzone.query.filter_by()
        if keyword:
            induzone = induzone.filter(Induzone.name.like("%{}%".format(keyword)))  # 查询词
        if level:
            induzone = induzone.filter_by(level=level)  # 园区级别筛选

        size = induzone.count()  # 分页总数
        induzone = induzone.paginate(page, perpage).items

        data = {"garden": [{"id": i.id,
                            "name": i.name,
                            "level": i.level if i.level else "-",  # 级别
                            # "cate": i.cate, # 园区类型
                            "area": i.area if i.area else "-",  # 面基
                            "cluster": i.cluster if i.cluster else ""  # 集群
                            } for i in induzone],
                "size": size}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="查询成功", data=data)


# 雷达监测页企业数量趋势统计
@api_mobile.route('/view_radar/tendency', methods=['POST'])
@login_required
def tendency():
    '''雷达监测页企业数量统计'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    area = req_dict.get("area")  # [省，市，区]
    province = area[0]
    city = area[1]
    district = area[2]
    product = req_dict.get("product")  # 企业产品
    sone = req_dict.get("sone")  # 选择1，1企业个数，2注册资本
    stwo = req_dict.get("stwo")  # 选择2， 1年度，2季度，3月度
    sthr = req_dict.get("sthr")  # 选择3， 1新增量，2累积量

    # 校验参数完整性
    if not all([area, sone, stwo, sthr]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()

        if province:
            enterprise = enterprise.filter_by(province=province)
        if city:
            enterprise = enterprise.filter_by(city=city)
        if district:
            enterprise = enterprise.filter_by(district=district)
        if product:
            # 有可能会变成模糊查询
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
            # company = company.filter_by(product_all=product)

        yearn = datetime.datetime.now().year + 1  # 现在年份
        scope = [i for i in range(1980, yearn, 5)]  # 年份范围
        months = [(1, 3), (4, 6), (7, 9), (10, 12)]  # 季度
        data = list()
        if sthr == 1:  # 新增量
            if stwo == 1:  # 年度，1980-2020
                for year in scope:
                    result = enterprise.filter(extract("year", Enterprise.build_date) == year)
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[year] = nums
                        data.append({"lable": year, "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[year] = round(cnums, 2) if cnums else 0
                        data.append({"lable": year, "value": round(cnums, 2) if cnums else 0})
            elif stwo == 2:  # 2020年季度
                for jd in range(len(months)):
                    result = enterprise.filter(and_(extract("year", Enterprise.build_date) == (yearn - 1),
                                                    extract("month", Enterprise.build_date).between(months[jd][0],
                                                                                                    months[jd][1])))
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[(jd + 1)] = nums
                        data.append({"lable": (jd + 1), "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[(jd + 1)] = round(cnums, 2) if cnums else 0
                        data.append({"lable": (jd + 1), "value": round(cnums, 2) if cnums else 0})
            elif stwo == 3:  # 2020年月度
                for m in range(1, 13):
                    result = enterprise.filter(and_(extract("year", Enterprise.build_date) == (yearn - 1),
                                                    extract("month", Enterprise.build_date) == m))
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[m] = nums
                        data.append({"lable": m, "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[m] = round(cnums, 2) if cnums else 0
                        data.append({"lable": m, "value": round(cnums, 2) if cnums else 0})
        elif sthr == 2:  # 累积量
            if stwo == 1:  # 年度，1980-2020
                for year in scope:
                    result = enterprise.filter(extract("year", Enterprise.build_date) <= year)
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[year] = nums
                        data.append({"lable": year, "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[year] = round(cnums, 2) if cnums else 0
                        data.append({"lable": year, "value": round(cnums, 2) if cnums else 0})
            elif stwo == 2:  # 2020年季度
                for jd in range(len(months)):
                    result = enterprise.filter(and_(extract("year", Enterprise.build_date) == (yearn - 1),
                                                    extract("month", Enterprise.build_date) <= months[jd][1]))
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[(jd + 1)] = nums
                        data.append({"lable": (jd + 1), "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        # data[(jd + 1)] = round(cnums, 2) if cnums else 0
                        data.append({"lable": (jd + 1), "value": round(cnums, 2) if cnums else 0})
            elif stwo == 3:  # 2020年月度
                for m in range(1, 13):
                    result = enterprise.filter(and_(extract("year", Enterprise.build_date) == (yearn - 1),
                                                    extract("month", Enterprise.build_date) <= m))
                    if sone == 1:  # 企业个数
                        nums = result.count()
                        # data[m] = nums
                        data.append({"lable": m, "value": nums})
                    else:  # 注册资本
                        cnums = result.with_entities(func.sum(Enterprise.capital_nums)).scalar()
                        data.append({"lable": m, "value": round(cnums, 2) if cnums else 0})
                        # data[m] = round(cnums, 2) if cnums else 0
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)
