import datetime
import re
import json
import time
import random
import threading
import numpy as np
import requests
import filetype
from sqlalchemy.exc import IntegrityError
from flask_mail import Mail, Message
from flask import g, current_app, request, jsonify, session
from apps.user_pc import api_user
from apps import creat_app
from apps.utils.send_phone_info import send_code_new
from apps.utils.response_code import RET
from apps import db, constants, redis_store
from apps.models import *
from apps.util import create_token
from werkzeug.security import generate_password_hash, check_password_hash
from apps import qiniu_store
from apps.utils.vxconfig import WxConfig
from apps.utils.encrypt_decrypt.aes_cbc import encrypt, decrypt


# 给手机发验证码(2020-11-4)
@api_user.route("/send_mobile_code", methods=["POST"])
def send_phone_code():
    '''
    向手机发送验证码
    :return:
    '''
    # 获取请求参数，转化字典
    req_dict = request.get_json()
    mobile = req_dict.get('mobile')  # 手机号
    # 校验参数完整性
    if not all([mobile]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.MOBILEERR, msg="手机号格式错误")
    # # 判断手机号是否存在
    # try:
    #     user = User.query.filter_by(mobile=mobile).first()
    # except Exception as e:
    #     current_app.logger.error(e)
    # else:
    #     if user:  # 手机号已存在
    #         return jsonify(code=RET.DATAEXIST, msg="手机号已存在，请直接登录")

    # 生成短信验证码
    sms_code = "%06d" % random.randint(0, 999999)
    data = send_code_new(mobile, sms_code)
    # print(data)
    if data['Message'] == 'OK':
        # 保存真实的短信验证码
        try:
            redis_store.setex("sms_code_%s" % mobile, constants.SMS_CODE_REDIS_EXPIRES, sms_code)
            # 保存发送给这个手机号的记录，防止用户在60s内再次出发发送短信的操作
            redis_store.setex("send_sms_code_%s" % mobile, constants.SEND_SMS_CODE_INTERVAL, 1)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="保存短信验证码异常")
        # 发送成功
        return jsonify(code=RET.OK, msg="发送成功")
    else:
        return jsonify(code=RET.THIRDERR, msg="发送失败")


# 手机验证码登录(2020-11-4)
@api_user.route("/login_bysms", methods=["POST"])
def login_bysms():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    mobile = req_dict.get('mobile')  # 手机号
    sms_code = req_dict.get("sms_code")  # 验证码

    # 校验参数完整性
    if not all([mobile, sms_code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
        # real_sms_code = "123456"
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 获取用户
    try:
        user = User.query.filter_by(mobile=mobile).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        # if "123456" != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    if not user:
        # 判断并添加用户信息
        try:
            user = User(name=mobile, mobile=mobile, flag=1, status=1)
            db.session.add(user)
            db.session.commit()
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")
    # print(user.status==3)
    if user.status == 3:
        return jsonify(code=RET.USERERR, msg="当前用户被禁止登录,请联系管理员")

    # 获取用户id，传入生成token的方法，并接收返回的token
    token = create_token(user.id)

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用手机-短信验证码登录成功了！+++++++++++++++++++++++=++'.format(time, mobile))

    return jsonify(code=RET.OK, msg="登录成功", token=token, flag=user.flag)


# # 异步邮箱发送信息
# def send_async_email(mail, app, msg):
#     with app.app_context():
#         mail.send(msg)
#
#
# # 给邮箱发验证码
# @api_user.route("/send_email_code", methods=["POST"])
# def send_email_code():
#     '''
#     向邮箱送验证码
#     :return:
#     '''
#     # 获取请求参数，转化字典
#     req_dict = request.get_json()
#     email = req_dict.get('email')  # 邮箱号
#     # 校验参数完整性
#     if not all([email]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     # 校验邮箱格式
#     if not re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", email):
#         return jsonify(code=RET.PARAMERR, msg="邮箱格式错误")
#
#     # print(email)
#     app = creat_app('product')
#     mail = Mail(app)
#     sms_code = "%06d" % random.randint(0, 999999)
#
#     msg = Message("中研认知产业链在线,欢迎您！", recipients=[email])
#     msg.body = "【中研认知产业链在线】您的验证码为：{}，您正在进行邮箱绑定，如非本人操作，请忽略本邮件！".format(sms_code)
#     thread = threading.Thread(target=send_async_email, args=(mail, app, msg))
#     thread.start()
#     try:
#         redis_store.setex("ems_code_%s" % email, constants.SMS_CODE_REDIS_EXPIRES, sms_code)
#         # 保存发送给这个邮箱的记录，防止用户在180s内再次出发发送短信的操作
#         redis_store.setex("send_ems_code_%s" % email, constants.SEND_EMS_CODE_INTERVAL, 1)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="保存验证码异常")
#
#     return jsonify(code=RET.OK, msg="发送成功")
''''''


# 注册页面选择选择单位(2020-11-4)
@api_user.route('/orgs', methods=['GET'])
def zcorgs():
    '''
    太原市企业条件选择导航获取
    :return:
    '''
    try:
        gover = Government.query.all()
        ty = Government.query.get(1)
        sections = ty.sections
        data = [{"label": i.name, "value": i.id} for i in gover]
        section = [{"label": i.name, "value": i.id} for i in sections]
        orgs = {"data": data, "section": section}
        return jsonify(code=RET.OK, msg="获取成功", orgs=orgs)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 注册（2020-11-4）
@api_user.route("/register", methods=["POST"])
def register():
    """
    用户注册
    :return:
    """
    # 获取请求参数，转化字典
    req_dict = request.get_json()

    real_name = req_dict.get("real_name")  # 姓名
    age = req_dict.get("age")  # 年龄
    sex = req_dict.get("sex")  # 性别
    mobile = req_dict.get('mobile')  # 手机号
    sms_code = req_dict.get("sms_code")  # 验证码

    name = req_dict.get("name")  # 用户名
    password = req_dict.get("password")  # 密码
    password_again = req_dict.get("repassword")  # 密码2

    position = req_dict.get("position")  # 职务
    unit = req_dict.get("unit")  # 机构/单位
    section = req_dict.get("section")  # 所在部门（政府）

    # 校验参数完整性
    if not all([real_name, age, sex, mobile, sms_code, name, unit, position, password, password_again]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
        # real_sms_code = "123456"
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.NODATA, msg="短信验证码失效")

    # 判断短信验证码是否失效
    if not redis_store:
        return jsonify(code=RET.NODATA, msg="短信验证码失效")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        # if "123456" != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    # 用户名唯一(字母开头，长度4-15)
    try:
        patten = "^[a-zA-Z][\w]*[\w]*$"
        if re.match(patten, name) and re.match(patten, name).string == name:
            user = User.query.filter_by(name=name).first()
            if user:
                return jsonify(code=RET.DATAEXIST, msg="用户名已存在")
        else:
            return jsonify(code=RET.DATAERR, msg="用户名格式错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户名格式错误")

    # 校验密码
    if password != password_again:
        return jsonify(code=RET.DATAERR, msg="密码不一致")

    # 增加密码校验策略，20211109
    # 判断密码长度是否8位，数字、字母、特殊字符同时存在，能使用用户名、连续性字母、数字、特殊字符等易猜测口令。
    if len(password) < 8:
        return jsonify(code=RET.DATAERR, msg="密码长度最少为8位")
    # 密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'
    if not (re.search(r'\d+', password) and re.search(r'[a-z]+', password) and re.search(r'[A-Z]+',password) and re.search(r'[!@#$%^&*()_+=-]+', password)):
        return jsonify(code=RET.DATAERR, msg="密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'")
    # 密码不能使用用户名
    if password == name:
        return jsonify(code=RET.DATAERR, msg="密码存在风险，不能与用户名相同！")

    # 判断并添加用户信息
    try:
        ouser = User.query.filter_by(mobile=mobile).first()
        print(ouser)
        if ouser and ouser.flag == 1 and ouser.status != 1:  # 外部访客被禁止
            return jsonify(code=RET.DATAEXIST, msg="当前用户被禁止，请联系管理员")

        if ouser and ouser.flag == 2 and ouser.status == 2:  # 注册暂时未通过
            return jsonify(code=RET.DATAEXIST, msg="手机号已注册,请耐心等待审核")

        if ouser and ouser.flag == 2 and ouser.status == 1:  # 内部用户再次注册
            return jsonify(code=RET.DATAEXIST, msg="手机号已注册,请勿重复注册")

        if ouser and ouser.flag == 1 and ouser.status == 1:  # 外部访客注册
            ouser.real_name = real_name
            ouser.age = age
            ouser.sex = sex
            ouser.mobile = mobile
            ouser.unit = unit
            ouser.position = position
            ouser.name = name
            ouser.flag = 2
            ouser.status = 2
            if section:
                ouser.section = section
            ouser.password = password
            # return jsonify(code=RET.DATAEXIST, msg="手机号已存在,请勿重复注册")
        else:
            user = User(real_name=real_name, age=age, sex=sex, mobile=mobile, unit=unit, position=position, name=name,
                        flag=2, status=2)
            if section:
                user.section = section
            user.password = password
            db.session.add(user)
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")
    # except IntegrityError as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.DBERR, msg="手机号已被使用，请勿重复注册")

    return jsonify(code=RET.OK, msg="注册成功，请等待工作人员的审核，通常为3-7个工作日")


# 内部用户手机-密码登录 (2020-11-4)
@api_user.route("/login_bypwd", methods=["POST"])
def login_bypwd():
    '''
    用户密码登录
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    # 解密
    param = req_dict.get("param")  # 揭秘参数
    req_dict = json.loads(decrypt(param))
    mobile = req_dict.get('mobile')
    password = req_dict.get('password')
    # 校验参数完整性
    if not all([mobile, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号错误")

    # 判断错误次数是否超过限制，如果超过则10分钟内禁止此IP登录
    user_ip = request.remote_addr
    print("IP地址：", user_ip)


    # 获取ip的锁定时间
    try:
        access_nums = redis_store.get('access_nums_{}'.format(user_ip))
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                lock_time = redis_store.ttl('access_nums_{}'.format(user_ip))
                return jsonify(code=RET.LOCKTIME, msg="ip锁定倒计时中.....", lock_time = lock_time)
    except Exception as e:
        current_app.logger.error(e)
    else:
        pass


    try:
        access_nums = redis_store.get('access_nums_{}'.format(user_ip))
        # access_nums = "123456"
    except Exception as e:
        current_app.logger.error(e)
    else:
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                return jsonify(code=RET.REQERR, msg="错误次数过多，请15分钟后重试！",time=constants.LOGIN_ERROR_FORBID_TIME)

    # 验证手机号与密码
    try:
        user = User.query.filter_by(mobile=mobile, flag=2).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="获取用户信息失败")

    if not user:
        return jsonify(code=RET.DATAERR, msg="账户不存在")
    # 将用户名与密码验证放置在一处，若失败返回提示信息并记录次数
    if not user.check_password(password):
        try:
            redis_store.incr('access_nums_{}'.format(user_ip))
            redis_store.expire('access_nums_{}'.format(user_ip), constants.LOGIN_ERROR_FORBID_TIME)
        except Exception as e:
            current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="密码错误")

    if user.status == 2:  # 审核
        return jsonify(code=RET.ROLEERR, msg="审核暂未通过,请以外部访客身份登陆")

    if user.status == 3:  # 驳回
        return jsonify(code=RET.ROLEERR, msg="您的审核未通过，请联系工作人员")

    session.permanent = True  # 设置session在设定时间内有效  注意这个要设置在request里边 即请求内部
    # 若成功保存登录状态
    token = create_token(user.id)

    time = datetime.now()
    current_app.logger.error('++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用手机-密码登录成功了！+++++++++++++++++++++++=++'.format(time,mobile))

    return jsonify(code=RET.OK, msg="登录成功", token=token,flag=user.flag)


''''''


# 微信授权
@api_user.route("/login_byvx", methods=["POST"])
def login_byvx():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    code = req_dict.get('code')  # 微信登录code

    # 校验参数完整性
    if not all([code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    app_id = WxConfig.get_wx_app_id()
    app_secret = WxConfig.get_wx_app_secret()

    url = u'https://api.weixin.qq.com/sns/oauth2/access_token'
    params = {
        'appid': app_id,
        'secret': app_secret,
        'code': code,
        'grant_type': 'authorization_code'
    }
    res = requests.get(url, params=params).json()

    user_info_url = u'https://api.weixin.qq.com/sns/userinfo'
    params1 = {
        'access_token': res.get("access_token"),
        'openid': res.get("openid")
    }
    uinfo = requests.get(user_info_url, params=params1).json()
    # nickname = uinfo.get('nickname').encode('iso8859-1').decode('utf-8')
    try:
        openid = uinfo["openid"]
        unionid = uinfo["unionid"]
    except:
        return None

    try:
        user = User.query.filter_by(vxopenid=openid, vxunionid=unionid).first()
        if user:
            # 若成功保存登录状态
            token = create_token(user.id)
            return jsonify(code=RET.OK, msg="登录成功", token=token,flag=user.flag)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="appid,secreat异常")

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用微信登录成功了！+++++++++++++++++++++++=++'.format(time, user))

    return jsonify(code=RET.USERERR, msg="授权成功", user_info=uinfo)


# vx登陆后绑定手机号
@api_user.route("/binding", methods=["POST"])
def binding():
    '''
    绑定已有账号
    :return:
    '''
    req_dict = request.get_json()
    openid = req_dict.get("openid")  # vxopenid
    unionid = req_dict.get("unionid")  # vxunionid
    mobile = req_dict.get('mobile')  # 手机号
    sms_code = req_dict.get("sms_code")  # 验证码

    # 校验参数完整性
    if not all([openid, unionid, mobile, sms_code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 获取用户
    try:
        user = User.query.filter_by(mobile=mobile).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")
    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    try:
        if user:
            user.vxopenid = openid
            user.vxunionid = unionid
            db.session.commit()
            if user.status != 1:
                jsonify(code=RET.OK, msg="绑定成功，当前用户被禁止登录,请联系管理员")
        else:
            user = User(name=mobile, mobile=mobile, vxopenid=openid, vxunionid=unionid, flag=1, status=1)
            # user.password = password
            db.session.add(user)
            db.session.commit()
    except Exception as e:
        # 表示操作失败，回滚数据库操作
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")

    # 若成功保存登录状态
    token = create_token(user.id)
    return jsonify(code=RET.OK, msg="绑定成功，登录成功", token=token,flag=user.flag)


# 后台用户账号密码
@api_user.route("/backLogin", methods=["POST"])
def back_login():
    '''
    用户密码登录
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    # 解密
    param = req_dict.get("param")  # 揭秘参数
    req_dict = json.loads(decrypt(param))
    name = req_dict.get('name')
    password = req_dict.get('password')
    # 校验参数完整性
    if not all([name, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 判断错误次数是否超过限制，如果超过则10分钟内禁止此IP登录
    user_ip = request.remote_addr
    # print("IP地址：", user_ip)
    try:
        access_nums = redis_store.get('access_nums_{}'.format(user_ip))
    except Exception as e:
        current_app.logger.error(e)
    else:
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                return jsonify(code=RET.REQERR, msg="错误次数过多，请稍候重试")

    # 验证账户与密码
    try:
        user = Bstage.query.filter_by(name=name).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 将用户名与密码验证放置在一处，若失败返回提示信息并记录次数
    if (not user) or (not user.check_password(password)):
        # if (not user) or (password != "123"):
        try:
            redis_store.incr('access_nums_{}'.format(user_ip))
            redis_store.expire('access_nums_{}'.format(user_ip), constants.LOGIN_ERROR_FORBID_TIME)
        except Exception as e:
            current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="密码错误")

    # 若成功保存登录状态和管理员的角色id
    token = create_token(user.id)

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过后台登录成功了！+++++++++++++++++++++++=++'.format(time, name))

    return jsonify(code=RET.OK, msg="登录成功", token=token,flag=3)
