import time

import oss2
import xlrd
import xlwt
from flask import request, current_app, jsonify
from sqlalchemy import and_

from apps.models import *

from apps.util import verify_token, verify_identity

from apps.view_choose import api_address
from apps.utils.response_code import RET

"""数据填报页面"""


@api_address.route("/index", methods=["GET"])
def index():
    return 'hello world!'


def get_total_area_id(total_area):
    total_area_id = ''
    if 0 < float(total_area) <= 500:
        total_area_id = 1
    if 500 < float(total_area) <= 1000:
        total_area_id = 2
    if 1000 < float(total_area) <= 2000:
        total_area_id = 3
    if 2000 < float(total_area) <= 5000:
        total_area_id = 4
    if 5000 < float(total_area) <= 10000:
        total_area_id = 5
    return total_area_id


def get_cover_land_area_id(cover_land_area):
    cover_land_area_id = ''
    if 0 < float(cover_land_area) <= 500:
        cover_land_area_id = 1
    if 500 < float(cover_land_area) <= 1000:
        cover_land_area_id = 2
    if 1000 < float(cover_land_area) <= 2000:
        cover_land_area_id = 3
    if 2000 < float(cover_land_area) <= 5000:
        cover_land_area_id = 4
    if 5000 < float(cover_land_area) <= 10000:
        cover_land_area_id = 5
    return cover_land_area_id


def get_build_type_id(build_type):
    build_type_id = ''
    if build_type == '商铺':
        build_type_id = 1
    if build_type == '写字楼':
        build_type_id = 2
    return build_type_id


def get_land_nature_id(land_nature):
    land_nature_id = ''
    if land_nature == '农用地':
        land_nature_id = 1
    if land_nature == '商业用地':
        land_nature_id = 2
    if land_nature == '建设用地':
        land_nature_id = 3
    if land_nature == '旅游用地':
        land_nature_id = 4
    if land_nature == '居民用地':
        land_nature_id = 5
    return land_nature_id


def get_transfer_year_id(transfer_year):
    transfer_year_id = ''
    if 0 < int(transfer_year) <= 5:
        transfer_year_id = 1
    if 5 < int(transfer_year) <= 10:
        transfer_year_id = 2
    if 10 < int(transfer_year) <= 15:
        transfer_year_id = 3
    if 15 < int(transfer_year) <= 20:
        transfer_year_id = 4
    if 20 < int(transfer_year):
        transfer_year_id = 5
    return transfer_year_id


# 展示现有数据
@api_address.route("/ShowAll", methods=["POST"])
def show_all():
    req_dic = request.get_json()
    carrier_type = req_dic['carrier_type']
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '默认展示数据'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行访问 {} 操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        if not all([page, per_page]):
            return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
        if carrier_type == 1:
            carrier_size = CarrierBuild.query.count()
            # print(carrier_size)

            # carrier_obj = CarrierBuild.query.order_by(CarrierBuild.upload_time.desc())
            carrier_obj = ''
            # if role_id == 1:
            #     carrier_obj = CarrierBuild.query.filter_by(CarrierBuild.upload_people_id == user_id)
            # if role_id == 2:
            #     carrier_obj = CarrierBuild.query.filter_by(CarrierBuild.upload_people_belong == belong_unit)
            # if role_id == 3:
            #     carrier_obj = CarrierBuild.query.filter_by(CarrierBuild.audit_status == 1)
            carrier_obj = carrier_obj.order_by(CarrierBuild.upload_time.desc())
            carrier_obj_list = carrier_obj.paginate(page, per_page).items
            # print(carrier_obj_list)
            data = [{"id": carrier_obj.id,
                     "construction_time": carrier_obj.construction_time,
                     "district_name": carrier_obj.district_name,
                     "build_name": carrier_obj.build_name,
                     "detail_address": carrier_obj.detail_address,
                     "cover_land_area": carrier_obj.cover_land_area,
                     "layer_num": carrier_obj.layer_num,
                     "car_space_num": carrier_obj.car_space_num,
                     "lift_num": carrier_obj.lift_num,
                     "build_area": carrier_obj.build_area,
                     "empty_area": carrier_obj.empty_area,
                     "build_type": carrier_obj.build_type,
                     "build_structure": carrier_obj.build_structure,
                     "owner": carrier_obj.owner,
                     "linkman": carrier_obj.linkman,
                     "link_mobile": carrier_obj.link_mobile,
                     "attract_status": carrier_obj.attract_status,  # 拟招引状态
                     "rent_money": carrier_obj.rent_money,  # 租金
                     "cooperation_model": carrier_obj.cooperation_model,  # 合作模式
                     "audit": carrier_obj.audit_status} for carrier_obj in carrier_obj_list]
            # print(data)
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "楼宇数据获取成功！"})

        if carrier_type == 2:
            carrier_size = CarrierLand.query.count()
            # print(carrier_size)

            carrier_obj = CarrierLand.query.order_by(CarrierLand.upload_time.desc())
            carrier_obj_list = carrier_obj.paginate(page, per_page).items
            # print(carrier_obj_list)
            data = [{"id": carrier_obj.id,
                     "district_name": carrier_obj.district_name,
                     "land_name": carrier_obj.land_name,
                     "audit_status": carrier_obj.audit_status,
                     "land_status": carrier_obj.land_status,
                     "land_code": carrier_obj.land_code,
                     "land_nature": carrier_obj.land_nature,
                     "total_area": carrier_obj.total_area,
                     "transfer_year": carrier_obj.transfer_year,
                     "industry_type": carrier_obj.industry_type
                     } for carrier_obj in carrier_obj_list]
            # print(data)
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "土地数据获取成功！"})

        if carrier_type == 3:
            carrier_size = CarrierFactory.query.count()
            # print(carrier_size)

            carrier_obj = CarrierFactory.query.order_by(CarrierFactory.upload_time.desc())
            carrier_obj_list = carrier_obj.paginate(page, per_page).items
            # print(carrier_obj_list)
            data = [{"id": carrier_obj.id,
                     "district_name": carrier_obj.district_name,
                     "factory_name": carrier_obj.factory_name,
                     "is_standard": carrier_obj.is_standard,
                     "construction_time": carrier_obj.construction_time,
                     "owner": carrier_obj.owner,
                     "cover_land_area": carrier_obj.cover_land_area,
                     "factory_area": carrier_obj.factory_area,
                     "empty_area": carrier_obj.empty_area,
                     "bearing": carrier_obj.bearing,
                     "linkman": carrier_obj.linkman,
                     "link_mobile": carrier_obj.link_mobile,
                     "is_electric": carrier_obj.is_electric,
                     "is_water": carrier_obj.is_water,
                     "is_warm": carrier_obj.is_warm,
                     "is_gas": carrier_obj.is_gas,
                     "is_network": carrier_obj.is_network,
                     "lift_num": carrier_obj.lift_num,
                     "rent_money": carrier_obj.rent_money,
                     "audit_status": carrier_obj.audit_status,
                     "layer_num": carrier_obj.layer_num} for carrier_obj in carrier_obj_list]
            # print(data)
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "厂房数据获取成功！"})

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")


# 设置前端页面访问权限
# @api_address.route("/FontPermission", methods=["POST"])
# def font_permission():
#     try:
#         token = request.headers['token']
#         user = verify_token(token)
#         user_id = user.id
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")
#     if not all([user, user_id]):
#         return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
#
#     try:
#         user = User.query.get(user_id)
#         result = user.role_id
#         print(result)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     if int(result) == 1:
#         return jsonify(code=RET.OK, data={"role_id": result, "msg": " 我是局级领导（可以看到载体资源库所有页面,以及所有下级人员提交的内容）。"})
#     if int(result) == 2:
#         return jsonify(code=RET.OK, data={"role_id": result, "msg": " 我是部长（可以看到载体资源库的数据填报页面，以及该部门所有办事员提交的内容。）。"})
#     if int(result) == 3:
#         return jsonify(code=RET.OK, data={"role_id": result, "msg": " 我是办事员（可以看到载体资源库的数据填报页面，只能看到我自己提交的内容。）。"})
#     else:
#         return jsonify(code=RET.OK, data={"role_id": result, "msg": "无任何权限"})


# 下载模板
@api_address.route("/DownloadTemplate", methods=["POST"])
def download_xlsx():
    req_dic = request.get_json()
    token = request.headers['token']
    action_name = '下载模板'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    template_type = req_dic['template_type']
    if not template_type:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")

    if template_type == 1:  # 楼宇的模板标识
        build_template = "http://39.100.39.50:8009/aaa_statics/carrier_template/可利用楼宇情况统计表.xlsx"
        operation_message = "进行了下载楼宇数据模板操作"
        upload_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=upload_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()
        return build_template

    if template_type == 2:  # 土地的模板标识
        land_template = "http://39.100.39.50:8009/aaa_statics/carrier_template/可利用土地情况统计表.xlsx"
        operation_message = "进行了下载土地数据模板操作"
        upload_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=upload_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()
        return land_template

    if template_type == 3:  # 厂房的模板标识
        # factory_template = "http://39.100.39.50:8009/aaa_statics/carrier_template/carrier_factory.xlsx"
        factory_template = "http://39.100.39.50:8009/aaa_statics/carrier_template/可利用厂房情况统计表.xlsx"
        operation_message = "进行了下载厂房数据模板操作"
        upload_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=upload_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()
        return factory_template


def is_number(s):
    try:
        if s == '':
            return True
        if float(s):
            return True

    except ValueError:
        pass

    try:
        import unicodedata
        if s == '':
            return True
        if unicodedata.numeric(s):
            return True

    except (TypeError, ValueError):
        pass

    return False


def delete_extra_zero(n):
    '''删除小数点后多余的0'''
    if isinstance(n, int):
        return n
    if isinstance(n, float):
        n = str(n).rstrip('0')  # 删除小数点后多余的0
        n = int(n.rstrip('.')) if n.endswith('.') else float(n)  # 只剩小数点直接转int，否则转回float
        return n


# 导入数据时根据详细地址获取经纬度
def get_jwd(address):
    import requests
    import json
    try:
        url = "http://api.map.baidu.com/geocoding/v3/?address={}&output=json&ak=Dhycqs8ud5" \
              "L6jbhPxTVtQnEFC0agQlgK&callback=showLocation".format(address)
        time.sleep(0.5)
        res = requests.get(url).text
        res = res[27:-1]
        last = json.loads(res)
        lng = last["result"]["location"]["lng"]
        lat = last["result"]["location"]["lat"]
        msg = '经纬度获取成功！'
        code = 0
        print(lng, lat)
        return lng, lat, code, msg
    except Exception as e:
        current_app.logger.error(e)
        lng = ''
        lat = ''
        msg = '地址不够详细，经纬度自动获取失败，请完善后再试！'
        code = 1
        return lng, lat, code, msg


# def get_district(district_name):
#     district_name1 = ''
#     if '小店' in district_name:
#         district_name1 = '小店区'
#     elif '迎泽' in district_name:
#         district_name1 = '迎泽区'
#     elif '杏花岭' in district_name:
#         district_name1 = '杏花岭区'
#     elif '尖草坪' in district_name:
#         district_name1 = '尖草坪区'
#     elif '万柏林' in district_name:
#         district_name1 = '万柏林区'
#     elif '晋源' in district_name:
#         district_name1 = '晋源区'
#     elif '古交' in district_name:
#         district_name1 = '古交市'
#
#     elif '娄烦' in district_name:
#         district_name1 = '娄烦县'
#     elif '中北高新' in district_name:
#         district_name1 = '中北高新区'
#     elif '清徐开发' in district_name:
#         district_name1 = '清徐开发区'
#     elif '清徐' in district_name:
#         district_name1 = '清徐县'
#     elif '阳曲示范' in district_name:
#         district_name1 = '阳曲示范区'
#     elif '阳曲' in district_name:
#         district_name1 = '阳曲县'
#     elif '西山示范' in district_name:
#         district_name1 = '西山示范区'
#     return district_name1


# 三载体批量导入（读取模板数据，保存到数据库）
@api_address.route("/UploadCarrierData", methods=["POST"])
def read_template():
    # 获取上传的文件
    # token = request.form['token']
    token = request.headers['token']
    action_name = '批量导入'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    # 载体类型
    carrier_type = request.form['carrier_type']
    # 上传的文件
    file = request.files['file']
    print(file.filename)  # 打印文件名
    if '可利用' not in file.filename or '统计表' not in file.filename:
        return jsonify(code=RET.DBERR, msg="导入失败！请检查模板格式以及文件名！")
    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字


        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    rep_num = 0
    rep_build_name_list = []
    success_num = 0
    # # 刚上传的数据审核状态为未审核   0为未审核；1为审核通过；3为驳回；4不通过
    # if role_id == 3:  # 办事员上传的数据默认状态为0
    #     audit_status = "0"
    # if role_id in [1, 2]:  # 局领导和部门负责人上传的数据默认状态为1
    #     audit_status = "1"
    audit_status = ''

    # 记录上传时间和上传人，记录"导入"的动作用于备注的是和否
    upload_time = datetime.now()
    action = '导入'
    name = ''

    row_list = [table.row_values(i) for i in range(1, nrows)]
    for i in range(0, len(row_list)):
        if carrier_type == '1':
            row_content = row_list[i]
            # 载体名称
            carrier_name = row_content[0]
            # 区域名称
            district_name = row_content[1]
            if not any([district_name, carrier_name]):
                return jsonify(code=RET.DATAERR, msg='上传失败！所属区域或者楼宇名称不能为空。')
            # district_name = get_district(district_name)

            # 判断该楼宇是否已经存在
            build_obj = CarrierBuild.query.filter_by(build_name=carrier_name).first()
            if build_obj:
                rep_num += 1
                rep_build_name_list.append(carrier_name)
                continue
            build_type = row_content[2]

            # 详细地址 是必填项，用来获取经纬度
            detail_address = row_content[3]
            if not detail_address:
                return jsonify(code=RET.DATAERR, msg='上传失败！详细地址不能为空，要尽量详细，用来获取经纬度')
            # 根据详细地址获取经纬度
            lng, lat, code, msg = get_jwd(detail_address)
            if code == 1:
                return jsonify(code=RET.DATAERR, msg=carrier_name + msg)

            construction_time = row_content[4]
            cover_land_area = row_content[5]
            build_area = row_content[6]
            empty_area = row_content[7]
            if not all([is_number(build_area) and is_number(
                    empty_area) and is_number(cover_land_area)]):
                return jsonify(code=RET.DATAERR, msg='上传失败！面积相关字段格式不正确，请填写数字')
            layer_num = row_content[8]
            car_space_num = row_content[9]
            lift_num = row_content[10]
            if not is_number(layer_num) and not is_number(car_space_num) and not is_number(lift_num):
                return jsonify(code=RET.DATAERR, msg='上传失败！"楼层数" 或者 "电梯数" 或者 "车位数" 格式不正确，请填写整数或置空')
            attract_status = row_content[11]
            cooperation_model = row_content[12]
            rent_money = row_content[13]
            wuye_money = row_content[14]
            # 联系人
            linkman = row_content[15]
            link_mobile = row_content[16]
            if not is_number(link_mobile):
                return jsonify(code=RET.DATAERR, msg='上传失败！电话号码格式不正确，请填写数字')
            # if link_mobile:
            #     link_mobile = str(delete_extra_zero(eval(str(link_mobile))))
            #     if not re.match(r"1[23456789]\d{9}$", link_mobile):
            #         return jsonify(code=RET.PARAMERR, msg="上传失败！电话号码格式不正确，请修改！")
            attract_advantage = row_content[17]
            policy = row_content[18]
        # 导入土地数据
        if carrier_type == '2':
            row_content = row_list[i]
            # 载体名称
            carrier_name = row_content[0]
            # 判断该土地是否已经存在
            land_obj = CarrierLand.query.filter_by(land_name=carrier_name).first()
            if land_obj:
                rep_num += 1
                rep_build_name_list.append(carrier_name)
                continue
            land_code = row_content[1]
            # 区域名称
            district_name = row_content[2]
            if not any([district_name, carrier_name]):
                return jsonify(code=RET.DATAERR, msg='上传失败！所属区域或者土地名称不能为空。')
            # district_name = get_district(district_name)

            land_nature = row_content[3]
            total_area = row_content[4]
            if not is_number(total_area):
                return jsonify(code=RET.DATAERR, msg='上传失败！面积相关字段格式不正确，请填写数字')

            # 详细地址 是必填项，用来获取经纬度
            detail_address = row_content[5]
            if not detail_address:
                return jsonify(code=RET.DATAERR, msg='上传失败！详细地址不能为空，要尽量详细，用来获取经纬度')
            # 根据详细地址获取经纬度
            lng, lat, code, msg = get_jwd(detail_address)
            if code == 1:
                return jsonify(code=RET.DATAERR, msg=carrier_name + msg)

        # 导入厂房数据
        if carrier_type == '3':
            row_content = row_list[i]
            # 载体名称
            carrier_name = row_content[0]
            # 区域名称
            district_name = row_content[1]
            if not any([district_name, carrier_name]):
                return jsonify(code=RET.DATAERR, msg='上传失败！所属区域或者厂房名称不能为空。')
            # district_name = get_district(district_name)

            # 判断该厂房是否已经存在
            factory_obj = CarrierFactory.query.filter_by(factory_name=carrier_name).first()
            if factory_obj:
                rep_num += 1
                rep_build_name_list.append(carrier_name)
                continue
            is_standard = row_content[2]
            # 详细地址 是必填项，用来获取经纬度
            detail_address = row_content[3]
            if not detail_address:
                return jsonify(code=RET.DATAERR, msg='上传失败！详细地址不能为空，要尽量详细，用来获取经纬度')
            # 根据详细地址获取经纬度
            lng, lat, code, msg = get_jwd(detail_address)
            if code == 1:
                return jsonify(code=RET.DATAERR, msg=carrier_name + msg)
            construction_time = row_content[4]
            cover_land_area = row_content[5]
            factory_area = row_content[6]
            empty_area = row_content[7]
            layer_num = row_content[8]
            factory_structure = row_content[9]
            width = row_content[10]
            high = row_content[11]
            bearing = row_content[12]
            is_water = row_content[13]
            is_electric = row_content[14]
            is_warm = row_content[15]
            is_gas = row_content[16]
            is_network = row_content[17]
            # 判断电气热暖是否按备注填写0或1
            # if is_electric not in ['', 0.0, 1.0, '1', '0'] or is_water not in ['', 0.0, 1.0, '1',
            #                                                                    '0'] or is_warm not in ['', 0.0, 1.0,
            #                                                                                            '1', '0'] \
            #         or is_gas not in ['', 0.0, 1.0, '1', '0'] or is_network not in ['', 0.0, 1.0, '1', '0']:
            #     return jsonify(code=RET.DATAERR, msg='上传失败！电气热暖相关字段格式不正确，请按备注填写0或1或置空！')
            # 判断电气热暖是否按备注填写0或1
            if is_electric not in ['', '是', '否'] or \
                    is_water not in ['', '是', '否'] or \
                    is_warm not in ['', '是', '否'] or \
                    is_gas not in ['', '是', '否'] or \
                    is_network not in ['', '是', '否']:
                return jsonify(code=RET.DATAERR, msg='上传失败！电气热暖相关字段格式不正确，请按备注填写是或否或置空！')

            lift_num = row_content[18]
            if lift_num and not is_number(lift_num):
                return jsonify(code=RET.DATAERR, msg='上传失败！电梯数格式不正确，请填写数字，没有的话置空！')
            attract_status = row_content[19]
            cooperation_model = row_content[20]
            rent_money = row_content[21]
            linkman = row_content[22]
            link_mobile = row_content[23]
            if not is_number(link_mobile):
                return jsonify(code=RET.DATAERR, msg='上传失败！电话号码格式不正确，请填写数字')
            # if link_mobile:
            #     link_mobile = str(delete_extra_zero(eval(str(link_mobile))))
            #     if not re.match(r"1[23456789]\d{9}$", link_mobile):
            #         return jsonify(code=RET.PARAMERR, msg="上传失败！电话号码格式不正确，请修改！")
            attract_advantage = row_content[24]
            policy = row_content[25]

        try:
            # 写入数据库
            if carrier_type == '1':
                name = '楼宇'
                carrier_obj = CarrierBuild(district_name=district_name, build_name=carrier_name,
                                           build_type=build_type,
                                           detail_address=detail_address, construction_time=construction_time,
                                           cover_land_area=cover_land_area, build_area=build_area,
                                           empty_area=empty_area,
                                           layer_num=layer_num, car_space_num=car_space_num, lift_num=lift_num,
                                           attract_status=attract_status, cooperation_model=cooperation_model,
                                           rent_money=rent_money, wuye_money=wuye_money, linkman=linkman,
                                           link_mobile=link_mobile, attract_advantage=attract_advantage, policy=policy,
                                           audit_status=audit_status, upload_time=upload_time,
                                           upload_people=user_name, upload_people_belong=belong_unit,
                                           upload_people_id=user_id, upload_people_role_id='', lng=lng, lat=lat,
                                           )
                db.session.add(carrier_obj)
                db.session.commit()
                success_num += 1
                continue
            if carrier_type == '2':
                name = '土地'
                carrier_obj = CarrierLand(land_name=carrier_name, land_code=land_code,
                                          district_name=district_name, land_nature=land_nature,
                                          total_area=total_area, detail_address=detail_address,
                                          audit_status=audit_status, upload_time=upload_time,
                                          upload_people=user_name, upload_people_belong=belong_unit,
                                          upload_people_id=user_id, upload_people_role_id='',
                                          lng=lng, lat=lat
                                          )
                db.session.add(carrier_obj)
                db.session.commit()
                success_num += 1
                continue
            if carrier_type == '3':
                name = '厂房'
                carrier_obj = CarrierFactory(district_name=district_name, factory_name=carrier_name,
                                             is_standard=is_standard, detail_address=detail_address,
                                             construction_time=construction_time, cover_land_area=cover_land_area,
                                             factory_area=factory_area, empty_area=empty_area, layer_num=layer_num,
                                             factory_structure=factory_structure, width=width, high=high,
                                             bearing=bearing, is_water=is_water, is_electric=is_electric,
                                             is_warm=is_warm, is_gas=is_gas, is_network=is_network, lift_num=lift_num,
                                             attract_status=attract_status, cooperation_model=cooperation_model,
                                             rent_money=rent_money, linkman=linkman, link_mobile=link_mobile,
                                             attract_advantage=attract_advantage, policy=policy,
                                             audit_status=audit_status, upload_time=upload_time,
                                             upload_people=user_name, upload_people_belong=belong_unit,
                                             upload_people_id=user_id, upload_people_role_id='',
                                             lng=lng, lat=lat
                                             )
                db.session.add(carrier_obj)
                db.session.commit()
                success_num += 1
                continue
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")

    # 更新es的楼宇数据
    # result = ''
    # if carrier_type == '1':
    #     result = insert_into_build_data()
    # if carrier_type == '2':
    #     result = insert_into_land_data()
    # if carrier_type == '3':
    #     result = insert_into_factory_data()
    # if result['_shards']['successful'] <= 0:
    #     current_app.logger.error(str(upload_time) + '上传数据时，es更新失败，请排查原因！')
    #     print(str(upload_time) + '上传数据时，es更新失败，请排查原因！')
    # 记录日志

    operation_message = "上传了 {} 条 {} 数据".format(success_num, name)
    upload_time = datetime.now()
    if str(upload_time) < upload_time.strftime('%Y-%m-25 00:00:00'):
        remark = '是'
    else:
        remark = '否'

    log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=upload_time,
                       operation_people=user_name, section=section, remark=remark,
                       operation_message=operation_message, operation_mobile=operation_mobile, action=action)
    db.session.add(log)
    db.session.commit()
    if rep_num > 0 and success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！{}数据上传 {} 条数据，重复数据 {} 条，上传失败的重复数据为 {}，请核实！'.format(name, success_num, rep_num,
                                                                                    rep_build_name_list))
    if rep_num == 0 and success_num > 0:
        return jsonify(code=RET.OK,
                       msg='上传成功！{}数据上传 {} 条数据，无重复数据。'.format(name, success_num))
    if rep_num > 0 and success_num == 0:
        return jsonify(code=RET.DATAERR,
                       msg='操作失败！{}数据上传 {} 条数据，重复数据{} 条。'.format(name, success_num, rep_num))
    if rep_num == 0 and success_num == 0:
        return jsonify(code=RET.DATAERR, msg='无数据上传。')
    else:
        pass


# 批量导出楼宇数据
@api_address.route("/BatchExport", methods=["POST"])
def batch_export_build():
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '批量导出楼宇'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    select_id_list = req_dic["select_id_list"]
    path = './apps/static/carrier_file/'
    pro_path = 'http://39.100.39.50:5050/static/carrier_file/'  # 项目路径
    try:
        if not select_id_list:
            return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
        target_data_list = []
        for select_id in select_id_list:
            carrier_obj = CarrierBuild.query.filter_by(id=select_id).first()
            # 提取数据，写入xslx表格
            data_list = []
            carrier_name = carrier_obj.build_name
            data_list.append(carrier_name)
            district_name = carrier_obj.district_name
            data_list.append(district_name)
            build_type = carrier_obj.build_type
            data_list.append(build_type)
            detail_address = carrier_obj.detail_address
            data_list.append(detail_address)
            construction_time = carrier_obj.construction_time
            data_list.append(construction_time)
            cover_land_area = carrier_obj.cover_land_area
            data_list.append(cover_land_area)
            build_area = carrier_obj.build_area
            data_list.append(build_area)
            empty_area = carrier_obj.empty_area
            data_list.append(empty_area)
            layer_num = carrier_obj.layer_num
            data_list.append(layer_num)
            car_space_num = carrier_obj.car_space_num
            data_list.append(car_space_num)
            lift_num = carrier_obj.lift_num
            data_list.append(lift_num)
            attract_status = carrier_obj.attract_status
            data_list.append(attract_status)
            cooperation_model = carrier_obj.cooperation_model
            data_list.append(cooperation_model)
            rent_money = carrier_obj.rent_money
            data_list.append(rent_money)
            wuye_money = carrier_obj.wuye_money
            data_list.append(wuye_money)
            linkman = carrier_obj.linkman
            data_list.append(linkman)
            link_mobile = carrier_obj.link_mobile
            data_list.append(link_mobile)
            attract_advantage = carrier_obj.attract_advantage
            data_list.append(attract_advantage)
            policy = carrier_obj.policy
            data_list.append(policy)
            target_data_list.append(data_list)

        head_list = ''
        sheet = ''
        try:
            sheet_name_titles = {
                "sheet1": ["楼宇名称", "所属县区", "楼宇类型(商铺/写字楼/其他)", "详细地址", "建成时间",
                           "总占地面积（㎡）", "总建筑面积（㎡）", "闲置面积（㎡）", "总层数",
                           "车位（个）", "电梯（部）", "拟招引业态", "合作模式(出租/出售/转让)",
                           "租金范围（元/平米/天）", "物业费（元/平米/月）", "联系人", "联系方式", "招商优势",
                           "优惠政策"]}
            excel = xlwt.Workbook(encoding='utf-8')
            # 写入表头
            for i in range(len(sheet_name_titles)):
                for k, v in sheet_name_titles.items():
                    sheet_name = k
                    sheet = excel.add_sheet(sheet_name)
                    head_list = v
                    print(head_list)
                    for j in range(len(head_list)):
                        sheet.write(0, j, head_list[j])
            # 写入数据，从第二行(i+1)
            rows = len(target_data_list)
            cols = len(head_list)
            for i in range(rows):
                for j in range(cols):
                    sheet.write(i + 1, j, target_data_list[i][j])
            time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
            file_name = "可利用楼宇情况统计表{}.xlsx".format(time_stamp)
            excel.save(path + file_name)

            # 记录日志
            data_num = len(select_id_list)
            operation_message = "导出了 {} 条 楼宇 数据".format(data_num)
            export_time = datetime.now()
            try:
                log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                                   operation_time=export_time, operation_people=user_name,
                                   operation_message=operation_message, operation_mobile=operation_mobile,
                                   section=section)
                db.session.add(log)
                db.session.commit()

                return jsonify(code=RET.OK, url=pro_path + file_name, msg="批量导出成功！")
            except Exception as e:
                db.session.rollback()
                current_app.logger.error(str(e) + '批量导出操作日志入库出错！')
                return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
        except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")


# 批量导出土地数据
@api_address.route("/BatchExportLand", methods=["POST"])
def batch_export_land():
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '批量导出土地'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    select_id_list = req_dic["select_id_list"]
    path = './apps/static/carrier_file/'
    pro_path = 'http://39.100.39.50:5050/static/carrier_file/'  # 项目路径

    try:
        if not select_id_list:
            return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
        target_data_list = []
        for select_id in select_id_list:
            carrier_obj = CarrierLand.query.filter_by(id=select_id).first()
            data_list = []
            carrier_name = carrier_obj.land_name
            data_list.append(carrier_name)
            land_code = carrier_obj.land_code
            data_list.append(land_code)
            district_name = carrier_obj.district_name
            data_list.append(district_name)
            land_nature = carrier_obj.land_nature
            data_list.append(land_nature)
            total_area = carrier_obj.total_area
            data_list.append(total_area)
            detail_address = carrier_obj.detail_address
            data_list.append(detail_address)
            target_data_list.append(data_list)
        head_list = ''
        sheet = ''
        try:
            sheet_name_titles = {
                "sheet1": ["土地名称", "土地编码", "所属县区",
                           "用地性质(农业用地/工业用地/商业用地/建设用地/旅游用地/居民用地)",
                           "总用地面积（公顷）", "详细地址"]}
            excel = xlwt.Workbook(encoding='utf-8')
            # 写入表头
            for i in range(len(sheet_name_titles)):
                for k, v in sheet_name_titles.items():
                    sheet_name = k
                    sheet = excel.add_sheet(sheet_name)
                    head_list = v
                    print(head_list)
                    for j in range(len(head_list)):
                        sheet.write(0, j, head_list[j])
            # 写入数据，从第二行(i+1)
            rows = len(target_data_list)
            cols = len(head_list)
            for i in range(rows):
                for j in range(cols):
                    sheet.write(i + 1, j, target_data_list[i][j])
            time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
            file_name = "可利用土地情况统计表{}.xlsx".format(time_stamp)
            excel.save(path + file_name)

            # 记录日志
            data_num = len(select_id_list)
            operation_message = "导出了 {} 条 土地 数据".format(data_num)
            export_time = datetime.now()
            try:
                log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                                   operation_time=export_time, operation_people=user_name,
                                   operation_message=operation_message, operation_mobile=operation_mobile,
                                   section=section)
                db.session.add(log)
                db.session.commit()

                return jsonify(code=RET.OK, url=pro_path + file_name, msg="批量导出成功！")
            except Exception as e:
                db.session.rollback()
                current_app.logger.error(str(e) + '批量导出操作日志入库出错！')
                return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
        except Exception as e:
            # db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")


# 批量导出厂房数据
@api_address.route("/BatchExportFactory", methods=["POST"])
def batch_export_factory():
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '批量导出厂房'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    select_id_list = req_dic["select_id_list"]
    path = './apps/static/carrier_file/'
    # pro_path = 'http://192.168.31.154:5000/static/'  # 项目路径
    pro_path = 'http://39.100.39.50:5050/static/carrier_file/'  # 项目路径
    try:
        if not select_id_list:
            return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
        target_data_list = []
        for select_id in select_id_list:
            carrier_obj = CarrierFactory.query.filter_by(id=select_id).first()

            # 提取数据，写入xslx表格
            data_list = []
            carrier_name = carrier_obj.factory_name
            data_list.append(carrier_name)
            district_name = carrier_obj.district_name
            data_list.append(district_name)
            is_standard = carrier_obj.is_standard
            data_list.append(is_standard)
            detail_address = carrier_obj.detail_address
            data_list.append(detail_address)
            construction_time = carrier_obj.construction_time
            data_list.append(construction_time)
            cover_land_area = carrier_obj.cover_land_area
            data_list.append(cover_land_area)
            factory_area = carrier_obj.factory_area
            data_list.append(factory_area)
            empty_area = carrier_obj.empty_area
            data_list.append(empty_area)
            layer_num = carrier_obj.layer_num
            data_list.append(layer_num)
            factory_structure = carrier_obj.factory_structure
            data_list.append(factory_structure)
            width = carrier_obj.width
            data_list.append(width)
            high = carrier_obj.high
            data_list.append(high)
            bearing = carrier_obj.bearing
            data_list.append(bearing)
            is_water = carrier_obj.is_water
            data_list.append(is_water)
            is_electric = carrier_obj.is_electric
            data_list.append(is_electric)
            is_warm = carrier_obj.is_warm
            data_list.append(is_warm)

            is_gas = carrier_obj.is_gas
            data_list.append(is_gas)
            is_network = carrier_obj.is_network
            data_list.append(is_network)
            lift_num = carrier_obj.lift_num
            data_list.append(lift_num)
            attract_status = carrier_obj.attract_status
            data_list.append(attract_status)
            cooperation_model = carrier_obj.cooperation_model
            data_list.append(cooperation_model)
            rent_money = carrier_obj.rent_money
            data_list.append(rent_money)
            linkman = carrier_obj.linkman
            data_list.append(linkman)
            link_mobile = carrier_obj.link_mobile
            data_list.append(link_mobile)
            attract_advantage = carrier_obj.attract_advantage
            data_list.append(attract_advantage)
            policy = carrier_obj.policy
            data_list.append(policy)
            target_data_list.append(data_list)
        head_list = ''
        sheet = ''
        try:
            sheet_name_titles = {
                "sheet1": ["厂房名称", "所属县区", "是否标准化厂房(是/否)", "详细地址", "建成时间",
                           "总占地面积（㎡）", "总建筑面积（㎡）", "闲置面积（㎡）", "总层数", "建筑结构",
                           "跨度（m）", "层高（m）", "承重（500kg/㎡）", "是否已通水(是/否)",
                           "是否已通电(是/否)", "是否已通暖(是/否)", "是否已通燃气(是/否)",
                           "是否已通网络(是/否)", "电梯/部", "拟招引业态", "合作模式(出租/出售/转让)",
                           "租金范围（元/平米/天）", "联系人", "联系方式", "招商优势", "优惠政策"]}
            excel = xlwt.Workbook(encoding='utf-8')
            # 写入表头
            for i in range(len(sheet_name_titles)):
                for k, v in sheet_name_titles.items():
                    sheet_name = k
                    sheet = excel.add_sheet(sheet_name)
                    head_list = v
                    print(head_list)
                    for j in range(len(head_list)):
                        sheet.write(0, j, head_list[j])
            # 写入数据，从第二行(i+1)
            rows = len(target_data_list)
            cols = len(head_list)
            for i in range(rows):
                for j in range(cols):
                    sheet.write(i + 1, j, target_data_list[i][j])
            time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
            file_name = "可利用厂房情况统计表{}.xlsx".format(time_stamp)
            excel.save(path + file_name)

            # 记录日志
            data_num = len(select_id_list)
            operation_message = "导出了 {} 条 厂房 数据".format(data_num)
            export_time = datetime.now()
            try:
                log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                                   operation_time=export_time, operation_people=user_name,
                                   operation_message=operation_message, operation_mobile=operation_mobile,
                                   section=section)
                db.session.add(log)
                db.session.commit()

                return jsonify(code=RET.OK, url=pro_path + file_name, msg="批量导出成功！")
            except Exception as e:
                db.session.rollback()
                current_app.logger.error(str(e) + '批量导出操作日志入库出错！')
                return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="批量导出操作失败！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误！")


# 三载体删除和批量删除
@api_address.route("/BatchDelete", methods=["POST"])
def batch_delete():
    req_dic = request.get_json()
    carrier_type = req_dic['carrier_type']
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '删除'
    delete_num = 0
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    delete_id_list = req_dic["delete_id_list"]
    if not delete_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")

    try:
        if not delete_id_list:
            return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
        carrier_obj_list = ''
        name = ''
        if carrier_type == 1:
            name = '楼宇'
            carrier_obj_list = CarrierBuild.query.filter(CarrierBuild.id.in_(delete_id_list)).all()
        if carrier_type == 2:
            name = '土地'
            carrier_obj_list = CarrierLand.query.filter(CarrierLand.id.in_(delete_id_list)).all()
        if carrier_type == 3:
            name = '厂房'
            carrier_obj_list = CarrierFactory.query.filter(CarrierFactory.id.in_(delete_id_list)).all()

        if not carrier_obj_list:
            return jsonify(code=RET.DBERR, msg="数据不存在！")
        for carrier_obj in carrier_obj_list:
            db.session.delete(carrier_obj)
            db.session.commit()
            delete_num += 1
        # 更新es
        # result = ''
        # if carrier_type == 1:
        #     result = delete_build_data(delete_id_list)
        # if carrier_type == 2:
        #     result = delete_land_data(delete_id_list)
        # if carrier_type == 3:
        #     result = delete_factory_data(delete_id_list)
        # if not result['_shards']['successful'] and int(result['_shards']['successful']) <= 0:
        #     db.session.rollback()
        #     return jsonify(code=RET.THIRDERR, msg="批量删除操作后es更新错误，请核实！")

        # 记录日志
        operation_message = "删除了 {} 条 {} 数据".format(delete_num, name)
        delete_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                           operation_time=delete_time, operation_people=user_name,
                           operation_message=operation_message, operation_mobile=operation_mobile,
                           section=section)
        db.session.add(log)
        db.session.commit()

        return jsonify(code=RET.OK, msg="成功批量删除{}条！".format(delete_num))

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量删除操作失败！")


# 三载体审核和批量审核
@api_address.route("/BatchAudit", methods=["POST"])
def batch_audit():
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    carrier_type = req_dic['carrier_type']
    audit_flag = req_dic["audit_flag"]  # 审核状态 0为未审核；1为审核通过；2为提交；3为驳回；4不通过
    audit_id_list = req_dic["audit_id_list"]
    audit_message = req_dic["audit_message"]
    action_name = '审核'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    # if role_id == 3:  # 办事员没有审核功能
    #     return jsonify(code=RET.THIRDERR, msg="办事员没有审核功能。")
    # if role_id == 2 and audit_flag == 3:  # 市直部门各区县领导没有驳回权限
    #     return jsonify(code=RET.THIRDERR, msg="市直部门各区县负责人没有驳回权限。")
    # if role_id == 1 and audit_flag in [1, 2, 4]:  # 局领导只能驳回
    #     return jsonify(code=RET.THIRDERR, msg="市直部门各区县领导局领导只有驳回权限。")

    audit_name = ''

    if not all([audit_flag, audit_id_list]):
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    try:
        carrier_obj_list = ''
        name = ''
        if carrier_type == 1:
            name = '楼宇'
            carrier_obj_list = CarrierBuild.query.filter(CarrierBuild.id.in_(audit_id_list)).all()
        if carrier_type == 2:
            name = '土地'
            carrier_obj_list = CarrierLand.query.filter(CarrierLand.id.in_(audit_id_list)).all()
        if carrier_type == 3:
            name = '厂房'
            carrier_obj_list = CarrierFactory.query.filter(CarrierFactory.id.in_(audit_id_list)).all()

        if not carrier_obj_list:
            return jsonify(code=RET.DBERR, msg="数据不存在！")
        for carrier_obj in carrier_obj_list:
            carrier_obj.audit_status = audit_flag
            carrier_obj.audit_message = audit_message
            db.session.commit()

        # 更新es
        # result = ''
        # if carrier_type == 1:
        #     result = fix_build_data(audit_id_list, '', '', '', '', '', '',
        #                             '', '', '', '', '', '', '', '',
        #                             '', '', '', '', '', '', '', '',
        #                             '', '', audit_message, audit_flag)
        # if carrier_type == 2:
        #     result = fix_land_data(audit_id_list, '', '', '', '', '', '',
        #                            '', '', '', '', '',
        #                            '', '', '', '', audit_message, audit_flag)
        # if carrier_type == 3:
        #     result = fix_factory_data(audit_id_list, '', '', '', '', '',
        #                               '', '', '', '',
        #                               '', '', '', '', '', '',
        #                               '', '', '', '', '', '', '', '',
        #                               '', '', '', '', audit_message, audit_flag)
        # if result['_shards']['successful'] and int(result['_shards']['successful']) <= 0:
        #     db.session.rollback()
        #     return jsonify(code=RET.THIRDERR, msg="批量审核后es更新失败，请核实！")

        # 记录日志
        if audit_flag == 1:
            audit_name = '通过'
        if audit_flag == 2:
            audit_name = '提交'
        if audit_flag == 3:
            audit_name = '驳回'
        if audit_flag == 4:
            audit_name = '不通过'
        audit_num = len(audit_id_list)
        operation_message = "审核 {} 了 {} 条 {} 数据".format(audit_name, audit_num, name)
        audit_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=audit_time,
                           operation_people=user_name,
                           operation_message=operation_message, operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()

        return jsonify(code=RET.OK, msg="审核成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！")


# 三载体类型查看页，和编辑页的数据展示接口
@api_address.route("/CheckDetail", methods=["POST"])
def carrier_detail():
    req_dic = request.get_json()
    carrier_type = req_dic['carrier_type']

    carrier_id = req_dic['id']
    if not carrier_id:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    try:
        if carrier_type == 1:
            carrier_obj_list = CarrierBuild.query.filter_by(id=carrier_id)
            data = [{"id": carrier_obj.id,
                     "construction_time": carrier_obj.construction_time,
                     "district_name": carrier_obj.district_name,
                     "build_name": carrier_obj.build_name,
                     "detail_address": carrier_obj.detail_address,
                     "cover_land_area": carrier_obj.cover_land_area,
                     "layer_num": carrier_obj.layer_num,
                     "car_space_num": carrier_obj.car_space_num,
                     "lift_num": carrier_obj.lift_num,
                     "build_area": carrier_obj.build_area,
                     "empty_area": carrier_obj.empty_area,
                     "build_type": carrier_obj.build_type,
                     # "build_structure": carrier_obj.build_structure,
                     # "owner": carrier_obj.owner,
                     "linkman": carrier_obj.linkman,
                     "link_mobile": carrier_obj.link_mobile,
                     "attract_status": carrier_obj.attract_status,  # 拟招引状态
                     "rent_money": carrier_obj.rent_money,  # 租金
                     "cooperation_model": carrier_obj.cooperation_model,  # 合作模式
                     # "details": carrier_obj.build_info,  # 楼宇介绍
                     "wuye_money": carrier_obj.wuye_money,  # 物业费
                     "attract_advantage": carrier_obj.attract_advantage,  # 招商优势
                     "policy": carrier_obj.policy,  # 优惠政策
                     "inside_picture_url": [
                         {"url": carrier_obj.inside_picture_url}] if carrier_obj.inside_picture_url else [],
                     "outer_picture_url": [
                         {"url": carrier_obj.outer_picture_url}] if carrier_obj.outer_picture_url else [],
                     # 平面图url
                     "price_url": [
                         {"url": carrier_obj.price_url}] if carrier_obj.price_url else [],
                     } for carrier_obj in carrier_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "msg": "数据获取成功！"})

        if carrier_type == 2:
            carrier_obj_list = CarrierLand.query.filter_by(id=carrier_id)
            data = [{"id": carrier_obj.id,
                     "district_name": carrier_obj.district_name,
                     "land_name": carrier_obj.land_name,
                     "land_code": carrier_obj.land_code,
                     "land_nature": carrier_obj.land_nature,
                     # "land_status": carrier_obj.land_status,
                     # "linkman": carrier_obj.linkman,
                     # "link_mobile": carrier_obj.link_mobile,
                     "detail_address": carrier_obj.detail_address,
                     "total_area": carrier_obj.total_area,
                     # "plot_ratio": carrier_obj.plot_ratio,
                     # "jing_area": carrier_obj.jing_area,
                     # "sales_price": carrier_obj.sales_price,
                     # "max_sales_price": carrier_obj.max_sales_price,
                     # "max_car_space_price": carrier_obj.max_car_space_price,
                     # "transfer_year": carrier_obj.transfer_year,
                     # "industry_type": carrier_obj.industry_type,
                     # "plan_target": carrier_obj.plan_target,
                     "price_url": [
                         {"url": carrier_obj.price_url}] if carrier_obj.price_url else [],
                     } for carrier_obj in carrier_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "msg": "数据获取成功！"})

        if carrier_type == 3:
            carrier_obj_list = CarrierFactory.query.filter_by(id=carrier_id)
            data = [{"id": carrier_obj.id,
                     "district_name": carrier_obj.district_name,
                     "factory_name": carrier_obj.factory_name,
                     "is_standard": str(carrier_obj.is_standard),
                     "rent_money": carrier_obj.rent_money,
                     "construction_time": carrier_obj.construction_time,
                     "detail_address": carrier_obj.detail_address,
                     # "owner": carrier_obj.owner,
                     "cover_land_area": carrier_obj.cover_land_area,
                     "factory_area": carrier_obj.factory_area,
                     "empty_area": carrier_obj.empty_area,
                     "factory_structure": carrier_obj.factory_structure,
                     "width": carrier_obj.width,
                     "high": carrier_obj.high,
                     "bearing": carrier_obj.bearing,
                     "linkman": carrier_obj.linkman,
                     "link_mobile": carrier_obj.link_mobile,  # 拟招引状态
                     "is_electric": str(carrier_obj.is_electric),  # 租金
                     "is_water": str(carrier_obj.is_water),  # 合作模式
                     "is_warm": str(carrier_obj.is_warm),  # 合作模式
                     "is_gas": str(carrier_obj.is_gas),  # 合作模式
                     "is_network": str(carrier_obj.is_network),  # 合作模式
                     "lift_num": str(carrier_obj.lift_num),  # 合作模式
                     "layer_num": str(carrier_obj.layer_num),  # 合作模式
                     "attract_status": carrier_obj.attract_status,  # 拟招引状态
                     "cooperation_model": carrier_obj.cooperation_model,  # 合作模式
                     "attract_advantage": carrier_obj.attract_advantage,  # 招商优势
                     "policy": carrier_obj.policy,  # 相关政策
                     # "property_type": carrier_obj.property_type,  # 产权类型
                     "inside_picture_url": [
                         {"url": carrier_obj.inside_picture_url}] if carrier_obj.inside_picture_url else [],
                     "outer_picture_url": [
                         {"url": carrier_obj.outer_picture_url}] if carrier_obj.outer_picture_url else [],
                     #  平面图
                     "price_url": [
                         {"url": carrier_obj.price_url}] if carrier_obj.price_url else []
                     } for carrier_obj in carrier_obj_list]

            return jsonify(code=RET.OK, data={"data": data, "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")


# 编辑修改楼宇
@api_address.route("/CarrierEdit", methods=["POST"])
def carrier_edit_build():
    # 获取编辑后的数据
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '编辑修改楼宇数据'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    # if role_id == 3:  # 如果是办事员可以编辑自己提报的内容
    #     pass
    # if role_id == 2:  # 市直部门这区县领导可以编辑该部门所有办事员提报的内容
    #     pass
    # if role_id == 1:  # 局领导能看到所有审核通过的内容
    #     return jsonify(code=RET.THIRDERR, msg="局领导不能编辑数据。")

    build_id = req_dic['id']
    construction_time = req_dic['construction_time']
    district_name = req_dic['district_name']
    build_name = req_dic['build_name']
    detail_address = req_dic['detail_address']
    if not all([district_name, build_name, detail_address]):
        return jsonify(code=RET.PARAMERR, msg="所属区县、载体名称、详细地址不能为空！")
    # district_name = get_district(district_name)

    # lng = ''
    # lat = ''
    lng, lat, code, msg = get_jwd(detail_address)
    if code == 1:
        return jsonify(code=RET.DATAERR, msg=msg)
    cover_land_area = req_dic['cover_land_area']
    # cover_land_area_id = ''
    # if cover_land_area:
    #     cover_land_area_id = get_cover_land_area_id(cover_land_area)
    layer_num = req_dic['layer_num']
    car_space_num = req_dic['car_space_num']
    lift_num = req_dic['lift_num']
    build_area = req_dic['build_area']
    # total_area_id = ''
    # if build_area:
    #     total_area_id = get_total_area_id(build_area)
    empty_area = req_dic['empty_area']
    build_type = req_dic['build_type']
    # build_type_id = ''
    # if build_type:
    #     build_type_id = get_build_type_id(build_type)
    # build_structure = req_dic['build_structure']
    # owner = req_dic['owner']
    linkman = req_dic['linkman']
    link_mobile = req_dic['link_mobile']
    # if link_mobile:
    #     if not re.match(r"1[23456789]\d{9}$", link_mobile):
    #         return jsonify(code=RET.PARAMERR, msg="手机号格式错误")
    attract_status = req_dic['attract_status']
    rent_money = req_dic['rent_money']
    wuye_money = req_dic['wuye_money']
    cooperation_model = req_dic['cooperation_model']

    attract_advantage = req_dic['attract_advantage']
    policy = req_dic['policy']
    try:
        carrier_build = CarrierBuild.query.filter_by(id=build_id).first()
        carrier_build.construction_time = construction_time
        carrier_build.district_name = district_name
        carrier_build.build_name = build_name
        carrier_build.detail_address = detail_address
        carrier_build.cover_land_area = cover_land_area
        carrier_build.layer_num = layer_num
        carrier_build.car_space_num = car_space_num
        carrier_build.lift_num = lift_num
        carrier_build.build_area = build_area
        carrier_build.empty_area = empty_area
        carrier_build.build_type = build_type
        # carrier_build.build_structure = build_structure
        # carrier_build.owner = owner
        carrier_build.linkman = linkman
        carrier_build.link_mobile = link_mobile
        carrier_build.attract_status = attract_status
        carrier_build.rent_money = rent_money
        carrier_build.cooperation_model = cooperation_model
        carrier_build.fix_time = datetime.now()
        carrier_build.fix_people = user_name
        carrier_build.lng = lng
        carrier_build.lat = lat
        carrier_build.wuye_money = wuye_money
        carrier_build.attract_advantage = attract_advantage
        carrier_build.policy = policy
        db.session.add(carrier_build)
        db.session.commit()

        # 更新es
        # build_id_list = [build_id]
        # result = fix_build_data(build_id_list, construction_time, district_name, build_name, detail_address,
        #                cover_land_area, layer_num, car_space_num, lift_num, build_area, empty_area,
        #                build_type, build_structure, owner, linkman, link_mobile, attract_status,
        #                rent_money, cooperation_model, lng, lat, build_type_id, build_area,
        #                total_area_id, cover_land_area_id, '', '')
        # if result['_shards']['successful'] and int(result['_shards']['successful']) <= 0:
        #     db.session.rollback()
        #     return jsonify(code=RET.THIRDERR, msg="编辑修改楼宇数据后es更新错误，请核实！")

        # 记录日志
        operation_message = "修改了1条楼宇数据，该楼宇名称为 {}".format(build_name)
        edit_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=edit_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()

        return jsonify(code=RET.OK, msg="数据修改成功！")

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 编辑修改土地
@api_address.route("/CarrierEditLand", methods=["POST"])
def carrier_edit_land():
    # 获取编辑后的数据
    req_dic = request.get_json()
    token = request.headers['token']
    action_name = '编辑修改土地数据'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))
    # if role_id == 3:  # 如果是办事员可以编辑自己提报的内容
    #     pass
    # if role_id == 2:  # 市直部门这区县领导可以编辑该部门所有办事员提报的内容
    #     pass
    # if role_id == 1:  # 局领导能看到所有审核通过的内容
    #     return jsonify(code=RET.THIRDERR, msg="局领导不能编辑数据。")
    land_id = req_dic['land_id']
    district_name = req_dic['district_name']
    land_name = req_dic['land_name']
    detail_address = req_dic['detail_address']
    if not all([district_name, land_name, detail_address]):
        return jsonify(code=RET.PARAMERR, msg="所属区县、载体名称、详细地址不能为空！")
    # district_name = get_district(district_name)

    lng, lat, code, msg = get_jwd(detail_address)
    if code == 1:
        return jsonify(code=RET.DATAERR, msg=msg)
    land_code = req_dic['land_code']
    land_nature = req_dic['land_nature']
    total_area = req_dic['total_area']
    try:
        carrier_land = CarrierLand.query.filter_by(id=land_id).first()
        carrier_land.district_name = district_name
        carrier_land.land_name = land_name
        carrier_land.detail_address = detail_address
        carrier_land.land_code = land_code
        carrier_land.land_nature = land_nature
        carrier_land.total_area = total_area
        carrier_land.fix_time = datetime.now()
        carrier_land.fix_people = user_name
        carrier_land.lng = lng
        carrier_land.lat = lat
        # db.session.add(carrier_land)
        db.session.commit()

        # 更新es
        # audit_id_list = [land_id]
        # result = fix_land_data(audit_id_list, district_name, land_name, detail_address, lng, lat, total_area,
        #               total_area_id, jing_area, land_nature, land_nature_id, transfer_year,
        #               transfer_year_id, industry_type, land_code, land_status, '', '')
        # if result['_shards']['successful'] and int(result['_shards']['successful']) <= 0:
        #     db.session.rollback()
        #     return jsonify(code=RET.THIRDERR, msg="编辑修改土地数据后es更新错误，请核实！")

        # 记录日志
        operation_message = "修改了1条土地数据，该土地名称为 {}".format(land_name)
        edit_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=edit_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()

        return jsonify(code=RET.OK, msg="数据修改成功！")

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.OK, msg="查询数据库错误！")


@api_address.route("/CarrierLandStatus", methods=["POST"])
def land_status():
    # 获取编辑后的数据
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '修改土地状态'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))
    land_id = req_dic['land_id']
    land_status = req_dic['land_status']
    try:
        carrier_build = CarrierLand.query.filter_by(id=land_id).first()
        land_name = carrier_build.land_name
        carrier_build.land_status = land_status
        db.session.add(carrier_build)
        db.session.commit()
        # TODO 更新es
        # 记录日志
        operation_message = "修改了1条土地状态，该土地名称为 {}".format(land_name)
        edit_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=edit_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()
        return jsonify(code=RET.OK, msg="数据修改成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.OK, msg="查询数据库错误！")


# 编辑修改厂房
@api_address.route("/CarrierEditFactory", methods=["POST"])
def carrier_edit_factory():
    # 获取编辑后的数据
    req_dic = request.get_json()
    # token = req_dic['token']
    token = request.headers['token']
    action_name = '编辑修改楼宇数据'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))
    # if role_id == 3:  # 如果是办事员可以编辑自己提报的内容
    #     pass
    # if role_id == 2:  # 市直部门这区县领导可以编辑该部门所有办事员提报的内容
    #     pass
    # if role_id == 1:  # 局领导能看到所有审核通过的内容
    #     return jsonify(code=RET.THIRDERR, msg="局领导不能编辑数据。")
    factory_id = req_dic['factory_id']
    district_name = req_dic['district_name']
    factory_name = req_dic['factory_name']
    detail_address = req_dic['detail_address']
    if not all([district_name, factory_name, detail_address]):
        return jsonify(code=RET.PARAMERR, msg="所属区县、载体名称、详细地址不能为空！")
    # district_name = get_district(district_name)

    is_standard = req_dic['is_standard']
    rent_money = req_dic['rent_money']
    construction_time = req_dic['construction_time']
    detail_address = req_dic['detail_address']
    lng, lat, code, msg = get_jwd(detail_address)
    if code == 1:
        return jsonify(code=RET.DATAERR, msg=msg)
    # owner = req_dic['owner']
    cover_land_area = req_dic['cover_land_area']
    # cover_land_area_id = ''
    # if cover_land_area:
    #     cover_land_area_id = get_cover_land_area_id(cover_land_area)
    factory_area = req_dic['factory_area']
    empty_area = req_dic['empty_area']
    factory_structure = req_dic['factory_structure']
    width = req_dic['width']
    high = req_dic['high']
    bearing = req_dic['bearing']
    linkman = req_dic['linkman']
    is_electric = req_dic['is_electric']
    is_water = req_dic['is_water']
    is_warm = req_dic['is_warm']
    is_gas = req_dic['is_gas']
    is_network = req_dic['is_network']
    lift_num = req_dic['lift_num']
    # is_lift = ''
    # if lift_num and int(lift_num) > 0:
    #     is_lift = 1
    layer_num = req_dic['layer_num']
    attract_status = req_dic['attract_status']
    cooperation_model = req_dic['cooperation_model']
    attract_advantage = req_dic['attract_advantage']
    policy = req_dic['policy']
    link_mobile = req_dic['link_mobile']
    if is_electric not in ['', '是', '否'] or \
            is_water not in ['', '是', '否'] or \
            is_warm not in ['', '是', '否'] or \
            is_gas not in ['', '是', '否'] or \
            is_standard not in ['', '是', '否'] or \
            is_network not in ['', '是', '否']:
        return jsonify(code=RET.DATAERR, msg='上传失败！电气热暖/标准厂房相关字段格式不正确，请按备注填写是或否或置空！')

    # if link_mobile:
    #     if not re.match(r"1[23456789]\d{9}$", link_mobile):
    #         return jsonify(code=RET.PARAMERR, msg="手机号格式错误")
    try:
        carrier_factory = CarrierFactory.query.filter_by(id=factory_id).first()
        carrier_factory.district_name = district_name
        carrier_factory.factory_name = factory_name
        carrier_factory.is_standard = is_standard
        carrier_factory.rent_money = rent_money
        carrier_factory.construction_time = construction_time
        carrier_factory.detail_address = detail_address
        # carrier_factory.owner = owner
        carrier_factory.cover_land_area = cover_land_area
        carrier_factory.factory_area = factory_area
        carrier_factory.empty_area = empty_area
        carrier_factory.factory_structure = factory_structure
        carrier_factory.width = width
        carrier_factory.high = high
        carrier_factory.bearing = bearing
        carrier_factory.linkman = linkman
        carrier_factory.link_mobile = link_mobile
        carrier_factory.is_electric = is_electric
        carrier_factory.is_water = is_water
        carrier_factory.is_warm = is_warm
        carrier_factory.is_gas = is_gas
        carrier_factory.is_network = is_network
        carrier_factory.lift_num = lift_num
        carrier_factory.layer_num = layer_num
        carrier_factory.fix_time = datetime.now()
        carrier_factory.fix_people = user_name
        carrier_factory.lng = lng
        carrier_factory.lat = lat

        carrier_factory.attract_status = attract_status
        carrier_factory.cooperation_model = cooperation_model
        carrier_factory.attract_advantage = attract_advantage
        carrier_factory.policy = policy

        db.session.add(carrier_factory)
        db.session.commit()

        # 更新es
        # factory_id_list = [factory_id]
        # result = fix_factory_data(factory_id_list, district_name, factory_name, detail_address, lng, lat,
        #                  factory_structure, factory_area, cover_land_area, cover_land_area_id,
        #                  is_lift, is_standard, owner, rent_money, construction_time, empty_area,
        #                  width, high, bearing, linkman, link_mobile, is_electric, is_water, is_warm,
        #                  is_gas, is_network, lift_num, layer_num, '', '')
        # if result['_shards']['successful'] and int(result['_shards']['successful']) <= 0:
        #     db.session.rollback()
        #     return jsonify(code=RET.THIRDERR, msg="编辑修改厂房数据后es更新错误，请核实！")

        # 记录日志
        operation_message = "修改了1条厂房数据，该厂房名称为 {}".format(factory_name)
        edit_time = datetime.now()
        log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit, operation_time=edit_time,
                           operation_people=user_name, operation_message=operation_message,
                           operation_mobile=operation_mobile, section=section)
        db.session.add(log)
        db.session.commit()

        return jsonify(code=RET.OK, msg="数据修改成功！")

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.OK, msg="查询数据库错误！")


# 楼宇搜索功能/无参数时为展示所有
@api_address.route("/SearchCarrier", methods=["POST"])
def search_carrier_build():
    req_dic = request.get_json()

    token = request.headers['token']

    action_name = '搜索楼宇'
    # try:
    #     section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    build_name = req_dic['build_name']
    district_name = req_dic['district_name']
    build_type = req_dic['build_type']

    page = req_dic['page']
    per_page = req_dic['per_page']
    carrier_size = ''
    carrier_obj = ''

    try:
        if all([build_name, district_name, build_type]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.audit_status.in_([1, 3])))
            #
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                                                         CarrierBuild.district_name == district_name,
                                                         CarrierBuild.build_type.like('%{}%'.format(build_type))))
            carrier_size = carrier_obj.count()
        elif all([build_name, district_name]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.district_name == district_name,
            #                                                  CarrierBuild.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                                                         CarrierBuild.district_name == district_name))
            carrier_size = carrier_obj.count()
        elif all([build_name, build_type]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                                                         CarrierBuild.build_type.like('%{}%'.format(build_type))))
            carrier_size = carrier_obj.count()
        elif all([district_name, build_type]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_id == user_id)
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.upload_people_belong == belong_unit)
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name),
            #                                                  CarrierBuild.build_type.like('%{}%'.format(build_type)),
            #                                                  CarrierBuild.audit_status.in_([1, 3]))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name),
                                                    CarrierBuild.build_type.like('%{}%'.format(build_type)))
            carrier_size = carrier_obj.count()
        elif any([build_name, district_name, build_type]):
            if build_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                #                                                 CarrierBuild.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                #                                                 CarrierBuild.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_name.like('%{}%'.format(build_name)),
                #                                                 CarrierBuild.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierBuild.query.filter(CarrierBuild.build_name.like('%{}%'.format(build_name)))
                carrier_size = carrier_obj.count()
            if district_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name,
                #                                                 CarrierBuild.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name,
                #                                                 CarrierBuild.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.district_name == district_name,
                #                                                 CarrierBuild.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierBuild.query.filter(CarrierBuild.district_name == district_name)
                carrier_size = carrier_obj.count()
            if build_type:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_type.like('%{}%'.format(build_type)),
                #                                                 CarrierBuild.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_type.like('%{}%'.format(build_type)),
                #                                                 CarrierBuild.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierBuild.query.filter(and_(CarrierBuild.build_type.like('%{}%'.format(build_type)),
                #                                                 CarrierBuild.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierBuild.query.filter(CarrierBuild.build_type.like('%{}%'.format(build_type)))
                carrier_size = carrier_obj.count()
        else:  # 无参数，搜索全部
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierBuild.query.filter(CarrierBuild.upload_people_id == user_id)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierBuild.query.filter(CarrierBuild.upload_people_belong == belong_unit)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierBuild.query.filter(CarrierBuild.audit_status.in_([1, 3]))
            #
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierBuild.query.filter(CarrierBuild.id > 0)
            carrier_size = carrier_obj.count()

        build_obj_list = carrier_obj.order_by(CarrierBuild.upload_time.desc()).paginate(page, per_page).items
        if build_obj_list:
            data = [{
                "id": build_obj.id,
                "construction_time": build_obj.construction_time,
                "district_name": build_obj.district_name,
                "build_name": build_obj.build_name,
                "detail_address": build_obj.detail_address,
                "cover_land_area": build_obj.cover_land_area,
                "layer_num": build_obj.layer_num,
                "car_space_num": build_obj.car_space_num,
                "lift_num": build_obj.lift_num,
                "build_area": build_obj.build_area,
                "empty_area": build_obj.empty_area,
                "build_type": build_obj.build_type,
                "build_structure": build_obj.build_structure,
                "owner": build_obj.owner,
                "linkman": build_obj.linkman,
                "link_mobile": build_obj.link_mobile,
                "attract_status": build_obj.attract_status,  # 拟招引状态
                "rent_money": build_obj.rent_money,  # 租金
                "cooperation_model": build_obj.cooperation_model,  # 合作模式
                "audit_message": build_obj.audit_message,  # 审核信息
                "wuye_money": build_obj.wuye_money,
                "attract_advantage": build_obj.attract_advantage,
                "policy": build_obj.policy,
                "audit": build_obj.audit_status} for build_obj in build_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "数据获取成功！"})
        else:
            return jsonify(code=RET.DATAERR, msg="没有符合搜索条件的数据！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 土地搜索功能/无参数时为展示所有
@api_address.route("/SearchCarrierLand", methods=["POST"])
def search_carrier_land():
    req_dic = request.get_json()
    token = request.headers['token']
    action_name = '土地搜索'
    # try:
    #     section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    district_name = req_dic['district_name']
    land_name = req_dic['land_name']
    land_code = req_dic['land_code']

    page = req_dic['page']
    per_page = req_dic['per_page']
    carrier_size = ''
    try:
        if all([district_name, land_name, land_code]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierLand.query.filter(
                and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                     CarrierLand.district_name == district_name,
                     CarrierLand.land_code.like('%{}%'.format(land_code))))
            carrier_size = carrier_obj.count()
        elif all([land_name, district_name]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.district_name == district_name,
            #              CarrierLand.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierLand.query.filter(
                and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                     CarrierLand.district_name == district_name))
            carrier_size = carrier_obj.count()
        elif all([land_name, land_code]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierLand.query.filter(
            #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
            #              CarrierLand.land_code.like('%{}%'.format(land_code)),
            #              CarrierLand.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierLand.query.filter(
                and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                     CarrierLand.land_code.like('%{}%'.format(land_code))))
            carrier_size = carrier_obj.count()
        elif any([district_name, land_name, land_code]):
            if land_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierLand.query.filter(
                #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                #              CarrierLand.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierLand.query.filter(
                #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                #              CarrierLand.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierLand.query.filter(
                #         and_(CarrierLand.land_name.like('%{}%'.format(land_name)),
                #              CarrierLand.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierLand.query.filter(CarrierLand.land_name.like('%{}%'.format(land_name)))
                carrier_size = carrier_obj.count()
            if district_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.district_name == district_name,
                #                                                 CarrierLand.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.district_name == district_name,
                #                                                 CarrierLand.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.district_name == district_name,
                #                                                 CarrierLand.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierLand.query.filter(CarrierLand.district_name == district_name)
                carrier_size = carrier_obj.count()
            if land_code:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.land_code.like('%{}%'.format(land_code)),
                #                                                 CarrierLand.upload_people_id == user_id))
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.land_code.like('%{}%'.format(land_code)),
                #                                                 CarrierLand.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierLand.query.filter(and_(CarrierLand.land_code.like('%{}%'.format(land_code)),
                #                                                 CarrierLand.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierLand.query.filter(CarrierLand.land_code.like('%{}%'.format(land_code)))
                carrier_size = carrier_obj.count()
        else:  # 无参数，搜索全部
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierLand.query.filter(CarrierLand.upload_people_id == user_id)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierLand.query.filter(CarrierLand.upload_people_belong == belong_unit)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierLand.query.filter(CarrierLand.audit_status.in_([1, 3]))
            #
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierLand.query.filter(CarrierLand.id > 0)
            carrier_size = carrier_obj.count()
        land_obj_list = carrier_obj.order_by(CarrierLand.upload_time.desc()).paginate(page, per_page).items
        if land_obj_list:
            data = [{
                "id": land_obj.id,
                "district_name": land_obj.district_name,
                "land_name": land_obj.land_name,
                "detail_address": land_obj.detail_address,
                "audit_status": land_obj.audit_status,
                "audit_message": land_obj.audit_message,  # 审核信息
                "land_status": land_obj.land_status,
                "land_code": land_obj.land_code,
                "land_nature": land_obj.land_nature,
                "total_area": land_obj.total_area,
                "transfer_year": land_obj.transfer_year,
                "industry_type": land_obj.industry_type
            } for land_obj in land_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "数据获取成功！"})
        else:
            return jsonify(code=RET.DATAERR, msg="没有符合搜索条件的数据！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 厂房搜索功能/无参数时为展示所有
@api_address.route("/SearchCarrierFactory", methods=["POST"])
def search_carrier_factory():
    req_dic = request.get_json()

    # token = req_dic['token']
    # token = request.headers['token']
    # action_name = '搜索厂房'
    # try:
    #     section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))
    district_name = req_dic['district_name']
    factory_name = req_dic['factory_name']
    is_standard = req_dic['is_standard']

    page = req_dic['page']
    per_page = req_dic['per_page']
    carrier_size = ''
    carrier_obj = ''
    try:
        if all([district_name, factory_name, is_standard]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.audit_status.in_([1, 3])))
            #
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierFactory.query.filter(
                and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                     CarrierFactory.district_name == district_name,
                     CarrierFactory.is_standard == is_standard))
            carrier_size = carrier_obj.count()
        elif all([factory_name, district_name]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.district_name == district_name,
            #              CarrierFactory.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierFactory.query.filter(
                and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                     CarrierFactory.district_name == district_name))
            carrier_size = carrier_obj.count()
        elif all([factory_name, is_standard]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_id == user_id))
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_belong == belong_unit))
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.audit_status.in_([1, 3])))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierFactory.query.filter(
                and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                     CarrierFactory.is_standard == is_standard))
            carrier_size = carrier_obj.count()
        elif all([district_name, is_standard]):
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.district_name == district_name),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_id == user_id)
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.district_name == district_name),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.upload_people_belong == belong_unit)
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierFactory.query.filter(
            #         and_(CarrierFactory.district_name == district_name),
            #              CarrierFactory.is_standard == is_standard,
            #              CarrierFactory.audit_status.in_([1, 3]))
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierFactory.query.filter(
                and_(CarrierFactory.district_name == district_name),
                CarrierFactory.is_standard == is_standard)
            carrier_size = carrier_obj.count()
        elif any([factory_name, district_name, is_standard]):
            if factory_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierFactory.query.filter(
                #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                #              CarrierFactory.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierFactory.query.filter(
                #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                #              CarrierFactory.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierFactory.query.filter(
                #         and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)),
                #              CarrierFactory.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierFactory.query.filter(
                    CarrierFactory.factory_name.like('%{}%'.format(factory_name)))
                carrier_size = carrier_obj.count()
            if district_name:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.district_name == district_name,
                #                                                    CarrierFactory.upload_people_id == user_id))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.district_name == district_name,
                #                                                    CarrierFactory.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.district_name == district_name,
                #                                                    CarrierFactory.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierFactory.query.filter(CarrierFactory.district_name == district_name)
                carrier_size = carrier_obj.count()
            if is_standard:
                # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.is_standard == is_standard,
                #                                                    CarrierFactory.upload_people_id == user_id))
                #     carrier_size = carrier_obj.count()
                # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.is_standard == is_standard,
                #                                                    CarrierFactory.upload_people_belong == belong_unit))
                #
                #     carrier_size = carrier_obj.count()
                # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
                #     carrier_obj = CarrierFactory.query.filter(and_(CarrierFactory.is_standard == is_standard,
                #                                                    CarrierFactory.audit_status.in_([1, 3])))
                #
                #     carrier_size = carrier_obj.count()
                carrier_obj = CarrierFactory.query.filter(CarrierFactory.is_standard == is_standard)
                carrier_size = carrier_obj.count()
        else:  # 无参数，搜索全部
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     carrier_obj = CarrierFactory.query.filter(CarrierFactory.upload_people_id == user_id)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     carrier_obj = CarrierFactory.query.filter(CarrierFactory.upload_people_belong == belong_unit)
            #
            #     carrier_size = carrier_obj.count()
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     carrier_obj = CarrierFactory.query.filter(CarrierFactory.audit_status.in_([1, 3]))
            #
            #     carrier_size = carrier_obj.count()
            carrier_obj = CarrierFactory.query.filter(CarrierFactory.id > 0)
            carrier_size = carrier_obj.count()
        factory_obj_list = carrier_obj.order_by(CarrierFactory.upload_time.desc()).paginate(page, per_page).items
        if factory_obj_list:
            data = [{
                "id": factory_obj.id,
                "district_name": factory_obj.district_name,
                "factory_name": factory_obj.factory_name,
                "audit_status": factory_obj.audit_status,
                "audit_message": factory_obj.audit_message,  # 审核信息
                "is_standard": factory_obj.is_standard,
                "rent_money": factory_obj.rent_money,
                "construction_time": factory_obj.construction_time,
                "detail_address": factory_obj.detail_address,
                # "owner": factory_obj.owner,
                "cover_land_area": factory_obj.cover_land_area,
                "factory_area": factory_obj.factory_area,
                "empty_area": factory_obj.empty_area,
                "factory_structure": factory_obj.factory_structure,
                "width": factory_obj.width,
                "high": factory_obj.high,
                "bearing": factory_obj.bearing,
                "linkman": factory_obj.linkman,
                "link_mobile": factory_obj.link_mobile,
                "is_electric": factory_obj.is_electric,
                "is_water": factory_obj.is_water,
                "is_warm": factory_obj.is_warm,
                "is_gas": factory_obj.is_gas,
                "is_network": factory_obj.is_network,
                "lift_num": factory_obj.lift_num,
                "layer_num": factory_obj.layer_num,
                "attract_status": factory_obj.attract_status,
                "cooperation_model": factory_obj.cooperation_model,
                "attract_advantage": factory_obj.attract_advantage,
                "policy": factory_obj.policy,
            } for factory_obj in factory_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "size": carrier_size, "msg": "数据获取成功！"})
        else:
            return jsonify(code=RET.DATAERR, msg="没有符合搜索条件的数据！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


@api_address.route("/ShowLog", methods=["POST"])
def show_log():
    req_dic = request.get_json()
    pop_flag = req_dic['pop_flag']  # ture or false
    filter_time = req_dic['filter_time']
    # token = request.headers['token']
    # action_name = '获取日志信息'
    # try:
    #     section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    page = req_dic['page']
    per_page = req_dic['per_page']
    log_obj = ''
    try:
        log_num = ''
        if filter_time:
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     log_obj = OperationLog.query.filter(and_(OperationLog.operation_time.like('%{}%'.format(filter_time)),
            #                                             OperationLog.operation_people_id == user_id))
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     log_obj = OperationLog.query.filter(and_(OperationLog.operation_time.like('%{}%'.format(filter_time)),
            #                                             OperationLog.operation_people_belong == belong_unit))
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     log_obj = OperationLog.query.filter(OperationLog.operation_time.like('%{}%'.format(filter_time)))
            # log_obj_list = log_obj.order_by(
            #     OperationLog.operation_time.desc()).paginate(page, per_page).items
            log_obj = OperationLog.query.filter(OperationLog.operation_time.like('%{}%'.format(filter_time)))
            log_obj_list = log_obj.order_by(
                OperationLog.operation_time.desc()).paginate(page, per_page).items
        else:
            # if role_id == 3:  # 如果是办事员智能看到自己提报的内容
            #     log_obj = OperationLog.query.filter(OperationLog.operation_people_id == user_id)
            #     log_num = log_obj.count()
            #     if pop_flag:
            #         month_day = datetime.now().strftime("%Y-%m-01 00:00:00")
            #         login_time_obj = OperationLog.query.filter(OperationLog.operation_people_id == user_id,
            #                                             OperationLog.action.like('%登录%'),
            #                                             OperationLog.operation_time >= month_day).all()
            #         if len(login_time_obj) == 1:
            #             current_month = datetime.now().strftime("%Y-%m-26 00:00:00")
            #             log_obj1 = OperationLog.query.filter(OperationLog.operation_people_id == user_id,
            #                                                 OperationLog.action == '导入',
            #                                                 OperationLog.operation_time < current_month).all()
            #             if not log_obj1:
            #                 # 记录日志
            #                 upload_time = datetime.now()
            #                 current_year = datetime.now().year
            #                 operation_message = "请及时上传{}年{}月土地、商业楼宇、标准厂房数据；如无请忽略。".format(str(current_year), current_month)
            #                 log = OperationLog(read_type=0, operation_people_id=user_id, operation_time=upload_time,
            #                                    operation_people=user_name,
            #                                    section=section,
            #                                    operation_message=operation_message, operation_mobile='',
            #                                    action='使用密码登录成功')
            #                 db.session.add(log)
            #                 db.session.commit()
            #                 return jsonify(code=RET.WARNING, msg='25号之前还未上传数据！')
            #         else:
            #             return jsonify(code=RET.OK, msg='本月不是第一次登录，无需提示！')
            #
            # if role_id == 2:  # 市直部门这区县领导智能看到该部门所有办事员提报的内容
            #     log_obj = OperationLog.query.filter(OperationLog.operation_people_belong == belong_unit)
            #     log_num = log_obj.count()
            #
            # if role_id == 1:  # 局领导能看到所有审核通过和自己驳回的内容
            #     log_obj = OperationLog.query.filter()
            #     log_num = log_obj.count()
            # log_obj_list = log_obj.order_by(
            #     OperationLog.operation_time.desc()).paginate(page, per_page).items
            log_obj = OperationLog.query.filter()
            log_num = log_obj.count()
            log_obj_list = log_obj.order_by(OperationLog.operation_time.desc()).paginate(page, per_page).items
            print(log_obj_list)
        if log_obj_list:
            data = [{
                "people": log_obj.operation_people,
                "mobile": log_obj.operation_mobile,
                "section": log_obj.section,
                "time": log_obj.operation_time.strftime("%Y-%m-%d %H:%M:%S"),
                "message": log_obj.operation_message,
                "remark": log_obj.remark if log_obj.remark else '',
            } for log_obj in log_obj_list]
            return jsonify(data={"code": RET.OK, "data": data, "size": log_num, "msg": '操作日志信息获取成功！'})
        else:
            return jsonify(code=RET.NODATA, msg='操作日志数据为空！')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='操作日志信息获取失败！')


# 上传楼宇/厂房内外部照片
@api_address.route("/UploadBuildPicture", methods=["POST"])
def upload_build_picture():
    # token = ''
    # token = request.headers['token']
    try:
        # token = request.form['token']
        token = request.headers['token']
        carrier_type = request.form['carrier_type']
    except Exception as e:
        print(e)
    action_name = '上传照片'
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, action_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))

    carrier_id = request.form['carrier_id']
    img_flag = request.form['img_flag']
    img_name = request.form['img_name']
    img_file = request.files['img_file']

    try:
        access_key_id = "LTAI4Fkgi7DUf6jCVW3KNGwT"
        access_key_secret = "ynr6TWWNOnpALn3YUICUaXwpp9w4er"
        auth = oss2.Auth(access_key_id, access_key_secret)
        bucket_name = "zysf-store"
        endpoint = "oss-cn-beijing.aliyuncs.com"
        bucket = oss2.Bucket(auth, endpoint, bucket_name)
        bucket.put_object('太原二期项目载体内外部图片/' + img_name, img_file)
        img_url = "https://{}.{}/{}".format(bucket_name, endpoint, '太原二期项目载体内外部图片/' + img_name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg='第三方系统(阿里云oss图片存储)出错！')

    try:
        name = ''
        carrier_obj = ''
        carrier_name = ''
        if carrier_type == '1':  # 楼宇
            name = '楼宇'
            carrier_obj = CarrierBuild.query.filter_by(id=carrier_id).first()
            carrier_name = carrier_obj.build_name
            print(carrier_obj)
        if carrier_type == '2':
            name = '土地'
            carrier_obj = CarrierLand.query.filter_by(id=carrier_id).first()
            carrier_name = carrier_obj.land_name
            print(carrier_obj)
        if carrier_type == '3':
            name = '厂房'
            carrier_obj = CarrierFactory.query.filter_by(id=carrier_id).first()
            carrier_name = carrier_obj.factory_name
            print(carrier_obj)

        if img_flag == '1':  # 内部图片
            carrier_obj.inside_picture_url = img_url
            db.session.commit()

            # 记录日志
            operation_message = "上传了{}名称为 {} 的，内部图片".format(name, carrier_name)
            edit_time = datetime.now()
            log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                               operation_time=edit_time, operation_people=user_name,
                               operation_message=operation_message,
                               operation_mobile=operation_mobile, section=section)
            db.session.add(log)
            db.session.commit()
            return jsonify(code=RET.OK, img_url=img_url, msg='图片上传成功！')

        if img_flag == '2':  # 外部图片
            carrier_obj.outer_picture_url = img_url
            db.session.commit()

            # 记录日志
            operation_message = "上传了{}名称为 {} 的，外部图片".format(name, carrier_name)
            edit_time = datetime.now()
            log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                               operation_time=edit_time, operation_people=user_name,
                               operation_message=operation_message,
                               operation_mobile=operation_mobile, section=section)
            db.session.add(log)
            db.session.commit()
            return jsonify(code=RET.OK, img_url=img_url, msg='图片上传成功！')
        if img_flag == '3':  # 土地的规划图
            carrier_obj.price_url = img_url
            db.session.commit()

            # 记录日志
            operation_message = "上传了{}名称为 {} 的规划图".format(name, carrier_name)
            edit_time = datetime.now()
            log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                               operation_time=edit_time, operation_people=user_name,
                               operation_message=operation_message,
                               operation_mobile=operation_mobile, section=section)
            db.session.add(log)
            db.session.commit()
            return jsonify(code=RET.OK, img_url=img_url, msg='图片上传成功！')

    except Exception as e:
        current_app.logger.error(e)
        db.session.rollback()
        return jsonify(code=RET.DBERR, img_url=img_url, msg='图片url入库失败！')
