import os
import time

import oss2
import requests
import xlrd
import xlwt
from dateutil.relativedelta import relativedelta
from flask import current_app, jsonify, request
from sqlalchemy import and_
import zipfile

from apps.models import *

from apps.models import ProjectManagement
from apps.utils.response_code import RET
from apps.inves_manage import api_manage
from apps.util import verify_token


# 项目管理---项目列表
from apps.inves_manage.siku_view import get_num, upload_daily_picture

"""项目总览"""


@api_manage.route("/ProjectStalker", methods=["POST"])  # 项目跟踪
def project_stalker():
    req_dic = request.get_json()
    district = req_dic['district']

    stalker_num1 = 0
    stalker_num2 = 0
    stalker_num3 = 0

    sign_num = 0
    start_num = 0
    end_num = 0

    job_num = 0
    new_value_num = 0
    revenue_num = 0
    try:
        project_obj_list = ProjectManagement.query.filter(
            ProjectManagement.district == district if district else text(''),
            ProjectManagement.is_delete == 0
        ).all()
        for project_obj in project_obj_list:
            if project_obj.sign_time and project_obj.project_stalker == '进展顺利项目':
                stalker_num1 += 1
            if project_obj.sign_time and project_obj.project_stalker == '进展难点项目':
                stalker_num2 += 1
            if project_obj.sign_time and project_obj.project_stalker == '进展难点项目':
                stalker_num3 += 1
            if project_obj.sign_time and project_obj.investment_volume >= 100000:
                stalker_num3 += 1
            if project_obj.sign_time:
                sign_num += 1
            if project_obj.start_time:
                start_num += 1
            if project_obj.end_time:
                end_num += 1
            if project_obj.job_num:
                job_num += project_obj.job_num
            if project_obj.new_value:
                new_value_num += project_obj.new_value
            if project_obj.revenue:
                revenue_num += project_obj.revenue

        data = {
            "stalker_num1": stalker_num1,
            "stalker_num2": stalker_num2,
            "stalker_num3": stalker_num3,
            "sign_num": sign_num,
            "start_num": start_num,
            "end_num": end_num,
            "job_num": job_num,
            "new_value_num": new_value_num,
            "revenue_num": revenue_num
        }
        return jsonify(code=RET.OK, data=data, msg="查询成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询出错！")


# 概览数据/项目地图
@api_manage.route("/Overview", methods=["POST"])
def project_map():
    req_dic = request.get_json()
    district_name = req_dic['district_name']
    try:
        project_obj_count1 = 0
        project_obj_count2 = 0
        project_obj_count3 = 0
        project_obj_list = ProjectManagement.query.filter(
            ProjectManagement.district == district_name if district_name else text('')
            ).all()
        for project_obj in project_obj_list:
            if project_obj.sign_time:
                project_obj_count1 += 1
            if project_obj.start_time:
                project_obj_count2 += 1
            if project_obj.end_time:
                project_obj_count3 += 1
        data = {
            "project_obj_count1": project_obj_count1,
            "project_obj_count2": project_obj_count2,
            "project_obj_count3": project_obj_count3,
        }
        print('签约时间：{}，开工时间：{}，竣工时间：{}，'.format(
            project_obj_count1,
            project_obj_count2,
            project_obj_count3))
        return jsonify(code=RET.OK, data=data, msg="查询成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")
