import os
import time

import oss2
import requests
import sqlalchemy
import xlrd
import xlwt
from dateutil.relativedelta import relativedelta
from flask import current_app, jsonify, request
from sqlalchemy import and_, or_
import zipfile

from apps.models import *

from apps.models import ProjectManagement
from apps.utils.response_code import RET
from apps.inves_manage import api_manage
from apps.util import verify_token


# 项目管理---项目列表
from apps.inves_manage.siku_view import get_num, upload_daily_picture


"""指标分析"""


# 项目签约完成率
# def get_data1(district_li, current_year, data_time):
def get_data1(district_li, current_year):
    data_li1 = []
    # now_time = datetime.now().strftime('%Y-%m-01 00:00:00')
    # now_time1 = (datetime.now() - relativedelta(years=1)).strftime('%Y-%m-01 00:00:00')
    #
    # if data_time:
    #     if data_time[0] and data_time[1]:
    #         now_time3 = ('{}-{}-01 00:00:00').format(data_time[0], data_time[1])
    #     if data_time[2]:
    #         now_time4 = ('{}-{}-01 00:00:00').format(data_time[0], data_time[2])

    try:
        for district in district_li:
            # if not data_time:
            #     project_obj_list = ProjectManagement.query.filter(
            #         ProjectManagement.is_delete == 0,
            #         ProjectManagement.sign_time < now_time,
            #         ProjectManagement.sign_time >= now_time1,
            #         ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            #     ).all()
            # else:
            #     project_obj_list = ProjectManagement.query.filter(
            #         ProjectManagement.is_delete == 0,
            #         ProjectManagement.sign_time < now_time4 if now_time4 else text(''),
            #         ProjectManagement.sign_time >= now_time3,
            #         ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            #     ).all()
            project_obj_list = ProjectManagement.query.filter(
                ProjectManagement.is_delete == 0,
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).all()
            if not project_obj_list:
                investment_volume = 0
            else:
                investment_volume = sum([project_obj.investment_volume for project_obj in project_obj_list])
            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                year_target = 0
            else:
                year_target = jc_obj.money_sign

            data = {
                "name": district,
                "data": round(investment_volume / 10000, 2),
                "target": year_target,
                "value": round(investment_volume / 10000 / year_target * 100, 2) if year_target and year_target != 0 else 0
            }
            data_li1.append(data)
            continue
    except Exception as e:
        current_app.logger.error(e)
        print('项目签约完成率计算出错', e)
        return 'error'
    data_li1 = sorted(data_li1, key=lambda x: x['value'], reverse=False)
    return data_li1


# 项目开工率
# def get_data2(district_li, current_year, data_time):
def get_data2(district_li, current_year):
    data_li2 = []

    # now_time = datetime.now().strftime('%Y-%m-01 00:00:00')
    # now_time1 = (datetime.now() - relativedelta(years=1)).strftime('%Y-%m-01 00:00:00')
    #
    # if data_time:
    #     if data_time[0] and data_time[1]:
    #         now_time3 = ('{}-{}-01 00:00:00').format(data_time[0], data_time[1])
    #     if data_time[2]:
    #         now_time4 = ('{}-{}-01 00:00:00').format(data_time[0], data_time[2])

    try:
        for district in district_li:
            # 签约项目个数
            # if not data_time:
            #     sign_num = ProjectManagement.query.filter(
            #         ProjectManagement.is_delete == 0,
            #         # ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
            #         ProjectManagement.sign_time < now_time,
            #         ProjectManagement.sign_time >= now_time1,
            #         ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            #     ).count()
            #     # 年度目标
            #     start_num = ProjectManagement.query.filter(
            #         ProjectManagement.is_delete == 0,
            #         # ProjectManagement.start_time.like('%{}%'.format(str(current_year))),
            #         ProjectManagement.start_time < now_time,
            #         ProjectManagement.start_time >= now_time1,
            #         ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            #     ).count()
            sign_num = ProjectManagement.query.filter(
                ProjectManagement.is_delete == 0,
                # ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).count()
            # 年度目标
            start_num = ProjectManagement.query.filter(
                ProjectManagement.is_delete == 0,
                # ProjectManagement.start_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.start_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).count()
            data = {
                "name": district,
                "data": start_num,
                "target": sign_num,
                "value": round(start_num / sign_num * 100, 2) if sign_num and sign_num != 0 else 0
            }
            data_li2.append(data)
            continue
    except Exception as e:
        current_app.logger.error(e)
        print('项目开工率计算出错', e)
        return 'error'
    data_li2 = sorted(data_li2, key=lambda x: x['value'], reverse=False)
    return data_li2


# 新开工项目计划投资额完成率
def get_data3(district_li, current_year):
    data_li3 = []
    try:
        for district in district_li:
            project_obj_list = ProjectManagement.query.filter(
                ProjectManagement.is_delete == 0,
                ProjectManagement.start_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).all()
            if not project_obj_list:
                investment_volume = 0
            else:
                investment_volume = sum([project_obj.investment_volume for project_obj in project_obj_list])
            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                year_target = 0
            else:
                year_target = jc_obj.money_plan_invest

            data = {
                "name": district,
                "data": round(investment_volume / 10000, 2),
                "target": year_target,
                "value": round(investment_volume / 10000 / year_target * 100, 2) if year_target and year_target != 0 else 0
            }
            data_li3.append(data)
            continue
    except Exception as e:
        current_app.logger.error(e)
        print('新开工项目计划投资额完成率计算出错', e)
        return 'error'
    data_li3 = sorted(data_li3, key=lambda x: x['value'], reverse=False)
    return data_li3


# 固定资产投资项目到位资金完成率
def get_data4(district_li, current_year):
    data_li4 = []
    try:
        for district in district_li:
            project_obj = MoneyArrive.query.filter(
                MoneyArrive.data_time.like('%{}%'.format(str(current_year))),
                MoneyArrive.is_delete == 0,
                MoneyArrive.district_name.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).first()
            if not project_obj:
                arrive_money = 0
            else:
                arrive_money = project_obj.arrive_money
            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                year_target = 0
            else:
                year_target = jc_obj.money_arrive_target1

            # data = {
            #     "name": district,
            #     "data": round(arrive_money / 10000, 2),
            #     "target": year_target,
            #     "value": round(arrive_money / 10000 / year_target * 100, 2) if year_target and year_target != 0 else 0
            # }
            data = {
                "name": district,
                "data": arrive_money,
                "target": year_target,
                "value": round(arrive_money / year_target * 100, 2) if year_target and year_target != 0 else 0
            }
            data_li4.append(data)
            continue
    except Exception as e:
        current_app.logger.error(e)
        print('固定资产投资项目到位资金完成率计算出错', e)
        return 'error'
    data_li4 = sorted(data_li4, key=lambda x: x['value'], reverse=False)
    return data_li4


# 非固定资产投资项目到位资金完成率
def get_data5(district_li, current_year):
    data_li5 = []
    try:
        for district in district_li:
            project_obj_list = ProjectManagement.query.filter(
                ProjectManagement.is_delete == 0,
                ProjectManagement.is_fixed_investment == '否',
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).all()
            if not project_obj_list:
                investment_volume = 0
            else:
                investment_volume = sum([float(project_obj.investment_year) for project_obj in project_obj_list])
            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                year_target = 0
            else:
                year_target = jc_obj.money_arrive_target0
            data = {
                "name": district,
                "data": round(investment_volume / 10000, 2),
                "target": year_target,
                "value": round(investment_volume / 10000 / year_target * 100, 2) if year_target and year_target != 0 else 0
            }
            data_li5.append(data)
            continue
    except Exception as e:
        current_app.logger.error(e)
        print('非固定资产投资项目到位资金完成率计算出错', e)
        return 'error'
    data_li5 = sorted(data_li5, key=lambda x: x['value'], reverse=False)
    return data_li5


# 综合得分
def get_data6(district_li, data_li1, data_li2, data_li3, data_li4, data_li5):
    # data_li1, data_li2, data_li3, data_li4, data_li5 = get_data_li(district_li, current_year)
    data_li6 = []
    # 项目签约情况得分=完成率（%）*赋分（15 上传后获取）如果小于赋分（15 上传后获取），
    # 则输出完成率（%）*赋分（15 上传后获取）的结果，否则输出赋分（15）
    grade_li1 = []
    for data in data_li1:
        grade = data["value"] * 15
        if grade < 15:
            grade_li1.append({"name": data["name"], "grade": grade})
        else:
            grade_li1.append({"name": data["name"], "grade": 15})
    # 项目开工率情况得分=如果开工率进度小于0.4，则输出开工率进度*赋分（5分）/0.4，否则输出赋分（5分）；
    grade_li2 = []
    for data in data_li2:
        grade = data["value"]
        if grade < 0.4:
            grade_li2.append({"name": data["name"], "grade": grade * 5 / 0.4})
        else:
            grade_li2.append({"name": data["name"], "grade": 5})
    # 新开工固定资产投资项目计划投资额完成情况得分=如果完成率（%）小于1，
    # 则输出完成率（%）*赋分（25 上传后获取）的结果，否则输出赋分（25）；
    grade_li3 = []
    for data in data_li3:
        grade = data["value"]
        if grade < 1:
            grade_li3.append({"name": data["name"], "grade": grade * 25})
        else:
            grade_li3.append({"name": data["name"], "grade": 25})
    # 固定资产投资项目资金到位情况得分=如果完成率（%）小于1，
    # 则输出完成率（%）*赋分（25 上传后获取）的结果，否则输出赋分（25）；
    grade_li4 = []
    for data in data_li4:
        grade = data["value"]
        if grade < 1:
            grade_li4.append({"name": data["name"], "grade": grade * 25})
        else:
            grade_li4.append({"name": data["name"], "grade": 25})
    # 非固定资产投资项目资金到位情况得分=如果完成率（%）小于1，
    # 则输出完成率（%）*赋分（5 上传后获取）的结果，否则输出赋分（5）；
    grade_li5 = []
    for data in data_li5:
        grade = data["value"]
        if grade < 1:
            grade_li5.append({"name": data["name"], "grade": grade * 5})
        else:
            grade_li5.append({"name": data["name"], "grade": 5})
    grade1 = 0
    grade2 = 0
    grade3 = 0
    grade4 = 0
    grade5 = 0
    for district in district_li:
        # 签约情况得分
        for grade_dic in grade_li1:
            if grade_dic["name"] == district:
                grade1 = grade_dic["grade"]
        # 项目开工率情况得分
        for grade_dic in grade_li2:
            if grade_dic["name"] == district:
                grade2 = grade_dic["grade"]
        # 新开工得分
        for grade_dic in grade_li3:
            if grade_dic["name"] == district:
                grade3 = grade_dic["grade"]
        # 固定资产得分
        for grade_dic in grade_li4:
            if grade_dic["name"] == district:
                grade4 = grade_dic["grade"]
        # 非固定资产得分
        for grade_dic in grade_li5:
            if grade_dic["name"] == district:
                grade5 = grade_dic["grade"]
        total_grade = grade1 + grade2 + grade3 + grade4 + grade5
        data_li6.append({"name": district, "value": total_grade})
    data_li6 = sorted(data_li6, key=lambda x: x['value'], reverse=False)
    return data_li6


# def get_data_li(district_li, current_year, data_time):
def get_data_li(district_li, current_year):
    # 一。项目签约完成率(签约项目完成率：完成率（%）：签约金额（亿元）/ 年度目标（亿元）)
    # data_li1 = get_data1(district_li, current_year, data_time)
    data_li1 = get_data1(district_li, current_year)
    if data_li1 == 'error':
        return jsonify(code=RET.DBERR, msg='项目签约完成率计算出错')

    # 二。项目开工率(开工率进度：当年签约当年开工个数/签约个数)
    # data_li2 = get_data2(district_li, current_year, data_time)
    data_li2 = get_data2(district_li, current_year)
    if data_li2 == 'error':
        return jsonify(code=RET.DBERR, msg='项目开工率计算出错')

    # 三。新开工项目计划投资额完成率(完成率（%）：新开工项目计划投资额（亿元）/ 年度目标（亿元）)
    # data_li3 = get_data3(district_li, current_year, data_time)
    data_li3 = get_data3(district_li, current_year)
    if data_li3 == 'error':
        return jsonify(code=RET.DBERR, msg='新开工项目计划投资额完成率计算出错')

    # 四。固定资产投资项目到位资金完成率(完成率（%）：固定资产投资项目资金到位额（亿元）/ 年度目标（亿元）)
    # data_li4 = get_data4(district_li, current_year, data_time)
    data_li4 = get_data4(district_li, current_year)
    if data_li4 == 'error':
        return jsonify(code=RET.DBERR, msg='固定资产投资项目到位资金完成率计算出错')

    # 五。非固定资产投资项目到位资金完成率(完成率（%）：非固定资产投资项目资金到位额（亿元）/ 年度目标（亿元）)
    # data_li5 = get_data5(district_li, current_year, data_time)
    data_li5 = get_data5(district_li, current_year)
    if data_li5 == 'error':
        return jsonify(code=RET.DBERR, msg='非固定资产投资项目到位资金完成率计算出错')

    return data_li1, data_li2, data_li3, data_li4, data_li5


# 山西省地市数据统计
@api_manage.route("/StatisticShanxiData", methods=["POST"])
def statistic_shanxi_data():
    req_dic = request.get_json()
    flag = req_dic['flag']  # 1项目签约金额完成情况, 2新开工项目计划投资额完成情况, 3固定资产投资项目资金到位完成情况
    # data_time = req_dic['data_time']  # ["2022", "07", "18"]
    # data_time = data_time[0] + '年' + data_time[1] + '-' + data_time[2] + '月'
    try:
        # 获取最新的时间周期
        data_obj = ShanxiTarget.query.order_by(sqlalchemy.desc(ShanxiTarget.id)).first()
        data_time = data_obj.data_time
        # if not data_time1:
        #     # 获取最新时间周期的数据
        #     target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time1, is_delete=0).all()
        # else:
        #     # 获取所选时间周期条件的数据
        #     target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()
        target_obj_li = ShanxiTarget.query.filter_by(data_time=data_time, is_delete=0).all()

        data1 = ''
        data2 = ''
        if flag == 1:
            data = [{
                "district_name": target_obj.district_name,
                # "sign_money": round(target_obj.sign_money / 10000, 2),
                "sign_money": target_obj.sign_money,
                # "sign_target_money": round(target_obj.sign_target_money / 10000, 2),
                "sign_target_money": target_obj.sign_target_money,
                "sign_finish_rate": round(target_obj.sign_finish_rate, 2),
            } for target_obj in target_obj_li]
            data1 = sorted(data, key=lambda x: x['sign_money'], reverse=True)
            data2 = sorted(data1, key=lambda x: x['sign_finish_rate'], reverse=True)
        if flag == 2:
            data = [{
                "district_name": target_obj.district_name,
                # "plan_invest_money": round(target_obj.plan_invest_money / 10000, 2),
                # "plan_target_money": round(target_obj.plan_target_money / 10000, 2),
                "plan_invest_money": target_obj.plan_invest_money,
                "plan_target_money": target_obj.plan_target_money,
                "plan_finish_rate": round(target_obj.plan_finish_rate, 2),
            } for target_obj in target_obj_li]
            data1 = sorted(data, key=lambda x: x['plan_invest_money'], reverse=True)
            data2 = sorted(data1, key=lambda x: x['plan_finish_rate'], reverse=True)
        if flag == 3:
            data = [{
                "district_name": target_obj.district_name,
                # "arrive_money": round(target_obj.arrive_money / 10000, 2),
                "arrive_money": target_obj.arrive_money,
                # "arrive_target_money": round(target_obj.arrive_target_money / 10000, 2),
                "arrive_target_money": target_obj.arrive_target_money,
                "arrive_finish_rate": round(target_obj.arrive_finish_rate, 2)
            } for target_obj in target_obj_li]
            data1 = sorted(data, key=lambda x: x['arrive_money'], reverse=True)
            data2 = sorted(data1, key=lambda x: x['arrive_finish_rate'], reverse=True)
        return jsonify(code=RET.OK, data={"data1": data1, "data2": data2}, msg="获取成功！")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 晋城市数据统计
@api_manage.route("/StatisticJcData", methods=["POST"])
def statistic_jc_data():
    # req_dic = request.get_json()
    # data_time = req_dic['data_time']  # [2022, 01, 12]

    # current_year = datetime.now().year
    current_year = 2022
    district_li = ["全市", "城区", "泽州县", "高平市", "阳城县", "陵川县",
                   "沁水县", "晋城经济技术开发区"]
    try:
        # data_li1, data_li2, data_li3, data_li4, data_li5 = get_data_li(district_li, current_year, data_time)
        data_li1, data_li2, data_li3, data_li4, data_li5 = get_data_li(district_li, current_year)

        # 六。综合得分
        data_li6 = get_data6(district_li, data_li1, data_li2, data_li3, data_li4, data_li5)
        return jsonify(code=RET.OK,
                       data={"data_li1": data_li1, "data_li2": data_li2,
                             "data_li3": data_li3, "data_li4": data_li4,
                             "data_li5": data_li5, "data_li6": data_li6},
                       msg="数据查询成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据查询错误！")


# 区县/开发区指标完成表导出
@api_manage.route("/ExportJcData", methods=["POST"])
def export_jc_data():
    req_dic = request.get_json()
    flag = req_dic['flag']  # 1县(市、区)、开发区指标,2开发区(示范区)指标
    data_time = req_dic['data_time']
    path = './apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:8008/aaa_statics/project_file/'  # 项目路径
    # pro_path = 'http://192.168.1.4:5000/statics/project_file/'  # 项目路径
    if flag == 1:
        res = export_jc_data1(data_time, path, pro_path)
        if res == 'error':
            return jsonify(code=RET.DBERR, msg='区县指标导出失败！')
        return jsonify(code=RET.OK, data=res, msg='区县指标导出成功。')
    if flag == 2:
        res = export_jc_data2(data_time, path, pro_path)
        if res == 'error':
            return jsonify(code=RET.DBERR, msg='开发区指标导出失败！')
        return jsonify(code=RET.OK, data=res, msg='开发区指标导出成功。')


# 区县指标完成表导出
def export_jc_data1(data_time, path, pro_path):
    # 2022年1-11月
    current_year = data_time.split('年')[0]
    current_month = data_time.split('年')[1].split('月')[0]
    if '-' in current_year:
        current_month1 = current_month.split('-')[0]
        current_month2 = current_month.split('-')[1]
        current_year1 = current_year + '/' + current_month1
        current_year2 = current_year + '/' + current_month2
    else:
        current_month1 = current_month
        current_month2 = ''
        current_year1 = current_year + '/' + current_month1
        current_year2 = ''

    district_li = ["全市", "城区", "泽州县", "高平市", "阳城县", "陵川县",
                   "沁水县", "晋城经济技术开发区"]
    # 六。综合得分
    data_li1, data_li2, data_li3, data_li4, data_li5 = get_data_li(district_li, 2022)

    data_li6 = get_data6(district_li, data_li1, data_li2, data_li3, data_li4, data_li5)

    target_data_list = []
    try:
        for district in district_li:
            project_obj = ProjectManagement.query.filter(
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.is_delete == 0,
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            )
            data_list = []
            # 县(市、区）、开发区
            data_list.append(district)

            # 签约个数
            sign_num = project_obj.count()
            data_list.append(sign_num)

            # 签约金额（亿元）
            project_obj_list = project_obj.all()
            if not project_obj_list:
                sign_money = 0
            else:
                sign_money = sum([project_obj.investment_volume for project_obj in project_obj_list])
            data_list.append(sign_money)

            # 签约年度目标（亿元）
            jc_obj = JcTarget.query.filter(JcTarget.year.like('%{}%'.format(str(current_year))),
                                           JcTarget.is_delete == 0,
                                           JcTarget.district_name.like('%{}%'.format(str(district))) if district != '全市' else text('')).first()
            sign_target = 0
            if jc_obj:
                sign_target = jc_obj.money_sign
            data_list.append(sign_target)

            # 签约完成率
            sign_rate = round(sign_money / sign_target, 2) if sign_target and sign_target != 0 else 0
            data_list.append(sign_rate)

            # 签约得分（15分）
            grade = sign_rate * 15
            if grade < 15:
                sign_grade = grade
            else:
                sign_grade = 15
            data_list.append(sign_grade)

            # 当年开工个数
            start_num = ProjectManagement.query.filter(
                ProjectManagement.start_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.is_delete == 0,
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).count()
            data_list.append(start_num)

            # 开工率进度（40 %）
            start_rate = round(start_num / sign_num, 2) if sign_num and sign_num != 0 else 0
            data_list.append(start_rate)

            # 开工得分（5分）
            if start_rate < 0.4:
                start_grade = round(start_rate * 5 / 0.4, 2)
            else:
                start_grade = 5
            data_list.append(start_grade)

            # 新开工项目计划投资额（亿元）
            project_obj_list = ProjectManagement.query.filter(
                ProjectManagement.start_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.is_delete == 0,
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).all()
            if not project_obj_list:
                new_start_money = 0
            else:
                new_start_money = sum([project_obj.investment_volume for project_obj in project_obj_list])
            data_list.append(new_start_money)

            # 新开工年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                new_start_target = 0
            else:
                new_start_target = jc_obj.money_plan_invest
            data_list.append(new_start_target)

            # 新开工完成率
            new_start_rate = round(new_start_money / new_start_target, 2) if new_start_target and new_start_target != 0 else 0
            data_list.append(new_start_rate)

            # 新开工得分
            for grade_dic in data_li6:
                if grade_dic['name'] == district:
                    new_start_rate = grade_dic['value']
            if new_start_rate < 1:
                new_start_grade = new_start_rate * 25
            else:
                new_start_grade = 25
            data_list.append(new_start_grade)

            # 固定资产投资项目资金到位额（亿元）
            project_obj = MoneyArrive.query.filter(
                MoneyArrive.data_time == data_time,
                MoneyArrive.is_delete == 0,
                MoneyArrive.district_name.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).first()
            if not project_obj:
                gutou1_money = 0
            else:
                gutou1_money = project_obj.arrive_money
            data_list.append(gutou1_money)

            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district if district != '全市' else text(''),
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                gutou1_target = 0
            else:
                gutou1_target = jc_obj.money_arrive_target1
            data_list.append(gutou1_target)

            # 完成率
            gutou1_rate = round(gutou1_money / gutou1_target, 2) if gutou1_target and gutou1_target != 0 else 0
            data_list.append(gutou1_rate)

            # 得分（25分）
            if gutou1_rate < 1:
                gutou1_grade = gutou1_rate * 25
            else:
                gutou1_grade = 25
            data_list.append(gutou1_grade)

            # 非固定资产投资项目资金到位额（亿元）
            project_obj_list = ProjectManagement.query.filter(
                ProjectManagement.is_fixed_investment == '否',
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.is_delete == 0,
                ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
            ).all()
            if not project_obj_list:
                gutou0_money = 0
            else:
                gutou0_money = sum([project_obj.investment_year for project_obj in project_obj_list])
            data_list.append(gutou0_money)

            # 年度目标
            jc_obj = JcTarget.query.filter(
                JcTarget.district_name == district,
                JcTarget.year.like('%{}%'.format(str(current_year))),
                JcTarget.is_delete == 0
            ).first()
            if not jc_obj:
                gutou0_target = 0
            else:
                gutou0_target = jc_obj.money_arrive_target0
            data_list.append(gutou0_target)

            # 完成率
            gutou0_rate = round(gutou0_money / gutou0_target, 2) if gutou0_target and gutou0_target != 0 else 0
            data_list.append(gutou0_rate)

            # 得分（5分）
            if gutou0_rate < 1:
                gutou0_grade = gutou0_rate * 5
            else:
                gutou0_grade = 5
            data_list.append(gutou0_grade)

            # 指标得分（75分）
            target_grade = 0
            for grade_dic in data_li6:
                if grade_dic['name'] == district:
                    target_grade = grade_dic['value']
            data_list.append(target_grade)
            target_data_list.append(data_list)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="山西各县区数据导出失败！")
    head_list = ''
    sheet = ''
    try:
        sheet_name_titles = {
            "sheet1": ["县(市、区）、开发区", "签约个数", "签约金额（亿元）", "年度目标（亿元）",
                       "完成率", "得分（15分）", "当年签约当年开工个数", "开工率进度（40 %）",
                       "得分（5分）", "新开工项目计划投资额（亿元）", "年度目标（亿元）", "完成率",
                       "得分（25分）", "固定资产投资项目资金到位额（亿元）", "年度目标（亿元）",
                       "完成率", "得分（25分）", "非固定资产投资项目资金到位额（亿元）",
                       "年度目标（亿元）", "完成率", "得分（5分）", "指标得分（75分）"
                       ]}
        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                # print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "招商引资晋城区县指标生成表{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return pro_path + file_name
    except Exception as e:
        current_app.logger.error(e)
        return 'error'


# 开发区指标完成表导出
def export_jc_data2(data_time, path, pro_path):
    district_li = ["晋城经济技术开发区（一区四园）", "高平经济技术开发区",
                   "阳城经济技术开发区", "沁水经济技术开发区", "陵川生态文化旅游示范区", "汇  总"]
    # 2022年1-11月
    current_year = data_time.split('年')[0]
    current_month = data_time.split('年')[1].split('月')[0]
    if '-' in current_year:
        current_month1 = current_month.split('-')[0]
        current_month2 = current_month.split('-')[1]
        current_year1 = current_year + '/' + current_month1
        current_year2 = current_year + '/' + current_month2
    else:
        current_month1 = current_month
        current_month2 = ''
        current_year1 = current_year + '/' + current_month1
        current_year2 = ''

    target_data_list = []
    try:
        for district in district_li:
            data_list = []
            project_obj = ProjectManagement.query.filter(
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.sign_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.district.like('%{}%'.format(str(district))),
                ProjectManagement.is_delete == 0
            )
            # 1县(市、区）、开发区
            data_list.append(district)
            # 2签约个数
            sign_num = project_obj.count()
            data_list.append(sign_num)
            # 3签约金额（亿元）
            project_obj_list = project_obj.all()
            sign_money = sum([project_obj.investment_volume / 10000 for project_obj in project_obj_list if project_obj_list])
            data_list.append(sign_money)
            # 4属地签约任务（亿元）
            target_obj = JcTarget.query.filter(JcTarget.district_name == district,
                                               JcTarget.is_delete == 0,
                                               JcTarget.year == current_year + '年').first()
            if target_obj:
                target_money = target_obj.money_sign
            else:
                target_money = 0
            data_list.append(target_money)
            # 5完成属地目标任务占比
            if target_money != 0:
                finish_rate = round(sign_money / target_money * 100, 2)
            else:
                finish_rate = 0
            data_list.append(finish_rate)
            # 6新开工项目计划投资额（亿元）
            project_obj1 = ProjectManagement.query.filter(
                ProjectManagement.start_time.like('%{}%'.format(str(current_year1))),
                ProjectManagement.start_time.like('%{}%'.format(str(current_year2))),
                ProjectManagement.is_delete == 0,
                ProjectManagement.district.like('%{}%'.format(str(district)))
            )
            project_obj_list1 = project_obj1.all()
            start_money = sum(
                [project_obj.investment_volume / 10000 for project_obj in project_obj_list1 if project_obj_list1])
            data_list.append(start_money)
            # 7新开工属地投资任务（亿元）
            if target_obj:
                plan_money = target_obj.money_plan_invest
            else:
                plan_money = 0
            if not plan_money:
                plan_money = 0
            data_list.append(plan_money)
            # 8新开工完成属地目标任务占比
            if start_money != 0:
                start_rate = round(start_money / plan_money * 100, 2)
            else:
                start_rate = 0
            data_list.append(start_rate)

            # 9当年签约当年开工个数
            start_num = project_obj1.count()
            data_list.append(start_num)

            # 10开工率年度目标
            if target_obj:
                start_rate = target_obj.rate_start
            else:
                start_rate = 0
            data_list.append(start_rate)

            # 11开工率排名
            start_rank = ''
            data_list.append(start_rank)
            target_data_list.append(data_list)
            continue
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="开发区数据导出失败！")
    try:
        sheet_name_titles = {
            "sheet1": ["县(市、区）、开发区", "签约个数", "签约金额（亿元）", "属地签约任务（亿元）",
                       "完成属地目标任务占比", "新开工项目计划投资额（亿元）", "属地投资任务（亿元）",
                       "完成属地目标任务占比", "当年签约当年开工个数", "开工率年度目标（40 %）",
                       "开工率排名"
                       ]}
        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                # print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "招商引资开发区指标生成表{}.xlsx".format(time_stamp)
        excel.save(path + file_name)
        return pro_path + file_name
    except Exception as e:
        current_app.logger.error(e)
        return 'error'


"""项目分析"""


# 项目分析四个图表
@api_manage.route("/ProjectGraph", methods=["POST"])
def project_graph():
    req_dic = request.get_json()
    district = req_dic['district']
    flag = req_dic['flag']  # 1项目来源区域分布，2项目投资额区间分布，3项目产业分布，4项目行业类型分布

    project_source = req_dic['project_source']  # 用于1项目来源区域分布
    industry_name = req_dic['industry_name']  # 用于4项目行业类型分布

    # current_year = datetime.now().year
    current_year = 2022
    try:
        project_obj = ProjectManagement.query.filter(
            ProjectManagement.district == district if district else text(''),
            ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
            ProjectManagement.is_delete == 0
        )
        if not project_obj.all():
            return jsonify(code=RET.NODATA, msg='查询无数据！')
        if flag == 1:
            total_num = project_obj.count()
            num1 = project_obj.filter(or_(
                ProjectManagement.investor_district.like('%北京%'),
                ProjectManagement.investor_district.like('%天津%'),
                ProjectManagement.investor_district.like('%河北%')
            )).count()
            num2 = project_obj.filter(or_(
                ProjectManagement.investor_district.like('%江苏%'),
                ProjectManagement.investor_district.like('%浙江%'),
                ProjectManagement.investor_district.like('%上海%')
            )).count()
            num3 = project_obj.filter(or_(
                ProjectManagement.investor_district.like('%广东%'),
                ProjectManagement.investor_district.like('%香港%'),
                ProjectManagement.investor_district.like('%澳门%')
            )).count()
            num4 = project_obj.filter(or_(
                ProjectManagement.investor_district.like('%河南%'),
                ProjectManagement.investor_district.like('%长治%'),
                ProjectManagement.investor_district.like('%晋城%'),
                ProjectManagement.investor_district.like('%运城%'),
                ProjectManagement.investor_district.like('%聊城%'),
                ProjectManagement.investor_district.like('%菏泽%'),
                ProjectManagement.investor_district.like('%泰安%'),
                ProjectManagement.investor_district.like('%宿州%'),
                ProjectManagement.investor_district.like('%淮北%'),
                ProjectManagement.investor_district.like('%阜阳%'),
                ProjectManagement.investor_district.like('%亳州%'),
                ProjectManagement.investor_district.like('%蚌埠%'),
                ProjectManagement.investor_district.like('%淮南%'),
                ProjectManagement.investor_district.like('%邢台%'),
                ProjectManagement.investor_district.like('%邯郸%')
            )).count()
            num5 = total_num - sum([num1, num2, num3, num4])
            total_num = sum([num1, num2, num3, num4, num5])
            data = [
                {"name": "京津冀", "value": round(num1 / total_num * 100, 2)},
                {"name": "长三角", "value": round(num2 / total_num * 100, 2)},
                {"name": "珠三角", "value": round(num3 / total_num * 100, 2)},
                {"name": "中原经济区", "value": round(num4 / total_num * 100, 2)},
                {"name": "其他", "value": round(num5 / total_num * 100, 2)}
            ]
        elif flag == 2:
            project_count1 = project_obj.filter(
                ProjectManagement.investment_volume > 0,
                ProjectManagement.investment_volume <= 0.5 * 10000
            ).count()
            project_count2 = project_obj.filter(
                ProjectManagement.investment_volume > 0.5 * 10000,
                ProjectManagement.investment_volume <= 1 * 10000
            ).count()
            project_count3 = project_obj.filter(
                ProjectManagement.investment_volume > 1 * 10000,
                ProjectManagement.investment_volume <= 5 * 10000
            ).count()
            project_count4 = project_obj.filter(
                ProjectManagement.investment_volume > 5 * 10000,
                ProjectManagement.investment_volume <= 10 * 10000
            ).count()
            project_count5 = project_obj.filter(
                ProjectManagement.investment_volume > 10 * 10000,
                ProjectManagement.investment_volume <= 20 * 10000
            ).count()
            project_count6 = project_obj.filter(
                ProjectManagement.investment_volume > 20 * 10000,
            ).count()
            data = [
                {"name": "0-0.5亿", "value": project_count1},
                {"name": "0.5-1亿", "value": project_count2},
                {"name": "1-5亿", "value": project_count3},
                {"name": "5-10亿", "value": project_count4},
                {"name": "10-20亿", "value": project_count5},
                {"name": "20亿以上", "value": project_count6},
            ]
        elif flag == 3:  # 项目产业分布
            # 第一产业
            project_count1 = project_obj.filter(ProjectManagement.industry_level == '第一产业').count()
            # 第二产业
            project_count2 = project_obj.filter(
                ProjectManagement.industry_level == '第二产业').count()
            # 第三产业
            project_count3 = project_obj.filter(
                ProjectManagement.industry_level == '第三产业').count()
            total_num = project_count1 + project_count2 + project_count3
            if total_num == 0:
                return jsonify(code=RET.NODATA, msg='产业类型无数据！')
            data = [
                {"name": "第一产业", "value": round(project_count1 / total_num * 100, 2)},
                {"name": "第二产业", "value": round(project_count2 / total_num * 100, 2)},
                {"name": "第三产业", "value": round(project_count3 / total_num * 100, 2)},
            ]
        elif flag == 4:
            industry_list = ["传统产业升级改造", "现代农业", "战略性新兴产业", "现代服务业", "文化旅游产业"]
            data = []
            num_li = []
            for industry in industry_list:
                # if industry == '其他':
                #     all_project_count = project_obj.count()
                #     other_num = all_project_count - sum(num_li)
                #     data_dic = {"name": industry, "value": other_num}
                #     data.append(data_dic)
                # else:
                #     project_count = project_obj.filter(ProjectManagement.industry == industry).count()
                #     num_li.append(project_count)
                #     data_dic = {"name": industry, "value": project_count}
                #     data.append(data_dic)
                #     continue
                project_count = project_obj.filter(ProjectManagement.industry == industry).count()
                num_li.append(project_count)
                data_dic = {"name": industry, "value": project_count}
                data.append(data_dic)
        elif flag == 5:
            if project_source == '京津冀':
                num1 = project_obj.filter(
                    ProjectManagement.investor_district.like("%北京%")).count()
                num2 = project_obj.filter(
                    ProjectManagement.investor_district.like("%天津%")).count()
                num3 = project_obj.filter(
                    ProjectManagement.investor_district.like("%河北%")).count()

                total_num = sum([num1, num2, num3])
                data = [
                    {"name": "北京市", "value": round(num1 / total_num * 100, 2)},
                    {"name": "天津市", "value": round(num2 / total_num * 100, 2)},
                    {"name": "河北省", "value": round(num3 / total_num * 100, 2)},
                ]
            if project_source == '长三角':
                num1 = project_obj.filter(
                    ProjectManagement.investor_district.like('%江苏%')).count()
                num2 = project_obj.filter(
                    ProjectManagement.investor_district.like('%浙江%')).count()
                num3 = project_obj.filter(
                    ProjectManagement.investor_district.like('%上海%')).count()

                total_num = sum([num1, num2, num3])
                data = [
                    {"name": "江苏省", "value": round(num1 / total_num * 100, 2)},
                    {"name": "浙江省", "value": round(num2 / total_num * 100, 2)},
                    {"name": "上海市", "value": round(num3 / total_num * 100, 2)},
                ]
            if project_source == '珠三角':
                num1 = project_obj.filter(
                    ProjectManagement.investor_district.like('%广东%')).count()
                num2 = project_obj.filter(
                    ProjectManagement.investor_district.like('%香港%')).count()
                num3 = project_obj.filter(
                    ProjectManagement.investor_district.like('%澳门%')).count()

                total_num = sum([num1, num2, num3])
                data = [
                    {"name": "广东省", "value": round(num1 / total_num * 100, 2)},
                    {"name": "香港特别行政区", "value": round(num2 / total_num * 100, 2)},
                    {"name": "澳门特别行政区", "value": round(num3 / total_num * 100, 2)},
                ]
            if project_source == '中原经济区':
                project_obj_list = project_obj.filter(or_(
                    ProjectManagement.investor_district.like('%河南%'),
                    ProjectManagement.investor_district.like('%长治%'),
                    ProjectManagement.investor_district.like('%晋城%'),
                    ProjectManagement.investor_district.like('%运城%'),
                    ProjectManagement.investor_district.like('%聊城%'),
                    ProjectManagement.investor_district.like('%菏泽%'),
                    ProjectManagement.investor_district.like('%泰安%'),
                    ProjectManagement.investor_district.like('%宿州%'),
                    ProjectManagement.investor_district.like('%淮北%'),
                    ProjectManagement.investor_district.like('%阜阳%'),
                    ProjectManagement.investor_district.like('%亳州%'),
                    ProjectManagement.investor_district.like('%蚌埠%'),
                    ProjectManagement.investor_district.like('%淮南%'),
                    ProjectManagement.investor_district.like('%邢台%'),
                    ProjectManagement.investor_district.like('%邯郸%')
                )).all()
                source_list = set([project_obj.investor_district for project_obj in project_obj_list])
                num_list = []
                source_data_list = []
                data = []
                for source in list(source_list):
                    num = project_obj.filter(
                        ProjectManagement.investor_district.like('%{}%'.format(source))).count()
                    num_list.append(num)
                    source_data_list.append({"source": source, "num": num})
                total_num = sum(num_list)
                for source_data in source_data_list:
                    data_dic = {"name": source_data["source"], "value": round(source_data["num"] / total_num * 100, 2)}
                    data.append(data_dic)
                    continue
        elif flag == 6:
            project_obj_list = project_obj.filter(ProjectManagement.industry == industry_name).all()
            industry2_name_list = set([project_obj.industry2 for project_obj in project_obj_list])
            num_list = []
            industry_data_list = []
            data = []
            for industry2 in list(industry2_name_list):
                num = project_obj.filter(ProjectManagement.industry2 == industry2).count()
                num_list.append(num)
                industry_data_list.append({"industry": industry2, "num": num})
                continue
            total_num = sum(num_list)
            for industry_data in industry_data_list:
                data.append({"name": industry_data["industry"], "value": round(industry_data["num"] / total_num * 100, 2)})
                continue
        else:
            return jsonify(code=RET.PARAMERR, msg="参数错误！")

        return jsonify(code=RET.OK, data=data, msg='数据查询成功')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据查询错误！")


# 各类型项目列表
@api_manage.route("/ArealProject", methods=["POST"])
def areal_project():
    req_dic = request.get_json()
    district = req_dic['district']  # 全局
    project_source = req_dic['project_source']  # 用于1项目来源区域分布
    investment_volume = req_dic['investment_volume']  # 用于2项目投资额区间分布
    industry_level = req_dic['industry_level']  # 用于3项目产业分布
    industry_name = req_dic['industry_name']  # 用于4项目行业类型分布

    flag = req_dic['flag']  # 1项目来源区域分布，2项目投资额区间分布，3项目产业分布，4项目行业类型分布
    page = req_dic['page']
    per_page = req_dic['per_page']
    # current_year = datetime.now().year
    current_year = 2022

    try:
        project_obj = ProjectManagement.query.filter(
            ProjectManagement.district == district if district else text(''),
            ProjectManagement.sign_time.like('%{}%'.format(str(current_year))),
            ProjectManagement.is_delete == 0
        )

        if flag == 1:  # 项目来源区域分布项目列表
            if project_source == '京津冀':
                project_obj = project_obj.filter(or_(
                    ProjectManagement.investor_district.like('%北京%'),
                    ProjectManagement.investor_district.like('%天津%'),
                    ProjectManagement.investor_district.like('%河北%')
                ))
            elif project_source == '长三角':
                project_obj = project_obj.filter(or_(
                    ProjectManagement.investor_district.like('%江苏%'),
                    ProjectManagement.investor_district.like('%浙江%'),
                    ProjectManagement.investor_district.like('%上海%')
                ))
            elif project_source == '珠三角':
                project_obj = project_obj.filter(or_(
                    ProjectManagement.investor_district.like('%广东%'),
                    ProjectManagement.investor_district.like('%香港%'),
                    ProjectManagement.investor_district.like('%澳门%')
                ))
            elif project_source == '中原经济区':
                project_obj = project_obj.filter(or_(
                    ProjectManagement.investor_district.like('%河南%'),
                    ProjectManagement.investor_district.like('%天津%'),
                    ProjectManagement.investor_district.like('%河北%'),
                    ProjectManagement.investor_district.like('%长治%'),
                    ProjectManagement.investor_district.like('%晋城%'),
                    ProjectManagement.investor_district.like('%运城%'),
                    ProjectManagement.investor_district.like('%聊城%'),
                    ProjectManagement.investor_district.like('%菏泽%'),
                    ProjectManagement.investor_district.like('%泰安%'),
                    ProjectManagement.investor_district.like('%宿州%'),
                    ProjectManagement.investor_district.like('%淮北%'),
                    ProjectManagement.investor_district.like('%阜阳%'),
                    ProjectManagement.investor_district.like('%亳州%'),
                    ProjectManagement.investor_district.like('%蚌埠%'),
                    ProjectManagement.investor_district.like('%淮南%'),
                    ProjectManagement.investor_district.like('%邢台%'),
                    ProjectManagement.investor_district.like('%邯郸%'),
                ))
            elif project_source == '其他':
                project_obj = project_obj.filter(and_(
                    ProjectManagement.investor_district.notlike('%河南%'),
                    ProjectManagement.investor_district.notlike('%长治%'),
                    ProjectManagement.investor_district.notlike('%晋城%'),
                    ProjectManagement.investor_district.notlike('%运城%'),
                    ProjectManagement.investor_district.notlike('%聊城%'),
                    ProjectManagement.investor_district.notlike('%菏泽%'),
                    ProjectManagement.investor_district.notlike('%泰安%'),
                    ProjectManagement.investor_district.notlike('%宿州%'),
                    ProjectManagement.investor_district.notlike('%淮北%'),
                    ProjectManagement.investor_district.notlike('%阜阳%'),
                    ProjectManagement.investor_district.notlike('%亳州%'),
                    ProjectManagement.investor_district.notlike('%蚌埠%'),
                    ProjectManagement.investor_district.notlike('%淮南%'),
                    ProjectManagement.investor_district.notlike('%邢台%'),
                    ProjectManagement.investor_district.notlike('%邯郸%'),

                    ProjectManagement.investor_district.notlike('%北京%'),
                    ProjectManagement.investor_district.notlike('%天津%'),
                    ProjectManagement.investor_district.notlike('%河北%'),
                    ProjectManagement.investor_district.notlike('%江苏%'),
                    ProjectManagement.investor_district.notlike('%浙江%'),
                    ProjectManagement.investor_district.notlike('%上海%'),
                    ProjectManagement.investor_district.notlike('%广东%'),
                    ProjectManagement.investor_district.notlike('%香港%'),
                    ProjectManagement.investor_district.notlike('%澳门%')
                ))
            else:
                pass

        elif flag == 2:  # 项目投资额区间分布项目列表
            if investment_volume:
                project_obj = project_obj.filter(
                    ProjectManagement.investment_volume > investment_volume[0] if investment_volume[0] else text(''),
                    ProjectManagement.investment_volume <= investment_volume[1] if investment_volume[1] else text(''))

        elif flag == 3:  # 项目产业分布项目列表
            if industry_level:
                project_obj = project_obj.filter(ProjectManagement.industry_level == industry_level)

        elif flag == 4:  # 项目行业类型分布项目列表
            if industry_name:
                project_obj = project_obj.filter(ProjectManagement.industry == industry_name)

        elif flag == 5:  # 下钻的二级数据
            if project_source:
                project_obj = project_obj.filter(
                    ProjectManagement.investor_district.like('%{}%'.format(project_source))
                )
            if industry_name:
                project_obj = project_obj.filter(ProjectManagement.industry2 == industry_name)

        else:
            pass

        if not project_obj.all():
            return jsonify(code=RET.NODATA, msg='没有符合条件的数据！')
        project_size = project_obj.count()
        id_list = [project_obj.id for project_obj in project_obj.all()]
        project_obj_list = project_obj.order_by(ProjectManagement.upload_time.desc()).paginate(page, per_page).items
        data = [{
            "id": project_obj.id,
            "project_name": project_obj.project_name,
            "investor_district": project_obj.investor_district,
            # "industry": project_obj.industry + '-' if project_obj.industry else '' + project_obj.industry2 if project_obj.industry2 else '',
            "industry": project_obj.industry,
            "project_type": project_obj.industry_level,
            "investment_volume": project_obj.investment_volume
        } for project_obj in project_obj_list]
        return jsonify(code=RET.OK,
                       data={"data": data,
                             "size": project_size,
                             "id_list": id_list,
                             "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据查询错误！")


# 首页统计
@api_manage.route("/GetData", methods=["POST"])
def get_data():
    req_dic = request.get_json()
    flag = req_dic['flag']
    # current_year = str(datetime.now().year)
    current_year = "2022"
    district_li1 = ["全市", "城区", "泽州县", "高平市", "阳城县", "陵川县", "沁水县", "晋城经济技术开发区"]

    target_data_li = []
    if flag == 1:  # 签约项目完成情况
        try:
            for district in district_li1:
                data = {}
                project_obj = ProjectManagement.query.filter(
                    ProjectManagement.sign_time.like('%{}%'.format(current_year)),
                    ProjectManagement.is_delete == 0,
                    ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
                )
                # 区县
                data.update({"district": district})
                # 年度目标
                jc_obj = JcTarget.query.filter(JcTarget.year.like('%{}%'.format(current_year)),
                                               JcTarget.is_delete == 0,
                                               JcTarget.district_name.like('%{}%'.format(str(district))) if district != '全市' else text('')).first()
                target = 0
                if jc_obj:
                    target = jc_obj.money_sign
                data.update({"target": target})
                # 签约金额（亿元）
                project_obj_list = project_obj.all()
                if not project_obj_list:
                    sign_money = 0
                else:
                    sign_money = sum([project_obj.investment_volume / 10000 for project_obj in project_obj_list])
                data.update({"value": round(sign_money, 2)})

                # 签约完成率
                rate = round(sign_money / target * 100, 2) if target and target != 0 else 0
                data.update({"rate": rate})
                target_data_li.append(data)
            return jsonify(code=RET.OK, data=target_data_li, msg='数据查询成功。')
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据查询错误！")

    if flag == 2:  # 项目开工完成情况
        try:
            for district in district_li1:
                data = {}
                # 区县
                data.update({"district": district})
                project_obj = ProjectManagement.query.filter(
                    ProjectManagement.sign_time.like('%{}%'.format(current_year)),
                    ProjectManagement.is_delete == 0,
                    ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
                )
                # 签约个数
                sign_num = project_obj.count()
                data.update({"value": sign_num})
                # 当年开工个数
                target = ProjectManagement.query.filter(
                    ProjectManagement.start_time.like('%{}%'.format(current_year)),
                    ProjectManagement.is_delete == 0,
                    ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
                ).count()
                data.update({"target": target})

                # 开工率进度（40 %）
                rate = round(target / sign_num * 100, 2) if sign_num and sign_num != 0 else 0
                data.update({"rate": rate})
                target_data_li.append(data)
            return jsonify(code=RET.OK, data=target_data_li, msg='数据查询成功。')
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据查询错误！")

    if flag == 3:  # 新开工项目计划投资额完情况
        try:
            for district in district_li1:
                data = {}
                # 区县
                data.update({"district": district})
                # 新开工项目计划投资额（亿元）
                project_obj_list = ProjectManagement.query.filter(
                    ProjectManagement.sign_time.like('%{}%'.format(current_year)),
                    ProjectManagement.is_delete == 0,
                    ProjectManagement.district.like('%{}%'.format(district)) if district != '全市' else text('')
                ).all()
                if not project_obj_list:
                    new_start_money = 0
                else:
                    new_start_money = sum([project_obj.investment_volume / 10000 for project_obj in project_obj_list])
                data.update({"value": round(new_start_money, 2)})

                # 新开工年度目标
                jc_obj = JcTarget.query.filter(
                    JcTarget.district_name == district if district != '全市' else text(''),
                    JcTarget.year.like('%{}%'.format(current_year)),
                    JcTarget.is_delete == 0
                ).first()
                if not jc_obj:
                    target = 0
                else:
                    target = jc_obj.money_plan_invest
                data.update({"target": target})

                # 新开工完成率
                rate = round(new_start_money / target * 100, 2) if target and target != 0 else 0
                data.update({"rate": rate})
                target_data_li.append(data)
            return jsonify(code=RET.OK, data=target_data_li, msg='数据查询成功。')
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据查询错误！")

    if flag == 4:  # 固投资金完成情况
        try:
            for district in district_li1:
                data = {}
                # 区县
                data.update({"district": district})
                # 固定资产投资项目资金到位额（亿元）
                money_obj_li = MoneyArrive.query.filter_by(is_delete=0).all()
                max_id = max([money_obj.id for money_obj in money_obj_li])
                data_time_obj = MoneyArrive.query.get(max_id)
                data_time = data_time_obj.data_time
                project_obj = MoneyArrive.query.filter(
                    MoneyArrive.data_time == data_time,
                    MoneyArrive.is_delete == 0,
                    MoneyArrive.district_name.like('%{}%'.format(str(district))) if district != '全市' else text('')
                ).first()
                if not project_obj:
                    gutou1_money = 0
                else:
                    gutou1_money = project_obj.arrive_money
                data.update({"value": gutou1_money})

                # 年度目标
                jc_obj = JcTarget.query.filter(
                    JcTarget.district_name == district if district != '全市' else text(''),
                    JcTarget.year.like('%{}%'.format(str(current_year))),
                    JcTarget.is_delete == 0
                ).first()
                if not jc_obj:
                    gutou1_target = 0
                else:
                    gutou1_target = jc_obj.money_arrive_target1
                data.update({"target": gutou1_target})

                # 完成率
                gutou1_rate = round(gutou1_money / gutou1_target * 100, 2) if gutou1_target and gutou1_target != 0 else 0
                data.update({"rate": gutou1_rate})
                target_data_li.append(data)
            return jsonify(code=RET.OK, data=target_data_li, msg='数据查询成功。')
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据查询错误！")

    if flag == 5:  # 非固投资金完成情况
        try:
            for district in district_li1:
                data = {}
                # 区县
                data.update({"district": district})
                # 非固定资产投资项目资金到位额（亿元）
                project_obj_list = ProjectManagement.query.filter(
                    ProjectManagement.is_fixed_investment == '否',
                    ProjectManagement.sign_time.like('%{}%'.format(current_year)),
                    ProjectManagement.is_delete == 0,
                    ProjectManagement.district.like('%{}%'.format(str(district))) if district != '全市' else text('')
                ).all()
                if not project_obj_list:
                    gutou0_money = 0
                else:
                    gutou0_money = sum([project_obj.investment_volume / 10000 for project_obj in project_obj_list])
                data.update({"value": round(gutou0_money, 2)})

                # 年度目标
                jc_obj = JcTarget.query.filter(
                    JcTarget.district_name == district,
                    JcTarget.year.like('%{}%'.format(current_year)),
                    JcTarget.is_delete == 0
                ).first()
                if not jc_obj:
                    gutou0_target = 0
                else:
                    gutou0_target = jc_obj.money_arrive_target0
                data.update({"target": gutou0_target})

                # 完成率
                gutou0_rate = round(gutou0_money / gutou0_target * 100, 2) if gutou0_target and gutou0_target != 0 else 0
                data.update({"rate": gutou0_rate})
                target_data_li.append(data)
            return jsonify(code=RET.OK, data=target_data_li, msg='数据查询成功。')
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据查询错误！")