# # # -*- coding:utf-8 -*-
# import threading
# from apps.models import IndustryChain, Enterprise
# from manager import app
# from apps import db
#
#
# """
# IndustryChain或者Enterprise数据表更新后，
# 计算产业环节相关企业的数量并填充到IndustryChain的enterprise_num字段中。
# """
#
#
# def handle():
#     with app.app_context():
#         industry_obj_list = IndustryChain.query.all()
#         print(industry_obj_list)
#         # 读取industry_chain数据表的产业名称
#         for industry_obj in industry_obj_list:
#             industry_name = industry_obj.industry_name
#             indu_id = industry_obj.id
#             chain_id = industry_obj.chain_id
#             # 读取全国企业表，模糊匹配product_all字段
#             if industry_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
#                                  "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
#                                  "现代服务业", "数字经济", "文化旅游"]:
#                 continue
#
#             else:
#                 indu_obj_li = IndustryChain.query.filter(IndustryChain.relate_id == indu_id).all()
#                 for indu_obj in indu_obj_li:
#                     indu_name = indu_obj.industry_name
#                     print("正在查询【{}】的相关企业......".format(indu_name))
#                     enterprise_num1 = Enterprise.query.filter(
#                         Enterprise.c_type == chain_id,
#                         Enterprise.product_all.like("%{}%".format(industry_name))
#                     ).count()
#                     print(enterprise_num1)
#                     enterprise_num2 = Enterprise.query.filter(
#                         Enterprise.c_type1 == chain_id,
#                         Enterprise.product_all1.like("%{}%".format(industry_name))
#                     ).count()
#                     print(enterprise_num2)
#                     enterprise_num3 = Enterprise.query.filter(
#                         Enterprise.c_type2 == chain_id,
#                         Enterprise.product_all2.like("%{}%".format(industry_name))
#                     ).count()
#                     print(enterprise_num3)
#                     enterprise_num = enterprise_num1 + enterprise_num2 + enterprise_num3
#                     industry_obj.enterprise_num = enterprise_num
#                     # db.session.commit()
#                     print("产品【{}】已完成, 共有{}家相关企业。".format(indu_name, enterprise_num))
#
#
# if __name__ == '__main__':
#     t = threading.Thread(target=handle)
#     t.start()


# # -*- coding:utf-8 -*-
import threading
from apps.models import IndustryChain, Enterprise
from manager import app
from apps import db


"""
IndustryChain或者Enterprise数据表更新后，
计算产业环节相关企业去重后的数量并填充到IndustryChain的enterprise_num字段中。
"""


def get_product_li(product, chain_id):
    res_two_li = []
    res_three_li = []
    product_id = IndustryChain.query.filter_by(industry_name=product, chain_id=chain_id).first().id
    product_li = [{"chain_name": product, "chain_name_id": product_id}]
    chain_one_obj_list = IndustryChain.query.filter_by(relate_id=product_id, chain_id=chain_id).all()
    res_one_li = [{"chain_name": chain_one_obj.industry_name,
                "chain_name_id": chain_one_obj.id
                } for chain_one_obj in chain_one_obj_list]

    for res_one in res_one_li:
        chain_two_obj_list = IndustryChain.query.filter_by(relate_id=res_one["chain_name_id"]).all()
        res_two = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_two_obj_list]
        res_two_li.extend(res_two)
        res_one_li.extend(res_two)

    for res_two in res_two_li:
        chain_three_obj_list = IndustryChain.query.filter_by(relate_id=res_two["chain_name_id"]).all()
        res_three = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_three_obj_list]
        res_three_li.extend(res_three)
        res_one_li.extend(res_three)
    # print(res_one_li)
    for res_three in res_three_li:
        chain_four_obj_list = IndustryChain.query.filter_by(relate_id=res_three["chain_name_id"]).all()
        res_four = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_four_obj_list]
        res_one_li.extend(res_four)
    res_one_li.extend(product_li)
    return [res_one["chain_name"] for res_one in res_one_li]


def handle():
    with app.app_context():
        industry_obj_list = IndustryChain.query.all()
        # industry_obj_list = IndustryChain.query.filter(IndustryChain.id == 604).all()
        # print(industry_obj_list)
        # 读取industry_chain数据表的产业名称
        for industry_obj in industry_obj_list:
            industry_name = industry_obj.industry_name

            # 读取全国企业表，模糊匹配product_all字段
            if industry_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
                                 "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
                                 "现代服务业", "数字经济", "文化旅游"]:
                continue

            else:
                chain_id = industry_obj.chain_id
                indu_obj_li = get_product_li(industry_name, chain_id)
                # total_enterprise_num = 0
                company = []
                for indu_name in indu_obj_li:
                    # indu_name = indu_obj.industry_name
                    print("正在查询【{}】的相关企业......".format(indu_name))
                    company1 = Enterprise.query.filter(
                        Enterprise.c_type == chain_id,
                        Enterprise.product_all.like("%{}%".format(indu_name))
                    ).all()
                    company += company1
                    # print(company1)
                    company2 = Enterprise.query.filter(
                        Enterprise.c_type1 == chain_id,
                        Enterprise.product_all1.like("%{}%".format(indu_name))
                    ).all()
                    company += company2
                    # print(company2)
                    company3 = Enterprise.query.filter(
                        Enterprise.c_type2 == chain_id,
                        Enterprise.product_all2.like("%{}%".format(indu_name))
                    ).all()
                    company += company3
                    print("产品【{}】已完成, 共有{}家相关企业。".format(indu_name, len(company1 + company2 + company3)))

                company = set(company)  # 去重
                enterprise_num = len(company)
                industry_obj.enterprise_num = enterprise_num
                db.session.commit()
                print("=======产品【{}】已完成, 共有{}家相关企业=======。".format(industry_name, enterprise_num))


if __name__ == '__main__':
    t = threading.Thread(target=handle)
    t.start()
