import requests
from flask import current_app, request, jsonify
from apps.models import *
from sqlalchemy import extract, or_, and_
from apps.util import login_required, create_token, verify_token
from apps.utils.response_code import RET
from datetime import datetime
import datetime
from apps import db, constants, redis_store

from apps.view_xiaocx import api_xiaocx

from apps.inves_manage.siku_view import get_num, write_dynamic
from apps.view_choose.choose_view import global_region, global_land, global_factory, global_build


# 全部搜索功能
@api_xiaocx.route("/SearchAll", methods=["POST"])
@login_required
def search_all():
    req_dict = request.get_json()
    key_words = req_dict['key_words']  # 关键字
    industry_name = req_dict['industry_name']  # 所属行业
    district_name = req_dict['district_name']  # 所属区县
    carrier_type_id = req_dict['carrier_type_id']  # 载体类型id（1：园区；2：土地；3：楼宇；4：厂房。）
    preference = req_dict.get("preference")  # 选址偏好 [f,f,t,f,f,f]
    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小
    token = request.headers['token']

    if any([preference[0], preference[1], preference[2], preference[3], preference[4]]):
        if not industry_name:
            return jsonify(code=RET.PARAMERR, msg="选择选址偏好时，必须选择所属行业！")
    industry_id = ''
    if industry_name:
        industry_id = IndustryChain.query.filter(IndustryChain.industry_name.like("%{}%".format(industry_name))).first()

    data_list = []
    if carrier_type_id == 0:
        # 行政区
        if not industry_name:
            region_data = global_region(industry_id, preference, key_words, district_name,
                                        page, per_page)
            data_list.append(region_data)
        # 土地
        land_data = global_land(key_words, district_name, '', '', '', page, per_page)
        data_list.append(land_data)
        # 厂房
        factory_data = global_factory(key_words, district_name, '', industry_name, page, per_page)
        data_list.append(factory_data)
        # 楼宇
        build_data = global_build(key_words, district_name, '', industry_name, '', page, per_page)
        data_list.append(build_data)
        return jsonify(code=RET.OK, data=data_list, msg='全部数据查询成功！')
    if carrier_type_id == 1:  # 土地
        data = global_land(key_words, district_name, '', '', '', page, per_page)
        return jsonify(data)
    if carrier_type_id == 2:  # 厂房
        data = global_factory(key_words, district_name, '', industry_name, page, per_page)
        return jsonify(data)
    if carrier_type_id == 3:  # 楼宇
        data = global_build(key_words, district_name, '', industry_name, '', page, per_page)
        return jsonify(data)
    else:
        data = {"code": RET.PARAMERR, "msg": '参数错误！'}
        return jsonify(data)


# 首页搜索
@api_xiaocx.route('/IndexSearch', methods=['POST'])
@login_required
def index_search():
    req_dict = request.get_json()
    carrier_type = req_dict.get("carrier_type")  # 载体类型 1地块，2楼宇，3厂房，4园区，5项目
    carrier_name = req_dict.get("carrier_name")  # 载体名称
    district = req_dict.get("district")  # 所属区县
    industry = req_dict.get("industry")  # 产业类型
    investment_volume_list = req_dict.get("investment_volume_list")  # 投资额区间 [1, 0-0.5]

    nature = req_dict.get("nature")  # 土地性质
    area = req_dict.get("area")  # 土地面积 [10, 20 ]

    build_area = req_dict.get("build_area")  # 建筑面积 [0, 10000]
    rent_money = req_dict.get("rent_money")  # 租金 [0, 1.5]

    zone_level = req_dict.get("zone_level")  # 园区级别

    page = req_dict.get("page")  # page
    perpage = req_dict.get("perpage")  # perpage
    data = []
    total_num = ''
    try:
        if carrier_type == 1:
            if carrier_name:
                land_obj = CarrierLand.query.filter(
                    # CarrierLand.land_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierLand.land_nature == nature if nature else text(''),
                    CarrierLand.district_name == district if district else text(''),
                    CarrierLand.total_area > float(area[0]) if area[0] else text(''),
                    CarrierLand.total_area <= float(area[1]) if area[1] else text(''),
                ).filter(
                    or_(
                        CarrierLand.land_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierLand.land_nature.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierLand.total_area.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierLand.district_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierLand.total_area.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                ))
            else:
                land_obj = CarrierLand.query.filter(
                    CarrierLand.land_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierLand.land_nature == nature if nature else text(''),
                    CarrierLand.district_name == district if district else text(''),
                    CarrierLand.total_area > float(area[0]) if area[0] else text(''),
                    CarrierLand.total_area <= float(area[1]) if area[1] else text(''),
                )
            land_obj_list = land_obj.paginate(page, perpage).items
            total_num = land_obj.count()
            data = [{
                "id": land_obj.id,
                "name": land_obj.land_name,
                "district": land_obj.district_name,
                "nature": land_obj.land_nature,
                "area": land_obj.total_area,
                "price_url": land_obj.price_url,
                "lng": land_obj.lng,
                "lat": land_obj.lat,
            } for land_obj in land_obj_list]

        if carrier_type == 2:
            if carrier_name:
                build_obj = CarrierBuild.query.filter(
                    # CarrierBuild.build_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierBuild.attract_status.like('%{}%'.format(industry)) if industry else text(''),
                    CarrierBuild.district_name == district if district else text(''),
                    CarrierBuild.build_area > build_area[0] if build_area[0] else text(''),
                    CarrierBuild.build_area <= build_area[1] if build_area[1] else text(''),
                    CarrierBuild.rent_money > rent_money[0] if rent_money[0] else text(''),
                    CarrierBuild.rent_money <= rent_money[1] if rent_money[1] else text('')
                ).filter(
                    or_(
                        CarrierBuild.build_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierBuild.attract_status.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierBuild.build_area.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierBuild.rent_money.like('%{}%'.format(carrier_name)) if carrier_name else text(''),

                        CarrierBuild.district_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierBuild.build_area.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                ))
            else:
                build_obj = CarrierBuild.query.filter(
                    CarrierBuild.build_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierBuild.attract_status.like('%{}%'.format(industry)) if industry else text(''),
                    CarrierBuild.district_name == district if district else text(''),
                    CarrierBuild.build_area > build_area[0] if build_area[0] else text(''),
                    CarrierBuild.build_area <= build_area[1] if build_area[1] else text(''),
                    CarrierBuild.rent_money > rent_money[0] if rent_money[0] else text(''),
                    CarrierBuild.rent_money <= rent_money[1] if rent_money[1] else text('')
                )
            build_obj_list = build_obj.paginate(page, perpage).items
            total_num = build_obj.count()
            data = [{
                "id": build_obj.id,
                "name": build_obj.build_name,
                "district": build_obj.district_name,
                "rent": build_obj.rent_money,
                "area": build_obj.build_area,
                "attract_status": build_obj.attract_status,
                "price_url": build_obj.price_url,
                "lng": build_obj.lng,
                "lat": build_obj.lat,
            } for build_obj in build_obj_list]

        if carrier_type == 3:
            if carrier_name:
                factory_obj = CarrierFactory.query.filter(
                    # CarrierFactory.factory_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierFactory.attract_status.like('%{}%'.format(industry)) if industry else text(''),
                    CarrierFactory.district_name == district if district else text(''),
                    CarrierFactory.factory_area > build_area[0] if build_area[0] else text(''),
                    CarrierFactory.factory_area <= build_area[1] if build_area[1] else text('')
                ).filter(
                    or_(
                        CarrierFactory.factory_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierFactory.attract_status.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        CarrierFactory.factory_area.like('%{}%'.format(carrier_name)) if carrier_name else text(''),

                        CarrierFactory.district_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                ))
            else:
                factory_obj = CarrierFactory.query.filter(
                    CarrierFactory.factory_name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    CarrierFactory.attract_status.like('%{}%'.format(industry)) if industry else text(''),
                    CarrierFactory.district_name == district if district else text(''),
                    CarrierFactory.factory_area > build_area[0] if build_area[0] else text(''),
                    CarrierFactory.factory_area <= build_area[1] if build_area[1] else text('')
                )
            factory_obj_list = factory_obj.paginate(page, perpage).items
            total_num = factory_obj.count()
            data = [{
                "id": factory_obj.id,
                "name": factory_obj.factory_name,
                "district": factory_obj.district_name,
                "attract_industry": factory_obj.attract_status,
                "area": factory_obj.factory_area,
                "price_url": factory_obj.outer_picture_url,
                "lng": factory_obj.lng,
                "lat": factory_obj.lat,
            } for factory_obj in factory_obj_list]

        if carrier_type == 4:  # 园区
            if carrier_name:

                zone_obj = Induzone.query.filter(
                    # Induzone.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    Induzone.navigat.like('%{}%'.format(industry)) if industry else text(''),
                    Induzone.district == district if district else text(''),
                    Induzone.cate == '产业园区',
                    Induzone.level == zone_level if zone_level else text('')
                ).filter(
                    or_(
                        Induzone.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Induzone.navigat.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Induzone.level.like('%{}%'.format(carrier_name)) if carrier_name else text(''),

                        Induzone.phone.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Induzone.industry_position.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Induzone.district.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                ))
            else:
                zone_obj = Induzone.query.filter(
                    Induzone.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    Induzone.navigat.like('%{}%'.format(industry)) if industry else text(''),
                    Induzone.district == district if district else text(''),
                    Induzone.cate == '产业园区',
                    Induzone.level == zone_level if zone_level else text('')
                )
            zone_obj_list = zone_obj.paginate(page, perpage).items
            total_num = zone_obj.count()
            data = [{
                "id": zone_obj.id,
                "name": zone_obj.name,
                "phone": zone_obj.phone,
                "industry_position": zone_obj.industry_position,
                "district": zone_obj.district,
                "price_url": zone_obj.image,
                "lng": zone_obj.lng,
                "lat": zone_obj.lat,
            } for zone_obj in zone_obj_list]

        if carrier_type == 5:  # 项目
            if carrier_name:
                project_obj = Project.query.filter(
                    # Project.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    Project.district == district if district else text(''),
                    Project.attract_industry.like('%{}%'.format(industry)) if industry else text(''),
                    Project.money > float(investment_volume_list[0]) * 10000 if investment_volume_list[0] else text(''),
                    Project.money <= float(investment_volume_list[1]) * 10000 if investment_volume_list[1] else text(''),
                ).filter(
                    or_(
                        Project.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Project.district.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Project.attract_industry.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                        Project.money.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    ))
            else:
                project_obj = Project.query.filter(
                    Project.name.like('%{}%'.format(carrier_name)) if carrier_name else text(''),
                    Project.district == district if district else text(''),
                    Project.attract_industry == industry if industry else text(''),
                    Project.money > float(investment_volume_list[0]) * 10000 if investment_volume_list[0] else text(''),
                    Project.money <= float(investment_volume_list[1]) * 10000 if investment_volume_list[1] else text('')
                )
            project_obj_list = project_obj.paginate(page, perpage).items
            total_num = project_obj.count()
            data = [{
                "id": project_obj.id,
                "name": project_obj.name,
                "district": project_obj.district,
                "money": project_obj.money,
                "attract_industry": project_obj.attract_industry,
                # "lng": project_obj.lng,
                # "lat": project_obj.lat,
                "lng": '',
                "lat": '',
            } for project_obj in project_obj_list]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": total_num}, msg='数据查询成功！')


# 推介会列表
@api_xiaocx.route('/IntroductionMeet', methods=['POST'])
@login_required
def introduction_meet():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    flag = req_dict.get("flag")

    try:
        meet_obj_list = IntroductionMeet.query.filter(IntroductionMeet.flag == flag).order_by(IntroductionMeet.time.desc()).paginate(page, perpage).items
        meet_count = IntroductionMeet.query.count()

        data = [{
            "id": meet_obj.id,
            "name": meet_obj.name,
            "time": meet_obj.time,
            "organizer": meet_obj.organizer,
            "img_url": meet_obj.img_url,
            # "info": meet_obj.info,
        } for meet_obj in meet_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": meet_count}, msg='数据查询成功！')


# 推介会详情
@api_xiaocx.route('/MeetDetail', methods=['POST'])
@login_required
def meet_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        meet_obj = IntroductionMeet.query.get(_id)
        data = {
            "id": meet_obj.id,
            "name": meet_obj.name,
            "time": meet_obj.time,
            "organizer": meet_obj.organizer,
            "video_url": meet_obj.video_url,
            "img_url": meet_obj.img_url,
            "info": meet_obj.info
        }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data=data, msg='数据查询成功！')


# 招商资讯列表
@api_xiaocx.route('/Information', methods=['POST'])
@login_required
def information():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    flag = req_dict.get("flag")
    name = req_dict.get("name")

    try:
        inform_obj = InvestmentInformation.query.filter(
            InvestmentInformation.flag == flag,
            InvestmentInformation.name.like("%{}%".format(name)) if name else text('')
        )

        inform_obj_list = inform_obj.order_by(InvestmentInformation.time.desc()).paginate(page, perpage).items
        inform_count = inform_obj.count()

        data = [{
            "id": inform_obj.id,
            "name": inform_obj.name,
            "time": inform_obj.time,
            "source": inform_obj.source,
        } for inform_obj in inform_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="查询出错！")
    return jsonify(code=RET.OK, data={"data": data, "size": inform_count}, msg='数据查询成功！')


# 招商资讯详情/最新一条时id传空
@api_xiaocx.route('/InformationDetail', methods=['POST'])
@login_required
def information_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        if _id:
            inform_obj = InvestmentInformation.query.get(_id)
        else:  # 最新一条
            inform_obj = InvestmentInformation.query.order_by(
                InvestmentInformation.time.desc()).all()

        data = {
            "name": inform_obj.name,
            "time": inform_obj.time,
            "source": inform_obj.source,
            "info": inform_obj.content,
        }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    return jsonify(code=RET.OK, data=data, msg='Data query success！')


# 重点企业列表
@api_xiaocx.route('/CompanyList', methods=['POST'])
@login_required
def company_list():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    name = req_dict.get("name")
    district = req_dict.get("district")

    try:
        company_obj = Company.query.filter(
            Company.district == district if district else text(''),
            Company.company_name.like("%{}%".format(name)) if name else text('')
        )
        company_obj_list = company_obj.paginate(page, perpage).items
        company_count = company_obj.count()
        data = [{
            "id": company_obj.id,
            "name": company_obj.company_name,
            "product_all": company_obj.product_all,
            "c_name": company_obj.c_name
        } for company_obj in company_obj_list]

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    return jsonify(code=RET.OK, data={"data": data, "size": company_count}, msg='Data query success！')


# 重点企业详情
@api_xiaocx.route('/CompanyDetail', methods=['POST'])
@login_required
def company_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        company_obj = Company.query.get(_id)
        data = {
            "id": company_obj.id,
            "company_name": company_obj.company_name,
            "chain_master": '链主' if company_obj.chain_master == '1' else '',
            "district": company_obj.district,
            "lng": company_obj.lng,
            "lat": company_obj.lat,
            "address": company_obj.address,
            "telephone": company_obj.telephone,
            "company_info": company_obj.company_info,
            "c_name": company_obj.c_name,
            "zizhi": list(filter(len, [
                '高新技术企业' if company_obj.high_new == '1' else '',
                '科技型中小企业' if company_obj.tbe == '1' else '',
                '省级民营科技企业' if company_obj.tbe_sjmy == '1' else '',
                '融资企业' if company_obj.fianacing == '1' else '',
                '上市企业' if company_obj.quoted_company == '1' else '',
                '专利企业' if company_obj.patent == '1' else '',
                '山西民营100强' if company_obj.sxmon == '1' else '',
                '山西专精特新企业' if company_obj.zjtg == '1' else '',
                '国家级专精特新小巨人企业' if company_obj.zjtg_gjjxjr == '1' else '',
                '省级专精特新小巨人企业' if company_obj.zjtg_sjxjr == '1' else '',
                '独角兽企业' if company_obj.unicorn == '1' else '',
                '瞪羚企业' if company_obj.dengl == '1' else '',
                '中国500强' if company_obj.isfive == '1' else '',
                '山西100强' if company_obj.sxonhun == '1' else '',
                '规模以上企业' if company_obj.scale == '1' else '',
                '限额以上服务业' if company_obj.serve == '1' else '',
                '链主企业' if company_obj.chain_master == '1' else ''
        ]))
        }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    return jsonify(code=RET.OK, data=data, msg='Data query success！')


# 投资咨询
@api_xiaocx.route('/Consultation', methods=['POST'])
@login_required
def consultation():
    req_dict = request.get_json()
    project_name = req_dict.get("project_name")
    investor = req_dict.get("investor")
    investor_place = req_dict.get("investor_place")
    project_type = req_dict.get("project_type")
    investment_volume = req_dict.get("investment_volume")
    basic_information = req_dict.get("basic_information")
    land_area = req_dict.get("land_area")
    linkman = req_dict.get("linkman")
    link_mobile = req_dict.get("link_mobile")
    consultation_time = datetime.datetime.now()
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_id = user_obj.id
    except:
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    try:
        cons_obj = CustomerConsultation()
        cons_obj.user_id = user_id
        cons_obj.project_name = project_name
        cons_obj.investor = investor
        cons_obj.investor_place = investor_place
        cons_obj.project_type = project_type
        cons_obj.investment_volume = investment_volume
        cons_obj.basic_information = basic_information
        cons_obj.land_area = land_area
        cons_obj.linkman = linkman
        cons_obj.link_mobile = link_mobile
        cons_obj.consultation_time = consultation_time
        cons_obj.flag = 0
        db.session.add(cons_obj)
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    return jsonify(code=RET.OK, msg='save successfully！')


# 投资咨询信息列表
@api_xiaocx.route('/ConsultationList', methods=['POST'])
@login_required
def consultation_list():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        flag = user_obj.flag
        user_id = user_obj.id
    except:
        return jsonify(code=RET.SESSIONERR, msg="Query error！")

    try:
        if flag == 1:  # 外部访客智能看到自己的信息
            cons_obj_list = CustomerConsultation.query.filter(CustomerConsultation.user_id == user_id).order_by(CustomerConsultation.consultation_time.desc()).paginate(
                page, perpage).items
        else:
            cons_obj_list = CustomerConsultation.query.order_by(CustomerConsultation.consultation_time.desc()).paginate(page, perpage).items
        cons_count = CustomerConsultation.query.count()
        data = [{
            "id": cons_obj.id,
            "project_name": cons_obj.project_name,
            "investor": cons_obj.investor,
            "investor_place": cons_obj.investor_place,
            "project_type": cons_obj.project_type,
            "investment_volume": cons_obj.investment_volume,
            "basic_information": cons_obj.basic_information,
            "land_area": cons_obj.land_area,
            "linkman": cons_obj.linkman,
            "link_mobile": cons_obj.link_mobile,
            "flag": cons_obj.flag,
            "reply_content": cons_obj.reply_content,
            "consultation_time": cons_obj.consultation_time.strftime("%Y-%m-%d %H:%M:%S"),
            # "reply_time": cons_obj.reply_time,
        } for cons_obj in cons_obj_list]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="Query error！")
    return jsonify(code=RET.OK, data={"data": data, "size": cons_count}, msg='Data query success！')


# 投资咨询详情
@api_xiaocx.route('/ConsultationDetail', methods=['POST'])
@login_required
def consultation_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    try:
        cons_obj = CustomerConsultation.query.get(_id)
        data = {
            "id": cons_obj.id,
            "is_sync": cons_obj.is_sync,
            "project_name": cons_obj.project_name,
            "investor": cons_obj.investor,
            "investor_place": cons_obj.investor_place,
            "project_type": cons_obj.project_type,
            "investment_volume": cons_obj.investment_volume,
            "basic_information": cons_obj.basic_information,
            "land_area": cons_obj.land_area,
            "linkman": cons_obj.linkman,
            "link_mobile": cons_obj.link_mobile,
            "flag": cons_obj.flag,
            "reply_content": cons_obj.reply_content
        }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Query error！")
    return jsonify(code=RET.OK, data=data, msg='Data query success！')


# 回复投资咨询
@api_xiaocx.route('/ReplyConsultation', methods=['POST'])
@login_required
def reply_consultation():
    req_dict = request.get_json()
    reply_content = req_dict.get("reply_content")
    _id = req_dict.get("id")
    is_sync = req_dict.get("is_sync")
    token = request.headers["token"]
    consultation_time = datetime.datetime.now()
    upload_time = consultation_time.strftime("%Y/%m/%d")
    time_strf = consultation_time.strftime("%Y%m%d")

    try:
        user_obj = verify_token(token)
        upload_unity = user_obj.name
        upload_people = user_obj.belong_organization
        mobile = user_obj.mobile

        cons_obj = CustomerConsultation.query.get(_id)
        if reply_content:
            cons_obj.reply_content = reply_content
            cons_obj.flag = 1  # 已回复
            cons_obj.consultation_time = consultation_time  # 回复时间

        if is_sync == 1:
            cons_obj.is_sync = 1  # 跟平台同步
        db.session.commit()

        if is_sync == 1:
            project_type = cons_obj.project_type
            project_name = cons_obj.project_name
            investor_name = cons_obj.investor
            investor_district = cons_obj.investor_place
            investment_volume = cons_obj.investment_volume
            project_info = cons_obj.basic_information

            project_obj = SikuProject.query.filter(
                SikuProject.project_name == project_name,
                SikuProject.thread_source == '来自晋城小程序').first()
            if project_obj:
                return jsonify(code=RET.DBERR, msg='项目已存在。')

            project_obj_list = SikuProject.query.all()  # 项目编号
            project_num_list = ''
            if project_obj_list:
                project_num_list = [project_obj.project_num for project_obj in
                                    project_obj_list if (project_obj.project_num).startswith(time_strf)]
            if project_num_list:
                max_project_num = max(project_num_list)[8:]
                num = get_num(max_project_num)
                if num == 'error':
                    return 'error'
                project_num = time_strf + num
            else:
                project_num = time_strf + '001'

            # 创建项目
            new_project_obj = SikuProject(
                flag=1,  # 表示线索库
                is_delete=0,
                thread_progress='待对接',
                # provence=investor_district1,
                # city=investor_district2,
                industry=project_type.split('/')[0] if project_type and '/' in project_type else project_type,
                industry2=project_type.split('/')[1] if project_type and '/' in project_type else '',
                upload_unity=upload_unity,
                upload_people=upload_people,
                upload_time=upload_time,
                project_year=upload_time.split('/')[0],
                project_name=project_name,
                project_num=int(project_num),
                investor_name=investor_name,
                investor_district=investor_district,
                project_type=project_type,
                investment_volume=investment_volume,
                # investment_volume1=investment_volume1,
                project_info=project_info,
                # project_info1=project_info1,
                thread_people=upload_unity,
                thread_people_unity=upload_people,
                thread_people_mobile=mobile,
                thread_source='其他来源',
                other_source='来自晋城小程序'
            )
            db.session.add(new_project_obj)
            db.session.commit()
            project_id = new_project_obj.id

            # 记录项目动态
            time1 = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            write_dynamic(upload_people, project_id, '从晋城小程序导入了项目', time1)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="Error saving reply message！")
    return jsonify(code=RET.OK, msg='The reply message is saved successfully.')


# 收藏载体
@api_xiaocx.route('/CollectionCarrier', methods=['POST'])
@login_required
def collection_carrier():
    req_dict = request.get_json()
    id_list = req_dict.get("id_list")
    name = req_dict.get("name")
    token = request.headers["token"]
    user_obj = verify_token(token)
    if not user_obj:
        return jsonify(code=RET.SESSIONERR, msg='用户未登录。')

    try:
        if name == 'land':
            for _id in id_list:
                land_obj = CarrierLand.query.get(_id)
                if not land_obj or land_obj in user_obj.carrier_land:
                    continue
                user_obj.carrier_land.append(land_obj)
                db.session.commit()

        elif name == 'build':
            for _id in id_list:
                build_obj = CarrierBuild.query.get(_id)
                if build_obj and build_obj in user_obj.carrier_build:
                    continue
                user_obj.carrier_build.append(build_obj)
                db.session.commit()

        elif name == 'factory':
            for _id in id_list:
                factory_obj = CarrierFactory.query.get(_id)
                if not factory_obj or factory_obj in user_obj.carrier_factory:
                    continue
                user_obj.carrier_factory.append(factory_obj)
                db.session.commit()

        elif name == 'zone':
            for _id in id_list:
                zone_obj = Induzone.query.get(_id)
                if not zone_obj or zone_obj in user_obj.industry_zone:
                    continue
                user_obj.industry_zone.append(zone_obj)
                db.session.commit()

        elif name == 'project':
            for _id in id_list:
                project_obj = Project.query.get(_id)
                if not project_obj or project_obj in user_obj.project:
                    continue
                user_obj.project.append(project_obj)
                db.session.commit()

        elif name == 'company':
            for _id in id_list:
                company_obj = Company.query.get(_id)
                if not company_obj or company_obj in user_obj.company:
                    continue
                user_obj.company.append(company_obj)
                db.session.commit()

        elif name == 'policy':
            for _id in id_list:
                policy_obj = InduPolicy.query.get(_id)
                if not policy_obj or policy_obj in user_obj.industry_policy:
                    continue
                user_obj.industry_policy.append(policy_obj)
                db.session.commit()

        else:
            pass
        return jsonify(code=RET.OK, msg='Successful collection')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='Collection failure')


# 取消收藏
@api_xiaocx.route('/CancelCollection', methods=['POST'])
@login_required
def cancel_collection():
    req_dict = request.get_json()
    id_list = req_dict.get("id_list")
    name = req_dict.get("name")
    token = request.headers["token"]
    user_obj = verify_token(token)
    if not user_obj:
        return jsonify(code=RET.SESSIONERR, msg='User not logged in.')
    try:
        if name == 'land':
            for _id in id_list:
                land_obj = CarrierLand.query.get(_id)
                if not land_obj or land_obj not in user_obj.carrier_land:
                    continue
                user_obj.carrier_land.remove(land_obj)
                db.session.commit()

        elif name == 'build':
            for _id in id_list:
                build_obj = CarrierBuild.query.get(_id)
                if not build_obj or build_obj not in user_obj.carrier_build:
                    continue
                user_obj.carrier_build.remove(build_obj)
                db.session.commit()

        elif name == 'factory':
            for _id in id_list:
                factory_obj = CarrierFactory.query.get(_id)
                if not factory_obj or factory_obj not in user_obj.carrier_factory:
                    continue
                user_obj.carrier_factory.remove(factory_obj)
                db.session.commit()

        elif name == 'zone':
            for _id in id_list:
                zone_obj = Induzone.query.get(_id)
                if not zone_obj or zone_obj not in user_obj.industry_zone:
                    continue
                user_obj.industry_zone.remove(zone_obj)
                db.session.commit()

        elif name == 'project':
            for _id in id_list:
                project_obj = Project.query.get(_id)
                if not project_obj or project_obj not in user_obj.project:
                    continue
                user_obj.project.remove(project_obj)
                db.session.commit()

        elif name == 'company':
            for _id in id_list:
                company_obj = Company.query.get(_id)
                if not company_obj or company_obj not in user_obj.company:
                    continue
                user_obj.company.remove(company_obj)
                db.session.commit()
        elif name == 'policy':
            for _id in id_list:
                policy_obj = InduPolicy.query.get(_id)
                if not policy_obj or policy_obj not in user_obj.industry_policy:
                    continue
                user_obj.industry_policy.remove(policy_obj)
                db.session.commit()
        else:
            pass
        return jsonify(code=RET.OK, msg='Unbookmark success')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='Unbookmark failure')


# 获取收藏列表
@api_xiaocx.route('/CollectionList', methods=['POST'])
def collection_list():
    req_dict = request.get_json()
    name = req_dict.get("name")
    # key_word = req_dict.get("key_word")
    token = request.headers["token"]

    user_obj = verify_token(token)
    if not user_obj:
        return jsonify(code=RET.SESSIONERR, msg='User not logged in')
    user_id = user_obj.id
    try:
        data = []
        if name == 'land':
            obj_list = UserLand.query.filter(UserLand.user_id == user_id).order_by(UserLand.create_time.desc()).all()
            # obj_list = user_obj.carrier_land
            id_list = [obj.land_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = CarrierLand.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.land_name,
                    "district": obj.district_name,
                    "nature": obj.land_nature,
                    "area": obj.total_area,
                    "price_url": obj.price_url,
                    "lng": obj.lng,
                    "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'build':
            obj_list = UserBuild.query.filter(UserBuild.user_id == user_id).order_by(UserBuild.create_time.desc()).all()
            # obj_list = user_obj.carrier_build
            id_list = [obj.build_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = CarrierBuild.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.build_name,
                    "district": obj.district_name,
                    "rent": obj.rent_money,
                    "area": obj.build_area,
                    "price_url": obj.price_url,
                    "lng": obj.lng,
                    "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'factory':
            obj_list = UserFactory.query.filter(UserFactory.user_id == user_id).order_by(UserFactory.create_time.desc()).all()
            # obj_list = user_obj.carrier_factory
            id_list = [obj.factory_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = CarrierFactory.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.factory_name,
                    "district": obj.district_name,
                    "attract_industry": obj.attract_status,
                    "area": obj.factory_area,
                    "price_url": obj.price_url,
                    "lng": obj.lng,
                    "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'zone':
            obj_list = UserZone.query.filter(UserZone.user_id == user_id).order_by(UserZone.create_time.desc()).all()
            # obj_list = user_obj.industry_zone
            id_list = [obj.zone_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = Induzone.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.name,
                    "phone": obj.phone,
                    "industry_position": obj.industry_position,
                    "district": obj.district,
                    "price_url": obj.image,
                    "lng": obj.lng,
                    "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'project':
            obj_list = UserProject.query.filter(UserProject.user_id == user_id).order_by(UserProject.create_time.desc()).all()
            # obj_list = user_obj.project
            id_list = [obj.project_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = Project.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.name,
                    "district": obj.district,
                    "money": obj.money,
                    "attract_industry": obj.attract_industry,
                    # "lng": obj.lng,
                    # "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'company':
            obj_list = UserCompany.query.filter(UserCompany.user_id == user_id).order_by(UserCompany.create_time.desc()).all()
            # obj_list = user_obj.company
            id_list = [obj.company_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = Company.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "company_name": obj.company_name,
                    "district": obj.district,
                    "company_industry": obj.company_industry,
                    "lng": obj.lng,
                    "lat": obj.lat,
                }
                data.append(data_dic)

        elif name == 'policy':
            obj_list = UserPolicy.query.filter(UserPolicy.user_id == user_id).order_by(UserPolicy.create_time.desc()).all()
            # obj_list = user_obj.industry_policy
            id_list = [obj.policy_id for obj in obj_list]
            data = []
            for id in id_list:
                obj = InduPolicy.query.get(id)
                data_dic = {
                    "id": obj.id,
                    "name": obj.name,
                    "post_num": obj.post_num,
                    "industry": obj.industry,
                    "pubdate": obj.pubdate.strftime("%Y-%m-%d"),
                    "file": obj.file
                }
                data.append(data_dic)

        else:
            pass
        # data = sorted(data, key=lambda x: x['id'], reverse=True)

        return jsonify(code=RET.OK, data=data, msg='Query success')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='Query failure')


# 微信授权
@api_xiaocx.route("/WeChatLogin", methods=["POST"])
def wechat_login():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    code = req_dict.get('code')  # 微信登录code
    flag = req_dict.get('flag')  # 微信登录code
    print(flag)
    # 校验参数完整性
    if not all([code]):
        return jsonify(code=RET.PARAMERR, msg="Parameter incompleteness!")

    # app_id = 'wx67c0a99d684274f8'
    # app_secret = 'd89755bb5d2d3f85e97d0f08c30dbebc'
    if flag == 1:  # 投资晋城
        app_id = 'wx78f5fa8193a9d06a'
        app_secret = 'c7a57d430061fb4ca131e5148ff0e6fe'
    if flag == 2:  # jinlaitou
        app_id = 'wx67c0a99d684274f8'
        app_secret = 'd89755bb5d2d3f85e97d0f08c30dbebc'
    data = {"code": code}
    # 获取token
    url = u'https://api.weixin.qq.com/cgi-bin/token'
    params = {
        'appid': app_id,
        'secret': app_secret,
        'grant_type': 'client_credential'
    }

    try:
        res = requests.get(url, params=params).json()
        access_token = res['access_token']
        # 获取电话号码
        url1 = u"https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token={}".format(access_token)
        res1 = requests.post(url1, json=data).json()
        print(res1)
        user_info = ''
        if res1['errmsg'] == 'ok':
            mobile = res1['phone_info']["phoneNumber"]
            user_obj = User.query.filter_by(mobile=mobile).first()
            if user_obj:
                # 若成功保存登录状态
                token = create_token(user_obj.id)
                user_info = {
                    "flag": user_obj.flag,
                    "mobile": user_obj.mobile,
                    "token": token
                }

            else:
                user_obj = User(mobile=mobile, flag=1, status=1)
                db.session.add(user_obj)
                db.session.commit()
                # 若成功保存登录状态
                token = create_token(user_obj.id)
                user_info = {
                    "flag": 1,
                    "mobile": mobile,
                    "token": token
                }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="数据异常！")
    return jsonify(code=RET.OK, data=user_info, msg="微信登录成功。")


# 返回收藏状态
@api_xiaocx.route("/IsCollection", methods=["POST"])
def is_collection():
    req_dic = request.get_json()
    type = req_dic["type"]
    _id = req_dic["id"]
    token = request.headers["token"]

    user_obj = verify_token(token)
    if not user_obj:
        return jsonify(code=RET.SESSIONERR, msg='用户未登录。')

    if type == "land":
        land_obj = CarrierLand.query.get(_id)
        if land_obj in user_obj.carrier_land:
            return jsonify(code=RET.OK, data="True", msg="此地块为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此地块为未收藏状态。")

    if type == "build":
        build_obj = CarrierBuild.query.get(_id)
        if build_obj in user_obj.carrier_build:
            return jsonify(code=RET.OK, data="True", msg="此楼宇为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此楼宇为未收藏状态。")

    if type == "factory":
        factory_obj = CarrierFactory.query.get(_id)
        if factory_obj in user_obj.carrier_factory:
            return jsonify(code=RET.OK, data="True", msg="此厂房为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此厂房为未收藏状态。")

    if type == "zone":
        zone_obj = Induzone.query.get(_id)
        if zone_obj in user_obj.industry_zone:
            return jsonify(code=RET.OK, data="True", msg="此园区为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此园区为未收藏状态。")

    if type == "project":
        project_obj = Project.query.get(_id)
        if project_obj in user_obj.project:
            return jsonify(code=RET.OK, data="True", msg="此项目为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此项目为未收藏状态。")

    if type == "company":
        company_obj = Company.query.get(_id)
        if company_obj in user_obj.company:
            return jsonify(code=RET.OK, data="True", msg="此企业为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此企业为未收藏状态。")

    if type == "policy":
        policy_obj = InduPolicy.query.get(_id)
        if policy_obj in user_obj.industry_policy:
            return jsonify(code=RET.OK, data="True", msg="此楼宇为已收藏状态。")
        return jsonify(code=RET.OK, data="False", msg="此楼宇为未收藏状态。")
