import re

import requests
from elasticsearch import Elasticsearch
from flask import request, current_app, jsonify
from sqlalchemy import or_, and_

from apps.models import *
from apps.utils.response_code import RET
# from apps.utils.es_language import *
# from apps.view_carrier import api_carrier
from apps.util import verify_identity, verify_token, login_required
from apps.view_choose import api_address

"""选址评估页面"""


# 搜索行政区公共方法
def global_region(industry_id, preference, key_words, district_name, page, per_page):
    try:
        if key_words:
            carrier_obj = Induzone.query.filter(
                and_(
                    Induzone.region.like('%{}%'.format(district_name)) if district_name != '晋城市' else text(''),
                    Induzone.id.in_([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
                )).filter(
                or_(
                    Induzone.region.like("%" + key_words + "%"),
                    Induzone.cluster.like("%" + key_words + "%"),
                    Induzone.navigat.like("%" + key_words + "%"),
                    Induzone.cate.like("%" + key_words + "%")
                    ))
            if preference[0] == "true":  # 如果有政府扶持力度 --- 政策数的打分
                carrier_obj = carrier_obj.order_by(Induzone.policy_point.desc())
            if preference[1] == "true":  # 产业聚集度 --- 产业的打分
                carrier_obj = carrier_obj.outerjoin(CompanyIndustryPoint, Induzone.name == CompanyIndustryPoint.district).filter(
                    CompanyIndustryPoint.f_type == industry_id).order_by(CompanyIndustryPoint.point.desc()).all()
                carrier_obj = carrier_obj.outerjoin(CompanyIndustryPoint,
                                             Induzone.name == CompanyIndustryPoint.district).\
                                             order_by(CompanyIndustryPoint.point.desc()).all()

            if preference[2] == "true":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
                carrier_obj = carrier_obj.order_by(Induzone.mall_point.desc(), Induzone.hotel_point.desc(),
                                     Induzone.school_point.desc())

            if preference[3] == "true":  # 生活配套服务
                carrier_obj = carrier_obj.order_by(Induzone.live_point.desc())
            if preference[4] == "true":  # 交通 -----交通打分
                carrier_obj = carrier_obj.order_by(Induzone.traffic_point.desc())
        else:
            carrier_obj = Induzone.query.filter(
                and_(
                    Induzone.region.like('%{}%'.format(district_name)) if district_name != '晋城市' else text(''),
                    # Induzone.navigat.like('%{}%'.format(industry_name)) if industry_name else text(''),
                    Induzone.id.in_([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
                ))
            if preference[0] == "true":  # 如果有政府扶持力度 --- 政策数的打分
                carrier_obj = carrier_obj.order_by(Induzone.policy_point.desc())
            if preference[1] == "true":  # 产业聚集度 --- 产业的打分
                carrier_obj = carrier_obj.outerjoin(CompanyIndustryPoint, Induzone.name == CompanyIndustryPoint.district).filter(
                    CompanyIndustryPoint.f_type == industry_id).order_by(CompanyIndustryPoint.point.desc()).all()
            if preference[2] == "true":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
                carrier_obj = carrier_obj.order_by(Induzone.mall_point.desc(), Induzone.hotel_point.desc(),
                                     Induzone.school_point.desc())
            if preference[3] == "true":  # 生活配套服务
                carrier_obj = carrier_obj.order_by(Induzone.live_point.desc())
            if preference[4] == "true":  # 交通 -----交通打分
                carrier_obj = carrier_obj.order_by(Induzone.traffic_point.desc())

        # region_obj_list = carrier_obj.order_by(Induzone.upload_time.desc()).paginate(page, per_page).items
        region_obj_list = carrier_obj.paginate(page, per_page).items
        # region_obj_list = carrier_obj.all()
        carrier_size = len(region_obj_list)
        if region_obj_list:
            data_list = [{
                "id": region_obj.id,
                "carrier_type": '行政区',
                "region_name": region_obj.name if region_obj.name else '',
                "cover_region_area": region_obj.area if region_obj.area else '',
                "gdp": region_obj.gdp if region_obj.gdp else '',
                "detail_address": region_obj.address if region_obj.address else '',  # 审核信息
                "industry_name": region_obj.navigat if region_obj.navigat else '',
                "district_name": region_obj.region if region_obj.region else '',
                "price_url": region_obj.image if region_obj.image else '',
                "lng": region_obj.lng if region_obj.lng else '',
                "lat": region_obj.lat if region_obj.lat else ''
            } for region_obj in region_obj_list]
            data = {"code": RET.OK, "data": {"data_list": data_list, "size": carrier_size, "msg": "行政区 数据获取成功！"}}
            return data
        else:
            data = {"code": RET.DATAERR, "msg": "没有符合搜索条件的 行政区 数据！"}
            return data
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        data = {"code": RET.DBERR, "msg": "行政区 查询数据库错误！"}
        return data


# 土地公共方法
def global_land(key_words, district_name, land_name, land_nature, industry_name, page, per_page):
    try:
        if key_words:
            carrier_obj = CarrierLand.query.filter(
                and_(CarrierLand.land_name.like('%{}%'.format(land_name)) if land_name else text(''),
                     CarrierLand.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierLand.land_nature.like('%{}%'.format(land_nature)) if land_nature else text(''),
                     CarrierLand.audit_status == 1
                     )).filter(
                or_(
                    CarrierLand.district_name.like("%" + key_words + "%"),
                    CarrierLand.land_name.like("%" + key_words + "%")
                    ))
        else:
            carrier_obj = CarrierLand.query.filter(
                     CarrierLand.land_name.like('%{}%'.format(land_name)) if land_name else text(''),
                     CarrierLand.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierLand.land_nature == land_nature if land_nature else text(''),
                     CarrierLand.audit_status == 1
                     )

        land_obj_list = carrier_obj.order_by(CarrierLand.upload_time.desc()).paginate(page, per_page).items
        carrier_size = len(land_obj_list)
        if land_obj_list:
            data_list = [{
                "id": land_obj.id,
                "carrier_type": "土地",
                "land_name": land_obj.land_name,
                "land_nature": land_obj.land_nature,
                "total_area": land_obj.total_area,
                "district_name": land_obj.district_name,
                "price_url": land_obj.price_url,
                "lng": land_obj.lng,
                "lat": land_obj.lat
            } for land_obj in land_obj_list]
            data = {"code": RET.OK, "data": {"data_list": data_list, "size": carrier_size, "msg": "土地 数据获取成功！"}}
            return data
        else:
            data = {"code": RET.DATAERR, "msg": "没有符合搜索条件的 土地 数据！"}
            return data
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        data = {"code": RET.DBERR, "msg": "土地 查询数据库错误！"}
        return data


# 厂房公共方法
def global_factory(key_words, district_name, factory_name, industry_name, page, per_page):
    try:
        if key_words:
            carrier_obj = CarrierFactory.query.filter(
                and_(CarrierFactory.factory_name.like('%{}%'.format(factory_name)) if factory_name else text(''),
                     CarrierFactory.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierFactory.attract_status.like('%{}%'.format(industry_name)) if industry_name else text(''),
                     CarrierFactory.audit_status == 1
                     )).filter(
                or_(CarrierFactory.attract_status.like("%" + key_words + "%"),
                    CarrierFactory.district_name.like("%" + key_words + "%"),
                    CarrierFactory.factory_name.like("%" + key_words + "%")
                    ))
            carrier_size = carrier_obj.count()

        else:
            carrier_obj = CarrierFactory.query.filter(
                     CarrierFactory.factory_name.like('%{}%'.format(factory_name)) if factory_name else text(''),
                     CarrierFactory.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierFactory.attract_status.like('%{}%'.format(industry_name)) if industry_name else text(''),
                     CarrierFactory.audit_status == 1
                     )
            carrier_size = carrier_obj.count()
        factory_obj_list = carrier_obj.order_by(CarrierFactory.upload_time.desc()).paginate(page, per_page).items
        if factory_obj_list:
            data_list = [{
                "id": factory_obj.id,
                "carrier_type": "标准厂房",
                "factory_name": factory_obj.factory_name,
                "factory_area": factory_obj.factory_area,
                "district_name": factory_obj.district_name,  # 审核信息
                "detail_address": factory_obj.detail_address,
                "industry_name": factory_obj.attract_status,
                "is_standard": factory_obj.is_standard,
                "attract_status": factory_obj.attract_status,
                "price_url": factory_obj.outer_picture_url,
                "lng": factory_obj.lng,
                "lat": factory_obj.lat
            } for factory_obj in factory_obj_list]
            data = {"code": RET.OK, "data": {"data_list": data_list, "size": carrier_size, "msg": "厂房 数据获取成功！"}}
            return data
        else:
            data = {"code": RET.DATAERR, "msg": "没有符合搜索条件的 厂房 数据！"}
            return data
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        data = {"code": RET.DBERR, "msg": "厂房 查询数据库错误！"}
        return data


# 楼宇公共方法
def global_build(key_words, district_name, build_name, industry_name, build_type, page, per_page):
    try:
        if key_words:
            carrier_obj = CarrierBuild.query.filter(
                and_(CarrierBuild.build_name.like('%{}%'.format(build_name)) if build_name else text(''),
                     CarrierBuild.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierBuild.build_type.like('%{}%'.format(build_type)) if build_type else text(''),
                     CarrierBuild.attract_status.like('%{}%'.format(industry_name)) if industry_name else text(''),
                     CarrierBuild.audit_status == 1
                     )).filter(
                or_(CarrierBuild.attract_status.like("%" + key_words + "%"),
                    CarrierBuild.district_name.like("%" + key_words + "%"),
                    CarrierBuild.build_name.like("%" + key_words + "%"),
                    CarrierBuild.build_type.like("%" + key_words + "%")
                    ))
        else:
            carrier_obj = CarrierBuild.query.filter(
                     CarrierBuild.build_name.like('%{}%'.format(build_name)) if build_name else text(''),
                     CarrierBuild.district_name == district_name if district_name != '晋城市' else text(''),
                     CarrierBuild.build_type.like('%{}%'.format(build_type)) if build_type else text(''),
                     CarrierBuild.attract_status.like('%{}%'.format(industry_name)) if industry_name else text(''),
                     CarrierBuild.audit_status == 1
                     )

        build_obj_list = carrier_obj.order_by(CarrierBuild.upload_time.desc()).paginate(page, per_page).items
        carrier_size = len(build_obj_list)
        if build_obj_list:
            data_list = [{
                "id": build_obj.id,
                "carrier_type": "商业楼宇",
                "district_name": build_obj.district_name,
                "build_name": build_obj.build_name,
                "build_area": build_obj.build_area,
                "detail_address": build_obj.detail_address,  # 审核信息
                # "industry_name": build_obj.industry_name,
                "layer_num": build_obj.layer_num,
                "build_type": build_obj.build_type,
                "attract_status": build_obj.attract_status,
                "rent_money": build_obj.rent_money,
                "price_url": build_obj.price_url,
                "lng": build_obj.lng,
                "lat": build_obj.lat
            } for build_obj in build_obj_list]
            data = {"code": RET.OK, "data": {"data_list": data_list, "size": carrier_size, "msg": "楼宇 数据获取成功！"}}
            return data
        else:
            data = {"code": RET.DATAERR, "msg": "没有符合搜索条件的 楼宇 数据！"}
            return data
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        data = {"code": RET.DBERR, "msg": "楼宇 查询数据库错误！"}
        return data


def get_district_name(token):
    try:
        user = verify_token(token)
        user_id = user.id  # 用户id
        # 查出做此操作的用户名
        user_obj = User.query.get(user_id)
        district_name1 = user_obj.belong_organization  # 所属区县
        if not district_name1:
            return jsonify(code=RET.NODATA, msg="权限错误，请设置用户所属单位！")
        if '晋城市' in district_name1:
            return "晋城市"
        else:
            if '沁水' in district_name1:
                return '沁水县'
            if '高平' in district_name1:
                return '高平市'
            if '阳城' in district_name1:
                return '阳城县'
            if '陵川' in district_name1:
                return '陵川县'
            if '泽州' in district_name1:
                return '泽州县'
            if '城区' in district_name1:
                return '城区'
            if '晋城经济技' in district_name1:
                return '晋城经济技术开发区'
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")


# 土地条件搜索功能
@api_address.route("/SearchLand", methods=["POST"])
def search_land():
    req_dict = request.get_json()
    key_words = req_dict['key_words']
    district_name = req_dict['district_name']
    land_name = req_dict['land_name']
    land_nature = req_dict['land_nature']
    industry_name = req_dict['industry_name']
    # total_area_id = req_dict['total_area_id']
    # transfer_year_id = req_dict['transfer_year_id']
    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小
    token = request.headers['token']
    if not district_name:
        district_name = get_district_name(token)
    data = global_land(key_words, district_name, land_name, land_nature, industry_name, page, per_page)
    return jsonify(data)


# 厂房条件搜索功能
@api_address.route("/SearchFactory", methods=["POST"])
def search_factory():
    req_dict = request.get_json()
    key_words = req_dict['key_words']  # 关键字
    factory_name = req_dict['factory_name']  # 厂房名称
    industry_name = req_dict['industry_name']  # 产业类型
    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小
    token = request.headers['token']

    district_name = req_dict['district_name']  # 区域名称
    if not district_name:
        district_name = get_district_name(token)

    data = global_factory(key_words, district_name, factory_name, industry_name, page, per_page)
    return jsonify(data)


# 楼宇条件搜索功能
@api_address.route("/SearchBuild", methods=["POST"])
def search_build():
    req_dict = request.get_json()
    key_words = req_dict['key_words']  # 关键字
    district_name = req_dict['district_name']  # 区域名称
    build_name = req_dict['build_name']  # 楼宇名称
    industry_name = req_dict['industry_name']  # 产业类型（名称）
    build_type = req_dict['build_type']  # 楼宇类型id（商铺/写字楼）
    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小
    token = request.headers['token']
    if not district_name:
        district_name = get_district_name(token)
    data = global_build(key_words, district_name, build_name, industry_name, build_type, page, per_page)
    return jsonify(data)


# 全部搜索功能
@api_address.route("/SearchAll", methods=["POST"])
@login_required
def search_all():
    req_dict = request.get_json()
    key_words = req_dict['key_words']  # 关键字
    industry_name = req_dict['industry_name']  # 所属行业
    district_name = req_dict['district_name']  # 所属区县
    carrier_type_id = req_dict['carrier_type_id']  # 载体类型id（1：园区；2：土地；3：楼宇；4：厂房。）
    preference = req_dict.get("preference")  # 选址偏好 [f,f,t,f,f,f]
    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小
    token = request.headers['token']

    if any([preference[0], preference[1], preference[2], preference[3], preference[4]]):
        if not industry_name:
            return jsonify(code=RET.PARAMERR, msg="选择选址偏好时，必须选择所属行业！")
    industry_id = ''
    if industry_name:
        industry_id = IndustryChain.query.filter(IndustryChain.industry_name.like("%{}%".format(industry_name))).first()
    if not district_name:
        district_name = get_district_name(token)

    data_list = []
    if carrier_type_id == 0:
        # 行政区
        if not industry_name:
            region_data = global_region(industry_id, preference, key_words, district_name,
                                        page, per_page)
            data_list.append(region_data)
        # 土地
        if not industry_name:
            land_data = global_land(key_words, district_name, '', '', '', page, per_page)
            data_list.append(land_data)
        # 厂房
        factory_data = global_factory(key_words, district_name, '', industry_name, page, per_page)
        data_list.append(factory_data)
        # 楼宇
        build_data = global_build(key_words, district_name, '', industry_name, '', page, per_page)
        data_list.append(build_data)
        return jsonify(code=RET.OK, data=data_list, msg='全部数据查询成功！')
    if carrier_type_id == 1 and not industry_name:  # 土地
        data = global_land(key_words, district_name, '', '', '', page, per_page)
        return jsonify(data)
    if carrier_type_id == 2:  # 厂房
        data = global_factory(key_words, district_name, '', industry_name, page, per_page)
        return jsonify(data)
    if carrier_type_id == 3:  # 楼宇
        data = global_build(key_words, district_name, '', industry_name, '', page, per_page)
        return jsonify(data)
    else:
        data = {"code": RET.PARAMERR, "msg": '参数错误！'}
        return jsonify(data)
