"""
更新企业是否为链主字段
"""
# # -*- coding:utf-8 -*-
import threading

import pandas as pd

from apps.models import IndustryChain, Enterprise, Company
from manager import app
from apps import db

"""
根据资质计算企业的热度，并提交保存
"""

# 读取链主企业文件
xl_path = "晋城链主企业.xlsx"
data = pd.read_excel(xl_path)
com_li = []
for i in range(len(data)):
    com_name = str(data.loc[i, "企业名称"])
    com_li.append(com_name)


def handle():
    with app.app_context():
        company_obj_list = Company.query.all()
        # 读取企业数据表的资质
        i = 0
        for company_obj in company_obj_list:
            company_name = company_obj.company_name
            if company_name in com_li:
                company_obj.chain_master = '1'
                db.session.commit()
                i += 1
            else:
                company_obj.chain_master = '0'
                db.session.commit()
        print('已完成，一共{}个'.format(i))


if __name__ == '__main__':
    t = threading.Thread(target=handle)
    t.start()
