from flask import g, current_app, request, jsonify, session
from apps.attract import api_att
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
import json
import requests
from apps import db, constants, redis_store

'''本页接口使用全国企业库enterprise'''
graph = conn_neo4j()


# 全国企业条件选择导航(类型，资质，上市，融资)
@api_att.route('/attract/field', methods=['GET'])
@login_required
def field():
    '''太原市企业条件选择导航获取'''
    try:
        property = Property.query.filter_by(statu=1)

        typy = property.filter_by(sid=1, statu=1).all()
        qualificat = property.filter_by(sid=2, statu=1).all()
        quoted = property.filter_by(sid=3, statu=1).all()
        financ = property.filter_by(sid=4, statu=1).all()

        data = {"entype": [{"label": i.name, "value": i.nid} for i in typy],
                "qualificat": [{"label": i.name, "value": i.nid} for i in qualificat],
                "quoted": [{"label": i.name, "value": i.nid} for i in quoted],
                "financ": [{"label": i.name, "value": i.nid} for i in financ],
                "buildate": [{"label": "1-3年", "value": 1}, {"label": "3-5年", "value": 2},
                             {"label": "5-8年", "value": 3}, {"label": "8-10年", "value": 4},
                             {"label": "10-15年", "value": 5}, {"label": "15年以上", "value": 6}],
                "capital": [{"label": "100万以内", "value": 1}, {"label": "100万-500万", "value": 2},
                            {"label": "500万-1000万", "value": 3}, {"label": "1000万-5000万", "value": 4},
                            {"label": "5000万-1亿", "value": 5}, {"label": "1亿以上", "value": 6}]
                }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", options=data)


# 全国企业列表
@api_att.route('/attract/enterprise', methods=['POST'])
# @login_required
def enterprise():
    '''
    太原市企业列表
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    product = req_dict.get("product")  # 产业产品选择
    company_name = req_dict.get("company_name")  # 产业产品名称筛选
    sorts = req_dict.get("sorts")  # 排序 sorts "1"按时间降序 ，“2”按热度降序

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:  # 子行业分类
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 企业类型
        if entype:
            enterprise = enterprise.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                enterprise = enterprise.filter_by(high_new=1)
            if qualificat == 2:
                enterprise = enterprise.filter_by(tbe=1)
            if qualificat == 3:
                enterprise = enterprise.filter_by(quoted_company=1)
            if qualificat == 4:
                enterprise = enterprise.filter_by(isfive=1)
            if qualificat == 5:
                enterprise = enterprise.filter_by(unicorn=1)
            if qualificat == 6:
                enterprise = enterprise.filter_by(dengl=1)

        # 注册资本
        if capital:
            enterprise = enterprise.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            enterprise = enterprise.filter_by(public_id=quoted)
        # 区域选择
        if province:
            enterprise = enterprise.filter_by(province=province)
            if city:
                enterprise = enterprise.filter_by(city=city)
                if district:
                    enterprise = enterprise.filter_by(district=district)
        # 成立时间id
        if yearid:
            enterprise = enterprise.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            enterprise = enterprise.filter_by(roundid=roundid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
            # enterprise = enterprise.filter(Enterprise.product_all.ilike())
        if company_name:
            enterprise = enterprise.filter(Enterprise.company_name.like("%{}%".format(company_name)))
        # print(enterprise)
        size = enterprise.count()
        if sorts=="1":
            enterprise = enterprise.order_by(Enterprise.build_date.desc()).paginate(page, perpage).items  # 企业热度倒序
        else:
            enterprise = enterprise.order_by(Enterprise.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": i.id,
               "company_name": i.company_name,
               "hots": i.hots} for i in enterprise]
        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 通过like查询
def find_up(name_query, relation, area):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    sql = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res = graph.run(sql).data()
    # cnums = Enterprise.query.filter_by(stream="{}".format(relation[:2]), c_type=inid).count()

    data = {"clickable": False,
            "node": "{}".format(relation[:2]),
            "level": 1,
            "subNodeList": [],
            # "count": cnums
            }
    past = list()
    for it in res:
        productName = it["m.name"]
        if productName in past:
            continue
        past.append(productName)
        if area[0]:
            enterprise = Enterprise.query.filter_by(province=area[0])
            if area[1]:
                enterprise = enterprise.filter_by(city=area[1])
                if area[2]:
                    enterprise = enterprise.filter_by(district=area[2])
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(productName)))
        else:
            enterprise = Enterprise.query.filter(Enterprise.product_all.like("%{}%".format(productName)))

        erjicount = enterprise.count()
        node = {"clickable": True,
                "node": "{}".format(productName),
                "level": 2,
                "count": erjicount,
                "subNodeList": []
                }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(productName)
        result = graph.run(sql_02).data()

        for item in result:
            productName = item["m.name"]

            if area[0]:
                enterprise = Enterprise.query.filter_by(province=area[0])
                if area[1]:
                    enterprise = enterprise.filter_by(city=area[1])
                    if area[2]:
                        enterprise = enterprise.filter_by(district=area[2])
                enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(productName)))
            else:
                enterprise = Enterprise.query.filter(Enterprise.product_all.like("%{}%".format(productName)))

            count = enterprise.count()

            erjicount += count
            node["subNodeList"].append({"clickable": True,
                                        "node": "{}".format(productName),
                                        "level": 3,
                                        "count": count,
                                        "subNodeList": []
                                        })
        node["count"] = erjicount
        data["subNodeList"].append(node)

    return data


# 创建body
def create_body(args_query, args_term):
    body = {
        "query": {
            "bool": {
                "must": [{"multi_match": {"query": "{}".format(args_query["query"]),  # match_phrase来实现完全匹配查询。
                                          "type": "phrase",
                                          "fields": [
                                              "product"
                                          ],
                                          "slop": 0,
                                          }
                          },
                         ]
            }
        },
        "from": 0,
        "size": 10,
        "sort": [],
        "aggs": {},
        "_source": ['company_name'],

    }

    for k, v in args_term.items():
        body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})

    return body


# 通过es全匹配查询
def find_up_by_es(name_query, relation, area):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    args_term = dict()  # 省市区条件
    if area[0]:
        args_term['province'] = area[0]
    if area[1]:
        args_term['city'] = area[1]
    if area[2]:
        args_term['district'] = area[2]
    url = "http://127.0.0.1:9200/ty_cur/_search"

    sql = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res = graph.run(sql).data()
    res = list(set([i["m.name"] for i in list(res)]))  # 不重复的一级节点
    data = {"clickable": False,
            "node": "{}".format(relation[:2]),
            "level": 1,
            "subNodeList": [],
            # "count": cnums
            }

    for it in res:
        productName = it

        # es全匹配查询企业数量
        args_query = dict()  # 产品
        args_query["query"] = productName
        body = create_body(args_query, args_term)
        result_es = json.loads(requests.post(url=url, json=body).text)
        erjicount = int(result_es["hits"]["total"])

        node = {"clickable": True,
                "node": "{}".format(productName),
                "level": 2,
                "count": erjicount,
                "subNodeList": []
                }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(productName)
        result = graph.run(sql_02).data()

        for item in result:
            productName = item["m.name"]
            # es全匹配查询企业数量
            args_query = dict()  # 产品
            args_query["query"] = productName
            body = create_body(args_query, args_term)
            result_es = json.loads(requests.post(url=url, json=body).text)
            count = int(result_es["hits"]["total"])

            erjicount += count
            node["subNodeList"].append({"clickable": True,
                                        "node": "{}".format(productName),
                                        "level": 3,
                                        "count": count,
                                        "subNodeList": []
                                        })
        node["count"] = erjicount
        data["subNodeList"].append(node)

    return data


# 通过es全匹配查询三级
def find_thr_by_es(inid, name_query, relation, area):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    args_term = dict()  # 省市区条件
    if area[0]:
        args_term['province'] = area[0]
    if area[1]:
        args_term['city'] = area[1]
    if area[2]:
        args_term['district'] = area[2]
    args_term['c_type'] = inid  # 指定二级企业分类
    # url = "http://127.0.0.1:9200/ty_cur/_search"
    # url = "http://127.0.0.1:9200/ty_all_enterprise/_search"
    url = "http://127.0.0.1:9200/ty_enterprise/_search"

    sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res_zero = graph.run(sql_01).data()
    res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
    data = {"clickable": False,
            "node": "{}".format(relation[:2]),
            "level": 1,
            "subNodeList": [],
            # "count": cnums
            }

    for it in res_one:
        pname_one = it

        # es全匹配查询企业数量
        args_query = dict()  # 产品
        args_query["query"] = pname_one
        body = create_body(args_query, args_term)
        result_es = json.loads(requests.post(url=url, json=body).text)
        erjicount = int(result_es["hits"]["total"])

        node_one = {"clickable": True,
                    "node": "{}".format(pname_one),
                    "level": 2,
                    "count": erjicount,
                    "subNodeList": []
                    }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
        result = graph.run(sql_02).data()
        result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
        for item in result:
            pname_two = item
            # es全匹配查询企业数量
            args_query = dict()  # 产品
            args_query["query"] = pname_two
            body = create_body(args_query, args_term)
            result_es = json.loads(requests.post(url=url, json=body).text)
            count2 = int(result_es["hits"]["total"])
            # 二级节点
            node_two = {"clickable": True,
                        "node": "{}".format(pname_two),
                        "level": 3,
                        "count": count2,
                        "subNodeList": []
                        }
            sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
            result3 = graph.run(sql_03).data()
            result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
            for itm in result3:
                pname_thr = itm
                args_query = dict()  # 产品
                args_query["query"] = pname_thr
                body = create_body(args_query, args_term)
                result_es = json.loads(requests.post(url=url, json=body).text)
                count3 = int(result_es["hits"]["total"])
                # 三级
                node_thr = {"clickable": True,
                            "node": "{}".format(pname_thr),
                            "level": 4,
                            "count": count3,
                            "subNodeList": []
                            }
                node_two["subNodeList"].append(node_thr)
            node_one["subNodeList"].append(node_two)
        data["subNodeList"].append(node_one)

    return data


# 行业产品公司数量(链图)
@api_att.route('/attract/chain', methods=['POST'])
# @login_required
def attract_chain():
    '''行业id->行业链标题-》上中下游-》查询数值'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）
    area = req_dict.get("area")  # ["","",""] 省市区

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        name_query = "att" + str(inid) + str("".join(area))
        if redis_store.get(name_query) is not None:
            data = json.loads(redis_store.get(name_query))
            return jsonify(code=RET.OK, msg="获取成功", data=data)

        # 行业使用名
        industryName = Industry.query.filter_by(nid=inid).first().oname
        ptp = neo4j_dict()

        if industryName in ptp:
            industryName = ptp[industryName]
        result = {
            "industryChain": industryName,
            "nodeList": [find_thr_by_es(inid, industryName, "上游行业", area),
                         find_thr_by_es(inid, industryName, "中游行业", area),
                         find_thr_by_es(inid, industryName, "下游行业", area)]
        }
        # redis缓存
        redis_store.set(name_query, json.dumps(result))
        redis_store.expire(name_query, 30 * 24 * 3600)
        print("redis")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=result)


# 颜色计数
def jishu(num):
    if num >= 0 and num <= 50:
        return "#72D4F1"
    if num > 50 and num <= 100:
        return "#00BAF6"
    if num > 100 and num <= 200:
        return "#4F9FFF"
    if num > 200 and num <= 500:
        return "#4265F6"
    if num > 500 and num <= 1000:
        return "#0052d6"
    if num > 1000:
        return "#0245AE"


# (112.56937550968271, 37.87982942385603)
# 招商地图下的色块图(同右侧得数量分布饼图)
@api_att.route('/attract/map', methods=['POST'])
# @login_required
def attract_map():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id

    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    product = req_dict.get("product")  # 产业产品选择

    try:
        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 企业类型
        if entype:
            enterprise = enterprise.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                enterprise = enterprise.filter_by(high_new=1)
            if qualificat == 2:
                enterprise = enterprise.filter_by(tbe=1)
            if qualificat == 3:
                enterprise = enterprise.filter_by(quoted_company=1)
            if qualificat == 4:
                enterprise = enterprise.filter_by(isfive=1)
            if qualificat == 5:
                enterprise = enterprise.filter_by(unicorn=1)
            if qualificat == 6:
                enterprise = enterprise.filter_by(dengl=1)

        # 注册资本
        if capital:
            enterprise = enterprise.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            enterprise = enterprise.filter_by(public_id=quoted)
        # 成立时间id
        if yearid:
            enterprise = enterprise.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            enterprise = enterprise.filter_by(roundid=roundid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                province_data = Enterprise.query.filter_by(province=pro).first()
                df.append({"name": pro,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": province_data.p_lng, "lat": province_data.p_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                city_data = Enterprise.query.filter_by(province=province, city=cit).first()
                df.append({"name": cit,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": city_data.c_lng, "lat": city_data.c_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                district_data = Enterprise.query.filter_by(province=province, city=city, district=dis).first()
                df.append({"name": dis,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            district_data = Enterprise.query.filter_by(province=province, city=city, district=district).first()
            df.append({"name": district,
                       "value": num,
                       "color": "",
                       "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})
            return jsonify(code=RET.OK, msg="获取成功", data=df)

        return jsonify(code=RET.DATAERR, msg="地区参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 为右侧全国地图企业数据
@api_att.route('/attract/cnums', methods=['POST'])
# @login_required
def attract_cnums():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id

    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    product = req_dict.get("product")  # 产业产品选择

    try:
        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 企业类型
        if entype:
            enterprise = enterprise.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                enterprise = enterprise.filter_by(high_new=1)
            if qualificat == 2:
                enterprise = enterprise.filter_by(tbe=1)
            if qualificat == 3:
                enterprise = enterprise.filter_by(quoted_company=1)
            if qualificat == 4:
                enterprise = enterprise.filter_by(isfive=1)
            if qualificat == 5:
                enterprise = enterprise.filter_by(unicorn=1)
            if qualificat == 6:
                enterprise = enterprise.filter_by(dengl=1)

        # 注册资本
        if capital:
            enterprise = enterprise.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            enterprise = enterprise.filter_by(public_id=quoted)
        # 成立时间id
        if yearid:
            enterprise = enterprise.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            enterprise = enterprise.filter_by(roundid=roundid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                df.append({"name": pro, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                df.append({"name": cit,"value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                df.append({"name": dis,"value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            df.append({"name": district,"value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])

        return jsonify(code=RET.DATAERR, msg="地区参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 招商地图下的散点图（至区后）
@api_att.route('/attract/sdmap', methods=['POST'])
# @login_required
def attract_sdmap():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    capital = req_dict.get("capital")  # 注册资本id
    quoted = req_dict.get("quoted")  # 上市板块
    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    yearid = req_dict.get("yearid")  # 成立时间年限id
    roundid = req_dict.get("roundid")  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    product = req_dict.get("product")  # 产业产品选择

    # 校验参数完整性
    if not all([province, city, district]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 企业类型
        if entype:
            enterprise = enterprise.filter_by(entypeid=entype)
        # 企业资质
        if qualificat:
            if qualificat == 1:
                enterprise = enterprise.filter_by(high_new=1)
            if qualificat == 2:
                enterprise = enterprise.filter_by(tbe=1)
            if qualificat == 3:
                enterprise = enterprise.filter_by(quoted_company=1)
            if qualificat == 4:
                enterprise = enterprise.filter_by(isfive=1)
            if qualificat == 5:
                enterprise = enterprise.filter_by(unicorn=1)
            if qualificat == 6:
                enterprise = enterprise.filter_by(dengl=1)
        # 注册资本
        if capital:
            enterprise = enterprise.filter_by(capital_id=capital)
        # 上市板块
        if quoted:
            enterprise = enterprise.filter_by(public_id=quoted)
        # 区域选择
        if district:
            # enterprise = enterprise.filter_by(district=district)
            enterprise = enterprise.filter_by(province=province, city=city, district=district)
        # 成立时间id
        if yearid:
            enterprise = enterprise.filter_by(yearid=yearid)
        # 融资轮次
        if roundid:
            enterprise = enterprise.filter_by(roundid=roundid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
            # enterprise = enterprise.filter_by(province=province, city=city, district=district).all()
        enterprise = enterprise.all()
        data = []
        for com in enterprise:
            data.append({"id": com.id,
                         "name": com.company_name,
                         "jwd": {"lng": com.lng,  # 企业地址出的经纬度
                                 "lat": com.lat}
                         })  # 上下中游

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 全国企业信息详情（已经启用，改用360页企业详情）
@api_att.route('/enterprise/detail', methods=['POST'])
@login_required
def enter_detail():
    '''
    企业信息详情
    :return:
    '''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Enterprise.query.get(_id)
        user = User.query.get(user_id)  # 获取关注列表
        if user:
            enters_ids = [coms.id for coms in user.enterprise]
        else:
            enters_ids = []
        if company:
            data = {"id": company.id,
                    "company_name": company.company_name,
                    "telephone": company.telephone if company.telephone else "-",
                    "web_site": company.web_site if company.web_site else "-",
                    "email": company.email if company.email else "-",
                    "address": company.address if company.address else "-",
                    "jwd": {"lng": company.lng if company.lng else "-",
                            "lat": company.lat if company.lat else "-"},
                    "company_info": company.company_info if company.company_info else "-",
                    "high_new": "高新技术企业" if company.high_new else "-",
                    "legal": company.legal if company.legal else "-",
                    "status": company.status if company.status else "-",
                    "build_date": str(company.build_date)[:10] if company.build_date else "-",
                    "capital": company.capital if company.capital else "-",
                    "social_code": company.social_code if company.social_code else "-",
                    "taking": company.takingn if company.takingn else "-",
                    "bao": company.bao_num if company.bao_num else "-",
                    "entype": company.entype if company.entype else "-",
                    "industry": company.company_industry if company.company_industry else "-",
                    "scope": company.business_scope if company.business_scope else "-",
                    "collect": "1" if company.id in enters_ids else "2",  # 关注状态码1关注，2未关注
                    "choice": "2"  # 1太原企业，2全国企业
                    }
        else:
            return jsonify(code=RET.NODATA, msg="查无数据")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)
