from datetime import datetime
# Werkzeug库的security实现散列密码的计算
from werkzeug.security import generate_password_hash, check_password_hash
from itsdangerous import TimedJSONWebSignatureSerializer as Serializer
from apps import constants
from . import db
from config import Config
from sqlalchemy import text


class BaseModel:
    """
    模型基类，补充创建时间与更新时间
    """
    create_time = db.Column(db.DateTime, default=datetime.now, doc='创建时间', comment='创建时间')  # 记录的创建时间
    update_time = db.Column(db.DateTime, default=datetime.now, onupdate=datetime.now, doc='更新时间', comment='更新时间')  # 记录的更新时间


# 全国企业
class Enterprise(db.Model):
    __tablename__ = "enterprise"

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='企业主键id', comment='企业主键id主键id')  # 企业
    company_name = db.Column(db.String(255), index=True, doc='企业名', comment='企业名')  # 企业名
    status = db.Column(db.String(32), doc='经营状态', comment='经营状态')  # 经营状态
    legal = db.Column(db.String(255), doc='发定代表人', comment='发定代表人')  # 发定代表人
    capital = db.Column(db.String(255), doc='注册资本,22万美元', comment='注册资本,22万美元')  # 注册资本,22万美元
    capital_nums = db.Column(db.Float, doc='注册资本转换成人民币数值', comment='注册资本转换成人民币数值')  # 注册资本转换成人民币数值
    capital_id = db.Column(db.Integer, doc='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6', comment='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6')  # 注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6
    build_date = db.Column(db.DateTime, doc='注册时间', comment='注册时间')  # 注册时间
    yearid = db.Column(db.Integer, index=True, doc='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）', comment='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）')  # 成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）
    province = db.Column(db.String(32), index=True, doc='省', comment='省')  # 省
    city = db.Column(db.String(32), index=True, doc='市', comment='市')  # 市
    district = db.Column(db.String(32), index=True, doc='区', comment='区')  # 区
    lng = db.Column(db.String(100), doc='经度', comment='经度')  # 经度
    lat = db.Column(db.String(100), doc='纬度', comment='纬度')  # 纬度
    p_lng = db.Column(db.String(100), doc='省经度', comment='省经度')  # 省经度
    p_lat = db.Column(db.String(100), doc='省纬度', comment='省纬度')  # 省纬度
    c_lng = db.Column(db.String(100), doc='市经度', comment='市经度')  # 市经度
    c_lat = db.Column(db.String(100), doc='市纬度', comment='市纬度')  # 市纬度
    d_lng = db.Column(db.String(100), doc='区经度', comment='区经度')  # 区经度
    d_lat = db.Column(db.String(100), doc='区纬度', comment='区纬度')  # 区纬度
    address = db.Column(db.String(255), doc='企业地址', comment='企业地址')  # 企业地址
    telephone = db.Column(db.Text, doc='电话', comment='电话')  # 电话
    telephone_more = db.Column(db.Text, doc='更多电话', comment='更多电话')  # 更多电话
    email = db.Column(db.Text, doc='邮箱', comment='邮箱')  # 邮箱
    social_code = db.Column(db.String(100), doc='统一社会信用代码', comment='统一社会信用代码')  # 统一社会信用代码
    tax_code = db.Column(db.String(100), doc='纳税人识别号', comment='纳税人识别号')  # 纳税人识别号
    register_code = db.Column(db.String(100), doc='注册号', comment='注册号')  # 注册号
    company_code = db.Column(db.String(100), doc='组织机构代码', comment='组织机构代码')  # 组织机构代码
    bao_num = db.Column(db.Integer, doc='参保人数', comment='参保人数')  # 参保人数
    entype = db.Column(db.String(100), doc='企业类型', comment='企业类型')  # 企业类型
    entypeid = db.Column(db.Integer, index=True, doc='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)', comment='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)')  # 公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)
    scale_range = db.Column(db.Integer, index=True, doc='企业规模id，1：20人以下，2:20-99人，3:100-499人，4：500-999人，5： 1000-4999人，6：5000-9999人，7:10000人', comment='企业规模id，1：20人以下，2:20-99人，3:100-499人，4：500-999人，5： 1000-4999人，6：5000-9999人，7:10000人')

    company_industry = db.Column(db.String(100), doc='所属行业', comment='所属行业')  # 所属行业
    web_site = db.Column(db.String(255), doc='企业网址', comment='企业网址')  # 企业网址
    business_scope = db.Column(db.Text, doc='企业经营范围', comment='企业经营范围')  # 企业经营范围
    money_type = db.Column(db.String(100), doc='注册币种', comment='注册币种')  # 注册币种
    money_type_id = db.Column(db.Integer, doc='注册币种类型id', comment='注册币种类型id')  # 注册币种类型id

    high_new = db.Column(db.String(32), doc='是否高新技术企业', comment='是否高新技术企业')  # 是否高新技术企业
    parti_year = db.Column(db.Integer, doc='高新企业注册年份', comment='高新企业注册年份')  # 高新企业注册年份
    tbe = db.Column(db.String(32), doc='是否科技型中小企业', comment='是否科技型中小企业')  # 是否科技型中小企业
    tbe_sjmy = db.Column(db.String(32), doc='是否为省级民营科技企业', comment='是否为省级民营科技企业')  # 省级民营科技企业
    zjtg = db.Column(db.String(32), doc='是否为专精特新企业', comment='是否为专精特新企业')  # 山西专精特工企业
    zjtg_gjjxjr = db.Column(db.String(32), doc='是否为国家级专精特新小巨人企业', comment='是否为国家级专精特新小巨人企业')  # 国家级专精特新小巨人企业
    zjtg_sjxjr = db.Column(db.String(32), doc='是否为省级专精特新小巨人企业', comment='是否为省级专精特新小巨人企业')  # 省级专精特新小巨人企业
    fianacing = db.Column(db.String(32), doc='是否为有融资企业', comment='是否为有融资企业')  # 是否为有融资企业
    fianacing_rounds = db.Column(db.String(32), doc='融资轮次', comment='融资轮次')  # 融资轮次
    roundid = db.Column(db.Integer, index=True, doc='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）', comment='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）')  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    financing_amount = db.Column(db.Float, doc='融资金额', comment='融资金额')  # 融资金额
    software_copyright = db.Column(db.String(32), doc='是否为有软件著作权', comment='是否为有软件著作权')  # 是否为有软件著作权
    num_software = db.Column(db.Integer, doc='软件著作权个数', comment='软件著作权个数')  # 软件著作权个数
    quoted_company = db.Column(db.String(32), doc='是否上市企业', comment='是否上市企业')  # 是否上市企业
    public_sector = db.Column(db.String(32), doc='上市板块', comment='上市板块')  # 上市板块
    public_id = db.Column(db.Integer, index=True, doc='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)', comment='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)')  # 上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)

    foreign_investment = db.Column(db.String(32), doc='是否外商投资', comment='是否外商投资')  # 是否外商投资
    patent = db.Column(db.String(32), doc='是否为有专利企业', comment='是否为有专利企业')  # 是否为有专利企业
    num_patent = db.Column(db.Integer, doc='专利个数', comment='专利个数')  # 专利个数
    company_info = db.Column(db.Text, doc='公司简介', comment='公司简介')  # 公司简介

    dengl = db.Column(db.String(32), doc='瞪羚', comment='瞪羚')  # 瞪羚
    unicorn = db.Column(db.String(32), doc='独角兽企业', comment='独角兽企业')  # 独角兽企业
    isfive = db.Column(db.String(32), doc='是否中国500强', comment='是否中国500强')  # 是否中国500强

    product_all = db.Column(db.String(255), doc='公司拥有产品', comment='公司拥有产品')  # 公司拥有产品
    takingn = db.Column(db.Float, doc='营收', comment='营收')  # 营收

    hots = db.Column(db.Integer, doc='企业热度(权重值)', comment='企业热度(权重值)')  # 企业热度(权重值)
    c_name = db.Column(db.String(255), doc='行业类名', comment='行业类名')  # 行业类名
    c_type = db.Column(db.Integer, index=True, doc='行业类id', comment='行业类id')  # 行业类id
    f_name = db.Column(db.String(255), doc='父行业类名', comment='父行业类名')  # 父行业类名
    f_type = db.Column(db.Integer, index=True, doc='父行业类id', comment='父行业类id')  # 父行业类id
    __table_args__ = ({'comment': '全国企业表'})  # 添加表注释


# 晋城企业表
class Company(db.Model):
    __tablename__ = "company"
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='企业主键id', comment='企业主键id')  # 企业
    company_name = db.Column(db.String(255), doc='企业名', comment='企业名')  # 企业名
    status = db.Column(db.String(32), doc='经营状态', comment='经营状态')  # 经营状态
    legal = db.Column(db.String(32), doc='法定代表人', comment='法定代表人')  # 法定代表人
    capital = db.Column(db.String(255), doc='注册资本,22万美元', comment='注册资本,22万美元')  # 注册资本,22万美元
    capital_nums = db.Column(db.Float, doc='注册资本转换成人民币数值', comment='注册资本转换成人民币数值')  # 注册资本转换成人民币数值
    capital_id = db.Column(db.Integer, doc='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6', comment='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6')  # 注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6
    build_date = db.Column(db.DateTime, doc='注册时间', comment='注册时间')  # 注册时间
    yearid = db.Column(db.Integer, doc='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）', comment='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）')  # 成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）
    province = db.Column(db.String(32), doc='省', comment='省')  # 省
    city = db.Column(db.String(32), doc='市', comment='市')  # 市
    district = db.Column(db.String(32), doc='区', comment='区')  # 区
    lng = db.Column(db.String(100), doc='经度', comment='经度')  # 经度
    lat = db.Column(db.String(100), doc='纬度', comment='纬度')  # 纬度
    c_lng = db.Column(db.String(100), doc='市经度', comment='市经度')  # 市经度
    c_lat = db.Column(db.String(100), doc='市纬度', comment='市纬度')  # 市纬度
    d_lng = db.Column(db.String(100), doc='区经度', comment='区经度')  # 区经度
    d_lat = db.Column(db.String(100), doc='区纬度', comment='区纬度')  # 区纬度
    address = db.Column(db.String(255), doc='企业地址', comment='企业地址')  # 企业地址
    telephone = db.Column(db.Text, doc='电话', comment='电话')  # 电话
    telephone_more = db.Column(db.Text, doc='更多电话', comment='更多电话')  # 更多电话
    email = db.Column(db.Text, doc='邮箱', comment='邮箱')  # 邮箱
    social_code = db.Column(db.String(100), doc='统一社会信用代码', comment='统一社会信用代码')  # 统一社会信用代码
    tax_code = db.Column(db.String(100), doc='纳税人识别号', comment='纳税人识别号')  # 纳税人识别号
    register_code = db.Column(db.String(100), doc='注册号', comment='注册号')  # 注册号
    company_code = db.Column(db.String(100), doc='组织机构代码', comment='组织机构代码')  # 组织机构代码
    bao_num = db.Column(db.Integer, doc='参保人数', comment='参保人数')  # 参保人数
    entype = db.Column(db.String(100), doc='企业类型', comment='企业类型')  # 企业类型
    entypeid = db.Column(db.Integer, doc='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)', comment='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)')  # 公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)
    # (全民所有制企业-6)(外商企业-7)

    company_industry = db.Column(db.String(100), doc='所属行业', comment='所属行业')  # 所属行业
    web_site = db.Column(db.String(255), doc='企业网址', comment='企业网址')  # 企业网址
    business_scope = db.Column(db.Text, doc='企业经营范围', comment='企业经营范围')  # 企业经营范围
    money_type = db.Column(db.String(100), doc='注册币种', comment='注册币种')  # 注册币种
    money_type_id = db.Column(db.Integer, doc='注册币种类型id', comment='注册币种类型id')  # 注册币种类型id

    high_new = db.Column(db.String(32), doc='是否高新技术企业', comment='是否高新技术企业')  # 是否高新技术企业
    parti_year = db.Column(db.Integer, doc='高新企业注册年份', comment='高新企业注册年份')  # 高新企业注册年份
    tbe = db.Column(db.String(32), doc='是否科技型中小企业', comment='是否科技型中小企业')  # 是否科技型中小企业
    tbe_sjmy = db.Column(db.String(32), doc='是否为省级民营科技企业', comment='是否为省级民营科技企业')  # 省级民营科技企业
    fianacing = db.Column(db.String(32), doc='是否为有融资企业', comment='是否为有融资企业')  # 是否为有融资企业
    fianacing_rounds = db.Column(db.String(32), doc='融资轮次', comment='融资轮次')  # 融资轮次
    roundid = db.Column(db.Integer, doc='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）', comment='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）')  # 融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）
    financing_amount = db.Column(db.Float, doc='融资金额', comment='融资金额')  # 融资金额
    software_copyright = db.Column(db.String(32), doc='是否为有软件著作权', comment='是否为有软件著作权')  # 是否为有软件著作权
    num_software = db.Column(db.Integer, doc='软件著作权个数', comment='软件著作权个数')  # 软件著作权个数
    public_sector = db.Column(db.String(32), doc='上市板块', comment='上市板块')  # 上市板块
    quoted_company = db.Column(db.String(32), doc='是否上市企业', comment='是否上市企业')  # 是否上市企业
    public_id = db.Column(db.Integer, doc='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)', comment='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)')  # 上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)

    foreign_investment = db.Column(db.String(32), doc='是否外商投资', comment='是否外商投资')  # 是否外商投资
    patent = db.Column(db.String(32), doc='是否为有专利企业', comment='是否为有专利企业')  # 是否为有专利企业
    num_patent = db.Column(db.Integer, doc='专利个数', comment='专利个数')  # 专利个数
    induzone = db.Column(db.String(255), doc='所在园区', comment='所在园区')  # 所在园区
    company_info = db.Column(db.Text, doc='公司简介', comment='公司简介')  # 公司简介

    sxmon = db.Column(db.String(32), doc='是否山西民营100强', comment='是否山西民营100强')  # 是否山西民营100强（2019年）
    zjtg = db.Column(db.String(32), doc='是否为山西专精特新企业', comment='是否为山西专精特新企业')  # 山西专精特工企业
    zjtg_gjjxjr = db.Column(db.String(32), doc='是否为国家级专精特新小巨人企业', comment='是否为国家级专精特新小巨人企业')  # 国家级专精特新小巨人企业
    zjtg_sjxjr = db.Column(db.String(32), doc='是否为省级专精特新小巨人企业', comment='是否为省级专精特新小巨人企业')  # 省级专精特新小巨人企业
    unicorn = db.Column(db.String(32), doc='独角兽企业', comment='独角兽企业')  # 独角兽企业
    dengl = db.Column(db.String(32), doc='瞪羚', comment='瞪羚')  # 瞪羚
    hncode = db.Column(db.String(32), doc='高企证书编号', comment='高企证书编号')  # 高企证书编号
    isfive = db.Column(db.String(32), doc='是否中国500强', comment='是否中国500强')  # 是否中国500强
    istyfive = db.Column(db.String(32), doc='是否2020中国500强', comment='是否2020中国500强')  # 是否2020中国500强
    quotedate = db.Column(db.DateTime, doc='上市时间', comment='上市时间')  # 上市时间
    sxonhun = db.Column(db.String(32), doc='是否山西100强', comment='是否山西100强')  # 是否山西100强

    product_all = db.Column(db.String(255), doc='公司拥有产品', comment='公司拥有产品')  # 公司拥有产品
    scale = db.Column(db.String(32), doc='规模以上企业', comment='规模以上企业')  # 规模以上企业
    serve = db.Column(db.String(32), doc='限额以上服务业', comment='限额以上服务业')  # 限额以上服务业

    takingn = db.Column(db.Float, doc='营收 (万元)', comment='营收 (万元)')  # 2019营收 (万元)
    ouputn = db.Column(db.Float, doc='年产值', comment='年产值')  # 2019年产值
    profit = db.Column(db.Float, doc='公司利润（万元）', comment='公司利润（万元）')  # 2019公司利润（万元）
    c_name = db.Column(db.String(255), doc='行业类名', comment='行业类名')  # 行业类名
    c_type = db.Column(db.Integer, doc='行业类id', comment='行业类id')  # 行业类id
    f_name = db.Column(db.String(255), doc='父行业类名', comment='父行业类名')  # 父行业类名
    f_type = db.Column(db.Integer, doc='父行业类id', comment='父行业类id')  # 父行业类id
    hots = db.Column(db.Integer, doc='企业热度', comment='企业热度')  # 企业热度
    sort_num = db.Column(db.Integer, doc='权重值', comment='权重值')  # 权重值
    stream = db.Column(db.String(32), doc='行业上下游', comment='行业上下游')  # 行业上下游
    product = db.Column(db.String(255), doc='生产产品', comment='生产产品')  # 生产产品
    __table_args__ = ({'comment': '晋城企业表'})  # 添加表注释


# 晋城企业行政许可
class CompanyAdminPermission(db.Model):
    __tablename_ = "company_admin_permission"
    __table_args__ = ({'comment': '晋城企业行政许可数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='晋城企业行政许可主键id', comment='晋城企业行政许可主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')
    number = db.Column(db.String(32), doc='晋城企业行政许可编号', comment='晋城企业行政许可编号')
    name = db.Column(db.String(32), doc='晋城企业行政许可证名称', comment='晋城企业行政许可证名称')
    time = db.Column(db.DateTime, doc='有效期自', comment='有效期自')
    effective_data = db.Column(db.DateTime, doc='有效期至', comment='有效期至')
    Licensing_authority = db.Column(db.String(32), doc='许可机关', comment='许可机关')
    content = db.Column(db.String(32), doc='许可内容', comment='许可内容')
    source = db.Column(db.String(32), doc='来源', comment='来源')


# 晋城企业税务信用
class CompanyTaxCredit(db.Model):
    __tablename_ = "company_tax_credit"
    __table_args__ = ({'comment': '晋城企业税务信用数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='晋城企业税务信用主键id', comment='晋城企业税务信用主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')
    evaluation_annual = db.Column(db.String(32), doc='评价年度', comment='评价年度')
    identify_number = db.Column(db.String(32), doc='纳税人识别号', comment='纳税人识别号')
    level = db.Column(db.String(32), doc='纳税信用等级', comment='纳税信用等级')
    evaluate = db.Column(db.String(32), doc='单位评价', comment='单位评价')


# 晋城企业进出口信用
class CompanyImportExport(db.Model):
    __tablename_ = "company_import_export"
    __table_args__ = ({'comment': '晋城企业进出口信用数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='晋城企业进出口信用主键id', comment='晋城企业进出口信用主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')
    register_customs = db.Column(db.String(32), doc='注册海关', comment='注册海关')
    business_category = db.Column(db.String(32), doc='经营类别', comment='经营类别')
    register_date = db.Column(db.DateTime, doc='注册日期', comment='注册日期')


# 晋城企业供应商
class CompanySupplier(db.Model):
    __tablename_ = "company_supplier"
    __table_args__ = ({'comment': '晋城企业供应商数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='晋城企业供应商主键id', comment='晋城企业供应商主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')
    supplier_name = db.Column(db.String(32), doc='客户名字', comment='客户名字')
    buy_rate = db.Column(db.String(32), doc='采购占比', comment='采购占比')
    buy_money = db.Column(db.String(32), doc='采购金额', comment='采购金额')
    open_time = db.Column(db.DateTime, doc='公开时间', comment='公开时间')
    data_source = db.Column(db.String(32), doc='数据来源', comment='数据来源')
    relation = db.Column(db.String(32), doc='关联关系', comment='关联关系')
    lng = db.Column(db.String(100), doc='经度', comment='经度')  # 经度
    lat = db.Column(db.String(100), doc='纬度', comment='纬度')  # 纬度


# 晋城企业客户
class CompanyCustomer(db.Model):
    __tablename_ = "company_customer"
    __table_args__ = ({'comment': '晋城企业客户数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='晋城企业客户主键id', comment='晋城企业客户主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')
    customer_name = db.Column(db.String(32), doc='客户', comment='客户')
    sales_rate = db.Column(db.String(32), doc='销售占比', comment='销售占比')
    sales_money = db.Column(db.String(32), doc='销售金额', comment='销售金额')
    open_time = db.Column(db.DateTime, comment='公开时间')
    data_source = db.Column(db.String(32), doc='数据来源', comment='数据来源')
    relation = db.Column(db.String(32), doc='关联关系', comment='关联关系')


# 晋城企业详情股权出质
class CompanyStock(db.Model):
    __tablename_ = "company_stock"
    __table_args__ = ({'comment': '晋城企业详情股权出质'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='股权出质主键id', comment='股权出质主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')

    num = db.Column(db.String(32), doc='等级编号', comment='等级编号')
    person = db.Column(db.String(10), doc='出质人', comment='出质人')
    from_company = db.Column(db.String(25), doc='出质股权的企业', comment='出质股权的企业')
    pledgee = db.Column(db.String(10), doc='质权人', comment='质权人')
    amount = db.Column(db.Float, doc='出质股权数额（万元）', comment='出质股权数额（万元）')
    datatime = db.Column(db.DateTime, doc='登记日期', comment='登记日期')
    status = db.Column(db.String(10), doc='状态', comment='状态')


# 晋城企业详情股权质押
class CompanyPledge(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '晋城企业详情股权质押'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='股权质押主键id', comment='股权质押主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')

    person1 = db.Column(db.String(10), doc='质押人', comment='质押人')
    jion_company = db.Column(db.String(25), doc='参股企业', comment='参股企业')
    person2 = db.Column(db.String(10), doc='质押权人', comment='质押权人')
    number = db.Column(db.Float, doc='质押股份总额（股）', comment='质押股份总额（股）')
    amount = db.Column(db.Float, doc='质押股份市值（元）', comment='质押股份市值（元）')
    status = db.Column(db.String(10), doc='状态', comment='状态')
    datatime = db.Column(db.DateTime, doc='公告日期', comment='公告日期')


# 晋城企业详情担保信息
class CompanyDanbao(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '晋城企业详情担保信息'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='担保信息主键id', comment='担保信息主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')

    person1 = db.Column(db.String(10), doc='被担保方', comment='被担保方')
    person2 = db.Column(db.String(10), doc='担保方', comment='担保方')
    method = db.Column(db.String(10), doc='方式', comment='方式')
    amount = db.Column(db.Float, doc='担保金额（万元）', comment='担保金额（万元）')
    datatime = db.Column(db.DateTime, doc='公告日期', comment='公告日期')


# 晋城企业详情专利信息
class CompanyPatent(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '晋城企业详情专利信息'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='专利信息主键id', comment='专利信息主键id')  # 企业
    company_id = db.Column(db.Integer, doc='晋城企业id', comment='晋城企业id')

    name = db.Column(db.String(50), doc='发明名称', comment='发明名称')
    type = db.Column(db.String(20), doc='类型', comment='类型')
    status = db.Column(db.String(20), doc='法律状态', comment='法律状态')
    num = db.Column(db.String(50), doc='申请号', comment='申请号')
    day = db.Column(db.DateTime, doc='申请日', comment='申请日')
    open_num = db.Column(db.String(20), doc='公开号', comment='公开号')
    datatime = db.Column(db.DateTime, doc='公开日期', comment='公开日期')
    person = db.Column(db.String(20), doc='发明人', comment='发明人')


# 全国企业表企业行政许可
class EnterpriseAdminPermission(db.Model):
    __tablename_ = "company_admin_permission"
    __table_args__ = ({'comment': '全国企业表企业行政许可数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='全国企业表企业行政许可主键id', comment='全国企业表企业行政许可主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')
    number = db.Column(db.String(32), doc='全国企业表企业行政许可编号', comment='全国企业表企业行政许可编号')
    name = db.Column(db.String(32), doc='全国企业表企业行政许可证名称', comment='全国企业表企业行政许可证名称')
    time = db.Column(db.DateTime, doc='有效期自', comment='有效期自')
    effective_data = db.Column(db.DateTime, doc='有效期至', comment='有效期至')
    Licensing_authority = db.Column(db.String(32), doc='许可机关', comment='许可机关')
    content = db.Column(db.String(32), doc='许可内容', comment='许可内容')
    source = db.Column(db.String(32), doc='来源', comment='来源')


# 全国企业表企业税务信用
class EnterpriseTaxCredit(db.Model):
    __tablename_ = "company_tax_credit"
    __table_args__ = ({'comment': '全国企业表企业税务信用数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='全国企业表企业税务信用主键id', comment='全国企业表企业税务信用主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')
    evaluation_annual = db.Column(db.String(32), doc='评价年度', comment='评价年度')
    identify_number = db.Column(db.String(32), doc='纳税人识别号', comment='纳税人识别号')
    level = db.Column(db.String(32), doc='纳税信用等级', comment='纳税信用等级')
    evaluate = db.Column(db.String(32), doc='单位评价', comment='单位评价')


# 全国企业表企业进出口信用
class EnterpriseImportExport(db.Model):
    __tablename_ = "company_import_export"
    __table_args__ = ({'comment': '全国企业表企业进出口信用数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='全国企业表企业进出口信用主键id', comment='全国企业表企业进出口信用主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')
    register_customs = db.Column(db.String(32), doc='注册海关', comment='注册海关')
    business_category = db.Column(db.String(32), doc='经营类别', comment='经营类别')
    register_date = db.Column(db.DateTime, doc='注册日期', comment='注册日期')


# 全国企业表企业供应商
class EnterpriseSupplier(db.Model):
    __tablename_ = "company_supplier"
    __table_args__ = ({'comment': '全国企业表企业供应商数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='全国企业表企业供应商主键id', comment='全国企业表企业供应商主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')
    supplier_name = db.Column(db.String(32), doc='客户名字', comment='客户名字')
    buy_rate = db.Column(db.String(32), doc='采购占比', comment='采购占比')
    buy_money = db.Column(db.String(32), doc='采购金额', comment='采购金额')
    open_time = db.Column(db.DateTime, doc='公开时间', comment='公开时间')
    data_source = db.Column(db.String(32), doc='数据来源', comment='数据来源')
    relation = db.Column(db.String(32), doc='关联关系', comment='关联关系')
    lng = db.Column(db.String(100), doc='经度', comment='经度')  # 经度
    lat = db.Column(db.String(100), doc='纬度', comment='纬度')  # 纬度


# 全国企业表企业客户
class EnterpriseCustomer(db.Model):
    __tablename_ = "company_customer"
    __table_args__ = ({'comment': '全国企业表企业客户数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='全国企业表企业客户主键id', comment='全国企业表企业客户主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')
    customer_name = db.Column(db.String(32), doc='客户', comment='客户')
    sales_rate = db.Column(db.String(32), doc='销售占比', comment='销售占比')
    sales_money = db.Column(db.String(32), doc='销售金额', comment='销售金额')
    open_time = db.Column(db.DateTime, comment='公开时间')
    data_source = db.Column(db.String(32), doc='数据来源', comment='数据来源')
    relation = db.Column(db.String(32), doc='关联关系', comment='关联关系')


# 全国企业表企业详情股权出质
class EnterpriseStock(db.Model):
    __tablename_ = "company_stock"
    __table_args__ = ({'comment': '全国企业表企业详情股权出质'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='股权出质主键id', comment='股权出质主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')

    num = db.Column(db.String(32), doc='等级编号', comment='等级编号')
    person = db.Column(db.String(10), doc='出质人', comment='出质人')
    from_company = db.Column(db.String(25), doc='出质股权的企业', comment='出质股权的企业')
    pledgee = db.Column(db.String(10), doc='质权人', comment='质权人')
    amount = db.Column(db.Float, doc='出质股权数额（万元）', comment='出质股权数额（万元）')
    datatime = db.Column(db.DateTime, doc='登记日期', comment='登记日期')
    status = db.Column(db.String(10), doc='状态', comment='状态')


# 全国企业表企业详情股权质押
class EnterprisePledge(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '全国企业表企业详情股权质押'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='股权质押主键id', comment='股权质押主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')

    person1 = db.Column(db.String(10), doc='质押人', comment='质押人')
    jion_company = db.Column(db.String(25), doc='参股企业', comment='参股企业')
    person2 = db.Column(db.String(10), doc='质押权人', comment='质押权人')
    number = db.Column(db.Float, doc='质押股份总额（股）', comment='质押股份总额（股）')
    amount = db.Column(db.Float, doc='质押股份市值（元）', comment='质押股份市值（元）')
    status = db.Column(db.String(10), doc='状态', comment='状态')
    datatime = db.Column(db.DateTime, doc='公告日期', comment='公告日期')


# 全国企业表企业详情担保信息
class EnterpriseDanbao(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '全国企业表企业详情担保信息'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='担保信息主键id', comment='担保信息主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')

    person1 = db.Column(db.String(10), doc='被担保方', comment='被担保方')
    person2 = db.Column(db.String(10), doc='担保方', comment='担保方')
    method = db.Column(db.String(10), doc='方式', comment='方式')
    amount = db.Column(db.Float, doc='担保金额（万元）', comment='担保金额（万元）')
    datatime = db.Column(db.DateTime, doc='公告日期', comment='公告日期')


# 全国企业表企业详情专利信息
class EnterprisePatent(db.Model):
    __tablename_ = "company_pledge"
    __table_args__ = ({'comment': '全国企业表企业详情专利信息'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='专利信息主键id', comment='专利信息主键id')  # 企业
    company_id = db.Column(db.Integer, doc='全国企业表企业id', comment='全国企业表企业id')

    name = db.Column(db.String(50), doc='发明名称', comment='发明名称')
    type = db.Column(db.String(20), doc='类型', comment='类型')
    status = db.Column(db.String(20), doc='法律状态', comment='法律状态')
    num = db.Column(db.String(50), doc='申请号', comment='申请号')
    day = db.Column(db.DateTime, doc='申请日', comment='申请日')
    open_num = db.Column(db.String(20), doc='公开号', comment='公开号')
    datatime = db.Column(db.DateTime, doc='公开日期', comment='公开日期')
    person = db.Column(db.String(20), doc='发明人', comment='发明人')


# 产业导航目录
class Industry(db.Model):
    __tablename_ = "industry"
    __table_args__ = ({'comment': '产业导航目录表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='产业主键id', comment='产业主键id')
    name = db.Column(db.String(32), doc='导航名', comment='导航名')  # 导航名
    oname = db.Column(db.String(32), doc='导航真名', comment='导航真名')  # 导航真名
    nid = db.Column(db.Integer, doc='导航id(对应企业数据表中的f_type)', comment='导航id(对应企业数据表中的f_type)')  # 导航id(导航在企业数据中的id)
    fid = db.Column(db.Integer, doc='表中fid', comment='表中fid')  # 表中fid
    statu = db.Column(db.Integer, doc='启用状态1启用，2禁用', comment='启用状态1启用，2禁用')  # 启用状态1启用，2禁用
    info = db.Column(db.Text, doc='行业简介', comment='行业简介')  # 行业简介
    companys = db.Column(db.Integer, doc='行业下企业数', comment='行业下企业数')  # 行业下企业数
    entities = db.Column(db.Integer, doc='行业所包含细分行业实体数', comment='行业所包含细分行业实体数')  # 行业所包含细分行业实体数


# 招商驾驶舱-区县经济指标表/产业载体-行政区
class City(BaseModel, db.Model):
    __tablename__ = "city"
    __table_args__ = ({'comment': '招商驾驶舱-区县经济指标表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='经济指标主键id', comment='经济指标主键id')
    area = db.Column(db.String(255), doc='区县名称', comment='区县名称')  # 区县名称
    size = db.Column(db.Float, doc='区县面积', comment='区县面积')  # 区县面积
    year = db.Column(db.Integer, doc='年份', comment='年份')  # 年份
    people = db.Column(db.Integer, doc='人口', comment='人口')  # 人口
    GDP = db.Column(db.Float, doc='GDP(万元)', comment='GDP(万元)')  # GDP(万元)
    investment = db.Column(db.Float, doc='固定投资资产', comment='固定投资资产')  # 固定投资资产
    retail = db.Column(db.Float, doc='社会消费品零售总额', comment='社会消费品零售总额')  # 社会消费品零售总额
    public = db.Column(db.Float, doc='一般公共预算支出', comment='一般公共预算支出')  # 一般公共预算支出
    public_in = db.Column(db.Float, doc='一般公共预算收入', comment='一般公共预算收入')  # 一般公共预算收入
    addscale = db.Column(db.Float, doc='规上工业增加值', comment='规上工业增加值')  # 规上工业增加值
    people_out = db.Column(db.Float, doc='居然人均可支配收入', comment='居然人均可支配收入')  # 居然人均可支配收入
    people_per = db.Column(db.Float, doc='居民消费价格指数', comment='居民消费价格指数')  # 居民消费价格指数
    in_out = db.Column(db.Float, doc='进出口总额', comment='进出口总额')  # 进出口总额
    info = db.Column(db.Text, doc='基本信息', comment='基本信息')  # 基本信息
    question = db.Column(db.Text, doc='标注', comment='标注')  # 标注


# 招商驾驶舱-各区县视频
class Video(db.Model):
    __tablename__ = "video"
    __table_args__ = ({'comment': '招商驾驶舱-各区县视频表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='视频主键id', comment='视频主键id')
    district = db.Column(db.String(32), nullable=False, doc='区县名称', comment='区县名称')
    image_url = db.Column(db.String(255), doc='视频封面', comment='视频封面')
    video_id1 = db.Column(db.String(255), doc='视频链接', comment='视频链接')


# 招商驾驶舱-项目数量/金额产业分布图
class NewProject(BaseModel, db.Model):
    __tablename__ = "newproject"
    __table_args__ = ({'comment': '招商驾驶舱-项目数量/金额产业分布表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')  # id
    type = db.Column(db.String(255), doc='产业类型', comment='产业类型')  # 产业类型
    number = db.Column(db.Integer, doc='项目个数', comment='项目个数')  # 项目个数
    money = db.Column(db.Float, doc='价格', comment='价格')  # 价格
    district = db.Column(db.String(255), doc='区县名称', comment='区县名称')  #


# 招商驾驶舱-招商引资作战图
class Examine(BaseModel, db.Model):
    __tablename__ = "examine"
    __table_args__ = ({'comment': '招商驾驶舱-招商引资作战图表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')  # id
    district = db.Column(db.String(255), doc='县区', comment='县区')  # 县区
    year = db.Column(db.Integer, doc='年', comment='年')  # 年
    month = db.Column(db.Integer, doc='月', comment='月')  # 月
    project_num = db.Column(db.Integer, doc='项目个数', comment='项目个数')  # 项目个数
    sign_aim = db.Column(db.Integer, doc='签约目标', comment='签约目标')  # 签约目标

    sign_finnish = db.Column(db.Float, doc='签约的完成', comment='签约的完成')  # 签约的完成
    sign_grade = db.Column(db.Float, doc='签约的得分，签约项目投资额完成率', comment='签约的得分，签约项目投资额完成率')  # 签约的得分，签约项目投资额完成率
    start_finish = db.Column(db.Float, doc='开工实际投资', comment='开工实际投资')  # 开工实际投资
    start_grade = db.Column(db.Float, doc='开工项目完成得分，开工项目计划投资额完成率', comment='开工项目完成得分，开工项目计划投资额完成率')  # 开工项目完成得分，开工项目计划投资额完成率
    invest_finish = db.Column(db.Float, doc='固投已完成', comment='固投已完成')  # 固投已完成
    invest_grade = db.Column(db.Float, doc='固投得分，开工项目到位资金额', comment='固投得分，开工项目到位资金额')  # 固投得分，开工项目到位资金额

    start_num = db.Column(db.Integer, doc='项目的开工个数', comment='项目的开工个数')  # 项目的开工个数
    start_num_grade = db.Column(db.Float, doc='签约开工率得分', comment='签约开工率得分')  # 签约开工率得分

    start_aim = db.Column(db.Float, doc='开工计划金额', comment='开工计划金额')  # 开工计划金额
    invest_aim = db.Column(db.Float, doc='固投目标金额', comment='固投目标金额')  # 固投目标金额
    invest_aim_f = db.Column(db.Float, doc='非固投目标金额', comment='非固投目标金额')  # 非固投目标金额
    invest_finish_f = db.Column(db.Integer, doc='非固投已完成', comment='非固投已完成')  # 非固投已完成
    invest_grade_f = db.Column(db.Float, doc='非固投得分', comment='非固投得分')  # 非固投得分
    grade = db.Column(db.Integer, doc='综合排名', comment='综合排名')  # 综合排名


# 招商驾驶舱-重点招商项目表
class Project(BaseModel, db.Model):
    __tablename__ = "project"
    __table_args__ = ({'comment': '招商驾驶舱-重点招商项目表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='工程id', comment='工程id')  # 工程id
    project_stage_id = db.Column(db.Integer, doc='项目阶段id：落地项目为1，招商项目为2', comment='项目阶段id：落地项目为1，招商项目为2')
    name = db.Column(db.String(255), doc='工程名', comment='工程名')  # 一.工程名
    district = db.Column(db.String(255), doc='区县名称', comment='区县名称')  # 二.县区
    type = db.Column(db.String(255), doc='工程类型', comment='工程类型')  # 三.(1)工程类型
    money = db.Column(db.String(255), doc='项目投资金额', comment='项目投资金额')  # 三.(2)项目投资金额
    background = db.Column(db.Text, doc='项目背景', comment='项目背景')  # 三.(3)项目背景
    content = db.Column(db.Text, doc='项目的具体内容', comment='项目的具体内容')  # 三.(4)项目的具体内容
    way = db.Column(db.Text, doc='拟引资方式及内容', comment='拟引资方式及内容')  # 四.拟引资方式及内容
    company = db.Column(db.String(255), doc='招商单位', comment='招商单位')  # 五.(1)招商单位
    contact = db.Column(db.String(255), doc='联系方式', comment='联系方式')  # 五.(2)联系方式
    email = db.Column(db.String(255), doc='电子邮箱', comment='电子邮箱')  # 五.(3)电子邮箱




# 招商驾驶舱-产业政策
class InduPolicy(db.Model):
    __tablename_ = "indupolicy"
    __table_args__ = ({'comment': '招商驾驶舱-产业政策'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='政策主键id', comment='政策主键id')
    name = db.Column(db.String(255), doc='政策名', comment='政策名')  # 政策名
    post_num = db.Column(db.String(255), doc='发文字号', comment='发文字号')  # 发文字号
    industry = db.Column(db.String(32), doc='行业名称', comment='行业名称')  # 行业名称
    pubdate = db.Column(db.DateTime, doc='发布时间', comment='发布时间')  # 发布时间
    year = db.Column(db.Integer, doc='发布年份', comment='发布年份')  # 发布年份
    url = db.Column(db.String(255), doc='外链接', comment='外链接')  # 外链接
    file = db.Column(db.String(255), doc='本地文件位置', comment='本地文件位置')  # 本地文件位置
    category = db.Column(db.String(32), doc='政策类型', comment='政策类型')  # 政策类型
    org = db.Column(db.String(255), doc='政策发布机构', comment='政策发布机构')  # 政策发布机构
    district = db.Column(db.String(32), doc='政策发布地区', comment='政策发布地区')  # 政策发布地区
    body = db.Column(db.Text, doc='正文', comment='正文')  # 正文（2021-4-13改为发布机构筛选条件）
    navigator = db.Column(db.String(255), doc='导航一', comment='导航一')  # 导航一
    navigat = db.Column(db.String(255), doc='导航二', comment='导航二')  # 导航二
    level = db.Column(db.String(255), doc='级别', comment='级别')  # 级别
    sorts = db.Column(db.Integer, doc='机构排序', comment='机构排序')  # 机构排序
    sorts_level = db.Column(db.Integer, doc='发布机构排序', comment='发布机构排序')  # 发布机构排序


# 产业现状图谱-园区数据表
class Induzone(db.Model):
    __tablename_ = "induzone"
    __table_args__ = ({'comment': '产业现状图谱-产业载体园区信息表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='园区主键id', comment='园区主键id')
    name = db.Column(db.String(255), doc='园区名称', comment='园区名称')  # 园区姓名
    image = db.Column(db.String(255), doc='园区图片', comment='园区图片')  # 园区单图链接http://192.168.132.165:5000/static/images/garden.jpg
    phone = db.Column(db.String(255), doc='园区联系电话', comment='园区联系电话')  # 园区联系电话
    email = db.Column(db.String(30))  # 邮箱

    address = db.Column(db.String(255), doc='园区地址', comment='园区地址')  # 园区地址
    industry_position = db.Column(db.String(255), doc='产业定位', comment='产业定位')  # 产业定位
    gdp = db.Column(db.Float, doc='GDP(亿元)', comment='GDP(亿元)')  # GDP(亿元)
    represent = db.Column(db.Text, doc='代表企业', comment='代表企业')  # 代表企业
    introduct = db.Column(db.Text, doc='园区简介', comment='园区简介')  # 园区简介
    level = db.Column(db.String(32), doc='园区级别', comment='园区级别')  # 园区级别
    district = db.Column(db.String(255), doc='园区区县', comment='园区区县')  # 园区区县
    charge = db.Column(db.String(255), doc='园区负责人', comment='园区负责人')  # 园区负责人
    site = db.Column(db.String(255), doc='园区所在地', comment='园区所在地')  # 园区所在地
    industry_type = db.Column(db.String(255), doc='产业类型', comment='产业类型')  # 产业类型
    area = db.Column(db.Float, doc='占地面积(平方公里)', comment='占地面积(平方公里)')  # 占地面积(平方公里)
    # subzone = db.Column(db.String(255), doc='上级园区', comment='上级园区')  # 上级园区
    # mainzone = db.Column(db.Text, doc='主要产业园区', comment='主要产业园区')  # 主要产业园区
    # zpolicy = db.Column(db.Text, doc='产业政策', comment='产业政策')  # 产业政策
    lng = db.Column(db.String(255), doc='经度', comment='经度')  # 经度
    lat = db.Column(db.String(255), doc='纬度', comment='纬度')  # 纬度
    cluster = db.Column(db.String(255), doc='产业集群', comment='产业集群')  # 产业集群
    cate = db.Column(db.String(255), doc='园区类型', comment='园区类型')  # 园区类型

    # 园区信息
    # acreage = db.Column(db.Float, doc='规划面积（平方公里）', comment='规划面积（平方公里）')  # 规划面积（平方公里）
    # actarea = db.Column(db.Float, doc='建成面积（平方公里）', comment='建成面积（平方公里）')  # 建成面积（平方公里）
    # tax = db.Column(db.Float, doc='税收要求（万元/亩）', comment='税收要求（万元/亩）')  # 税收要求（万元/亩）
    out_power = db.Column(db.Float, doc='产出强度（万元/亩）', comment='产出强度（万元/亩）')  # 产出强度（万元/亩）
    # indu_need = db.Column(db.String(255), doc='行业要求', comment='行业要求')  # 行业要求
    # fiscal = db.Column(db.Float, doc='财政收入（亿元）', comment='财政收入（亿元）')  # 财政收入（亿元）
    invest_power = db.Column(db.Float, doc='亩均投资强度（万元/亩）', comment='亩均投资强度（万元/亩）')  # 投资强度（万元/亩）
    value_product = db.Column(db.Float, doc='亩均年产值（万元/亩）', comment='亩均年产值（万元/亩）')  # 亩均年产值（万元/亩）
    tax = db.Column(db.Float, doc='亩均年税收（万元/亩）', comment='亩均年税收（万元/亩）')  # 亩均年税收（万元/亩）
    # 投资成本
    indu_land = db.Column(db.String(255), doc='工业土地均价（万元/亩）', comment='工业土地均价（万元/亩）')  # 工业土地均价（万元/亩）
    # indu_sup = db.Column(db.String(255), doc='工业土地供应量', comment='工业土地供应量')  # 工业土地供应量
    comm_land = db.Column(db.String(255), doc='商办土地均价（万元/亩）', comment='商办土地均价（万元/亩）')  # 商办土地均价（万元/亩）
    # comm_sup = db.Column(db.String(255), doc='商办土地供应量', comment='商办土地供应量')  # 商办土地供应量

    # resident_ele_one = db.Column(db.String(255), doc='居民用电（一档）（元/度）', comment='居民用电（一档）（元/度）')  # 居民用电（一档）（元/度）
    # resident_ele_two = db.Column(db.String(255), doc='居民用电（二档）（元/度）', comment='居民用电（二档）（元/度）')  # 居民用电（二档）（元/度）
    # resident_ele_thr = db.Column(db.String(255), doc='居民用电（三档）（元/度）', comment='居民用电（三档）（元/度）')  # 居民用电（三档）（元/度）
    # comm_ele_one = db.Column(db.String(255), doc='商业用电（峰段）（元/度）', comment='商业用电（峰段）（元/度）')  # 商业用电（峰段）（元/度）
    # comm_ele_two = db.Column(db.String(255), doc='商业用电（平段）（元/度）', comment='商业用电（平段）（元/度）')  # 商业用电（平段）（元/度）
    # comm_ele_thr = db.Column(db.String(255), doc='商业用电（谷段）（元/度）', comment='商业用电（谷段）（元/度）')  # 商业用电（谷段）（元/度）
    # indu_ele_one = db.Column(db.String(255), doc='工业用电（峰段）（元/度）', comment='工业用电（峰段）（元/度）')  # 工业用电（峰段）（元/度）
    # indu_ele_two = db.Column(db.String(255), doc='工业用电（平段）（元/度）', comment='工业用电（平段）（元/度）')  # 工业用电（平段）（元/度）
    # indu_ele_thr = db.Column(db.String(255), doc='工业用电（谷段）（元/度）', comment='工业用电（谷段）（元/度）')  # 工业用电（谷段）（元/度）
    # resident_water_one = db.Column(db.String(255), doc='居民用水（一档）（元/吨）', comment='居民用水（一档）（元/吨）')  # 居民用水（一档）（元/吨）
    # resident_water_two = db.Column(db.String(255), doc='居民用水（二档）（元/吨）', comment='居民用水（二档）（元/吨）')  # 居民用水（二档）（元/吨）
    # resident_water_thr = db.Column(db.String(255), doc='居民用水（三档）（元/吨）', comment='居民用水（三档）（元/吨）')  # 居民用水（三档）（元/吨）
    # comm_water = db.Column(db.String(255), doc='商业用水（元/吨）', comment='商业用水（元/吨）')  # 商业用水（元/吨）
    # indu_water = db.Column(db.String(255), doc='工业用水（元/吨）', comment='工业用水（元/吨）')  # 工业用水（元/吨）
    # special_water = db.Column(db.String(255), doc='特种用水（元/吨）', comment='特种用水（元/吨）')  # 特种用水（元/吨）
    # resident_natgas_one = db.Column(db.String(255), doc='居民用气（一档）（元/m³）', comment='居民用气（一档）（元/m³）')  # 居民用气（一档）（元/m³）
    # resident_natgas_two = db.Column(db.String(255), doc='居民用气（二档）（元/m³）', comment='居民用气（二档）（元/m³）')  # 居民用气（二档）（元/m³）
    # resident_natgas_thr = db.Column(db.String(255), doc='居民用气（三档）（元/m³）', comment='居民用气（三档）（元/m³）')  # 居民用气（三档）（元/m³）
    # sewage = db.Column(db.String(255), doc='污水处理（元/吨）', comment='污水处理（元/吨）')  # 污水处理（元/吨）
    # wagelevel = db.Column(db.String(255), doc='最低工资标准（元/月）', comment='最低工资标准（元/月）')  # 最低工资标准（元/月）
    highmag = db.Column(db.String(255), doc='高层管理人员（元/月）', comment='高层管理人员（元/月）')  # 高层管理人员（元/月）
    middlemag = db.Column(db.String(255), doc='中级管理人员（元/月）', comment='中级管理人员（元/月）')  # 中级管理人员（元/月）
    worker = db.Column(db.String(255), doc='普通员工（元/月）', comment='普通员工（元/月）')  # 普通员工（元/月）
    # 环境配套
    # dis_freight = db.Column(db.Text, doc='距离货运站距离', comment='距离货运站距离')  # 距离货运站距离
    # dis_rail = db.Column(db.Text, doc='距离高铁站', comment='距离高铁站')  # 距离高铁站
    # dis_port = db.Column(db.Text, doc='距离港口距离', comment='距离港口距离')  # 距离港口距离
    # dis_air = db.Column(db.Text, doc='距离机场距离', comment='距离机场距离')  # 距离机场距离
    # road_trans = db.Column(db.Text, doc='公路运输', comment='公路运输')  # 公路运输
    # rail_trans = db.Column(db.Text, doc='铁路运输', comment='铁路运输')  # 铁路运输

    trans_facility = db.Column(db.Text, doc='交通配套', comment='交通配套')  # 交通配套
    goods_trans = db.Column(db.Text, doc='货物运输', comment='货物运输')  # 货物运输
    live_facility = db.Column(db.Text, doc='园区生活配套', comment='园区生活配套')  # 园区生活配套
    market = db.Column(db.Text, doc='百货商场', comment='百货商场')  # 百货商场
    hotel_bus = db.Column(db.Text, doc='酒店商务', comment='酒店商务')  # 酒店商务
    medical = db.Column(db.Text, doc='医疗机构', comment='医疗机构')  # 医疗机构
    education = db.Column(db.Text, doc='教育教育', comment='教育教育')  # 教育教育

    induenterprise = db.Column(db.Text, doc='规模以上企业', comment='规模以上企业')  # 规模以上企业
    innovate = db.Column(db.Text, doc='科研机构', comment='科研机构')  # 科研机构
    base = db.Column(db.Text, doc='双创基地', comment='双创基地')  # 双创基地
    carrier = db.Column(db.Text, doc='产业载体', comment='产业载体')  # 产业载体

    navigator = db.Column(db.String(255), doc='导航一', comment='导航一')  # 导航一
    navigat = db.Column(db.String(255), doc='导航二', comment='导航二')  # 导航二
    region = db.Column(db.String(255), doc='精确行政区', comment='精确行政区')  # 精确行政区

    # 用于园区
    gdp_point = db.Column(db.Float, doc='GDP的评分', comment='GDP的评分')  # GDP的评分
    # company_industry_point = db.Column(db.Float, doc='园区控制大小', comment='园区控制大小')  # 园区控制大小
    # warter_point = db.Column(db.Float, doc='水费的评分', comment='水费的评分')  # 水费的评分
    # electricity_point = db.Column(db.Float, doc='电费的评分', comment='电费的评分')  # 电费的评分（）
    school_point = db.Column(db.Float, doc='高校院所的评分', comment='高校院所的评分')  # 高校院所的评分
    policy_point = db.Column(db.Float, doc='政策数的评分', comment='政策数的评分')  # 政策数的评分
    live_point = db.Column(db.Float, doc='生活配套的评分', comment='生活配套的评分')  # 高校院所的评分
    traffic_point = db.Column(db.Float, doc='交通的评分', comment='交通的评分')  # 高校院所的评分
    mall_point = db.Column(db.Float, doc='购物中心的评分', comment='购物中心的评分')  # 购物中心的评分
    hotel_point = db.Column(db.Float, doc='酒店餐饮的评分', comment='酒店餐饮的评分')  # 酒店餐饮的评分
    development_zone = db.Column(db.String(255), doc='所在开发区', comment='所在开发区')  # 所在开发区

# 项目列表
# class Item(db.Model):
#     __tablename_ = "item"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 项目id
#     build_date = db.Column(db.DateTime)  # 成立时间
#     company_name = db.Column(db.String(255))  # 项目企业
#     admin = db.Column(db.String(255))  # 企业联系人
#     mobile = db.Column(db.String(255))  # 企业联系人联系电话
#     email = db.Column(db.String(255))  # 企业联系邮箱
#
#     name = db.Column(db.String(255))  # 项目名称
#     store = db.Column(db.DateTime)  # 项目入库时间
#     product = db.Column(db.String(255))  # 生产产品
#     industry = db.Column(db.String(255))  # 所在行业
#     indu_id = db.Column(db.Integer)  # 所在行业id
#     invest = db.Column(db.Float)  # 投资额(亿元)
#     # invest = db.Column(db.String(32))  # 投资额(万元)
#     invest_id = db.Column(db.Integer)  # 投资额id
#
#     area = db.Column(db.String(255))  # 占地面积
#     value = db.Column(db.Float)  # 预计产值（万）
#     tax = db.Column(db.Float)  # 预计税收（万）
#
#     unit = db.Column(db.String(255))  # 项目所在机构、单位、局
#     section = db.Column(db.String(255))  # 项目所在部门
#     link = db.Column(db.String(255))  # 对接人（手动填充，非创建者也可以）
#     link_mobile = db.Column(db.String(255))  # 对接人的联系方式
#     user_id = db.Column(db.Integer)  # 项目创建人id
#
#     level = db.Column(db.String(255))  # 项目的级别
#     level_id = db.Column(db.Integer)  # 项目级别id
#     stage = db.Column(db.String(255))  # 项目的进度
#     stage_id = db.Column(db.Integer)  # 项目进度id
#
#     status = db.Column(db.String(255))  # 项目上报状态
#     belong = db.Column(db.Integer)  # 是否为太原市投促局项目 1是，2否
#     share = db.Column(db.String(255))  # 共享人
#     unit_up = db.Column(db.String(255))  # 被上报局
#
#     main_introduce = db.Column(db.Text)  # 项目主体介绍
#     invest_introduce = db.Column(db.Text)  # 投资项目介绍
#     build_introduce = db.Column(db.Text)  # 项目建设内容
#     encomy = db.Column(db.Text)  # 项目的经济效益
#     policy = db.Column(db.Text)  # 项目政策需求
#     question = db.Column(db.Text)  # 项目进展及存在的问题
#
#
# # 项目阶段表
# class Trends(BaseModel, db.Model):
#     __tablename__ = "trends"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     stage = db.Column(db.String(255))  # 项目的阶段
#     unit = db.Column(db.String(255))  # 主导机构
#     user = db.Column(db.String(255))  # 更新人
#     item_id = db.Column(db.Integer, db.ForeignKey("item.id"))  # 项目ID
#     item = db.relationship('Item', backref=db.backref('trends'))  # 外键联系
#
#
# # 招商资源管理项目文件
# class File(BaseModel, db.Model):
#     __tablename__ = "file"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(255))  # 上传文件名
#     file_size = db.Column(db.String(255))  # 文件大小
#     uploader = db.Column(db.String(255))  # 上传人
#     url = db.Column(db.String(255))  # url
#     item_id = db.Column(db.Integer, db.ForeignKey("item.id"))  # 项目ID
#     item = db.relationship('Item', backref=db.backref('file'))  # 外键联系
#
#
# # 政府机构之间的上下级统筹
# followers = db.Table('followers',
#                      db.Column('follower_id', db.Integer, db.ForeignKey('government.id'), primary_key=True),
#                      db.Column('followed_id', db.Integer, db.ForeignKey('government.id'), primary_key=True)
#                      )
#
#
# # 政府机构表（自关联多对多）
# class Government(db.Model):
#     __tablename__ = "government"
#     # 基本信息
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     pnums = db.Column(db.Integer)  # 人数
#     charge = db.Column(db.String(255))  # 机构负责人
#     charge_phone = db.Column(db.String(255))  # 负责人电话
#     function = db.Column(db.Text)  # 部门职能
#     name = db.Column(db.String(255), nullable=False, view_index=True)  # 政府机构单位名称
#     # followed 我的下级，管制谁，followers 我的上级，谁管制我
#     followed = db.relationship('Government', secondary=followers, primaryjoin=(followers.c.follower_id == id),
#                                secondaryjoin=(followers.c.followed_id == id),
#                                backref=db.backref('followers', lazy='dynamic'), lazy='dynamic')
#
#
# # 政府部门（政府-部门 一对多）
# class Section(db.Model):
#     __tablename__ = "section"
#     # 基本信息
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     pnums = db.Column(db.Integer)  # 人数
#     charge = db.Column(db.String(255))  # 部门负责人
#     charge_phone = db.Column(db.String(255))  # 负责人电话
#     function = db.Column(db.Text)  # 部门职能
#     name = db.Column(db.String(255), nullable=False)  # 政府机构部门名称
#     # gid = db.Column(db.Integer) # 政府id
#     goverment_id = db.Column(db.Integer, db.ForeignKey("government.id"))
#     goverment = db.relationship('Government', backref=db.backref('sections'))  # 政府1-N部门
#
#
# # 政府组（政府1-N部门1-N组）
# class Group(db.Model):
#     __tablename__ = "group"
#     # 基本信息
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     pnums = db.Column(db.Integer)  # 人数
#     charge = db.Column(db.String(255))  # 组负责人
#     charge_phone = db.Column(db.String(255))  # 负责人电话
#     function = db.Column(db.Text)  # 部门职能
#     name = db.Column(db.String(255), nullable=False)  # 政府机构部门下组的名称
#     # sid = db.Column(db.Integer) # 部门id
#     section_id = db.Column(db.Integer, db.ForeignKey("section.id"))
#     section = db.relationship('Section', backref=db.backref('groups'))  # 部门1-N组
#
#
# # 用户关注行业，多-多
# class UserIndustry(BaseModel, db.Model):
#     __tablename__ = "user_industry"
#
#     user_id = db.Column(db.Integer, db.ForeignKey("user.id"), primary_key=True)
#     industry_id = db.Column(db.Integer, db.ForeignKey("industry.id"), primary_key=True)
#
#
# # #用户关注公司，多-多
# class UserCompany(BaseModel, db.Model):
#     __tablename__ = "user_company"
#
#     user_id = db.Column(db.Integer, db.ForeignKey("user.id"), primary_key=True)
#     company_id = db.Column(db.Integer, db.ForeignKey("company.id"), primary_key=True)
#
#
# # #用户关注公司，多-多
# class UserEnterprise(BaseModel, db.Model):
#     __tablename__ = "user_enterprise"
#
#     user_id = db.Column(db.Integer, db.ForeignKey("user.id"), primary_key=True)
#     enterprise_id = db.Column(db.Integer, db.ForeignKey("enterprise.id"), primary_key=True)
#
#
# 用户


class User(BaseModel, db.Model):
    __tablename__ = "user"
    __table_args__ = ({'comment': '用户信息表'})  # 添加表注释

    # 基本信息
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 用户编号
    name = db.Column(db.String(32), unique=True)  # 用户名
    password_hash = db.Column(db.String(128))  # 加密的密码
    real_name = db.Column(db.String(32))  # 姓名
    age = db.Column(db.Integer)  # 年龄
    sex = db.Column(db.Integer)  # 性别，男1女2
    mobile = db.Column(db.String(11), unique=True)  # 手机号
    email = db.Column(db.String(20))  # 邮箱
    # 个人中心的信息
    function = db.Column(db.Text)  # 工作职能 ---个人中心
    flag = db.Column(db.Integer)  # 普通1，政府2
    status = db.Column(db.Integer)  # 通过1，在审2,驳回3
    # bused = db.Column(db.Integer) # 账户有无组织
    # 政府信息
    position = db.Column(db.String(128))  # 现任职务（职务）
    unit = db.Column(db.String(128))  # 现任工作机构、单位（政府机构，局）
    section = db.Column(db.String(128))  # 所在部门（部门）
    group = db.Column(db.String(128))  # 所在组
    level = db.Column(db.String(128))  # 职级（职级） 跟role_id对应
    leader = db.Column(db.String(32))  # 领导（直属领导）

    # 三方登陆唯一标识
    # 微信
    vxopenid = db.Column(db.String(128), unique=True)  # 微信openid
    vxunionid = db.Column(db.String(128), unique=True)  # 微信unionid
    # 角色(职级配置)
    role_id = db.Column(db.Integer, db.ForeignKey("role.id"))
    role = db.relationship("Role", backref=db.backref("users"))

    # # 钉钉
    # ddopenid = db.Column(db.String(128))  # 钉钉openid
    # ddunionid = db.Column(db.String(128))  # 钉钉unionid
    # dddingid = db.Column(db.String(128))  # 钉钉dingid

    # 用户关注行业（图谱）
    # industry = db.relationship("Industry", secondary="user_industry", backref=db.backref('bindustry'))
    # 用户关注太原企业
    # company = db.relationship("Company", secondary="user_company", backref=db.backref("bcompany"))
    # 用户关注全国企业
    # enterprise = db.relationship("Enterprise", secondary="user_enterprise", backref=db.backref("benterprise"))

    @property
    def password(self):
        # 设置为只写的方式
        # return self.password_hash
        raise AttributeError('这个属性只能设置，不能读取')

    @password.setter
    def password(self, value):
        self.password_hash = generate_password_hash(value)

    def check_password(self, password):
        '''检验密码的正确性，传入参数为用户登录时填写的密码'''
        return check_password_hash(self.password_hash, password)

    # 生成token
    @staticmethod
    def create_token(user_id):
        """
        生成token,生成方式（ 内部配置的私钥+有效期+用户的id ）
        :param user_id: 用户id
        :return:
        """
        # 第一个参数是内部的私钥,写在配置里,第二个参数是有效期（秒）
        s = Serializer(Config.SECRET_KEY, expires_in=Config.TOKEN_EXPIRATION)
        # 接收用户id转换与编码
        token = s.dumps({"id": user_id}).decode('ascii')
        print(token)
        return token


# 角色（职位，职级）
class Role(BaseModel, db.Model):
    __tablename__ = "role"
    __table_args__ = ({'comment': '用户角色表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 企业
    role_name = db.Column(db.String(255), unique=True)  # 角色名
    role = db.Column(db.String(10), unique=True)  # 权限值 000000 0位位职级123，后面为权限01
    info = db.Column(db.String(255))  # 权限说明


# 创新资源-高等院校(985,211,本科，高职专高)
class College(db.Model):
    __tablename_ = "college"
    __table_args__ = ({'comment': '创新资源-高等院校表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 省市区层级分类

    category = db.Column(db.String(255))  # 学校类型 211工程院校1,普通本科2,高职专高3
    cateid = db.Column(db.Integer)  # 学校类型 211工程院校1,普通本科2,高职专高3
    name = db.Column(db.String(255))  # 高等院校高职专科等机构名称
    ccode = db.Column(db.String(255))  # 院校代码
    buildate = db.Column(db.String(255))  # 创建时间
    nature = db.Column(db.String(255))  # 办学性质
    clas = db.Column(db.String(255))  # 学校类别
    feature = db.Column(db.String(255))  # 学校特色
    charge = db.Column(db.String(255))  # 主管部门
    major = db.Column(db.String(255))  # 专业设置
    faculty = db.Column(db.String(255))  # 院系设置
    introduct = db.Column(db.Text)  # 院校简介
    address = db.Column(db.String(255))  # 所在地址
    lng = db.Column(db.String(255))  # 经度
    lat = db.Column(db.String(255))  # 纬度

    navigator = db.Column(db.String(255))  # 导航一
    navigat = db.Column(db.String(255))  # 导航二

    research = db.Column(db.String(255))  # 研究方向
    admin = db.Column(db.String(255))  # 所在行政区
    developarea = db.Column(db.String(255))  # 所在开发区


# 创新资源-科研机构
class Scientific(db.Model):
    __tablename_ = "scientific"
    __table_args__ = ({'comment': '创新资源-科研机构表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(255))  # 机构现名
    introduct = db.Column(db.Text)  # 机构简介
    buildate = db.Column(db.DateTime)  # 创建时间
    telephone = db.Column(db.String(255))  # 电话
    fax = db.Column(db.String(255))  # 传真
    postcode = db.Column(db.String(255))  # 邮编
    address = db.Column(db.String(255))  # 所在地址
    lng = db.Column(db.String(255))  # 经度
    lat = db.Column(db.String(255))  # 纬度

    research = db.Column(db.String(255))  # 研究方向
    admin = db.Column(db.String(255))  # 所在行政区
    developarea = db.Column(db.String(255))  # 所在开发区

    navigator = db.Column(db.String(255))  # 导航一
    navigat = db.Column(db.String(255))  # 导航二


# 创新资源-创新平台（实验室等）
class Lab(db.Model):
    __tablename_ = "lab"
    __table_args__ = ({'comment': '创新资源-创新平台表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True)

    cate = db.Column(db.String(255))  # 创新平台分类
    cateid = db.Column(db.Integer)  # 创新平台分类id
    # 工程技术中心1,国际科技合作基地2,企业技术中心3,双创基地4,院士工作站5,质量检测与测量中心6,重点实验室7，会议会展8

    name = db.Column(db.String(255))  # 机构现名
    fax = db.Column(db.String(255))  # 传真
    postcode = db.Column(db.String(255))  # 邮编
    introduct = db.Column(db.Text)  # 机构简介
    address = db.Column(db.String(255))  # 所在地址
    lng = db.Column(db.String(255))  # 经度
    lat = db.Column(db.String(255))  # 纬度
    city = db.Column(db.String(255))  # 城市

    navigator = db.Column(db.String(255))  # 导航一
    navigat = db.Column(db.String(255))  # 导航二

    research = db.Column(db.String(255))  # 研究方向
    admin = db.Column(db.String(255))  # 所在行政区
    developarea = db.Column(db.String(255))  # 所在开发区


# 产业载体-土地数据
class ZaitiLand(db.Model):
    __tablename_ = "zaiti_land"
    __table_args__ = ({'comment': '产业载体-土地数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    num = db.Column(db.String(20))
    name = db.Column(db.String(20))
    addr = db.Column(db.String(50))
    nature = db.Column(db.String(20))
    acreage = db.Column(db.String(50))
    target = db.Column(db.String(255))
    age_limit = db.Column(db.String(20))
    industry_type = db.Column(db.String(255))
    telephone = db.Column(db.String(20))
    navigator = db.Column(db.String(10))
    navigat = db.Column(db.String(20))


# 产业载体-楼宇数据
class ZaitiBuild(db.Model):
    __tablename_ = "zaiti_build"
    __table_args__ = ({'comment': '产业载体-楼宇数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(20))
    addr = db.Column(db.String(50))
    acreage = db.Column(db.String(50))
    buide_type = db.Column(db.String(20))
    industry_type = db.Column(db.String(255))
    rate = db.Column(db.String(20))
    telephone = db.Column(db.String(20))
    navigator = db.Column(db.String(10))
    navigat = db.Column(db.String(20))


# 产业载体-楼宇数据
class ZaitiFactory(db.Model):
    __tablename_ = "zaiti_factory"
    __table_args__ = ({'comment': '产业载体-厂房数据表'})  # 添加表注释
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(20))
    addr = db.Column(db.String(50))
    acreage = db.Column(db.String(50))
    structure = db.Column(db.String(20))
    height = db.Column(db.String(20))
    bearing = db.Column(db.String(50))
    new_level = db.Column(db.String(20))
    other = db.Column(db.String(255))
    industry_type = db.Column(db.String(20))
    factory_type = db.Column(db.String(20))
    telephone = db.Column(db.String(20))
    navigator = db.Column(db.String(10))
    navigat = db.Column(db.String(20))


# 雷达评估页行业在不同地区的测评分数
class EvaluationNodeData(db.Model):
    __tablename_ = "evaluation_data"
    __table_args__ = ({'comment': '产业招商雷达-产业评估'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')
    c_type = db.Column(db.Integer, index=True, doc='行业id', comment='行业id')  # 行业id

    province = db.Column(db.String(32), index=True, doc='省份', comment='省份')  # 省份
    city = db.Column(db.String(32), index=True, doc='城市', comment='城市')  # 城市
    district = db.Column(db.String(32), index=True, doc='区域', comment='区域')  # 区域

    product = db.Column(db.String(32), index=True, doc='产品名', comment='产品名')  # 产品名
    score = db.Column(db.Integer, doc='综合分', comment='综合分')  # 综合分


# 选址评分部分--企业聚合度
class CompanyIndustryPoint(db.Model):
    __tablename_ = "company_industry_point"
    __table_args__ = ({'comment': '选址评分部分--企业聚合度数据表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')
    district = db.Column(db.String(32), doc='区县园区名', comment='区县园区名')  # 区县园区名
    point = db.Column(db.Float, doc='分数', comment='分数')  # 分数
    f_type = db.Column(db.Integer, doc='类型，对应产业导航nid', comment='类型，对应产业导航nid')  # 类型，对应产业导航nid


# 360企业画像--下拉框内容数据表（企业类型，资质，上市状态，融资轮次）
class Property(db.Model):
    __tablename_ = "property"
    __table_args__ = ({'comment': '360企业画像--下拉框内容数据表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')
    name = db.Column(db.String(32), doc='字段名', comment='字段名')  # 字段名
    nid = db.Column(db.Integer, doc='字段id', comment='字段id')  # 字段id
    sid = db.Column(db.Integer, doc='字段类型id', comment='字段类型id')  # 字段类型id 1企业类型，2企业资质，3上市状态，4融资轮次
    statu = db.Column(db.Integer, doc='状态:1启动，2禁用', comment='状态:1启动，2禁用')  # 状态 1启动，2禁用


# 查找历史表
class SearchList(BaseModel, db.Model):
    __tablename__ = "search_list"
    __table_args__ = ({'comment': '360企业画像--查找历史数据表'})  # 添加表注释

    id = db.Column(db.Integer, primary_key=True, autoincrement=True, doc='主键id', comment='主键id')
    history = db.Column(db.String(128), doc='用户搜索历史', comment='用户搜索历史')  # 用户搜索历史
    user_id = db.Column(db.Integer, db.ForeignKey("user.id"), doc='用户id', comment='用户id')
    section = db.relationship('User', backref=db.backref('searchlist'))  # 用户-搜索






# # 创新资源-双创平台
# class Platform(db.Model):
#     __tablename_ = "platform"
#     __table_args__ = ({'comment': '创新资源-双创平台表'})  # 添加表注释
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#
#     cate = db.Column(db.String(64))  # 产业服务平台分类  产业联盟1,公共服务平台2,行业协会3
#     cateid = db.Column(db.Integer)  # 产业服务平台分类id  产业联盟1,公共服务平台2,行业协会3
#     name = db.Column(db.String(64))  # 平台名称
#     introduct = db.Column(db.Text)  # 平台简介
#     address = db.Column(db.String(64))  # 地址
#     lng = db.Column(db.String(100))  # 经度
#     lat = db.Column(db.String(100))  # 纬度
#     city = db.Column(db.String(32))  # 城市
#
#     navigator = db.Column(db.String(255))  # 导航一
#     navigat = db.Column(db.String(255))  # 导航二
#
#     research = db.Column(db.String(255))  # 研究方向
#     admin = db.Column(db.String(255))  # 所在行政区
#     developarea = db.Column(db.String(255))  # 所在开发区


# 资源机构的位置信息+research（产品词扩展）
# class Orgs(db.Model):
#     __tablename_ = "orgs"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(255))  # 机构名
#     category = db.Column(db.String(255))  # 机构类型
#     admin = db.Column(db.String(255))  # 所在行政区
#     lng = db.Column(db.String(255))  # 经度
#     lat = db.Column(db.String(255))  # 纬度
#
#     research = db.Column(db.String(255))  # research
#     navigator = db.Column(db.String(255))  # 导航一
#     navigat = db.Column(db.String(255))  # 导航二







#
#
# # # 园区政策
# # class Zonepolicy(db.Model):
# #     __tablename_ = "zonepolicy"
# #
# #     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
# #     name = db.Column(db.String(32))  # 园区政策名
# #     pubdate = db.Column(db.DateTime)  # 发布时间
# #     org = db.Column(db.String(32))  # 政策发布机构
# #     url = db.Column(db.String(255))  # 外链接
# #     file = db.Column(db.String(255))  # 本地文件位置
# #     induzone_id = db.Column(db.Integer, db.ForeignKey("induzone.id"))
# #     zone = db.relationship('Induzone', backref=db.backref('policys'))  # 园区政策
#
#
# # 产业政策（wf）
#
#
#
#
#
#

#
#
# # 企业属性导航全部（企业类型，资质，上市状态，融资轮次）
# class Property(db.Model):
#     __tablename_ = "property"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(32))  # 字段名
#     nid = db.Column(db.Integer)  # 字段id
#     sid = db.Column(db.Integer)  # 字段类型id 1企业类型，2企业资质，3上市状态，4融资轮次
#     statu = db.Column(db.Integer)  # 状态 1启动，2禁用
#
#
# # 招商资源管理字典（行业选择，项目阶段）
# class Attract(db.Model):
#     __tablename_ = "view_map"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(32))  # 字段名
#     nid = db.Column(db.Integer)  # 字段id（在项目数据中的id）
#     sid = db.Column(db.Integer)  # 字段类型id 1行业选择，2项目进度 3项目级别
#     statu = db.Column(db.Integer)  # 状态 1启动，2禁用
#
#
# # 园区信息管理字典（行业选择，项目阶段）
# class Zone(db.Model):
#     __tablename_ = "zone"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(32))  # 字段名
#     nid = db.Column(db.Integer)  # 字段id（在项目中的id）
#     sid = db.Column(db.Integer)  # 字段类型id 1园区类别，2园区级别
#     statu = db.Column(db.Integer)  # 状态 1启动，2禁用
#
#
# # 雷达评估页行业在不同地区的测评分数
# class EvaluationData(db.Model):
#     __tablename_ = "evaluationdata"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     c_type = db.Column(db.Integer)  # 行业id
#
#     province = db.Column(db.String(32))  # 省份
#     city = db.Column(db.String(32))  # 城市
#     district = db.Column(db.String(32))  # 区域
#
#     development = db.Column(db.Integer)  # 发育度
#     contribute = db.Column(db.Integer)  # 贡献度
#     innovate = db.Column(db.Integer)  # 创新度
#     growup = db.Column(db.Integer)  # 成长性
#     capital = db.Column(db.Integer)  # 资本力
#     general = db.Column(db.Integer)  # 综合分
#
#

#
#

#
#
#
#
#
#
#
#
#
#
#
#
#
#
# # # 产品描述简介
# # class ProductInfo(BaseModel, db.Model):
# #     __tablename__ = "product_info"
# #
# #     id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # id
# #     name = db.Column(db.String(32))  # 产品名
# #     info = db.Column(db.Text)  # 产品描述
#
#
# # 后台管理用户
# class Bstage(BaseModel, db.Model):
#     __tablename__ = "bstage"
#
#     # 基本信息
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 用户编号
#     name = db.Column(db.String(32), unique=True)  # 用户名
#     password_hash = db.Column(db.String(128))  # 加密的密码
#
#     # 角色(职级配置)
#     role = db.Column(db.Integer)  # 1超级管理员，2 系统运维员
#
#     @property
#     def password(self):
#         # 设置为只写的方式
#         # return self.password_hash
#         raise AttributeError('这个属性只能设置，不能读取')
#
#     @password.setter
#     def password(self, value):
#         self.password_hash = generate_password_hash(value)
#
#     def check_password(self, password):
#         '''检验密码的正确性，传入参数为用户登录时填写的密码'''
#         return check_password_hash(self.password_hash, password)
#
#
# # 区域要素管理（园区）
# class Garden(db.Model):
#     __tablename__ = "garden"
#
#     # 基本信息
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#
#     unit = db.Column(db.String(255))  # 园区所属机构
#     section = db.Column(db.String(255))  # 园区所属部门
#     user = db.Column(db.Integer)  # 园区创建人id
#     uperson = db.Column(db.String(255))  # 园区上报人
#     up_unit = db.Column(db.String(255))  # 园区上报机构
#     status = db.Column(db.Enum("审核通过", "审核驳回", "正在审核", "未上报"), default="未上报", view_index=True)  # 园区上报状态
#
#     name = db.Column(db.String(255))  # 园区姓名
#     level = db.Column(db.String(255))  # 园区级别
#     charge = db.Column(db.String(255))  # 园区负责人
#     phone = db.Column(db.String(255))  # 园区联系电话
#     cate = db.Column(db.String(255))  # 园区类型
#     address = db.Column(db.String(255))  # 园区地址
#     cluster = db.Column(db.String(255))  # 产业集群（多选）
#
#     # 土地信息
#     land_code = db.Column(db.String(255))  # 土地位置/编号
#     land_property = db.Column(db.String(255))  # 土地性质
#     land_range = db.Column(db.String(255))  # 土地范围
#     land_size = db.Column(db.String(255))  # 土地面积/平方公里
#     indu_appeal = db.Column(db.String(255))  # 产业诉求
#     # 楼宇信息
#     build_name = db.Column(db.String(255))  # 楼宇名称
#     build_add = db.Column(db.String(255))  # 楼宇地址
#     build_size = db.Column(db.String(255))  # 楼宇面积/平方公里
#     build_appeal = db.Column(db.String(255))  # 楼宇诉求
#     # 厂房信息
#     plant_add = db.Column(db.String(255))  # 厂房位置
#     plant_size = db.Column(db.String(255))  # 厂房面积
#     plant_condition = db.Column(db.String(255))  # 厂房条件
#
#     # 园区信息
#     area = db.Column(db.String(64))  # 占地面积(平方公里)
#     acreage = db.Column(db.String(32))  # 规划面积（平方公里）
#     actarea = db.Column(db.String(32))  # 建成面积（平方公里）
#     tax = db.Column(db.String(32))  # 税收要求（万元/亩）
#     out_power = db.Column(db.String(32))  # 产出强度（万元/亩）
#     invest_power = db.Column(db.String(32))  # 投资强度（万元/亩）
#     indu_need = db.Column(db.String(255))  # 行业要求
#     gdp = db.Column(db.String(32))  # GDP(亿元)
#     fiscal = db.Column(db.String(32))  # 财政收入（亿元）
#     indu_land = db.Column(db.String(32))  # 工业土地均价（万元/亩）
#     indu_sup = db.Column(db.String(32))  # 工业土地供应量
#     comm_land = db.Column(db.String(32))  # 商办土地均价（万元/亩）
#     comm_sup = db.Column(db.String(32))  # 商办土地供应量
#     represent = db.Column(db.Text)  # 代表企业
#
#     # 投资成本
#     resident_ele_one = db.Column(db.String(32))  # 居民用电（一档）（元/度）
#     resident_ele_two = db.Column(db.String(32))  # 居民用电（二档）（元/度）
#     resident_ele_thr = db.Column(db.String(32))  # 居民用电（三档）（元/度）
#     comm_ele_one = db.Column(db.String(32))  # 商业用电（峰段）（元/度）
#     comm_ele_two = db.Column(db.String(32))  # 商业用电（平段）（元/度）
#     comm_ele_thr = db.Column(db.String(32))  # 商业用电（谷段）（元/度）
#     indu_ele_one = db.Column(db.String(32))  # 工业用电（峰段）（元/度）
#     indu_ele_two = db.Column(db.String(32))  # 工业用电（平段）（元/度）
#     indu_ele_thr = db.Column(db.String(32))  # 工业用电（谷段）（元/度）
#     resident_water_one = db.Column(db.String(32))  # 居民用水（一档）（元/吨）
#     resident_water_two = db.Column(db.String(32))  # 居民用水（二档）（元/吨）
#     resident_water_thr = db.Column(db.String(32))  # 居民用水（三档）（元/吨）
#     comm_water = db.Column(db.String(32))  # 商业用水（元/吨）
#     indu_water = db.Column(db.String(32))  # 工业用水（元/吨）
#     special_water = db.Column(db.String(32))  # 特种用水（元/吨）
#     resident_natgas_one = db.Column(db.String(32))  # 居民用气（一档）（元/m³）
#     resident_natgas_two = db.Column(db.String(32))  # 居民用气（二档）（元/m³）
#     resident_natgas_thr = db.Column(db.String(32))  # 居民用气（三档）（元/m³）
#     sewage = db.Column(db.String(32))  # 污水处理（元/吨）
#     wagelevel = db.Column(db.String(32))  # 最低工资标准（元/月）
#     worker = db.Column(db.String(32))  # 普通员工（元/月）
#     middlemag = db.Column(db.String(32))  # 中级管理人员（元/月）
#     highmag = db.Column(db.String(32))  # 高层管理人员（元/月）
#     # 环境配套
#     dis_freight = db.Column(db.String(255))  # 距离货运站距离
#     dis_rail = db.Column(db.String(255))  # 距离高铁站
#     dis_port = db.Column(db.String(255))  # 距离港口距离
#     dis_air = db.Column(db.String(255))  # 距离机场距离
#     road_trans = db.Column(db.String(255))  # 公路运输
#     rail_trans = db.Column(db.String(255))  # 铁路运输
#     live_facility = db.Column(db.String(255))  # 园区生活配套
#     market = db.Column(db.String(255))  # 百货商场
#     hotel_bus = db.Column(db.String(255))  # 酒店商务
#     medical = db.Column(db.String(255))  # 医疗机构
#     education = db.Column(db.String(255))  # 学校教育
#
#     induenterprise = db.Column(db.Text)  # 规模以上企业
#     innovate = db.Column(db.Text)  # 科研机构
#     base = db.Column(db.Text)  # 双创基地
#     carrier = db.Column(db.Text)  # 产业载体
#     url_file = db.Column(db.String(255))  # 文件路由
#
#
# # 区域要素管理下文件（文件和图片）
# class Gfile(BaseModel, db.Model):
#     __tablename__ = "gfile"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(255), unique=True)  # 文件名
#     size = db.Column(db.String(255))  # 文件大小
#     uperson = db.Column(db.String(255))  # 上传人
#     cate = db.Column(db.Integer)  # 文件类型，1文件，2图片
#     url = db.Column(db.String(255))  # 文件本地地址
#     garden_id = db.Column(db.Integer, db.ForeignKey("garden.id"))
#     garden = db.relationship('Garden', backref=db.backref('document'))  # 园区1-N文件、图片
#
#
# # 手机端项目搜索历史
# class SearchItem(db.Model):
#     __tablename__ = "searchitem"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     history = db.Column(db.String(128))  # 用户搜索历史
#     user_id = db.Column(db.Integer, db.ForeignKey("user.id"))  # 用户外键
#     section = db.relationship('User', backref=db.backref('searchitem'))  # 用户-搜索
#
#
# # 太原给的，招商驾驶舱的企业数据（招商驾驶舱左上角）
# class ZCompany(db.Model):
#     __tablename__ = "zcompany"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     name = db.Column(db.String(255))  # 公司名称
#     quality = db.Column(db.String(1))  # 公司类型 012345  （500-上市-规模-专精特新-高新-科技型中小）
#     quality_name = db.Column(db.String(32))  # 公司类型名称
#     district = db.Column(db.String(255))  # 区县名
#     company_name = db.Column(db.String(255))  # 公司名称（）
#
#
# # class ZCollge(db.Model):
# #     __tablename__ = "zcollege"
# #
# #     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
# #     name = db.Column(db.String(255))  # 公司名称
# #     category = db.Column(db.String(1))  # 公司类型
# #     category_name = db.Column(db.String(32))  # 公司类型名称
# #     district = db.Column(db.String(255))  # 区县名
# #     college_name = db.Column(db.String(255))  # 公司名称
# #
# #
# # class ZScientific(db.Model):
# #     __tablename__ = "zscientific"
# #
# #     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
# #     name = db.Column(db.String(255))  # 机构名称
# #     district = db.Column(db.String(255))  # 区县名
# #     scientific_name = db.Column(db.String(255))  # 科研机构名称
# #
# #
# # class Zlab():
# #     __tablename__ = "zlab"
# #
# #     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
# #     name = db.Column(db.String(255))  # 机构名称
# #     district = db.Column(db.String(255))  # 区县名
# #     lab_name = db.Column(db.String(255))  # 科研机构名称
#
# # 作战图
# class YearMonth(db.Model):
#     __tablename__ = "year_month"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)
#     year = db.Column(db.String(4))  # 年
#     month = db.Column(db.String(2))  # 月
#
#
# # 对应zcompany的企业详情
# class ZhaoShang(db.Model):
#     __tablename__ = "zhaoshang"
#
#     id = db.Column(db.Integer, primary_key=True, autoincrement=True)  # 企业
#     company_name = db.Column(db.String(255))  # 企业名
#     status = db.Column(db.String(32))  # 经营状态
#     legal = db.Column(db.String(32))  # 发定代表人
#     capital = db.Column(db.String(255))  # 注册资本,22万美元
#     capital_nums = db.Column(db.Float)  # 注册资本转换成人民币数值
#     build_date = db.Column(db.DateTime)  # 注册时间
#     province = db.Column(db.String(32))  # 省
#     city = db.Column(db.String(32))  # 市
#     district = db.Column(db.String(32))  # 区
#     lng = db.Column(db.String(100))  # 经度
#     lat = db.Column(db.String(100))  # 纬度
#     address = db.Column(db.String(255))  # 企业地址
#     telephone = db.Column(db.Text)  # 电话
#     email = db.Column(db.Text)  # 邮箱
#     social_code = db.Column(db.String(100))  # 统一社会信用代码
#     bao_num = db.Column(db.String(32))  # 参保人数
#     entype = db.Column(db.String(100))  # 企业类型
#     company_industry = db.Column(db.String(100))  # 所属行业
#     web_site = db.Column(db.String(255))  # 企业网址
#     business_scope = db.Column(db.Text)  # 企业经营范围
#
#     isfive = db.Column(db.String(32))  # 是否中国500强
#
#     scale = db.Column(db.String(32))  # 规模以上企业
#     zjtg = db.Column(db.String(32))  # 山西专精特工企业
#     high_new = db.Column(db.String(32))  # 是否高新技术企业
#     tbe = db.Column(db.String(32))  # 是否科技型中小企业
#     quoted_company = db.Column(db.String(32))  # 是否上市企业
#
#     induzone = db.Column(db.String(255))  # 所在园区
#     company_info = db.Column(db.Text)  # 公司简介
#     product = db.Column(db.String(255))  # 产品
#     takingn = db.Column(db.Float)  # 营收