from flask import request, jsonify, current_app, g
from apps.manage import api_power
from apps.models import *
from apps.utils.response_code import RET
from apps.util import login_required


# 获取上级或下级统筹机构 (ok)
@api_power.route("/uadOrg", methods=["GET"])
@login_required
def uad_org():
    try:
        gover = Government.query.all()
        data = [{"label": i.name, "value": i.id} for i in gover]
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 获取上级机构后的统筹机构 (ok)
@api_power.route("/downOrg", methods=["POST"])
@login_required
def down_org():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 机构名称
    try:
        if _id:
            gover = Government.query.all()
            data = [{"label": i.name, "value": i.id} for i in gover if i.id != _id]
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        else:
            gover = Government.query.all()
            data = [{"label": i.name, "value": i.id} for i in gover]
            return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 新增机构组织（ok）
@api_power.route("/addOrg", methods=["POST"])
@login_required
def add_org():
    '''
    不得重名
    '''
    req_dict = request.get_json()
    name = req_dict.get("name")  # 机构名称
    forg = req_dict.get("forg")  # 上级机构 id
    charge = req_dict.get("charge")  # 机构负责人
    charge_phone = req_dict.get("charge_phone")  # 负责人电话
    sublist = req_dict.get("sublist")  # 统筹机构id list["1","2"...]

    # 校验参数完整性
    if not all([name]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        gover = Government.query.filter_by(name=name).first()
        if gover:  # 机构名相同，提示其错误
            return jsonify(code=RET.DBERR, msg="机构名重复")

        goverment = Government(name=name)  # 创建机构
        if charge:
            goverment.charge = charge
        if charge_phone:
            goverment.charge_phone = charge_phone
        db.session.add(goverment)  # 添加到数据库

        if forg:  # 如果有上级机构，就让上级机构统筹新增机构
            fgover = Government.query.get(forg)
            fgover.followed.append(goverment)
        for ctr in sublist:  # 如果有统筹机构，就让新增机构统筹
            sgover = Government.query.get(ctr)
            goverment.followed.append(sgover)
        db.session.commit()  # 提交数据库
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 组织架构管理,获取机构单位数据（ok）
@api_power.route("/organization", methods=["POST"])
@login_required
def organization():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        # goverment = Government.query.paginate(page, perpage).items
        goverment = Government.query.all()
        size = Government.query.count()
        df = [{"id": gover.id,
               "name": gover.name,
               "pnums": gover.pnums if gover.pnums else 0,
               "charge": gover.charge if gover.charge else "-",
               "charge_phone": gover.charge_phone if gover.charge_phone else "-",
               "cate": 1} for gover in goverment]
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误", data=[])


# 组织架构获取部门和组（Ok）
@api_power.route("/sectionGroup", methods=["POST"])
@login_required
def section_group():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当前机构或者部门的id
    cate = req_dict.get("cate")  # 分类标识，1机构，2部门

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 查询当前机构下的部门
            goverment = Government.query.get(_id)
            sections = goverment.sections  # 查询当前机构下的部门list
            data = [{"id": sec.id,
                     "name": sec.name,
                     "pnums": sec.pnums if sec.pnums else 0,
                     "charge": sec.charge if sec.charge else "-",
                     "charge_phone": sec.charge_phone if sec.charge_phone else "-",
                     "cate": 2} for sec in sections]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        if cate == 2:  # 查询当前部门下的组
            section = Section.query.get(_id)
            groups = section.groups  # 查询当前部门下的组list
            data = [{"id": group.id,
                     "name": group.name,
                     "pnums": group.pnums if group.pnums else 0,
                     "charge": group.charge if group.charge else "-",
                     "charge_phone": group.charge_phone if group.charge_phone else "-",
                     "cate": 3} for group in groups]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        return jsonify(code=RET.OK, msg="暂无下级信息", data=[])
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误", data=[])


# 新增下级部门(ok)
@api_power.route("/addSub", methods=["POST"])
@login_required
def add_sub():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当前机构或者部门id
    cate = req_dict.get("cate")  # 分类标识，1机构，2部门
    name = req_dict.get("name")  # 部门或组名称
    pnums = req_dict.get("pnums")  # 机构负责人
    charge = req_dict.get("charge")  # 机构负责人
    charge_phone = req_dict.get("charge_phone")  # 负责人电话

    # 校验参数完整性
    if not all([_id, cate, name]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 增加部门
            sec = Section.query.filter_by(name=name, goverment_id=_id).first()
            if sec:  # 一个机构下部门名不能重复
                return jsonify(code=RET.DATAERR, msg="部门名重复")
            goverment = Government.query.get(_id)
            section = Section(name=name, goverment_id=_id)
            if pnums:
                section.pnums = pnums
            if charge:
                section.charge = charge
            if charge_phone:
                section.charge_phone = charge_phone
            db.session.add(section)  # 添加部门
            goverment.sections.append(section)  # 外键关系添加
            db.session.commit()  # 数据库提交
        if cate == 2:  # 增加组
            gro = Group.query.filter_by(name=name, section_id=_id).first()
            if gro:  # 一个部门下组名不能重复
                return jsonify(code=RET.DATAERR, msg="组名重复")
            section = Section.query.get(_id)
            group = Group(name=name, section_id=_id)
            if pnums:
                group.pnums = pnums
            if charge:
                group.charge = charge
            if charge_phone:
                group.charge_phone = charge_phone
            db.session.add(group)  # 添加组
            section.groups.append(group)  # 添加关系
            db.session.commit()  # 提交
        if cate == 3:
            return jsonify(code=RET.OK, msg="暂无下级机构，请勿继续添加")
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        # 操作失败，数据回滚
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 删除组织机构或者部门和组(需要先删除人员)--------OK
@api_power.route("/deleteOrg", methods=["POST"])
@login_required
def deleteorg():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 待删除的，部门、机构、组、id
    cate = req_dict.get("cate")  # 待删除数据的类别 1政府，2部门，3组

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 删除机构
            gover = Government.query.get(_id)  # 当前机构对象
            section = gover.sections  # 当前机构下的部门对象列表
            if len(section) > 0:  # 有部门就需要先删除部门
                return jsonify(code=RET.REQERR, msg="当前机构有部门存在，请清除后再操作")
            unums = User.query.filter_by(unit=gover.name, status=1).count()  # 当前机构下通过审核人员
            if unums > 0:  # 当前部门有人，先到机构详情，进行人员的删除
                return jsonify(code=RET.REQERR, msg="当前机构有人员存在，请清除后再操作")
            db.session.delete(gover)  # 无人无部门，删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        if cate == 2:  # 删除部门
            section = Section.query.get(_id)
            gover = section.goverment  # 部门所属的机构
            group = section.groups  # 当前部门的组对象list
            if len(group) > 0:  # 如果有组先删除组
                return jsonify(code=RET.REQERR, msg="当前部门有组存在，请清除后再操作")
            unums = User.query.filter_by(unit=gover.name, section=section.name, status=1).count()  # # 已经通过审核的人数
            if unums > 0:  # 当前部门有人，先到部门详情，进行部门人员的删除
                return jsonify(code=RET.REQERR, msg="当前部门有人员存在，请清除后再操作")
            gover.sections.remove(section)  # 当前部门没有人，没有组，删除部门之前需要先删除与之相关的机构关系
            db.session.delete(section)  # 删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        if cate == 3:  # 删除组
            group = Group.query.get(_id)  # 当前组信息
            section = group.section  # 组属于的部门，单个对象
            gover = section.goverment  # 部门属于的机构，单个对象
            unums = User.query.filter_by(unit=gover.name, section=section.name, group=group.name,
                                         status=1).count()  # 已经通过审核的人数
            if unums > 0:  # 当前组有人，先到组详情，进行组员的删除
                return jsonify(code=RET.REQERR, msg="当前组有人员存在，请清除后再操作")
            section.groups.remove(group)  # 当前组没有人，删除组之前需要先删除与之相关的部门关系
            db.session.delete(group)  # 删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作失败")


''''''


# 获取机构，部门或者组详情()
@api_power.route("/orgDetail", methods=["POST"])
@login_required
def org_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # id
    cate = req_dict.get("cate")  # 1机构，2部门，3组

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 政府机构详情
            goverment = Government.query.get(_id)
            # 政府信息
            data = {"id": goverment.id,
                    "name": goverment.name,  # 机构名
                    "charge": goverment.charge if goverment.charge else "-",  # 主管
                    "phone": goverment.charge_phone if goverment.charge_phone else "-",  # 电话
                    "pnums": goverment.pnums if goverment.pnums else 0,  # 机构人数
                    "secnums": len(goverment.sections),  # 部门数
                    "func": goverment.function if goverment.function else "",  # 政府职能
                    "cate": cate}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        if cate == 2:  # 部门详情
            section = Section.query.get(_id)
            # 政府信息
            data = {"id": section.id,
                    "name": section.name,  # 机构名
                    "charge": section.charge if section.charge else "-",  # 主管
                    "phone": section.charge_phone if section.charge_phone else "-",  # 电话
                    "pnums": section.pnums if section.pnums else 0,  # 机构人数
                    "secnums": len(section.groups),  # 组数
                    "func": section.function if section.function else "",  # 部门职能
                    "cate": cate}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        if cate == 3:  # 组详情
            group = Group.query.get(_id)
            # 政府信息
            data = {"id": group.id,
                    "name": group.name,  # 机构名
                    "charge": group.charge if group.charge else "-",  # 主管
                    "phone": group.charge_phone if group.charge_phone else "-",  # 电话
                    "pnums": group.pnums if group.pnums else 0,  # 机构人数
                    "secnums": "-",
                    "func": group.function if group.function else "",  # 部门职能
                    "cate": cate}
            return jsonify(code=RET.OK, msg="查询成功", data=data)

        return jsonify(code=RET.OK, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 编辑机构，部门或者组详情
@api_power.route("/editDetail", methods=["POST"])
@login_required
def edit_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 部门id
    cate = req_dict.get("cate")  # 1机构，2部门，3组
    name = req_dict.get("name")  # 1机构，2部门，3组  的名称
    charge = req_dict.get("charge")  # 局内领导
    charge_phone = req_dict.get("charge_phone")  # 联系方式
    func = req_dict.get("func")  # 部门职能
    pnums = str(req_dict.get("pnums"))  # 人数
    secnums = str(req_dict.get("secnums"))  # 部门组人数

    # 校验参数完整性
    if not all([_id, name, charge, charge_phone, pnums, secnums]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 机构
            gover = Government.query.filter_by(name=name).filter(Government.id != _id).first()
            if gover:
                return jsonify(code=RET.DBERR, msg="机构名不可重复")
            gover = Government.query.get(_id)
            gover.name = name
            gover.charge = charge
            gover.charge_phone = charge_phone
            gover.function = func
            gover.pnums = pnums
            gover.secnums = secnums
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        if cate == 2:  # 部门
            section = Section.query.get(_id)  # 当前部门
            gover_id = section.goverment_id  # 当前部门的机构id
            sec = Section.query.filter_by(name=name, goverment_id=gover_id).filter(Section.id != _id).first()
            if sec:  # 当前机构下此部门名已存在
                return jsonify(code=RET.DBERR, msg="部门名不可重复")
            section.name = name
            section.charge = charge
            section.charge_phone = charge_phone
            section.function = func
            section.pnums = pnums
            section.secnums = secnums
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        if cate == 3:  # 组
            group = Group.query.get(_id)  # 当前组
            sec_id = group.section_id  # 当前组的部门id
            gro = Group.query.filter_by(name=name, section_id=sec_id).filter(Group.id != _id).first()
            if gro:  # 当前部门下此组名已存在
                return jsonify(code=RET.DBERR, msg="组名不可重复")
            group.name = name
            group.charge = charge
            group.charge_phone = charge_phone
            group.function = func
            group.pnums = pnums
            group.secnums = secnums
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        return jsonify(code=RET.DATAERR, msg="cate参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 获取机构，部门或者组的人员
@api_power.route("/orgStaff", methods=["POST"])
@login_required
def org_staff():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 部门id
    cate = req_dict.get("cate")  # 1机构，2部门，3组

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 政府机构详情
            goverment = Government.query.get(_id)
            # 人员列表
            staff = User.query.filter_by(status=1, unit=goverment.name).filter(User.role_id.isnot(None)).all()  # 通过审核的员工列表
            staff = [{"id": i.id,
                      "name": i.real_name,
                      "position": i.position,
                      "section": i.section} for i in staff]
            return jsonify(code=RET.OK, msg="查询成功", data=staff)
        if cate == 2:  # 部门详情
            section = Section.query.get(_id)
            # 人员列表
            staff = User.query.filter_by(status=1, unit=section.goverment.name, section=section.name).filter(User.role_id.isnot(None)).all()  # 通过审核的员工列表
            staff = [{"id": i.id,
                      "name": i.real_name,
                      "position": i.position,
                      "section": i.section} for i in staff]
            return jsonify(code=RET.OK, msg="查询成功", data=staff)
        if cate == 3:  # 组详情
            group = Group.query.get(_id)
            # 人员列表
            staff = User.query.filter_by(status=1, unit=group.section.goverment.name, section=group.section.name,
                                         group=group.name).filter(User.role_id.isnot(None)).all()  # 通过审核的员工列表
            staff = [{"id": i.id,
                      "name": i.real_name,
                      "position": i.position,
                      "section": i.section} for i in staff]
            return jsonify(code=RET.OK, msg="查询成功", data=staff)
        else:
            return jsonify(code=RET.OK, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 机构部门或这组的待新增人员列表-------------------?
@api_power.route("/listOfStaff", methods=["POST"])
# @login_required
def list_Staff():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当前机构id
    cate = req_dict.get("cate")  # 1机构 2部门 3组

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if cate == 1:  # 政府
            gover = Government.query.get(_id)
            if gover:
                name = gover.name
                user = User.query.filter_by(unit=name).filter(User.role_id.isnot(None)).all()
                data = [{"id": i.id,
                         "real_name": i.real_name if i.real_name else i.id} for i in user]
                return jsonify(code=RET.OK, msg="查询成功", data=data)
            else:
                return jsonify(code=RET.DATAERR, msg="参数错误")
        if cate == 2:  # 部门
            section = Section.query.get(_id)
            if section:
                gover = section.goverment
                user = User.query.filter_by(unit=gover.name).filter(User.role_id.isnot(None)).all()
                data = [{"id": i.id,
                         "real_name": i.real_name if i.real_name else i.id} for i in user]
                return jsonify(code=RET.OK, msg="查询成功", data=data)
            else:
                return jsonify(code=RET.DATAERR, msg="参数错误")
        if cate == 3:  # 组
            group = Group.query.get(_id)
            if group:
                section = group.section
                gover = section.goverment
                user = User.query.filter_by(unit=gover.name).filter(User.role_id.isnot(None)).all()
                data = [{"id": i.id,
                         "real_name": i.real_name if i.real_name else i.id} for i in user]
                return jsonify(code=RET.OK, msg="查询成功", data=data)
            else:
                return jsonify(code=RET.DATAERR, msg="参数错误")
        return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 机构部门或这组的人员 新增（人员部门调度）
@api_power.route("/addStaffOrg", methods=["POST"])
# @login_required
def add_staff():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 部门机构组id
    cate = req_dict.get("cate")  # 1政府，2部门，3组
    uid = req_dict.get("uid")  # 员工id
    level = req_dict.get("level")  # 职级(角色id)
    position = req_dict.get("position")  # 职务,文本框随意填

    # 校验参数完整性
    if not all([_id, level, position]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(uid)
        if user:
            if cate == 1:  # 政府机构
                user.section = Government.query.get(_id).name
                # 删除原有角色
                role = Role.query.get(user.role_id)
                role.users.remove(user)
                # 添加新角色
                role = Role.query.get(level)
                role.users.append(user)

                user.position = position
                db.session.commit()
                return jsonify(code=RET.OK, msg="添加成功")
            if cate == 2:  # 部门调度
                user.section = Section.query.get(_id).name
                # 删除原有角色
                role = Role.query.get(user.role_id)
                role.users.remove(user)
                # 添加新角色
                role = Role.query.get(level)
                role.users.append(user)

                user.position = position
                db.session.commit()
                return jsonify(code=RET.OK, msg="添加成功")
            if cate == 3:  # 组调度
                user.group = Group.query.get(_id).name
                # 删除原有角色
                role = Role.query.get(user.role_id)
                role.users.remove(user)
                # 添加新角色
                role = Role.query.get(level)
                role.users.append(user)

                user.position = position
                db.session.commit()
                return jsonify(code=RET.OK, msg="添加成功")

            return jsonify(code=RET.DATAERR, msg="参数错误")
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# # 测试
# @api_power.route("/cs", methods=["get"])
# def ces():
#     gover = Government.query.get(18)
#     section = Section.query.get(37)
#     print(gover,section)
#     # section.goverment.remove(gover)
#     gover.sections.remove(section)
#     db.session.commit()
#     return "ok"
''''''


# 机构部门或这组的人员 删除（人员失去组，机构项目）
@api_power.route("/deleteStaffOrg", methods=["POST"])
@login_required
def delete_staff():
    req_dict = request.get_json()
    uid = req_dict.get("uid")  # 员工id
    cate = req_dict.get("cate")  # 1政府，2部门，3组
    _id = req_dict.get("id")  # 机构部门组id
    # level = req_dict.get("level")  # 职级
    # position = req_dict.get("position")  # 职务

    # 校验参数完整性
    if not all([uid, cate, _id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(uid)
        if user:
            if cate == 1:  # 政府机构
                role = Role.query.get(user.role_id)
                role.users.remove(user)
                user.unit = ""  # 机构
                user.position = ""  # 职位
                user.section = ""  # 部门
                user.group = ""  # 组
                user.level = ""  # 级别
                user.leader = ""  # 领导者
                user.password = ""  # 密码
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            if cate == 2:  # 部们
                role = Role.query.get(user.role_id)
                # user.role_id = ""
                role.users.remove(user)
                user.position = ""
                user.section = ""
                user.group = ""
                user.level = ""
                # user.role_id = ""
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            if cate == 3:  # 组调度
                user.group = ""
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            return jsonify(code=RET.DATAERR, msg="参数错误")
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 获取统筹机构列表
@api_power.route("/orgCtrl", methods=["POST"])
@login_required
def org_ctrl():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 机构id
    cate = req_dict.get("cate")  # 1政府，2部门，3组

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if cate == 1:  # 政府机构详情
            goverment = Government.query.get(_id)
            # 统筹机构列表
            ctrl = goverment.followed
            bkpm = [{"id": j.id,
                     "name": j.name,
                     "charge": j.charge if j.charge else "-",
                     "phone": j.charge_phone if j.charge_phone else "-"} for j in ctrl]
            return jsonify(code=RET.OK, msg="查询成功", data=bkpm)

        return jsonify(code=RET.OK, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 获取待新增统筹机构列表
@api_power.route("/getCtrl", methods=["POST"])
@login_required
def get_ctrl():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        goverment = Government.query.get(_id)
        folllowedids = {i.id for i in goverment.followed}  # 已经被管制的
        folllowedids.add(_id)  # 添加自己
        all_ids = {i.id for i in Government.query.filter_by().all()}  # 全部机构id
        options = list(all_ids - folllowedids)  # 未被当前机构统筹的机构id列表

        goverments = Government.query.filter(Government.id.in_(options)).all()
        data = [{"id": i.id,
                 "name": i.name} for i in goverments]

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="添加失败")


# 机构详情页添加统筹机构
@api_power.route("/addBeCtrl", methods=["POST"])
@login_required
def add_bectrl():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    ids = req_dict.get("ids")

    # 校验参数完整性
    if not all([_id, ids]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        goverment = Government.query.get(_id)
        folllowedids = {i.id for i in goverment.followed}
        ids = set(ids)
        for id in (ids - folllowedids):
            gover = Government.query.get(id)
            goverment.followed.append(gover)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="添加失败")


# 机构详情页删除统筹机构
@api_power.route("/deleteCtrl", methods=["POST"])
@login_required
def delete_bectrl():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    bectrl_id = req_dict.get("bectrl_id")

    # 校验参数完整性
    if not all([_id, bectrl_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        goverment = Government.query.get(_id)
        begoverment = Government.query.get(bectrl_id)
        goverment.followed.remove(begoverment)
        db.session.commit()

        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作失败")
