import os
import time
import datetime
import random
import re
import pandas as pd
import xlsxwriter
from flask import jsonify, request, current_app
from sqlalchemy import or_, and_, desc
from apps.models import *
from apps.util import login_required, verify_token
from apps.inves_manage import api_manage, pro_url
from apps.utils.response_code import RET
from dateutil.relativedelta import relativedelta


# s
def get_year_month(year, month):
    year = int(year)
    month = int(month)
    if month == 12:
        year += 1
        month = 1
    else:
        year = year
        month += 1
    return year, month


def get_ininvest_id(x):
    try:
        x = int(x)
    except:
        x = float(x)
    if x < 0:
        return 0
    if x <= 1:
        return 1
    if x <= 10:
        return 2
    if x <= 50:
        return 3
    if x < 100:
        return 4

    return 5


# 获取项目阶段
@api_manage.route("/stage", methods=["GET"])
def get_stage():
    # 谋划项目、在谈项目、签约项目、暂停项目
    data = [{"label": "谋划项目", "value": 1},
            {"label": "在谈项目", "value": 2},
            {"label": "签约项目", "value": 3},
            {"label": "暂停项目", "value": 4},
            ]
    return jsonify(code=RET.OK, msg='查找成功', data=data)


# 招商资源管理
# 新增项目详情页的下拉列表
@api_manage.route("/listAddItem", methods=["GET"])
@login_required
def list_add_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 157
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    try:
        attract = Attract.query.filter_by(statu=1)
        industry_list = attract.filter_by(sid=1).all()  # 行业表
        stage_list = attract.filter_by(sid=2).all()  # 项目阶段表
        level_list = attract.filter_by(sid=3).all()  # 项目级别表
        invest = [{"name": "请选择", "id": ""}, {"name": "1亿元以下", "id": 1}, {"name": "1-10亿元", "id": 2},
                  {"name": "10-50亿元", "id": 3}, {"name": "50-100亿元", "id": 4},
                  {"name": "100亿元以上", "id": 5}]
        unit = user.unit  # 操作人的机构
        government = Government.query.filter_by(name=unit).first()
        section_list = government.sections
        section_list = [i.name for i in section_list]
        # if user.id == 157 or user.real_name == "史春梅":
        #     section_list = ["综合部", "产业项目促进部", "投资服务中心"]
        # if user.id == 159 or user.real_name == "王彤":
        #     section_list = ["政策信息部", "工业投资促进部"]
        # if user.id == 160 or user.real_name == "王剑":
        #     section_list = ["综合部", "区域经济合作部"]
        if user.id == 161 or user.real_name == "郭艳芳":
            section_list = ["区域经济合作部"]

        industry = [{"name": i.name, "industry_id": i.nid} for i in industry_list]
        industry = [{"name": "请选择", "id": ""}] + industry
        stage = [{"name": i.name, "stage_id": i.nid} for i in stage_list]
        stage = [{"name": "请选择", "stage_id": ""}] + stage
        level = [{"name": i.name, "level_id": i.nid} for i in level_list]
        level = [{"name": "请选择", "stage_id": ""}] + level
        section = [{"name": i, "section_id": 1} for i in section_list]  # 这里的id不予使用
        section = [{"name": "请选择", "stage_id": ""}] + section
        data = {
            "industry": industry,
            "stage": stage,
            "level": level,
            "invest": invest,
            "section": section
        }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取机构下的部门（新增项目详情页）
@api_manage.route("/unitSection", methods=["GET"])
@login_required
def unit_section():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        section = user.section
        return jsonify(code=RET.OK, msg='查找成功', data={"unit": unit, "section": section})
    except Enterprise as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取个人姓名接口
@api_manage.route("/getUser", methods=["GET"])
@login_required
def get_user():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        name = user.real_name
        return jsonify(code=RET.OK, msg="查找成功", data=name)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 新增项目的接口
@api_manage.route("/addItem", methods=["POST"])
@login_required
def add_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    build_date = req_dic.get("build_date")  # 公司成立时间
    company_name = req_dic.get("company_name")  # 项目企业
    admin = req_dic.get("admin")  # 联系人
    mobile = req_dic.get("mobile")  # 联系电话
    email = req_dic.get("email")  # 联系邮箱
    invest = req_dic.get("invest")  # 投资额(亿元)
    area = req_dic.get("area")  # 占地面积
    value = req_dic.get("value")  # 预计产值
    tax = req_dic.get("tax")  # 预计税收
    name = req_dic.get("name")  # 项目名称
    product = req_dic.get("product")  # 生产产品
    industry = req_dic.get("industry")  # 行业
    link = req_dic.get("link")  # 对接人
    link_mobile = req_dic.get("link_mobile")  # 对接人的联系方式
    level = req_dic.get("level")  # 项目的级别
    level_id = req_dic.get("level_id")  # 项目级别ID
    stage = req_dic.get("stage")  # 项目的进度
    stage_id = req_dic.get("stage_id")  # 项目进度id
    main_introduce = req_dic.get("main_introduce")  # 项目主体介绍
    invest_introduce = req_dic.get("invest_introduce")  # 投资项目介绍
    build_introduce = req_dic.get("build_introduce")  # 项目建设内容
    encomy = req_dic.get("encomy")  # 项目的经济效益
    policy = req_dic.get("policy")  # 项目政策需求
    question = req_dic.get("question")  # 项目存在的问题
    store = req_dic.get("store")  # 入库时间
    indu_id = req_dic.get("indu_id")  # 所在行业id


    # 校验
    # 公司成立时间
    if build_date:
        build_date = str(build_date)[0:10]  # 公司成立时间
    else:
        build_date = datetime.now()
    # 入库时间
    if store:
        store = store[0:10]
    else:
        store = datetime.now()

    # 所在行业id
    if not indu_id:
        indu_id = 0

    # 投资额(亿元)
    if invest:
        try:
            invest = float(req_dic.get("invest"))  # 投资额(亿元)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误，投资额 需为纯数字！")
    else:
        invest = 0

    # 占地面积
    if area:
        try:
            area = float(req_dic.get("area"))  # 占地面积
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误,占地面积 需为纯数字！")

    # 预计产值
    if value:
        try:
            value = float(req_dic.get("value"))  # 预计产值
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误，预计产值 需为纯数字！")
    else:
        value = 0

    # 预计税收
    if tax:
        try:
            tax = float(req_dic.get("tax"))  # 预计税收
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误,预计税收 需为纯数字！")
    else:
        tax = 0

    # 项目级别ID
    if not level_id:
        level_id = 0

    # 项目进度id
    if not stage_id:
        stage_id = 0



    # 2021/11/30 彤晓提出取消必填项
    # if not all([build_date, company_name, admin, mobile, email, industry,
    #             name, product, indu_id, invest, area, value, tax, store,
    #             link, link_mobile, level, level_id, stage, stage_id]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    if not company_name:
        return jsonify(code=RET.PARAMERR, msg="项目名不能为空！")


    if mobile and not re.match(r"1[23456789]\d{9}", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    if link_mobile and not re.match(r"1[23456789]\d{9}", link_mobile):
        return jsonify(code=RET.PARAMERR, msg="联系人手机号格式错误")

    if email and not re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", email):
        return jsonify(code=RET.PARAMERR, msg="邮箱格式错误")
    try:
        current_app.logger.error('======= tag1{}{} ========'.format(build_date,store))
        # item = Item(build_date=str(build_date)[0:10], company_name=company_name, admin=admin,
        #             mobile=mobile, email=email, name=name, product=product, industry=industry,
        #             indu_id=indu_id, invest=invest, area=area, value=value, tax=tax, store=store[0:10],
        #             link=link, link_mobile=link_mobile, level=level, level_id=level_id,
        #             stage=stage, stage_id=stage_id)
        item = Item(build_date=build_date, company_name=company_name, admin=admin,
                    mobile=mobile, email=email, name=name, product=product, industry=industry,
                    indu_id=indu_id, invest=invest, area=area, value=value, tax=tax, store=store,
                    link=link, link_mobile=link_mobile, level=level, level_id=level_id,
                    stage=stage, stage_id=stage_id)
        user = User.query.get(user_id)
        item.user_id = user_id
        item.unit = user.unit
        government = Government.query.filter_by(name=user.unit).first()
        item.unit_id = government.id
        if invest:
            item.invest_id = get_ininvest_id(invest)
        else:
            item.invest_id = 0
        item.status = "1"
        item.belong = 2
        if government.id == 1:
            item.belong = 1
        item.section = user.section

        # 非必填项目
        if main_introduce:
            item.main_introduce = main_introduce
        if invest_introduce:
            item.invest_introduce = invest_introduce
        if build_introduce:
            item.build_introduce = build_introduce
        if encomy:
            item.encomy = encomy
        if policy:
            item.policy = policy
        if question:
            item.question = question

        # 添加项目
        db.session.add(item)
        db.session.commit()
        data = {"item_id": item.id, "name": user.name, "code": RET.OK}

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误,项目添加失败")

    try:
        trend = Trends(item_id=data.get("item_id"), unit=user.unit,
                       user=user.real_name, stage=stage)
        db.session.add(trend)
        db.session.commit()
        return jsonify(code=RET.OK, msg="新增成功", data=data)
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误，项目阶段添加失败")


# 上传文件
@api_manage.route("/upItemFile", methods=["POST"])
@login_required
def up_item_file():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="权限数据库错误")

    req_dic = request.form.to_dict()
    file_up = request.files.get("file")

    filename = file_up.filename
    data = file_up.read()
    length = len(data)
    s = ["B", 'KB', 'MB', 'GB']
    j = 0
    if (length / 1024) / 1024 > 16:
        return jsonify(code=RET.DATAERR, msg="文件大小不能超过16MB")
    while True:
        j += 1
        if length % 1024 > 1024:
            length = length / 1024
        else:
            break
    file_size = str(length)[0:3] + s[j]
    item_id = req_dic.get("item_id")

    if not all([item_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    new_filename = filename.split(".")

    if new_filename[-1] not in ['xls', 'xlsx', 'pdf', 'ppt', 'pptx', "doc", "docx", "zip", "rar", "txt"]:
        return jsonify(code=RET.DATAERR, msg="文件格式错误")
    try:
        # 写入文件
        path = "/root/code/dist/files/" + str(item_id) + "/"
        url = path + filename
        file_db = File.query.filter_by(url=url).first()

        if file_db:
            return jsonify(code=RET.DATAEXIST, msg="该文件名已经存在")

        if not os.path.exists(path):
            os.mkdir(path=path)

        with open(url, "wb") as f:
            f.write(data)
        # 获取上传人消息
        user = User.query.get(user_id)

        file_add = File(name=filename, uploader=user.real_name, file_size=file_size,
                        url=url, item_id=item_id)

        db.session.add(file_add)
        db.session.commit()
        user = user.real_name

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    data = {"name": filename, "size": file_size, "user": user, "id": file_add.id}
    return jsonify(code=RET.OK, msg="添加成功", data=data)


# 下载文件
@api_manage.route("/downItemFile", methods=["POST"])
@login_required
def down_Item_file():
    req_dict = request.get_json()
    file_id = req_dict.get('file_id')  # 文件id
    if not file_id:
        return jsonify(code=RET.PARAMERR, msg="数据异常")
    try:
        file = File.query.get(file_id)
        if file.url:
            filename = file.name
            item_id = file.item_id
            url = pro_url  + str(item_id) + "/" + filename  # 文件目录
            return jsonify(code=RET.OK, msg="查询成功", filename=filename, url=url)
        return jsonify(code=RET.OK, msg="暂无文件")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 删除文件
@api_manage.route("/deleteItemFile", methods=["POST"])
@login_required
def delete_item_file():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    file_id = req_dic.get("id")

    if not file_id:
        return jsonify(code=RET.DBERR, msg="数据错误")
    try:
        file = File.query.get(file_id)
        url = file.url
        db.session.delete(file)
        db.session.commit()
        os.remove(url)
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目详情页接口
@api_manage.route("/detailsItem", methods=["POST"])
@login_required
def details_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 157
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    item_id = req_dic.get("item_id")

    if not item_id:
        return jsonify(code=RET.DATAERR, msg="缺少必要的参数")

    try:
        item = Item.query.get(item_id)
        if not item:
            return jsonify(code=RET.DATAERR, msg="不存在这样的项目")
        company = Company.query.filter_by(company_name=item.company_name).first()

        company_id = -1
        company_status = "-1"
        if company:
            company_status = "1"
            company_id = company.id
        else:
            company = Enterprise.query.filter_by(company_name=item.company_name).first()
            if company:
                company_status = "2"
                company_id = company.id

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    # 项目的详细信息
    basic = {
        "build_date": item.build_date.strftime('%Y-%m-%d') if item.build_date else "",
        "company_name": item.company_name,
        "admin": item.admin,
        "mobile": item.mobile,
        "email": item.email,
        "name": item.name,
        "store": item.store.strftime('%Y-%m-%d') if item.store else "",
        "product": item.product,
        "industry": item.industry,
        # "invest": str(item.invest) + "亿元" if item.invest else "",
        "invest": str(item.invest) if item.invest else "",
        "area": item.area,
        "value": item.value,
        "tax": item.tax,
        "link": item.link,
        "link_mobile": item.link_mobile,
        # "email": item.email,
        "level": item.level,
        "stage": item.stage,
        "main_introduce": item.main_introduce if item.main_introduce else "-",
        "invest_introduce": item.invest_introduce if item.invest_introduce else "-",
        "build_introduce": item.build_introduce if item.build_introduce else "-",
        "encomy": item.encomy if item.encomy else "-",
        "policy": item.policy if item.policy else "-",
        "question": item.question if item.question else "-",
        "company_id": company_id,
        "company_status": company_status,
    }

    # 项目的文件列表
    file_list = [{
        "file_id": i.id,
        "name": i.name,
        "file_size": i.file_size,
        "uploader": i.uploader,
        "url": i.url
    } for i in item.file]

    # 项目的进程列表
    trends_list = [{
        "time": i.create_time.strftime('%Y-%m-%d') if i.create_time else "",
        "stage": i.stage,
        "unit": i.unit,
        "updater": i.user
    } for i in item.trends]

    data = {
        "basic": basic,
        "file": file_list,
        "trends_list": trends_list
    }

    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 更改项目
@api_manage.route("/updateItem", methods=["POST"])
@login_required
def update_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        old_user_id = user.id
        if old_user_id != user_id:
            return jsonify(code=RET.ROLEERR, msg="权限验证失败")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    # try:
    #     req_dic = request.get_json()
    #     item_id = req_dic.get("item_id")  # ID
    #     build_date = req_dic.get("build_date")  # 公司成立时间
    #     store = req_dic.get("store")  # 入库时间
    #     company_name = req_dic.get("company_name")  # 项目企业
    #     admin = req_dic.get("admin")  # 联系人
    #     mobile = req_dic.get("mobile")  # 联系电话
    #     email = req_dic.get("email")  # 联系邮箱
    #     name = req_dic.get("name")  # 项目名称
    #     product = req_dic.get("product")  # 生产产品
    #     industry = req_dic.get("industry")  # 所在行业
    #     invest = req_dic.get("invest")  # 投资额
    #     area = req_dic.get("area")  # 占地面积
    #     value = req_dic.get("value")  # 预计产值
    #     tax = req_dic.get("tax")  # 预计税收
    #     # unit = req_dic.get("unit")  # 报送单位
    #     # section = req_dic.get("section")  # 报送单位的部门
    #     link = req_dic.get("link")  # 对接人
    #     link_mobile = req_dic.get("link_mobile")  # 对接人的联系方式
    #     level = req_dic.get("level")  # 项目的级别
    #     stage = req_dic.get("stage")  # 项目的进度
    #     stage_id = req_dic.get('stage_id')
    #
    #     main_introduce = req_dic.get("main_introduce")  # 项目主体介绍
    #     invest_introduce = req_dic.get("invest_introduce")  # 投资项目介绍
    #     build_introduce = req_dic.get("build_introduce")  # 项目建设内容
    #     encomy = req_dic.get("encomy")  # 项目的经济效益
    #     policy = req_dic.get("policy")  # 项目政策需求
    #     question = req_dic.get("question")  # 项目存在的问题
    try:
        req_dic = request.get_json()
        item_id = req_dic.get("item_id")  # ID
        build_date = req_dic.get("build_date")  # 公司成立时间
        store = req_dic.get("store")  # 入库时间
        company_name = req_dic.get("company_name")  # 项目企业
        admin = req_dic.get("admin")  # 联系人
        mobile = req_dic.get("mobile")  # 联系电话
        email = req_dic.get("email")  # 联系邮箱
        name = req_dic.get("name")  # 项目名称
        product = req_dic.get("product")  # 生产产品
        industry = req_dic.get("industry")  # 所在行业
        # invest = req_dic.get("invest")  # 投资额
        invest = req_dic.get("invest")  # 投资额(亿元)
        area = req_dic.get("area")  # 占地面积
        # value = req_dic.get("value")  # 预计产值
        # tax = req_dic.get("tax")  # 预计税收
        value = req_dic.get("value")  # 预计产值
        tax = req_dic.get("tax")  # 预计税收
        # unit = req_dic.get("unit")  # 报送单位
        # section = req_dic.get("section")  # 报送单位的部门
        link = req_dic.get("link")  # 对接人
        link_mobile = req_dic.get("link_mobile")  # 对接人的联系方式
        level = req_dic.get("level")  # 项目的级别
        stage = req_dic.get("stage")  # 项目的进度
        stage_id = req_dic.get('stage_id')

        main_introduce = req_dic.get("main_introduce")  # 项目主体介绍
        invest_introduce = req_dic.get("invest_introduce")  # 投资项目介绍
        build_introduce = req_dic.get("build_introduce")  # 项目建设内容
        encomy = req_dic.get("encomy")  # 项目的经济效益
        policy = req_dic.get("policy")  # 项目政策需求
        question = req_dic.get("question")  # 项目存在的问题


    except Exception as e:
        current_app.logger.error(e)

    # 2021/11/30 彤晓提出取消必填项
    # if not all([item_id, build_date, store, company_name, admin, mobile, email,
    #             name, product, industry, invest, area, value, tax,
    #             link, link_mobile, level, stage, user_id]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    if not all([company_name, user_id]):
        return jsonify(code=RET.PARAMERR, msg="项目名不能为空！")

    # try:
    #     build_date = str(build_date)[0:10]
    #     store = str(store)[0:10]
    #     item = Item.query.get(item_id)
    #     new_item = Item.query.filter(or_(Item.share.like("%--" + str(user_id) + "--%"),
    #                                      Item.user_id == user_id), Item.id == item_id).first()
    #     if not new_item:
    #         return jsonify(code=RET.ROLEERR, msg="权限不足")
    #     indu_id = Attract.query.filter_by(name=industry).first().id
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.DBERR, msg="数据库错误")



    if build_date:
        try:
            build_date = str(build_date)[0:10]
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")
    else:
        build_date = datetime.now()

    if store:
        try:
            store = str(store)[0:10]
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")
    else:
        store = datetime.now()

    try:
        item = Item.query.get(item_id)
        new_item = Item.query.filter(or_(Item.share.like("%--" + str(user_id) + "--%"),
                                      Item.user_id == user_id), Item.id == item_id).first()
        if not new_item:
             return jsonify(code=RET.ROLEERR, msg="权限不足")
        if industry:
            indu_id = Attract.query.filter_by(name=industry).first().id
        else:
            indu_id = 0
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    # 项目进度id
    if not stage_id:
        stage_id = 0

    # 修改项目状态
    if item.stage_id != stage_id and stage_id != "":
        item.stage = stage
        item.stage_id = stage_id
        if not link:
            try:
                link = User.query.get(user_id)
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")

        try:
            trends = Trends(item_id=item_id, stage=stage, unit=item.unit, user=link)
            db.session.add(trends)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")

    # 投资额(亿元)
    if invest:
        try:
            invest = float(req_dic.get("invest"))  # 投资额(亿元)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误，投资额 需为纯数字！")
    else:
        invest = 0

    # 占地面积
    if area:
        try:
            area = float(req_dic.get("area"))  # 占地面积
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误,占地面积 需为纯数字！")

    # 预计产值
    if value:
        try:
            value = float(req_dic.get("value"))  # 预计产值
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误，预计产值 需为纯数字！")
    else:
        value = 0

    # 预计税收
    if tax:
        try:
            tax = float(req_dic.get("tax"))  # 预计税收
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="数据类型错误,预计税收 需为纯数字！")
    else:
        tax = 0

    # 项目级别ID
    # if not level_id:
    #     level_id = 0

    item.build_date = build_date  # 创建时间
    item.store = store  # 入库时间
    item.company_name = company_name  # 公司名
    item.admin = admin  # 联系人
    item.mobile = mobile  # 联系人的电话
    item.email = email  # 邮箱
    item.name = name  # 项目名称
    item.product = product  # 产品
    item.industry = industry  # 行业
    item.indu_id = indu_id
    item.invest = invest  # 投资金额
    if invest:
        item.invest_id = get_ininvest_id(invest)  # 投资金额的ID
    else:
        item.invest_id = 0
    item.area = area  # 占地面积
    item.value = value  # 预计产值
    item.tax = tax  # 预计税收
    # item.unit = unit  # 报送机构
    # item.section = section  # 报送部门
    item.link = link  # 对接人
    item.link_mobile = link_mobile  # 对接人的联系方式
    item.level = level  # 项目级别

    if main_introduce:
        item.main_introduce = main_introduce  # 项目主体介绍
    if invest_introduce:
        item.invest_introduce = invest_introduce  # 投资项目介绍
    if build_introduce:
        item.build_introduce = build_introduce  # 项目建设内容
    if encomy:
        item.encomy = encomy  # 项目经济效益
    if policy:
        item.policy = policy  # 项目政策需求
    if question:
        item.question = question  # 项目存在问题

    try:
        db.session.commit()
        return jsonify(code=RET.OK, msg="更改成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商项目管理页面的筛选条件
@api_manage.route("/listMangeItem", methods=["GET"])
@login_required
def list_manage_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit  # 用户所在的部门
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    try:
        attract = Attract.query.filter_by(statu=1)
        industry_list = attract.filter_by(sid=1).all()
        stage_list = attract.filter_by(sid=2).all()  # 项目阶段
        unit = Government.query.filter_by(name=unit).first()
        industry = [{"name": i.name, "industry_id": i.id} for i in industry_list]  # 项目行业
        industry = [{"name": "请选择", "industry_id": ""}] + industry
        stage = [{"name": i.name, "stage_id": i.id} for i in stage_list]  # 项目阶段
        stage = [{"name": "请选择", "stage_id": ""}] + stage
        section = [{"name": i.name, "section_id": i.id} for i in unit.sections]  # 部门
        section = [{"name": "请选择", "section_id": ""}] + section
        invest = [{"invest": "请选择", "invest_id": ""}, {"invest": "1亿元以下", "invest_id": 1},
                  {"invest": "1-10亿", "invest_id": 2},
                  {"invest": "10-50亿", "invest_id": 3}, {"invest": "50-100亿", "invest_id": 4},
                  {"invest": "100亿以上", "invest_id": 5}]  # 投资额
        data = {
            "industry": industry,
            "stage": stage,
            "section": section,
            "invest": invest
        }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


'''
# 招商项目管理页项目列表
@api_manage.route("/getManageItem", methods=["POST"])
@login_required
def get_manage_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit  # 用户所在的部门
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    # 获取当前账号的权限制
    try:
        item = Item.query.filter_by(unit=unit)

        # 权限查找
        if role[0] == "2":  # 部级
            item = item.filter_by(section=user.section)

        if role[0] == "3":  # 个人，包括你被分享的 ---可能有个数有问题--
            item = item.filter(or_(Item.share.like("%--" + str(user_id) + "--%"), Item.user_id == user_id))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dic = request.get_json()
    page = req_dic.get("page")  # 页数
    perpage = req_dic.get("perpage")  # 每页个数
    stage_id = req_dic.get("stage_id")  # 项目进展
    indu_id = req_dic.get("indu_id")  # 行业
    invest_id = req_dic.get("invest_id")  # 投资
    section = req_dic.get("section")  # 部门
    search = req_dic.get("search")  # 搜索栏搜索的值
    order = req_dic.get("order")  # 按照投资额的顺序  #1为顺序，2为倒序

    if not page:
        page = 1

    if not perpage:
        perpage = 10

    if stage_id:
        item = item.filter_by(stage_id=stage_id)

    if indu_id:
        item = item.filter_by(indu_id=indu_id)

    if invest_id:
        item = item.filter_by(invest_id=invest_id)

    if section:
        if section != "请选择":
            item = item.filter_by(section=section)

    if search:
        item = item.filter(or_(Item.company_name.like("%" + search + "%")
                               , Item.name.like("%" + search + "%")))

    if order == 2:
        item = item.order_by(desc("invest"))
    else:
        item = item.order_by("invest")
    item = item.order_by(desc("id"))
    # 分页查询
    try:
        maxnum = len(item.all())
        item = item.paginate(page, perpage).items

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    data_list = []
    status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
    for i in item:
        status = i.status
        if not i.status:
            status = 0
        data_list.append(
            {
                "id": i.id,
                "company_name": i.company_name,
                "name": i.name,
                "product": i.product,
                "industry": i.industry,
                "invest": i.invest,
                "stage": i.stage,
                "section": i.section,
                "link": i.link,
                "status": status_list[int(status)]
            }
        )
    data = {"data_list": data_list, "maxnum": maxnum}
    return jsonify(code=RET.OK, msg="查询成功", data=data)
'''


# 招商项目管理页项目列表
@api_manage.route("/getManageItem", methods=["POST"])
@login_required
def get_manage_item():
    try:
        token = request.headers["token"]
        user = verify_token(token)
        unit = user.unit  # 用户所在的部门
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.ROLEERR, msg="用户状态异常")
    # 用户id
    user_id = user.id
    # 获取当前账号的权限值
    try:
        item = Item.query.filter_by(unit=unit)  # 先筛选机构
        # 此部分是在原有的基础上新添的个别人的、分管部门不同而临时固定的特殊人员筛选，需更改用户在表中的id
        if role[0] == "1":  # 局级
            # if user.id == 157 or user.real_name == "史春梅":
            #     item = item.filter(or_(Item.section.in_(["综合部", "产业项目促进部", "投资服务中心"]), Item.user_id == 157))
            # if user.id == 159 or user.real_name == "王彤":
            #     item = item.filter(or_(Item.section.in_(["政策信息部", "工业投资促进部"]), Item.user_id == 159))
            # if user.id == 160 or user.real_name == "王剑":
            #     item = item.filter(or_(Item.section.in_(["综合部", "区域经济合作部"]), Item.user_id == 160))
            if user.id == 5 or user.real_name == "郭艳芳":# id=5
                item = item.filter(or_(Item.section.in_(["区域经济合作部"]), Item.user_id == 5))
        # 权限查找
        if role[0] == "2":  # 部级
            item = item.filter_by(section=user.section)
        if role[0] == "3":  # 个人，包括你被分享的 ---可能有个数有问题--
            item = item.filter(or_(Item.share.like("%--" + str(user_id) + "--%"), Item.user_id == user_id))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    # 获取参数
    req_dic = request.get_json()
    page = req_dic.get("page")  # 页数
    perpage = req_dic.get("perpage")  # 每页个数
    stage_id = req_dic.get("stage_id")  # 项目进展
    indu_id = req_dic.get("indu_id")  # 行业
    invest_id = req_dic.get("invest_id")  # 投资
    section = req_dic.get("section")  # 部门
    search = req_dic.get("search")  # 搜索栏搜索的值
    order = req_dic.get("order")  # 按照投资额的顺序  #1为顺序，2为倒序

    if not page:
        page = 1
    if not perpage:
        perpage = 10
    if stage_id:  # 项目进展
        item = item.filter_by(stage_id=stage_id)
    if indu_id:  # 行业选择
        item = item.filter_by(indu_id=indu_id)
    if invest_id:  # 投资额
        item = item.filter_by(invest_id=invest_id)
    if section:
        if section != "请选择":
            item = item.filter_by(section=section)
    if search:  # 搜索框
        item = item.filter(or_(Item.company_name.like("%" + search + "%"), Item.name.like("%" + search + "%")))
    if order == 2:  # 排序方式
        item = item.order_by(desc("invest"))
    else:
        item = item.order_by("invest")
    item = item.order_by(desc("id"))
    # 分页查询
    try:
        maxnum = item.count()
        item = item.paginate(page, perpage).items
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    data_list = []
    status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
    for i in item:
        status = i.status
        if not i.status:
            status = 0
        data_list.append(
            {
                "id": i.id,
                "company_name": i.company_name,  # # 项目企业
                "name": i.name,  # 项目名称
                "product": i.product,  # 生产产品
                "industry": i.industry,  # 所在行业
                "invest": i.invest,  # 投资额(亿元)
                "stage": i.stage,  # # 项目的进度
                "section": i.section,  # 项目所在部门
                "link": i.link,  # 对接人
                "status": status_list[int(status)]  # # 项目上报状态
            }
        )
    data = {"data_list": data_list, "maxnum": maxnum}
    return jsonify(code=RET.OK, msg="查询成功", data=data)


# 删除项目 ---  同时删除与项目相关的动态和文件在数据库的存储
@api_manage.route("/deleteItem", methods=["POST"])
@login_required
def delete_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        old_user_id = user.id
        if old_user_id != user_id:
            return jsonify(code=RET.ROLEERR, msg="权限验证失败")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    data = req_dic.get('item_id')  # 删除项目ID的列表
    if not data:
        return jsonify(code=RET.DATAERR, msg="数据错误")
    # 删除主表
    try:
        for i in data:
            item = Item.query.filter_by(id=i).first()
            if int(item.user_id) != user_id:
                return jsonify(code=RET.ROLEERR, msg="权限验证失败")
            db.session.delete(item)
        db.session.commit()
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据库错误')

    # 删除对应文件表的内容
    try:
        file = File.query.filter_by(item_id=None).all()
        for i in file:
            url = i.url
            os.remove(url)
            db.session.delete(i)
        db.session.commit()

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据库错误')
    b = os.getcwd()

    for i in data:
        path = b + "/apps/static/ItemFiles/{}".format(i)
        if os.path.exists(path):
            os.rmdir(path)
    # 删除对应项目阶段表的内容
    try:
        trends = Trends.query.filter_by(item_id=None).all()
        for i in trends:
            db.session.delete(i)
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='数据库错误')
    return jsonify(code=RET.OK, msg='删除成功')


# 获取所有机构
@api_manage.route("/listGetUnit", methods=["GET"])
def list_get_unit():
    try:
        government = Government.query.filter_by().all()
        data = [
            {"government_name": i.name, "government_id": i.id} for i in government
        ]
        data = [{"government_name": "请选择", "government_id": ""}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取机构的部门和人员
@api_manage.route("/getSectionPeople", methods=["POST"])
@login_required
def get_section_people():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dic = request.get_json()
    government_id = req_dic.get("government_id")

    if not government_id:
        return jsonify(code=RET.DATAERR, msg="参数不完整")
    try:
        government = Government.query.get(government_id)
        data = []

        for i in government.sections:

            person = [{"name": "请选择", "id": ""}]
            section = User.query.filter(and_(User.unit == government.name,
                                             User.section == i.name, User.id != user_id)).all()

            for j in section:
                person.append({"name": j.name, "id": j.id})
            data.append({"person": person, "name": i.name, "section_id": i.id})
        data = [{"section_id": "", "name": "请选择", "person": [{"name": "请选择", "id": ""}]}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 调度项目：----接口带有权限
@api_manage.route("/controlItem", methods=["POST"])
@login_required
def control_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # 获取权限制（可能有外键）
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        role = user.role.role
        # 判断是否具备权限
        if role[1] != "1":
            return jsonify(code=RET.ROLEERR, msg="权限验证失败")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    item_id = req_dic.get("item_id")  # 需要调度的项目id
    user_id = req_dic.get("user_id")  # 获得项目的用户id
    if not all([item_id, user_id]):
        return jsonify(code=RET.PARAMERR, msg="数据不全，请重新选择")
    try:
        item = Item.query.get(item_id)
        user = User.query.get(user_id)
        item.user_id = user.id
        item.unit = user.unit
        item.section = user.section
        item.link = user.real_name
        db.session.commit()
        return jsonify(code=RET.OK, msg="调度成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取共享项目的成员和部门
@api_manage.route("/getSectionShare", methods=["GET"])
@login_required
def get_section_share():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        government = Government.query.filter_by(name=unit).first()
        data = []

        for i in government.sections:
            person = []
            section = User.query.filter(and_(User.unit == unit,
                                             User.section == i.name, User.id != user_id)).all()
            for j in section:
                person.append({"name": j.name, "id": j.id})
            data.append({"person": person, "section": i.name})

        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 通过机构名获取部门接口
@api_manage.route("/getSec", methods=["GET"])
@login_required
def get_sec():
    '''选择部门后会出现人员名单'''
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        government = Government.query.filter_by(name=unit).first()
        data = [{"section": i.name, "id": i.id} for i in government.sections]
        data = [{"section": "请选择", "id": ""}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 通过部门名查找部门下人员的接口
@api_manage.route("/getSecpeople", methods=["POST"])
@login_required
def get_sec_pel():
    req_dic = request.get_json()
    sec_id = req_dic.get("section")
    if not sec_id:
        return jsonify(code=RET.PARAMERR, msg='缺少参数')
    try:
        user = User.query.filter_by(section=sec_id).all()
        data = [{"name": i.real_name, "user_id": i.id} for i in user]
        data = [{"name": "请选择", "id": ""}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 分享项目接口
@api_manage.route("/shareItem", methods=["POST"])
@login_required
def share_item():
    req_dic = request.get_json()
    token = request.headers["token"]
    user = verify_token(token)
    old_user_id = user.id
    user_id = req_dic.get("user_id")  # 需要分享的人的ID
    item_id = req_dic.get("item_id")  # 项目id

    # 判断两个数据是否都存在
    if not all([user_id, item_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 获取需要更改的项目
    try:
        item = Item.query.get(item_id)
        if int(item.user_id) != old_user_id:
            return jsonify(code=RET.ROLEERR, msg="权限验证失败")
        # 首次分享
        if not item.share:
            item.share = "--"
        if str(user_id) in item.share:
            return jsonify(code=RET.DATAERR, msg="已经共享")

        # 改数据
        item.share = item.share + str(user_id) + "--"
        db.session.commit()
        return jsonify(code=RET.OK, msg="共享成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 上报项目
@api_manage.route("/upItem", methods=['POST'])
@login_required
def up_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dic = request.get_json()
    unit_id = req_dic.get("unit_id")  # 局
    item_id = req_dic.get("item_id")  # 项目id

    if not all([unit_id, item_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 获取项目的数据
    try:
        item = Item.query.get(item_id)
        if int(item.user_id) != user_id:
            return jsonify(code=RET.ROLEERR, msg="权限验证失败")
        if not item.status or (item.status == "1" or item.status == "3"):
            government = Government.query.get(unit_id)
            item.unit_up = government.name
            item.status = "2"
            db.session.commit()
            return jsonify(code=RET.OK, msg="上报成功")
        else:
            return jsonify(code=RET.REQERR, msg="不能上报")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据错误")


# 选取项目后下载excel表格接口
@api_manage.route("/downManageItem", methods=["POST"])
@login_required
def down_manage_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dic = request.get_json()
    data = req_dic.get('item_id')  # 查找项目ID的列表

    if not data:
        return jsonify(code=RET.DATAERR, msg="数据错误")

    # 下载文件
    path = pro_url
    # old_path = os.getcwd() + "/apps/static/temporaryFile/"
    old_path ="/root/code/dist/files/" # 此处用nginx做静态文件代理
    if not os.path.exists(old_path):
        os.mkdir(path=old_path)
    try:
        # user_id = 151
        user = User.query.get(user_id)
        fileuser = user.real_name
        # fileuser = "cs"
        hz = random.randint(1,10)
        filename = "{}_item_{}.xlsx".format(fileuser,hz)
        df = pd.DataFrame(columns=["企业名称", "项目名称", "所在行业", "投资金额", "项目进度", "所在部门", "项目对接人", "状态", "项目介绍", "项目进展"])
        status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
        for i in range(0, len(data)):
            item = Item.query.filter_by(id=data[i]).first()
            status = item.status
            if not item.status:
                status = 0
            df.loc[i] = [item.company_name, item.name, item.industry, item.invest, item.stage, item.section,
                         item.link, status_list[int(status)], item.invest_introduce, item.question]

        # df.to_excel(old_path + filename, view_index=None)

        writer = pd.ExcelWriter(old_path + filename, engine='xlsxwriter')
        # Convert the dataframe to an XlsxWriter Excel object.
        df.to_excel(writer, sheet_name='Sheet1')
        # Get the xlsxwriter worksheet object.
        worksheet = writer.sheets['Sheet1']
        # Set the column width and format.
        worksheet.set_column("B:D", 28)  # 在这里更改宽度值
        worksheet.set_column("D:I", 12)  # 在这里更改宽度值
        worksheet.set_column("J:K", 50)  # 在这里更改宽度值

        writer.save()

        return jsonify(code=RET.OK, msg="查找成功", url=path + filename, filename=filename)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目上报追踪的筛选条件接口
@api_manage.route("/listReportItem", methods=["GET"])
@login_required
def list_report_item():
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id
        user = User.query.get(user_id)
        role = user.flag  # 用户类型判断(内部外部)
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    try:
        attract = Attract.query.filter_by(statu=1)
        industry_list = attract.filter_by(sid=1).all()  # 项目行业
        stage_list = attract.filter_by(sid=2).all()  # 项目阶段
        unit = Government.query.filter_by().all()  # 单位名单

        industry = [{"name": i.name, "indu_id": i.nid} for i in industry_list]  # 项目行业
        industry = [{"name": "请选择", "indu_id": ""}] + industry
        stage = [{"name": i.name, "stage_id": i.nid} for i in stage_list]  # 项目阶段
        stage = [{"name": "请选择", "stage_id": ""}] + stage
        unit = [{"name": i.name, "unit_id": i.id} for i in unit]  # 报送单位
        unit = [{"name": "请选择", "unit_id": ""}] + unit
        invest = [{"invest": "请选择", "invest_id": ""}, {"invest": "1亿元以下", "invest_id": 1},
                  {"invest": "1-10亿", "invest_id": 2},
                  {"invest": "10-50亿", "invest_id": 3}, {"invest": "50-100亿", "invest_id": 4},
                  {"invest": "100亿以上", "invest_id": 5}]  # 投资额
        way = [{"way_id": "请选择", "name": ""}, {"way_id": 1, "name": "只看进行中的项目"}, {"way_id": 2, "name": "只看促投局的项目"}]
        data = {
            "industry": industry,
            "stage": stage,
            "unit": unit,
            "invest": invest,
            "way": way,
        }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目上报追踪的列表
@api_manage.route("/reportItem", methods=["POST"])
@login_required
def report_item():
    '''选取上报单位unit_up是本单位的项目，然后再选择其他筛选条件，比如是哪个单位上报的'''
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    # user_id = 3
    req_dic = request.get_json()

    indu_id = req_dic.get("indu_id")  # 行业，
    invest_id = req_dic.get("invest_id")  # 投资额ID
    evolve_id = req_dic.get("stage_id")  # 项目进度
    unit_name = req_dic.get("unit")  # 报送单位
    way_id = req_dic.get("way_id")  # 查看方式
    search = req_dic.get("search")  # 搜索框
    order = str(req_dic.get("order"))  # 顺序 1-正序，2-倒序
    page = req_dic.get("page")  # 页数
    perpage = req_dic.get("perpage")  # 每页个数

    item = Item.query.filter_by(unit_up=unit)

    if not page:
        page = 1

    if not perpage:
        perpage = 10

    if indu_id:
        item = item.filter_by(indu_id=indu_id)

    if invest_id:
        item = item.filter_by(invest_id=invest_id)

    if evolve_id:
        item = item.filter_by(stage_id=evolve_id)

    if unit_name:
        if unit_name != "请选择":
            item = item.filter_by(unit=unit_name)

        # 进行中项目
    if way_id == 1:
        # 数据可能需要改
        item = item.filter(and_(Item.stage_id != 5, Item.stage_id != 10))
        # 投促局调度的项目
    if way_id == 2:
        item = item.filter_by(belong=1)
    # 搜索，模糊查询
    if search:
        item = item.filter(or_(Item.company_name.like('%' + search + "%"), Item.name.like('%' + search + "%")))

    # 排序
    item = item.order_by(desc(Item.id))
    if order:
        if order == "2":
            item = item.order_by(desc(Item.invest))
        else:
            item = item.order_by(Item.invest)

    try:
        # maxnum = len(item.all())
        maxnum = item.count()
        item = item.paginate(page, perpage).items
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    # for j in government_list:
    #     new_item = item.filter_by(unit_up = j.name).order_by(desc(Item.id)).all()
    status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
    data_list = []
    for i in item:
        status = i.status
        if not i.status:
            status = 0
        data_list.append({
            "item_id": i.id,
            "name": i.name,
            "company": i.company_name,
            "product": i.product,
            "industry": i.industry,
            "invest": i.invest,
            "stage": i.stage,
            "unit": i.unit,
            "link": i.link,
            "status": status_list[int(status)]
        })
    data = {"data_list": data_list, "maxnum": maxnum}
    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 对上报项目的审核
@api_manage.route("/auditItem", methods=["POST"])
@login_required
def audit_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # 查询user的值
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        power = user.role.role
        if power[2] != "1":
            return jsonify(code=RET.ROLEERR, msg="权限不足")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    item_id = req_dic.get("item_id")  # 项目id
    status = req_dic.get("status")  # 状态 4--通过，3--驳回
    if not all([item_id, status]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 改权限
    try:
        item = Item.query.get(item_id)
        item.status = status
        db.session.commit()
        return jsonify(code=RET.OK, msg="操作成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 从上报的项目列表里进行删除
@api_manage.route("/deleteReport", methods=["POST"])
@login_required
def delete_report():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        role = user.role.role
        if role[2] != "1":
            return jsonify(code=RET.ROLEERR, msg="权限不够")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    item_id = req_dic.get("item_id")

    if not item_id:
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        item = Item.query.get(item_id)
        item.unit_up = None
        item.status = None
        db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 下载项目上报追踪的列表
@api_manage.route("/downReport", methods=["POST"])
# @login_required
def down_report():
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id

    req_dic = request.get_json()
    data = req_dic.get('data')  # 查找项目ID的列表
    if not data:
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    # 下载文件
    path = "http://touzi.cjwltzj.taiyuan.gov.cn/files/temporaryFile/"
    old_path ="/root/code/files/temporaryFile/"
    if not os.path.exists(old_path):
        os.mkdir(path=old_path)

    try:
        user = User.query.get(5)
        fileuser = user.name
        filetime = int(time.time())
        filename = "{}{}.xlsx".format(fileuser, filetime)
        df = pd.DataFrame(columns=["序号", "企业名称", "项目名称", "投资产品", "所在行业",
                                   "投资金额", "项目进度", "报送单位", "项目对接人", "状态"])
        status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
        for i in range(0, len(data)):
            item = Item.query.filter_by(id=data[i]).first()
            status = item.status
            if not item.status:
                status = 0
            df.loc[i] = [i, item.company_name, item.name, item.product, item.industry,
                         item.invest, item.stage, item.unit, item.link, status_list[int(status)]]
        df.to_excel(old_path + filename, index=None)  # path +
        return jsonify(code=RET.OK, msg="查找成功", url=path + filename, filename=filename)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计图查看（机构内部）
@api_manage.route("/stageInTableO", methods=["POST"])
@login_required
def stage_in_table_o():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
        _section = user.section
        role = user.role.role  # 获取角色权值
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")  # 年份开始
    month_begin = req_dic.get("month_begin")  # 月份开始
    year_end = req_dic.get("year_end")  # 年份结束
    month_end = req_dic.get("month_end")  # 月份结束
    stage_id = req_dic.get("stage_id")  # 项目阶段id
    indu_id = req_dic.get("indu_id")  # 产业选择
    section = req_dic.get("section")  # 部门
    user_id = req_dic.get("user_id")  # 成员

    # if not all([year_begin, month_begin, year_end, month_end]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")
    date_begin, date_end = 0, 0
    if year_begin and year_end and month_begin and month_end:
        year_begin = year_begin[:-1]
        month_begin = month_begin[:-1]
        (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])
        # date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
        date_begin = datetime.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
        date_end = datetime.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
        # print(date_begin, date_end)
    try:
        item = Item.query.filter_by()
        if role[0] == "1":  # 局级领导（看本单位所有项目）
            item = Item.query.filter(Item.unit == unit)
        if role[0] == "2":  # 部长（看本单位本部门所有项目）
            item = Item.query.filter(Item.unit == unit, Item.section == _section)
        if role[0] == "3":  # 只看个人的
            item = Item.query.filter(Item.user_id == user_id)
        # 填补时间
        if date_begin and date_end:
            item = item.filter(Item.store.between(date_begin, date_end))
        # 一个机构内的所有人
        item_user = User.query.filter_by(unit=unit)
        item_evolve = Attract.query.filter_by(statu=1, sid=2)  # 招商资源管理字典（项目进度）
        item_industry = Attract.query.filter_by(statu=1, sid=1)  # 招商资源管理字典（行业选择）
        if stage_id:
            item = item.filter_by(stage_id=stage_id)  # 项目进度筛选
            item_evolve = Attract.query.filter_by(nid=stage_id)
        if indu_id:
            item = item.filter_by(industry=indu_id)  # 项目行业筛选
            item_industry = item_industry.filter_by(nid=indu_id)
        if section:
            if section != "请选择":
                item = item.filter_by(section=section)
                item_user = item_user.filter_by(section=section)
        if user_id:
            item = item.filter_by(user_id=user_id)
            item_user = item_user.filter_by(section=section, id=user_id)
        item_evolve = set(item_evolve.with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        item_evolve.sort()
        # 项目阶段统计
        stage = [{"name": Attract.query.filter_by(nid=i[0], sid=2).first().name,
                  "value": item.filter_by(stage_id=i[0]).count()
                  } for i in item_evolve]

        item_user = set(item_user.with_entities(User.id).all())
        user = [{
            "name": User.query.get(i[0]).real_name, "value": item.filter_by(user_id=i[0]).count(),
        } for i in item_user]

        item_industry = set(item_industry.with_entities(Attract.nid).all())
        industry = [{
            "name": Attract.query.filter_by(nid=i[0], sid=1).first().name, "value": item.filter_by(indu_id=i[0]).count()
        } for i in item_industry]
        data = {
            "stage": stage,  # 阶段
            "user": user,  # 用户
            "industry": industry,  # 行业
            "section": stage,  # 部门
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计图查看（机构内部）
@api_manage.route("/stageInTable", methods=["POST"])
@login_required
def stage_in_table():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id


    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit  # 招商单位
        _section = user.section  # 招商部门
        role = user.role.role  # 获取角色权值
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")  # 年份开始
    month_begin = req_dic.get("month_begin")  # 月份开始
    year_end = req_dic.get("year_end")  # 年份结束
    month_end = req_dic.get("month_end")  # 月份结束
    stage_id = req_dic.get("stage_id")  # 项目阶段id
    indu_id = req_dic.get("indu_id")  # 产业选择
    section = req_dic.get("section")  # 部门
    user_id = req_dic.get("user_id")  # 成员

    date_begin, date_end = 0, 0
    if year_begin and year_end and month_begin and month_end:
        year_begin = year_begin[:-1]
        month_begin = month_begin[:-1]
        (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])
        # date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
        date_begin = datetime.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
        date_end = datetime.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
        # print(date_begin, date_end)
    try:
        item = Item.query.filter_by()
        if role[0] == "1":  # 局级领导（看本单位所有项目）
            item = Item.query.filter(Item.unit == unit)
        if role[0] == "2":  # 部长（看本单位本部门所有项目）
            item = Item.query.filter(Item.unit == unit, Item.section == _section)
        if role[0] == "3":  # 只看个人的
            item = Item.query.filter(Item.user_id == user_id)
        # 填补时间
        if date_begin and date_end:
            item = item.filter(Item.store.between(date_begin, date_end))

        item_user = User.query.filter_by(unit=unit).filter(User.role_id != 2)  # 一个机构内除了局领导外所有人
        item_evolve = Attract.query.filter_by(statu=1, sid=2)  # 招商资源管理字典（项目进度）
        item_industry = Attract.query.filter_by(statu=1, sid=1)  # 招商资源管理字典（行业选择）

        goverment = Government.query.filter_by(name=unit).first()
        all_section = goverment.sections
        all_section = [i.name for i in all_section]
        # print(all_section)
        if stage_id:  # 项目阶段
            item = item.filter_by(stage_id=stage_id)  # 项目进度筛选
            item_evolve = Attract.query.filter_by(nid=stage_id)
        if indu_id:  # 行业筛选
            item = item.filter_by(industry=indu_id)  # 项目行业筛选
            item_industry = item_industry.filter_by(nid=indu_id)
        if section:  # 部门筛选
            if section != "请选择":
                item = item.filter_by(section=section)
                item_user = item_user.filter_by(section=section)
        if user_id:  # 人员筛选
            item = item.filter_by(user_id=user_id)
            item_user = item_user.filter_by(section=section, id=user_id)
        item_evolve = set(item_evolve.with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        item_evolve.sort()
        # 项目阶段统计
        stage = [{"name": Attract.query.filter_by(nid=i[0], sid=2).first().name,
                  "value": item.filter_by(stage_id=i[0]).count()
                  } for i in item_evolve]
        # 人员统计
        item_user = item_user.all()
        item_user = [i.id for i in item_user]
        user = [{
            "name": User.query.get(i).real_name, "value": item.filter_by(user_id=i).count(),
        } for i in item_user]

        item_industry = set(item_industry.with_entities(Attract.nid).all())
        industry = [{
            "name": Attract.query.filter_by(nid=i[0], sid=1).first().name, "value": item.filter_by(indu_id=i[0]).count()
        } for i in item_industry]
        # 按部门查看
        section = []
        for i in all_section:
            section.append({"name": i, "value": item.filter_by(section=i).count()})
        data = {
            "stage": stage,  # 阶段
            "user": user,  # 用户
            "industry": industry,  # 行业
            "section": section,  # 部门
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目上报追踪的统计表查看（机构内部）
@api_manage.route("stageInList", methods=["POST"])
@login_required
def stage_in_list():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
        _section = user.section
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")
    section = req_dic.get("section")
    user_id = req_dic.get("user_id")

    # if not all([year_begin, month_begin, year_end, month_end]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")
    date_begin, date_end = 0, 0
    if year_begin and year_end and month_begin and month_end:
        year_begin = year_begin[:-1]
        month_begin = month_begin[:-1]
        (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])
        date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
        date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)

    try:
        item = Item.query.filter_by()
        if role[0] == "1":  # 局级领导（看本单位所有项目）
            item = Item.query.filter(Item.unit == unit)
        if role[0] == "2":  # 部长（看本单位本部门所有项目）
            item = Item.query.filter(Item.unit == unit, Item.section == _section)
        if role[0] == "3":  # 只看个人的
            item = Item.query.filter(Item.user_id == user_id)

        if date_begin and date_end:
            item = item.filter(Item.store.between(date_begin, date_end))

        item_user = User.query.filter_by(unit=unit)
        item_evolve = Attract.query.filter_by(statu=1, sid=2)
        item_industry = Attract.query.filter_by(statu=1, sid=1)
        if stage_id:
            item = item.filter_by(stage_id=stage_id)
            item_evolve = Attract.query.filter_by(nid=stage_id)
        if indu_id:
            item = item.filter_by(industry=indu_id)
            item_industry = item_industry.filter_by(nid=indu_id)
        if section:
            if section != "请选择":
                item = item.filter_by(section=section)
                item_user = item_user.filter_by(section=section)
        if user_id:
            item = item.filter_by(user_id=user_id)
            item_user = item_user.filter_by(section=section, id=user_id)

        start_time = date_begin
        data = []

        lis_qua = ["一", "二", "三", "四"]

        item_evolve = set(item_evolve.with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        evolve_list = [i[0] for i in item_evolve]
        evolve_list.sort()
        item_user = list(set(item_user.with_entities(User.id).all()))
        user_list = [i[0] for i in item_user]
        item_industry = list(set(item_industry.with_entities(Attract.nid).all()))
        industry_list = [i[0] for i in item_industry]
        industry_list.sort()
        j = 1

        time_now = time.localtime(int(time.time()))
        bb = []
        for i in evolve_list:
            stage_name = Attract.query.filter_by(nid=i, sid=2).first().name
            bb.append(stage_name)
        stage_list = [["序号", "年", "季度", "月"] + bb]
        bb = []
        for i in user_list:
            stage_name = User.query.get(i).real_name
            bb.append(stage_name)
        all_user = [["序号", "年", "季度", "月"] + bb]
        bb = []
        for i in industry_list:
            stage_name = Attract.query.filter_by(nid=i, sid=1).first().name
            bb.append(stage_name)

        all_industry = [["序号", "年", "季度", "月"] + bb]
        while start_time < date_end and start_time < time_now:
            month = int((start_time.tm_mon - 0.5) // 3)
            time_key = str(start_time.tm_year) + "-" + lis_qua[month] + "-" + str(start_time.tm_mon)
            end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
            end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
            end_time = str(end_time)
            end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
            item_time = item.filter(Item.store >= start_time, Item.store < end_time)

            evolve_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]

            for i in evolve_list:
                nums = item_time.filter_by(stage_id=i).count()

                evolve_data.append(nums)
            stage_list.append(evolve_data)

            user_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]

            for i in user_list:
                nums = item_time.filter_by(user_id=i).count()
                user_data.append(nums)

            all_user.append(user_data)
            industry_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]

            for i in industry_list:
                nums = item_time.filter_by(indu_id=i).count()
                industry_data.append(nums)
            all_industry.append(industry_data)

            j += 1
            start_time = end_time

        data.append({
            "stage": stage_list,
            "user": all_industry,
            "industry": all_user
        })

        return jsonify(code=RET.OK, msg="查找成功", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目上报追踪统计表选取表格下载type_a 1-进展，2-人员，3-产业（机构内部）
@api_manage.route("/stageInDown", methods=["POST"])
@login_required
def stage_in_down():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
        _section = user.section
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")
    section = req_dic.get("section")
    user_id = req_dic.get("user_id")
    type_a = req_dic.get("type")
    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])
    date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')
    try:
        if role[0] == "1":
            item = Item.query.filter(and_(Item.unit == unit, Item.store >= date_begin, Item.store < date_end))
        if role[0] == "2":
            item = Item.query.filter(
                and_(Item.unit == unit, Item.section == _section, Item.store >= date_begin, Item.store < date_end))
        if role[0] == "3":
            item = Item.query.filter(and_(Item.user_id == user_id, Item.store >= date_begin, Item.store < date_end))
        if stage_id:
            item = item.filter_by(evolve=stage_id)
        if indu_id:
            item = item.filter_by(indu_id=indu_id)
        if section:
            if section != "请选择":
                item = item.filter_by(section=section)
        if user_id:
            item = item.filter_by(user_id=user_id)

        start_time = date_begin
        lis_qua = ["一", "二", "三", "四"]
        time_now = time.localtime(int(time.time()))
        if type_a == 1:
            item_evolve = set(Attract.query.filter_by(statu=1, sid=2).with_entities(Attract.nid).all())
            item_evolve = list(item_evolve)
            item_evolve.sort()
            evolve_list = [i[0] for i in item_evolve]
            evolve_list_new = [Attract.query.filter_by(sid=2, nid=i).first().name for i in evolve_list]

            df_evolve = pd.DataFrame(columns=["序号", "年", "季度", "月"] + evolve_list_new)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)
                evolve = []
                evolve_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in evolve_list:
                    nums = item_time.filter_by(stage_id=i).count()

                    evolve_data.append(nums)
                df_evolve.loc[j] = evolve_data + evolve
                j += 1
                start_time = end_time
            path = pro_url + "/dayFile/evolve/"
            old_path = "/root/code/dist/files/dayFile/evolve/"
            if not os.path.exists(old_path):
                os.mkdir(old_path)
            filetime = int(time.time())
            filename_evolve = "阶段{}.xlsx".format(filetime)
            url = old_path + filename_evolve
            df_evolve.to_excel(url, index=None)  # , url=url)
            return jsonify(code=RET.OK, msg="查找成功", url=path + filename_evolve, filename=filename_evolve)

        if type_a == 2:
            item_user = User.query.filter_by(unit=unit)
            if section:
                if section != "请选择":
                    item = item.filter_by(section=section)
                    item_user = item_user.filter_by(section=section)
            if user_id:
                item = item.filter_by(user_id=user_id)
                item_user = item_user.filter_by(section=section, id=user_id)
            item_user = list(set(item_user.with_entities(User.id).all()))
            user_list = [i[0] for i in item_user]
            user_list_new = [User.query.get(i).real_name for i in user_list]
            df_user = pd.DataFrame(columns=["序号", "年", "季度", "月"] + user_list_new)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)

                user_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in user_list:
                    nums = item_time.filter_by(user_id=i).count()
                    user_data.append(nums)
                df_user.loc[j] = user_data

                j += 1
                start_time = end_time
                path = pro_url + "/dayFile/user/"
                old_path = "/root/code/dist/files/dayFile/user/"
                if not os.path.exists(old_path):
                    os.mkdir(old_path)
                filetime = int(time.time())
                filename_user = "用户{}.xlsx".format(filetime)
                url = old_path + filename_user
            df_user.to_excel(url, index=None)  # , url=path + url)
            return jsonify(code=RET.OK, msg="查找成功", url=path + filename_user, filename=filename_user)

        if type_a == 3:
            item_industry = set(Attract.query.filter_by(statu=1, sid=1).with_entities(Attract.nid).all())
            industry_list = [i[0] for i in item_industry]
            industry_list_new = [Attract.query.filter_by(sid=1, nid=i).first().name for i in industry_list]
            df_industry = pd.DataFrame(columns=["序号", "年", "季度", "月"] + industry_list_new)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)

                industry_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in industry_list:
                    nums = item_time.filter_by(indu_id=i).count()
                    industry_data.append(nums)

                df_industry.loc[j] = industry_data

                j += 1
                start_time = end_time
            path = pro_url + "/dayFile/industry/"
            old_path = "/root/code/dist/files/dayFile/industry/"
            if not os.path.exists(old_path):
                os.mkdir(old_path)
            filetime = int(time.time())
            filename_industry = "行业{}.xlsx".format(filetime)
            url = old_path + filename_industry
        df_industry.to_excel(url, index=None)  # , url=url)
        return jsonify(code=RET.OK, msg="查找成功", url=path + filename_industry, filename=filename_industry)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 机构统筹的机构
@api_manage.route("UnitUnit", methods=["GET"])
@login_required
def unit_unit():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit_name = user.unit
        unit = Government.query.filter_by(name=unit_name).first()
        data = [{"name": i.name, "unit_id": i.id} for i in unit.followed]
        data = [{"name": "请选择", "unit_id": ""}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计图查看（机构统筹机构）
@api_manage.route("/stageOutTable", methods=["POST"])
@login_required
def stage_out_table():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        unit = user.unit
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    unit_name = req_dic.get("unit_name")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")

    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])

    date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
    try:
        item = Item.query.filter(and_(Item.store >= date_begin, Item.store < date_end, Item.unit_up == unit))
        government = Government.query.filter_by(name=unit).first()
        foller_name = [i.name for i in government.followed]
        item = item.filter(Item.unit.in_(foller_name))
        item_user = item.filter(Item.unit.in_(foller_name))
        item_evolve = Attract.query.filter_by(statu=1, sid=2)
        item_industry = Attract.query.filter_by(statu=1, sid=1)

        if stage_id:
            item = item.filter_by(stage_id=stage_id)
            item_evolve = Attract.query.filter_by(nid=stage_id)

        if indu_id:
            item = item.filter_by(industry=indu_id)
            item_industry = item_industry.filter_by(nid=indu_id)

        if unit_name:
            if unit_name != "请选择":
                item = item.filter_by(unit=unit_name)
                foller_name = Item.query.filter_by(unit=unit_name).all()

        item_evolve = set(item_evolve.filter_by(statu=1, sid=2).with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        item_evolve.sort()

        stage = [{
            "name": Attract.query.filter_by(nid=i[0], sid=2).first().name,
            "value": item.filter_by(stage_id=i[0]).count()
        } for i in item_evolve]

        item_user = set(item_user.with_entities(Item.unit).all())
        unit = [{
            "name": i, "value": item.filter_by(unit=i).count()
        } for i in foller_name]

        item_industry = set(item_industry.with_entities(Attract.nid).all())
        industry = [{
            "name": Attract.query.filter_by(nid=i[0], sid=1).first().name, "value": item.filter_by(indu_id=i[0]).count()
        } for i in item_industry]
        data = {
            "stage": stage,
            "unit": unit,
            "industry": industry
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计表查看（机构统筹机构）
@api_manage.route("/stageOutList", methods=["POST"])
@login_required
def stageoutlist():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        unit = user.unit
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    unit_name = req_dic.get("unit_name")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")

    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])

    date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
    try:
        item = Item.query.filter(and_(Item.store >= date_begin, Item.store <= date_end, Item.unit_up == unit))
        government = Government.query.filter_by(name=unit).first()
        foller_name = [i.name for i in government.followed]
        item = item.filter(Item.unit.in_(foller_name))
        item_evolve = Attract.query.filter_by(statu=1, sid=2)
        item_industry = Attract.query.filter_by(statu=1, sid=1)

        if stage_id:
            item = item.filter_by(stage_id=stage_id)
            item_evolve = Attract.query.filter_by(nid=stage_id)

        if indu_id:
            item = item.filter_by(industry=indu_id)
            item_industry = item_industry.filter_by(nid=indu_id)

        if unit_name:
            if unit_name != "请选择":
                item = item.filter_by(unit=unit_name)

        start_time = date_begin
        data = []

        lis_qua = ["一", "二", "三", "四"]

        item_evolve = set(item_evolve.with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        evolve_list = [i[0] for i in item_evolve]
        evolve_list.sort()
        item_industry = list(set(item_industry.with_entities(Attract.nid).all()))
        industry_list = [i[0] for i in item_industry]
        industry_list.sort()

        j = 1

        time_now = time.localtime(int(time.time()))

        bb = []
        for i in evolve_list:
            stage_name = Attract.query.filter_by(nid=i, sid=2).first().name
            bb.append(stage_name)
        stage_list = [["序号", "年", "季度", "月"] + bb]

        all_user = [["序号", "年", "季度", "月"] + foller_name]
        bb = []
        for i in industry_list:
            stage_name = Attract.query.filter_by(nid=i, sid=1).first().name
            bb.append(stage_name)

        all_industry = [["序号", "年", "季度", "月"] + bb]

        while start_time < date_end and start_time < time_now:
            month = int((start_time.tm_mon - 0.5) // 3)
            time_key = str(start_time.tm_year) + "-" + lis_qua[month] + "-" + str(start_time.tm_mon)
            end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
            end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
            end_time = str(end_time)
            end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
            item_time = item.filter(Item.store >= start_time, Item.store < end_time)
            evolve_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]

            for i in evolve_list:
                nums = item_time.filter_by(stage_id=i).count()

                evolve_data.append(nums)
            stage_list.append(evolve_data)

            user_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
            print(foller_name)
            for i in foller_name:
                nums = item_time.filter_by(unit=i).count()
                user_data.append(nums)

            all_user.append(user_data)

            industry_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]

            for i in industry_list:
                nums = item_time.filter_by(indu_id=i).count()
                industry_data.append(nums)
            all_industry.append(industry_data)

            j += 1
            start_time = end_time

        data.append({
            "stage": stage_list,
            "unit": all_industry,
            "industry": all_user
        })

        return jsonify(code=RET.OK, msg="查找成功", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计表下载（机构统筹机构）
@api_manage.route("/stageOutDown", methods=["POST"])
@login_required
def stage_out_down():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    unit_name = req_dic.get("unit_name")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")
    type_a = req_dic.get("type")
    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])

    date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
    try:
        item = Item.query.filter(and_(Item.store >= date_begin, Item.store < date_end, Item.unit_up == unit))
        government = Government.query.filter_by(name=unit).first()
        foller_name = [i.name for i in government.followed]
        item = item.filter(Item.unit.in_(foller_name))

        if stage_id:
            item = item.filter_by(stage_id=stage_id)
        if indu_id:
            item = item.filter_by(indu_id=indu_id)

        if unit_name:
            if unit_name != "请选择":
                item = item.filter_by(unit=unit_name)
        else:
            try:
                government = Government.query.filter_by(name=unit).first()
                data = [i.name for i in government.followed]
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")
            item = item.filter(Item.unit.in_(data))

        start_time = date_begin
        time_now = time.localtime(int(time.time()))
        lis_qua = ["一", "二", "三", "四"]
        if type_a == 1:
            item_evolve = set(Attract.query.filter_by(statu=1, sid=2).with_entities(Attract.nid).all())
            item_evolve = list(item_evolve)
            item_evolve.sort()
            evolve_list = [i[0] for i in item_evolve]
            evolve_list_new = [Attract.query.filter_by(sid=2, nid=i).first().name for i in evolve_list]

            df_evolve = pd.DataFrame(columns=["序号", "年", "季度", "月"] + evolve_list_new)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)
                evolve = []
                evolve_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in evolve_list:
                    nums = item_time.filter_by(stage_id=i).count()

                    evolve_data.append(nums)
                df_evolve.loc[j] = evolve_data + evolve
                j += 1
                start_time = end_time
            path = pro_url + "/dayFile/evolve/"
            old_path = "/root/code/dist/files/dayFile/evolve/"
            if not os.path.exists(old_path):
                os.mkdir(old_path)
            filetime = int(time.time())
            filename_evolve = "阶段{}.xlsx".format(filetime)
            url = old_path + filename_evolve
            df_evolve.to_excel(url, index=None)  # , url=url)
            return jsonify(code=RET.OK, msg="查找成功", url=path + filename_evolve, filename=filename_evolve)

        if type_a == 2:
            df_user = pd.DataFrame(columns=["序号", "年", "季度", "月"] + foller_name)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)

                user_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in foller_name:
                    nums = item_time.filter_by(unit=i).count()
                    user_data.append(nums)
                df_user.loc[j] = user_data

                j += 1
                start_time = end_time
                path = pro_url + "/dayFile/user/"
                old_path = "/root/code/dist/files/dayFile/user/"
                if not os.path.exists(old_path):
                    os.mkdir(old_path)
                filetime = int(time.time())
                filename_user = "用户{}.xlsx".format(filetime)
                url = old_path + filename_user
            df_user.to_excel(url, index=None)  # , url=path + url)

            return jsonify(code=RET.OK, msg="查找成功", data=path + filename_user, filename=filename_user)

        if type_a == 3:
            item_industry = set(Attract.query.filter_by(statu=1, sid=1).with_entities(Attract.nid).all())
            industry_list = [i[0] for i in item_industry]
            industry_list_new = [Attract.query.filter_by(sid=1, nid=i).first().name for i in industry_list]

            df_industry = pd.DataFrame(columns=["序号", "年", "季度", "月"] + industry_list_new)
            j = 1
            while start_time < date_end and start_time < time_now:
                month = int((start_time.tm_mon - 0.5) // 3)
                end_time = time.strftime('%Y-%m-%d %H:%M:%S', start_time)  # - relativedelta(months= +1)
                end_time = datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S") - relativedelta(months=-1)
                end_time = str(end_time)
                end_time = time.strptime(end_time, '%Y-%m-%d %H:%M:%S')
                item_time = item.filter(Item.store >= start_time, Item.store < end_time)

                industry_data = [j, str(start_time.tm_year), lis_qua[month], str(start_time.tm_mon)]
                for i in industry_list:
                    nums = item_time.filter_by(indu_id=i).count()
                    industry_data.append(nums)
                df_industry.loc[j] = industry_data
                j += 1
                start_time = end_time
            path = pro_url + "/dayFile/industry/"
            old_path = "/root/code/dist/files/dayFile/industry/"
            if not os.path.exists(old_path):
                os.mkdir(old_path)
            filetime = int(time.time())
            filename_industry = "行业{}.xlsx".format(filetime)
            url = old_path + filename_industry
            df_industry.to_excel(url, index=None)  # , url=url)
        return jsonify(code=RET.OK, msg="查找成功", url=path + filename_industry, filename=filename_industry)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 判断是内部用户还是外部用户，
@api_manage.route("/getFlag", methods=["POST"])
@login_required
def get_flag():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        flag = user.flag  # 普通1，政府2 ,# 区县用户
        # if flag == 2 and user.unit != "太原市促进外来投资局":
        #     flag = 3
        return jsonify(code=RET.OK, msg="查询成功", data=flag)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
