import re
import random
import threading
from flask import jsonify, request, current_app
from flask_mail import Mail, Message
from apps import redis_store, creat_app
from apps.view_user import api_user
from apps.models import *
from apps.utils.response_code import RET
from apps.util import login_required, verify_token
from apps.utils.send_phone_info import send_code_new


# 全国企业的收藏，可能存在问题，企业实体数

@api_user.route("/user_code", methods=["POST"])
def user_code():
    # 获取请求参数，转化字典
    req_dict = request.get_json()
    mobile = req_dict.get('mobile')

    if not all([mobile]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    if not re.match(r'^1[3456789]\d{9}$', mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    sms_code = "%06d" % random.randint(0, 999999)
    data = send_code_new(mobile, sms_code)

    if data['Message'] == 'OK':
        # 保存真实的短信验证码
        try:
            redis_store.setex("sms_code_%s" % mobile, constants.SMS_CODE_REDIS_EXPIRES, sms_code)
            # 保存发送给这个手机号的记录，防止用户在60s内再次出发发送短信的操作
            redis_store.setex("send_sms_code_%s" % mobile, constants.SEND_SMS_CODE_INTERVAL, 60)

        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="保存短信验证码异常")
        # 发送成功
        return jsonify(code=RET.OK, msg="发送成功")

    else:
        return jsonify(code=RET.THIRDERR, msg="发送失败")


# 异步邮箱发送信息
def send_async_email(mail, app, msg):
    with app.app_context():
        mail.send(msg)





# 给邮箱发验证码
@api_user.route("/email_code", methods=["POST"])
def send_email_code():
    '''
    向邮箱送验证码
    :return:
    '''
    # 获取请求参数，转化字典
    req_dict = request.get_json()
    email = req_dict.get('email')  # 邮箱号

    # 校验参数完整性
    if not all([email]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验邮箱格式
    if not re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$", email):
        return jsonify(code=RET.PARAMERR, msg="邮箱格式错误")

    # print(email)
    # app = creat_app('product')
    app = creat_app('develop')
    mail = Mail(app)
    sms_code = "%06d" % random.randint(0, 999999)

    msg = Message("中研认知产业链在线,欢迎您！", recipients=[email])
    msg.body = "【中研认知产业链在线】您的验证码为：{}，您正在进行邮箱绑定，如非本人操作，请忽略本邮件！".format(sms_code)
    thread = threading.Thread(target=send_async_email, args=(mail, app, msg))
    thread.start()

    try:
        redis_store.setex("sms_code_%s" % email, constants.SMS_CODE_REDIS_EXPIRES, sms_code)
        # 保存发送给这个邮箱号的记录，防止用户在60s内再次出发发送短信的操作
        redis_store.setex("send_sms_code_%s" % email, constants.SEND_SMS_CODE_INTERVAL, 60)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="保存验证码异常")
    print(redis_store.get('sms_code_{}'.format(email)))
    return jsonify(code=RET.OK, msg="发送成功")


@api_user.route("/changeEmail", methods=["POST"])
@login_required
def change_email():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dic = request.get_json()
    email = req_dic.get("email")
    email_code = req_dic.get("email_code")
    try:
        user_information = User.query.get(user_id)

        if not all([email, email_code]):
            return jsonify(code=RET.PARAMERR, msg="参数不全")
        if email:
            user_information.email = email

            if not email_code:
                return jsonify(code=RET.NODATA, msg="验证码不能为空")

            if not re.match("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$",
                            user_information.email):
                return jsonify(code=RET.PARAMERR, msg="邮箱格式错误")

            # 获取邮箱验证码
            try:
                real_sms_code = redis_store.get('sms_code_{}'.format(user_information.email)).decode()
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="redis数据库异常")

            # 判断邮箱验证码是否失效
            if not redis_store:
                return jsonify(code=RET.NODATA, msg="短信验证码失效")

            # 删除redis中的邮箱验证码，防止重复校验
            try:
                redis_store.delete("sms_code_{}".format(user_information.email))
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="redis数据库异常")
            # 判断用户填写短信验证码是否一致
            if real_sms_code != email_code:
                return jsonify(code=RET.DATAERR, msg="邮箱验证码错误")
            db.session.commit()
            return jsonify(code=RET.OK, msg="更改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# @api_user.route("/detail", methods=["GET"])
# @login_required
# def detail():
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id
#     try:
#         user_information = User.query.get(user_id)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     data = {
#         "flag": user.flag,
#         "real_name": user_information.real_name,  # 名字
#         "age": user_information.age,  # 年龄
#         "sex": user_information.sex,  # 性别
#         "mobile": user_information.mobile,  # 手机号
#         "username": user_information.name,  # 用户名
#         "email": user_information.email,  # 邮箱
#         "section": user_information.section if user_information.section else "-",  # 部门
#         "position": user_information.position if user_information.position else "-",  # 职务
#         "level": user_information.level if user_information.level else "-",  # 职级
#         "unit": user_information.unit if user_information.unit else "-",  # 所在机构
#         "funct": user_information.function if user_information.function else "-",  # 工作职能
#     }
#     return jsonify(code=RET.OK, msg="查找成功", data=data)


# @api_user.route("/personal", methods=["POST"])
# @login_required
# def personal():
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id
#
#     req_dict = request.get_json()
#     real_name = req_dict.get("real_name")
#     age = req_dict.get("age")
#     sex = req_dict.get("sex")
#     name = req_dict.get("name")
#
#     try:
#         user_information = User.query.get(user_id)
#
#         # 姓名
#         if real_name:
#             user_information.real_name = real_name
#
#         # 年龄
#         if age:
#             user_information.age = age
#
#         # 性别  1 - 男   2 - 女
#         if sex:
#             user_information.sex = sex
#
#         # 用户名
#         if name:
#             user = User.query.filter_by(name=name).filter(User.id != user_id).first()
#             if user:
#                 return jsonify(code=RET.DATAEXIST, msg="用户名已经存在")
#             user_information.name = name
#         db.session.commit()
#     except Exception as e:
#         db.session.rollback()  # 回滚数据库
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     return jsonify(code=RET.OK, msg="修改成功")


# 企业的收藏加个下拉列表来判断来自哪个表--是全国企业还是山西企业。
# 返回值里面要带有status还未添加
# 查看收藏----页数，分类

# @api_user.route("/EnterpriseCollect", methods=["POST"])
# @login_required
# def enterprise_collect():
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id
#
#     req_dict = request.get_json()
#     page = req_dict.get("page")
#     per_page = req_dict.get("per_page")
#     classify = req_dict.get("classify")
#     choice = req_dict.get("choice")
#     if not page:
#         page = 1
#
#     if not per_page:
#         per_page = 10
#
#     if not all([classify, choice]):
#         return jsonify(code=RET.PARAMERR, msg="数据不全")
#
#     # 判断是企业还是行业关注，企业1，行业0
#     if classify == 1:
#         company = []
#         try:
#             user = User.query.get(user_id)
#         except Exception as e:
#             current_app.logger.error(e)
#             return jsonify(code=RET.DBERR, msg="数据库错误")
#         if choice == 2:
#             try:
#                 maxnum = len(user.enterprise)
#                 company_list = user.enterprise[(page - 1) * per_page:page * per_page]
#                 for i in company_list:
#                     create_time = UserEnterprise.query.filter_by(enterprise_id=i.id, user_id=user_id).first()
#                     company.append({
#                         "id": i.id,
#                         "company_name": i.company_name,
#                         "create_time": create_time.create_time.strftime('%Y-%m-%d'),
#                         "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-"
#                     })
#             except Exception as e:
#                 current_app.logger.error(e)
#                 return jsonify(code=RET.DBERR, msg="数据库错误")
#
#             data = {
#                 "ob_list": company,
#                 "maxnum": maxnum
#             }
#             return jsonify(code=RET.OK, msg="查找成功", data=data)
#         else:
#             maxnum = len(user.company)
#             company_list = user.company[(page - 1) * per_page:page * per_page]
#             try:
#                 for i in company_list:
#                     create_time = UserCompany.query.filter_by(company_id=i.id, user_id=user_id).first()
#                     company.append({
#                         "id": i.id,
#                         "company_name": i.company_name,
#                         "create_time": create_time.create_time.strftime('%Y-%m-%d'),
#                         "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-"
#                     })
#             except Exception as e:
#                 current_app.logger.error(e)
#                 return jsonify(code=RET.DBERR, msg="数据库错误")
#
#             data = {
#                 "ob_list": company,
#                 "maxnum": maxnum
#             }
#             return jsonify(code=RET.OK, msg="查找成功", data=data)
#     # 行业
#     try:
#         user = User.query.get(user_id)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     maxnum = len(user.industry)
#     industry = []
#     industry_list = user.industry[(page - 1) * per_page:page * per_page]
#
#     for i in industry_list:
#         # 查询关注时间
#         try:
#             indu = UserIndustry.query.filter_by(industry_id=i.id, user_id=user_id).first()
#         except Exception as e:
#             current_app.logger.error(e)
#             return jsonify(code=RET.DBERR, msg="数据库错误")
#
#         # count = Company.query.filter_by(company_industry = i.name)
#         industry.append({
#             "id": i.id,
#             "industry_name": i.name,
#             "create_time": indu.create_time.strftime("%Y-%m-%d"),
#             "count": i.entities if i.entities else 0
#         })
#
#     data = {
#         "ob_list": industry,
#         "maxnum": maxnum
#     }
#     return jsonify(code=RET.OK, msg="查找成功", data=data)


# 取消收藏
@api_user.route("/delete", methods=["POST"])
@login_required
def delete():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    req_dict = request.get_json()

    id = req_dict.get("id")
    classify = req_dict.get("classify")
    choice = req_dict.get("choice")
    print(id, classify, choice)
    if not all([id, classify, choice]):
        return jsonify(code=RET.PARAMERR, msg="数据不全")

    # id = g.id

    if classify == 1:
        if choice == "2":
            # 删除全国数据
            # pass
            try:
                company_user = UserEnterprise.query.filter_by(enterprise_id=id, user_id=user_id).first()
                db.session.delete(company_user)
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")
        else:
            try:
                company_user = UserCompany.query.filter_by(company_id=id, user_id=user_id).first()
                db.session.delete(company_user)
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")
    # 删除企业数据
    try:
        industry_user = UserIndustry.query.filter_by(industry_id=id, user_id=user_id).first()
        db.session.delete(industry_user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="取关成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
