import os
import json
from elasticsearch import Elasticsearch
from flask import request, jsonify, current_app
from apps.models import *
from apps.view_mobile import api_mobile
from apps.util import login_required, verify_token
from apps.utils.response_code import RET


def body_qualificat(s, j):
    body = {
        "query": {
            "bool": {
                "must": {"match":
                             {"{}": "{}".format(s, j)}
                         }
            }
        }
    }
    return body


def body_type(s):
    body = {
        "query": {
            "bool": {
                "must": {"match":
                             {"entypeid": "{}".format(s)}
                         }
            }
        }
    }
    return body


def create_body(page, page_size, args_query, args_date, args_term):
    '''

    :param page:
    :param page_size:
    :param args_query:
    :param args_date:
    :param args_term:
    :return:
    '''

    body = {
        "query": {
            "bool": {
                "filter": {
                    "range": {
                        "build_date": {
                        }
                    }
                },
                "must": [
                    {"multi_match": {
                        "query": "{}".format(args_query["query"]),
                        "type": "best_fields",
                        "fields": [
                            "product^1.0",
                            "company_name^1.0",
                            "industry^1.0"
                        ],
                        "tie_breaker": 0.3
                    }
                    },
                ]
            }
        },
        "from": page,
        "size": page_size,
        "sort": [],
        "aggs": {},
        "_source": [
            # 'all_info',
            'industry', 'build_date', 'register_money_nums', 'product',
            'company_name', "mysql_id"
        ],
        "highlight": {
            "fields": {
                "product": {"type": "plain"},
                "company_name": {"type": "plain"},
                "industry": {"type": "plain"}
            }
        }
    }

    if args_date:
        body["query"]["bool"]["filter"]["range"]["build_date"]["gte"] = args_date["build_date"][0]
        body["query"]["bool"]["filter"]["range"]["build_date"]["lte"] = args_date["build_date"][1]

    for k, v in args_term.items():
        body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})

    return body


# 360企业画像两个静态表

def openDists():
    upload_path = os.path.dirname(os.path.dirname(__file__)) + "/utils/json/city.json"
    with open(upload_path, encoding="utf-8") as f:
        data = json.load(f)

    return data


# 地域层级数据分级获取
@api_mobile.route('/mobileGetRegion', methods=['GET'])
def mobile_get_region():
    try:
        data = openDists()
        if len(data) > 0:
            return jsonify(code=200, msg="查找成功", data=data)
        else:
            return jsonify(code=201, msg="暂时没有数据")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查找错误")


@api_mobile.route('/mobileField', methods=['GET'])
# @login_required
def mobile_field():
    '''
    全国企业条件选择导航获取
    :return:
    '''
    try:
        property = Property.query.filter_by(statu=1)
        typy = property.filter_by(sid=1, statu=1).all()
        qualificat = property.filter_by(sid=2, statu=1).all()
        quoted = property.filter_by(sid=3, statu=1).all()
        financ = property.filter_by(sid=4, statu=1).all()
        # options: [{ value: "选项1", label: "无数据" },{ value: "选项2", label: "3333" }],
        data = {"entype": [{"name": "请选择", "id": ""}] + [{"name": i.name, "id": i.nid} for i in typy],
                "qualificat": [{"name": "请选择", "id": ""}] + [{"name": i.name, "id": i.nid} for i in qualificat],
                "quoted": [{"name": "请选择", "id": ""}] + [{"name": i.name, "id": i.nid} for i in quoted],
                "financ": [{"name": "请选择", "id": ""}] + [{"name": i.name, "id": i.nid} for i in financ],
                "buildate": [{"name": "请选择", "id": ""}] + [{"name": "1-3年", "id": 1}, {"name": "3-5年", "id": 2},
                                                           {"name": "5-8年", "id": 3}, {"name": "8-10年", "id": 4},
                                                           {"name": "10-15年", "id": 5}, {"name": "15年以上", "id": 6}],
                "capital": [{"name": "请选择", "id": ""}] + [{"name": "100万以内", "id": 1}, {"name": "100万-500万", "id": 2},
                                                          {"name": "500万-1000万", "id": 3},
                                                          {"name": "1000万-5000万", "id": 4},
                                                          {"name": "1000万-1亿", "id": 5}, {"name": "1亿以上", "id": 6}]
                }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", options=data)


# 搜索接口
@api_mobile.route("/mobileSearch", methods=["POST"])
@login_required
def mobile_search():
    req_dict = request.get_json()

    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # ##es的查询，。。。。
    # user_id = 2
    qualificat = req_dict.get("qualificat")
    entypeid = req_dict.get("entypeid")
    area = req_dict.get("area")
    province = None
    city = None
    district = None
    if area:
        province = area[0]
        city = area[1]
        district = area[2]
    capital_id = req_dict.get("capital_id")
    public_id = req_dict.get("public_id")
    financ_id = req_dict.get("financ_id")
    yearid = req_dict.get("yearid")
    print(yearid)
    company = req_dict.get("company")

    args_query = dict()
    args_date = dict()
    args_term = dict()

    # #每页个数
    per_page = req_dict.get("per_page")
    page = req_dict.get("page")
    if not req_dict.get("per_page"):
        per_page = 10
    per_page = int(per_page)
    # 页数
    if not page:
        page = 1
    page = int(page)
    page = (page - 1) * per_page
    args_query["query"] = "公司"
    # 搜索框
    if company:
        args_query["query"] = company

        try:
            user = User.query.get(user_id)
            b = []
            if user.searchlist:
                for j in user.searchlist:
                    b.append(j.history)
                if company in b:
                    user.searchlist.remove(user.searchlist[b.index(company)])
                if len(b) > 5:
                    user.searchlist.remove(user.searchlist[0])
            search = SearchList(history=company)
            db.session.add(search)
            user.searchlist.append(search)
            db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")

    # 公司类型
    if entypeid:
        args_term['entypeid'] = entypeid

    # 注册资本
    if capital_id:
        args_term['capital_id'] = capital_id

    # 上市状态
    if public_id:
        args_term['public_id'] = public_id

    # 省
    if province:
        args_term['province'] = province

    # 市
    if city:
        args_term['city'] = city

    # 区
    if district:
        args_term['district'] = district

    # 公司资质
    if qualificat:

        if qualificat == 1:
            args_term['high_new'] = 1

        if qualificat == 2:
            args_term['tbe'] = 1

        if qualificat == 3:
            args_term['quoted_company'] = 1

        if qualificat == 4:
            args_term['isfive'] = 1

        if qualificat == 5:
            args_term['unicorn'] = 1

        if qualificat == 6:
            args_term['dengl'] = 1

    # 成立时间
    if yearid:
        args_term['yearid'] = yearid

    if financ_id:
        args_term['financ_id'] = financ_id

    body = create_body(page, per_page, args_query, args_date, args_term)
    if not company:
        del body["query"]["bool"]["must"][0]

    try:
        es = Elasticsearch([{'host': '39.100.39.50', 'port': 9200}])

        data = es.search(index="ty_360", body=body)
        data_list = []

        # 数据的列表添加进去
        for i in data["hits"]['hits']:

            if company:
                # 判断高亮，然后添加
                data_list.append({
                    "company": i["highlight"]["company_name"][0] if "company_name" in i["highlight"] else i["_source"][
                        "company_name"],
                    "product": i["highlight"]["product"][0] if "product" in i["highlight"] else i["_source"]["product"],
                    "industry": i["highlight"]["industry"][0] if "industry" in i["highlight"] else i["_source"][
                        "industry"],
                    "money": "{}万元".format(i["_source"]["register_money_nums"]),
                    "createtime": i["_source"]["build_date"],
                    "id": i["_source"]["mysql_id"],
                    "choice": 2
                })
            else:
                data_list.append({
                    "company": i["_source"]["company_name"],
                    "product": i["_source"]["product"],
                    "industry": i["_source"]["industry"],
                    "money": "{}万元".format(i["_source"]["register_money_nums"]),
                    "createtime": i["_source"]["build_date"],
                    "id": i["_source"]["mysql_id"],
                    "choice": 2,
                })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="es数据库错误")
    data = {
        "data": data_list
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 搜索历史接口
@api_mobile.route("/mobileSearchList", methods=["GET"])
@login_required
def mobile_search_list():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 2
    try:
        user = User.query.get(user_id)
        data = {
            "search": [i.history for i in user.searchlist]
        }
        data["search"] = data["search"][::-1]
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 删除搜索历史接口
@api_mobile.route("/deleteSearchlist", methods=["GET"])
@login_required
def delete_search_list():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 2
    try:
        user = User.query.get(user_id)
        for i in user.searchlist:
            user.searchlist.remove(i)
        db.session.commit()
        return jsonify(code=RET.OK, msg="查询成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
