from flask import g, current_app, request, jsonify, session
from sqlalchemy import or_

from apps.view_map import api_map
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
import json
import requests
from apps import db, constants, redis_store

'''本页接口使用全国企业库enterprise'''
graph = conn_neo4j()


# 颜色计数
def jishu(num):
    if num >= 0 and num <= 50:
        return "#72D4F1"
    if num > 50 and num <= 100:
        return "#00BAF6"
    if num > 100 and num <= 200:
        return "#4F9FFF"
    if num > 200 and num <= 500:
        return "#4265F6"
    if num > 500 and num <= 1000:
        return "#0052d6"
    if num > 1000:
        return "#0245AE"


# 招商地图下的色块图(同右侧得数量分布饼图)
@api_map.route('/AttractMap', methods=['POST'])
# @login_required
def attract_map():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    try:
        enterprise = Enterprise.query.filter_by(c_type=inid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                province_data = Enterprise.query.filter_by(province=pro).first()
                df.append({"name": pro,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": province_data.p_lng, "lat": province_data.p_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                city_data = Enterprise.query.filter_by(province=province, city=cit).first()
                df.append({"name": cit,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": city_data.c_lng, "lat": city_data.c_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                district_data = Enterprise.query.filter_by(province=province, city=city, district=dis).first()
                df.append({"name": dis,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            district_data = Enterprise.query.filter_by(province=province, city=city, district=district).first()
            print(district_data)
            if district_data:
                df.append({"name": district,
                           "value": num,
                           "color": "",
                           "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})
                return jsonify(code=RET.OK, msg="获取成功", data=df)
            else:
                return jsonify(code=RET.OK, msg="无满足条件数据", data=df)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 右侧全国地图企业数据
@api_map.route('/EnterpriseTop5', methods=['POST'])
# @login_required
def attract_cnums():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    try:
        enterprise = Enterprise.query.filter_by(c_type=inid)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                df.append({"name": pro, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                df.append({"name": cit, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                df.append({"name": dis, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            df.append({"name": district, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])

        return jsonify(code=RET.DATAERR, msg="地区参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 全国企业列表
@api_map.route('/AttractEnterprise', methods=['POST'])
# @login_required
def enterprise():
    '''
    太原市企业列表
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:  # 子行业分类
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        # 区域选择
        if province:
            enterprise = enterprise.filter_by(province=province)
            if city:
                enterprise = enterprise.filter_by(city=city)
                if district:
                    enterprise = enterprise.filter_by(district=district)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        size = enterprise.count()
        enterprise = enterprise.order_by(Enterprise.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": i.id,
               "company_name": i.company_name,
               "hots": i.hots,
               "aptitude": ['高新技术企业' if i.high_new == '1' else
                            '科技型中小企业' if i.tbe == '1' else
                            '上市企业' if i.quoted_company == '1' else
                            '山西民营100强' if i.sxmon == '1' else
                            '山西专精特新企业' if i.zjtg == '1' else
                            '独角兽企业' if i.unicorn == '1' else
                            '瞪羚' if i.dengl == '1' else
                            '中国500强' if i.isfive == '1' else
                            '规模以上企业' if i.scale == '1' else
                            '限额以上服务业' if i.serve == '1' else '']
               } for i in enterprise]
        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 招商地图下的散点图（至区后）
@api_map.route('/AttractSdmap', methods=['POST'])
# @login_required
def attract_sdmap():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    # 校验参数完整性
    # if not all([district]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            enterprise = Enterprise.query.filter_by(c_type=inid)
        else:
            enterprise = Enterprise.query.filter_by()
        if district:
            enterprise = enterprise.filter_by(province=province, city=city, district=district)
        if product:
            enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
        enterprise = enterprise.all()
        data = []
        if enterprise:
            for com in enterprise:
                data.append({"id": com.id,
                             "name": com.company_name,
                             "jwd": {"lng": com.lng,  # 企业地址出的经纬度
                                     "lat": com.lat}
                             })  # 上下中游
        else:
            return jsonify(code=RET.OK, msg="获取失败，无数据", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


"""以下202212月改版后需求新增"""


# 企业搜索
@api_map.route('/SearchEnterprises', methods=['POST'])
def search_enterprise():
    req_dic = request.get_json()
    entype = req_dic['entype']
    aptitude = req_dic['aptitude']  # 资质
    company_name = req_dic['company_name']
    status = req_dic['status']
    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        enterprise_obj = Enterprise.query.filter(or_(
            Enterprise.entype == entype,
            Enterprise.company_name.like('%{}%'.format(company_name)),
            Enterprise.status == status,
            Enterprise.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Enterprise.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Enterprise.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Enterprise.sxmon == '1' if aptitude == '山西民营100强' else text(''),
            Enterprise.zjtg == '1' if aptitude == '山西专精特新企业' else text(''),
            Enterprise.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Enterprise.dengl == '1' if aptitude == '瞪羚' else text(''),
            Enterprise.isfive == '1' if aptitude == '中国500强' else text(''),
            Enterprise.scale == '1' if aptitude == '规模以上企业' else text(''),
            Enterprise.serve == '1' if aptitude == '限额以上服务业' else text(''),
        ))
        size = enterprise_obj.count()

        enterprise_obj_list = enterprise_obj.paginate(page, per_page).items
        data = [{
            "id": enterprise_obj.id,
            "enterprise_name": enterprise_obj.enterprise_name,
            "district": enterprise_obj.district,
            "entype": enterprise_obj.entype,
            "aptitude": ["高新技术企业" if enterprise_obj.high_new == '1' else
                         "科技型中小企业" if enterprise_obj.tbe == '1' else
                         "上市企业" if enterprise_obj.quoted_company == '1' else
                         "山西民营100强" if enterprise_obj.sxmon == '1' else
                         "山西专精特新企业" if enterprise_obj.zjtg == '1' else
                         "独角兽企业" if enterprise_obj.unicorn == '1' else
                         "瞪羚" if enterprise_obj.dengl == '1' else
                         "中国500强" if enterprise_obj.isfive == '1' else
                         "规模以上企业" if enterprise_obj.scale == '1' else
                         "限额以上服务业" if enterprise_obj.serve == '1' else '']
        } for enterprise_obj in enterprise_obj_list]
        data = {"size": size, "df": data}

        return jsonify(code=RET.OK, data=data, msg='查询成功。')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='查询出错！')