from flask import current_app, request, jsonify
from apps.manage import api_power
from apps.models import *
from apps.util import login_required, verify_btoken
from apps.utils.response_code import RET


# 导航目录列表
@api_power.route('/listField', methods=['GET'])
@login_required
def list_fields():
    '''导航目录列表'''
    try:
        field = Industry.query.all()
        data = [{"id": i.id,
                 "name": i.name,
                 "statu": i.statu,  # 启用状态1启用，2禁用
                 "cate": "一级产业" if i.fid == 0 else "二级产业"} for i in field]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 导航信息编辑
@api_power.route('/modifyFields', methods=['POST'])
@login_required
def modify_fields():
    '''导航信息修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    name = req_dict.get("newname")  # 行业新名字

    try:
        field = Industry.query.get(_id)
        field.name = name
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


# 导航状态修改
@api_power.route('/fieldStatu', methods=['POST'])
@login_required
def field_statu():
    '''导航信息修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    statu = req_dict.get("statu")  # 状态值1启用，2禁用

    try:
        field = Industry.query.get(_id)
        if statu == 1:
            field.statu = 2
        else:
            field.statu = 1
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


'''导航一'''


# 产业发展图谱目录列表
@api_power.route('/listPropertyty', methods=['GET'])
@login_required
def list_propertyty():
    '''产业发展图谱目录列表'''
    try:
        field = Propertyty.query.all()
        data = [{"id": i.id,
                 "name": i.name,
                 "statu": i.statu,  # 状态 1启动，2禁用
                 "cate": "企业类型" if i.sid == 1 else "企业资质" if i.sid == 2 else "上市状态" if i.sid == 3
                 else "融资轮次"} for i in field]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 产业发展图谱目录信息编辑
@api_power.route('/modifyPropertyty', methods=['POST'])
@login_required
def modify_propertyty():
    '''产业发展图谱目录信息编辑'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    name = req_dict.get("newname")  # 行业新名字

    try:
        propertyty = Propertyty.query.get(_id)
        propertyty.name = name
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


# 产业发展图谱导航状态修改
@api_power.route('/propertytyStatu', methods=['POST'])
@login_required
def propertyty_statu():
    '''产业发展图谱导航状态修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    statu = req_dict.get("statu")  # 状态值1启用，2禁用

    try:
        propertyty = Propertyty.query.get(_id)
        if statu == 1:
            propertyty.statu = 2
        else:
            propertyty.statu = 1
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


'''导航二'''


# 产业招商地图360企业画像目录列表
@api_power.route('/listProperty', methods=['GET'])
@login_required
def list_property():
    '''产业发展图谱目录列表'''
    try:
        propert = Property.query.all()
        data = [{"id": i.id,
                 "name": i.name,
                 "statu": i.statu,  # 状态 1启动，2禁用
                 "cate": "企业类型" if i.sid == 1 else "企业资质" if i.sid == 2 else "上市状态" if i.sid == 3
                 else "融资轮次"} for i in propert]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 产业招商地图360企业画像目录信息编辑
@api_power.route('/modifyProperty', methods=['POST'])
@login_required
def modify_property():
    '''产业招商地图360企业画像目录信息编辑'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    name = req_dict.get("newname")  # 行业新名字

    try:
        propert = Property.query.get(_id)
        propert.name = name
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


# 产业招商地图360企业画像目录状态修改
@api_power.route('/propertyStatu', methods=['POST'])
@login_required
def property_statu():
    '''产业招商地图360企业画像目录状态修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    statu = req_dict.get("statu")  # 状态值1启用，2禁用

    try:
        propert = Property.query.get(_id)
        if statu == 1:
            propert.statu = 2
        else:
            propert.statu = 1
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


'''导航三'''


# 招商资源管理目录列表
@api_power.route('/listAttract', methods=['GET'])
@login_required
def list_atract():
    '''招商资源管理目录列表'''
    try:
        attract = Attract.query.all()
        data = [{"id": i.id,
                 "name": i.name,
                 "statu": i.statu,  # 状态 1启动，2禁用
                 "cate": "行业选择" if i.sid == 1 else "项目阶段" if i.sid == 2 else "项目级别"} for i in attract]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 招商资源管理目录信息编辑
@api_power.route('/modifyAttract', methods=['POST'])
@login_required
def modify_attract():
    '''招商资源管理目录信息编辑'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    name = req_dict.get("newname")  # 行业新名字

    try:
        attract = Attract.query.get(_id)
        attract.name = name
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


# 招商资源管理目录状态修改
@api_power.route('/attractStatu', methods=['POST'])
@login_required
def attract_statu():
    '''产业发展图谱导航状态修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    statu = req_dict.get("statu")  # 状态值1启用，2禁用

    try:
        attract = Attract.query.get(_id)
        if statu == 1:
            attract.statu = 2
        else:
            attract.statu = 1
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


'''导航四'''


# 园区信息目录列表
@api_power.route('/listZone', methods=['GET'])
@login_required
def list_zone():
    '''招商资源管理目录列表'''
    try:
        zone = Zone.query.all()
        data = [{"id": i.id,
                 "name": i.name,
                 "statu": i.statu,  # 状态 1启动，2禁用
                 "cate": "园区类别" if i.sid == 1 else "园区级别"} for i in zone]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 园区信息目录信息编辑
@api_power.route('/modifyZone', methods=['POST'])
@login_required
def modify_zone():
    '''园区信息目录信息编辑'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    name = req_dict.get("newname")  # 行业新名字

    try:
        zone = Zone.query.get(_id)
        zone.name = name
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")


# 园区信息目录状态修改
@api_power.route('/zoneStatu', methods=['POST'])
@login_required
def zone_statu():
    '''园区信息目录状态修改'''
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    _id = req_dict.get('id')  # 行业id
    statu = req_dict.get("statu")  # 状态值1启用，2禁用

    try:
        zone = Zone.query.get(_id)
        if statu == 1:
            zone.statu = 2
        else:
            zone.statu = 1
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")

    return jsonify(code=RET.OK, msg="修改成功")
