from flask import current_app, request, jsonify
from apps.models import *
from apps.utils.response_code import RET
from apps.view_mobile import api_mobile
import pymysql


def judge_number(s):
    if "." in str(s):
        d = s.split(".")
        if len(d) == 2:
            for i in d:
                if i.isdigit():
                    pass
                else:
                    return False
            return True
        return False
    else:
        return str(s).isdigit()


# 选址评估，选择建议
@api_mobile.route("/chooseAdvice", methods=["POST"])
def choose_advice():
    req_dict = request.get_json()

    company = req_dict.get("company")
    industry = req_dict.get("industry")
    revenue = req_dict.get("revenue")
    tax = req_dict.get("tax")
    product = req_dict.get("product")
    budget = req_dict.get('budget')
    address = req_dict.get("address")
    preference = req_dict.get("preference")
    if not all([company, industry, revenue, tax, product, budget, preference]):
        return jsonify(code=RET.DATAERR, msg="数据不全")
    for i in range(0, 3):
        if not judge_number([revenue, tax, budget][i]):
            return jsonify(code=RET.DATAERR, msg=["营收应该为数字", "税收应该为数字", "预算应该为数字"][i])
    list_zone = []
    if address and address != "太原市":
        list_zone.append("(region='{}'or development_zone = '{}')".format(address, address))

    list_zone.append(" (f_type is Null or f_type = {}) ".format(industry))
    list_zone.append("IFNULL(induzone.tax,0)<={}".format(tax))
    list_zone.append("IFNULL(induzone.invest_power,0)<={}".format(budget))
    list_zone = " and ".join(list_zone)

    sum_list = []
    if preference[5] != "false":  # 地区经济发展 ---GDP的打分
        sum_list.append("IFNULL(induzone.gdp_point,0)")

    if preference[1] != "false":  # 产业聚集度 --- 产业的打分
        # sum_list.append("IFNULL(company_industry_point,0)")
        sum_list.append("IFNULL(company_industry_point.point,0)")

    if preference[0] != "false":  # 征服扶持力度 --- 政策数的打分
        sum_list.append("IFNULL(induzone.policy_point,0)")

    if preference[3] != "false":  # 生活配套 -------水电打分
        sum_list.append("IFNULL(induzone.warter_point,0)")

    # if preference[2] :  # 交通 -----交通打分
    #     sum_list.append("IFNULL(induzone.electricity_point,0)")

    if preference[4] != "false":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
        sum_list.append("IFNULL(induzone.mall_point,0)")
        sum_list.append("IFNULL(induzone.hotel_point,0)")
        sum_list.append("IFNULL(induzone.school_point,0)")

    # 拼接where请求
    if list_zone:
        list_zone = "where " + list_zone

    # 拼接排序请求
    sum_list = " + ".join(sum_list)
    if sum_list:
        sum_list = " order by " + sum_list + " desc"
    # sql语句
    sql = "select * from induzone " \
          "LEFT OUTER JOIN company_industry_point on induzone.name = company_industry_point.district " \
          + list_zone + sum_list
    try:
        conn = pymysql.connect(host='39.100.39.50',
                               user='root',
                               password='Root@2020',
                               db='indutyty',
                               charset='utf8')

        cursor = conn.cursor()
        # print(sql)
        data_num = cursor.execute(sql)
        data_list = cursor.fetchall()

        # print(sql)
        if data_num > 3:
            data_list = data_list[0:3]

        data = [{"id": i[0],
                 "name": i[1],
                 "charge": i[9] if i[9] else "-",
                 "phone": i[10] if i[10] else "-",
                 "jwd": {"lng": i[13], "lat": i[14]}} for i in data_list]
        # 没有查询结果的查找
        if not data_list:
            data = [{"name": "对不起，没有找到合适的园区！"}]
        cursor.close()
        conn.close()
        return jsonify(code=RET.OK, msg="选址成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 地图的处理
@api_mobile.route("/chooseMap", methods=["POST"])
def choose_map():
    req_dict = request.get_json()
    district = req_dict.get("district")

    try:
        if not district:
            # 获取所有的园区值
            district_list = Induzone.query.filter_by().all()
            data = [{"name": j.name, "jwd": {"lat": j.lat, "lng": j.lng}} for j in district_list]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        district_list = Induzone.query.filter_by(region=district)
        data = [{"name": i.name, "jwd": {"lat": i.lat, "lng": i.lng}} for i in district_list]
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取下拉列表
@api_mobile.route("/chooseDownList", methods=["GET"])
def choose_downlist():
    try:
        industry = Industry.query.filter_by(statu=1).all()
        data = [{
            "name": i.name,
            "id": i.nid,
        } for i in industry]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    return jsonify(code=RET.OK, msg="查找成功", data=data)
