from sqlalchemy import text

from apps.models import CarrierFactory, CarrierBuild, CarrierLand


class Common(object):
    @staticmethod
    def get_total_land_area(time1, time2, district_name, land_nature, upload_time):
        area_obj_list = CarrierLand.query.filter(
            CarrierLand.audit_status == 1,
            CarrierLand.upload_time > time1 if time1 else text(''),
            CarrierLand.upload_time < time2 if time2 else text(''),
            CarrierLand.land_nature == land_nature if land_nature else text(''),
            CarrierLand.district_name == district_name if district_name else text(''),
            CarrierLand.upload_time > upload_time if upload_time else text(''),
        ).all()
        return area_obj_list


    @staticmethod
    def get_total_factory_area(time1, time2, district_name):
        area_obj_list = CarrierFactory.query.filter(
            CarrierFactory.upload_time > time1 if time1 else text(''),
            CarrierFactory.upload_time < time2 if time2 else text(''),
            CarrierFactory.audit_status == 1,
            CarrierFactory.district_name == district_name if district_name else text(''),
        ).all()
        return area_obj_list

    @staticmethod
    def get_empty_factory_area(time1, time2, upload_time, district_name):
        empty_area_obj_list = CarrierFactory.query.filter(
            CarrierFactory.upload_time > time1 if time1 else text(''),
            CarrierFactory.upload_time < time2 if time2 else text(''),
            CarrierFactory.audit_status == 1,
            CarrierFactory.district_name == district_name if district_name else text(''),
            CarrierFactory.upload_time > upload_time if upload_time else text('')
        ).all()
        return empty_area_obj_list

    @staticmethod
    def get_total_build_area(time1, time2, district_name):
        area_obj_list = CarrierBuild.query.filter(
            CarrierBuild.upload_time > time1 if time1 else text(''),
            CarrierBuild.upload_time < time2 if time2 else text(''),
            CarrierBuild.audit_status == 1,
            CarrierBuild.district_name == district_name if district_name else text(''),
        ).all()
        return area_obj_list

    @staticmethod
    def get_empty_build_area(time1, time2, upload_time, district_name):
        empty_area_obj_list = CarrierBuild.query.filter(
            CarrierBuild.upload_time > time1 if time1 else text(''),
            CarrierBuild.upload_time < time2 if time2 else text(''),
            CarrierBuild.audit_status == 1,
            CarrierBuild.district_name == district_name if district_name else text(''),
            CarrierBuild.upload_time > upload_time if upload_time else text('')
        ).all()
        return empty_area_obj_list
