import os
import time
import datetime
import re
import pandas as pd
from flask import jsonify, request, current_app
from sqlalchemy import or_, and_, desc
from apps.models import *
from apps.util import login_required,verify_token
from apps.view_mobile import api_mobile
from apps.utils.response_code import RET
from dateutil.relativedelta import relativedelta

def get_year_month(year,month):
    year = int(year)
    month = int(month)
    if month == 12:
        year += 1
        month = 1
    else:
        year = year
        month += 1
    return year,month

def get_ininvest_id(x):
    x = int(x)
    if x < 0:
        return 0
    if x <= 1:
        return 1
    if x <= 10:
        return 2
    if x <= 50:
        return 3
    if x < 100:
        return 4
    return 5


# 招商资源管理
# 新增项目详情页的下拉列表
@api_mobile.route("/mobileInList", methods=["GET"])
# @login_required
def mobile_in_list():

    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code = RET.ROLEERR,msg = "无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    try:
        attract = Attract.query.filter_by(statu=1)
        industry_list = attract.filter_by(sid=1).all()  # 行业表
        stage_list = attract.filter_by(sid=2).all()  # 项目阶段表
        invest = [{"name":"请选择","id":""},{"name":"1亿元以下","id":1},{"name":"1-10亿元","id":2},
                       {"name":"10-50亿元","id":3},{"name":"50-100亿元","id":4},
                       {"name":"100亿元以上","id":5}]
        unit = user.unit  # 操作人的机构
        government = Government.query.filter_by(name = unit).first()
        section_list = government.sections
        industry = [{"name": i.name, "industry_id": i.nid} for i in industry_list]
        industry = [{"name":"请选择","industry_id":""}] + industry
        stage = [{"name": i.name, "stage_id": i.nid} for i in stage_list]
        stage = [{"name":"请选择","stage_id":""}]+stage
        section = [{"name": i.name, "section_id": i.id} for i in section_list]
        section = [{"name":"请选择","section_id":""}] + section
        data = {
            "industry": industry,
            "stage": stage,
             "invest":invest,
             "section":section
        }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

# 招商资源管理页面的详情页
@api_mobile.route("/mobileInItem", methods=["POST"])
# @login_required
def mobile_in_item():

    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        unit = user.unit  # 用户所在的部门
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    page = req_dic.get("page")  # 页数
    perpage = req_dic.get("perpage")  # 每页个数
    stage_id = req_dic.get("stage_id")  # 项目进展
    indu_id = req_dic.get("indu_id")  # 行业
    invest_id = req_dic.get("invest_id")  # 投资
    section = req_dic.get("section")  # 部门
    search = req_dic.get("search")  # 搜索栏搜索的值
    #order = req_dic.get("order")  # 按照投资额的顺序  #1为顺序，2为倒序
    if search:
        try:
            user = User.query.get(user_id)
            b = []
            print(user.searchitem)
            if user.searchitem:
                for j in user.searchitem:
                    b.append(j.history)
                if search in b:
                    user.searchitem.remove(user.searchitem[b.index(search)])
                if len(b) > 5:
                    user.searchitem.remove(user.searchitem[0])
            sear = SearchItem(history=search)
            db.session.add(sear)
            user.searchitem.append(sear)
            db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg='数据库错误')
        # 获取当前账号的权限制
    try:
        item = Item.query.filter_by()
        if role[0]  == "1":
            item = item.filter_by(unit=unit)

        # 权限查找
        if role[0] == "2":  # 部级
            item = item.filter_by(section=user.section)

        if role[0] == "3":  # 个人
            item = item.filter(or_(Item.share.like("%--" + str(user_id) + "--%"), Item.user_id == user_id))

        if not page:
            page = 1

        if not perpage:
            perpage = 10

        if stage_id:
            item = item.filter_by(stage_id=stage_id)

        if indu_id:
            item = item.filter_by(indu_id=indu_id)

        if invest_id:
            item = item.filter_by(invest_id=invest_id)

        if section:
            if section != "请选择":
                item = item.filter_by(section=section)

        if search:
            item = item.filter(or_(Item.company_name.like("%" + search + "%")
                                   , Item.name.like("%" + search + "%")))

        # if order == 2:
        #     item = item.order_by(desc("invest"))
        # else:
        #     item = item.order_by("invest")
        item = item.order_by(desc("id"))

        maxnum = len(item.all())
        item = item.paginate(page, perpage).items

        data_list = []
        #status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
        for i in item:
            # status = i.status
            # if not i.status:
            #     status = 0
            data_list.append(
                {
                    "id": i.id,
                    "company_name": i.company_name,
                    "name": i.name,
                    #"product": i.product,
                    #"industry": i.industry,
                    #"invest": i.invest,
                    #"section": i.section,
                    "stage": i.stage,
                    "unit":i.unit,
                    "link": i.link,
                    #"status": status_list[int(status)]
                }
            )
        data = {"data_list": data_list, "maxnum": maxnum}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商资源管理
# 新增项目详情页的下拉列表
@api_mobile.route("/mobileUpList", methods=["GET"])
# @login_required
def mobile_up_list():

    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    try:
        attract = Attract.query.filter_by(statu=1)
        industry_list = attract.filter_by(sid=1).all()
        stage_list = attract.filter_by(sid=2).all()  # 项目阶段
        unit = Government.query.filter_by().all()
        industry = [{"name": i.name, "indu_id": i.nid} for i in industry_list]  # 项目行业
        industry = [{"name": "请选择", "indu_id": ""}] + industry
        stage = [{"name": i.name, "stage_id": i.nid} for i in stage_list]  # 项目阶段
        stage = [{"name": "请选择", "stage_id": ""}] + stage
        unit = [{"name": i.name, "unit_id": i.id} for i in unit]  # 报送单位
        unit = [{"name": "请选择", "unit_id": ""}] + unit
        invest = [{"invest": "请选择", "invest_id": ""}, {"invest": "1亿元以下", "invest_id": 1},
                  {"invest": "1-10亿", "invest_id": 2},
                  {"invest": "10-50亿", "invest_id": 3}, {"invest": "50-100亿", "invest_id": 4},
                  {"invest": "100亿以上", "invest_id": 5}]  # 投资额
        data = {
            "industry": industry,
            "stage": stage,
            "unit": unit,
            "invest": invest
        }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


@api_mobile.route("/mobileUpItem", methods=["POST"])
@login_required
def mobile_up_item():

    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    #user_id = 3
    req_dic = request.get_json()

    indu_id = req_dic.get("indu_id")  # 行业，
    invest_id = req_dic.get("invest_id")  # 投资额ID
    evolve_id = req_dic.get("stage_id")  # 项目进度
    unit_name = req_dic.get("unit")  # 报送单位
    way_id = req_dic.get("way_id")  # 查看方式
    search = req_dic.get("search")  # 搜索框
    order = str(req_dic.get("order"))  # 顺序 1-正序，2-倒序
    page = req_dic.get("page")  # 页数
    perpage = req_dic.get("perpage")  # 每页个数
    if search:
        try:
            user = User.query.get(user_id)
            b = []
            if user.searchitem:
                for j in user.searchitem:
                    b.append(j.history)
                if search in b:
                    user.searchitem.remove(user.searchitem[b.index(search)])
                if len(b) > 5:
                    user.searchitem.remove(user.searchitem[0])
            sear = SearchItem(history=search)
            db.session.add(sear)
            user.searchitem.append(sear)
            db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg='数据库错误')

    try:
        item = Item.query.filter_by(unit_up=unit)

        if not page:
            page = 1

        if not perpage:
            perpage = 10

        if indu_id:
            item = item.filter_by(indu_id=indu_id)

        if invest_id:
            item = item.filter_by(invest_id=invest_id)

        if evolve_id:
            item = item.filter_by(stage_id=evolve_id)

        if unit_name:
            if unit_name != "请选择":
                item = item.filter_by(unit=unit_name)

            # 进行中项目
        if way_id == 1:
            # 数据可能需要改
            item = item.filter(and_(Item.stage_id != 5, Item.stage_id != 10))
            # 投促局调度的项目
        if way_id == 2:
            item = item.filter_by(belong=1)
        # 搜索，模糊查询
        if search:
            item = item.filter(or_(Item.company_name.like('%' + search + "%"), Item.name.like('%' + search + "%")))
        # 排序
        item = item.order_by(desc(Item.id))
        if order:
            if order == "2":
                item = item.order_by(desc(Item.invest))
            else:
                item = item.order_by(Item.invest)
                
        maxnum = len(item.all())
        item = item.paginate(page, perpage).items
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code = RET.DBERR,msg = "数据库错误")
    # for j in government_list:
    #     new_item = item.filter_by(unit_up = j.name).order_by(desc(Item.id)).all()
    #status_list = ["", "未上报", "已上报", "已驳回", "已通过"]
    data_list = []
    for i in item:
        # status = i.status
        # if not i.status:
        #     status = 0
        data_list.append({
            "item_id":i.id,
            "name": i.name,
            "company": i.company_name,
            #"product": i.product,
            #"industry": i.industry,
            #"invest": i.invest,
            "stage": i.stage,
            "unit": i.unit,
            "link": i.link,
            #"status":status_list[int(status)]
        })
    data = {"data_list": data_list, "maxnum": maxnum}
    return jsonify(code=RET.OK, msg="查找成功", data=data)


@api_mobile.route("/mobiledetailsItem", methods=["POST"])
@login_required
def mobile_details_item():

    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 3
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    req_dic = request.get_json()
    item_id = req_dic.get("item_id")

    if not item_id:
        return jsonify(code=RET.DATAERR, msg="缺少必要的参数")

    try:
        item = Item.query.get(item_id)
        if not item:
            return jsonify(code=RET.DATAERR, msg="不存在这样的项目")

        data = {
            "build_date": item.build_date.strftime('%Y-%m-%d'),
            "company_name": item.company_name,
            "admin": item.admin,
            "mobile": item.mobile,
            "email": item.email,
            "name": item.name,
            "store": item.store.strftime('%Y-%m-%d'),
            "product": item.product,
            "industry": item.industry,
            "invest": item.invest,
            "area": item.area,
            "value": item.value,
            "tax": item.tax,
            "unit":item.unit,
            "link": item.link,
            "link_mobile": item.link_mobile,
            "email": item.email,
            # "level": item.level,
            # "stage": item.stage,
            "main_introduce": item.main_introduce if item.main_introduce else "-",
            "invest_introduce": item.invest_introduce if item.invest_introduce else "-",
            "build_introduce": item.build_introduce if item.build_introduce else "-",
            "encomy": item.encomy if item.encomy else "-",
            "policy": item.policy if item.policy else "-",
            "question": item.question if item.question else "-",
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

#搜索历史接口
@api_mobile.route("/mobileSearchItem",methods = ["GET"])
@login_required
def mobile_search_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        data = {
        "search":[i.history for i in user.searchitem]
    }
        data["search"] = data["search"][::-1]
        return jsonify(code = RET.OK,msg = "查询成功",data = data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

#搜索历史接口
@api_mobile.route("/deleteSearchItem",methods = ["GET"])
@login_required
def delete_search_item():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user = User.query.get(user_id)
        for i in user.searchitem:
            user.searchitem.remove(i)
        db.session.commit()
        return jsonify(code = RET.OK,msg = "删除成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

# 获取机构的部门和人员
@api_mobile.route("/getSectionPeople", methods=["GET"])
# @login_required
def get_section_people():

    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        unit = user.unit
        government = Government.query.filter_by(name = unit).first()
        data = []

        for i in government.sections:

            person = [{"name":"请选择","id":""}]
            section = User.query.filter(and_(User.unit == government.name,
                                             User.section == i.name,User.id != user_id)).all()

            for j in section:
                person.append({"name": j.name, "id": j.id})
            data.append({"person":  person, "name": i.name, "section_id": i.id})
        data = [{"section_id":"","name":"请选择","person":[{"name":"请选择","id":""}]}] + data
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


#机构统筹的机构
@api_mobile.route("/UnitUnit",methods = ["GET"])
# @login_required
def unit_unit():
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        unit_name = user.unit
        unit = Government.query.filter_by(name = unit_name).first()
        data = [{"name":i.name,"unit_id":i.id}for i in unit.followed]
        data = [{"name":"请选择","unit_id":""}] + data
        return jsonify(code = RET.OK,msg = "查找成功",data = data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code = RET.DBERR,msg = "数据库错误")

# 招商进度管理统计图查看（机构内部）
@api_mobile.route("/stageInTable", methods=["POST"])
# @login_required
def stage_in_table():

    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    user_id = 3
    try:
        user = User.query.get(user_id)
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
        unit = user.unit
        _section = user.section
        role = user.role.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code = RET.DBERR,msg = "数据库错误")

    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")
    section = req_dic.get("section")
    user_id = req_dic.get("user_id")

    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])

    date_begin = time.strptime("{}-{}-01".format(year_begin,month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end,month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
    try:
        if role[0]  == "1":
            item = Item.query.filter(and_(Item.unit == unit, Item.store >= date_begin, Item.store < date_end))
        if role[0] == "2":
            item = Item.query.filter(and_(Item.unit == unit,Item.section == _section, Item.store >= date_begin, Item.store < date_end))
        if role[0]  == "3":
            item = Item.query.filter(and_(Item.user_id == user_id, Item.store >= date_begin, Item.store < date_end))
        item_user = User.query.filter_by(unit = unit)
        item_evolve = Attract.query.filter_by(statu = 1,sid = 2)
        item_industry = Attract.query.filter_by(statu = 1,sid = 1)
        if stage_id:
            item = item.filter_by(stage_id=stage_id)
            item_evolve = Attract.query.filter_by(nid = stage_id)
        if indu_id:
            item = item.filter_by(industry=indu_id)
            item_industry = item_industry.filter_by(nid = indu_id)
        if section:
            if section != "请选择":
                item = item.filter_by(section=section)
                item_user = item_user.filter_by(section = section)
        if user_id:
            item = item.filter_by(user_id=user_id)
            item_user = item_user.filter_by(section=section,id = user_id)
        item_evolve = set(item_evolve.with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        item_evolve.sort()
        stage = [{
           "name": Attract.query.filter_by(nid=i[0],sid = 2).first().name,"value" :item.filter_by(stage_id=i[0]).count()
        } for i in item_evolve]

        item_user = set(item_user.with_entities(User.id).all())
        user = [{
            "name":User.query.get(i[0]).real_name,"value":item.filter_by(user_id=i[0]).count(),
        } for i in item_user]

        item_industry = set(item_industry.with_entities(Attract.nid).all())
        industry = [{
           "name" :Attract.query.filter_by(nid=i[0], sid=1).first().name,"value": item.filter_by(indu_id=i[0]).count()
        } for i in item_industry]
        data = {
            "stage": stage,
            "user": user,
            "industry": industry
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商进度管理统计图查看（机构统筹机构）
@api_mobile.route("/stageOutTable", methods=["POST"])
@login_required
def stage_out_table():

    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    try:
        user = User.query.get(user_id)
        unit = user.unit
        role = user.flag
        if role != 2:
            return jsonify(code=RET.ROLEERR, msg="无权限查看此内容")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dic = request.get_json()
    year_begin = req_dic.get("year_begin")
    month_begin = req_dic.get("month_begin")
    year_end = req_dic.get("year_end")
    month_end = req_dic.get("month_end")
    unit_name = req_dic.get("unit_name")
    stage_id = req_dic.get("stage_id")
    indu_id = req_dic.get("indu_id")


    if not all([year_begin, month_begin, year_end, month_end]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    year_begin = year_begin[:-1]
    month_begin = month_begin[:-1]
    (year_end, month_end) = get_year_month(year_end[:-1], month_end[:-1])

    date_begin = time.strptime("{}-{}-01".format(year_begin, month_begin), '%Y-%m-%d')
    date_end = time.strptime("{}-{}-01".format(year_end, month_end), '%Y-%m-%d')  # - relativedelta(months=-1)
    try:
        item = Item.query.filter(and_(Item.store >= date_begin, Item.store < date_end,Item.unit_up == unit))
        government = Government.query.filter_by(name=unit).first()
        foller_name = [i.name for i in government.followed]
        item = item.filter(Item.unit.in_(foller_name))
        item_user = item.filter(Item.unit.in_(foller_name))
        item_evolve = Attract.query.filter_by(statu=1, sid=2)
        item_industry = Attract.query.filter_by(statu=1, sid=1)

        if stage_id:
            item = item.filter_by(stage_id=stage_id)
            item_evolve = Attract.query.filter_by(nid=stage_id)

        if indu_id:
            item = item.filter_by(industry=indu_id)
            item_industry = item_industry.filter_by(nid=indu_id)

        if unit_name:
            if unit_name != "请选择":
                item = item.filter_by(unit=unit_name)
                item_user = item_user.filter_by(unit=unit_name)

        item_evolve = set(item_evolve.filter_by(statu = 1,sid = 2).with_entities(Attract.nid).all())
        item_evolve = list(item_evolve)
        item_evolve.sort()

        stage = [{
            "name":Attract.query.filter_by(nid=i[0],sid = 2).first().name,"value":item.filter_by(stage_id=i[0]).count()
        } for i in item_evolve]

        item_user = set(item_user.with_entities(Item.unit).all())
        unit = [{
            "name":i[0],"value": item.filter_by(unit=i[0]).count()
        } for i in item_user]

        item_industry =  set(item_industry.with_entities(Attract.nid).all())
        industry = [{
            "name":Attract.query.filter_by(nid=i[0], sid=1).first().name,"value": item.filter_by(indu_id=i[0]).count()
        } for i in item_industry]
        data = {
            "stage": stage,
            "unit": unit,
            "industry": industry
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

