import os
import json
from elasticsearch import Elasticsearch
from flask import request, jsonify, current_app
from apps.models import *
from apps.view_360 import api_portraits
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps import redis_store


def body_qualificat(s, j):
    body = {
        "query": {
            "bool": {
                "must": {"match": {"{}": "{}".format(s, j)}}
            }
        }
    }
    return body


def body_type(s):
    body = {
        "query": {
            "bool": {
                "must": {"match": {"entypeid": "{}".format(s)}}
            }
        }
    }
    return body


def create_body(page, page_size, args_query, args_term):
    body = {
        "query": {
            "bool": {
                "filter": {
                    "range": {
                        "build_date": {
                        }
                    }
                },
                "must": [
                    {"multi_match": {
                        "query": "{}".format(args_query["query"]),
                        "type": "best_fields",
                        "fields": [
                            "product^1.0",
                            "company_name^1.0",
                            "industry^1.0"
                        ],
                        "tie_breaker": 0.3
                    }
                    },
                ]
            }
        },
        "from": page,
        "size": page_size,
        "sort": [],
        "aggs": {},
        "_source": [
            # 'all_info',
            'industry', 'build_date', 'register_money_nums', 'product',
            'company_name', "mysql_id"
        ],
        "highlight": {
            "fields": {
                "product": {"type": "plain"},
                "company_name": {"type": "plain"},
                "industry": {"type": "plain"}
            }
        }
    }

    for k, v in args_term.items():
        body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})

    return body


# 360企业画像两个静态表（如果前端页面进行删除，此接口也一并删除）
@api_portraits.route("/table", methods=["GET"])
def table():
    try:
        name_query = "static_360"
        if redis_store.get(name_query) is not None:
            data = json.loads(redis_store.get(name_query))
            return jsonify(code=RET.OK, msg="获取成功", data=data)

        company = Enterprise.query.filter_by()
        grdz = company.filter_by(entypeid=1).count()
        gfyx = company.filter_by(entypeid=2).count()
        hhqy = company.filter_by(entypeid=3).count()
        jtsy = company.filter_by(entypeid=4).count()
        gyqy = company.filter_by(entypeid=5).count()
        yxzr = company.filter_by(entypeid=6).count()
        wstz = company.filter_by(entypeid=7).count()
        new_dic = [grdz, yxzr, gfyx, jtsy, hhqy, gyqy, wstz]

        gxjs = company.filter_by(high_new="1").count()
        kjzx = company.filter_by(tbe="1").count()
        ssqy = company.filter_by(quoted_company="1").count()
        djs = company.filter_by(unicorn="1").count()
        dlqy = company.filter_by(dengl="1").count()
        quality_list = [gxjs, kjzx, ssqy, djs, dlqy]

        data = {
            "type": new_dic,
            "quality": quality_list
        }
        # redis缓存
        redis_store.set(name_query, json.dumps(data))
        redis_store.expire(name_query, 30 * 24 * 3600)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.OK, msg="数据库错误")
    return jsonify(code=RET.OK, msg="查询成功", data=data)


# 360企业画像两个静态表(参数数据)(如果前端页面进行删除，此接口也一并删除)
@api_portraits.route("/doubleTable", methods=["POST"])
def double_table():
    # 获取参数
    req_dict = request.get_json()
    area = req_dict.get("area")  # 省市区参数
    province = ""
    city = ""
    district = ""

    if area[0]:
        province = area[0]
    if area[1]:
        city = area[1]
    if area[2]:
        district = area[2]

    if not all([area]):
        return jsonify(code=RET.NODATA, msg="参数缺失")

    try:
        name_query = "static_360" + province + city + district
        if redis_store.get(name_query) is not None:
            data = json.loads(redis_store.get(name_query))
            return jsonify(code=RET.OK, msg="获取成功", data=data)

        company = Enterprise.query.filter_by()
        if province:
            company = company.filter_by(province=province)
            if city:
                company = company.filter_by(city=city)
                if district:
                    company = company.filter_by(district=district)

        grdz = company.filter_by(entypeid=1).count()
        gfyx = company.filter_by(entypeid=2).count()
        hhqy = company.filter_by(entypeid=3).count()
        jtsy = company.filter_by(entypeid=4).count()
        gyqy = company.filter_by(entypeid=5).count()
        yxzr = company.filter_by(entypeid=6).count()
        wstz = company.filter_by(entypeid=7).count()
        new_dic = [grdz, yxzr, gfyx, jtsy, hhqy, gyqy, wstz]

        gxjs = company.filter_by(high_new="1").count()
        kjzx = company.filter_by(tbe="1").count()
        ssqy = company.filter_by(quoted_company="1").count()
        djs = company.filter_by(unicorn="1").count()
        dlqy = company.filter_by(dengl="1").count()
        quality_list = [gxjs, kjzx, ssqy, djs, dlqy]

        data = {
            "type": new_dic,
            "quality": quality_list
        }
        # redis缓存
        redis_store.set(name_query, json.dumps(data))
        redis_store.expire(name_query, 29 * 24 * 3600)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.OK, msg="数据库错误")
    return jsonify(code=RET.OK, msg="查询成功", data=data)


def openDists():
    upload_path = os.path.dirname(os.path.dirname(__file__)) + "/utils/json/city.json"
    with open(upload_path, encoding="utf-8") as f:
        data = json.load(f)

    return data


# 地域层级数据分级获取
@api_portraits.route('/getRegion', methods=['GET'])
def getRegion():
    try:
        data = openDists()
        if len(data) > 0:
            return jsonify(code=200, msg="查找成功", data=data)
        else:
            return jsonify(code=201, msg="暂时没有数据")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查找错误")


@api_portraits.route('/field', methods=['GET'])
# @login_required
def field():
    '''
    全国企业条件选择导航获取
    :return:
    '''
    try:
        property = Property.query.filter_by(statu=1)
        typy = property.filter_by(sid=1, statu=1).all()
        qualificat = property.filter_by(sid=2, statu=1).all()
        quoted = property.filter_by(sid=3, statu=1).all()
        financ = property.filter_by(sid=4, statu=1).all()
        # options: [{ value: "选项1", label: "无数据" },{ value: "选项2", label: "3333" }],
        data = {"entype": [{"label": i.name, "value": i.nid} for i in typy],
                "qualificat": [{"label": i.name, "value": i.nid} for i in qualificat],
                "quoted": [{"label": i.name, "value": i.nid} for i in quoted],
                "financ": [{"label": i.name, "value": i.nid} for i in financ],
                "buildate": [{"label": "1-3年", "value": 1}, {"label": "3-5年", "value": 2},
                             {"label": "5-8年", "value": 3}, {"label": "8-10年", "value": 4},
                             {"label": "10-15年", "value": 5}, {"label": "15年以上", "value": 6}],
                "capital": [{"label": "100万以内", "value": 1}, {"label": "100万-500万", "value": 2},
                            {"label": "500万-1000万", "value": 3}, {"label": "1000万-5000万", "value": 4},
                            {"label": "1000万-1亿", "value": 5}, {"label": "1亿以上", "value": 6}]
                }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", options=data)


# 搜索接口
@api_portraits.route("/search", methods=["POST"])
@login_required
def search():
    # 获取用户信息
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 5
    # 参数获取
    req_dict = request.get_json()
    company = req_dict.get("company")  # 搜索企业名称
    entypeid = req_dict.get("entypeid")  # 企业类型
    qualificat = req_dict.get("qualificat")  # 资质
    capital_id = req_dict.get("capital_id")  # 资本
    public_id = req_dict.get("public_id")  # 上市状态
    area = req_dict.get("area")  # 地区条件获取
    if area == []:
        area = ["", "", ""]
    province = area[0]
    city = area[1]
    district = area[2]

    yearid = req_dict.get("yearid")  # 成立时间
    financ_id = req_dict.get("financ_id")  # 融资轮次

    page = req_dict.get("page")  # 页码
    per_page = int(req_dict.get("per_page"))  # 每页大小

    # 页数
    if not page:
        page = 1
    page = int(page)
    page = (page - 1) * per_page

    args_query = dict()  # 查询字段
    args_term = dict()  # 条件字典

    args_query["query"] = "公司"
    # 搜索框
    if company:
        args_query["query"] = company
        # 添加搜索历史
        try:
            user = User.query.get(user_id)
            b = []
            if user.searchlist:
                for j in user.searchlist:
                    b.append(j.history)
                if company in b:
                    user.searchlist.remove(user.searchlist[b.index(company)])
                if len(b) > 5:
                    user.searchlist.remove(user.searchlist[0])
            search = SearchList(history=company)
            db.session.add(search)
            user.searchlist.append(search)
            db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")

    # 公司类型
    if entypeid:
        args_term['entypeid'] = entypeid
    # 注册资本
    if capital_id:
        args_term['capital_id'] = capital_id
    # 上市状态
    if public_id:
        args_term['public_id'] = public_id
    # 省
    if province:
        args_term['province'] = province
    # 市
    if city:
        args_term['city'] = city
    # 区
    if district:
        args_term['district'] = district
    # 公司资质
    if qualificat:
        if qualificat == 1:
            args_term['high_new'] = 1
        if qualificat == 2:
            args_term['tbe'] = 1
        if qualificat == 3:
            args_term['quoted_company'] = 1
        if qualificat == 4:
            args_term['isfive'] = 1
        if qualificat == 5:
            args_term['unicorn'] = 1
        if qualificat == 6:
            args_term['dengl'] = 1
    # 成立时间
    if yearid:
        args_term['yearid'] = yearid
    # 融资轮次
    if financ_id:
        args_term['financ_id'] = financ_id
    body = create_body(page, per_page, args_query, args_term)
    if not company:
        del body["query"]["bool"]["must"][0]

    try:
        es = Elasticsearch([{'host': 'localhost', 'port': 9200}])

        # data = es.search(index="ty_360", body=body)
        data = es.search(index="ty_enterprise", body=body)
        data_list = []

        # 数据的列表添加进去
        for i in data["hits"]['hits']:

            if company:
                # 判断高亮，然后添加
                data_list.append({
                    "company": i["highlight"]["company_name"][0] if "company_name" in i["highlight"] else i["_source"][
                        "company_name"],
                    "product": i["highlight"]["product"][0] if "product" in i["highlight"] else i["_source"]["product"],
                    "industry": i["highlight"]["industry"][0] if "industry" in i["highlight"] else i["_source"][
                        "industry"],
                    "money": "{}万元".format(i["_source"]["register_money_nums"]),
                    "createtime": i["_source"]["build_date"],
                    "id": i["_source"]["mysql_id"],
                    "choice": 2
                })
            else:
                data_list.append({
                    "company": i["_source"]["company_name"],
                    "product": i["_source"]["product"],
                    "industry": i["_source"]["industry"],
                    "money": "{}万元".format(i["_source"]["register_money_nums"]),
                    "createtime": i["_source"]["build_date"],
                    "id": i["_source"]["mysql_id"],
                    "choice": 2,
                })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="es数据库错误")
    data = {
        "data": data_list
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 搜索历史接口
@api_portraits.route("/searchList", methods=["GET"])
@login_required
def search_list():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    # user_id = 119

    try:
        user = User.query.get(user_id)
        history = [(i.history, i.id) for i in user.searchlist]
        # print(history)
        # print(sorted(history, key=lambda x: x[1], reverse=True))
        # data = {
        #     "search": [i.history for i in user.searchlist]
        # }
        data = {"search": [i[0] for i in sorted(history, key=lambda x: x[1], reverse=True)]}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 全国企业信息详情
@api_portraits.route('/detail', methods=['POST'])
@login_required
def enter_detail():
    '''
    企业信息详情
    :return:
    '''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Enterprise.query.get(_id)
        user = User.query.get(user_id)  # 获取关注列表
        if user:
            enters_ids = [coms.id for coms in user.enterprise]
        else:
            enters_ids = []
        if company:
            data = {"id": company.id,
                    "company_name": company.company_name,
                    "telephone": company.telephone if company.telephone else "-",
                    "web_site": company.web_site if company.web_site else "-",
                    "email": company.email if company.email else "-",
                    "address": company.address if company.address else "-",
                    "jwd": {"lng": company.lng if company.lng else "-",
                            "lat": company.lat if company.lat else "-"},
                    "company_info": company.company_info if company.company_info else "-",

                    "isfive": "500强企业" if company.isfive == "1" else "",  # 500强
                    "quoted_company": "上市企业" if company.quoted_company == "1" else "",  # 上市企业
                    "high_new": "高新技术企业" if company.high_new == "1" else "",
                    "tbe": "科技型中小企业" if company.tbe == "1" else "",  # 科技型中小企业
                    "unicorn": "独角兽企业" if company.unicorn == "1" else "",  # 独角兽企业
                    "dengl": "瞪羚企业" if company.dengl == "1" else "",  # 瞪羚企业

                    "legal": company.legal if company.legal else "-",
                    "status": company.status if company.status else "-",
                    "build_date": str(company.build_date)[:10] if company.build_date else "-",
                    "capital": company.capital if company.capital else "-",
                    "social_code": company.social_code if company.social_code else "-",
                    "taking": company.takingn if company.takingn else "-",
                    "bao": company.bao_num if company.bao_num else "-",
                    "entype": company.entype if company.entype else "-",
                    "industry": company.company_industry if company.company_industry else "-",
                    "scope": company.business_scope if company.business_scope else "-",
                    "collect": "1" if company.id in enters_ids else "2",  # 关注状态码1关注，2未关注
                    "choice": "2"  # 1太原企业，2全国企业
                    }
        else:
            return jsonify(code=RET.NODATA, msg="查无数据")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)
