import re
from flask import request, jsonify, current_app
from sqlalchemy import func, desc, or_, and_
from apps.manage import api_power
from apps.models import *
from apps.utils.response_code import RET
from apps.util import login_required


# 外部访客列表
@api_power.route("/userListOfExternal", methods=["POST"])
@login_required
def user_list_external():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    key = req_dict.get("key")  # 查询条件

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.filter_by(flag=1)
        if key:
            user = user.filter(User.name.like("%{}%".format(key)))
        result = user.paginate(page, perpage).items
        size = user.count()
        df = [{"id": i.id,
               "real_name": i.real_name if i.real_name else "-",
               "name": i.name if i.name else "-",
               "mobile": i.mobile if i.mobile else "-",
               "age": i.age if i.age else "-",
               "sex": "男" if i.sex == 1 else "女" if i.sex == 2 else "-",
               "create_time": str(i.create_time) if i.create_time else "-",
               "email": i.email if i.email else "-",
               "status": i.status} for i in result]  # 1启用,2禁止
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 外部访客状态修改
@api_power.route("/updateStatus", methods=["POST"])
@login_required
def update_status():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    status = req_dict.get("status")  # 1通过 2禁用

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(_id)
        if status == 1:
            user.status = 3
        else:
            user.status = 1
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        # 操作失败，操作返回
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 局内用户筛选条件
@api_power.route("/manage/fields", methods=["GET"])
def manage_field():
    ''''''
    try:
        gover = Government.query.all()
        data = {"status": [{"label": "通过", "value": 1}, {"label": "在审", "value": 2}, {"label": "驳回", "value": 3}],
                "goverment": [{"label": i.name, "value": i.id} for i in gover]}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 局内用户筛选条件2, 根据机构获取部门
@api_power.route("/manage/fieldt", methods=["POST"])
def manage_fielt():
    ''''''
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 机构id
    try:
        gover = Government.query.get(_id)
        section = gover.sections
        data = [{"label": i.name, "value": i.id} for i in section]

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 局内用户列表
@api_power.route("/userListOfInside", methods=["POST"])
# @login_required
def user_list_inside():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    key = req_dict.get("key")  # 查询条件
    status = req_dict.get("status")  # 1通过，2在审，3驳回
    unit = req_dict.get("unit")  # 所在机构id
    section = req_dict.get("section")  # 所在部门id

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.filter_by(flag=2)
        if key:
            # user = user.filter(User.real_name.like("%{}%".format(key)))
            user = user.filter(or_(User.real_name.like("%{}%".format(key)), User.name.like("%{}%".format(key))))
        if status:
            user = user.filter_by(status=status)
        if unit:
            unit_name = Government.query.get(unit).name
            user = user.filter_by(unit=unit_name)
        if section:
            sec_name = Section.query.get(section).name
            user = user.filter_by(section=sec_name)

        size = user.count()
        result = user.paginate(page, perpage).items
        df = [{"id": i.id,
               "real_name": i.real_name if i.real_name else "-",
               "position": i.position if i.position else "-",
               "level": i.level if i.level else "-",
               "unit": i.unit if i.unit else "-",
               "section": i.section if i.section else "-",
               "leader": i.leader if i.leader else "-",
               "mobile": i.mobile if i.mobile else "-",
               "age": i.age if i.age else "-",
               "sex": "男" if i.sex == 1 else "女" if i.sex == 2 else "-",
               "email": i.email if i.email else "-",
               "name": i.name if i.name else "-",
               "create_time": str(i.create_time) if i.create_time else "-",
               "status": "通过" if i.status == 1 else "在审" if i.status == 2 else "驳回"} for i in result]
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 局内用户信息
@api_power.route("/userInsideInfo", methods=["POST"])
@login_required
def user_inside_info():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        i = User.query.get(_id)

        data = {"id": i.id,
                "real_name": i.real_name if i.real_name else "-",
                "position": i.position if i.position else "-",
                "level": "",  # 角色
                "unit": "",  # 机构
                "section": "",  # 部门
                "leader": i.leader if i.leader else "-",
                "mobile": i.mobile if i.mobile else "-",
                "age": i.age if i.age else "-",
                "sex": "男" if i.sex == 1 else "女" if i.sex == 2 else "-",
                "email": i.email if i.email else "",
                "name": i.name if i.name else "-",
                "create_time": str(i.create_time) if i.create_time else "-",
                "status": "通过" if i.status == 1 else "在审" if i.status == 2 else "驳回"}

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 局内用户编辑
@api_power.route("/updateUser", methods=["POST"])
@login_required
def update_user():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当亲用户id
    real_name = req_dict.get("real_name")  # 真名
    position = req_dict.get("position")  # 职务
    level = req_dict.get("level")  # 角色id 必选
    unit = req_dict.get("unit")  # 机构
    section = req_dict.get("section")  # 部门
    leader = req_dict.get("leader")  # 领导
    mobile = req_dict.get("mobile")
    sex = req_dict.get("sex")  # 1男2女
    age = req_dict.get("age")
    email = req_dict.get("email")
    name = req_dict.get("name")
    password = req_dict.get("name")

    # 用户名唯一(字母开头，长度4-15)
    try:
        patten = "^[a-zA-Z][\w]*[\w]*$"
        if re.match(patten, name) and re.match(patten, name).string == name:
            user = User.query.filter_by(name=name).filter(User.id != _id).first()
            if user:
                return jsonify(code=RET.DATAEXIST, msg="用户名已存在")
        else:
            return jsonify(code=RET.DATAERR, msg="用户名格式错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户名格式错误")

    # 校验参数完整性
    if not all([_id, real_name, position, level, leader, mobile, sex, age, name]):
        return jsonify(code=RET.PARAMERR, msg="请选择必填项")
    try:
        role = Role.query.get(level)

        user = User.query.get(_id)
        user.real_name = real_name
        user.position = position
        user.level = role.role_name
        if unit:
            user.unit = Government.query.get(unit).name
        if section:
            user.section = Section.query.get(section).name
        user.leader = leader
        user.mobile = mobile
        user.sex = sex
        user.age = age
        if email:
            user.email = email
        user.name = name
        if password:
            user.password = password

        role.users.append(user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 局内用户新增
@api_power.route("/addUser", methods=["POST"])
# @login_required
def add_user():
    req_dict = request.get_json()

    real_name = req_dict.get("real_name")  # 真实姓名
    position = req_dict.get("position")  # 职务
    level = req_dict.get("level")  # 职级 id (角色id)
    unit = req_dict.get("unit")  # 机构id
    section = req_dict.get("section")  # 部门id
    leader = req_dict.get("leader")  # ?
    mobile = req_dict.get("mobile")
    sex = req_dict.get("sex")  # 1男2女
    age = req_dict.get("age")
    email = req_dict.get("email")
    name = req_dict.get("name")
    password = req_dict.get("password")

    # 校验参数完整性
    if not all([real_name, position, unit, mobile, sex, name, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 用户名唯一(字母开头，长度4-15)
    try:
        patten = "^[a-zA-Z][\w]*[\w]*$"
        if re.match(patten, name) and re.match(patten, name).string == name:
            user = User.query.filter_by(name=name).first()
            if user:
                return jsonify(code=RET.DATAEXIST, msg="用户名已存在")
        else:
            return jsonify(code=RET.DATAERR, msg="用户名格式错误,请填入以字母开头的数字和字母组合")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户名格式错误")

    # 判断手机号
    try:
        user = User.query.filter_by(mobile=mobile).first()
        if user:
            return jsonify(code=RET.DATAEXIST, msg="手机号已存在")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="手机号已存在")

    try:
        role = Role.query.get(level)
        govername = Government.query.get(unit)  # 获取机构name
        user = User(real_name=real_name, age=age, sex=sex, mobile=mobile, unit=govername.name, position=position,
                    name=name, flag=2, status=1, level=role.role_name)
        user.password = password
        if section:  # 部门id
            secname = Section.query.get(section).name  # 获取部门名
            user.section = secname
        if leader:  # 领导
            user.leader = leader
        if email:  # 邮箱
            user.email = email
        db.session.add(user)
        role.users.append(user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 编辑状态
@api_power.route("/updateAccount", methods=["POST"])
@login_required
def update_account():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    status = req_dict.get("status")  # 1通过，2在审，3驳回

    # 校验参数完整性
    if not all([_id, status]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(_id)
        if not user.role and status == 1:  # 没有角色，想通过
            return jsonify(code=RET.DATAERR, msg="请先在编辑，为用户添加职级角色")

        user.status = status
        db.session.commit()
        dict_zh = {1: "通过", 2: "在审", 3: "驳回"}
        data = dict_zh[status]
        return jsonify(code=RET.OK, msg="修改成功", info=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 删除用户(批量删除，单个删除)
@api_power.route("/deleteUser", methods=["POST"])
@login_required
def delete_user():
    req_dict = request.get_json()
    ids = req_dict.get("id")  # list[1,2,3]

    # 校验参数完整性
    if not all([ids]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        for i in ids:
            user = User.query.get(i)
            db.session.delete(user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="删除失败")


# 职级（角色）列表获取
@api_power.route("/getRole", methods=["GET"])
@login_required
def get_role():
    try:
        roles = Role.query.all()

        data = [{"value": role.id,
                 "label": role.role_name} for role in roles]
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")
