import re
from flask import request, jsonify, current_app
from apps.manage import api_power
from apps.models import *
from apps.util import login_required, verify_btoken
from apps.utils.response_code import RET


# 新增角色
@api_power.route("/addRole", methods=["POST"])
@login_required
def add_role():
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    role_name = req_dict.get("role_name")  # 职位名称（角色）
    rolev = req_dict.get("rolev")  # 权值 0层级123， 1调度，2审核，3删除，4审核/上报，5新增/编辑 ,300001"
    info = req_dict.get("info")  # 职位功能（角色）

    # 校验参数完整性
    if not all([role_name, rolev, info]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        role = Role.query.filter_by(role_name=role_name).first()
        if role:
            return jsonify(code=RET.DATAEXIST, msg="角色名已存在")
        role = Role.query.filter_by(role=rolev).first()
        if role:
            return jsonify(code=RET.DATAEXIST, msg="权限配置已存在,角色：{}".format(role.role_name))

        role = Role(role_name=role_name, role=rolev, info=info)
        db.session.add(role)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 获取角色列表
@api_power.route("/roles", methods=["GET"])
@login_required
def roles():
    try:
        roles = Role.query.all()
        data = [{"id": role.id,
                 "name": role.role_name,
                 "rolev": role.role,
                 "info": role.info} for role in roles]

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 获取角色信息
@api_power.route("/getRole", methods=["POST"])
@login_required
def roleinfo():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 角色id
    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        role = Role.query.get(_id)
        data = {"id": role.id,
                "name": role.role_name,
                "rolev": role.role,
                "info": role.info}

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 角色编辑
@api_power.route("/updateRole", methods=["POST"])
@login_required
def update_role():
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 角色id
    role_name = req_dict.get("role_name")  # 职位名称（角色）
    rolev = req_dict.get("rolev")  # 权值 1调度，2审核，3删除，4审核/上报，5新增/编辑 "00001"
    info = req_dict.get("info")  # 职位功能（角色）

    # 校验参数完整性
    if not all([_id, role_name, rolev, info]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        me = Role.query.get(_id)
        if me.role_name != role_name:
            role = Role.query.filter_by(role_name=role_name).first()
            if role:
                return jsonify(code=RET.DATAEXIST, msg="角色名已存在")
        if me.role != rolev:
            role = Role.query.filter_by(role=rolev).first()
            if role:
                return jsonify(code=RET.DATAEXIST, msg="权限配置已存在,角色：{}".format(role.role_name))
        me.role_name = role_name
        me.role = rolev
        me.info = info
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 删除角色
@api_power.route("/deleteRole", methods=["POST"])
@login_required
def delete_role():
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 角色id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        me = Role.query.get(_id)
        if len(me.users) != 0:
            return jsonify(code=RET.DATAEXIST, msg="当前角色存在用户使用,请查证并清除后再操作")
        db.session.delete(me)
        db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 新添管理员账号
@api_power.route("/addManager", methods=["POST"])
@login_required
def add_manager():
    token = request.headers["token"]
    user = verify_btoken(token)
    user_role = user.role  # 用户角色
    if user_role != 1:
        return jsonify(code=RET.ROLEERR, msg="暂无权限")
    req_dict = request.get_json()
    account = req_dict.get("account")  # 账户
    password = req_dict.get("password")  # 密码
    role = req_dict.get("role")  # 角色 1超级管理员，2系统运维员

    # 校验参数完整性
    if not all([account, password, role]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 用户名唯一(字母开头，长度4-15)
    try:
        patten = "^[a-zA-Z][\w]*[\w]*$"
        if re.match(patten, account) and re.match(patten, account).string == account:
            user = Bstage.query.filter_by(name=account).first()
            if user:
                return jsonify(code=RET.DATAEXIST, msg="用户名已存在")
        else:
            return jsonify(code=RET.DATAERR, msg="用户名格式错误1")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户名格式错误2")

    try:
        me = Bstage(name=account, role=role)
        me.password = password
        db.session.add(me)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")
