import os
from flask import g, current_app, request, jsonify, session, send_from_directory, make_response
from apps.inves_manage import api_manage
# from apps.utils.commons import login_required
from apps.util import login_required
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.read_json import open_type
from datetime import datetime, timedelta
from sqlalchemy import extract, or_, and_
from sqlalchemy.sql import func
import datetime
import filetype
from apps.utils.forms import *
from werkzeug.datastructures import CombinedMultiDict
from apps.models import *


# 获取筛选条件
@api_manage.route("/attFiled", methods=["GET"])
@login_required
def att_filed():
    user_id = g.user_id

    try:
        user = User.query.get(user_id)
        unit = user.unit  # 用户所在机构
        goverment = Government.query.filter_by(name=unit).first()  # 按名查找机构
        sections = [i.name for i in goverment.sections]  # 机构下部门

        attract = Attract.query.filter_by(statu=1)  # 招商字典
        indu = attract.filter_by(sid=1).all()  # 行业
        stage = attract.filter_by(sid=2).all()  # 阶段（进度）

        data = {"indu": {i.name: i.nid for i in indu},
                "capital": {"1亿以下": 1, "1-10亿": 2, "10-50亿": 3, "50-100亿": 4, "100亿以上": 5},
                "stage": {i.name: i.nid for i in stage},
                "section": sections
                }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


def pic(x):
    if x < 0:
        return False
    if x <= 1:
        return 1
    if x <= 10:
        return 2
    if x <= 50:
        return 3
    if x <= 100:
        return 4
    return 5


# # 项目新增
# @api_manage.route("/addItem", methods=["GET"])
# @login_required
# def add_item():
#     req_dict = request.get_json()
#     company_name = req_dict.get("company_name")  # 企业名称
#     build_date = req_dict.get("build_date")  # 成立时间
#     admin = req_dict.get("admin")  # 企业联系人
#     mobile = req_dict.get("mobile")  # 企业联系人联系方式
#     email = req_dict.get("email")  # 企业联系人邮箱
#
#     name = req_dict.get("name")  # 项目名称
#     product = req_dict.get("product")  # 项目产品
#     industry = req_dict.get("industry")  # 项目行业
#     indu_id = req_dict.get("indu_id")  # 项目行业
#     invest = req_dict.get("invest")  # 投资额
#     # invest_id =
#     area = req_dict.get("area")  # 占地面积
#     value = req_dict.get("value")  # 预计产值
#     tax = req_dict.get("tax")  # 预计税收
#     store = req_dict.get("store")  # 项目入库时间
#     unit_up = req_dict.get("store")  # 项目入库时间
#     link = req_dict.get("link")  # 项目对接人
#     link_mobile = req_dict.get("link_mobile")  # 项目对接人联系方式
#     level = req_dict.get("level")  # 项目级别
#     level_id = req_dict.get("level_id")  # 项目级别id
#     stage = req_dict.get("level")  # 项目进度
#     stage_id = req_dict.get("stage_id")  # 项目进度id
#
#     main_introduce = req_dic.get("main_introduce")  # 项目主体介绍
#     invest_introduce = req_dic.get("invest_introduce")  # 投资项目介绍
#     build_introduce = req_dic.get("build_introduce")  # 项目建设内容
#     encomy = req_dic.get("encomy")  # 项目的经济效益
#     policy = req_dic.get("policy")  # 项目政策需求
#     question = req_dic.get("question")  # 项目存在的问题
#     file = request.files.get("file")  # 文件
