from flask import current_app, request, jsonify
from apps.atlas import api_atlas
from apps.util import login_required
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j,neo4j_dict
from apps import redis_store
import json


graph = conn_neo4j()

'''行业名转换ptp字典两个  neo4j_dict  line 164/177'''
def deleteDuplicate(li):
    '''
    列表[字典]去重
    :param li:
    :return:
    '''
    temp_list = list(set([str(i) for i in li]))
    li = [eval(i) for i in temp_list]
    return li


def find_up_thr(name_query, relation):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    # 零级，上中下三游
    data = {
            "node": "{}".format(relation[:2]),
            "level": 1,
            "subNodeList": [],
            }
    sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res_zero = graph.run(sql_01).data()
    res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
    for it in res_one:  # 一级节点
        pname_one = it
        # 一级
        node_one = {
                    "node": "{}".format(pname_one),
                    "level": 2,
                    "subNodeList": []
                    }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
        result = graph.run(sql_02).data()
        result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
        for item in result:
            pname_two = item
            # 二级
            node_two = {
                        "node": "{}".format(pname_two),
                        "level": 3,
                        "subNodeList": []
                        }
            sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
            result3 = graph.run(sql_03).data()
            result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
            for itm in result3:
                pname_thr = itm
                # 三级
                node_thr = {
                            "node": "{}".format(pname_thr),
                            "level": 4,
                            "subNodeList": []
                            }
                node_two["subNodeList"].append(node_thr)
            node_one["subNodeList"].append(node_two)
        data["subNodeList"].append(node_one)
    return data


# 行业产品公司数量(链图,根据地理位置)
@api_atlas.route('/industry/chain', methods=['POST'])
# @login_required
def industry_chain():
    '''
    行业id->行业链标题-》上中下游-》查询数值
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）
    district = req_dict.get("district")  # 区县

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "jc" + str(inid) + str(district)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        # 行业使用名
        industryName = Industry.query.filter_by(nid=inid).first().oname
        ptp = neo4j_dict()
        if industryName in ptp:
            industryName = ptp[industryName]
        # print(industryName)
        result = {
            "industryChain": industryName,
            "nodeList": [find_up_thr(industryName, "上游行业"),
                         find_up_thr(industryName, "中游行业"),
                         find_up_thr(industryName, "下游行业")]
        }
        # redis缓存
        # redis_store.set(name_query, json.dumps(result))
        # redis_store.expire(name_query, 30 * 24 * 3600)
        # print("redis")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=result)