import json
import requests
from sqlalchemy import or_
from flask import g, current_app, request, jsonify, session
from apps.atlas import api_atlas
from apps.util import login_required
from apps.utils.response_code import RET
from apps.models import *


# 创建body
def create_body(page, page_size, query, args_term, args_cate, args_org):
    '''
    :param page:
    :param page_size:
    :param args_query:
    :param args_date:
    :param args_term:
    :return:
    https://www.cnblogs.com/yjf512/p/4897294.html
    '''
    if query:
        body = {
            "query": {
                "bool": {
                    "must": [{"multi_match": {"query": "{}".format(query),
                                              # "type": "best_fields",
                                              "fields": [
                                                  "name^1000.0",
                                                  "body^1.0",
                                                  # "org^5.0",
                                                  # "navigator^5.0",
                                                  # "navigat^5.0"
                                              ],
                                              "tie_breaker": 0.3
                                              }
                              }
                             ]
                }
            },
            "from": (page - 1) * page_size,
            "size": page_size,
            "sort": {},
            "aggs": {},
            "_source": [
                "name", "org", "pubdate", "policyid"
            ],
            "highlight": {}
        }
    else:
        body = {
            "query": {
                "bool": {
                    "must": [{"match_all": {}
                              }
                             ]
                }
            },
            "from": (page - 1) * page_size,
            "size": page_size,
            "sort": {"pubdate": {"order": "desc"}},
            "aggs": {},
            "_source": [
                "name", "org", "pubdate", "policyid"
            ],
            "highlight": {}
        }
    if args_cate:
        body["query"]["bool"]["must"].append(
            {"multi_match": {"query": "{}".format(args_cate["indu"]),  # match_phrase来实现完全匹配查询（精准模糊查询）。
                             "type": "phrase",
                             "fields": [
                                 "navigator^5.0",
                                 "navigat^5.0"
                             ],
                             "slop": 0,
                             }
             })
    if args_org:
        body["query"]["bool"]["must"].append(
            {"multi_match": {"query": "{}".format(args_org["org"]),  # match_phrase来实现完全匹配查询（精准模糊查询）。
                             "type": "phrase",
                             "fields": [
                                 "org"
                             ],
                             "slop": 0,
                             }
             })
    for k, v in args_term.items():
        body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})
    # print(body)
    return body


# 机构省市区选择（2021-1-7）
@api_atlas.route("/selectArea", methods=['GET'])
def select_area():
    '''机构省市区选择'''
    result = [{"label": "国家", "value": 5}, {"label": "省级", "value": 1}, {"label": "市级", "value": 2},
              {"label": "区县", "value": 3}, {"label": "开发区", "value": 4}]
    return jsonify(code=RET.OK, msg="查询成功", data=result)


# 发布机构（根据省市区获取）（2021-1-7）
@api_atlas.route("/areaCategory", methods=['POST'])
def area_category():
    '''发布机构'''
    req_dict = request.get_json()
    vau = req_dict.get("vau")  # 省1、市2、区县3、开发区4
    # 校验参数完整性
    if not all([vau]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    country = ["国务院"]
    # province = ["山西省政府", "省政府办公厅", "省发展和改革委员会", "省科学技术厅", "省工业和信息化厅", "省人力资源和社会保障厅", "省生态环境厅", "省商务厅", "其他"]
    province = ["山西省委", "山西省政府"]
    # city = ["太原市政府", "市政府办公厅", "市发展改革委", "市科技局", "市工信局", "市人社局", "市生态环境局", "市商务局", "市文旅局", "市外来投资局", "市大数据局", "其他"]
    city = ["太原市委", "太原市政府"]
    district = ["小店区政府", "迎泽区政府", "杏花岭区政府", "尖草坪区政府", "万柏林区政府", "晋源区政府", "古交市政府", "清徐县政府", "阳曲县政府", "娄烦县政府", "其他"]
    dev = ["山西转型综合改革示范区", "中北高新区", "清徐经济开发区", "阳曲现代农业产业示范区", "西山生态文化旅游示范区", "其他"]

    if vau == 5:  # 国家
        result = [{"label": name, "value": country.index(name)} for name in country]
    elif vau == 1:  # 省，默认
        result = [{"label": name, "value": province.index(name)} for name in province]
    elif vau == 2:  # 市
        result = [{"label": name, "value": city.index(name)} for name in city]
    elif vau == 3:  # 区
        result = [{"label": name, "value": district.index(name)} for name in district]
    elif vau == 4:  # 县
        result = [{"label": name, "value": dev.index(name)} for name in dev]
    else:
        return jsonify(code=RET.DATAERR, msg="参数错误")

    return jsonify(code=RET.OK, msg="查询成功", data=result)


'''
url = "http://127.0.0.1:9200/typolicy/_search"
'''


# 太原产业政策列表(转es)（小程序调用，不可删除）
@api_atlas.route('/industry/policy', methods=['POST'])
# @login_required
def indupolicy():
    '''
    太原产业政策列表(第一版用mysql,全文搜索，准备改用用es)
    根据条件多字段搜索
    :return:model-InduPolicy
    '''
    req_dict = request.get_json()

    inid = req_dict.get("inid")  # 行业id

    category = req_dict.get("category")  # 政策类型
    org = req_dict.get("org")  # 发布机构
    year = req_dict.get("year")  # 发布年份
    keyword = req_dict.get("keyword")  # 搜索园区内容

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    if org == "省级":
        org = "山西省政府"
    if org == "市级":
        org = "太原市政府"
    if org == "区县":
        org = "小店区政府"
    if org == "开发区":
        org = "山西省转型综合改革示范区"
    if org == "山西转型综合改革示范区":
        org = "山西省转型综合改革示范区"

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    query = ""  # 要查询的关键词
    args_term = dict()  # 要匹配的字段
    args_cate = dict()  # 要多字段(两导航)完全匹配
    args_org = dict()  # 要多字段(两导航)完全匹配

    if keyword:
        query = keyword
    if category:
        args_term["category"] = category
    if org:
        args_org["org"] = org
    if year:
        args_term["year"] = year

    if inid:
        indu_name = Industry.query.filter_by(nid=inid).first().oname
        args_cate["indu"] = indu_name

    body = create_body(page, perpage, query, args_term, args_cate, args_org)

    try:
        url = "http://127.0.0.1:9200/typolicy/_search"
        # url = "http://127.0.0.1:9200/newindex/_search"
        result_es = json.loads(requests.post(url=url, json=body).text)
        # print(result_es)
        data = []
        size = result_es["hits"]["total"]
        for item in result_es["hits"]["hits"]:
            data.append({"name": item["_source"]["name"],
                         "org": item["_source"]["org"],
                         "pubdate": str(item["_source"]["pubdate"]),
                         "id": item["_source"]["policyid"]})
        result = {"data": data, "size": size}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="查询成功", data=result)


# # 太原产业政策列表(转es)（pc更新）
# @api_atlas.route('/industry/policyList', methods=['POST'])
# # @login_required
# def policy_list():
#     '''
#     太原产业政策列表(第一版用mysql,全文搜索，准备改用用es)
#     根据条件多字段搜索
#     :return:model-InduPolicy
#     '''
#     req_dict = request.get_json()
#
#     inid = req_dict.get("inid")  # 行业id
#
#     category = req_dict.get("category")  # 政策类型
#     level = req_dict.get("level")  # 发布级别
#     org = req_dict.get("org")  # 发布机构
#     year = req_dict.get("year")  # 发布年份
#     keyword = req_dict.get("keyword")  # 搜索园区内容
#
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#
#     if org == "省级":
#         org = "山西省政府"
#     if org == "市级":
#         org = "太原市政府"
#     if org == "区县":
#         org = "小店区政府"
#     if org == "开发区":
#         org = "山西转型综合改革示范区"
#     if org == "山西转型综合改革示范区":
#         org = "山西省转型综合改革示范区"
#
#     # 校验参数完整性
#     if not all([page, perpage]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     query = ""  # 要查询的关键词
#     args_term = dict()  # 要匹配的字段
#     args_cate = dict()  # 要多字段(两导航)完全匹配
#     args_org = dict()  # 要多字段(两导航)完全匹配
#
#     if keyword:
#         query = keyword
#     if category:
#         args_term["category"] = category
#     if org:
#         args_org["org"] = org
#     if year:
#         args_term["year"] = year
#     if level:
#         args_term["level"] = level
#
#     if inid:
#         indu_name = Industry.query.filter_by(nid=inid).first().oname
#         args_cate["indu"] = indu_name
#
#     body = create_body(page, perpage, query, args_term, args_cate, args_org)
#
#     try:
#         # url = "http://127.0.0.1:9200/policy/_search"
#         url = "http://127.0.0.1:9200/typolicy/_search"
#         result_es = json.loads(requests.post(url=url, json=body).text)
#         print(result_es)
#         data = []
#         size = result_es["hits"]["total"]
#         for item in result_es["hits"]["hits"]:
#             data.append({"name": item["_source"]["name"],
#                          "org": item["_source"]["org"],
#                          "pubdate": str(item["_source"]["pubdate"]),
#                          "id": item["_source"]["policyid"]})
#         result = {"data": data, "size": size}
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="查询成功", data=result)


# 太原产业政策列表(转mysql)（pc更新）
@api_atlas.route('/industry/policyList', methods=['POST'])
# @login_required
def policy_list():
    '''
    :return:
    '''
    req_dict = request.get_json()

    inid = req_dict.get("inid")  # 行业id

    category = req_dict.get("category")  # 政策类型
    level = req_dict.get("level")  # 发布级别
    org = req_dict.get("org")  # 发布机构
    year = req_dict.get("year")  # 发布年份
    keyword = req_dict.get("keyword")  # 搜索园区内容

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    if org == "省级":
        org = "山西省政府"
    if org == "市级":
        org = "太原市政府"
    if org == "区县":
        org = "小店区政府"
    if org == "开发区":
        org = "山西转型综合改革示范区"
    if org == "山西转型综合改革示范区":
        org = "山西省转型综合改革示范区"

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        indu_policy = InduPolicy.query.order_by(InduPolicy.sorts_level)
        # indu_policy = indu_policy.order_by(InduPolicy.sorts_level)
        if category:
            indu_policy = indu_policy.filter_by(category=category)
        if org:
            indu_policy = indu_policy.filter(InduPolicy.body.like("%{}%".format(org)))
        if year:
            indu_policy = indu_policy.filter_by(year=year)
        if level:
            indu_policy = indu_policy.filter_by(level=level)
        if inid:
            indu_name = Industry.query.filter_by(nid=inid).first().oname
            indu_policy = indu_policy.filter(or_(InduPolicy.navigat.like("%{}%".format(indu_name)),
                                                 InduPolicy.navigator.like("%{}%".format(indu_name))))

        if keyword:  # 如果搜索，全部搜索
            indu_policy = InduPolicy.query.filter(InduPolicy.name.like("%{}%".format(keyword)))
        else:
            indu_policy = indu_policy
        size = indu_policy.count()
        indu_policy = indu_policy.order_by(InduPolicy.sorts).order_by(InduPolicy.pubdate.desc()).paginate(page,
                                                                                                          perpage).items

        data = [{"id": i.id,
                 "name": i.name,
                 "org": i.org,
                 "pubdate": str(i.pubdate)[:10]} for i in indu_policy]
        result = {"data": data, "size": size}

        return jsonify(code=RET.OK, msg="查询成功", data=result)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# # 产业政策详情(转es)
# @api_atlas.route('/indupolicy/detail', methods=['POST'])
# # @login_required
# def policy_detail():
#     '''
#     产业政策详情(从es数据查询文件本地的路径)
#     :return:
#     '''
#     req_dict = request.get_json()
#     _id = req_dict.get("id")  # 产业政策policyid
#     # 校验参数完整性
#     if not all([_id]):
#         return jsonify(errno=RET.PARAMERR, errmsg="参数不完整")
#     body = {"query":
#                 {"bool": {"must": [{"term": {"policyid": "{}".format(_id)}}],
#                           "must_not": [],
#                           "should": []}},
#             "from": 0,
#             "size": 50,
#             "sort": [],
#             "aggs": {},
#             "_source": [
#                 "name", "org", "pubdate", "industry", "category",
#                 "district", "url", "file"
#             ],
#             }
#     try:
#         url = "http://127.0.0.1:9200/typolicy/_search"
#         result_es = json.loads(requests.post(url=url, json=body).text)
#         data = result_es["hits"]["hits"][0]["_source"]
#         # 转换https
#         # data["file"] = str(data["file"]).replace("http","https")
#         return jsonify(code=RET.OK, msg="查询成功", data=data)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(errno=RET.DBERR, errmsg="数据库查询错误")
''''''


# 政策详情
@api_atlas.route("/indupolicy/detail", methods=["POST"])
def policy_detail():
    req_dic = request.get_json()
    _id = req_dic.get("id")

    if not _id:
        return jsonify(code=RET.PARAMERR, msg="参数不全")
    if _id == 129:
        _id = 52
    try:
        policy = InduPolicy.query.get(_id)
        data = {"name": policy.name,
                "file": policy.file if policy.file else "-",
                "category": policy.category if policy.category else "-",
                "org": policy.org if policy.org else "-",
                "industry": policy.industry if policy.industry else "-",
                "district": policy.district if policy.district else "-",
                "pubdate": str(policy.pubdate)[0:10] if policy.pubdate else "-",
                "url": policy.url if policy.pubdate else "-",
                "post_num": policy.post_num if policy.post_num else ""}
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
