import datetime
import re
import json
import time
import random
import threading
import numpy as np
import requests
import filetype
from sqlalchemy.exc import IntegrityError
from flask_mail import Mail, Message
from flask import g, current_app, request, jsonify, session
from apps.view_user import api_user
from apps import creat_app
from apps.utils.send_phone_info import send_code_new, send_code, send_reset_password_code
from apps.utils.response_code import RET
from apps import db, constants, redis_store
from apps.models import *
from apps.util import create_token, verify_token, login_required
from werkzeug.security import generate_password_hash, check_password_hash
from apps import qiniu_store
from apps.utils.vxconfig import WxConfig
from apps.utils.encrypt_decrypt.aes_cbc import encrypt, decrypt


# 给手机发验证码
@api_user.route("/SendMobileCode", methods=["POST"])
def send_phone_code():
    '''
    向手机发送验证码
    :return:
    '''
    # 获取请求参数，转化字典
    req_dict = request.get_json()
    mobile = req_dict.get('mobile')  # 手机号
    sms_type = req_dict.get('sms_type')  # 验证码类型  验1证码登录,2手机号码绑定,3密码重置验证码
    # 校验参数完整性
    if not all([mobile]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.MOBILEERR, msg="手机号格式错误")
    # # 判断手机号是否存在
    # try:
    #     user = User.query.filter_by(mobile=mobile).first()
    # except Exception as e:
    #     current_app.logger.error(e)
    # else:
    #     if user:  # 手机号已存在
    #         return jsonify(code=RET.DATAEXIST, msg="手机号已存在，请直接登录")

    # 生成短信验证码
    sms_code = "%06d" % random.randint(0, 999999)
    data = ''
    if sms_type == 1:  # 验证码登录
        data = send_code_new(mobile, sms_code)
    if sms_type == 2:  # 手机号码绑定
        data = send_code(mobile, sms_code)
    if sms_type == 3:  # 密码重置验证码
        data = send_reset_password_code(mobile, sms_code)
    # print(data)
    if data['Message'] == 'OK':
        # 保存真实的短信验证码
        try:
            redis_store.setex("sms_code_%s" % mobile, constants.SMS_CODE_REDIS_EXPIRES, sms_code)
            # 保存发送给这个手机号的记录，防止用户在60s内再次出发发送短信的操作
            redis_store.setex("send_sms_code_%s" % mobile, constants.SEND_SMS_CODE_INTERVAL, 1)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="保存短信验证码异常")
        # 发送成功
        return jsonify(code=RET.OK, msg="发送成功")
    if data['Message'] != 'OK':
        return jsonify(code=RET.THIRDERR, msg="发送次数太多，已被限流，请稍后再试！")
    else:
        return jsonify(code=RET.THIRDERR, msg="发送失败")


# 后台用户账号密码
@api_user.route("/backLogin", methods=["POST"])
def back_login():
    '''
    用户密码登录
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    # 解密
    param = req_dict.get("param")  # 揭秘参数
    req_dict = json.loads(decrypt(param))
    # name = req_dict.get('name')
    name = req_dict.get('name')

    password = req_dict.get('password')
    # 校验参数完整性
    if not all([name, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 判断错误次数是否超过限制，如果超过则10分钟内禁止此IP登录
    user_ip = request.remote_addr
    # print("IP地址：", user_ip)
    try:
        access_nums = redis_store.get('jincheng_access_nums_{}'.format(user_ip))
    except Exception as e:
        current_app.logger.error(e)
    else:
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                return jsonify(code=RET.REQERR, msg="错误次数过多，请稍候重试")

    # 验证账户与密码
    try:
        user = Bstage.query.filter_by(name=name).first()
        # 用于记录日志
        # section, user_name, operation_mobile, role_id, belong_unit = get_user_info(user)
        name = user.name
        role = user.role
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 将用户名与密码验证放置在一处，若失败返回提示信息并记录次数
    # if (not user) or (not user.check_password(password)):
    #     # if (not user) or (password != "123"):
    #     try:
    #         redis_store.incr('access_nums_{}'.format(user_ip))
    #         redis_store.expire('access_nums_{}'.format(user_ip), constants.LOGIN_ERROR_FORBID_TIME)
    #     except Exception as e:
    #         current_app.logger.error(e)
    #     return jsonify(code=RET.DBERR, msg="密码错误")

    # 若成功保存登录状态和管理员的角色id
    token = create_token(user.id)

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过后台登录成功了！+++++++++++++++++++++++=++'.format(time, name))
    # 记录日志
    role_name = ''
    if role == 1:
        role_name = '超级管理员'
    if role == 2:
        role_name = '系统运维员'
    return jsonify(code=RET.OK, msg="登录成功", token=token, flag=3)


# 手机验证码登录
@api_user.route("/LoginBySms", methods=["POST"])
def login_bysms():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    mobile = req_dict.get('mobile')  # 手机号
    sms_code = req_dict.get("sms_code")  # 验证码

    # 校验参数完整性
    if not all([mobile, sms_code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
        # real_sms_code = "123456"
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 获取用户
    try:
        user = User.query.filter_by(mobile=mobile).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        # if "123456" != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    if not user:
        # 判断并添加用户信息
        try:
            user = User(name=mobile, mobile=mobile, flag=1, status=1)
            db.session.add(user)
            db.session.commit()
        except Exception as e:
            # 表示操作失败，回滚数据库操作
            db.session.rollback()
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库异常")
    # print(user.status==3)
    if user.status == 0:
        return jsonify(code=RET.USERERR, msg="当前用户被禁止登录,请联系管理员")

    # 获取用户id，传入生成token的方法，并接收返回的token
    token = create_token(user.id)

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用手机-短信验证码登录成功了！+++++++++++++++++++++++=++'.format(time, mobile))

    return jsonify(code=RET.OK, msg="登录成功", data={"token": token, "flag": user.flag})


# 内部用户手机-密码登录
@api_user.route("/LoginByPwd", methods=["POST"])
def login_bypwd():
    '''
    用户密码登录
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    # 解密
    param = req_dict.get("param")  # 加密参数
    req_dict = json.loads(decrypt(param))
    mobile = req_dict.get('mobile')
    password = req_dict.get('password')
    # 校验参数完整性
    if not all([mobile, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号错误")

    # 判断错误次数是否超过限制，如果超过则10分钟内禁止此IP登录
    user_ip = request.remote_addr
    # print("IP地址：", user_ip)

    # 获取ip的锁定时间
    try:
        access_nums = redis_store.get('jincheng_access_nums_{}'.format(user_ip))
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                lock_time = redis_store.ttl('jincheng_access_nums_{}'.format(user_ip))
                return jsonify(code=RET.LOCKTIME, msg="ip锁定倒计时中，还剩{}秒！".format(lock_time), lock_time=lock_time)
    except Exception as e:
        current_app.logger.error(e)
    else:
        pass

    try:
        access_nums = redis_store.get('jincheng_access_nums_{}'.format(user_ip))
        # access_nums = "123456"
    except Exception as e:
        current_app.logger.error(e)
    else:
        if access_nums:
            if int(access_nums.decode()) >= constants.LOGIN_ERROR_TIMES:
                return jsonify(code=RET.REQERR, msg="错误次数过多，请15分钟后重试！", time=constants.LOGIN_ERROR_FORBID_TIME)

    # 验证手机号与密码
    try:
        user = User.query.filter_by(mobile=mobile, flag=2).first()
        district_name = user.belong_organization
        if not district_name:
            return jsonify(code=RET.NODATA, msg="请设置用户所属单位！")
        if '晋城市' in district_name:
            district_name = "晋城市"
        else:
            if '沁水' in district_name:
                district_name = '沁水县'
            if '高平' in district_name:
                district_name = '高平市'
            if '阳城' in district_name:
                district_name = '阳城县'
            if '陵川' in district_name:
                district_name = '陵川县'
            if '泽州' in district_name:
                district_name = '泽州县'
            if '城区' in district_name:
                district_name = '城区'
            if '晋城经济技' in district_name:
                district_name = '晋城经济技术开发区'
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="获取用户信息失败")

    if not user:
        return jsonify(code=RET.DATAERR, msg="账户不存在")
    # 将用户名与密码验证放置在一处，若失败返回提示信息并记录次数
    if not user.check_password(password):
        try:
            redis_store.incr('jincheng_access_nums_{}'.format(user_ip))
            redis_store.expire('jincheng_access_nums_{}'.format(user_ip), constants.LOGIN_ERROR_FORBID_TIME)
        except Exception as e:
            current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="密码错误")

    if user.status == 0:  # 被禁止
        return jsonify(code=RET.ROLEERR, msg="账号被禁止，请联系管理员进行处理！")
    if user.status == 2:  # 审核
        return jsonify(code=RET.ROLEERR, msg="审核暂未通过,请以外部访客身份登陆")

    if user.status == 3:  # 驳回
        return jsonify(code=RET.ROLEERR, msg="您的审核未通过，请联系工作人员")

    session.permanent = True  # 设置session在设定时间内有效  注意这个要设置在request里边 即请求内部
    # 若成功保存登录状态
    token = create_token(user.id)

    # 页面权限列表
    page_permission_list = ''
    fun_permission_list = ''
    org_obj = user.org
    if org_obj:
        page_permission_list = eval(org_obj.page_permission_id)
        fun_permission_list = eval(org_obj.fun_permission_id)

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用手机-密码登录成功了！+++++++++++++++++++++++=++'.format(time, mobile))
    return jsonify(code=RET.OK,
                   data={"msg": "登录成功",
                         "token": token,
                         "flag": user.flag,
                         "district_name": district_name,
                         "page_permission_list": page_permission_list,
                         "fun_permission_list": fun_permission_list})


# 微信授权
@api_user.route("/LoginByvx", methods=["POST"])
def login_byvx():
    '''
    用户验证码登录，用户存在，直接登陆，不存在就后台注册
    :return:
    '''
    # 参数获取与校验
    req_dict = request.get_json()
    code = req_dict.get('code')  # 微信登录code

    # 校验参数完整性
    if not all([code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    app_id = WxConfig.get_wx_app_id()
    app_secret = WxConfig.get_wx_app_secret()

    url = u'https://api.weixin.qq.com/sns/oauth2/access_token'
    params = {
        'appid': app_id,
        'secret': app_secret,
        'code': code,
        'grant_type': 'authorization_code'
    }
    res = requests.get(url, params=params).json()

    user_info_url = u'https://api.weixin.qq.com/sns/userinfo'
    params1 = {
        'access_token': res.get("access_token"),
        'openid': res.get("openid")
    }
    uinfo = requests.get(user_info_url, params=params1).json()
    # nickname = uinfo.get('nickname').encode('iso8859-1').decode('utf-8')
    try:
        openid = uinfo["openid"]
        unionid = uinfo["unionid"]
    except:
        return None

    try:
        user = User.query.filter_by(vxopenid=openid, vxunionid=unionid).first()
        if user:
            # 若成功保存登录状态
            token = create_token(user.id)
            return jsonify(code=RET.OK, msg="登录成功", data={"token": token, "flag": user.flag})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="appid,secreat异常")

    time = datetime.now()
    current_app.logger.error(
        '++++++++++++++++++++++++++++登录日志>>>{}:{}通过使用微信登录成功了！+++++++++++++++++++++++=++'.format(time, user))

    return jsonify(code=RET.USERERR, msg="授权成功", user_info=uinfo)


# vx登陆后绑定手机号
@api_user.route("/Binding", methods=["POST"])
def binding():
    '''
    绑定已有账号
    :return:
    '''
    req_dict = request.get_json()
    openid = req_dict.get("openid")  # vxopenid
    unionid = req_dict.get("unionid")  # vxunionid
    mobile = req_dict.get('mobile')  # 手机号
    sms_code = req_dict.get("sms_code")  # 验证码

    # 校验参数完整性
    if not all([openid, unionid, mobile, sms_code]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 获取用户
    try:
        user = User.query.filter_by(mobile=mobile).first()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="获取用户信息失败")

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")
    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    try:
        if user:
            user.vxopenid = openid
            user.vxunionid = unionid
            db.session.commit()
            if user.status != 1:
                jsonify(code=RET.OK, msg="绑定成功，当前用户被禁止登录,请联系管理员")
        else:
            user = User(name=mobile, mobile=mobile, vxopenid=openid, vxunionid=unionid, flag=1, status=1)
            # user.password = password
            db.session.add(user)
            db.session.commit()
    except Exception as e:
        # 表示操作失败，回滚数据库操作
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")

    # 若成功保存登录状态
    token = create_token(user.id)
    return jsonify(code=RET.OK, msg="绑定成功，登录成功", data={"token": token, "flag": user.flag})


"""用户中心"""


# 用户中心-账号设置-添加账号(注册)
@api_user.route("/Register", methods=["POST"])
def register():
    """
    用户注册
    :return:
    """
    # 获取请求参数，转化字典
    req_dict = request.get_json()
    real_name = req_dict.get("real_name")  # 姓名
    mobile = req_dict.get('mobile')  # 联系电话
    belong_organization = req_dict.get("belong_organization")  # 所属机构
    belong_department = req_dict.get("belong_department")  # 所属部门（政府）
    position = req_dict.get("position")  # 职务
    password = req_dict.get("password")  # 密码
    password_again = req_dict.get("password_again")  # 密码2
    sms_code = req_dict.get("sms_code")  # 验证码

    # 校验参数完整性
    if not all([real_name, mobile, belong_organization,
                sms_code, position, password, password_again]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 校验手机号格式
    if not re.match(r"1[23456789]\d{9}$", mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(mobile)).decode()
        # real_sms_code = "123456"
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.NODATA, msg="短信验证码失效")

    # 判断短信验证码是否失效
    if not redis_store:
        return jsonify(code=RET.NODATA, msg="短信验证码失效")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(mobile))
    except Exception as e:
        current_app.logger.error(e)

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        # if "123456" != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    # 校验密码
    if password != password_again:
        return jsonify(code=RET.DATAERR, msg="密码不一致")

    # 增加密码校验策略，20211109
    # 判断密码长度是否8位，数字、字母、特殊字符同时存在，能使用用户名、连续性字母、数字、特殊字符等易猜测口令。
    if len(password) < 8:
        return jsonify(code=RET.DATAERR, msg="密码长度最少为8位")
    # 密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'
    if not (re.search(r'\d+', password) and re.search(r'[a-z]+', password) and re.search(r'[A-Z]+',
                                                                                         password) and re.search(
        r'[.!@#$%^&*()_+=-]+', password)):
        return jsonify(code=RET.DATAERR, msg="密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'")

    # 判断并添加用户信息
    try:
        ouser = User.query.filter_by(mobile=mobile).first()
        # print(ouser)
        if ouser and ouser.flag == 1 and ouser.status == 0:  # 外部访客被禁止
            return jsonify(code=RET.DATAEXIST, msg="当前用户被禁止，请联系管理员")

        if ouser and ouser.flag == 2 and ouser.status == 2:  # 注册暂时未通过
            return jsonify(code=RET.DATAEXIST, msg="手机号已注册,请耐心等待审核")

        if ouser and ouser.flag == 2 and ouser.status == 1:  # 内部用户再次注册
            return jsonify(code=RET.DATAEXIST, msg="手机号已注册,请勿重复注册")

        if ouser and ouser.flag == 1 and ouser.status == 1:  # 外部访客注册
            ouser.real_name = real_name  # 姓名
            ouser.mobile = mobile  # 联系电话
            ouser.belong_organization = belong_organization  # 所属机构

            ouser.belong_department = belong_department  # 所属部门

            ouser.position = position  # 职务
            ouser.flag = 2  # 外部访问为1，内部人员为2
            ouser.status = 2  # 审核
            ouser.password = password
        else:
            user = User(real_name=real_name,
                        mobile=mobile,
                        belong_organization=belong_organization,
                        belong_department=belong_department,
                        position=position,
                        flag=2, status=2, password=password)

            db.session.add(user)
        db.session.commit()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库异常")
    return jsonify(code=RET.OK, msg="注册成功")


# 用户中心-个人中心初始数据展示
@api_user.route("/UserInfo", methods=["GET"])
@login_required
def detail():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user_info = User.query.get(user_id)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    data = {
        "flag": user.flag,
        "real_name": user_info.real_name,  # 名字
        # "age": user_info.age,  # 年龄
        # "sex": user_info.sex,  # 性别
        "mobile": user_info.mobile,  # 手机号
        # "username": user_info.name,  # 用户名
        # "email": user_info.email,  # 邮箱
        "belong_organization": user_info.belong_organization if user_info.belong_organization else "-",  # 机构
        "belong_department": user_info.belong_department if user_info.belong_department else "-",  # 部门
        "position": user_info.position if user_info.position else "-",  # 职务
        # "level": user_info.level if user_info.level else "-",  # 职级
        # "unit": user_info.unit if user_info.unit else "-",  # 所在机构
        # "funct": user_info.function if user_info.function else "-",  # 工作职能
        # "name": user_info.name if user_info.name else "-",  # 用户名
        # "password": user_info.password if user_info.password else "-",  # 密码
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 用户中心-个人中心确认修改
# @api_user.route("/FixUserInfo", methods=["POST"])
# @login_required
# def fix_user_info():
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id
#     req_dict = request.get_json()
#     real_name = req_dict.get("real_name")
#     age = req_dict.get("age")
#     sex = req_dict.get("sex")
#     name = req_dict.get("name")
#     position = req_dict.get("position")
#
#     belong_organization = req_dict.get("belong_organization")
#     belong_department = req_dict.get("belong_department")
#
#     try:
#         user_information = User.query.get(user_id)
#         # 姓名
#         if real_name:
#             user_information.real_name = real_name
#         # 机构
#         if belong_organization:
#             user_information.belong_organization = belong_organization
#         # 部门
#         if belong_department:
#             user_information.belong_department = belong_department
#         # 年龄
#         if age:
#             user_information.age = age
#         # 性别  1 - 男   2 - 女
#         if sex:
#             user_information.sex = sex
#         # 职务
#         if position:
#             user_information.position = position
#         # 用户名
#         if name:
#             user = User.query.filter_by(name=name).filter(User.id != user_id).first()
#             if user:
#                 return jsonify(code=RET.DATAEXIST, msg="用户名已经存在")
#             user_information.name = name
#         db.session.commit()
#     except Exception as e:
#         db.session.rollback()  # 回滚数据库
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     return jsonify(code=RET.OK, msg="修改成功")


# 修改用户手机号
@api_user.route("/ChangePhone", methods=["POST"])
@login_required
def change_phone():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id
    try:
        user_info = User.query.get(user_id)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    req_dict = request.get_json()
    mobile = req_dict.get("mobile")
    sms_code = req_dict.get("sms_code")

    # 校验手机号格式
    if not re.match(r'^1[3456789]\d{9}$', user_info.mobile):
        return jsonify(code=RET.PARAMERR, msg="手机号格式错误")

    if not redis_store.get('sms_code_{}'.format(user_info.mobile)):
        return jsonify(code=RET.DATAERR, msg="请获取验证码")
    # 获取短信验证码
    try:
        real_sms_code = redis_store.get('sms_code_{}'.format(user_info.mobile)).decode()
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="redis数据库异常")

    # 判断短信验证码是否失效
    if not redis_store:
        return jsonify(code=RET.NODATA, msg="短信验证码失效")

    # 删除redis中的短信验证码，防止重复校验
    try:
        redis_store.delete("sms_code_{}".format(user_info.mobile))
    except Exception as e:
        current_app.logger.error(e)

    # 判断用户填写短信验证码是否一致
    if real_sms_code != sms_code:
        return jsonify(code=RET.DATAERR, msg="短信验证码错误")

    try:
        exist = User.query.filter_by(mobile=mobile).first()
        if exist:
            return jsonify(code=RET.DATAEXIST, msg="手机号已存在")
        user.mobile = mobile
        db.session.commit()
        return jsonify(code=RET.OK, msg="手机号更改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 修改用户登录密码
@api_user.route("/ChangePassword", methods=["POST"])
@login_required
def change_password():
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id

    # 原密码是否正确
    req_dic = request.get_json()
    password = req_dic.get("password")
    new_password = req_dic.get("new_password")
    again_password = req_dic.get("again_password")

    try:
        user_info = User.query.get(user_id)
        if not check_password_hash(user_info.password_hash, password):
            return jsonify(code=RET.DATAERR, msg="原始密码错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    # 密码长度
    if len(new_password) < 6:
        return jsonify(code=RET.DATAERR, msg="密码太短，不安全")
    # 新密码不能与原始密码一致
    if new_password == password:
        return jsonify(code=RET.DATAERR, msg="新密码不能与原始密码一致")
    # 两次密码是否一致
    if new_password != again_password:
        return jsonify(code=RET.PARAMERR, msg="两次密码不一致")

    # 判断密码长度是否8位，数字、字母、特殊字符同时存在，能使用用户名、连续性字母、数字、特殊字符等易猜测口令。
    if len(new_password) < 8:
        return jsonify(code=RET.DATAERR, msg="密码长度最少为8位")
    # 密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'
    if not (re.search(r'\d+', new_password) and re.search(r'[a-z]+', new_password) and re.search(r'[A-Z]+',
                                                                                                 new_password) and re.search(
        r'.[!@#$%^&*()_+=-]+', new_password)):
        return jsonify(code=RET.DATAERR, msg="密码应设置为包含大小写字母、数字、特殊符号'!@#$%^&*()_+=-'")

    # 两个密码是否都存在
    if not all([new_password, again_password, password]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user_info = User.query.get(user_id)
        # if not check_password_hash(user_info.password_hash, password):
        #     return jsonify(code=RET.DATAERR, msg="密码错误")
        user_info.password = new_password
        db.session.commit()
        return jsonify(code=RET.OK, msg="更改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


"""以下为202212月改版后需求"""


# 用户中心-个人中心确认修改
@api_user.route("/FixUserInfo", methods=["POST"])
@login_required
def fix_user_info():
    token = request.headers["token"]
    try:
        user = verify_token(token)
        user_id = user.id
    except:
        return jsonify(code=RET.SESSIONERR, msg='个人信息校验失败，请重新登录！')
    req_dict = request.get_json()
    real_name = req_dict.get("real_name")
    # age = req_dict.get("age")
    # sex = req_dict.get("sex")
    # name = req_dict.get("name")
    position = req_dict.get("position")

    belong_organization = req_dict.get("belong_organization")  # 202212新增
    belong_department = req_dict.get("belong_department")  # 202212新增

    try:
        user_information = User.query.get(user_id)
        # 姓名
        if real_name:
            user_information.real_name = real_name
        # 机构
        if belong_organization:
            user_information.belong_organization = belong_organization
        # 部门
        if belong_department:
            user_information.belong_department = belong_department
        # 年龄
        # if age:
        #     user_information.age = age
        # # 性别  1 - 男   2 - 女
        # if sex:
        #     user_information.sex = sex
        # 职务
        if position:
            user_information.position = position
        # 用户名
        # if name:
        #     user = User.query.filter_by(name=name).filter(User.id != user_id).first()
        #     if user:
        #         return jsonify(code=RET.DATAEXIST, msg="用户名已经存在")
        #     user_information.name = name
        db.session.commit()
    except Exception as e:
        db.session.rollback()  # 回滚数据库
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    return jsonify(code=RET.OK, msg="修改成功")


# 查看收藏-收藏的企业和行业
@api_user.route("/GetCollect", methods=["POST"])
@login_required
def get_collect():
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")
    req_dict = request.get_json()
    page = req_dict.get("page")
    per_page = req_dict.get("per_page")
    classify = req_dict.get("classify")
    choice = req_dict.get("choice")

    company_name = req_dict.get("company_name")

    if not page:
        page = 1

    if not per_page:
        per_page = 10

    if classify == 1 and not all([classify, choice]):
        return jsonify(code=RET.PARAMERR, msg="数据不全")

    # 判断是企业还是行业关注，企业1，行业0
    if classify == 1:
        company = []
        try:
            user = User.query.get(user_id)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")
        if choice == "2":
            try:
                maxnum = len(user.enterprise)
                company_list = user.enterprise[(page - 1) * per_page:page * per_page]
                for i in company_list:
                    create_time = UserEnterprise.query.filter_by(enterprise_id=i.id, user_id=user_id).first()
                    if company_name:
                        if company_name in i.company_name:
                            company.append({
                                "id": i.id,
                                "company_name": i.company_name,
                                "create_time": create_time.create_time.strftime('%Y-%m-%d %H:%M:%S'),
                                "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-",
                                "high_new": '高新技术企业' if i.high_new == '1' else '',
                                "tbe": '科技型中小企业' if i.tbe == '1' else '',
                                "quoted_company": '上市企业' if i.quoted_company == '1' else '',
                                "sxmon": '山西民营100强' if i.sxmon == '1' else '',
                                "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
                                "unicorn": '独角兽企业' if i.unicorn == '1' else '',
                                "dengl": '瞪羚企业' if i.dengl == '1' else '',
                                "isfive": '中国500强' if i.isfive == '1' else '',
                                "scale": '规模以上企业' if i.scale == '1' else '',
                                "serve": '限额以上服务业' if i.serve == '1' else '',
                                "chain_master": '链主企业' if i.chain_master == '1' else ''
                            })
                        else:
                            continue
                    else:
                        company.append({
                            "id": i.id,
                            "company_name": i.company_name,
                            "create_time": create_time.create_time.strftime('%Y-%m-%d %H:%M:%S'),
                            "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-",
                            "high_new": '高新技术企业' if i.high_new == '1' else '',
                            "tbe": '科技型中小企业' if i.tbe == '1' else '',
                            "quoted_company": '上市企业' if i.quoted_company == '1' else '',
                            "sxmon": '山西民营100强' if i.sxmon == '1' else '',
                            "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
                            "unicorn": '独角兽企业' if i.unicorn == '1' else '',
                            "dengl": '瞪羚企业' if i.dengl == '1' else '',
                            "isfive": '中国500强' if i.isfive == '1' else '',
                            "scale": '规模以上企业' if i.scale == '1' else '',
                            "serve": '限额以上服务业' if i.serve == '1' else '',
                            "chain_master": '链主企业' if i.chain_master == '1' else ''

                        })
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")

            data = {
                "ob_list": company,
                "maxnum": maxnum
            }
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        else:
            maxnum = len(user.company)
            company_list = user.company[(page - 1) * per_page:page * per_page]
            try:
                for i in company_list:
                    create_time = UserCompany.query.filter_by(company_id=i.id, user_id=user_id).first()

                    if company_name:
                        if company_name in i.company_name:
                            company.append({
                                "id": i.id,
                                "company_name": i.company_name,
                                "create_time": create_time.create_time.strftime('%Y-%m-%d %H:%M:%S'),
                                "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-",
                                "high_new": '高新技术企业' if i.high_new == '1' else '',
                                "tbe": '科技型中小企业' if i.tbe == '1' else '',
                                "quoted_company": '上市企业' if i.quoted_company == '1' else '',
                                "sxmon": '山西民营100强' if i.sxmon == '1' else '',
                                "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
                                "unicorn": '独角兽企业' if i.unicorn == '1' else '',
                                "dengl": '瞪羚企业' if i.dengl == '1' else '',
                                "isfive": '中国500强' if i.isfive == '1' else '',
                                "scale": '规模以上企业' if i.scale == '1' else '',
                                "serve": '限额以上服务业' if i.serve == '1' else '',
                                "chain_master": '链主企业' if i.chain_master == '1' else ''

                            })
                        else:
                            continue
                    else:
                        company.append({
                            "id": i.id,
                            "company_name": i.company_name,
                            "create_time": create_time.create_time.strftime('%Y-%m-%d %H:%M:%S'),
                            "build_date": i.build_date.strftime("%Y-%m-%d") if i.build_date else "-",
                            "high_new": '高新技术企业' if i.high_new == '1' else '',
                            "tbe": '科技型中小企业' if i.tbe == '1' else '',
                            "quoted_company": '上市企业' if i.quoted_company == '1' else '',
                            "sxmon": '山西民营100强' if i.sxmon == '1' else '',
                            "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
                            "unicorn": '独角兽企业' if i.unicorn == '1' else '',
                            "dengl": '瞪羚企业' if i.dengl == '1' else '',
                            "isfive": '中国500强' if i.isfive == '1' else '',
                            "scale": '规模以上企业' if i.scale == '1' else '',
                            "serve": '限额以上服务业' if i.serve == '1' else '',
                            "chain_master": '链主企业' if i.chain_master == '1' else ''
                        })
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")

            data = {
                "ob_list": company,
                "maxnum": maxnum
            }
            return jsonify(code=RET.OK, msg="查找成功", data=data)
    # 行业
    try:
        user = User.query.get(user_id)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    maxnum = len(user.industry)
    industry = []
    industry_list = user.industry[(page - 1) * per_page:page * per_page]

    for i in industry_list:
        # 查询关注时间
        try:
            indu = UserIndustry.query.filter_by(industry_id=i.id, user_id=user_id).first()
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")

        # count = Company.query.filter_by(company_industry = i.name)
        industry.append({
            "id": i.id,
            "industry_name": i.name,
            "create_time": indu.create_time.strftime("%Y-%m-%d"),
            "count": i.entities if i.entities else 0
        })
        industry = sorted(industry, key=lambda k: k['create_time'], reverse=True)
    data = {
        "ob_list": industry,
        "maxnum": maxnum
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)


# 取消收藏
@api_user.route("/CancelCollect", methods=["POST"])
@login_required
def cancel_collect():
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")
    req_dict = request.get_json()

    id = req_dict.get("id")
    classify = req_dict.get("classify")
    choice = req_dict.get("choice")
    # print(id, classify, choice)
    if classify == 1 and not all([id, classify, choice]):
        return jsonify(code=RET.PARAMERR, msg="数据不全")

    # id = g.id

    if classify == 1:
        if choice == "2":
            # 删除全国数据
            # pass
            try:
                company_user = UserEnterprise.query.filter_by(enterprise_id=id, user_id=user_id).first()
                db.session.delete(company_user)
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")
        else:
            try:
                company_user = UserCompany.query.filter_by(company_id=id, user_id=user_id).first()
                db.session.delete(company_user)
                db.session.commit()
                return jsonify(code=RET.OK, msg="删除成功")
            except Exception as e:
                current_app.logger.error(e)
                return jsonify(code=RET.DBERR, msg="数据库错误")
    # 删除行业数据
    try:
        industry_user = UserIndustry.query.filter_by(industry_id=id, user_id=user_id).first()
        db.session.delete(industry_user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="取关成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
