from elasticsearch import Elasticsearch
from flask import g, current_app, request, jsonify, session
from sqlalchemy import or_, and_

from apps.view_map import api_map
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
import json
import requests
from apps import db, constants, redis_store
from apps.view_360company.view import create_body
from apps.view_atlas.view import get_product_li

'''本页接口使用全国企业库enterprise'''
graph = conn_neo4j()


# 颜色计数
def jishu(num):
    if num >= 0 and num <= 50:
        return "#72D4F1"
    if num > 50 and num <= 100:
        return "#00BAF6"
    if num > 100 and num <= 200:
        return "#4F9FFF"
    if num > 200 and num <= 500:
        return "#4265F6"
    if num > 500 and num <= 1000:
        return "#0052d6"
    if num > 1000:
        return "#0245AE"


# 招商地图下的色块图(同右侧得数量分布饼图)
@api_map.route('/AttractMap', methods=['POST'])
@login_required
def attract_map():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    name_query = "AttractMap" + province + city + district + product + str(inid)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)

    try:
        enterprise = Enterprise.query.filter(or_(
                Enterprise.c_type == inid,
                Enterprise.c_type1 == inid,
                Enterprise.c_type2 == inid
            ))
        company1 = []
        if product:
            # enterprise = enterprise.filter(or_(
            #     Enterprise.product_all.like("%{}%".format(product)),
            #     Enterprise.product_all1.like("%{}%".format(product)),
            #     Enterprise.product_all2.like("%{}%".format(product))
            # ))
            company1, size = get_enterprise_num(product, inid)

        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                if product:
                    num = len([company for company in company1 if company.province == pro])
                else:
                    num = enterprise.filter_by(province=pro).count()
                # province_data = Enterprise.query.filter_by(province=pro).first()
                df.append({"name": pro,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": province_data.p_lng, "lat": province_data.p_lat}})
                           })
            # redis缓存
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df))
            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                if product:
                    num = len([company for company in company1 if company.province == province and company.city == cit])
                else:
                    num = enterprise.filter_by(province=province, city=cit).count()
                city_data = Enterprise.query.filter_by(province=province, city=cit).first()
                df.append({"name": cit,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": city_data.c_lng, "lat": city_data.c_lat}})
                           })
            # redis缓存
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df))
            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                if product:
                    num = len([company for company in company1 if company.province == province and company.city == city and company.district == dis])
                else:
                    num = enterprise.filter_by(province=province, city=city, district=dis).count()
                district_data = Enterprise.query.filter_by(province=province, city=city, district=dis).first()
                df.append({"name": dis,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})
                           })
            # redis缓存
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df))
            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and district:  # 区数据
            if product:
                num = len([company for company in company1 if company.province == province and company.city == city and company.district == district])
            else:
                num = enterprise.filter_by(province=province, city=city, district=district).count()
            district_data = Enterprise.query.filter_by(province=province, city=city, district=district).first()
            # print(district_data)
            if district_data:
                df.append({"name": district,
                           "value": num,
                           "color": "",
                           # "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})
                           })

                # redis缓存
                redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df))
                return jsonify(code=RET.OK, msg="获取成功", data=df)
            else:
                return jsonify(code=RET.OK, msg="无满足条件数据", data=df)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 右侧全国地图企业数据
@api_map.route('/EnterpriseTop5', methods=['POST'])
@login_required
def attract_cnums():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    name_query = "EnterpriseTop5" + str(inid) + province + city + district + product
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)

    try:
        enterprise = Enterprise.query.filter(or_(
            Enterprise.c_type == inid,
            Enterprise.c_type1 == inid,
            Enterprise.c_type2 == inid
        ))
        company1 = []
        if product:
            company1, size = get_enterprise_num(product, inid)
        else:
            pass
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Enterprise.query.with_entities(Enterprise.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                if product:
                    num = len([company for company in company1 if company.province == pro])
                else:
                    num = enterprise.filter_by(province=pro).count()
                if num != 0:
                    df.append({"name": pro, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df[:5]))
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and not city:  # 省-》市数据
            cities = Enterprise.query.filter_by(province=province).with_entities(Enterprise.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                if product:
                    num = len([company for company in company1 if company.province == province and company.city == cit])
                else:
                    num = enterprise.filter_by(province=province, city=cit).count()
                # num = enterprise.filter_by(province=province, city=cit).count()
                if num != 0:
                    df.append({"name": cit, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df[:5]))
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and not district:  # 市-》区数据
            districts = Enterprise.query.filter_by(province=province, city=city).with_entities(
                Enterprise.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                if product:
                    num = len([company for company in company1 if company.province == province and company.city == city and company.district == dis])
                else:
                    num = enterprise.filter_by(province=province, city=city, district=dis).count()

                # num = enterprise.filter_by(province=province, city=city, district=dis).count()
                if num != 0:
                    df.append({"name": dis, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(df[:5]))
            return jsonify(code=RET.OK, msg="获取成功", data=df[:5])
        if province and city and district:  # 区数据
            if product:
                num = len([company for company in company1 if
                           company.province == province and company.city == city and company.district == district])
            else:
                num = enterprise.filter_by(province=province, city=city, district=district).count()

            # num = enterprise.filter_by(province=province, city=city, district=district).count()
            if num != 0:
                df.append({"name": district, "value": num})
            df = sorted(df, key=lambda x: x["value"], reverse=True)
            data = df[:5]
            # redis缓存
            redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
            return jsonify(code=RET.OK, msg="获取成功", data=data)
        return jsonify(code=RET.DATAERR, msg="地区参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 全国企业列表
# @api_map.route('/AttractEnterprise', methods=['POST'])
# # @login_required
# def enterprise():
#     '''
#     太原市企业列表
#     :return:
#     '''
#     req_dict = request.get_json()
#     inid = req_dict.get("inid")  # 行业id
#     page = req_dict.get("page")  # 分页页码
#     perpage = req_dict.get("perpage")  # 分页大小
#     province = req_dict.get("province")
#     city = req_dict.get("city")
#     district = req_dict.get("district")
#     product = req_dict.get("product")  # 产业产品选择
#
#
#     if not all([page, perpage]):
#         return jsonify(code=RET.PARAMERR, msg="参数不完整")
#
#     try:
#         if inid:  # 子行业分类
#             enterprise = Enterprise.query.filter_by(c_type=inid)
#         else:
#             enterprise = Enterprise.query.filter_by()
#         # 区域选择
#         if province:
#             enterprise = enterprise.filter_by(province=province)
#             if city:
#                 enterprise = enterprise.filter_by(city=city)
#                 if district:
#                     enterprise = enterprise.filter_by(district=district)
#         if product:
#             enterprise = enterprise.filter(Enterprise.product_all.like("%{}%".format(product)))
#         size = enterprise.count()
#         enterprise = enterprise.order_by(Enterprise.hots.desc()).paginate(page, perpage).items  # 企业热度倒序
#
#         df = [{"id": i.id,
#                "company_name": i.company_name,
#                "hots": i.hots,
#                "aptitude": ['高新技术企业' if i.high_new == '1' else
#                             '科技型中小企业' if i.tbe == '1' else
#                             '上市企业' if i.quoted_company == '1' else
#                             '山西民营100强' if i.sxmon == '1' else
#                             '山西专精特新企业' if i.zjtg == '1' else
#                             '独角兽企业' if i.unicorn == '1' else
#                             '瞪羚' if i.dengl == '1' else
#                             '中国500强' if i.isfive == '1' else
#                             '规模以上企业' if i.scale == '1' else
#                             '限额以上服务业' if i.serve == '1' else '']
#                } for i in enterprise]
#         data = {"size": size, "df": df}
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库查询错误")
#
#     return jsonify(code=RET.OK, msg="获取成功", data=data)

""""""
# 招商地图下的散点图（至区后）
@api_map.route('/AttractSdmap', methods=['POST'])
@login_required
def attract_sdmap():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    name_query = "AttractSdmap" + str(inid) + province + city + district + product
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)

    # 校验参数完整性
    # if not all([district]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            # enterprise = Enterprise.query.filter_by(c_type=inid)
            enterprise = Enterprise.query.filter(or_(
                Enterprise.c_type == inid,
                Enterprise.c_type1 == inid,
                Enterprise.c_type2 == inid
            ))
        else:
            enterprise = Enterprise.query.filter_by()
        if district:
            enterprise = enterprise.filter_by(province=province, city=city, district=district)
        if product:
            enterprise = enterprise.filter(or_(
                Enterprise.product_all.like("%{}%".format(product)),
                Enterprise.product_all1.like("%{}%".format(product)),
                Enterprise.product_all2.like("%{}%".format(product))
            ))
        enterprise = enterprise.all()
        data = []
        if enterprise:
            for com in enterprise:
                data.append({"id": com.id,
                             "name": com.company_name,
                             "jwd": {"lng": com.lng,  # 企业地址出的经纬度
                                     "lat": com.lat}
                             })  # 上下中游
        else:
            return jsonify(code=RET.OK, msg="获取失败，无数据", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    # redis缓存
    # try:
    #     redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data)
    # except:
    #     return jsonify(code=RET.DBERR, msg="redis保存失败！")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


"""以下202212月改版后需求新增"""


# 企业搜索
@api_map.route('/SearchEnterprises', methods=['POST'])
def search_enterprise():
    req_dic = request.get_json()
    entype = req_dic['entype']
    aptitude = req_dic['aptitude']  # 资质
    company_name = req_dic['company_name']
    status = req_dic['status']
    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        enterprise_obj = Enterprise.query.filter(or_(
            Enterprise.entype == entype,
            Enterprise.company_name.like('%{}%'.format(company_name)),
            Enterprise.status == status,
            Enterprise.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Enterprise.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Enterprise.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Enterprise.sxmon == '1' if aptitude == '山西民营100强' else text(''),
            Enterprise.zjtg == '1' if aptitude == '山西专精特新企业' else text(''),
            Enterprise.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Enterprise.dengl == '1' if aptitude == '瞪羚' else text(''),
            Enterprise.isfive == '1' if aptitude == '中国500强' else text(''),
            Enterprise.scale == '1' if aptitude == '规模以上企业' else text(''),
            Enterprise.serve == '1' if aptitude == '限额以上服务业' else text(''),
        ))
        size = enterprise_obj.count()

        enterprise_obj_list = enterprise_obj.paginate(page, per_page).items
        data = [{
            "id": enterprise_obj.id,
            "enterprise_name": enterprise_obj.enterprise_name,
            "district": enterprise_obj.district,
            "entype": enterprise_obj.entype,
            "aptitude": ["高新技术企业" if enterprise_obj.high_new == '1' else
                         "科技型中小企业" if enterprise_obj.tbe == '1' else
                         "上市企业" if enterprise_obj.quoted_company == '1' else
                         "山西民营100强" if enterprise_obj.sxmon == '1' else
                         "山西专精特新企业" if enterprise_obj.zjtg == '1' else
                         "独角兽企业" if enterprise_obj.unicorn == '1' else
                         "瞪羚企业" if enterprise_obj.dengl == '1' else
                         "中国500强" if enterprise_obj.isfive == '1' else
                         "规模以上企业" if enterprise_obj.scale == '1' else
                         "限额以上服务业" if enterprise_obj.serve == '1' else '']
        } for enterprise_obj in enterprise_obj_list]
        data = {"size": size, "df": data}

        return jsonify(code=RET.OK, data=data, msg='查询成功。')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='查询出错！')


def get_enterprise_num(product, inid):
    indu_obj_li = get_product_li(product, inid)
    # total_enterprise_num = 0
    company = []
    for indu_name in indu_obj_li:
        # indu_name = indu_obj.industry_name
        # print("正在查询【{}】的相关企业......".format(indu_name))
        company1 = Enterprise.query.filter(
            Enterprise.c_type == inid,
            Enterprise.product_all.like("%{}%".format(indu_name))
        ).all()
        company += company1
        # print(company1)
        company2 = Enterprise.query.filter(
            Enterprise.c_type1 == inid,
            Enterprise.product_all1.like("%{}%".format(indu_name))
        ).all()
        company += company2
        # print(company2)
        company3 = Enterprise.query.filter(
            Enterprise.c_type2 == inid,
            Enterprise.product_all2.like("%{}%".format(indu_name))
        ).all()
        company += company3
        # print("产品【{}】已完成, 共有{}家相关企业。".format(indu_name, len(company1 + company2 + company3)))

    company = set(company)  # 去重
    size = len(company)
    return company, size


# 全国企业列表
@api_map.route('/AttractEnterprise', methods=['POST'])
def attract_enterprise():
    '''
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    company_name = req_dict.get("company_name")  # 产业产品名称筛选
    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    quoted = req_dict.get("quoted")  # 上市板块（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)
    product = req_dict.get("product")  # 产业产品选择

    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    name_query = "AttractEnterprise" + str(inid) + str(page) + province + city + district + \
                 product + company_name + entype + qualificat + quoted + product
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)

    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        enterprise = Enterprise.query.filter(or_(
            Enterprise.c_type == inid,
            Enterprise.c_type1 == inid,
            Enterprise.c_type2 == inid
        ))

        enterprise = enterprise.filter(
            # Enterprise.product_all.like("%{}%".format(product)) if product else text(''),
            Enterprise.entype.like('%{}%'.format(entype)) if entype else text(''),
            Enterprise.company_name.like('%{}%'.format(company_name)) if company_name else text(''),
            # Enterprise.c_type == inid if not product else text(''),
            Enterprise.public_id == quoted if quoted else text(''),
            Enterprise.province == province if province else text(''),
            Enterprise.city == city if city else text(''),
            Enterprise.district == district if district else text(''),
            Enterprise.isfive == '1' if qualificat == '中国500强企业' else text(''),
            Enterprise.quoted_company == '1' if qualificat == '上市企业' else text(''),
            Enterprise.chain_master == '1' if qualificat == '链主企业' else text(''),
            Enterprise.high_new == '1' if qualificat == '高新技术企业' else text(''),
            Enterprise.zjtg == '1' if qualificat == '山西专精特新企业' else text(''),
            Enterprise.unicorn == '1' if qualificat == '独角兽企业' else text(''),
            Enterprise.dengl == '1' if qualificat == '瞪羚企业' else text(''),
            Enterprise.tbe == '1' if qualificat == '科技型中小企业' else text(''),
            Enterprise.scale == '1' if qualificat == '规模以上企业' else text(''),
            Enterprise.sxonhun == '1' if qualificat == '山西100强企业' else text(''),
            Enterprise.serve == '1' if qualificat == '限额以上服务业企业' else text(''),
            Enterprise.patent == '1' if qualificat == '专利企业' else text('')
        )
        if product:
            company, size = get_enterprise_num(product, inid)
            company1 = sorted(company, key=lambda x: x.hots, reverse=True)  # 排序
            enterprise_obj_list = company1[(page - 1) * perpage:page * perpage]  # 分页
        else:
            size = enterprise.count()
            enterprise_obj_list = enterprise.order_by(Enterprise.hots.desc()).paginate(page, perpage).items

        df = [{"id": i.id,
               "company_name": i.company_name,
               "aptitude": list(filter(None, [
                   "中国500强" if i.isfive == '1' else '',
                   "上市企业" if i.quoted_company == '1' else '',
                   "链主企业" if i.chain_master == '1' else '',
                   "高新技术企业" if i.high_new == '1' else '',
                   "山西专精特新企业" if i.zjtg == '1' else '',
                   "独角兽企业" if i.unicorn == '1' else '',
                   "瞪羚企业" if i.dengl == '1' else '',
                   "科技型中小企业" if i.tbe == '1' else '',
                   "山西民营100强" if i.sxonhun == '1' else '',
                   "规模以上企业" if i.scale == '1' else '',
                   "限额以上服务业" if i.serve == '1' else '',

                   "专利企业" if i.patent == '1' else ''
               ]))
               } for i in enterprise_obj_list]
        data = {"size": size, "df": df}
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    # redis缓存
    try:
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except:
        return jsonify(code=RET.DBERR, msg="redis保存失败！")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 全国企业列表(Es)
@api_map.route('/AttractEnterpriseEs', methods=['POST'])
def attract_enterprise_es():
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    company_name = req_dict.get("company_name")  # 产业产品名称筛选
    entype = req_dict.get("entype")  # 企业类型id
    qualificat = req_dict.get("qualificat")  # 企业资质id
    quoted = req_dict.get("quoted")  # 上市板块（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)
    product = req_dict.get("product")  # 产业产品选择

    area = req_dict.get("area")  # ["省","市","区"]
    province = area[0]
    city = area[1]
    district = area[2]
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 页数
    if not page:
        page = 1
    page = int(page)
    page = (page - 1) * perpage

    args_query = dict()  # 查询字段
    args_term = dict()  # 条件字典

    args_query["company_name"] = "公司"
    # 搜索框
    if company_name:
        args_query["company_name"] = company_name

    if inid:
        args_term['c_type'] = inid

    if entype:
        args_term['entype'] = entype

    if quoted:
        args_term['public_id'] = quoted

    if product:
        args_term['product'] = product
    # 公司资质
    if qualificat:
        if qualificat == 1:
            args_term['isfive'] = 1
        if qualificat == 2:
            args_term['quoted_company'] = 1
        if qualificat == 3:
            args_term['fianacing'] = 1
        if qualificat == 4:
            args_term['high_new'] = 1
        if qualificat == 5:
            args_term['tbe'] = 1
        if qualificat == 6:
            args_term['dengl'] = 1
        if qualificat == 7:
            args_term['unicorn'] = 1
    # 省
    if province:
        args_term['province'] = province
    # 市
    if city:
        args_term['city'] = city
    # 区
    if district:
        args_term['district'] = district

    # # 成立时间
    # if yearid:
    #     args_term['yearid'] = yearid
    # # 融资轮次
    # if roundid:
    #     args_term['roundid'] = roundid
    # # 企业状态
    # if status:
    #     args_term['status'] = status
    # # 企业规模
    # if scale_range:
    #     args_term['scale_range'] = scale_range
    #     # 公司类型
    # if entypeid:
    #     args_term['entypeid'] = entypeid

    body = create_body(page, perpage, args_query, args_term)
    if not company_name:
        del body["query"]["bool"]["must"][0]

    try:
        es = Elasticsearch([{'host': '39.100.39.50', 'port': 9200}])

        # data = es.search(index="jincheng_pictext_index_202301131004_a6181e52", body=body)
        data = es.search(index="jincheng_pictext_index_202303161620_76c624b8", body=body)
        data_list = []
        # print(data_list)
        size = data["hits"]['total']

        # 数据的列表添加进去
        for i in data["hits"]['hits']:
            if company_name:
                # 判断高亮，然后添加
                data_list.append({
                    "id": i["_source"]["mysql_id"],
                    "company": i["highlight"]["company_name"][0] if "company_name" in i["highlight"] else i["_source"][
                        "company_name"],
                    "area": i["_source"]["province"] + i["_source"]["city"] + i["_source"]["district"],
                    "createtime": i["_source"]["build_date"],
                    "legal": i["_source"]["legal"],
                    "capital": i["_source"]["capital"],
                    "entype": i["_source"]["entype"],
                    "address": i["_source"]["address"],
                    "telephone": i["_source"]["telephone"],
                    "high_new": '高新技术企业' if i["_source"]["high_new"] == "1" else '',
                    "tbe": '科技型中小企业' if i["_source"]["tbe"] == "1" else '',
                    "fianacing": '融资企业' if i["_source"]["fianacing"] == "1" else '',
                    "quoted_company": '上市企业' if i["_source"]["quoted_company"] == "1" else '',
                    "dengl": '瞪羚企业' if i["_source"]["dengl"] == "1" else '',
                    "unicorn": '独角兽企业' if i["_source"]["unicorn"] == "1" else '',
                    "isfive": '500强企业' if i["_source"]["isfive"] == '1' else '',
                })
            else:
                data_list.append({
                    "id": i["_source"]["mysql_id"],
                    "company": i["_source"]["company_name"],
                    "area": i["_source"]["province"] + i["_source"]["city"] + i["_source"]["district"],
                    "createtime": i["_source"]["build_date"],
                    "legal": i["_source"]["legal"],
                    "capital": i["_source"]["capital"],
                    "entype": i["_source"]["entype"],
                    "address": i["_source"]["address"],
                    "telephone": i["_source"]["telephone"],
                    "high_new": '高新技术企业' if i["_source"]["high_new"] == "1" else '',
                    "tbe": '科技型中小企业' if i["_source"]["tbe"] == "1" else '',
                    "fianacing": '融资企业' if i["_source"]["fianacing"] == "1" else '',
                    "quoted_company": '上市企业' if i["_source"]["quoted_company"] == "1" else '',
                    "dengl": '瞪羚企业' if i["_source"]["dengl"] == "1" else '',
                    "unicorn": '独角兽企业' if i["_source"]["unicorn"] == "1" else '',
                    "isfive": '500强企业' if i["_source"]["isfive"] == '1' else '',
                })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="es数据库错误")
    data = {
        "data": data_list, "size": size
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)