import json
import requests
from flask import g, current_app, request, jsonify, session
from apps.view_atlas import api_atlas
from apps.util import login_required
from apps.utils.response_code import RET
from apps.utils.neo4j_conn import conn_neo4j
from ..models import Enterprise
from py2neo import Graph

graph = conn_neo4j()

# graph1 = Graph("http://39.100.39.50:7475", username="neo4j",
#                password="century-english-almanac-havana-golf-9040")  # 太原的neo4j,测试是借用


def deleteDuplicate(li):
    '''
    列表[字典]去重
    :param li:
    :return:
    '''
    temp_list = list(set([str(i) for i in li]))
    li = [eval(i) for i in temp_list]
    return li


def check(name):
    '''
    判断当前企业是否有上下游关系，True有、False无
    :param name: 节点名
    :return:
    '''
    # Cypher = "match (n)-[r]->(m) WHERE m.name='{}' or n.name='{}' return r.type".format(name, name)
    Cypher = "match (n)-[r]->(m) WHERE m.name='{}' or n.name='{}' return r.name".format(name, name)
    # res = graph1.run(Cypher).data()
    res = graph.run(Cypher).data()
    # res = list(set([i["r.type"] for i in res]))
    res = list(set([i["r.name"] for i in res]))
    if res.__contains__("上游行业") or res.__contains__("下游行业"):
        return True
    return False


# 根据企业查询产品
def body_by_companyName(company_name):
    '''
    :param company_name: 公司名
    :return:
    '''
    body = {
        "query": {
            "bool": {
                "must": [
                    {
                        "match": {
                            "company_name": "{}".format(company_name)
                        }
                    }
                ],
                "must_not": [],
                "should": []
            }
        },
        "sort": [],
        "aggs": {},
        "_source": ["product"]
    }

    return body


# 根据产品查询企业
def body_by_products(product):
    '''
    :param company_name: 公司名
    :return:
    '''
    body = {
        "query": {
            "bool": {
                "must": [
                    {
                        "match": {
                            "product": "{}".format(product)
                        }
                    }
                ],
                "must_not": [],
                "should": []
            }
        },
        "from": 0,
        "size": 20,  # 限制条数
        "sort": [],
        "aggs": {},
        "_source": ["company_name", "lng", "lat"]
    }

    return body


def trans_formet(name, list_data):
    '''
    :param name: str 要转换的主题name
    :param list_data: list 要转换的数据列表
    :return:
    '''
    for i in range(len(list_data)):
        if list_data[i]["bname"] != name:
            # if list_data[i]["r.type"] == "上游行业":
            if list_data[i]["r.name"] == "上游行业":
                list_data[i] = {
                    "source": name,
                    "relation": "下游行业",
                    "target": "{}".format(
                        list_data[i]["bname"])}
            # elif list_data[i]["r.type"] == "下游行业":
            elif list_data[i]["r.name"] == "下游行业":
                list_data[i] = {
                    "source": name,
                    "relation": "上游行业",
                    "target": "{}".format(
                        list_data[i]["bname"])}
        else:
            list_data[i] = {"source": "{}".format(list_data[i]["bname"]),
                            # "relation": "{}".format(list_data[i]["r.type"]),
                            "relation": "{}".format(list_data[i]["r.name"]),
                            "target": "{}".format(list_data[i]["sname"])}
    return list_data


def findCenterProducts(product_name):
    '''
    查找中间产品
    查询当前产品往上直到有上下游关系，并返回产品实体名称和关系名称的列表
    :param name: 产品名
    :return:
    '''
    if check(product_name):  # 直接关联上下游
        res = [product_name]
        return res
    else:
        # sql = "match (n)-[r]->(m) WHERE m.name='{}' return n.name,r.type".format(product_name)
        sql = "match (n)-[r]->(m) WHERE m.name='{}' return n.name,r.name".format(product_name)
        # print(sql)
        # res = graph1.run(sql).data()
        res = graph.run(sql).data()
        final_result = []  # 最终产品集
        for i in res:
            if check(i["n.name"]):  # 判断是否有上下游关系(添加到最终产品集)
                final_result.append(i["n.name"])
            else:
                result = findCenterProducts(i["n.name"])
                final_result.extend(result)
        if len(final_result) >= 1:
            return final_result
        else:
            return []


def offer_company(name):
    '''
    # 判断是否有供应商
    :param name: 产品实体
    :return:
    '''
    try:
        url = "http://127.0.0.1:9200/tychain/_search"  # 产品对企业
        # 1、根据公司查询产品
        body = body_by_products(name)
        result_es = json.loads(requests.post(url=url, json=body).text)
        if result_es["hits"]["total"] >= 1:
            return True
        return False
    except Exception as e:
        current_app.logger.error(e)
        return False


def findUpDownCompany(name_query, name):  # 对中间产品进行上下游产品查询
    '''
    :param name_query: 要查询的产品
    :param name: 中间产品
    :return:
    '''
    # sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname ".format(
    #     name, name, name, name)
    sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.name,m.name as sname ".format(
        name, name, name, name)
    # res_product = graph1.run(sql_all).data()
    res_product = graph.run(sql_all).data()
    res_product = trans_formet(name, res_product)
    nodes = []
    links = []
    # nodes.append({"id": "{}".format(item), "name": "{}↓".format(item), "category": "2"})
    # links.append({"from": "a", "to": "{}".format(item), "text": "产品"})
    for i in res_product:
        if offer_company(i["target"]):  # 判断是否有供应商
            nodes.append({"data": {"category": "3", "real_name": i["target"]}, "id": "{}".format(i["target"]),
                          "name": "{}↓".format(i["target"]), "category": "3"})
            links.append(
                {"from": "{}".format(name_query), "to": "{}".format(i["target"]), "text": "{}".format(i["relation"])})
            # if i["relation"] == "上游行业":
            # if i["source"] == name_query:
            #     nodes.append({"name": "{}↓".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
            #     links.append({"source": "{}↓".format(i["source"]), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
            # else:
            #     nodes.append({"name": "{}↓".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
            #     links.append({"source": "{}↓".format(name_query), "target": "{}↓".format( i["target"]), "name": "{}".format(i["relation"])})
            # elif i["relation"] == "下游行业":
            #     nodes.append({"id": "{}".format(i["target"]), "name": "{}↓".format(i["target"]), "category": "3"})
            #     links.append({"from": "{}".format(name_query), "to": "{}".format(i["target"]),"text": "{}".format(i["relation"])})
            # if i["source"] == name_query:
            #     nodes.append({"name": "{}↓".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
            #     links.append({"source": "{}↓".format(i["source"]), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
            # else:
            #     nodes.append({"name": "{}↓".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
            #     links.append({"source": "{}↓".format(name_query), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
        else:
            nodes.append({"data": {"category": "3", "real_name": i["target"]}, "id": "{}".format(i["target"]),
                          "name": "{}".format(i["target"]), "category": "3"})
            links.append(
                {"from": "{}".format(name_query), "to": "{}".format(i["target"]), "text": "{}".format(i["relation"])})
            # if i["relation"] == "上游行业":
            #     if i["source"] == name_query:
            #         nodes.append({"name": "{}".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
            #         links.append({"source": "{}↓".format(i["source"]), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
            #     else:
            #         nodes.append({"name": "{}".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
            #         links.append({"source": "{}↓".format(name_query), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
            # elif i["relation"] == "下游行业":
            #     if i["source"] == name_query:
            #         nodes.append({"name": "{}".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
            #         links.append({"source": "{}↓".format(i["source"]), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
            #     else:
            #         nodes.append({"name": "{}".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
            #         links.append({"source": "{}↓".format(name_query), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})

    return nodes, links


def findUDP(product_name):  # 对中间产品进行上下游产品查询
    '''
    :param name_query: 要查询的产品
    :param name: 中间产品
    :return:
    '''
    # sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
    #           "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname ".format(
    #     product_name, product_name, product_name, product_name)
    sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.name,m.name as sname UNION " \
              "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.name,m.name as sname ".format(
        product_name, product_name, product_name, product_name)
    # res_product = graph1.run(sql_all).data()
    res_product = graph.run(sql_all).data()
    res_product = trans_formet(product_name, res_product)
    products = list()
    for i in res_product:
        products.append(i["target"])
    return products


# 获取供应链图谱 查询企业接口
@api_atlas.route("/SupplyChain/FindZero", methods=['POST'])
def find_zero():
    try:
        get_data = request.get_json()
        name = get_data.get('company_name')
        result = {

            "nodes": [
                {"data": {"category": "1", "real_name": name}, "id": "a", "name": "{}↓".format(name), "category": "1"}],
            "links": [],
            "rootId": 'a'
        }
        return jsonify(code=RET.OK, msg="获取成功", data=result)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常", data={})


# 获取供应链图谱 查询企业的产品接口
@api_atlas.route("/SupplyChain/FindNext", methods=['POST'])
def find_next():
    req_dict = request.get_json()
    name = req_dict.get('name')  # 名称
    # id = req_dict.get("id")  # id
    category = req_dict.get("category")
    # 检查参数的完整性
    if not all([name, category]):
        return jsonify(code=RET.DATAERR, msg="参数不完整")
    try:
        if category == "1":  # 查询企业的产品
            url = "http://39.100.39.50:9200/jc_supply_chain1/_search"  # 产品对企业
            # 1、根据公司查询产品
            body = body_by_companyName(name)
            result_es = json.loads(requests.post(url=url, json=body).text)
            res = list(set([i["_source"]["product"] for i in result_es["hits"]["hits"]]))
            if res:
                nodes = list()
                links = list()
                result = dict()
                products = list(set(res))
                for item in products:
                    # nodes.append({"id": "{}".format(item), "name": "{}↓".format(item), "category": "2"})
                    nodes.append({"data": {"category": "2", "real_name": item}, "id": "{}".format(item),
                                  "name": "{}↓".format(item), "category": "2"})
                    links.append({"from": "a", "to": "{}".format(item), "text": "产品"})
                result["nodes"] = nodes
                result["links"] = links
                return jsonify(code=RET.OK, msg="获取成功", data=result)
            else:
                return jsonify(code=RET.NODATA, msg="无数据", data={})
        elif category == "2":  # 根据产品查询上下游产品
            nodes = list()
            links = list()
            center_product = findCenterProducts(name)  # 获取中间产品
            for udp in center_product:
                # findUpDownCompany(udp) # 获取上下游行业
                antity, relation = findUpDownCompany(name, udp)  # 获取上下游行业
                nodes.extend(antity)
                links.extend(relation)
            nodes = deleteDuplicate(nodes)
            links = deleteDuplicate(links)
            result = {
                "nodes": nodes,
                "links": links
            }
            return jsonify(code=RET.OK, msg="获取成功", data=result)
        elif category == "3":  # 产品查询供应商
            url = "http://39.100.39.50:9200/jc_supply_chain1/_search"
            body = body_by_products(name)
            companys_return = json.loads(requests.post(url=url, json=body).text)
            res = [i["_source"]["company_name"] for i in companys_return["hits"]["hits"]]
            if res:
                nodes = list()
                links = list()
                result = dict()
                products = list(set(res))
                for item in products:
                    nodes.append({"data": {"category": "4", "real_name": item}, "id": "{}".format(item),
                                  "name": "{}".format(item), "category": "4"})
                    links.append({"from": "{}".format(name), "to": "{}".format(item), "text": "{}".format("供应商企业")})
                result["nodes"] = nodes
                result["links"] = links
                return jsonify(code=RET.OK, msg="获取成功", data=result)
            else:
                return jsonify(code=RET.NODATA, msg="无数据")
        else:
            return jsonify(code=RET.NODATA, msg="无数据")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常", data={})


# 企业供应链地图
@api_atlas.route("/SupplyChain/Map", methods=['POST'])
def get_semic_map():
    try:
        res = request.get_json()
        company_name = res.get('company_name').strip()
        c_type = res.get('c_type')
        url = "http://39.100.39.50:9200/jc_supply_chain1/_search"  # 产品对企业
        # 1、根据公司查询产品
        body = body_by_companyName(company_name)
        result_es = json.loads(requests.post(url=url, json=body).text)
        try:
            products = list(set([i["_source"]["product"] for i in result_es["hits"]["hits"]]))  # 无需去重，最终数据不会出现重复项
        except:
            return jsonify(code=RET.NODATA, msg="无相关供应链地图数据！")

        # print("直接产品:", products)
        # 2、查询上下游产品
        products_center = list()
        for product_name in products:
        # for product_name in ['地铁运营', '轨道交通装备']:
            products_center.extend(findCenterProducts(product_name))  # 查找中间产品
        products_uad = list()
        for product_name in products_center:
            products_uad.extend(findUDP(product_name))  # 对中间产品进行上下游产品查询
        products_uad = list(set(products_uad))

        # print("中间产品：", products_uad)
        # 3、根据产品进行供应商及其经纬度查询
        companys = list()
        for pro in products_uad:
            body = body_by_products(pro)
            companys_return = json.loads(requests.post(url=url, json=body).text)
            companys.extend([i["_source"] for i in companys_return["hits"]["hits"]])

        data = {}
        supplier = list()
        if companys:
            for item in companys:
                supplier.append({"name": item["company_name"],
                                 "value": [item["lng"], item["lat"]]
                                 })
        # 获取本公司的经纬度
        enterprise = Enterprise.query.filter_by(company_name=company_name).first()
        enterprise_lng = enterprise.lng
        enterprise_lat = enterprise.lat
        data['SupplyEnterprise'] = [{'name': company_name, "value": [enterprise_lng, enterprise_lat]}]
        data['supplier'] = supplier
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.PARAMERR, msg="参数错误")


# def deleteDuplicate(li):
#     '''
#     列表[字典]去重
#     :param li:
#     :return:
#     '''
#     temp_list = list(set([str(i) for i in li]))
#     li = [eval(i) for i in temp_list]
#     return li
#
#
# def check(name):
#     '''
#     判断当前企业是否有上下游关系，True有、False无
#     :param name: 节点名
#     :return:
#     '''
#     Cypher = "match (n)-[r]->(m) WHERE m.name='{}' or n.name='{}' return r.type".format(name, name)
#     res = graph.run(Cypher).data()
#     res = list(set([i["r.type"] for i in res]))
#     if res.__contains__("上游行业") or res.__contains__("下游行业"):
#         return True
#     return False
#
#
# # 根据企业查询产品
# def body_by_companyName(company_name):
#     '''
#     :param company_name: 公司名
#     :return:
#     '''
#     body = {
#         "query": {
#             "bool": {
#                 "must": [
#                     {
#                         "match": {
#                             "company_name": "{}".format(company_name)
#                         }
#                     }
#                 ],
#                 "must_not": [],
#                 "should": []
#             }
#         },
#         "sort": [],
#         "aggs": {},
#         "_source": ["product"]
#     }
#
#     return body
#
#
# # 根据产品查询企业
# def body_by_products(product):
#     '''
#     :param company_name: 公司名
#     :return:
#     '''
#     body = {
#         "query": {
#             "bool": {
#                 "must": [
#                     {
#                         "match": {
#                             "product": "{}".format(product)
#                         }
#                     }
#                 ],
#                 "must_not": [],
#                 "should": []
#             }
#         },
#         "from": 0,
#         "size": 20,  # 限制条数
#         "sort": [],
#         "aggs": {},
#         "_source": ["company_name", "lng", "lat"]
#     }
#
#     return body
#
#
# def trans_formet(name, list_data):
#     '''
#     :param name: str 要转换的主题name
#     :param list_data: list 要转换的数据列表
#     :return:
#     '''
#     for i in range(len(list_data)):
#         if list_data[i]["bname"] != name:
#             if list_data[i]["r.type"] == "上游行业":
#                 list_data[i] = {
#                     "source": name,
#                     "relation": "下游行业",
#                     "target": "{}".format(
#                         list_data[i]["bname"])}
#             elif list_data[i]["r.type"] == "下游行业":
#                 list_data[i] = {
#                     "source": name,
#                     "relation": "上游行业",
#                     "target": "{}".format(
#                         list_data[i]["bname"])}
#         else:
#             list_data[i] = {"source": "{}".format(list_data[i]["bname"]),
#                             "relation": "{}".format(list_data[i]["r.type"]),
#                             "target": "{}".format(list_data[i]["sname"])}
#     return list_data
#
#
# def findCenterProducts(name):
#     '''
#     查找中间产品
#     查询当前产品往上直到有上下游关系，并返回产品实体名称和关系名称的列表
#     :param name: 产品名
#     :return:
#     '''
#     if check(name):  # 直接关联上下游
#         res = [name]
#         return res
#     else:
#         sql = "match (n)-[r]->(m) WHERE m.name='{}' return n.name,r.type".format(name)
#         # print(sql)
#         res = graph.run(sql).data()
#         final_result = []  # 最终产品集
#         for i in res:
#             if check(i["n.name"]):  # 判断是否有上下游关系(添加到最终产品集)
#                 final_result.append(i["n.name"])
#             else:
#                 result = findCenterProducts(i["n.name"])
#                 final_result.extend(result)
#         if len(final_result) >= 1:
#             return final_result
#         else:
#             return []
#
#
# def offer_company(name):
#     '''
#     # 判断是否有供应商
#     :param name: 产品实体
#     :return:
#     '''
#     try:
#         url = "http://127.0.0.1:9200/tychain/_search"  # 产品对企业
#         # 1、根据公司查询产品
#         body = body_by_products(name)
#         result_es = json.loads(requests.post(url=url, json=body).text)
#         if result_es["hits"]["total"] >= 1:
#             return True
#         return False
#     except Exception as e:
#         current_app.logger.error(e)
#         return False
#
#
# def findUpDownCompany(name_query, name):  # 对中间产品进行上下游产品查询
#     '''
#     :param name_query: 要查询的产品
#     :param name: 中间产品
#     :return:
#     '''
#     sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname ".format(
#         name, name, name, name)
#
#     res_product = graph.run(sql_all).data()
#     res_product = trans_formet(name, res_product)
#     nodes = []
#     links = []
#     # nodes.append({"id": "{}".format(item), "name": "{}↓".format(item), "category": "2"})
#     # links.append({"from": "a", "to": "{}".format(item), "text": "产品"})
#     for i in res_product:
#         if offer_company(i["target"]):  # 判断是否有供应商
#             nodes.append({"id": "{}".format(i["target"]), "name": "{}↓".format(i["target"]), "category": "3"})
#             links.append(
#                 {"from": "{}".format(name_query), "to": "{}".format(i["target"]), "text": "{}".format(i["relation"])})
#             # if i["relation"] == "上游行业":
#             # if i["source"] == name_query:
#             #     nodes.append({"name": "{}↓".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #     links.append({"source": "{}↓".format(i["source"]), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
#             # else:
#             #     nodes.append({"name": "{}↓".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #     links.append({"source": "{}↓".format(name_query), "target": "{}↓".format( i["target"]), "name": "{}".format(i["relation"])})
#             # elif i["relation"] == "下游行业":
#             #     nodes.append({"id": "{}".format(i["target"]), "name": "{}↓".format(i["target"]), "category": "3"})
#             #     links.append({"from": "{}".format(name_query), "to": "{}".format(i["target"]),"text": "{}".format(i["relation"])})
#             # if i["source"] == name_query:
#             #     nodes.append({"name": "{}↓".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #     links.append({"source": "{}↓".format(i["source"]), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
#             # else:
#             #     nodes.append({"name": "{}↓".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #     links.append({"source": "{}↓".format(name_query), "target": "{}↓".format(i["target"]), "name": "{}".format(i["relation"])})
#         else:
#             nodes.append({"id": "{}".format(i["target"]), "name": "{}".format(i["target"]), "category": "3"})
#             links.append(
#                 {"from": "{}".format(name_query), "to": "{}".format(i["target"]), "text": "{}".format(i["relation"])})
#             # if i["relation"] == "上游行业":
#             #     if i["source"] == name_query:
#             #         nodes.append({"name": "{}".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #         links.append({"source": "{}↓".format(i["source"]), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
#             #     else:
#             #         nodes.append({"name": "{}".format(i["target"]), "category": 3, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #         links.append({"source": "{}↓".format(name_query), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
#             # elif i["relation"] == "下游行业":
#             #     if i["source"] == name_query:
#             #         nodes.append({"name": "{}".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #         links.append({"source": "{}↓".format(i["source"]), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
#             #     else:
#             #         nodes.append({"name": "{}".format(i["target"]), "category": 4, "name_query": "{}".format(i["target"]), "isclick": 0})
#             #         links.append({"source": "{}↓".format(name_query), "target": "{}".format(i["target"]), "name": "{}".format(i["relation"])})
#
#     return nodes, links
#
#
# def findUDP(name):  # 对中间产品进行上下游产品查询
#     '''
#     :param name_query: 要查询的产品
#     :param name: 中间产品
#     :return:
#     '''
#     sql_all = "match (n) -[r:`下游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`上游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`上游行业`]->(m) WHERE n.name='{}' return n.name as bname,r.type,m.name as sname UNION " \
#               "match (n) -[r:`下游行业`]->(m) WHERE m.name='{}' return n.name as bname,r.type,m.name as sname ".format(
#         name, name, name, name)
#     res_product = graph.run(sql_all).data()
#     res_product = trans_formet(name, res_product)
#     products = list()
#     for i in res_product:
#         products.append(i["target"])
#     return products
#
#
# @api_atlas.route("/SupplyChain/FindZero", methods=['POST'])
# def find_zero():
#     try:
#         get_data = request.get_json()
#         name = get_data.get('company_name')
#         result = {
#             "nodes": [{"id": "a", "nickname": "{}".format(name), "name": "{}↓".format(name), "category": "1"}],
#             "links": [],
#             "rootId": 'a'
#         }
#         return jsonify(code=RET.OK, msg="获取成功", data=result)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常", data={})
#
#
# @api_atlas.route("/SupplyChain/FindNext", methods=['POST'])
# def find_next():
#     req_dict = request.get_json()
#     name = req_dict.get('name')  # 名称
#     # id = req_dict.get("id")  # id
#     category = req_dict.get("category")
#     # 检查参数的完整性
#     if not all([name, category]):
#         return jsonify(code=RET.DATAERR, msg="参数不完整")
#
#     try:
#         if category == "1":  # 查询企业的产品
#             url = "http://39.100.39.50:9200/jc_supply_chain/_search"  # 产品对企业
#             # 1、根据公司查询产品
#             body = body_by_companyName(name)
#             result_es = json.loads(requests.post(url=url, json=body).text)
#             res = list(set([i["_source"]["product"] for i in result_es["hits"]["hits"]]))
#             if res:
#                 nodes = list()
#                 links = list()
#                 result = dict()
#                 products = list(set(res))
#                 for item in products:
#                     nodes.append({"id": "{}".format(item), "nickname": "{}".format(item), "name": "{}↓".format(item), "category": "2"})
#                     links.append({"from": "a", "to": "{}".format(item), "text": "产品"})
#                 result["nodes"] = nodes
#                 result["links"] = links
#                 return jsonify(code=RET.OK, msg="获取成功", data=result)
#             else:
#                 return jsonify(code=RET.NODATA, msg="无数据", data={})
#         elif category == "2":  # 根据产品查询上下游产品
#             nodes = list()
#             links = list()
#             center_product = findCenterProducts(name)  # 获取中间产品
#             for udp in center_product:
#                 # findUpDownCompany(udp) # 获取上下游行业
#                 antity, relation = findUpDownCompany(name, udp)  # 获取上下游行业
#                 nodes.extend(antity)
#                 links.extend(relation)
#             nodes = deleteDuplicate(nodes)
#             links = deleteDuplicate(links)
#             result = {
#                 "nodes": nodes,
#                 "links": links
#             }
#             return jsonify(code=RET.OK, msg="获取成功", data=result)
#         elif category == "3":  # 产品查询供应商
#             url = "http://39.100.39.50:9200/jc_supply_chain/_search"
#             body = body_by_products(name)
#             companys_return = json.loads(requests.post(url=url, json=body).text)
#             res = [i["_source"]["company_name"] for i in companys_return["hits"]["hits"]]
#             if res:
#                 nodes = list()
#                 links = list()
#                 result = dict()
#                 products = list(set(res))
#                 for item in products:
#                     nodes.append({"id": "{}".format(item), "nickname": "{}".format(item), "name": "{}".format(item), "category": "4"})
#                     links.append({"from": "{}".format(name), "to": "{}".format(item), "text": "{}".format("供应商企业")})
#                 result["nodes"] = nodes
#                 result["links"] = links
#                 return jsonify(code=RET.OK, msg="获取成功", data=result)
#             else:
#                 return jsonify(code=RET.NODATA, msg="无数据")
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据异常", data={})
#
#
# # 企业供应链地图
# @api_atlas.route("/SupplyChain/Map", methods=['POST'])
# def get_semic_map():
#     try:
#         res = request.get_json()
#         company_name = res.get('company_name').strip()
#         c_type = res.get('c_type')
#         url = "http://39.100.39.50:9200/jc_supply_chain/_search"  # 产品对企业
#         # 1、根据公司查询产品
#         body = body_by_companyName(company_name)
#         result_es = json.loads(requests.post(url=url, json=body).text)
#         products = list(set([i["_source"]["product"] for i in result_es["hits"]["hits"]]))  # 无需去重，最终数据不会出现重复项
#         # print("直接产品:", products)
#         # 2、查询上下游产品
#         products_center = list()
#         for i in products:
#             products_center.extend(findCenterProducts(i))
#         products_uad = list()
#         for j in products_center:
#             products_uad.extend(findUDP(j))
#         products_uad = list(set(products_uad))
#
#         # print("中间产品：", products_uad)
#         # 3、根据产品进行供应商及其经纬度查询
#         companys = list()
#         for pro in products_uad:
#             body = body_by_products(pro)
#             companys_return = json.loads(requests.post(url=url, json=body).text)
#             companys.extend([i["_source"] for i in companys_return["hits"]["hits"]])
#
#         data = list()
#         if companys:
#             for item in companys:
#                 data.append({"name": item["company_name"],
#                              "jwd": {"lng": item["lng"],  # 园区地址出的经纬度
#                                      "lat": item["lat"]}
#                              })
#
#         return jsonify(code=RET.OK, msg="获取成功", data=data)
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code=RET.PARAMERR, msg="参数错误")
