from flask import current_app, request, jsonify
from sqlalchemy import or_

from apps.view_atlas import api_atlas
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
from apps import redis_store
import json

graph = conn_neo4j()

'''行业名转换ptp字典两个  neo4j_dict  line 164/177'''


def deleteDuplicate(li):
    '''列表[字典]去重'''
    temp_list = list(set([str(i) for i in li]))
    li = [eval(i) for i in temp_list]
    return li


def find_up_thr(name_query, relation):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    # 零级，上中下三游
    data = {
        "node": "{}".format(relation[:2]),
        "level": 1,
        "subNodeList": [],
    }
    sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res_zero = graph.run(sql_01).data()
    res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
    for it in res_one:  # 一级节点
        pname_one = it
        # 一级
        node_one = {
            "node": "{}".format(pname_one),
            "level": 2,
            "subNodeList": []
        }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
        result = graph.run(sql_02).data()
        result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
        for item in result:
            pname_two = item
            # 二级
            node_two = {
                "node": "{}".format(pname_two),
                "level": 3,
                "subNodeList": []
            }
            sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
            result3 = graph.run(sql_03).data()
            result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
            for itm in result3:
                pname_thr = itm
                # 三级
                node_thr = {
                    "node": "{}".format(pname_thr),
                    "level": 4,
                    "subNodeList": []
                }
                node_two["subNodeList"].append(node_thr)
            node_one["subNodeList"].append(node_two)
        data["subNodeList"].append(node_one)
    return data


# 获取产业集群名称
@api_atlas.route('/industry/cluster', methods=['GET'])
@login_required
def get_cluster():
    try:
        cluster_obj = IndustryChain.query.filter_by(industry_type=0, status=1).all()
        data = [{"id": i.id, 'name': i.industry_name, 'industry_level': 1,
                 "icon": i.icon_url, "icon1": i.icon_url1}
                for i in cluster_obj]

        return jsonify(code=RET.OK, msg='产业集群名称获取成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 获取新表的产业集群名称
@api_atlas.route('/IndustryCluster', methods=['POST'])
def industry_cluster():
    req_dic = request.get_json()
    industry_name = req_dic['industry_name']
    flag = req_dic['flag']

    try:
        industry_obj = IndustryChain.query.filter_by(industry_name=industry_name).first()
        industry_id = industry_obj.id
        chain_id = industry_obj.chain_id

        if flag == 2:
            # 查询redis
            result = redis_store.get('chain_id_{}'.format(industry_id))
            if result:
                return jsonify(code=RET.OK, msg="获取成功", data=json.loads(result))
        result = {
            "industryChain": industry_name,
            "nodeList": [find_up_thr1(chain_id, 1, industry_id, flag),
                         find_up_thr1(chain_id, 2, industry_id, flag),
                         find_up_thr1(chain_id, 3, industry_id, flag)]
        }
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    if flag == 2:
        try:
            redis_store.setex("chain_id_%s" % industry_id, constants.INDUSTRY_ENTERPRISE_REDIS_EXPIRES,
                              json.dumps(result))
            # 保存发送给这个手机号的记录，防止用户在60s内再次出发发送短信的操作
            # redis_store.setex("send_sms_code_%s" % mobile, constants.SEND_SMS_CODE_INTERVAL, 1)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="保存产业/企业数量信息异常")

    return jsonify(code=RET.OK, msg="获取成功", data=result)


# def get_count(industry_id, chain_name, flag):
#     company_count = ''
#     if flag == 1:  # 晋城
#         if chain_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
#                                  "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
#                                  "现代服务业", "数字经济", "文化旅游"]:
#             company_count = Company.query.filter(
#                 # Company.product_all.like('%{}%'.format(chain_name)),
#                 Company.c_type == industry_id
#             ).count()
#         else:
#             company_count = Company.query.filter(
#                 Company.product_all.like('%{}%'.format(chain_name)),
#                 Company.c_type == industry_id,
#             ).count()
#     if flag == 2:  # 全国
#         if chain_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
#                           "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
#                           "现代服务业", "数字经济", "文化旅游"]:
#             company_count = Enterprise.query.filter(
#                 # Enterprise.product_all.like('%{}%'.format(chain_name)),
#                 Enterprise.c_type == industry_id
#             ).count()
#         else:
#             company_count = Enterprise.query.filter(
#                 Enterprise.product_all.like('%{}%'.format(chain_name)),
#                 Enterprise.c_type == industry_id,
#             ).count()
#     return company_count
def get_count(chain_id, industry_id, chain_name, flag):
    company_count = ''
    id_list = []
    if flag == 1:  # 晋城
        # company_count = Company.query.filter(
        #     Company.product_all.like('%{}%'.format(chain_name)),
        #     Company.c_type == chain_id,
        # ).count()
        company_obj_li = Company.query.filter(
            Company.product_all.like('%{}%'.format(chain_name)),
            Company.c_type == chain_id,
        ).all()

        # 企业id列表，用于一级产业的企业数量去重
        id_list = [company_obj.id for company_obj in company_obj_li]
        company_count = len(company_obj_li)

    if flag == 2:  # 全国
        chain_obj = IndustryChain.query.filter(
            IndustryChain.industry_name == chain_name,
            IndustryChain.chain_id == chain_id,
        ).first()
        company_count = chain_obj.enterprise_num
    return id_list, company_count


# def find_up_thr1(industry_type, industry_id):
#     # relation 1为上游，2为中游，3为下游
#     relation = ''
#     if industry_type == 1:
#         relation = '上游'
#     if industry_type == 2:
#         relation = '中游'
#     if industry_type == 3:
#         relation = '下游'
#
#     # 零级，上中下三游
#     data = {
#         "node": "{}".format(relation),
#         "level": 1,
#         "subNodeList": [],
#     }
#
#     # 获取一级节点
#     chain_one_obj_list = IndustryChain.query.filter_by(industry_type=industry_type,
#                                                        relate_id=industry_id).all()
#     res_one = [{"chain_name": chain_one_obj.industry_name,
#                 "chain_name_id": chain_one_obj.id
#                 } for chain_one_obj in chain_one_obj_list]
#     for pname_one in res_one:  # 一级节点
#         chain_name = pname_one["chain_name"]
#         total_count = 0
#
#         # 一级的企业数量
#         company_count = get_count(chain_name)
#         total_count += company_count
#         # 一级
#         node_one = {
#             "node": "{}".format(chain_name),
#             "level": 2,
#             "company_count": total_count,
#             "subNodeList": []
#         }
#         # 获取二级节点
#         chain_two_obj_list = IndustryChain.query.filter_by(relate_id=pname_one["chain_name_id"]).all()
#         res_two = [{"chain_name": chain_two_obj.industry_name,
#                     "chain_name_id": chain_two_obj.id
#                     } for chain_two_obj in chain_two_obj_list]
#
#         for item in res_two:
#             pname_two = item
#             chain_name = pname_two["chain_name"]
#             company_count = get_count(chain_name)
#             total_count += company_count
#
#             # 二级
#             node_two = {
#                 "node": "{}".format(chain_name),
#                 "level": 3,
#                 "company_count": company_count,
#                 "subNodeList": []
#             }
#             # 获取第三级节点
#             chain_three_obj_list = IndustryChain.query.filter_by(relate_id=pname_two["chain_name_id"]).all()
#             res_three = [{"chain_name": chain_three_obj.industry_name,
#                           "chain_name_id": chain_three_obj.id
#                           } for chain_three_obj in chain_three_obj_list]
#             for itm in res_three:
#                 pname_thr = itm
#                 chain_name = pname_thr["chain_name"]
#                 company_count = get_count(chain_name)
#                 total_count += company_count
#
#                 # 三级
#                 node_thr = {
#                     "node": "{}".format(chain_name),
#                     "level": 4,
#                     "company_count": company_count,
#                     "subNodeList": []
#                 }
#                 node_two["subNodeList"].append(node_thr)
#             node_one["subNodeList"].append(node_two)
#         data["subNodeList"].append(node_one)
#     return data
def find_up_thr1(chain_id, industry_type, industry_id, flag):
    # relation 1为上游，2为中游，3为下游
    relation = ''
    if industry_type == 1:
        relation = '上游'
    if industry_type == 2:
        relation = '中游'
    if industry_type == 3:
        relation = '下游'

    # 零级，上中下三游
    data = {
        "node": "{}".format(relation),
        "level": 1,
        "subNodeList": [],
    }

    # 获取一级节点
    chain_one_obj_list = IndustryChain.query.filter_by(industry_type=industry_type,
                                                       relate_id=industry_id).all()
    res_one = [{"chain_name": chain_one_obj.industry_name,
                "chain_name_id": chain_one_obj.id
                } for chain_one_obj in chain_one_obj_list]
    for pname_one in res_one:
        # 一级节点
        one_id_li = []

        chain_name1 = pname_one["chain_name"]
        if chain_name1 == '数字技术应用':
            print()
        # 一级的企业数量
        id_list, company_count = get_count(chain_id, industry_id, chain_name1, flag)
        one_id_li.extend(id_list)
        # 一级
        node_one = {
            "node": "{}".format(chain_name1),
            "level": 2,
            "company_count": 0,
            "enterprise_count": company_count,
            "subNodeList": []
        }
        # 获取二级节点
        chain_two_obj_list = IndustryChain.query.filter_by(relate_id=pname_one["chain_name_id"]).all()
        res_two = [{"chain_name": chain_two_obj.industry_name,
                    "chain_name_id": chain_two_obj.id
                    } for chain_two_obj in chain_two_obj_list]

        for pname_two in res_two:
            two_id_li = []
            chain_name2 = pname_two["chain_name"]
            id_list, company_count = get_count(chain_id, industry_id, chain_name2, flag)
            two_id_li.extend(id_list)
            one_id_li.extend(two_id_li)

            # 二级
            node_two = {
                "node": "{}".format(chain_name2),
                "level": 3,
                "company_count": len(set(two_id_li)),
                "enterprise_count": company_count,
                "subNodeList": []
            }
            # 获取第三级节点
            chain_three_obj_list = IndustryChain.query.filter_by(relate_id=pname_two["chain_name_id"]).all()
            res_three = [{"chain_name": chain_three_obj.industry_name,
                          "chain_name_id": chain_three_obj.id
                          } for chain_three_obj in chain_three_obj_list]
            for pname_thr in res_three:
                three_id_li = []
                chain_name3 = pname_thr["chain_name"]
                id_list, company_count, = get_count(chain_id, industry_id, chain_name3, flag)
                three_id_li.extend(id_list)
                two_id_li.extend(three_id_li)
                one_id_li.extend(two_id_li)

                # 三级
                node_thr = {
                    "node": "{}".format(chain_name3),
                    "level": 4,
                    "company_count": len(three_id_li),
                    "enterprise_count": company_count,
                    "subNodeList": []
                }
                node_two["subNodeList"].append(node_thr)
            node_two.update({"company_count": len(set(two_id_li))})
            node_one["subNodeList"].append(node_two)
        node_one.update({"company_count": len(set(one_id_li))})
        data["subNodeList"].append(node_one)
    return data


# 返回上中下游产业链数据接口
@api_atlas.route('/industry/chain', methods=['POST'])
@login_required
def industry_chain():
    '''
    行业id->行业链标题-》上中下游-》查询数值
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "jc" + str(inid) + str(district)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        # 行业使用名
        # industryName = Industry.query.filter_by(nid=inid).first().oname
        industryName = IndustryChain.query.filter_by(id=inid).first().industry_name
        ptp = neo4j_dict()
        if industryName in ptp:
            industryName = ptp[industryName]
        # print(industryName)
        result = {
            "industryChain": industryName,
            "nodeList": [find_up_thr(industryName, "上游行业"),
                         find_up_thr(industryName, "中游行业"),
                         find_up_thr(industryName, "下游行业")]
        }
        # redis缓存
        # redis_store.set(name_query, json.dumps(result))
        # redis_store.expire(name_query, 30 * 24 * 3600)
        # print("redis")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=result)


# 点击产业创新资源联动显示 innovation resource
@api_atlas.route('/innovate/resource', methods=['POST'])
def industry_resource():
    '''创新资源机构列表'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个"1",子行业"2"）

    select_flag = req_dict.get("select_flag")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([inid, industry_level, select_flag, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # name = Industry.query.filter_by(nid=inid).first().oname
    name = IndustryChain.query.filter_by(id=inid).first().industry_name

    if select_flag == 1:  # 高等院校
        try:
            if industry_level == 1:
                college = College.query.filter(College.navigat.like("%{}%".format(name)))
            # else:
            #     college = College.query.filter(College.navigat.like("%{}%".format(name)))
            size = college.count()
            college = college.paginate(page, perpage).items

            data = {"df": [{"id": i.id,
                            "name": i.name,
                            "admin": i.admin,
                            "buildate": i.buildate,
                            "charge": i.charge,
                            "cate": i.category,
                            "nature": i.nature,
                            "ccode": i.ccode,
                            "address": i.address,
                            "lng": i.lng,
                            "lat": i.lat,
                            } for i in college],
                    "size": size}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="参数错误")
    elif select_flag == 2:  # 科研机构
        if industry_level == 1:
            scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
        else:
            scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
        size = scientific.count()
        scientific = scientific.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "telephone": i.telephone,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address} for i in scientific],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    elif select_flag == 3:  # 创新平台3
        if industry_level == 1:
            lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        # else:
        #     lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        size = lab.count()
        lab = lab.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "cate": i.cate,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address,
                        "lng": i.lng,
                        "lat": i.lat
                        } for i in lab],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    else:
        return jsonify(code=RET.PARAMERR, msg="参数错误")


def get_data(name, industry_level, select_flag, page, perpage):
    try:
        if select_flag in [1, 2, 7]:  # 当选择行政区/园区时
            induzone = ''
            size = ''
            if select_flag == 1 and industry_level == 1:  # 当选择的是父产业的行政区时
                induzone = Induzone.query.filter(Induzone.cate.like('行政区'), Induzone.navigat.like("%{}%".format(name)))
                size = induzone.count()  # 分页总数
            elif select_flag == 2 and industry_level == 1:  # 当选择的是父产业的园区时
                induzone = Induzone.query.filter(Induzone.cate.like('产业园区'), Induzone.navigat.like("%{}%".format(name)))
                size = induzone.count()  # 分页总数
            elif select_flag == 7 and industry_level == 1:  # 当选择的是开发区时
                induzone = Induzone.query.filter(Induzone.cate.like('开发区'), Induzone.navigat.like("%{}%".format(name)))
                size = induzone.count()  # 分页总数
            induzone = induzone.paginate(page, perpage).items

            if select_flag == 1:
                # 封装行政区数据
                admin_data = {"admin_data": [{
                    "id": i.id,
                    "image": i.image,
                    "region": i.district,
                    "cate": i.cate,
                    "area": i.area,
                    "address": i.address,
                    "navigat": i.navigat,
                    "cluster": i.cluster,
                    "lng": i.lng,
                    "lat": i.lat,
                    "phone": i.phone,
                } for i in induzone],
                    "size": size,
                }
                return admin_data

            if select_flag in [2, 7]:
                # 封装园区数据
                garden_data = {"garden": [{"id": i.id,
                                           "image": i.image,
                                           "name": i.name,  # 园区名称
                                           "region": i.district,  # 所属地区
                                           "area": i.area,
                                           "phone": i.phone,  # 联系电话
                                           "level": i.level,  # 园区级别
                                           "navigat": i.navigat,
                                           "cate": i.cate,  # 园区类型
                                           "address": i.address,
                                           "lng": i.lng,
                                           "lat": i.lat,
                               } for i in induzone],
                               "size": size}
                return garden_data
    except Exception as e:
        # print(e)
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 产业载体
@api_atlas.route('/carrier/zaiti', methods=['POST'])
def industry_zaiti():
    '''产业载体数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个"1",子行业"2"）
    select_flag = req_dict.get("select_flag")  # 1行政区，2园区，3产业载体，
    # 4土地，5楼宇，6厂房，7开发区
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # if inid:
    # name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
    name = IndustryChain.query.filter_by(id=inid).first().industry_name

    try:
        data = get_data(name, industry_level, select_flag, page, perpage)
        return jsonify(code=RET.OK, msg="数据查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)


#  产业政策
@api_atlas.route('/industry/indus_policy', methods=['POST'])
def industry_policy():
    """产业政策数据"""
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个1,子行业2）
    policy_level = req_dict.get("policy_level")  # 政策等级，（国家级1，省级2，市级3，区县4，开发区5）
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    policy_type = req_dict.get("policy_type")  # 政策类型，全国、国务院
    policy_year = req_dict.get("policy_year")  # 政策年份
    policy_name = req_dict.get("policy_name")  # 政策名称
    token = request.headers["token"]
    user_obj = verify_token(token)
    # if not user_obj:
    #     return jsonify(code=RET.SESSIONERR, msg='用户未登录。')
    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        indu_policy = ''
        size = ''
        name = ''
        if inid:
            name = IndustryChain.query.filter_by(id=inid).first().industry_name  # 获取导航对应的真名
        # name = '煤层气'
        # print(name)
        if industry_level == 1:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "国家级",

                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "省级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "市级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "区县",
                    InduPolicy.district == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "开发区",
                    InduPolicy.district == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            else:
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    # InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    # InduPolicy.district == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items

        if industry_level == 2:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "省级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "市级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "区县",
                    InduPolicy.district == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    InduPolicy.level == "开发区",
                    InduPolicy.district == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            else:
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)) if name else text(''),
                    # InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type != '全部' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    # 封装政策数据
    policy_data = []
    data = {}
    for i in indu_policy:
        is_collect = ''
        if user_obj:  # 涉及小程序
            if i in user_obj.industry_policy:
                is_collect = 'True'
            else:
                is_collect = 'False'

        policy_data.append({
            "id": i.id,
            "name": i.name,
            "org": i.org,
            "file": i.file,
            "is_collect": is_collect,
            "pubdate": (i.pubdate).strftime("%Y-%m-%d"),
        })
    data.update({"size": size})
    data.update({"policy_data": policy_data})
    return jsonify(code=RET.OK, msg="政策数据查询成功", data=data)


# 产业政策详情信息-复用招商驾驶舱政策详情接口


# 骨干企业详情信息


# 创新资源-高等院校详情
@api_atlas.route('/innovate/college_detail', methods=['POST'])
def get_college_detail():
    req_dict = request.get_json()
    college_id = req_dict.get('id')
    try:
        college = College.query.filter_by(id=college_id).first()
        # 封装院校数据
        data = {
            "name": college.name,  # 校名
            "charge": college.charge,  # 主管部门
            "buildate": college.buildate,  # 创办时间
            "nature": college.nature,  # 办学性质
            "clas": college.clas,  # 学校类别
            "address": college.address,  # 校址
            "introduct": college.introduct,  # 简介
            "ccode": college.ccode,  # 学校代码
            "feature": college.feature,  # 学校特色
            "research": college.research,  # 研究方向
            "major": college.major,
            "faculty": college.faculty,
            "lng": college.lng,  # 经度
            "lat": college.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='院校详情查询成功！', data=data)

    except Exception as e:
        current_app.logger.error(e)


# 创新资源-科研机构详情
@api_atlas.route('/innovate/scientific_detail', methods=['POST'])
def get_scientific_detail():
    req_dict = request.get_json()
    scientific_id = req_dict.get('id')
    try:
        scientific = Scientific.query.filter_by(id=scientific_id).first()
        # 封装科研机构数据
        data = {
            "name": scientific.name,  # 名称
            "admin": scientific.admin,  # 行政区
            "telephone": scientific.telephone,  # 联系电话
            "fax": scientific.fax,  # 传真
            "postcode": scientific.postcode,  # 邮编
            "address": scientific.address,  # 地址
            "introduct": scientific.introduct,  # 简介
            "lng": scientific.lng,  # 经度
            "lat": scientific.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='科研机构详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 创新资源-创新平台详情
@api_atlas.route('/innovate/Lab_detail', methods=['POST'])
def get_lab_detail():
    req_dict = request.get_json()
    lab_id = req_dict.get('id')
    try:
        lab = Lab.query.filter_by(id=lab_id).first()
        # 封装创新平台数据
        data = {
            "name": lab.name,  # 名称
            "address": lab.address,  # 地址
            "introduct": lab.introduct,  # 简介
            "lng": lab.lng,  # 经度
            "lat": lab.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='创新平台详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 产业载体-各类型详情信息
@api_atlas.route('/carrier/zaiti_detail', methods=['POST'])
def get_zaiti_detail_data():
    req_dict = request.get_json()
    id = req_dict.get('id')
    cate_id = req_dict.get('cate_id')  # 1行政区，2园区，3土地，4楼宇，5厂房
    # print(cate_id)

    if cate_id in [1, 2]:
        try:
            induzone = Induzone.query.filter_by(id=id).first()
            district = induzone.district

            # 水电气暖
            # if district:
                # resource_obj = DistrictResource.query.filter(DistrictResource.district == district).first()
                # resource_data = {
                #     "domestic_water": resource_obj.domestic_water,
                #     "not_Domestic_water": resource_obj.not_Domestic_water,
                #     "special_water": resource_obj.special_water,
                #     "electricity_life": resource_obj.electricity_life,
                #     "electricity_commercial": resource_obj.electricity_commercial,
                #     "electricity_industrial": resource_obj.electricity_industrial,
                #     "gas_city": resource_obj.gas_city,
                #     "gas_commercial": resource_obj.gas_commercial,
                #     "hot_life": resource_obj.hot_life,
                #     "not_hot_life": resource_obj.not_hot_life,
                # }
                # labor_obj = LaborCost.query.filter(LaborCost.district == district).first()
                # labor_data = {
                #     "endowment_insurance1": labor_obj.endowment_insurance1,
                #     "endowment_insurance2": labor_obj.endowment_insurance2,
                #     "unemployment_insurance1": labor_obj.unemployment_insurance1,
                #     "unemployment_insurance2": labor_obj.unemployment_insurance2,
                #     "injury_insurance1": labor_obj.injury_insurance1,
                #     "injury_insurance2": labor_obj.injury_insurance2,
                #     "maternity_insurance1": labor_obj.maternity_insurance1,
                #     "maternity_insurance2": labor_obj.maternity_insurance2,
                #     "medical_insurance1": labor_obj.medical_insurance1,
                #     "medical_insurance2": labor_obj.medical_insurance2,
                #     "month_wage_rates": labor_obj.month_wage_rates,
                #     "hour_wage_rates": labor_obj.hour_wage_rates
                # }
            url = ''
            if district == '泽州县':
                url = 'https://zysf-store.oss-cn-beijing.aliyuncs.com/%E6%99%8B%E5%9F%8E%E6%8B%9B%E5%95%86%E5%9B%BE%E8%B0%B1%E5%B9%B3%E5%8F%B0/%E4%BA%A7%E4%B8%9A%E8%BD%BD%E4%BD%93-%E6%8A%95%E8%B5%84%E6%88%90%E6%9C%AC%E9%85%8D%E5%9B%BE/%E5%B7%B4%E5%85%AC%E9%95%872022%E5%B9%B4%E5%9F%BA%E5%87%86%E5%9C%B0%E4%BB%B7%E8%A1%A8.png'
            elif district == '高平市':
                url = 'https://zysf-store.oss-cn-beijing.aliyuncs.com/%E6%99%8B%E5%9F%8E%E6%8B%9B%E5%95%86%E5%9B%BE%E8%B0%B1%E5%B9%B3%E5%8F%B0/%E4%BA%A7%E4%B8%9A%E8%BD%BD%E4%BD%93-%E6%8A%95%E8%B5%84%E6%88%90%E6%9C%AC%E9%85%8D%E5%9B%BE/%E9%AB%98%E5%B9%B3%E5%B8%82%E5%B8%82%E5%8C%BA%E5%9C%9F%E5%9C%B0%E7%BA%A7%E5%88%AB%E5%92%8C%E5%9F%BA%E5%87%86%E5%9C%B0%E4%BB%B7%E8%A1%A8.png'
            elif district == '沁水县':
                url = 'https://zysf-store.oss-cn-beijing.aliyuncs.com/%E6%99%8B%E5%9F%8E%E6%8B%9B%E5%95%86%E5%9B%BE%E8%B0%B1%E5%B9%B3%E5%8F%B0/%E4%BA%A7%E4%B8%9A%E8%BD%BD%E4%BD%93-%E6%8A%95%E8%B5%84%E6%88%90%E6%9C%AC%E9%85%8D%E5%9B%BE/%E6%B2%81%E6%B0%B4%E5%8E%BF%E5%8E%BF%E5%9F%8E%E5%90%84%E7%BA%A7%E5%9C%9F%E5%9C%B0%E5%9F%BA%E5%87%86%E5%9C%B0%E4%BB%B7%E8%A1%A8.png'
            elif district == '阳城县':
                url = 'https://zysf-store.oss-cn-beijing.aliyuncs.com/%E6%99%8B%E5%9F%8E%E6%8B%9B%E5%95%86%E5%9B%BE%E8%B0%B1%E5%B9%B3%E5%8F%B0/%E4%BA%A7%E4%B8%9A%E8%BD%BD%E4%BD%93-%E6%8A%95%E8%B5%84%E6%88%90%E6%9C%AC%E9%85%8D%E5%9B%BE/%E9%98%B3%E5%9F%8E%E5%8E%BF%E5%9F%8E%E9%95%87%E5%9F%BA%E5%87%86%E5%9C%B0%E4%BB%B7%E8%A1%A8.png'
            elif district == '城区':
                url = 'https://zysf-store.oss-cn-beijing.aliyuncs.com/%E6%99%8B%E5%9F%8E%E6%8B%9B%E5%95%86%E5%9B%BE%E8%B0%B1%E5%B9%B3%E5%8F%B0/%E4%BA%A7%E4%B8%9A%E8%BD%BD%E4%BD%93-%E6%8A%95%E8%B5%84%E6%88%90%E6%9C%AC%E9%85%8D%E5%9B%BE/%E6%99%8B%E5%9F%8E%E5%B8%82%E4%B8%BB%E5%9F%8E%E5%8C%BA%E5%9F%BA%E5%87%86%E5%9C%B0%E4%BB%B7.png'
            else:
                pass
            data = {
                "id": induzone.id,
                "district": induzone.district if induzone.district else '',
                "cate": induzone.cate if induzone.cate else '',
                "area": induzone.area if induzone.area else '',
                "address": induzone.address if induzone.address else '',
                # "address": induzone.region if induzone.region else ',
                "cluster": induzone.cluster if induzone.cluster else '',
                "name": induzone.name if induzone.name else '',  # 名称
                # "district": induzone.district if induzone.district else ',  # 所属地区
                "phone": induzone.phone if induzone.phone else '',  # 电话
                "email": induzone.email if induzone.email else '',
                # "address": induzone.address if induzone.address else ',  # 园区地址
                "industry_position": induzone.industry_position if induzone.industry_position else '',  # 产业定位
                # "cate": induzone.cate if induzone.cate else ',  # 园区类型
                "gdp": induzone.gdp if induzone.gdp else '',  # GDP
                "represent": induzone.represent if induzone.represent else '',  # 代表企业
                "introduct": induzone.introduct if induzone.introduct else '',  # 简介
                "level": induzone.level if induzone.level else '',  # 等级
                "charge": induzone.charge if induzone.charge else '',  # 园区负责人
                "site": induzone.site if induzone.site else '',  # 园区所在地
                "industry_type": induzone.industry_type if induzone.industry_type else '',  # 产业类型
                # "area": induzone.area if induzone.area else ',  # 面积
                "out_power": induzone.out_power if induzone.out_power else '',  # 产出强度（万元/亩）

                "invest_power": induzone.invest_power if induzone.invest_power else '',  # 亩均投资强度（万元/亩）
                "value_product": induzone.value_product if induzone.value_product else '',  # 亩均年产值（万元/亩）
                "tax": induzone.tax if induzone.tax else '',  # 亩均年税收（万元/亩）
                "indu_land": induzone.indu_land if induzone.indu_land else '',  # 工业土地均价（万元/亩）
                "comm_land": induzone.comm_land if induzone.comm_land else '',  # 商办土地均价（万元/亩）
                "highmag": induzone.highmag if induzone.highmag else '',  # 高层管理人员（元/月）
                "middlemag": induzone.middlemag if induzone.middlemag else '',  # 中级管理人员（元/月）
                "worker": induzone.worker if induzone.worker else '',  # 普通员工（元/月）
                "trans_facility": induzone.trans_facility if induzone.trans_facility else '',  # 交通配套
                "goods_trans": induzone.goods_trans if induzone.goods_trans else '',  # 货物运输
                "live_facility": induzone.live_facility if induzone.live_facility else '',  # 园区生活配套
                "market": induzone.market if induzone.market else '',  # 百货商场
                "hotel_bus": induzone.hotel_bus if induzone.hotel_bus else '',  # 酒店商务
                "medical": induzone.medical if induzone.medical else '',  # 医疗机构
                "education": induzone.education if induzone.education else '',  # 教育教育
                "img_url": url if url else '',
                "xiaqu_area": induzone.xiaqu_area if induzone.xiaqu_area else '',
                "people_num": induzone.people_num if induzone.people_num else '',
                "carrier_form": induzone.carrier_form if induzone.carrier_form else '',
                "area_structure": induzone.area_structure if induzone.area_structure else '',
                "lng": induzone.lng if induzone.lng else '',
                "lat": induzone.lat if induzone.lat else '',
                "admin_live_water1": induzone.admin_live_water1 if induzone.admin_live_water1 else '',
                "admin_live_water2": induzone.admin_live_water2 if induzone.admin_live_water2 else '',
                "admin_live_water3": induzone.admin_live_water3 if induzone.admin_live_water3 else '',
                "admin_electric1": induzone.admin_electric1 if induzone.admin_electric1 else '',
                "admin_electric2": induzone.admin_electric2 if induzone.admin_electric2 else '',
                "admin_electric3": induzone.admin_electric3 if induzone.admin_electric3 else '',
                "admin_gas1": induzone.admin_gas1 if induzone.admin_gas1 else '',
                "admin_gas2": induzone.admin_gas2 if induzone.admin_gas2 else '',
                "admin_residence1": induzone.admin_residence1 if induzone.admin_residence1 else '',
                "admin_residence2": induzone.admin_residence2 if induzone.admin_residence2 else '',
                "admin_tax_rate": induzone.admin_tax_rate if induzone.admin_tax_rate else '',
                "admin_wage_level": induzone.admin_wage_level if induzone.admin_wage_level else '',
                "zone_status": induzone.zone_status if induzone.zone_status else '',
                "zone_land_area": induzone.zone_land_area if induzone.zone_land_area else '',
                "zone_structure_area": induzone.zone_structure_area if induzone.zone_structure_area else '',
                "zone_linkman": induzone.zone_linkman if induzone.zone_linkman else '',
                "zone_mobile": induzone.zone_mobile if induzone.zone_mobile else '',
                # "resource_data": resource_data,
                # "labor_data": labor_data
            }
            return jsonify(code=RET.OK, msg='详情数据查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)


"""以下202212月改版后需求"""


# 企业搜索
@api_atlas.route('/SearchEnterprises', methods=['POST'])
def search_enterprise():
    req_dic = request.get_json()
    entype = req_dic['entype']
    aptitude = req_dic['aptitude']  # 资质
    company_name = req_dic['company_name']
    status = req_dic['status']

    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        company_obj = Company.query.filter(or_(
            Company.entype == entype,
            Company.company_name.like('%{}%'.format(company_name)),
            Company.status == status,
            Company.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Company.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Company.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Company.sxmon == '1' if aptitude == '山西民营100强' else text(''),
            Company.zjtg == '1' if aptitude == '山西专精特新企业' else text(''),
            Company.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Company.dengl == '1' if aptitude == '瞪羚' else text(''),
            Company.isfive == '1' if aptitude == '中国500强' else text(''),
            Company.scale == '1' if aptitude == '规模以上企业' else text(''),
            Company.serve == '1' if aptitude == '限额以上服务业' else text(''),
        ))
        company_obj_list = company_obj.paginate(page, per_page).items
        data = [{
            "id": company_obj.id,
            "company_name": company_obj.company_name,
            "district": company_obj.district,
            "entype": company_obj.entype,
            "aptitude": ["高新技术企业" if company_obj.high_new == '1' else
                         "科技型中小企业" if company_obj.tbe == '1' else
                         "上市企业" if company_obj.quoted_company == '1' else
                         "山西民营100强" if company_obj.sxmon == '1' else
                         "山西专精特新企业" if company_obj.zjtg == '1' else
                         "独角兽企业" if company_obj.unicorn == '1' else
                         "瞪羚企业" if company_obj.dengl == '1' else
                         "中国500强" if company_obj.isfive == '1' else
                         "规模以上企业" if company_obj.scale == '1' else
                         "限额以上服务业" if company_obj.serve == '1' else '']
        } for company_obj in company_obj_list]
        return jsonify(code=RET.OK, data=data, msg='查询成功。')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='查询出错！')


def get_product_li(product, inid):
    res_two_li = []
    res_three_li = []
    product_id = IndustryChain.query.filter_by(industry_name=product, chain_id=inid).first().id
    product_li = [{"chain_name": product, "chain_name_id": product_id}]
    chain_one_obj_list = IndustryChain.query.filter_by(relate_id=product_id, chain_id=inid).all()
    res_one_li = [{"chain_name": chain_one_obj.industry_name,
                "chain_name_id": chain_one_obj.id
                } for chain_one_obj in chain_one_obj_list]

    for res_one in res_one_li:
        chain_two_obj_list = IndustryChain.query.filter_by(relate_id=res_one["chain_name_id"], chain_id=inid).all()
        res_two = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_two_obj_list]
        res_two_li.extend(res_two)
        res_one_li.extend(res_two)

    for res_two in res_two_li:
        chain_three_obj_list = IndustryChain.query.filter_by(relate_id=res_two["chain_name_id"], chain_id=inid).all()
        res_three = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_three_obj_list]
        res_three_li.extend(res_three)
        res_one_li.extend(res_three)
    print(res_one_li)
    for res_three in res_three_li:
        chain_four_obj_list = IndustryChain.query.filter_by(relate_id=res_three["chain_name_id"], chain_id=inid).all()
        res_four = [{"chain_name": chain_one_obj.industry_name,
                       "chain_name_id": chain_one_obj.id
                       } for chain_one_obj in chain_four_obj_list]
        res_one_li.extend(res_four)
    res_one_li.extend(product_li)
    return [res_one["chain_name"] for res_one in res_one_li]


# 点击产业联动显示企业
@api_atlas.route('/industry/enterprise', methods=['POST'])
@login_required
def industry_enterprise():
    '''骨干企业数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行个"1",子行业"2"）
    product = req_dict.get("product")
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("per_page")  # 分页大小
    # sorts = req_dict.get("sorts")  # 排序 sorts "1"按时间降序 ，“2”按热度降序
    entype = req_dict['entype']
    aptitude = req_dict['aptitude']  # 资质
    company_name = req_dict['company_name']
    status = req_dict['status']
    # 校验参数完整性
    # if not all([industry_level, page, perpage]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Company.query.filter(
            Company.city == "晋城市",
            Company.entype.like('%{}%'.format(entype)) if entype else text(''),
            Company.company_name.like('%{}%'.format(company_name)) if company_name else text(''),
            Company.public_sector == status if status else text('')
        )
        company = company.filter(Company.c_type == inid)

        company = company.filter(
            Company.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Company.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Company.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Company.sxmon == '1' if aptitude == '山西100强企业' else text(''),
            Company.zjtg == '1' if aptitude == '山西省专精特新企业' else text(''),
            Company.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Company.dengl == '1' if aptitude == '瞪羚企业' else text(''),
            Company.isfive == '1' if aptitude == '中国500强企业' else text(''),
            Company.scale == '1' if aptitude == '规模以上企业' else text(''),
            Company.serve == '1' if aptitude == '限额以上服务业企业' else text(''),
            Company.chain_master == '1' if aptitude == '链主企业' else text(''),
        )

        if product:
            # 点击上级环节，展示本级所有企业
            product_li = get_product_li(product, inid)
            company1 = []
            for product in product_li:
                company2 = company.filter(
                    Company.c_type == inid,
                    Company.product_all.like("%{}%".format(product))
                ).all()
                company1 += company2
            company1 = set(company1)
            size = len(company1)
            company1 = sorted(company1, key=lambda x: x.hots, reverse=True)  # 排序
            companys = company1[(page - 1) * perpage:page * perpage]  # 分页
        else:
            size = company.count()
            companys = company.order_by(Company.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": i.id,
               "company_name": i.company_name,
               "district": i.district,
               "build_date": (i.build_date).strftime("%Y-%m-%d") if i.build_date else '',
               "legal": i.legal,
               "capital_nums": i.capital_nums,
               "entype": i.entype,
               "address": i.address,
               "telephone": i.telephone,
               "hosts": i.hots,
               "industry_chain": i.c_name,
               "product_all": i.product_all,
               "high_new": '高新技术企业' if i.high_new == '1' else '',
               "tbe": '科技型中小企业' if i.tbe == '1' else '',
               "quoted_company": '上市企业' if i.quoted_company == '1' else '',
               "sxmon": '山西民营100强' if i.sxmon == '1' else '',
               "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
               "unicorn": '独角兽企业' if i.unicorn == '1' else '',
               "dengl": '瞪羚企业' if i.dengl == '1' else '',
               "isfive": '中国500强' if i.isfive == '1' else '',
               "scale": '规模以上企业' if i.scale == '1' else '',
               "serve": '限额以上服务业' if i.serve == '1' else '',
               "fianacing": '融资企业' if i.fianacing == '1' else '',
               "patent": '有专利企业' if i.patent == '1' else '',
               "chain_master": '链主企业' if i.chain_master == '1' else ''
               } for i in companys]
        # df.sort(key=lambda s: s["hosts"], reverse=True)

        data = {"size": size, "df": df}
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 二级行业收藏状态获取
@api_atlas.route('/industry/Inducollect', methods=['POST'])
@login_required
def inducollect():
    '''获取当前用户对二级行业的收藏状态'''
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id  # 用户id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")

    req_dic = request.get_json()
    id = req_dic['id']

    try:
        user = User.query.get(user_id)  # 获取关注列表
        industrys = user.industry
        if industrys:
            indu_ids = [indu.nid for indu in user.industry]
        else:
            indu_ids = []
        if int(id) in indu_ids:
            return jsonify(code=RET.OK, msg="查询成功", collect="1")
        else:
            return jsonify(code=RET.OK, msg="查询成功", collect="2")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 行业业收藏与取消
@api_atlas.route('/IndustryCollect', methods=['POST'])
@login_required
def industry_collect():
    '''企业收藏与状态取消'''
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 二级行业id
    collect = req_dict.get("collect")  # 关注状态(1是，2否)
    # 校验参数完整性
    if not all([_id, collect]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if collect == "2":  # 未关注，我要关注
            user = User.query.get(user_id)
            # indu = Industry.query.filter_by(nid=_id).first()
            indu = IndustryChain.query.filter_by(id=_id).first()

            user.industry.append(indu)
            db.session.commit()
            return jsonify(code=RET.OK, msg="收藏成功", collect="1")
        elif collect == "1":  # 已关注，我要取关
            user = User.query.get(user_id)
            # indu = Industry.query.filter_by(nid=_id).first()
            indu = IndustryChain.query.filter_by(id=_id).first()
            user.industry.remove(indu)
            db.session.commit()
            return jsonify(code=RET.OK, msg="取消成功", collect="2")
        else:
            return jsonify(code=RET.DATAERR, msg="参数异常")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 企业收藏与取消
@api_atlas.route('/EnterpriseCollect', methods=['POST'])
@login_required
def enterprise_collect():
    '''
    企业收藏与取消
    :return:
    '''
    # 获取用户id
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id  # 用户id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id
    choice = req_dict.get("choice")  # 1太原企业，2全国企业
    collect = req_dict.get("collect")  # 关注状态(1是，2否)

    # 校验参数完整性
    if not all([_id, choice, collect]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if choice == 1:  # 太原企业
            if collect == 2:  # 未关注，我要关注
                user = User.query.get(user_id)
                coms = Company.query.get(_id)
                user.company.append(coms)
                db.session.commit()
                return jsonify(code=RET.OK, msg="收藏成功", collect="1")
            elif collect == 1:  # 已关注，我要取关
                user = User.query.get(user_id)
                coms = Company.query.get(_id)
                user.company.remove(coms)
                db.session.commit()
                return jsonify(code=RET.OK, msg="取消收藏", collect="2")
            else:
                return jsonify(code=RET.DATAERR, msg="参数异常")
        if choice == 2:  # 全国企业
            if collect == 2:  # 未关注，我要关注
                user = User.query.get(user_id)
                enters = Enterprise.query.get(_id)
                user.enterprise.append(enters)
                db.session.commit()
                return jsonify(code=RET.OK, msg="收藏成功", collect="1")
            elif collect == 1:  # 已关注，我要取关
                user = User.query.get(user_id)
                enters = Enterprise.query.get(_id)
                user.enterprise.remove(enters)
                db.session.commit()
                return jsonify(code=RET.OK, msg="取消收藏", collect="2")
            else:
                return jsonify(code=RET.DATAERR, msg="状态参数异常")
        else:
            return jsonify(code=RET.DATAERR, msg="企业类别参数异常")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


"""骨干企业散点图色块图"""


# 颜色计数
def jishu(num):
    if num >= 0 and num <= 50:
        return "#72D4F1"
    if num > 50 and num <= 100:
        return "#00BAF6"
    if num > 100 and num <= 200:
        return "#4F9FFF"
    if num > 200 and num <= 500:
        return "#4265F6"
    if num > 500 and num <= 1000:
        return "#0052d6"
    if num > 1000:
        return "#0245AE"


# 招商地图下的色块图(同右侧得数量分布饼图)
@api_atlas.route('/AttractMap', methods=['POST'])
@login_required
def attract_map():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    try:
        enterprise = Company.query.filter_by(c_type=inid)
        if product:
            enterprise = enterprise.filter(Company.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Company.query.with_entities(Company.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                province_data = Company.query.filter_by(province=pro).first()
                df.append({"name": pro,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": province_data.p_lng, "lat": province_data.p_lat}
                           })

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and not city:  # 省-》市数据
            cities = Company.query.filter_by(province=province).with_entities(Company.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                city_data = Company.query.filter_by(province=province, city=cit).first()
                df.append({"name": cit,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": city_data.c_lng, "lat": city_data.c_lat}
                           })

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and not district:  # 市-》区数据
            districts = Company.query.filter_by(province=province, city=city).with_entities(
                Company.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                district_data = Company.query.filter_by(province=province, city=city, district=dis).first()
                df.append({"name": dis,
                           "value": num,
                           "color": jishu(num),
                           # "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}
                           })

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            district_data = Company.query.filter_by(province=province, city=city, district=district).first()
            # print(district_data)
            if district_data:
                df.append({"name": district,
                           "value": num,
                           "color": "",
                           # "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}
                           })
                return jsonify(code=RET.OK, msg="获取成功", data=df)
            else:
                return jsonify(code=RET.OK, msg="无满足条件数据", data=df)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 招商地图下的散点图（至区后）
@api_atlas.route('/AttractSdmap', methods=['POST'])
@login_required
def attract_sdmap():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    # 校验参数完整性
    # if not all([district]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            enterprise = Company.query.filter_by(c_type=inid)
        else:
            enterprise = Company.query.filter_by()
        if district:
            enterprise = enterprise.filter_by(province=province, city=city, district=district)
        if product:
            enterprise = enterprise.filter(Company.product_all.like("%{}%".format(product)))
        enterprise = enterprise.all()
        data = []
        if enterprise:
            for com in enterprise:
                data.append({"id": com.id,
                             "name": com.company_name,
                             "jwd": {"lng": com.lng,  # 企业地址出的经纬度
                                     "lat": com.lat}
                             })  # 上下中游
        else:
            return jsonify(code=RET.OK, msg="获取失败，无数据", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)
