"""
更新企业是否为链主字段
"""
# # -*- coding:utf-8 -*-
import threading

import pandas as pd

from apps.models import IndustryChain, Enterprise, Company
from manager import app
from apps import db

"""
根据资质计算企业的热度，并提交保存
"""

# 读取链主企业文件
xl_path = "无标题.xlsx"
data = pd.read_excel(xl_path)
# com_li = []
# for i in range(len(data)):
#     com_name = str(data.loc[i, "企业名称"])
#     com_li.append(com_name)


def handle():
    with app.app_context():
        for i in range(len(data)):
            com_name = str(data.loc[i, "company_name"])
            ent_id = str(data.loc[i, "ent_id"])
            company_obj = Company.query.filter_by(company_name=com_name).first()
            if company_obj:
                company_obj.company_id = ent_id
                db.session.commit()

        print('已完成，一共{}个'.format(i))


if __name__ == '__main__':
    t = threading.Thread(target=handle)
    t.start()
