import time
from datetime import datetime

from flask import request, jsonify, current_app, g
from apps.manage import api_power
from apps.models import *
from apps.utils.response_code import RET
from apps.util import login_required, verify_token


# 获取首页机构列表
@api_power.route("/organization", methods=["POST"])
@login_required
def organization():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        goverment = Government.query.all()
        size = Government.query.count()
        df = [{"id": gover.id,  # id
               "name": gover.name,  # 机构
               "pnums": gover.pnums if gover.pnums else 0,  # 人数
               "charge": gover.charge if gover.charge else "-",  # 负责人
               "charge_phone": gover.charge_phone if gover.charge_phone else "-",  # 负责人电话
               "cate": 1} for gover in goverment]
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误", data=[])


# 新增机构组织
@api_power.route("/AddOrg", methods=["POST"])
@login_required
def add_org():
    '''
    不得重名
    '''
    # token = request.headers["token"]
    # user = verify_token(token)
    # user_id = user.id
    # user_name = User.query.get(id=user_id).name
    req_dict = request.get_json()
    org_name = req_dict.get("name")  # 机构名称
    pnums = req_dict.get("pnums")  # 人数
    charge = req_dict.get("charge")  # 机构负责人
    charge_phone = req_dict.get("charge_phone")  # 负责人电话

    # 校验参数完整性
    if not all([org_name]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        gover = Government.query.filter_by(name=org_name).first()
        if gover:  # 机构名相同，提示其错误
            return jsonify(code=RET.DBERR, msg="机构名重复")

        goverment = Government(name=org_name)  # 创建机构
        if charge:
            goverment.charge = charge
        if charge_phone:
            goverment.charge_phone = charge_phone
        if pnums:
            goverment.pnums = pnums
        # if user_name:
        #     goverment.add_person = user_name
        #     add_time = datetime.now()
        #     goverment.add_time = add_time
        db.session.add(goverment)  # 添加到数据库
        db.session.commit()  # 提交数据库
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 新增部门
@api_power.route("/addSub", methods=["POST"])
@login_required
def add_sub():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当前机构或者部门id
    cate = req_dict.get("cate")  # 分类标识，1机构，2部门
    name = req_dict.get("name")  # 部门或组名称
    pnums = req_dict.get("pnums")  # 人数
    charge = req_dict.get("charge")  # 机构负责人
    charge_phone = req_dict.get("charge_phone")  # 负责人电话

    # 校验参数完整性
    if not all([_id, name]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # if cate == 1:  # 增加部门
        sec = Section.query.filter_by(name=name, goverment_id=_id).first()
        if sec:  # 一个机构下部门名不能重复
            return jsonify(code=RET.DATAERR, msg="部门名重复")
        goverment = Government.query.get(_id)
        section = Section(name=name, goverment_id=_id)
        if pnums:
            section.pnums = pnums
        if charge:
            section.charge = charge
        if charge_phone:
            section.charge_phone = charge_phone
        db.session.add(section)  # 添加部门
        goverment.sections.append(section)  # 外键关系添加
        db.session.commit()  # 数据库提交
        # if cate == 2:  # 增加组
        #     gro = Group.query.filter_by(name=name, section_id=_id).first()
        #     if gro:  # 一个部门下组名不能重复
        #         return jsonify(code=RET.DATAERR, msg="组名重复")
        #     section = Section.query.get(_id)
        #     group = Group(name=name, section_id=_id)
        #     if pnums:
        #         group.pnums = pnums
        #     if charge:
        #         group.charge = charge
        #     if charge_phone:
        #         group.charge_phone = charge_phone
        #     db.session.add(group)  # 添加组
        #     section.groups.append(group)  # 添加关系
        #     db.session.commit()  # 提交
        # if cate == 3:
        #     return jsonify(code=RET.OK, msg="暂无下级机构，请勿继续添加")
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        # 操作失败，数据回滚
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 获取部门和组
@api_power.route("/sectionGroup", methods=["POST"])
@login_required
def section_group():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当前机构或者部门的id
    cate = req_dict.get("cate")  # 分类标识，1机构，2部门

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 查询当前机构下的部门
            goverment = Government.query.get(_id)
            sections = goverment.sections  # 查询当前机构下的部门list
            if sections:
                data = [{"id": sec.id,
                         "name": sec.name,
                         "pnums": sec.pnums if sec.pnums else 0,
                         "charge": sec.charge if sec.charge else "-",
                         "charge_phone": sec.charge_phone if sec.charge_phone else "-",
                         "cate": 2} for sec in sections]
            else:
                users = User.query.filter_by(belong_organization=goverment.name).all()  # 查询当前部门下的组list
                data = [{"id": user.id,
                         "name": user.real_name,
                         "pnums": '',
                         "charge": '',
                         "charge_phone": user.mobile if user.mobile else "-",
                         "cate": 3} for user in users]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        if cate == 2:  # 查询当前部门下的组
            section = Section.query.get(_id).name
            users = User.query.filter_by(belong_department=section).all()  # 查询当前部门下的组list
            data = [{"id": user.id,
                     "name": user.real_name,
                     "pnums": '',
                     "charge": '',
                     "charge_phone": user.mobile if user.mobile else "-",
                     "cate": 3} for user in users]
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        return jsonify(code=RET.OK, msg="暂无下级信息", data=[])
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误", data=[])


# 编辑机构，部门详情
@api_power.route("/editDetail", methods=["POST"])
@login_required
def edit_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 部门id
    cate = req_dict.get("cate")  # 1机构，2部门
    name = req_dict.get("name")  # 1机构，2部门  的名称
    charge = req_dict.get("charge")  # 局内领导
    charge_phone = req_dict.get("charge_phone")  # 联系方式
    pnums = str(req_dict.get("pnums"))  # 人数

    # 校验参数完整性
#     # if not all([_id, name, charge, charge_phone, pnums, secnums]):
    #     return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 机构
            gover = Government.query.filter_by(name=name).filter(Government.id != _id).first()
            if gover:
                return jsonify(code=RET.DBERR, msg="机构名不可重复")
            gover = Government.query.get(_id)
            gover.name = name
            gover.charge = charge
            gover.charge_phone = charge_phone
            gover.pnums = pnums
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        if cate == 2:  # 部门
            section = Section.query.get(_id)  # 当前部门
            gover_id = section.goverment_id  # 当前部门的机构id
            sec = Section.query.filter_by(name=name, goverment_id=gover_id).filter(Section.id != _id).first()
            if sec:  # 当前机构下此部门名已存在
                return jsonify(code=RET.DBERR, msg="部门名不可重复")
            section.name = name
            section.charge = charge
            section.charge_phone = charge_phone
            section.pnums = pnums
            db.session.commit()
            return jsonify(code=RET.OK, msg="修改成功")
        return jsonify(code=RET.DATAERR, msg="cate参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")


# 删除组织机构或者部门和组(需要先删除人员)
@api_power.route("/deleteOrg", methods=["POST"])
@login_required
def deleteorg():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 待删除的，部门、机构、组、id
    cate = req_dict.get("cate")  # 待删除数据的类别 1政府，2部门，3组

    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if cate == 1:  # 删除机构
            gover = Government.query.get(_id)  # 当前机构对象
            section = gover.sections  # 当前机构下的部门对象列表
            if len(section) > 0:  # 有部门就需要先删除部门
                return jsonify(code=RET.REQERR, msg="当前机构有部门存在，请清除后再操作")
            unums = User.query.filter_by(belong_organization=gover.name, status=1).count()  # 当前机构下通过审核人员
            if unums > 0:  # 当前部门有人，先到机构详情，进行人员的删除
                return jsonify(code=RET.REQERR, msg="当前机构有人员存在，请清除后再操作")
            db.session.delete(gover)  # 无人无部门，删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        if cate == 2:  # 删除部门
            section = Section.query.get(_id)
            gover = section.goverment  # 部门所属的机构
            group = section.groups  # 当前部门的组对象list
            if len(group) > 0:  # 如果有组先删除组
                return jsonify(code=RET.REQERR, msg="当前部门有组存在，请清除后再操作")
            unums = User.query.filter_by(belong_organization=gover.name,
                                         belong_department=section.name,
                                         status=1).count()  # # 已经通过审核的人数
            if unums > 0:  # 当前部门有人，先到部门详情，进行部门人员的删除
                return jsonify(code=RET.REQERR, msg="当前部门有人员存在，请清除后再操作")
            gover.sections.remove(section)  # 当前部门没有人，没有组，删除部门之前需要先删除与之相关的机构关系
            db.session.delete(section)  # 删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        if cate == 3:  # 删除部门下的人员
            user = User.query.get(_id)  # 当前组信息
            # section = group.section  # 组属于的部门，单个对象
            # gover = section.goverment  # 部门属于的机构，单个对象
            # unums = User.query.filter_by(belong_organization=gover.name,
            #                              belong_department=section.name,
            #                              group=group.name,
            #                              status=1).count()  # 已经通过审核的人数
            # if unums > 0:  # 当前组有人，先到组详情，进行组员的删除
            #     return jsonify(code=RET.REQERR, msg="当前组有人员存在，请清除后再操作")
            # section.groups.remove(group)  # 当前组没有人，删除组之前需要先删除与之相关的部门关系
            db.session.delete(user)  # 删除
            db.session.commit()  # 提交
            return jsonify(code=RET.OK, msg="删除成功")
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        # 操作失败，回滚数据库
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作失败")
