# import os
# import json
# from elasticsearch import Elasticsearch
# from flask import request,  jsonify, current_app
# from apps.models import *
# from apps.view_mobile import api_mobile
# from apps.util import login_required, verify_token
# from apps.utils.response_code import RET
#
# def create_body(page, page_size, args_query, args_date, args_term):
#     '''
#
#     :param page:
#     :param page_size:
#     :param args_query:
#     :param args_date:
#     :param args_term:
#     :return:
#     '''
#
#     body = {
#         "query": {
#             "bool": {
#                 "filter": {
#                     "range": {
#                         "build_date": {
#                         }
#                     }
#                 },
#                 "must": [
#                     {"multi_match": {
#                         "query": "{}".format(args_query["query"]),
#                         "type": "best_fields",
#                         "fields": [
#                             "product^1.0",
#                             "company_name^1.0",
#                             "industry^1.0"
#                         ],
#                         "tie_breaker": 0.3
#                     }
#                     },
#                 ]
#             }
#         },
#         "from": page,
#         "size": page_size,
#         "sort": [],
#         "aggs": {},
#         "_source": [
#             #'all_info',
#             'industry', 'build_date', 'register_money_nums', 'product',
#             'company_name',"mysql_id"
#         ],
#         "highlight": {
#             "fields": {
#                 "product": {"type": "plain"},
#                 "company_name": {"type": "plain"},
#                 "industry": {"type": "plain"}
#             }
#         }
#     }
#
#     if args_date:
#         body["query"]["bool"]["filter"]["range"]["build_date"]["gte"] = args_date["build_date"][0]
#         body["query"]["bool"]["filter"]["range"]["build_date"]["lte"] = args_date["build_date"][1]
#
#     for k, v in args_term.items():
#         body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})
#
#     return body
#
#
#
# #搜索接口
# @api_mobile.route("/mobileSearchTy", methods=["POST"])
# @login_required
# def mobile_search_ty():
#     req_dict = request.get_json()
#
#     token = request.headers["token"]
#     user = verify_token(token)
#     user_id = user.id
#
#     company = req_dict.get("company")
#     if not company:
#         return jsonify(code = RET.PARAMERR,msg = "数据库错误")
#     args_query = dict()
#     args_date = dict()
#     args_term = dict()
#
#     # #每页个数
#     per_page = req_dict.get("per_page")
#     page = req_dict.get("page")
#     if not req_dict.get("per_page"):
#         per_page = 10
#     per_page = int(per_page)
#     # 页数
#     if not page:
#         page = 1
#     page = int(page)
#     args_query["query"] = company
#
#     try:
#         user = User.query.get(user_id)
#         b = []
#         if user.searchlist:
#             for j in user.searchlist:
#                 b.append(j.history)
#             if company in b:
#                 user.searchlist.remove(user.searchlist[b.index(company)])
#             if len(b) > 5:
#                 user.searchlist.remove(user.searchlist[0])
#         search = SearchList(history=company)
#         db.session.add(search)
#         user.searchlist.append(search)
#         db.session.commit()
#     except Exception as e:
#         db.session.rollback()
#         current_app.logger.error(e)
#         return jsonify(code=RET.DBERR, msg="数据库错误")
#
#     body = create_body(page, per_page, args_query, args_date, args_term)
#
#     try:
#         es = Elasticsearch([{'host': '39.100.39.50', 'port': 9200}])
#         data = es.search(index="ty_com", body=body)
#         data_list = []
#
#         #数据的列表添加进去
#         for i in data["hits"]['hits']:
#
#             if company:
#                 # 判断高亮，然后添加
#                 data_list.append({
#                     "company": i["highlight"]["company_name"][0] if "company_name" in i["highlight"] else i["_source"]["company_name"],
#                     "product": i["highlight"]["product"][0] if "product" in i["highlight"] else i["_source"]["product"],
#                     "industry": i["highlight"]["industry"][0] if "industry" in i["highlight"] else i["_source"]["industry"],
#                     "money":  "{}万元".format( i["_source"]["register_money_nums"]),
#                     "createtime": i["_source"]["build_date"],
#                     "id": i["_source"]["mysql_id"],
#                     "choice": 1
#                 })
#             else:
#                 data_list.append({
#                     "company": i["_source"]["company_name"],
#                     "product": i["_source"]["product"],
#                     "industry": i["_source"]["industry"],
#                     "money": "{}万元".format(i["_source"]["register_money_nums"]),
#                     "createtime": i["_source"]["build_date"],
#                     "id": i["_source"]["mysql_id"],
#                     "choice":1,
#                 })
#     except Exception as e:
#         current_app.logger.error(e)
#         return jsonify(code = RET.DBERR,msg= "es数据库错误")
#     data = {
#         "data": data_list
#     }
#     return jsonify(code=RET.OK, msg="查找成功", data=data)
#
#
#
