import sys
import threading
from time import sleep

from flask import app
from apps.models import IndustryChain, Enterprise
from manager import app
from apps import db


# def jindu(enterprise_list_num):
#     for i in range(1, enterprise_list_num):
#         print("\r", end="")
#         print("进度: {}%: ".format(i), "▓" * (i // 2), end="")
#         sys.stdout.flush()
#         sleep(0.05)


def handle():
    with app.app_context():
        industry_obj_list = IndustryChain.query.all()
        print(industry_obj_list)
        # 读取industry_chain数据表的产业名称
        num = 0
        for industry_obj in industry_obj_list:
            industry_name = industry_obj.industry_name
            industry_id = industry_obj.id
            chain_id = industry_obj.chain_id
            # 读取全国企业表，模糊匹配product_all字段
            if industry_name in ["钢铁", "光机电", "煤层气", "装备制造", "铸造",
                                 "煤化工", "新材料", "绿色建材", "医药", "丝麻纺织服装",
                                 "现代服务业", "数字经济", "文化旅游"]:
                print("正在查询【{}】的相关企业......".format(industry_name))
                enterprise_list = Enterprise.query.filter(Enterprise.c_type == industry_id).count()

            else:
                print("正在查询【{}】的相关企业......".format(industry_name))

                enterprise_list = Enterprise.query.filter(Enterprise.product_all.like("%{}%".format(industry_name)),
                                                          Enterprise.c_type == chain_id).count()
            if not enterprise_list:
                enterprise_list = 0
            # 清空原有关联企业
            # enterprise_list_num = len(enterprise_list)
            industry_obj.enterprise_num = enterprise_list
            # industry_obj.enterprise = []
            db.session.commit()

            # enterprise_num = 0
            # for enterprise_obj in enterprise_list:
            #     industry_obj.enterprise.append(enterprise_obj)
            #     enterprise_num += 1
            #     enterprise_list_num -= 1
            #     if enterprise_num >= 100:
            #         db.session.commit()
            #         enterprise_num = 0
            #         continue
            #     # elif enterprise_list_num == 0 and enterprise_num == 400:
            #     #     db.session.commit()
            #     #     enterprise_num = 0
            #     #     continue
            #     # elif enterprise_list_num == 0 and enterprise_num == 300:
            #     #     db.session.commit()
            #     #     enterprise_num = 0
            #     #     continue
            #     # elif enterprise_list_num == 0 and enterprise_num == 200:
            #     #     db.session.commit()
            #     #     enterprise_num = 0
            #     #     continue
            #     # elif enterprise_list_num == 0 and enterprise_num == 100:
            #     #     db.session.commit()
            #     #     enterprise_num = 0
            #     #     continue
            #     else:
            #         pass
            # db.session.commit()
            # continue
            print("产业链【{}】已完成, 数量【{}】个".format(industry_name, enterprise_list))
            continue

            # enterprise_num += 1
                # enterprise_rate = str(enterprise_num / len(enterprise_list) * 100) + '%'
                # print("需要添加【{}】的企业外键一共{}个，已完成{}".format(industry_name, len(enterprise_list), enterprise_rate))

            # db.session.commit()
            # num += 1
            # print("产业链【{}】已完成，全部产业链已完成".format(industry_name) + str(num / 775 * 100) + '%')
            # print("产业链【{}】已完成".format(industry_name))


if __name__ == '__main__':
    t = threading.Thread(target=handle)
    t.start()
