from flask import current_app, request, jsonify
from sqlalchemy import or_

from apps.view_atlas import api_atlas
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps.models import *
from apps.utils.neo4j_conn import conn_neo4j, neo4j_dict
from apps import redis_store
import json

graph = conn_neo4j()

'''行业名转换ptp字典两个  neo4j_dict  line 164/177'''


def deleteDuplicate(li):
    '''列表[字典]去重'''
    temp_list = list(set([str(i) for i in li]))
    li = [eval(i) for i in temp_list]
    return li


def find_up_thr(name_query, relation):
    if relation == "中游行业":
        relation_c = "下位产品"
    else:
        relation_c = relation

    # 零级，上中下三游
    data = {
        "node": "{}".format(relation[:2]),
        "level": 1,
        "subNodeList": [],
    }
    sql_01 = "match (n) -[r:`{}`]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(relation_c, name_query)
    res_zero = graph.run(sql_01).data()
    res_one = list(set([i["m.name"] for i in list(res_zero)]))  # 不重复的一级节点
    for it in res_one:  # 一级节点
        pname_one = it
        # 一级
        node_one = {
            "node": "{}".format(pname_one),
            "level": 2,
            "subNodeList": []
        }
        sql_02 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_one)
        result = graph.run(sql_02).data()
        result = list(set([i["m.name"] for i in list(result)]))  # 不重复的二级节点
        for item in result:
            pname_two = item
            # 二级
            node_two = {
                "node": "{}".format(pname_two),
                "level": 3,
                "subNodeList": []
            }
            sql_03 = "match (n) -[r]->(m) WHERE n.name='{}' return n.name,r.type,m.name".format(pname_two)
            result3 = graph.run(sql_03).data()
            result3 = list(set([i["m.name"] for i in list(result3)]))  # 不重复的三级节点
            for itm in result3:
                pname_thr = itm
                # 三级
                node_thr = {
                    "node": "{}".format(pname_thr),
                    "level": 4,
                    "subNodeList": []
                }
                node_two["subNodeList"].append(node_thr)
            node_one["subNodeList"].append(node_two)
        data["subNodeList"].append(node_one)
    return data


# 获取产业集群名称
@api_atlas.route('/industry/cluster', methods=['GET'])
def get_cluster():
    try:
        # cluster_obj = Industry.query.filter_by(fid=0).all()
        cluster_obj = Industry.query.all()

        data = {
            "cluster": [
                {"id": i.nid, 'industry_level': 1, 'name': i.name,
                 "subNodeList": [{'id': j.nid, 'industry_level': 2, "name": j.name} for j in
                                 Industry.query.filter_by(fid=i.nid)]} for i in
                cluster_obj]

        }
        return jsonify(code=RET.OK, msg='产业集群名称获取成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 返回上中下游产业链数据接口
@api_atlas.route('/industry/chain', methods=['POST'])
# @login_required
def industry_chain():
    '''
    行业id->行业链标题-》上中下游-》查询数值
    :return:
    '''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 二级行业id（二级行业显示链图）

    # 校验参数完整性
    if not all([inid]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        # name_query = "jc" + str(inid) + str(district)
        # if redis_store.get(name_query) is not None:
        #     data = json.loads(redis_store.get(name_query))
        #     return jsonify(code=RET.OK, msg="获取成功", data=data)

        # 行业使用名
        industryName = Industry.query.filter_by(nid=inid).first().oname
        ptp = neo4j_dict()
        if industryName in ptp:
            industryName = ptp[industryName]
        # print(industryName)
        result = {
            "industryChain": industryName,
            "nodeList": [find_up_thr(industryName, "上游行业"),
                         find_up_thr(industryName, "中游行业"),
                         find_up_thr(industryName, "下游行业")]
        }
        # redis缓存
        # redis_store.set(name_query, json.dumps(result))
        # redis_store.expire(name_query, 30 * 24 * 3600)
        # print("redis")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据异常")
    return jsonify(code=RET.OK, msg="获取成功", data=result)


# 点击产业创新资源联动显示 innovation resource
@api_atlas.route('/innovate/resource', methods=['POST'])
def industry_resource():
    '''创新资源机构列表'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个"1",子行业"2"）

    select_flag = req_dict.get("select_flag")  # 机构类型id. 高等院校1,科研机构2，创新平台3，产业服务平台4

    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([inid, industry_level, select_flag, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    name = Industry.query.filter_by(nid=inid).first().oname

    if select_flag == 1:  # 高等院校
        try:
            if industry_level == 1:
                college = College.query.filter(College.navigat.like("%{}%".format(name)))
            # else:
            #     college = College.query.filter(College.navigat.like("%{}%".format(name)))
            size = college.count()
            college = college.paginate(page, perpage).items

            data = {"df": [{"id": i.id,
                            "name": i.name,
                            "admin": i.admin,
                            "buildate": i.buildate,
                            "charge": i.charge,
                            "cate": i.category,
                            "nature": i.nature,
                            "ccode": i.ccode,
                            "address": i.address,
                            } for i in college],
                    "size": size}
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DATAERR, msg="参数错误")
    elif select_flag == 2:  # 科研机构
        if industry_level == 1:
            scientific = Scientific.query.filter(Scientific.navigator.like("%{}%".format(name)))
        else:
            scientific = Scientific.query.filter(Scientific.navigat.like("%{}%".format(name)))
        size = scientific.count()
        scientific = scientific.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "telephone": i.telephone,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address} for i in scientific],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    elif select_flag == 3:  # 创新平台3
        if industry_level == 1:
            lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        # else:
        #     lab = Lab.query.filter(Lab.navigat.like("%{}%".format(name)))
        size = lab.count()
        lab = lab.paginate(page, perpage).items
        data = {"df": [{"id": i.id,
                        "name": i.name,
                        "admin": i.admin,
                        "cate": i.cate,
                        "fax": i.fax,
                        "postcode": i.postcode,
                        "address": i.address} for i in lab],
                "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    else:
        return jsonify(code=RET.PARAMERR, msg="参数错误")


def get_data(name, industry_level, select_flag, page, perpage):
    try:
        if select_flag in [1, 2, 7]:  # 当选择行政区/园区时
            induzone = ''
            if select_flag == 1 and industry_level == 1:  # 当选择的是父产业的行政区时
                induzone = Induzone.query.filter(Induzone.cate.like('行政区'), Induzone.navigat.like("%{}%".format(name)))
            # elif select_flag == 1 and industry_level == 2:  # 当选择的是子产业的行政区时
            #     induzone = Induzone.query.filter(Induzone.cate.like('行政区'), Induzone.navigat.like("%{}%".format(name)))
            elif select_flag == 2 and industry_level == 1:  # 当选择的是父产业的园区时
                induzone = Induzone.query.filter(Induzone.cate.like('产业园区'), Induzone.navigat.like("%{}%".format(name)))
            # elif select_flag == 2 and industry_level == 2:  # 当选择的是子产业的园区时
            #     induzone = Induzone.query.filter(Induzone.cate.like('产业园区'), Induzone.navigat.like("%{}%".format(name)))
            elif select_flag == 7 and industry_level == 1:  # 当选择的是开发区时
                induzone = Induzone.query.filter(Induzone.cate.like('开发区'), Induzone.navigat.like("%{}%".format(name)))

            size = induzone.count()  # 分页总数
            induzone = induzone.paginate(page, perpage).items

            if select_flag == 1:
                # 封装行政区数据
                admin_data = {"admin_data": [{
                    "id": i.id,
                    "image": i.image,
                    # "region": i.region,
                    "region": i.district,
                    "cate": i.cate,  # 园区类型
                    "area": i.area,
                    "address": i.address,
                    "cluster": i.cluster} for i in induzone],
                    "size": size}
                return admin_data

            if select_flag in [2, 7]:
                # 封装园区数据
                garden_data = {"garden": [{"id": i.id,
                                           "image": i.image,
                                           "name": i.name,  # 园区名称
                                           "region": i.region,  # 所属地区
                                           "phone": i.phone,  # 联系电话
                                           "level": i.level,  # 园区级别
                                           "cate": i.cate,  # 园区类型
                                           "address": i.address, } for i in induzone],  # 园区地址
                               "size": size}
                return garden_data

        if select_flag == 3:  # 当选择载体土地时
            if industry_level == 1:  # 当选择的是父产业时
                land = ZaitiLand.query.filter(ZaitiLand.navigator.like("%{}%".format(name)))
            else:
                land = ZaitiLand.query.filter(ZaitiLand.navigat.like("%{}%".format(name)))
            size = land.count()  # 分页总数
            land = land.paginate(page, perpage).items

            # 封装土地数据
            land_data = {"land_data": [{
                "id": i.id,
                "name": i.name,
                "num": i.num,
                "nature": i.nature,
                "acreage": i.acreage,
                "industry_type": i.industry_type,
                "telephone": i.telephone
            } for i in land], "size": size}
            return land_data

        if select_flag == 4:  # 当选择载体楼宇时
            if industry_level == 1:  # 当选择的是父产业时
                build = ZaitiBuild.query.filter(ZaitiBuild.navigator.like("%{}%".format(name)))
            else:
                build = ZaitiBuild.query.filter(ZaitiBuild.navigat.like("%{}%".format(name)))
            size = build.count()  # 分页总数
            build = build.paginate(page, perpage).items

            # 封装楼宇数据
            build_data = {
                "build_data": [{
                    "id": i.id,
                    "name": i.name,
                    "acreage": i.acreage,
                    "buide_type": i.buide_type,
                    "industry_type": i.industry_type,
                    "telephone": i.telephone,
                    "addr": i.addr,
                } for i in build], "size": size
            }
            return build_data

        if select_flag == 5:  # 当选择载体厂房时
            if industry_level == 1:  # 当选择的是父产业时
                factory = ZaitiFactory.query.filter(ZaitiFactory.navigator.like("%{}%".format(name)))
            else:
                factory = ZaitiFactory.query.filter(ZaitiFactory.navigat.like("%{}%".format(name)))
            size = factory.count()  # 分页总数
            factory = factory.paginate(page, perpage).items

            # 封装楼宇数据
            factory_data = {
                "factory_data": [{
                    "id": i.id,
                    "name": i.name,
                    "acreage": i.acreage,
                    "factory_type": i.factory_type,
                    "industry_type": i.industry_type,
                    "telephone": i.telephone,
                    "addr": i.addr,
                } for i in factory], "size": size
            }
            return factory_data
    except Exception as e:
        print(e)
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 产业载体
@api_atlas.route('/carrier/zaiti', methods=['POST'])
def industry_zaiti():
    '''产业载体数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个"1",子行业"2"）
    select_flag = req_dict.get("select_flag")  # 1行政区，2园区，3产业载体，
    # 4土地，5楼宇，6厂房，7开发区
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # if inid:
    name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
    try:
        data = get_data(name, industry_level, select_flag, page, perpage)
        return jsonify(code=RET.OK, msg="数据查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)


#  产业政策
@api_atlas.route('/industry/indus_policy', methods=['POST'])
def industry_policy():
    """产业政策数据"""
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行业高端设备等五个1,子行业2）
    policy_level = req_dict.get("policy_level")  # 政策等级，（国家级1，省级2，市级3，区县4，开发区5）
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("perpage")  # 分页大小

    policy_type = req_dict.get("policy_type")  # 政策类型，全国、国务院
    policy_year = req_dict.get("policy_year")  # 政策年份
    policy_name = req_dict.get("policy_name")  # 政策名称

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        indu_policy = ''
        size = ''
        name = Industry.query.filter_by(nid=inid).first().oname  # 获取导航对应的真名
        # name = '煤层气'
        print(name)
        if industry_level == 1:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    InduPolicy.level == "省级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    InduPolicy.level == "市级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    InduPolicy.level == "区县",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    InduPolicy.level == "开发区",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            else:
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    # InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items

        if industry_level == 2:
            if policy_level == 1:  # 国家级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)),
                    InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 2:  # 省级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)),
                    InduPolicy.level == "省级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 3:  # 市级
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)),
                    InduPolicy.level == "市级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 4:  # 区县
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)),
                    InduPolicy.level == "区县",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            elif policy_level == 5:  # 开发区
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigat.like("%{}%".format(name)),
                    InduPolicy.level == "开发区",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name)))
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items
            else:
                indu_policy = InduPolicy.query.filter(
                    InduPolicy.navigator.like("%{}%".format(name)),
                    # InduPolicy.level == "国家级",
                    InduPolicy.org == policy_type if policy_type == '国务院' else text(''),
                    InduPolicy.year == policy_year if policy_year else text(''),
                    InduPolicy.name.like('%{}%'.format(policy_name))
                )
                size = indu_policy.count()  # 分页总数
                # indu_policy = indu_policy.
                indu_policy = indu_policy.order_by(InduPolicy.pubdate.desc()).paginate(page, perpage).items

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    # 封装政策数据
    policy_data = {
        "policy_data": [{
            "id": i.id,
            "name": i.name,
            "org": i.org,
            "pubdate": (i.pubdate).strftime("%Y-%m-%d")
        } for i in indu_policy],
        "size": size
    }
    return jsonify(code=RET.OK, msg="政策数据查询成功", data=policy_data)


# 产业政策详情信息-复用招商驾驶舱政策详情接口


# 骨干企业详情信息


# 创新资源-高等院校详情
@api_atlas.route('/innovate/college_detail', methods=['POST'])
def get_college_detail():
    req_dict = request.get_json()
    college_id = req_dict.get('id')
    try:
        college = College.query.filter_by(id=college_id).first()
        # 封装院校数据
        data = {
            "name": college.name,  # 校名
            "charge": college.charge,  # 主管部门
            "buildate": college.buildate,  # 创办时间
            "nature": college.nature,  # 办学性质
            "clas": college.clas,  # 学校类别
            "address": college.address,  # 校址
            "introduct": college.introduct,  # 简介
            "ccode": college.ccode,  # 学校代码
            "feature": college.feature,  # 学校特色
            "research": college.research,  # 研究方向
            "major": college.major,
            "faculty": college.faculty,
            "lng": college.lng,  # 经度
            "lat": college.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='院校详情查询成功！', data=data)

    except Exception as e:
        current_app.logger.error(e)


# 创新资源-科研机构详情
@api_atlas.route('/innovate/scientific_detail', methods=['POST'])
def get_scientific_detail():
    req_dict = request.get_json()
    scientific_id = req_dict.get('id')
    try:
        scientific = Scientific.query.filter_by(id=scientific_id).first()
        # 封装科研机构数据
        data = {
            "name": scientific.name,  # 名称
            "admin": scientific.admin,  # 行政区
            "telephone": scientific.telephone,  # 联系电话
            "fax": scientific.fax,  # 传真
            "postcode": scientific.postcode,  # 邮编
            "address": scientific.address,  # 地址
            "introduct": scientific.introduct,  # 简介
            "lng": scientific.lng,  # 经度
            "lat": scientific.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='科研机构详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 创新资源-创新平台详情
@api_atlas.route('/innovate/Lab_detail', methods=['POST'])
def get_lab_detail():
    req_dict = request.get_json()
    lab_id = req_dict.get('id')
    try:
        lab = Lab.query.filter_by(id=lab_id).first()
        # 封装创新平台数据
        data = {
            "name": lab.name,  # 名称
            "address": lab.address,  # 地址
            "introduct": lab.introduct,  # 简介
            "lng": lab.lng,  # 经度
            "lat": lab.lat  # 纬度
        }
        return jsonify(code=RET.OK, msg='创新平台详情查询成功！', data=data)
    except Exception as e:
        current_app.logger.error(e)


# 产业载体-各类型详情信息
@api_atlas.route('/carrier/zaiti_detail', methods=['POST'])
def get_zaiti_detail_data():
    req_dict = request.get_json()
    id = req_dict.get('id')
    cate_id = req_dict.get('cate_id')  # 1行政区，2园区，3土地，4楼宇，5厂房
    print(cate_id)

    if cate_id in [1, 2]:
        try:
            induzone = Induzone.query.filter_by(id=id).first()
            data = {
                "district": induzone.district,
                "cate": induzone.cate,
                "area": induzone.area,
                # "address": induzone.address,
                "address": induzone.region,
                "cluster": induzone.cluster,
                "name": induzone.name,  # 名称
                # "district": induzone.district,  # 所属地区
                "phone": induzone.phone,  # 电话
                "email": induzone.email,
                # "address": induzone.address,  # 园区地址
                "industry_position": induzone.industry_position,  # 产业定位
                # "cate": induzone.cate,  # 园区类型
                "gdp": induzone.gdp,  # GDP
                "represent": induzone.represent,  # 代表企业
                "introduct": induzone.introduct,  # 简介
                "level": induzone.level,  # 等级
                "charge": induzone.charge,  # 园区负责人
                "site": induzone.site,  # 园区所在地
                "industry_type": induzone.industry_type,  # 产业类型
                # "area": induzone.area,  # 面积
                "out_power": induzone.out_power,  # 产出强度（万元/亩）

                "invest_power": induzone.invest_power,  # 亩均投资强度（万元/亩）
                "value_product": induzone.value_product,  # 亩均年产值（万元/亩）
                "tax": induzone.tax,  # 亩均年税收（万元/亩）
                "indu_land": induzone.indu_land,  # 工业土地均价（万元/亩）
                "comm_land": induzone.comm_land,  # 商办土地均价（万元/亩）
                "highmag": induzone.highmag,  # 高层管理人员（元/月）
                "middlemag": induzone.middlemag,  # 中级管理人员（元/月）
                "worker": induzone.worker,  # 普通员工（元/月）
                "trans_facility": induzone.trans_facility,  # 交通配套
                "goods_trans": induzone.goods_trans,  # 货物运输
                "live_facility": induzone.live_facility,  # 园区生活配套
                "market": induzone.market,  # 百货商场
                "hotel_bus": induzone.hotel_bus,  # 酒店商务
                "medical": induzone.medical,  # 医疗机构
                "education": induzone.education,  # 教育教育
            }
            return jsonify(code=RET.OK, msg='详情数据查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 3:
        try:
            land = ZaitiLand.query.filter_by(id=id).first()
            data = {
                "num": land.num,  # 编号
                "name": land.name,  # 地块名称
                "addr": land.addr,  # 地址
                "nature": land.nature,  # 土地性质
                "acreage": land.acreage,  # 面积
                "target": land.target,  # 规划指标
                "age_limit": land.age_limit,  # 出让年限
                "industry_type": land.industry_type,  # 产业类型
                "telephone": land.telephone  # 电话
            }
            return jsonify(code=RET.OK, msg='土地详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 4:
        try:
            build = ZaitiBuild.query.filter_by(id=id).first()
            data = {
                "name": build.name,  # 楼宇名称
                "addr": build.addr,  # 地址
                "acreage": build.acreage,  # 面积
                "buide_type": build.buide_type,  # 楼宇类型
                "industry_type": build.industry_type,  # 产业类型
                "rate": build.rate,  # 出租率
                "telephone": build.telephone  # 电话
            }
            return jsonify(code=RET.OK, msg='楼宇详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)

    if cate_id == 5:
        try:
            factory = ZaitiFactory.query.filter_by(id=id).first()
            data = {
                "name": factory.name,  # 厂房名称
                "addr": factory.addr,  # 地址
                "acreage": factory.acreage,  # 面积
                "structure": factory.structure,  # 简介
                "height": factory.height,  # 高度
                "bearing": factory.bearing,  # 承重
                "new_level": factory.new_level,  # 新旧程度
                "other": factory.other,  # 其他
                "industry_type": factory.industry_type,  # 产业类型
                "factory_type": factory.factory_type,  # 厂房类型
                "telephone": factory.telephone,  # 电话
            }
            return jsonify(code=RET.OK, msg='厂房详情查询成功！', data=data)
        except Exception as e:
            current_app.logger.error(e)


"""以下202212月改版后需求"""


# 企业搜索
@api_atlas.route('/SearchEnterprises', methods=['POST'])
def search_enterprise():
    req_dic = request.get_json()
    entype = req_dic['entype']
    aptitude = req_dic['aptitude']  # 资质
    company_name = req_dic['company_name']
    status = req_dic['status']

    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        company_obj = Company.query.filter(or_(
            Company.entype == entype,
            Company.company_name.like('%{}%'.format(company_name)),
            Company.status == status,
            Company.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Company.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Company.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Company.sxmon == '1' if aptitude == '山西民营100强' else text(''),
            Company.zjtg == '1' if aptitude == '山西专精特新企业' else text(''),
            Company.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Company.dengl == '1' if aptitude == '瞪羚' else text(''),
            Company.isfive == '1' if aptitude == '中国500强' else text(''),
            Company.scale == '1' if aptitude == '规模以上企业' else text(''),
            Company.serve == '1' if aptitude == '限额以上服务业' else text(''),
        ))
        company_obj_list = company_obj.paginate(page, per_page).items
        data = [{
            "id": company_obj.id,
            "company_name": company_obj.company_name,
            "district": company_obj.district,
            "entype": company_obj.entype,
            "aptitude": ["高新技术企业" if company_obj.high_new == '1' else
                         "科技型中小企业" if company_obj.tbe == '1' else
                         "上市企业" if company_obj.quoted_company == '1' else
                         "山西民营100强" if company_obj.sxmon == '1' else
                         "山西专精特新企业" if company_obj.zjtg == '1' else
                         "独角兽企业" if company_obj.unicorn == '1' else
                         "瞪羚" if company_obj.dengl == '1' else
                         "中国500强" if company_obj.isfive == '1' else
                         "规模以上企业" if company_obj.scale == '1' else
                         "限额以上服务业" if company_obj.serve == '1' else '']
        } for company_obj in company_obj_list]
        return jsonify(code=RET.OK, data=data, msg='查询成功。')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='查询出错！')


# 点击产业联动显示企业
@api_atlas.route('/industry/enterprise', methods=['POST'])
# @login_required
def industry_enterprise():
    '''骨干企业数据'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    industry_level = req_dict.get("industry_level")  # 行业等级,（父行个"1",子行业"2"）
    product = req_dict.get("product")
    page = req_dict.get("page")  # 分页页码
    perpage = req_dict.get("per_page")  # 分页大小
    # sorts = req_dict.get("sorts")  # 排序 sorts "1"按时间降序 ，“2”按热度降序
    entype = req_dict['entype']
    aptitude = req_dict['aptitude']  # 资质
    company_name = req_dict['company_name']
    status = req_dict['status']
    # 校验参数完整性
    if not all([industry_level, page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Company.query.filter(
            Company.c_type == inid,
            Company.city == "晋城市",
            Company.entype == entype if entype else text(''),
            Company.company_name.like('%{}%'.format(company_name)) if company_name else text(''),
            Company.status == status if status else text(''))
        if industry_level == 1 and product:
            company = company.filter(Company.c_name.like("%{}%".format(product)))

        else:
            if product:
                company = company.filter(Company.product_all.like("%{}%".format(product)))
        company = company.filter(
            Company.high_new == '1' if aptitude == '高新技术企业' else text(''),
            Company.tbe == '1' if aptitude == '科技型中小企业' else text(''),
            Company.quoted_company == '1' if aptitude == '上市企业' else text(''),
            Company.sxmon == '1' if aptitude == '山西民营100强' else text(''),
            Company.zjtg == '1' if aptitude == '山西专精特新企业' else text(''),
            Company.unicorn == '1' if aptitude == '独角兽企业' else text(''),
            Company.dengl == '1' if aptitude == '瞪羚' else text(''),
            Company.isfive == '1' if aptitude == '中国500强' else text(''),
            Company.scale == '1' if aptitude == '规模以上企业' else text(''),
            Company.serve == '1' if aptitude == '限额以上服务业' else text(''),
        )
        size = company.count()
        companys = company.order_by(Company.hots.desc()).paginate(page, perpage).items  # 企业热度倒序

        df = [{"id": i.id,
               "company_name": i.company_name,
               "district": i.district,
               "build_date": (i.build_date).strftime("%Y-%m-%d") if i.build_date else '',
               "legal": i.legal,
               "capital_nums": i.capital_nums,
               "entype": i.entype,
               "address": i.address,
               "telephone": i.telephone,
               "hosts": '企业热度' if i.hots else '',
               "high_new": '高新技术企业' if i.high_new == '1' else '',
               "tbe": '科技型中小企业' if i.tbe == '1' else '',
               "quoted_company": '上市企业' if i.quoted_company == '1' else '',
               "sxmon": '山西民营100强' if i.sxmon == '1' else '',
               "zjtg": '山西专精特新企业' if i.zjtg == '1' else '',
               "unicorn": '独角兽企业' if i.unicorn == '1' else '',
               "dengl": '瞪羚' if i.dengl == '1' else '',
               "isfive": '中国500强' if i.isfive == '1' else '',
               "scale": '规模以上企业' if i.scale == '1' else '',
               "serve": '限额以上服务业' if i.serve == '1' else ''
               } for i in companys]
        df.sort(key=lambda s: s["hosts"], reverse=True)

        data = {"size": size, "df": df}
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 二级行业收藏状态获取
@api_atlas.route('/industry/Inducollect', methods=['POST'])
# @login_required
def inducollect():
    '''获取当前用户对二级行业的收藏状态'''
    try:
        token = request.headers["token"]
        user = verify_token(token)
        user_id = user.id  # 用户id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="token过期，请重新登录！")

    req_dic = request.get_json()
    id = req_dic['id']

    try:
        user = User.query.get(user_id)  # 获取关注列表
        industrys = user.industry
        if industrys:
            indu_ids = [indu.nid for indu in user.industry]
        else:
            indu_ids = []
        if int(id) in indu_ids:
            return jsonify(code=RET.OK, msg="查询成功", collect="1")
        else:
            return jsonify(code=RET.OK, msg="查询成功", collect="2")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 行业业收藏与取消
@api_atlas.route('/industry/collect', methods=['POST'])
@login_required
def indu_collect():
    '''企业收藏与状态取消'''
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 二级行业id
    collect = req_dict.get("collect")  # 关注状态(1是，2否)
    # 校验参数完整性
    if not all([_id, collect]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if collect == "2":  # 未关注，我要关注
            user = User.query.get(user_id)
            indu = Industry.query.filter_by(nid=_id).first()
            user.industry.append(indu)
            db.session.commit()
            return jsonify(code=RET.OK, msg="收藏成功", collect="1")
        elif collect == "1":  # 已关注，我要取关
            user = User.query.get(user_id)
            indu = Industry.query.filter_by(nid=_id).first()
            user.industry.remove(indu)
            db.session.commit()
            return jsonify(code=RET.OK, msg="取消成功", collect="2")
        else:
            return jsonify(code=RET.DATAERR, msg="参数异常")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


"""骨干企业散点图色块图"""


# 颜色计数
def jishu(num):
    if num >= 0 and num <= 50:
        return "#72D4F1"
    if num > 50 and num <= 100:
        return "#00BAF6"
    if num > 100 and num <= 200:
        return "#4F9FFF"
    if num > 200 and num <= 500:
        return "#4265F6"
    if num > 500 and num <= 1000:
        return "#0052d6"
    if num > 1000:
        return "#0245AE"


# 招商地图下的色块图(同右侧得数量分布饼图)
@api_atlas.route('/AttractMap', methods=['POST'])
# @login_required
def attract_map():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    try:
        enterprise = Company.query.filter_by(c_type=inid)
        if product:
            enterprise = enterprise.filter(Company.product_all.like("%{}%".format(product)))
        # print(enterprise)
        df = list()
        if not province:  # 全国，省数据
            provinces = Company.query.with_entities(Company.province).distinct().all()
            provinces = [i[0] for i in provinces if i[0]]  # 拿到省份的无重复值
            for pro in provinces:
                num = enterprise.filter_by(province=pro).count()
                province_data = Company.query.filter_by(province=pro).first()
                df.append({"name": pro,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": province_data.p_lng, "lat": province_data.p_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and not city:  # 省-》市数据
            cities = Company.query.filter_by(province=province).with_entities(Company.city).distinct().all()
            cities = [i[0] for i in cities if i[0]]  # 拿到城市的无重复值
            for cit in cities:
                num = enterprise.filter_by(province=province, city=cit).count()
                city_data = Company.query.filter_by(province=province, city=cit).first()
                df.append({"name": cit,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": city_data.c_lng, "lat": city_data.c_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and not district:  # 市-》区数据
            districts = Company.query.filter_by(province=province, city=city).with_entities(
                Company.district).distinct().all()
            districts = [i[0] for i in districts if i[0]]  # 拿到区县的无重复值
            for dis in districts:
                num = enterprise.filter_by(province=province, city=city, district=dis).count()
                district_data = Company.query.filter_by(province=province, city=city, district=dis).first()
                df.append({"name": dis,
                           "value": num,
                           "color": jishu(num),
                           "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})

            return jsonify(code=RET.OK, msg="获取成功", data=df)
        if province and city and district:  # 区数据
            num = enterprise.filter_by(province=province, city=city, district=district).count()
            district_data = Company.query.filter_by(province=province, city=city, district=district).first()
            print(district_data)
            if district_data:
                df.append({"name": district,
                           "value": num,
                           "color": "",
                           "jwd": {"lng": district_data.d_lng, "lat": district_data.d_lat}})
                return jsonify(code=RET.OK, msg="获取成功", data=df)
            else:
                return jsonify(code=RET.OK, msg="无满足条件数据", data=df)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 招商地图下的散点图（至区后）
@api_atlas.route('/AttractSdmap', methods=['POST'])
# @login_required
def attract_sdmap():
    '''招商地图'''
    req_dict = request.get_json()
    inid = req_dict.get("inid")  # 行业id
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    product = req_dict.get("product")  # 产业产品选择

    # 校验参数完整性
    if not all([district]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        if inid:
            enterprise = Company.query.filter_by(c_type=inid)
        else:
            enterprise = Company.query.filter_by()
        if district:
            enterprise = enterprise.filter_by(province=province, city=city, district=district)
        if product:
            enterprise = enterprise.filter(Company.product_all.like("%{}%".format(product)))
        enterprise = enterprise.all()
        data = []
        if enterprise:
            for com in enterprise:
                data.append({"id": com.id,
                             "name": com.company_name,
                             "jwd": {"lng": com.lng,  # 企业地址出的经纬度
                                     "lat": com.lat}
                             })  # 上下中游
        else:
            return jsonify(code=RET.OK, msg="获取失败，无数据", data=data)

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")

    return jsonify(code=RET.OK, msg="获取成功", data=data)