import json
from aliyunsdkcore.client import AcsClient
from aliyunsdkcore.request import CommonRequest
from flask import current_app, request, jsonify
from apps.models import *
from apps.atlas import api_atlas
from apps.util import login_required, verify_token
from apps.utils.response_code import RET


# 企业信息详情
@api_atlas.route('/enterprise/detail', methods=['POST'])
@login_required
def enterprise_detail():
    '''
    企业信息详情
    :return:
    '''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id

    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Company.query.get(_id)
        user = User.query.get(user_id)  # 获取关注列表
        if user:
            company_ids = [coms.id for coms in user.company]
        else:
            company_ids = []
        if company:
            data = {"id": company.id,
                    "company_name": company.company_name,
                    "telephone": company.telephone if company.telephone else "-",
                    "web_site": company.web_site if company.web_site else "-",
                    "email": company.email if company.email else "-",
                    "address": company.address if company.address else "-",
                    "jwd": {"lng": company.lng if company.lng else "-",
                            "lat": company.lat if company.lat else "-"},
                    "company_info": company.company_info if company.company_info else "-",

                    "high_new": "高新技术企业" if company.high_new == "1" else "",
                    "isfive": "500强企业" if company.isfive == "1" else "",  # 500强
                    "quoted_company": "上市企业" if company.quoted_company == "1" else "",  # 上市企业
                    "tbe": "科技型中小企业" if company.tbe == "1" else "",  # 科技型中小企业
                    "unicorn": "独角兽企业" if company.unicorn == "1" else "",  # 独角兽企业
                    "dengl": "瞪羚企业" if company.dengl == "1" else "",  # 瞪羚企业

                    "legal": company.legal if company.legal else "-",
                    "status": company.status if company.status else "-",
                    "build_date": str(company.build_date)[:10] if company.build_date else "-",
                    "capital": company.capital if company.capital else "-",
                    "social_code": company.social_code if company.social_code else "-",
                    "taking": company.takingn if company.takingn else "-",
                    "bao": company.bao_num if company.bao_num else "-",
                    "entype": company.entype if company.entype else "-",
                    "industry": company.company_industry if company.company_industry else "-",
                    "scope": company.business_scope if company.business_scope else "-",
                    "collect": "1" if company.id in company_ids else "2",  # 关注状态码1关注，2未关注
                    "choice": "1"  # 1太原企业，2全国企业
                    }
        else:
            return jsonify(code=RET.NODATA, msg="查无数据")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 企业收藏与取消
@api_atlas.route('/enterprise/collect', methods=['POST'])
@login_required
def enter_collect():
    '''
    企业收藏与取消
    :return:
    '''
    # 获取用户id
    token = request.headers["token"]
    user = verify_token(token)
    user_id = user.id  # 用户id
    # user_id = 1
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 企业id
    choice = req_dict.get("choice")  # 1太原企业，2全国企业
    collect = req_dict.get("collect")  # 关注状态(1是，2否)

    # 校验参数完整性
    if not all([_id, choice, collect]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        if choice == "1":  # 太原企业
            if collect == "2":  # 未关注，我要关注
                user = User.query.get(user_id)
                coms = Company.query.get(_id)
                user.company.append(coms)
                db.session.commit()
                return jsonify(code=RET.OK, msg="收藏成功", collect="1")
            elif collect == "1":  # 已关注，我要取关
                user = User.query.get(user_id)
                coms = Company.query.get(_id)
                user.company.remove(coms)
                db.session.commit()
                return jsonify(code=RET.OK, msg="取消收藏", collect="2")
            else:
                return jsonify(code=RET.DATAERR, msg="参数异常")
        if choice == "2":  # 全国企业
            if collect == "2":  # 未关注，我要关注
                user = User.query.get(user_id)
                enters = Enterprise.query.get(_id)
                user.enterprise.append(enters)
                db.session.commit()
                return jsonify(code=RET.OK, msg="收藏成功", collect="1")
            elif collect == "1":  # 已关注，我要取关
                user = User.query.get(user_id)
                enters = Enterprise.query.get(_id)
                user.enterprise.remove(enters)
                db.session.commit()
                return jsonify(code=RET.OK, msg="取消收藏", collect="2")
            else:
                return jsonify(code=RET.DATAERR, msg="状态参数异常")
        else:
            return jsonify(code=RET.DATAERR, msg="企业类别参数异常")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 资源机构详情
@api_atlas.route('/orgs/detail', methods=['POST'])
# @login_required
def orgs_detail():
    '''
    资源机构详情
    :return:
    '''
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 机构id
    cate = req_dict.get("cateone")  # 机构类型
    # 校验参数完整性
    if not all([_id, cate]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        # 高等院校
        if cate == 1:
            college = College.query.get(_id)
            if college:
                data = {"id": college.id,
                        "name": college.name,  # 名称
                        "charge": college.charge if college.charge else "-",  # 主管部门
                        "category": college.category if college.category else "-",  # 学校类型
                        "buildate": str(college.buildate) if college.buildate else "-",  # 创办时间
                        "nature": college.nature if college.nature else "-",  # 办学性质
                        "address": college.address if college.address else "-",  # 地址
                        "clas": college.clas if college.clas else "-",  # 学校类别
                        "ccode": college.ccode if college.ccode else "-",  # 学校代码
                        "major": college.major if college.major else "-",  # 专业
                        "faculty": college.faculty if college.faculty else "-",  # 院系设置
                        "feature": college.feature if college.feature else "-",  # 学校特色
                        "introduct": college.introduct if college.introduct else "-",  # 简介
                        "research": college.research if college.research else "-",  # 研究方向

                        "jwd": {"lng": college.lng if college.lng else "-",
                                "lat": college.lat if college.lat else "-"}

                        }
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.NODATA, msg="无数据")
        # 科研机构
        elif cate == 2:
            college = Scientific.query.get(_id)
            if college:
                data = {"id": college.id,
                        "name": college.name,  # 机构名称
                        "telephone": college.telephone if college.telephone else "-",  # 电话
                        "fax": college.fax if college.fax else "-",  # 传真
                        "address": college.address if college.address else "-",  # 地址
                        "postcode": college.postcode if college.postcode else "-",  # 邮编
                        "introduct": college.introduct if college.introduct else "-",  # 机构简介

                        "jwd": {"lng": college.lng if college.lng else "-",
                                "lat": college.lat if college.lat else "-"}
                        }
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.NODATA, msg="无数据")
        # 创新平台
        elif cate == 3:
            college = Lab.query.get(_id)
            if college:
                data = {"id": college.id,
                        "name": college.name,  # 平台名称
                        "introduct": college.introduct if college.introduct else "-",
                        "address": college.address if college.address else "-",  # 地址
                        "jwd": {"lng": college.lng if college.lng else "-",
                                "lat": college.lat if college.lat else "-"}
                        }
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.NODATA, msg="无数据")
        # 产业服务平台
        elif cate == 4:
            college = Platform.query.get(_id)
            if college:
                data = {"id": college.id,
                        "name": college.name,
                        "introduct": college.introduct if college.introduct else "-",
                        "address": college.address if college.address else "-",
                        "research": college.research if college.research else "-",

                        "jwd": {"lng": college.lng if college.lng else "-",
                                "lat": college.lat if college.lat else "-"}
                        }
                return jsonify(code=RET.OK, msg="获取成功", data=data)
            else:
                return jsonify(code=RET.NODATA, msg="无数据")
        else:
            return jsonify(code=RET.DATAERR, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")



# print(get_img_url("690a08cb0aa94b7498ba13b549ee2deb"))
# 太原园区详情
@api_atlas.route('/carrier/detail', methods=['POST'])
# @login_required
def garden_detail():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 园区id

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        iz = Induzone.query.get(_id)
        if iz:
            data = {"id": iz.id,
                    "name": iz.name,  # 园区名
                    "image": str(iz.image),  # 园区图片
                    "level": iz.level,  # 园区级别
                    "cate": iz.cate,  # 园区类型
                    "charge": iz.charge if iz.charge else "-",  # 负责人
                    "phone": iz.phone if iz.phone else "-",  # 联系电话
                    "address": iz.address if iz.address else "-",  # 所在地
                    "cluster": iz.cluster if iz.cluster else "-",  # 产业集群
                    "detail": {"acreage": str(iz.area) + "平方公里" if iz.area else "-",  # 占地面积
                               "actarea": str(iz.actarea) + "平方公里" if iz.actarea else "-",  # 建成面基
                               "tax": str(iz.tax) + "万元/亩" if iz.tax else "-",  # 税收要求
                               "out_power": str(iz.out_power) + "万元/亩" if iz.out_power else "-",  # 产出强度
                               "invest_power": str(iz.invest_power) + "万元/亩" if iz.invest_power else "-",  # 投资强度
                               "indu_need": iz.indu_need if iz.indu_need else "-",  # 行业要求
                               "gdp": str(iz.gdp) + "亿元" if iz.gdp else "-",  # gdp
                               "fiscal": str(iz.fiscal) + "亿元" if iz.fiscal else "-",  # 财政收入（亿元）
                               "indu_land": iz.indu_land if iz.indu_land else "-",  # 工业土地均价
                               "indu_sup": iz.indu_sup if iz.indu_sup else "-",  # 工业土地供应量
                               "comm_land": iz.comm_land if iz.comm_land else "-",  # 商办土地均价
                               "comm_sup": iz.comm_sup if iz.comm_sup else "-",  # 商办土地供应量
                               "represent": iz.represent if iz.represent else "-"  # 代表企业
                               },
                    "invest": {"resident_ele_one": iz.resident_ele_one + "元/度" if iz.resident_ele_one else "-",  # 居民电价一
                               "resident_ele_two": iz.resident_ele_two + "元/度" if iz.resident_ele_two else "-",  # 居民电价二
                               "resident_ele_thr": iz.resident_ele_thr + "元/度" if iz.resident_ele_thr else "-",  # 居民电价三
                               "comm_ele_one": iz.comm_ele_one + "元/度" if iz.comm_ele_one else "-",  # 商业用电1
                               "comm_ele_two": iz.comm_ele_two + "元/度" if iz.comm_ele_two else "-",  # 商业用电2
                               "comm_ele_thr": iz.comm_ele_thr + "元/度" if iz.comm_ele_thr else "-",  # 商业用电3
                               "indu_ele_one": iz.indu_ele_one + "元/度" if iz.indu_ele_one else "-",  # 工业用电1
                               "indu_ele_two": iz.indu_ele_two + "元/度" if iz.indu_ele_two else "-",  # 工业用电2
                               "indu_ele_thr": iz.indu_ele_thr + "元/度" if iz.indu_ele_thr else "-",  # 工业用电3
                               "resident_water_one": iz.resident_water_one + "元/吨" if iz.resident_water_one else "-",
                               # 居民用水1
                               "resident_water_two": iz.resident_water_two + "元/吨" if iz.resident_water_two else "-",
                               # 居民用水2
                               "resident_water_thr": iz.resident_water_thr + "元/吨" if iz.resident_water_thr else "-",
                               # 居民用水3
                               "comm_water": iz.comm_water + "元/吨" if iz.comm_water else "-",  # 商业用水
                               "indu_water": iz.indu_water + "元/吨" if iz.indu_water else "-",  # 工业用水
                               "special_water": iz.special_water + "元/吨" if iz.special_water else "-",  # 特殊用水
                               "resident_natgas_one": iz.resident_natgas_one + "元/m³" if iz.resident_natgas_one else "-",
                               # 居民用气1
                               "resident_natgas_two": iz.resident_natgas_two + "元/m³" if iz.resident_natgas_two else "-",
                               # 居民用气1
                               "resident_natgas_thr": iz.resident_natgas_thr + "元/m³" if iz.resident_natgas_thr else "-",
                               # 居民用气1
                               "sewage": iz.sewage + "元/吨" if iz.sewage else "-",  # 污水处理
                               "wagelevel": iz.wagelevel + "元/月" if iz.wagelevel else "-",  # 最低工资
                               "worker": iz.worker + "元/月" if iz.worker else "-",  # 普通员工
                               "middlemag": iz.middlemag + "元/月" if iz.middlemag else "-",  # 中级管理
                               "highmag": iz.highmag + "元/月" if iz.highmag else "-",  # 高级管理
                               },
                    "config": {"dis_freight": iz.dis_freight if iz.dis_freight else "-",  # 距离货运站距离
                               "dis_port": iz.dis_port if iz.dis_port else "-",  # 距离港口距离
                               "dis_rail": iz.dis_rail if iz.dis_rail else "-",  # 距离高铁距离
                               "dis_air": iz.dis_air if iz.dis_air else "-",  # 距离机场距离
                               "road_trans": iz.road_trans if iz.road_trans else "-",  # 公路运输
                               "rail_trans": iz.rail_trans if iz.rail_trans else "-",  # 铁路运输
                               "live_facility": iz.live_facility if iz.live_facility else "-",  # 园区生活配套
                               "market": iz.market if iz.market else "-",  # 百货
                               "hotel_bus": iz.hotel_bus if iz.hotel_bus else "-",  # 酒店商务
                               "medical": iz.medical if iz.medical else "-",  # 医疗
                               "education": iz.education if iz.education else "-"  # 教育
                               },
                    "indevo": {"induenterprise": iz.induenterprise if iz.induenterprise else "-",  # 规模以上企业
                               "innovate": iz.innovate if iz.innovate else "-",  # 科研机构
                               "base": iz.base if iz.base else "-",  # 双创基地
                               "carrier": iz.carrier if iz.carrier else "-",  # 产业载体
                               },  # 产业发展

                    "intriduce": iz.introduct if iz.introduct else "-",  # 园区介绍
                    "jwd": {"lng": iz.lng if iz.lng else "-",  # 经度
                            "lat": iz.lat if iz.lat else "-"}

                    }
            return jsonify(code=RET.OK, msg="查询成功", data=data)
        else:
            return jsonify(code=RET.PARAMERR, msg="参数错误")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
