from wtforms import Form, FileField, StringField
from wtforms.validators import InputRequired
from flask_wtf.file import FileRequired, FileAllowed


# 验证图片文件
class UploadFormImage(Form):
    image = FileField(validators=[FileRequired(),  # FileRequired必须上传
                                   FileAllowed(['jpg', 'png', 'gif', "jpeg"], message='文件格式错误,或文件名携带中文')
                                   # FileAllowed:必须为指定的格式的文件
                                   ])
    id = StringField(validators=[InputRequired()])


# 验证其他文件
class UploadFormFile(Form):
    file = FileField(validators=[FileRequired(),  # FileRequired必须上传
                                 FileAllowed(['xls', 'xlsx'],
                                             message='文件格式错误')
                                 ])
    id = StringField(validators=[InputRequired()])


# 验证其他文件
class UploadFormDoc(Form):
    file = FileField(validators=[FileRequired(),  # FileRequired必须上传
                                 FileAllowed(['xls', 'xlsx', 'pdf', 'ppt', 'pptx', "doc", "docx", "zip", "rar"],
                                             message='文件格式错误')
                                 ])
    id = StringField(validators=[InputRequired()])
    size = StringField(validators=[InputRequired()])
