"""create table

Revision ID: bc6975965b45
Revises: 
Create Date: 2023-10-30 11:24:19.651422

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bc6975965b45'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('bstage',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(length=32), nullable=True),
    sa.Column('password_hash', sa.String(length=128), nullable=True),
    sa.Column('role', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('carrier_build',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('build_name', sa.String(length=20), nullable=True, comment='楼宇名称'),
    sa.Column('audit_status', sa.Integer(), nullable=True, comment='审核状态 0为未审核；1为审核通过；2为提交；3为驳回；4未通过'),
    sa.Column('audit_message', sa.String(length=50), nullable=True, comment='审核附言'),
    sa.Column('upload_time', sa.DateTime(), nullable=True, comment='数据上传时间'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='数据上传人'),
    sa.Column('upload_people_id', sa.String(length=20), nullable=True, comment='数据上传人用户id'),
    sa.Column('upload_people_role_id', sa.String(length=20), nullable=True, comment='数据上传人权限id'),
    sa.Column('upload_people_belong', sa.String(length=100), nullable=True, comment='数据上传人所属区县、机构、部门'),
    sa.Column('fix_time', sa.DateTime(), nullable=True, comment='数据修改时间'),
    sa.Column('fix_people', sa.String(length=20), nullable=True, comment='数据修改人'),
    sa.Column('lng', sa.String(length=50), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=50), nullable=True, comment='维度'),
    sa.Column('district_name', sa.String(length=50), nullable=True, comment='所属县区'),
    sa.Column('development_area', sa.String(length=50), nullable=True, comment='所属开发区'),
    sa.Column('build_type', sa.String(length=20), nullable=True, comment='楼宇类型(商铺/写字楼/其他)'),
    sa.Column('level', sa.String(length=255), nullable=True, comment='写字楼等级（甲/乙/其他）'),
    sa.Column('detail_address', sa.String(length=20), nullable=True, comment='详细地址（地址需填写准确、详细、精准）'),
    sa.Column('construction_time', sa.String(length=20), nullable=True, comment='建成时间（年）'),
    sa.Column('cover_land_area', sa.String(length=10), nullable=True, comment='总占地面积（㎡）'),
    sa.Column('build_area', sa.Float(), nullable=True, comment='总建筑面积（㎡）'),
    sa.Column('single_area', sa.String(length=20), nullable=True, comment='单层面积（㎡）'),
    sa.Column('empty_area', sa.String(length=20), nullable=True, comment='闲置面积（㎡）'),
    sa.Column('layer_num', sa.Integer(), nullable=True, comment='总层数'),
    sa.Column('car_space_num', sa.Integer(), nullable=True, comment='车位（个）'),
    sa.Column('lift_num', sa.Integer(), nullable=True, comment='电梯（部）'),
    sa.Column('is_water', sa.String(length=20), nullable=True, comment='是否已通水(是/否)'),
    sa.Column('is_electric', sa.String(length=20), nullable=True, comment='是否已通电(是/否)'),
    sa.Column('is_warm', sa.String(length=20), nullable=True, comment='是否已通暖(是/否)'),
    sa.Column('is_gas', sa.String(length=20), nullable=True, comment='是否已通燃气(是/否)'),
    sa.Column('is_internet', sa.String(length=20), nullable=True, comment='是否已通网络(是/否)'),
    sa.Column('is_divide', sa.String(length=20), nullable=True, comment='是否可以分割(是/否)'),
    sa.Column('attract_status', sa.String(length=20), nullable=True, comment='拟招引产业'),
    sa.Column('other_attract_status', sa.String(length=20), nullable=True, comment='其他产业名称'),
    sa.Column('cooperation_model', sa.String(length=20), nullable=True, comment='合作模式(出租/出售/转让)'),
    sa.Column('rent_money', sa.Float(), nullable=True, comment='租金（元/平米/天）'),
    sa.Column('wuye_money', sa.Float(), nullable=True, comment='物业费（元/平米/月）'),
    sa.Column('linkman', sa.String(length=20), nullable=True, comment='联系人'),
    sa.Column('link_mobile', sa.String(length=20), nullable=True, comment='联系方式'),
    sa.Column('inside_picture_url', sa.String(length=255), nullable=True, comment='内部照片url'),
    sa.Column('outer_picture_url', sa.String(length=255), nullable=True, comment='外部照片url'),
    sa.Column('price_url', sa.String(length=255), nullable=True, comment='平面图url'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业载体-楼宇数据表'
    )
    op.create_table('carrier_energy',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('district_name', sa.String(length=20), nullable=True, comment='区域名称'),
    sa.Column('electric_one', sa.String(length=50), nullable=True, comment='居民用电（一档）(元/度)'),
    sa.Column('electric_two', sa.String(length=50), nullable=True, comment='居民用电（二档）(元/度)'),
    sa.Column('electric_three', sa.String(length=20), nullable=True, comment='居民用电（三档）(元/度)'),
    sa.Column('business_electric_feng', sa.String(length=20), nullable=True, comment='商业用电（峰段）(元/度)'),
    sa.Column('business_electric_ping', sa.String(length=20), nullable=True, comment='商业用电（平段）(元/度)'),
    sa.Column('business_electric_gu', sa.String(length=20), nullable=True, comment='商业用电（谷段）(元/度)'),
    sa.Column('industrial_electric_feng', sa.String(length=20), nullable=True, comment='工业电价（峰段）(元/度)'),
    sa.Column('industrial_electric_ping', sa.String(length=20), nullable=True, comment='工业电价（平段）(元/度)'),
    sa.Column('industrial_electric_gu', sa.String(length=20), nullable=True, comment='工业电价（谷段）(元/度)'),
    sa.Column('life_water_one', sa.String(length=20), nullable=True, comment='居民用水（一档）(元/吨)'),
    sa.Column('life_water_two', sa.String(length=20), nullable=True, comment='居民用水（二档）(元/吨)'),
    sa.Column('life_water_three', sa.String(length=20), nullable=True, comment='居民用水（三档）(元/吨)'),
    sa.Column('business_water', sa.String(length=20), nullable=True, comment='商业用水(元/吨)'),
    sa.Column('industrial_water', sa.String(length=20), nullable=True, comment='工业用水(元/吨)'),
    sa.Column('special_water', sa.String(length=20), nullable=True, comment='特种用水(元/吨)'),
    sa.Column('life_gas_one', sa.String(length=20), nullable=True, comment='居民用气（一档）(元/m³)'),
    sa.Column('life_gas_two', sa.String(length=20), nullable=True, comment='居民用气（二档）(元/m³)'),
    sa.Column('life_gas_three', sa.String(length=20), nullable=True, comment='居民用气（三档）(元/m³)'),
    sa.PrimaryKeyConstraint('id'),
    comment='载体资源库-产业地图-水电气热能源数据表'
    )
    op.create_table('carrier_factory',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('factory_name', sa.String(length=20), nullable=True, comment='厂房名称'),
    sa.Column('lng', sa.String(length=50), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=50), nullable=True, comment='维度'),
    sa.Column('district_name', sa.String(length=50), nullable=True, comment='所属县区'),
    sa.Column('development_area', sa.String(length=50), nullable=True, comment='所属开发区'),
    sa.Column('build_type', sa.String(length=20), nullable=True, comment='厂房类型（单层/多层/混合层）'),
    sa.Column('is_standard', sa.String(length=20), nullable=True, comment='是否标准化厂房(是/否)'),
    sa.Column('detail_address', sa.String(length=50), nullable=True, comment='详细地址（地址需填写准确、详细、精准）'),
    sa.Column('construction_time', sa.String(length=20), nullable=True, comment='建成时间（年）'),
    sa.Column('cover_land_area', sa.String(length=20), nullable=True, comment='总占地面积（㎡）'),
    sa.Column('factory_area', sa.Float(), nullable=True, comment='总建筑面积（㎡）'),
    sa.Column('empty_area', sa.String(length=20), nullable=True, comment='闲置面积（㎡）'),
    sa.Column('layer_num', sa.String(length=20), nullable=True, comment='总层数'),
    sa.Column('factory_structure', sa.String(length=20), nullable=True, comment='建筑结构（混凝土框架、钢结构、砖混、砖混钢筋、钢筋混凝土、轻钢）'),
    sa.Column('width', sa.String(length=10), nullable=True, comment='跨度（m）'),
    sa.Column('high', sa.String(length=20), nullable=True, comment='层高（m）'),
    sa.Column('bearing', sa.String(length=20), nullable=True, comment='承重（kg/㎡）'),
    sa.Column('is_water', sa.String(length=20), nullable=True, comment='是否已通水(是/否)'),
    sa.Column('is_electric', sa.String(length=20), nullable=True, comment='是否已通电(是/否)'),
    sa.Column('is_warm', sa.String(length=20), nullable=True, comment='是否已通暖(是/否)'),
    sa.Column('is_gas', sa.String(length=20), nullable=True, comment='是否已通燃气(是/否)'),
    sa.Column('is_network', sa.String(length=20), nullable=True, comment='是否已通网络(是/否)'),
    sa.Column('is_car', sa.String(length=20), nullable=True, comment='是否可安装天车'),
    sa.Column('lift_num', sa.String(length=20), nullable=True, comment='电梯(部)'),
    sa.Column('attract_status', sa.String(length=20), nullable=True, comment='拟招引产业（下拉筛选）'),
    sa.Column('settled_enterprise', sa.String(length=20), nullable=True, comment='已入驻企业（企业全称，使用面积）'),
    sa.Column('cooperation_model', sa.String(length=20), nullable=True, comment='合作模式(出租/出售/转让)'),
    sa.Column('rent_money', sa.String(length=20), nullable=True, comment='租金（元/平米/天）'),
    sa.Column('linkman', sa.String(length=20), nullable=True, comment='联系人'),
    sa.Column('link_mobile', sa.String(length=20), nullable=True, comment='联系方式'),
    sa.Column('inside_picture_url', sa.String(length=255), nullable=True, comment='内部照片url'),
    sa.Column('outer_picture_url', sa.String(length=255), nullable=True, comment='外部照片url'),
    sa.Column('price_url', sa.String(length=255), nullable=True, comment='平面图url'),
    sa.Column('upload_time', sa.DateTime(), nullable=True, comment='数据上传时间'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='数据上传人名字'),
    sa.Column('upload_people_id', sa.String(length=20), nullable=True, comment='数据上传人用户id'),
    sa.Column('upload_people_role_id', sa.String(length=20), nullable=True, comment='数据上传人权限id'),
    sa.Column('upload_people_belong', sa.String(length=100), nullable=True, comment='数据上传人所属区县、机构、部门'),
    sa.Column('fix_time', sa.DateTime(), nullable=True, comment='数据修改时间'),
    sa.Column('fix_people', sa.String(length=20), nullable=True, comment='数据修改人名字'),
    sa.Column('audit_status', sa.String(length=20), nullable=True, comment='审核状态 0为未审核；1为审核通过；2为提交；3为驳回；4未通过；'),
    sa.Column('audit_message', sa.String(length=50), nullable=True, comment='审核附言'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业载体-厂房数据表'
    )
    op.create_table('carrier_land',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('land_name', sa.String(length=20), nullable=True, comment='土地名称'),
    sa.Column('upload_time', sa.DateTime(), nullable=True, comment='数据上传时间'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='数据上传人名字'),
    sa.Column('upload_people_id', sa.String(length=20), nullable=True, comment='数据上传人用户id'),
    sa.Column('upload_people_role_id', sa.String(length=20), nullable=True, comment='数据上传人权限id'),
    sa.Column('upload_people_belong', sa.String(length=100), nullable=True, comment='数据上传人所属区县、机构、部门'),
    sa.Column('fix_time', sa.DateTime(), nullable=True, comment='数据修改时间'),
    sa.Column('fix_people', sa.String(length=20), nullable=True, comment='数据修改人名字'),
    sa.Column('audit_status', sa.Integer(), nullable=True, comment='审核状态 0为未审核；1为审核通过；2为提交；3为驳回；4未通过'),
    sa.Column('audit_message', sa.String(length=50), nullable=True, comment='审核附言'),
    sa.Column('lng', sa.String(length=50), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=50), nullable=True, comment='维度'),
    sa.Column('land_code', sa.String(length=20), nullable=True, comment='土地编码'),
    sa.Column('district_name', sa.String(length=50), nullable=True, comment='所属县区'),
    sa.Column('development_area', sa.String(length=20), nullable=True, comment='所属开发区'),
    sa.Column('detail_address', sa.String(length=50), nullable=True, comment='土地位置'),
    sa.Column('land_use', sa.String(length=255), nullable=True, comment='用地四至'),
    sa.Column('land_nature', sa.String(length=20), nullable=True, comment='用地性质(工业用地/商服用地/物流仓储用地/科研用地/居住用地)（包括用地性质类别代码）'),
    sa.Column('total_area', sa.Float(), nullable=True, comment='用地面积（净用地面积）（公顷）'),
    sa.Column('surface_area', sa.String(length=20), nullable=True, comment='地上控制建面（㎡）'),
    sa.Column('plot_ratio', sa.String(length=10), nullable=True, comment='容积率'),
    sa.Column('greening_rate', sa.String(length=20), nullable=True, comment='绿化率'),
    sa.Column('density', sa.String(length=20), nullable=True, comment='建筑密度'),
    sa.Column('height_permitted', sa.String(length=20), nullable=True, comment='限高（㎡）'),
    sa.Column('transfer_year', sa.String(length=20), nullable=True, comment='出让年限'),
    sa.Column('develop_degree', sa.String(length=20), nullable=True, comment='用地开发程度（请详细描述几通一平）'),
    sa.Column('investment_intensity', sa.String(length=20), nullable=True, comment='投资强度（万元/亩）'),
    sa.Column('output_intensity', sa.String(length=20), nullable=True, comment='产出强度（万元/亩）'),
    sa.Column('tax', sa.String(length=20), nullable=True, comment='地均税收（万元/亩）'),
    sa.Column('linkman', sa.String(length=20), nullable=True, comment='联系人'),
    sa.Column('telephone', sa.String(length=20), nullable=True, comment='联系方式'),
    sa.Column('price_url', sa.String(length=255), nullable=True, comment='用地红线图'),
    sa.Column('other_requirements', sa.String(length=20), nullable=True, comment='其他要求'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业载体-土地数据表'
    )
    op.create_table('city',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='经济指标主键id'),
    sa.Column('area', sa.String(length=255), nullable=True, comment='区县名称'),
    sa.Column('size', sa.Float(), nullable=True, comment='区县面积'),
    sa.Column('year', sa.Integer(), nullable=True, comment='年份'),
    sa.Column('people', sa.Integer(), nullable=True, comment='人口'),
    sa.Column('GDP', sa.Float(), nullable=True, comment='GDP(万元)'),
    sa.Column('addscale', sa.Float(), nullable=True, comment='规上工业增加值'),
    sa.Column('investment', sa.Float(), nullable=True, comment='固定投资资产'),
    sa.Column('retail', sa.Float(), nullable=True, comment='社会消费品零售总额'),
    sa.Column('in_out', sa.Float(), nullable=True, comment='进出口总额'),
    sa.Column('public', sa.Float(), nullable=True, comment='一般公共预算支出'),
    sa.Column('people_out', sa.Float(), nullable=True, comment='居然人均可支配收入'),
    sa.Column('people_per', sa.Float(), nullable=True, comment='居民消费价格指数'),
    sa.Column('public_in', sa.Float(), nullable=True, comment='一般公共预算收入'),
    sa.Column('info', sa.Text(), nullable=True, comment='基本信息'),
    sa.Column('question', sa.Text(), nullable=True, comment='标注'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='数据标识 1整年数据，2阶段数据'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-区县经济指标表'
    )
    op.create_table('college',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('category', sa.String(length=255), nullable=True),
    sa.Column('cateid', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('ccode', sa.String(length=255), nullable=True),
    sa.Column('buildate', sa.String(length=255), nullable=True),
    sa.Column('nature', sa.String(length=255), nullable=True),
    sa.Column('clas', sa.String(length=255), nullable=True),
    sa.Column('feature', sa.String(length=255), nullable=True),
    sa.Column('charge', sa.String(length=255), nullable=True),
    sa.Column('major', sa.String(length=255), nullable=True),
    sa.Column('faculty', sa.String(length=255), nullable=True),
    sa.Column('introduct', sa.Text(), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True),
    sa.Column('lng', sa.String(length=255), nullable=True),
    sa.Column('lat', sa.String(length=255), nullable=True),
    sa.Column('navigator', sa.String(length=255), nullable=True),
    sa.Column('navigat', sa.String(length=255), nullable=True),
    sa.Column('research', sa.String(length=255), nullable=True),
    sa.Column('admin', sa.String(length=255), nullable=True),
    sa.Column('developarea', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    comment='创新资源-高等院校表'
    )
    op.create_table('company',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业主键id'),
    sa.Column('company_id', sa.String(length=255), nullable=True, comment='企业id'),
    sa.Column('company_name', sa.String(length=255), nullable=True, comment='企业名'),
    sa.Column('chain_master', sa.String(length=20), nullable=True, comment='链主企业'),
    sa.Column('status', sa.String(length=32), nullable=True, comment='经营状态'),
    sa.Column('legal', sa.String(length=32), nullable=True, comment='法定代表人'),
    sa.Column('capital', sa.String(length=255), nullable=True, comment='注册资本,22万美元'),
    sa.Column('capital_nums', sa.Float(), nullable=True, comment='注册资本转换成人民币数值'),
    sa.Column('capital_id', sa.Integer(), nullable=True, comment='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6'),
    sa.Column('build_date', sa.DateTime(), nullable=True, comment='注册时间'),
    sa.Column('yearid', sa.Integer(), nullable=True, comment='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）'),
    sa.Column('province', sa.String(length=32), nullable=True, comment='省'),
    sa.Column('city', sa.String(length=32), nullable=True, comment='市'),
    sa.Column('district', sa.String(length=32), nullable=True, comment='区'),
    sa.Column('lng', sa.String(length=100), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=100), nullable=True, comment='纬度'),
    sa.Column('c_lng', sa.String(length=100), nullable=True, comment='市经度'),
    sa.Column('c_lat', sa.String(length=100), nullable=True, comment='市纬度'),
    sa.Column('d_lng', sa.String(length=100), nullable=True, comment='区经度'),
    sa.Column('d_lat', sa.String(length=100), nullable=True, comment='区纬度'),
    sa.Column('address', sa.String(length=255), nullable=True, comment='企业地址'),
    sa.Column('telephone', sa.Text(), nullable=True, comment='电话'),
    sa.Column('telephone_more', sa.Text(), nullable=True, comment='更多电话'),
    sa.Column('email', sa.Text(), nullable=True, comment='邮箱'),
    sa.Column('social_code', sa.String(length=100), nullable=True, comment='统一社会信用代码'),
    sa.Column('tax_code', sa.String(length=100), nullable=True, comment='纳税人识别号'),
    sa.Column('register_code', sa.String(length=100), nullable=True, comment='注册号'),
    sa.Column('company_code', sa.String(length=100), nullable=True, comment='组织机构代码'),
    sa.Column('bao_num', sa.Integer(), nullable=True, comment='参保人数'),
    sa.Column('entype', sa.String(length=100), nullable=True, comment='企业类型'),
    sa.Column('entypeid', sa.Integer(), nullable=True, comment='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)'),
    sa.Column('company_industry', sa.String(length=100), nullable=True, comment='所属行业'),
    sa.Column('web_site', sa.String(length=255), nullable=True, comment='企业网址'),
    sa.Column('business_scope', sa.Text(), nullable=True, comment='企业经营范围'),
    sa.Column('register_org', sa.String(length=100), nullable=True, comment='登记机关'),
    sa.Column('money_type', sa.String(length=100), nullable=True, comment='注册币种'),
    sa.Column('money_type_id', sa.Integer(), nullable=True, comment='注册币种类型id'),
    sa.Column('high_new', sa.String(length=32), nullable=True, comment='是否高新技术企业'),
    sa.Column('parti_year', sa.Integer(), nullable=True, comment='高新企业注册年份'),
    sa.Column('tbe', sa.String(length=32), nullable=True, comment='是否科技型中小企业'),
    sa.Column('tbe_sjmy', sa.String(length=32), nullable=True, comment='是否为省级民营科技企业'),
    sa.Column('fianacing', sa.String(length=32), nullable=True, comment='是否为有融资企业'),
    sa.Column('fianacing_rounds', sa.String(length=32), nullable=True, comment='融资轮次'),
    sa.Column('roundid', sa.Integer(), nullable=True, comment='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）'),
    sa.Column('financing_amount', sa.Float(), nullable=True, comment='融资金额'),
    sa.Column('software_copyright', sa.String(length=32), nullable=True, comment='是否为有软件著作权'),
    sa.Column('num_software', sa.Integer(), nullable=True, comment='软件著作权个数'),
    sa.Column('public_sector', sa.String(length=32), nullable=True, comment='上市板块'),
    sa.Column('quoted_company', sa.String(length=32), nullable=True, comment='是否上市企业'),
    sa.Column('public_id', sa.Integer(), nullable=True, comment='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)'),
    sa.Column('foreign_investment', sa.String(length=32), nullable=True, comment='是否外商投资'),
    sa.Column('patent', sa.String(length=32), nullable=True, comment='是否为有专利企业'),
    sa.Column('num_patent', sa.Integer(), nullable=True, comment='专利个数'),
    sa.Column('induzone', sa.String(length=255), nullable=True, comment='所在园区'),
    sa.Column('company_info', sa.Text(), nullable=True, comment='公司简介'),
    sa.Column('sxmon', sa.String(length=32), nullable=True, comment='是否山西民营100强'),
    sa.Column('zjtg', sa.String(length=32), nullable=True, comment='是否为山西专精特新企业'),
    sa.Column('zjtg_gjjxjr', sa.String(length=32), nullable=True, comment='是否为国家级专精特新小巨人企业'),
    sa.Column('zjtg_sjxjr', sa.String(length=32), nullable=True, comment='是否为省级专精特新小巨人企业'),
    sa.Column('unicorn', sa.String(length=32), nullable=True, comment='独角兽企业'),
    sa.Column('dengl', sa.String(length=32), nullable=True, comment='瞪羚'),
    sa.Column('hncode', sa.String(length=32), nullable=True, comment='高企证书编号'),
    sa.Column('isfive', sa.String(length=32), nullable=True, comment='是否中国500强'),
    sa.Column('istyfive', sa.String(length=32), nullable=True, comment='是否2020中国500强'),
    sa.Column('quotedate', sa.DateTime(), nullable=True, comment='上市时间'),
    sa.Column('sxonhun', sa.String(length=32), nullable=True, comment='是否山西100强'),
    sa.Column('product_all', sa.String(length=255), nullable=True, comment='公司拥有产品'),
    sa.Column('scale', sa.String(length=32), nullable=True, comment='规模以上企业'),
    sa.Column('serve', sa.String(length=32), nullable=True, comment='限额以上服务业'),
    sa.Column('takingn', sa.Float(), nullable=True, comment='营收 (万元)'),
    sa.Column('ouputn', sa.Float(), nullable=True, comment='年产值'),
    sa.Column('profit', sa.Float(), nullable=True, comment='公司利润（万元）'),
    sa.Column('c_name', sa.String(length=255), nullable=True, comment='行业类名'),
    sa.Column('c_type', sa.Integer(), nullable=True, comment='行业类id'),
    sa.Column('f_name', sa.String(length=255), nullable=True, comment='父行业类名'),
    sa.Column('f_type', sa.Integer(), nullable=True, comment='父行业类id'),
    sa.Column('hots', sa.Integer(), nullable=True, comment='企业热度'),
    sa.Column('sort_num', sa.Integer(), nullable=True, comment='权重值'),
    sa.Column('stream', sa.String(length=32), nullable=True, comment='行业上下游'),
    sa.Column('product', sa.String(length=255), nullable=True, comment='生产产品'),
    sa.PrimaryKeyConstraint('id'),
    comment='晋城企业表'
    )
    op.create_index(op.f('ix_company_company_id'), 'company', ['company_id'], unique=False)
    op.create_table('company_certificate',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('start_date', sa.String(length=32), nullable=True, comment='发证时间'),
    sa.Column('type', sa.String(length=32), nullable=True, comment='证书类型'),
    sa.Column('cert_name', sa.String(length=32), nullable=True, comment='证书名称'),
    sa.Column('cert_no', sa.String(length=32), nullable=True, comment='证书号'),
    sa.Column('end_date', sa.String(length=32), nullable=True, comment='截止时间'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业表资质证书'
    )
    op.create_table('company_client',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业客户主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('client_name', sa.String(length=32), nullable=True, comment='客户'),
    sa.Column('ratio', sa.String(length=32), nullable=True, comment='销售占比'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='销售金额'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开时间'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='数据来源'),
    sa.Column('relation', sa.String(length=32), nullable=True, comment='关联关系'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业客户数据表'
    )
    op.create_table('company_equity',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='股权出质主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('reg_number', sa.String(length=32), nullable=True, comment='等级编号'),
    sa.Column('pledgor', sa.String(length=10), nullable=True, comment='出质人'),
    sa.Column('target_company', sa.String(length=25), nullable=True, comment='出质股权的企业'),
    sa.Column('pledgee', sa.String(length=10), nullable=True, comment='质权人'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='出质股权数额（万元）'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='登记日期'),
    sa.Column('status', sa.String(length=10), nullable=True, comment='状态'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业详情股权出质'
    )
    op.create_table('company_industry_point',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('district', sa.String(length=32), nullable=True, comment='区县园区名'),
    sa.Column('point', sa.Float(), nullable=True, comment='分数'),
    sa.Column('f_type', sa.Integer(), nullable=True, comment='类型，对应产业导航nid'),
    sa.PrimaryKeyConstraint('id'),
    comment='选址评分部分--企业聚合度数据表'
    )
    op.create_table('company_inout_info',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业进出口信用主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('customs_registered_address', sa.String(length=32), nullable=True, comment='注册海关'),
    sa.Column('management_category', sa.String(length=32), nullable=True, comment='经营类别'),
    sa.Column('record_date', sa.DateTime(), nullable=True, comment='注册日期'),
    sa.Column('industry_category', sa.String(length=32), nullable=True, comment='行业类别'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业进出口信用数据表'
    )
    op.create_table('company_licence',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业行政许可主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('licence_no', sa.String(length=32), nullable=True, comment='企业行政许可编号'),
    sa.Column('licence_name', sa.String(length=32), nullable=True, comment='企业行政许可证名称'),
    sa.Column('from_date', sa.String(length=32), nullable=True, comment='有效期自'),
    sa.Column('end_date', sa.String(length=32), nullable=True, comment='有效期至'),
    sa.Column('license_org', sa.String(length=32), nullable=True, comment='许可机关'),
    sa.Column('licence_content', sa.String(length=32), nullable=True, comment='许可内容'),
    sa.Column('source', sa.String(length=32), nullable=True, comment='来源'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业行政许可数据表'
    )
    op.create_table('company_patent',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='专利信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('name', sa.String(length=50), nullable=True, comment='发明名称'),
    sa.Column('type', sa.String(length=20), nullable=True, comment='类型'),
    sa.Column('status', sa.String(length=20), nullable=True, comment='法律状态'),
    sa.Column('apply_number', sa.String(length=50), nullable=True, comment='申请号'),
    sa.Column('apply_date', sa.String(length=32), nullable=True, comment='申请日'),
    sa.Column('pub_number', sa.String(length=20), nullable=True, comment='公开号'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开日期'),
    sa.Column('inventor', sa.String(length=20), nullable=True, comment='发明人'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业详情专利信息'
    )
    op.create_table('company_punish',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='处罚日期'),
    sa.Column('punish_no', sa.String(length=32), nullable=True, comment='决定文书号'),
    sa.Column('punish_reason', sa.String(length=32), nullable=True, comment='处罚事由'),
    sa.Column('punish_content', sa.String(length=32), nullable=True, comment='处罚结果/内容'),
    sa.Column('punish_org', sa.String(length=32), nullable=True, comment='处罚单位'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='来源'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业表行政处罚'
    )
    op.create_table('company_supplier',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业供应商主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('supplier_name', sa.String(length=32), nullable=True, comment='客户名字'),
    sa.Column('ratio', sa.String(length=32), nullable=True, comment='采购占比'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='采购金额'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开时间'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='数据来源'),
    sa.Column('relation', sa.String(length=32), nullable=True, comment='关联关系'),
    sa.Column('lng', sa.String(length=100), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=100), nullable=True, comment='纬度'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业供应商数据表'
    )
    op.create_table('company_tax_info',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业税务信用主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('name', sa.String(length=32), nullable=True, comment='名称'),
    sa.Column('year', sa.String(length=32), nullable=True, comment='评价年度'),
    sa.Column('id_number', sa.String(length=32), nullable=True, comment='纳税人识别号'),
    sa.Column('grade', sa.String(length=32), nullable=True, comment='纳税信用等级'),
    sa.Column('eval_department', sa.String(length=32), nullable=True, comment='单位评价'),
    sa.Column('type', sa.String(length=32), nullable=True, comment='类型'),
    sa.Column('business_id', sa.String(length=32), nullable=True, comment='数据id'),
    sa.PrimaryKeyConstraint('id'),
    comment='企业税务信用数据表'
    )
    op.create_table('customer_consultation',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('user_id', sa.Integer(), nullable=True, comment='访客id，属于哪位访客'),
    sa.Column('project_name', sa.String(length=200), nullable=True, comment='项目名称'),
    sa.Column('investor', sa.String(length=100), nullable=True, comment='投资方名称'),
    sa.Column('investor_place', sa.String(length=100), nullable=True, comment='投资方所在地'),
    sa.Column('project_type', sa.String(length=200), nullable=True, comment='项目类型'),
    sa.Column('investment_volume', sa.Float(), nullable=True, comment='总投资额'),
    sa.Column('basic_information', sa.Text(), nullable=True, comment='项目方基本情况'),
    sa.Column('land_area', sa.Text(), nullable=True, comment='拟落地区域'),
    sa.Column('linkman', sa.String(length=20), nullable=True, comment='联系人'),
    sa.Column('link_mobile', sa.String(length=20), nullable=True, comment='联系方式'),
    sa.Column('consultation_time', sa.DateTime(), nullable=True, comment='咨询/回复时间'),
    sa.Column('reply_time', sa.DateTime(), nullable=True, comment='回复时间'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='是否已回复 0否1是'),
    sa.Column('is_sync', sa.Integer(), nullable=True, comment='是否同步到平台 0否1是'),
    sa.Column('reply_content', sa.Text(), nullable=True, comment='回复内容'),
    sa.PrimaryKeyConstraint('id'),
    comment='小程序-客户咨询信息表'
    )
    op.create_table('district_resource',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='园区主键id'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='区县名称'),
    sa.Column('domestic_water', sa.Float(), nullable=True, comment='居民生活用水（元 / 立方米）'),
    sa.Column('not_Domestic_water', sa.Float(), nullable=True, comment='非居民用水（元 / 立方米）'),
    sa.Column('special_water', sa.Float(), nullable=True, comment='特种用水（元 / 立方米）'),
    sa.Column('electricity_life', sa.Float(), nullable=True, comment='居民生活电价'),
    sa.Column('electricity_commercial', sa.Float(), nullable=True, comment='商业电价'),
    sa.Column('electricity_industrial', sa.Float(), nullable=True, comment='工业电价'),
    sa.Column('gas_city', sa.Float(), nullable=True, comment='城市居民用气（元 / 立方米）'),
    sa.Column('gas_commercial', sa.Float(), nullable=True, comment='工商业用气（元 / 立方米）'),
    sa.Column('hot_life', sa.Float(), nullable=True, comment='居民用热（元 / 平方米）'),
    sa.Column('not_hot_life', sa.Float(), nullable=True, comment='非居民用热（元 / 平方米）'),
    sa.PrimaryKeyConstraint('id'),
    comment='现状图谱-投资成本-水电气暖价格'
    )
    op.create_table('enterprise',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业主键id主键id'),
    sa.Column('chain_master', sa.String(length=20), nullable=True, comment='链主企业'),
    sa.Column('company_id', sa.String(length=255), nullable=True, comment='企业id'),
    sa.Column('company_name', sa.String(length=255), nullable=True, comment='企业名'),
    sa.Column('status', sa.String(length=32), nullable=True, comment='经营状态'),
    sa.Column('legal', sa.String(length=255), nullable=True, comment='发定代表人'),
    sa.Column('capital', sa.String(length=255), nullable=True, comment='注册资本,22万美元'),
    sa.Column('capital_nums', sa.Float(), nullable=True, comment='注册资本转换成人民币数值'),
    sa.Column('capital_id', sa.Integer(), nullable=True, comment='注册资本大小类型，0-100,1,100-500,2,500-1000,3,1000-5000,4,5000-10000,5,10000+，6'),
    sa.Column('build_date', sa.DateTime(), nullable=True, comment='注册时间'),
    sa.Column('yearid', sa.Integer(), nullable=True, comment='成立时间年限id(1-3，1)(3-5，2)(5-8，3)（8-10，4）（10-15,5）（15以上，6）'),
    sa.Column('province', sa.String(length=32), nullable=True, comment='省'),
    sa.Column('city', sa.String(length=32), nullable=True, comment='市'),
    sa.Column('district', sa.String(length=32), nullable=True, comment='区'),
    sa.Column('lng', sa.String(length=100), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=100), nullable=True, comment='纬度'),
    sa.Column('p_lng', sa.String(length=100), nullable=True, comment='省经度'),
    sa.Column('p_lat', sa.String(length=100), nullable=True, comment='省纬度'),
    sa.Column('c_lng', sa.String(length=100), nullable=True, comment='市经度'),
    sa.Column('c_lat', sa.String(length=100), nullable=True, comment='市纬度'),
    sa.Column('d_lng', sa.String(length=100), nullable=True, comment='区经度'),
    sa.Column('d_lat', sa.String(length=100), nullable=True, comment='区纬度'),
    sa.Column('address', sa.String(length=255), nullable=True, comment='企业地址'),
    sa.Column('telephone', sa.Text(), nullable=True, comment='电话'),
    sa.Column('telephone_more', sa.Text(), nullable=True, comment='更多电话'),
    sa.Column('email', sa.Text(), nullable=True, comment='邮箱'),
    sa.Column('social_code', sa.String(length=100), nullable=True, comment='统一社会信用代码'),
    sa.Column('tax_code', sa.String(length=100), nullable=True, comment='纳税人识别号'),
    sa.Column('register_code', sa.String(length=100), nullable=True, comment='注册号'),
    sa.Column('company_code', sa.String(length=100), nullable=True, comment='组织机构代码'),
    sa.Column('bao_num', sa.Integer(), nullable=True, comment='参保人数'),
    sa.Column('entype', sa.String(length=100), nullable=True, comment='企业类型'),
    sa.Column('entypeid', sa.Integer(), nullable=True, comment='公司类型id(个人独资企业-1)(股份有限公司-2)(有限责任公司-3)(合伙企业-4)(集体所有制-5)(全民所有制企业-6)(外商企业-7)'),
    sa.Column('scale_range', sa.Integer(), nullable=True, comment='企业规模id，1：20人以下，2:20-99人，3:100-499人，4：500-999人，5： 1000-4999人，6：5000-9999人，7:10000人'),
    sa.Column('company_industry', sa.String(length=100), nullable=True, comment='所属行业'),
    sa.Column('web_site', sa.String(length=255), nullable=True, comment='企业网址'),
    sa.Column('business_scope', sa.Text(), nullable=True, comment='企业经营范围'),
    sa.Column('register_org', sa.String(length=100), nullable=True, comment='登记机关'),
    sa.Column('money_type', sa.String(length=100), nullable=True, comment='注册币种'),
    sa.Column('money_type_id', sa.Integer(), nullable=True, comment='注册币种类型id'),
    sa.Column('high_new', sa.String(length=32), nullable=True, comment='是否高新技术企业'),
    sa.Column('parti_year', sa.Integer(), nullable=True, comment='高新企业注册年份'),
    sa.Column('tbe', sa.String(length=32), nullable=True, comment='是否科技型中小企业'),
    sa.Column('tbe_sjmy', sa.String(length=32), nullable=True, comment='是否为省级民营科技企业'),
    sa.Column('zjtg', sa.String(length=32), nullable=True, comment='是否为专精特新企业'),
    sa.Column('zjtg_gjjxjr', sa.String(length=32), nullable=True, comment='是否为国家级专精特新小巨人企业'),
    sa.Column('zjtg_sjxjr', sa.String(length=32), nullable=True, comment='是否为省级专精特新小巨人企业'),
    sa.Column('fianacing', sa.String(length=32), nullable=True, comment='是否为有融资企业'),
    sa.Column('fianacing_rounds', sa.String(length=32), nullable=True, comment='融资轮次'),
    sa.Column('roundid', sa.Integer(), nullable=True, comment='融资轮次id(天使/种子，1)（PreA/A+,2）（PreB/B+,3）(C轮以上，4)（收并购，5）（战略投资，6）（其他，7）'),
    sa.Column('financing_amount', sa.Float(), nullable=True, comment='融资金额'),
    sa.Column('software_copyright', sa.String(length=32), nullable=True, comment='是否为有软件著作权'),
    sa.Column('num_software', sa.Integer(), nullable=True, comment='软件著作权个数'),
    sa.Column('quoted_company', sa.String(length=32), nullable=True, comment='是否上市企业'),
    sa.Column('public_sector', sa.String(length=32), nullable=True, comment='上市板块'),
    sa.Column('public_id', sa.Integer(), nullable=True, comment='上市版块的id----360企业画像（A股,1）(创业股，2)(港股，3)(新三股，4)(新四股,5)(中小板,6)'),
    sa.Column('foreign_investment', sa.String(length=32), nullable=True, comment='是否外商投资'),
    sa.Column('patent', sa.String(length=32), nullable=True, comment='是否为有专利企业'),
    sa.Column('num_patent', sa.Integer(), nullable=True, comment='专利个数'),
    sa.Column('company_info', sa.Text(), nullable=True, comment='公司简介'),
    sa.Column('dengl', sa.String(length=32), nullable=True, comment='瞪羚'),
    sa.Column('unicorn', sa.String(length=32), nullable=True, comment='独角兽企业'),
    sa.Column('isfive', sa.String(length=32), nullable=True, comment='是否中国500强'),
    sa.Column('takingn', sa.Float(), nullable=True, comment='营收'),
    sa.Column('hots', sa.Integer(), nullable=True, comment='企业热度(权重值)'),
    sa.Column('c_name', sa.String(length=255), nullable=True, comment='行业类名'),
    sa.Column('c_type', sa.Integer(), nullable=True, comment='行业类id'),
    sa.Column('product_all', sa.String(length=255), nullable=True, comment='公司拥有产品'),
    sa.Column('c_name1', sa.String(length=255), nullable=True, comment='行业类名'),
    sa.Column('c_type1', sa.Integer(), nullable=True, comment='行业类id'),
    sa.Column('product_all1', sa.String(length=255), nullable=True, comment='公司拥有产品'),
    sa.Column('c_name2', sa.String(length=255), nullable=True, comment='行业类名'),
    sa.Column('c_type2', sa.Integer(), nullable=True, comment='行业类id'),
    sa.Column('product_all2', sa.String(length=255), nullable=True, comment='公司拥有产品'),
    sa.Column('f_name', sa.String(length=255), nullable=True, comment='父行业类名'),
    sa.Column('f_type', sa.Integer(), nullable=True, comment='父行业类id'),
    sa.Column('sxonhun', sa.String(length=32), nullable=True, comment='是否山西100强'),
    sa.Column('scale', sa.String(length=32), nullable=True, comment='规模以上企业'),
    sa.Column('serve', sa.String(length=32), nullable=True, comment='限额以上服务业'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表'
    )
    op.create_index(op.f('ix_enterprise_c_type'), 'enterprise', ['c_type'], unique=False)
    op.create_index(op.f('ix_enterprise_c_type1'), 'enterprise', ['c_type1'], unique=False)
    op.create_index(op.f('ix_enterprise_c_type2'), 'enterprise', ['c_type2'], unique=False)
    op.create_index(op.f('ix_enterprise_city'), 'enterprise', ['city'], unique=False)
    op.create_index(op.f('ix_enterprise_company_id'), 'enterprise', ['company_id'], unique=False)
    op.create_index(op.f('ix_enterprise_company_name'), 'enterprise', ['company_name'], unique=False)
    op.create_index(op.f('ix_enterprise_district'), 'enterprise', ['district'], unique=False)
    op.create_index(op.f('ix_enterprise_entypeid'), 'enterprise', ['entypeid'], unique=False)
    op.create_index(op.f('ix_enterprise_f_type'), 'enterprise', ['f_type'], unique=False)
    op.create_index(op.f('ix_enterprise_province'), 'enterprise', ['province'], unique=False)
    op.create_index(op.f('ix_enterprise_public_id'), 'enterprise', ['public_id'], unique=False)
    op.create_index(op.f('ix_enterprise_roundid'), 'enterprise', ['roundid'], unique=False)
    op.create_index(op.f('ix_enterprise_scale_range'), 'enterprise', ['scale_range'], unique=False)
    op.create_index(op.f('ix_enterprise_yearid'), 'enterprise', ['yearid'], unique=False)
    op.create_table('enterprise_certificate',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='专利信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('start_date', sa.String(length=32), nullable=True, comment='发证时间'),
    sa.Column('type', sa.String(length=32), nullable=True, comment='证书类型'),
    sa.Column('cert_name', sa.String(length=32), nullable=True, comment='证书名称'),
    sa.Column('cert_no', sa.String(length=32), nullable=True, comment='证书号'),
    sa.Column('end_date', sa.String(length=32), nullable=True, comment='截止时间'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表资质证书'
    )
    op.create_table('enterprise_client',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业客户主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('client_name', sa.String(length=32), nullable=True, comment='客户'),
    sa.Column('ratio', sa.String(length=32), nullable=True, comment='销售占比'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='销售金额'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开时间'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='数据来源'),
    sa.Column('relation', sa.String(length=32), nullable=True, comment='关联关系'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业客户数据表'
    )
    op.create_table('enterprise_equity',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='股权出质主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('reg_number', sa.String(length=32), nullable=True, comment='等级编号'),
    sa.Column('pledgor', sa.String(length=10), nullable=True, comment='出质人'),
    sa.Column('target_company', sa.String(length=25), nullable=True, comment='出质股权的企业'),
    sa.Column('pledgee', sa.String(length=10), nullable=True, comment='质权人'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='出质股权数额（万元）'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='登记日期'),
    sa.Column('status', sa.String(length=10), nullable=True, comment='状态'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业详情股权出质'
    )
    op.create_table('enterprise_inout_info',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业进出口信用主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('customs_registered_address', sa.String(length=32), nullable=True, comment='注册海关'),
    sa.Column('management_category', sa.String(length=32), nullable=True, comment='经营类别'),
    sa.Column('record_date', sa.DateTime(), nullable=True, comment='注册日期'),
    sa.Column('industry_category', sa.String(length=32), nullable=True, comment='行业类别'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业进出口信用数据表'
    )
    op.create_table('enterprise_licence',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业行政许可主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('licence_no', sa.String(length=32), nullable=True, comment='企业行政许可编号'),
    sa.Column('licence_name', sa.String(length=32), nullable=True, comment='企业行政许可证名称'),
    sa.Column('from_date', sa.String(length=32), nullable=True, comment='有效期自'),
    sa.Column('end_date', sa.String(length=32), nullable=True, comment='有效期至'),
    sa.Column('license_org', sa.String(length=32), nullable=True, comment='许可机关'),
    sa.Column('licence_content', sa.String(length=32), nullable=True, comment='许可内容'),
    sa.Column('source', sa.String(length=32), nullable=True, comment='来源'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业行政许可数据表'
    )
    op.create_table('enterprise_patent',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='专利信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('name', sa.String(length=50), nullable=True, comment='发明名称'),
    sa.Column('type', sa.String(length=20), nullable=True, comment='类型'),
    sa.Column('status', sa.String(length=20), nullable=True, comment='法律状态'),
    sa.Column('apply_number', sa.String(length=50), nullable=True, comment='申请号'),
    sa.Column('apply_date', sa.String(length=32), nullable=True, comment='申请日'),
    sa.Column('pub_number', sa.String(length=20), nullable=True, comment='公开号'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开日期'),
    sa.Column('inventor', sa.String(length=20), nullable=True, comment='发明人'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业详情专利信息'
    )
    op.create_table('enterprise_punish',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='信息主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='处罚日期'),
    sa.Column('punish_no', sa.String(length=32), nullable=True, comment='决定文书号'),
    sa.Column('punish_reason', sa.String(length=32), nullable=True, comment='处罚事由'),
    sa.Column('punish_content', sa.String(length=32), nullable=True, comment='处罚结果/内容'),
    sa.Column('punish_org', sa.String(length=32), nullable=True, comment='处罚单位'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='来源'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表行政处罚'
    )
    op.create_table('enterprise_supplier',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业供应商主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('supplier_name', sa.String(length=32), nullable=True, comment='客户名字'),
    sa.Column('ratio', sa.String(length=32), nullable=True, comment='采购占比'),
    sa.Column('amount', sa.String(length=32), nullable=True, comment='采购金额'),
    sa.Column('pub_date', sa.String(length=32), nullable=True, comment='公开时间'),
    sa.Column('sources', sa.String(length=32), nullable=True, comment='数据来源'),
    sa.Column('relation', sa.String(length=32), nullable=True, comment='关联关系'),
    sa.Column('lng', sa.String(length=100), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=100), nullable=True, comment='纬度'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业供应商数据表'
    )
    op.create_table('enterprise_tax_info',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业税务信用主键id'),
    sa.Column('ent_id', sa.String(length=32), nullable=True, comment='企业id'),
    sa.Column('name', sa.String(length=32), nullable=True, comment='名称'),
    sa.Column('year', sa.String(length=32), nullable=True, comment='评价年度'),
    sa.Column('id_number', sa.String(length=32), nullable=True, comment='纳税人识别号'),
    sa.Column('grade', sa.String(length=32), nullable=True, comment='纳税信用等级'),
    sa.Column('eval_department', sa.String(length=32), nullable=True, comment='单位评价'),
    sa.Column('type', sa.String(length=32), nullable=True, comment='类型'),
    sa.Column('business_id', sa.String(length=32), nullable=True, comment='数据id'),
    sa.PrimaryKeyConstraint('id'),
    comment='全国企业表企业税务信用数据表'
    )
    op.create_table('evaluation_node_data',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('c_type', sa.Integer(), nullable=True, comment='行业id'),
    sa.Column('province', sa.String(length=32), nullable=True, comment='省份'),
    sa.Column('city', sa.String(length=32), nullable=True, comment='城市'),
    sa.Column('district', sa.String(length=32), nullable=True, comment='区域'),
    sa.Column('product', sa.String(length=32), nullable=True, comment='产品名'),
    sa.Column('score', sa.Integer(), nullable=True, comment='综合分'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业招商雷达-产业评估'
    )
    op.create_index(op.f('ix_evaluation_node_data_c_type'), 'evaluation_node_data', ['c_type'], unique=False)
    op.create_index(op.f('ix_evaluation_node_data_city'), 'evaluation_node_data', ['city'], unique=False)
    op.create_index(op.f('ix_evaluation_node_data_district'), 'evaluation_node_data', ['district'], unique=False)
    op.create_index(op.f('ix_evaluation_node_data_product'), 'evaluation_node_data', ['product'], unique=False)
    op.create_index(op.f('ix_evaluation_node_data_province'), 'evaluation_node_data', ['province'], unique=False)
    op.create_table('examine',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='县区'),
    sa.Column('time', sa.String(length=30), nullable=True, comment='标题的时间'),
    sa.Column('year', sa.Integer(), nullable=True, comment='年'),
    sa.Column('month', sa.Integer(), nullable=True, comment='月'),
    sa.Column('project_num', sa.Integer(), nullable=True, comment='项目个数'),
    sa.Column('sign_aim', sa.Integer(), nullable=True, comment='签约目标'),
    sa.Column('sign_finnish', sa.Float(), nullable=True, comment='签约的完成'),
    sa.Column('sign_grade', sa.Float(), nullable=True, comment='签约的得分，签约项目投资额完成率'),
    sa.Column('start_finish', sa.Float(), nullable=True, comment='开工实际投资'),
    sa.Column('start_grade', sa.Float(), nullable=True, comment='开工项目完成得分，开工项目计划投资额完成率'),
    sa.Column('invest_finish', sa.Float(), nullable=True, comment='固投已完成'),
    sa.Column('invest_grade', sa.Float(), nullable=True, comment='固投得分，开工项目到位资金额'),
    sa.Column('start_num', sa.Integer(), nullable=True, comment='项目的开工个数'),
    sa.Column('start_num_grade', sa.Float(), nullable=True, comment='签约开工率得分'),
    sa.Column('start_aim', sa.Float(), nullable=True, comment='开工计划金额'),
    sa.Column('invest_aim', sa.Float(), nullable=True, comment='固投目标金额'),
    sa.Column('invest_aim_f', sa.Float(), nullable=True, comment='非固投目标金额'),
    sa.Column('invest_finish_f', sa.Integer(), nullable=True, comment='非固投已完成'),
    sa.Column('invest_grade_f', sa.Float(), nullable=True, comment='非固投得分'),
    sa.Column('grade', sa.Integer(), nullable=True, comment='综合排名'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-招商引资作战图表'
    )
    op.create_table('government',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('pnums', sa.Integer(), nullable=True),
    sa.Column('charge', sa.String(length=255), nullable=True),
    sa.Column('charge_phone', sa.String(length=255), nullable=True),
    sa.Column('function', sa.Text(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_government_name'), 'government', ['name'], unique=False)
    op.create_table('indu_policy',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='政策主键id'),
    sa.Column('name', sa.String(length=255), nullable=True, comment='政策名'),
    sa.Column('post_num', sa.String(length=255), nullable=True, comment='发文字号'),
    sa.Column('industry', sa.String(length=32), nullable=True, comment='行业名称'),
    sa.Column('pubdate', sa.DateTime(), nullable=True, comment='发布时间'),
    sa.Column('year', sa.Integer(), nullable=True, comment='发布年份'),
    sa.Column('url', sa.String(length=255), nullable=True, comment='外链接'),
    sa.Column('file', sa.String(length=255), nullable=True, comment='本地文件位置'),
    sa.Column('category', sa.String(length=32), nullable=True, comment='政策类型'),
    sa.Column('org', sa.String(length=255), nullable=True, comment='政策发布机构'),
    sa.Column('district', sa.String(length=32), nullable=True, comment='政策发布地区'),
    sa.Column('body', sa.Text(), nullable=True, comment='正文'),
    sa.Column('navigator', sa.String(length=255), nullable=True, comment='导航一'),
    sa.Column('navigat', sa.String(length=255), nullable=True, comment='导航二'),
    sa.Column('level', sa.String(length=255), nullable=True, comment='级别'),
    sa.Column('sorts', sa.Integer(), nullable=True, comment='机构排序'),
    sa.Column('sorts_level', sa.Integer(), nullable=True, comment='发布机构排序'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-产业政策'
    )
    op.create_table('industry',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='产业主键id'),
    sa.Column('name', sa.String(length=32), nullable=True, comment='导航名'),
    sa.Column('oname', sa.String(length=32), nullable=True, comment='导航真名'),
    sa.Column('nid', sa.Integer(), nullable=True, comment='导航id(对应企业数据表中的f_type)'),
    sa.Column('fid', sa.Integer(), nullable=True, comment='表中fid'),
    sa.Column('statu', sa.Integer(), nullable=True, comment='启用状态1启用，2禁用'),
    sa.Column('info', sa.Text(), nullable=True, comment='行业简介'),
    sa.Column('companys', sa.Integer(), nullable=True, comment='行业下企业数'),
    sa.Column('entities', sa.Integer(), nullable=True, comment='行业所包含细分行业实体数'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业导航目录表'
    )
    op.create_table('industry_chain',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('industry_name', sa.String(length=20), nullable=True, comment='行业名称'),
    sa.Column('icon_url', sa.String(length=255), nullable=True, comment='未选中时行业图标'),
    sa.Column('icon_url1', sa.String(length=255), nullable=True, comment='选中时行业图标'),
    sa.Column('status', sa.Integer(), nullable=True, comment='启用状态1启用，2禁用'),
    sa.Column('industry_type', sa.Integer(), nullable=True, comment='行业类型(0是产业集群，1是上游行业，2是中游行业，3是下游行业)'),
    sa.Column('relate_id', sa.Integer(), nullable=True, comment='关系id(关联哪个产业环节'),
    sa.Column('chain_id', sa.Integer(), nullable=True, comment='关系id(关联哪个产业链'),
    sa.Column('enterprise_num', sa.Integer(), nullable=True, comment='相关全企业表数量'),
    sa.PrimaryKeyConstraint('id'),
    comment='新版产业链数据数据表'
    )
    op.create_table('industry_chain1',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('industry_name', sa.String(length=20), nullable=True, comment='行业名称'),
    sa.Column('icon_url', sa.String(length=255), nullable=True, comment='未选中时行业图标'),
    sa.Column('icon_url1', sa.String(length=255), nullable=True, comment='选中时行业图标'),
    sa.Column('status', sa.Integer(), nullable=True, comment='启用状态1启用，2禁用'),
    sa.Column('industry_type', sa.Integer(), nullable=True, comment='行业类型(0是产业集群，1是上游行业，2是中游行业，3是下游行业)'),
    sa.Column('relate_id', sa.Integer(), nullable=True, comment='关系id(关联哪个产业环节'),
    sa.Column('chain_id', sa.Integer(), nullable=True, comment='关系id(关联哪个产业链'),
    sa.Column('enterprise_num', sa.Integer(), nullable=True, comment='相关全企业表数量'),
    sa.PrimaryKeyConstraint('id'),
    comment='新版产业链数据数据表'
    )
    op.create_table('industry_distribute',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('industry_name', sa.String(length=20), nullable=True, comment='行业名称'),
    sa.Column('industry_num', sa.Integer(), nullable=True, comment='个数'),
    sa.Column('investment_volume', sa.Float(), nullable=True, comment='投资额（亿元）'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱开工项目产业分布数据'
    )
    op.create_table('induzone',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='园区主键id'),
    sa.Column('name', sa.String(length=255), nullable=True, comment='园区名称'),
    sa.Column('image', sa.String(length=255), nullable=True, comment='园区图片'),
    sa.Column('phone', sa.String(length=255), nullable=True, comment='园区联系电话'),
    sa.Column('email', sa.String(length=30), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True, comment='园区地址'),
    sa.Column('industry_position', sa.String(length=255), nullable=True, comment='产业定位'),
    sa.Column('gdp', sa.String(length=30), nullable=True, comment='GDP(亿元)'),
    sa.Column('represent', sa.Text(), nullable=True, comment='代表企业'),
    sa.Column('introduct', sa.Text(), nullable=True, comment='园区简介'),
    sa.Column('level', sa.String(length=32), nullable=True, comment='园区级别'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='园区区县'),
    sa.Column('charge', sa.String(length=255), nullable=True, comment='园区负责人'),
    sa.Column('site', sa.String(length=255), nullable=True, comment='园区所在地'),
    sa.Column('industry_type', sa.String(length=255), nullable=True, comment='产业类型'),
    sa.Column('area', sa.Float(), nullable=True, comment='占地面积(平方公里)'),
    sa.Column('lng', sa.String(length=255), nullable=True, comment='经度'),
    sa.Column('lat', sa.String(length=255), nullable=True, comment='纬度'),
    sa.Column('cluster', sa.String(length=255), nullable=True, comment='产业集群'),
    sa.Column('cate', sa.String(length=255), nullable=True, comment='园区类型'),
    sa.Column('out_power', sa.Float(), nullable=True, comment='产出强度（万元/亩）'),
    sa.Column('invest_power', sa.Float(), nullable=True, comment='亩均投资强度（万元/亩）'),
    sa.Column('value_product', sa.Float(), nullable=True, comment='亩均年产值（万元/亩）'),
    sa.Column('tax', sa.Float(), nullable=True, comment='亩均年税收（万元/亩）'),
    sa.Column('indu_land', sa.String(length=255), nullable=True, comment='工业土地均价（万元/亩）'),
    sa.Column('comm_land', sa.String(length=255), nullable=True, comment='商办土地均价（万元/亩）'),
    sa.Column('highmag', sa.String(length=255), nullable=True, comment='高层管理人员（元/月）'),
    sa.Column('middlemag', sa.String(length=255), nullable=True, comment='中级管理人员（元/月）'),
    sa.Column('worker', sa.String(length=255), nullable=True, comment='普通员工（元/月）'),
    sa.Column('trans_facility', sa.Text(), nullable=True, comment='交通配套'),
    sa.Column('goods_trans', sa.Text(), nullable=True, comment='货物运输'),
    sa.Column('live_facility', sa.Text(), nullable=True, comment='园区生活配套'),
    sa.Column('market', sa.Text(), nullable=True, comment='百货商场'),
    sa.Column('hotel_bus', sa.Text(), nullable=True, comment='酒店商务'),
    sa.Column('medical', sa.Text(), nullable=True, comment='医疗机构'),
    sa.Column('education', sa.Text(), nullable=True, comment='教育教育'),
    sa.Column('induenterprise', sa.Text(), nullable=True, comment='规模以上企业'),
    sa.Column('innovate', sa.Text(), nullable=True, comment='科研机构'),
    sa.Column('base', sa.Text(), nullable=True, comment='双创基地'),
    sa.Column('carrier', sa.Text(), nullable=True, comment='产业载体'),
    sa.Column('navigator', sa.String(length=255), nullable=True, comment='导航一'),
    sa.Column('navigat', sa.String(length=255), nullable=True, comment='导航二'),
    sa.Column('region', sa.String(length=255), nullable=True, comment='精确行政区'),
    sa.Column('gdp_point', sa.Float(), nullable=True, comment='GDP的评分'),
    sa.Column('school_point', sa.Float(), nullable=True, comment='高校院所的评分'),
    sa.Column('policy_point', sa.Float(), nullable=True, comment='政策数的评分'),
    sa.Column('live_point', sa.Float(), nullable=True, comment='生活配套的评分'),
    sa.Column('traffic_point', sa.Float(), nullable=True, comment='交通的评分'),
    sa.Column('mall_point', sa.Float(), nullable=True, comment='购物中心的评分'),
    sa.Column('hotel_point', sa.Float(), nullable=True, comment='酒店餐饮的评分'),
    sa.Column('development_zone', sa.String(length=255), nullable=True, comment='所在开发区'),
    sa.Column('upper_district', sa.String(length=255), nullable=True, comment='上级行政区'),
    sa.Column('xiaqu_area', sa.String(length=30), nullable=True, comment='辖区面积(平方公里)'),
    sa.Column('people_num', sa.String(length=30), nullable=True, comment='人口'),
    sa.Column('carrier_form', sa.String(length=30), nullable=True, comment='载体形态'),
    sa.Column('area_structure', sa.Float(), nullable=True, comment='辖区面积(平方公里)'),
    sa.Column('admin_live_water1', sa.String(length=255), nullable=True, comment='行政区-居民生活用水（元/立方米）'),
    sa.Column('admin_live_water2', sa.String(length=255), nullable=True, comment='行政区-非居民用水（元/立方米）'),
    sa.Column('admin_live_water3', sa.String(length=255), nullable=True, comment='行政区-特种用水（元/立方米）'),
    sa.Column('admin_electric1', sa.String(length=255), nullable=True, comment='行政区-居民生活电价'),
    sa.Column('admin_electric2', sa.String(length=255), nullable=True, comment='行政区-商业电价'),
    sa.Column('admin_electric3', sa.String(length=255), nullable=True, comment='行政区-工业电价'),
    sa.Column('admin_gas1', sa.String(length=255), nullable=True, comment='行政区-城市居民用气（元/立方米）'),
    sa.Column('admin_gas2', sa.String(length=255), nullable=True, comment='行政区-工商业用气（元/立方米）'),
    sa.Column('admin_residence1', sa.String(length=255), nullable=True, comment='行政区-居民住宅（元/平方米）'),
    sa.Column('admin_residence2', sa.String(length=255), nullable=True, comment='行政区-非居民住宅（元/平方米）'),
    sa.Column('admin_tax_rate', sa.String(length=255), nullable=True, comment='行政区-企业职工各种费率(人社局)'),
    sa.Column('admin_wage_level', sa.String(length=255), nullable=True, comment='行政区-工资标准(人社局)'),
    sa.Column('zone_status', sa.String(length=255), nullable=True, comment='产业园区-载体形态（楼宇/厂房）'),
    sa.Column('zone_land_area', sa.String(length=255), nullable=True, comment='产业园区-占地面积（平方公里）'),
    sa.Column('zone_structure_area', sa.String(length=255), nullable=True, comment='产业园区-建筑面积（平方公里）'),
    sa.Column('zone_linkman', sa.String(length=255), nullable=True, comment='产业园区-联系人（招商负责人）'),
    sa.Column('zone_mobile', sa.String(length=255), nullable=True, comment='产业园区-联系方式（招商负责人）'),
    sa.PrimaryKeyConstraint('id'),
    comment='产业现状图谱-产业载体园区信息表'
    )
    op.create_table('introduction_meet',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('name', sa.String(length=20), nullable=True, comment='推介会名字'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='推介会类型 1往期，2即将举办'),
    sa.Column('time', sa.String(length=100), nullable=True, comment='时间段'),
    sa.Column('organizer', sa.String(length=20), nullable=True, comment='举办方'),
    sa.Column('img_url', sa.String(length=255), nullable=True, comment='推介会封面'),
    sa.Column('video_url', sa.String(length=255), nullable=True, comment='推介会介绍'),
    sa.Column('info', sa.Text(), nullable=True, comment='推介会介绍'),
    sa.PrimaryKeyConstraint('id'),
    comment='小程序-推介会数据表'
    )
    op.create_table('investment_information',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('name', sa.String(length=200), nullable=True, comment='招商资讯名字'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='类型 1数据通报， 2工作动态'),
    sa.Column('time', sa.String(length=100), nullable=True, comment='时间段'),
    sa.Column('source', sa.String(length=20), nullable=True, comment='来源'),
    sa.Column('content', sa.String(length=255), nullable=True, comment='正文'),
    sa.PrimaryKeyConstraint('id'),
    comment='小程序-招商资讯数据表'
    )
    op.create_table('jc_target',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('file_name', sa.String(length=30), nullable=True, comment='文件名称'),
    sa.Column('is_delete', sa.Integer(), nullable=True, comment='逻辑删除'),
    sa.Column('year', sa.String(length=30), nullable=True, comment='数据年份'),
    sa.Column('upload_time', sa.String(length=30), nullable=True, comment='上传日期'),
    sa.Column('upload_unit', sa.String(length=30), nullable=True, comment='上传部门'),
    sa.Column('upload_people', sa.String(length=30), nullable=True, comment='上传人'),
    sa.Column('grade_sign', sa.Float(), nullable=True, comment='签约项目情况赋分15'),
    sa.Column('grade_start', sa.Float(), nullable=True, comment='项目开工率赋分5'),
    sa.Column('grade_plan_invest', sa.Float(), nullable=True, comment='新开工固定资产投资项目计划投资赋分25'),
    sa.Column('grade_arrive_target1', sa.Float(), nullable=True, comment='固定资产投资项目资金到位赋分25'),
    sa.Column('grade_arrive_target0', sa.Float(), nullable=True, comment='非固定资产投资项目资金到位赋分5'),
    sa.Column('district_name', sa.String(length=30), nullable=True, comment='区县名称'),
    sa.Column('money_sign', sa.Float(), nullable=True, comment='签约项目金额(年度目标)'),
    sa.Column('rate_start', sa.Float(), nullable=True, comment='项目开工率(年度目标)'),
    sa.Column('money_plan_invest', sa.Float(), nullable=True, comment='新开工固定资产投资项目计划投资额(年度目标)'),
    sa.Column('money_arrive_target1', sa.Float(), nullable=True, comment='固定资产投资项目资金到位额(年度目标)'),
    sa.Column('money_arrive_target0', sa.Float(), nullable=True, comment='非固定资产投资项目资金到位额(年度目标)'),
    sa.PrimaryKeyConstraint('id'),
    comment='项目化管理-晋城市县（市、区）、开发区指标表'
    )
    op.create_table('lab',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('cate', sa.String(length=255), nullable=True),
    sa.Column('cateid', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('fax', sa.String(length=255), nullable=True),
    sa.Column('postcode', sa.String(length=255), nullable=True),
    sa.Column('introduct', sa.Text(), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True),
    sa.Column('lng', sa.String(length=255), nullable=True),
    sa.Column('lat', sa.String(length=255), nullable=True),
    sa.Column('city', sa.String(length=255), nullable=True),
    sa.Column('navigator', sa.String(length=255), nullable=True),
    sa.Column('navigat', sa.String(length=255), nullable=True),
    sa.Column('research', sa.String(length=255), nullable=True),
    sa.Column('admin', sa.String(length=255), nullable=True),
    sa.Column('developarea', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    comment='创新资源-创新平台表'
    )
    op.create_table('labor_cost',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='园区主键id'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='区县名称'),
    sa.Column('endowment_insurance1', sa.Float(), nullable=True, comment='养老保险公司缴xx %'),
    sa.Column('endowment_insurance2', sa.Float(), nullable=True, comment='养老保险个人缴xx %'),
    sa.Column('unemployment_insurance1', sa.Float(), nullable=True, comment='失业保险公司缴XX %'),
    sa.Column('unemployment_insurance2', sa.Float(), nullable=True, comment='失业保险个人缴X %'),
    sa.Column('injury_insurance1', sa.Float(), nullable=True, comment='工伤保险公司缴XX %'),
    sa.Column('injury_insurance2', sa.Float(), nullable=True, comment='工伤保险个人缴X %'),
    sa.Column('maternity_insurance1', sa.Float(), nullable=True, comment='生育保险公司缴XX %'),
    sa.Column('maternity_insurance2', sa.Float(), nullable=True, comment='生育保险个人缴X %'),
    sa.Column('medical_insurance1', sa.Float(), nullable=True, comment='医疗保险公司缴XX %'),
    sa.Column('medical_insurance2', sa.Float(), nullable=True, comment='医疗保险个人缴X %'),
    sa.Column('month_wage_rates', sa.Float(), nullable=True, comment='月最低工资工资标准'),
    sa.Column('hour_wage_rates', sa.Float(), nullable=True, comment='非全日制用工小时最低工资标准'),
    sa.PrimaryKeyConstraint('id'),
    comment='现状图谱-投资成本-劳动力成本'
    )
    op.create_table('money_arrive',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('is_delete', sa.Integer(), nullable=True, comment='逻辑删除'),
    sa.Column('file_name', sa.String(length=30), nullable=True, comment='文件名称'),
    sa.Column('data_time', sa.String(length=30), nullable=True, comment='数据年份'),
    sa.Column('upload_time', sa.String(length=30), nullable=True, comment='上传日期'),
    sa.Column('upload_unit', sa.String(length=30), nullable=True, comment='上传部门'),
    sa.Column('upload_people', sa.String(length=30), nullable=True, comment='上传人'),
    sa.Column('district_name', sa.String(length=30), nullable=True, comment='区县名称'),
    sa.Column('arrive_money', sa.Float(), nullable=True, comment='固定资产投资项目资金到位额'),
    sa.PrimaryKeyConstraint('id'),
    comment='项目化管理-固定资产投资项目资金到位表'
    )
    op.create_table('newproject',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('type', sa.String(length=255), nullable=True, comment='产业类型'),
    sa.Column('number', sa.Integer(), nullable=True, comment='项目个数'),
    sa.Column('money', sa.Float(), nullable=True, comment='价格'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='区县名称'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-项目数量/金额产业分布表'
    )
    op.create_table('operation_log',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('operation_time', sa.DateTime(), nullable=True, comment='操作时间'),
    sa.Column('operation_people', sa.String(length=20), nullable=True, comment='操作人名字'),
    sa.Column('operation_people_id', sa.String(length=20), nullable=True, comment='操作人id'),
    sa.Column('operation_people_belong', sa.String(length=100), nullable=True, comment='操作人所属区县、机构、部门'),
    sa.Column('operation_mobile', sa.String(length=20), nullable=True, comment='操作人电话'),
    sa.Column('operation_message', sa.String(length=255), nullable=True, comment='操作信息'),
    sa.Column('section', sa.String(length=20), nullable=True, comment='操作人职务'),
    sa.Column('remark', sa.String(length=20), nullable=True, comment='备注：是或否（是否是每月二十五号前进行提报导入）'),
    sa.Column('action', sa.String(length=20), nullable=True, comment='记录"导入"的动作用于备注（每月十五号前是否进行提报导入）的是和否'),
    sa.Column('read_type', sa.Integer(), nullable=True, comment='消息类型（用于消息提醒） 0未读，1已读，3已读状态一天后转为历史消息'),
    sa.Column('time', sa.DateTime(), nullable=True, comment='转为已读状态的时间（用于消息提醒）'),
    sa.PrimaryKeyConstraint('id'),
    comment='载体资源库-记录操作日志的数据表'
    )
    op.create_table('organization_chart',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('one_org', sa.String(length=30), nullable=True, comment='一级组织机构'),
    sa.Column('two_department', sa.String(length=30), nullable=True, comment='二级部门'),
    sa.Column('three_role', sa.String(length=30), nullable=True, comment='三级角色'),
    sa.Column('page_permission_id', sa.String(length=255), nullable=True, comment='页面权限id列表'),
    sa.Column('fun_permission_id', sa.String(length=255), nullable=True, comment='功能权限id列表'),
    sa.PrimaryKeyConstraint('id'),
    comment='后台管理系统---组织结构表'
    )
    op.create_table('project',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='工程id'),
    sa.Column('year', sa.Integer(), nullable=True, comment='年'),
    sa.Column('project_stage_id', sa.Integer(), nullable=True, comment='项目阶段id：落地项目为1，招商项目为2'),
    sa.Column('name', sa.String(length=255), nullable=True, comment='工程名'),
    sa.Column('district', sa.String(length=255), nullable=True, comment='区县名称'),
    sa.Column('money', sa.Float(), nullable=True, comment='项目投资金额'),
    sa.Column('attract_industry', sa.String(length=255), nullable=True, comment='招引业态'),
    sa.Column('type', sa.String(length=255), nullable=True, comment='工程类型'),
    sa.Column('background', sa.Text(), nullable=True, comment='项目背景'),
    sa.Column('content', sa.Text(), nullable=True, comment='项目的具体内容'),
    sa.Column('way', sa.Text(), nullable=True, comment='拟引资方式及内容'),
    sa.Column('company', sa.String(length=255), nullable=True, comment='招商单位'),
    sa.Column('contact', sa.String(length=255), nullable=True, comment='联系方式'),
    sa.Column('email', sa.String(length=255), nullable=True, comment='电子邮箱'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-重点招商项目表'
    )
    op.create_table('project_dynamic_log',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('project_id', sa.Integer(), nullable=True, comment='项目id'),
    sa.Column('operation_people', sa.String(length=30), nullable=True, comment='操作人'),
    sa.Column('item', sa.String(length=255), nullable=True, comment='动态'),
    sa.Column('time', sa.String(length=30), nullable=True, comment='时间'),
    sa.PrimaryKeyConstraint('id'),
    comment='四库管理-项目动态数据表'
    )
    op.create_table('project_management',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('is_delete', sa.Integer(), nullable=True, comment='逻辑删除'),
    sa.Column('project_stalker', sa.String(length=30), nullable=True, comment='项目跟踪'),
    sa.Column('project_stalker_explain', sa.String(length=30), nullable=True, comment='项目跟踪说明'),
    sa.Column('project_name', sa.String(length=30), nullable=True, comment='项目名称'),
    sa.Column('district', sa.String(length=20), nullable=True, comment='项目所在地'),
    sa.Column('development_area', sa.String(length=20), nullable=True, comment='开发区'),
    sa.Column('attract_name', sa.String(length=30), nullable=True, comment='引资方名称'),
    sa.Column('investor_name', sa.String(length=30), nullable=True, comment='投资方名称'),
    sa.Column('investor_district', sa.String(length=30), nullable=True, comment='投资方所在地'),
    sa.Column('industry', sa.String(length=20), nullable=True, comment='所属行业-一级产业'),
    sa.Column('industry2', sa.String(length=20), nullable=True, comment='所属行业-二级产业'),
    sa.Column('industry_level', sa.String(length=20), nullable=True, comment='所属项目产业级别'),
    sa.Column('investment_volume', sa.Float(), nullable=True, comment='总投资额(万元)'),
    sa.Column('construction_content', sa.String(length=30), nullable=True, comment='建设内容'),
    sa.Column('project_address', sa.String(length=20), nullable=True, comment='项目选址'),
    sa.Column('project_progress', sa.String(length=30), nullable=True, comment='项目进展'),
    sa.Column('project_problem', sa.String(length=255), nullable=True, comment='难点情况'),
    sa.Column('project_year', sa.Integer(), nullable=True, comment='项目年份'),
    sa.Column('upload_unity', sa.String(length=20), nullable=True, comment='上传部门'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='上传人'),
    sa.Column('upload_time', sa.DateTime(), nullable=True, comment='上传时间'),
    sa.Column('project_num', sa.String(length=30), nullable=True, comment='项目编号'),
    sa.Column('project_source', sa.String(length=20), nullable=True, comment='项目来源'),
    sa.Column('project_unity', sa.String(length=20), nullable=True, comment='项目申报单位'),
    sa.Column('is_development_project', sa.String(length=20), nullable=True, comment='是否属于开发区项目'),
    sa.Column('sign_time', sa.String(length=40), nullable=True, comment='签约时间'),
    sa.Column('start_time', sa.String(length=40), nullable=True, comment='开工时间'),
    sa.Column('end_time', sa.String(length=40), nullable=True, comment='竣工时间'),
    sa.Column('investor_rank', sa.String(length=30), nullable=True, comment='投资方排名'),
    sa.Column('is_transf_project', sa.String(length=30), nullable=True, comment='是否转型项目'),
    sa.Column('country', sa.String(length=30), nullable=True, comment='投资方国别'),
    sa.Column('provence', sa.String(length=30), nullable=True, comment='投资方省份'),
    sa.Column('city', sa.String(length=30), nullable=True, comment='投资方市'),
    sa.Column('job_num', sa.Integer(), nullable=True, comment='带动就业岗位（个）'),
    sa.Column('new_value', sa.Float(), nullable=True, comment='新增产值（亿元）'),
    sa.Column('revenue', sa.Float(), nullable=True, comment='贡献税收（亿元）'),
    sa.Column('use_land', sa.String(length=30), nullable=True, comment='项目用地情况（亩）'),
    sa.Column('new_land', sa.String(length=30), nullable=True, comment='其中新增用地（亩）'),
    sa.Column('construction_nature', sa.String(length=30), nullable=True, comment='建设性质（亩）'),
    sa.Column('is_fixed_investment', sa.String(length=30), nullable=True, comment='固定资产投资项目'),
    sa.Column('investment_year', sa.String(length=20), nullable=True, comment='资金到位本年累计（万元）'),
    sa.Column('investment_history', sa.String(length=20), nullable=True, comment='资金到位历史累计（万元）'),
    sa.Column('cooperation_way', sa.String(length=20), nullable=True, comment='合作方式'),
    sa.Column('set_project_status', sa.String(length=20), nullable=True, comment='项目立项状态'),
    sa.Column('investor_people', sa.String(length=30), nullable=True, comment='投资方联系人'),
    sa.Column('investor_mobile', sa.String(length=30), nullable=True, comment='投资方电话'),
    sa.Column('investor_address', sa.String(length=30), nullable=True, comment='投资方联系地址'),
    sa.PrimaryKeyConstraint('id'),
    comment='项目化管理-项目信息表'
    )
    op.create_table('property',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('name', sa.String(length=32), nullable=True, comment='字段名'),
    sa.Column('nid', sa.Integer(), nullable=True, comment='字段id'),
    sa.Column('sid', sa.Integer(), nullable=True, comment='字段类型id'),
    sa.Column('statu', sa.Integer(), nullable=True, comment='状态:1启动，2禁用'),
    sa.PrimaryKeyConstraint('id'),
    comment='360企业画像--下拉框内容数据表'
    )
    op.create_table('role',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='企业'),
    sa.Column('role_name', sa.String(length=255), nullable=True, comment='角色名'),
    sa.Column('role', sa.String(length=10), nullable=True, comment='权限值 000000 0位位职级123，后面为权限01'),
    sa.Column('info', sa.String(length=255), nullable=True, comment='权限说明'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('role'),
    sa.UniqueConstraint('role_name'),
    comment='用户角色表'
    )
    op.create_table('scientific',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('introduct', sa.Text(), nullable=True),
    sa.Column('buildate', sa.DateTime(), nullable=True),
    sa.Column('telephone', sa.String(length=255), nullable=True),
    sa.Column('fax', sa.String(length=255), nullable=True),
    sa.Column('postcode', sa.String(length=255), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True),
    sa.Column('lng', sa.String(length=255), nullable=True),
    sa.Column('lat', sa.String(length=255), nullable=True),
    sa.Column('research', sa.String(length=255), nullable=True),
    sa.Column('admin', sa.String(length=255), nullable=True),
    sa.Column('developarea', sa.String(length=255), nullable=True),
    sa.Column('navigator', sa.String(length=255), nullable=True),
    sa.Column('navigat', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    comment='创新资源-科研机构表'
    )
    op.create_table('shanxi_target',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('is_delete', sa.Integer(), nullable=True, comment='逻辑删除'),
    sa.Column('data_time', sa.String(length=30), nullable=True, comment='数据年份'),
    sa.Column('upload_time', sa.String(length=30), nullable=True, comment='上传日期'),
    sa.Column('upload_unit', sa.String(length=30), nullable=True, comment='上传部门'),
    sa.Column('upload_people', sa.String(length=30), nullable=True, comment='上传人'),
    sa.Column('district_name', sa.String(length=30), nullable=True, comment='区县名称'),
    sa.Column('sign_money', sa.Float(), nullable=True, comment='签约金额'),
    sa.Column('sign_target_money', sa.Float(), nullable=True, comment='目标金额(年度目标)'),
    sa.Column('sign_finish_rate', sa.Float(), nullable=True, comment='完成率'),
    sa.Column('plan_invest_money', sa.Float(), nullable=True, comment='计划投资额'),
    sa.Column('plan_target_money', sa.Float(), nullable=True, comment='目标计划投资额(年度目标)'),
    sa.Column('plan_finish_rate', sa.Float(), nullable=True, comment='计划投资额完成率'),
    sa.Column('arrive_money', sa.Float(), nullable=True, comment='资金到位'),
    sa.Column('arrive_target_money', sa.Float(), nullable=True, comment='目标资金到位(年度目标)'),
    sa.Column('arrive_finish_rate', sa.Float(), nullable=True, comment='计划投资额完成率'),
    sa.PrimaryKeyConstraint('id'),
    comment='项目化管理-山西省地市指标表'
    )
    op.create_table('siku_project',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='1为线索库，2为对接库，3为签约库，4为开工库'),
    sa.Column('is_delete', sa.Integer(), nullable=True, comment='逻辑删除 1是0否'),
    sa.Column('distribute_condition', sa.String(length=20), nullable=True, comment='分发情况'),
    sa.Column('project_name', sa.String(length=200), nullable=True, comment='项目名称'),
    sa.Column('investor_name', sa.String(length=30), nullable=True, comment='投资方名称'),
    sa.Column('investor_district', sa.String(length=30), nullable=True, comment='投资方所在地'),
    sa.Column('project_type', sa.String(length=30), nullable=True, comment='项目类型'),
    sa.Column('industry', sa.String(length=20), nullable=True, comment='所属行业-一级产业'),
    sa.Column('industry2', sa.String(length=20), nullable=True, comment='所属行业-二级产业'),
    sa.Column('provence', sa.String(length=30), nullable=True, comment='投资方省份'),
    sa.Column('city', sa.String(length=30), nullable=True, comment='投资方市'),
    sa.Column('investment_volume', sa.Float(), nullable=True, comment='总投资额(万元)'),
    sa.Column('project_year', sa.Integer(), nullable=True, comment='项目年份'),
    sa.Column('project_info', sa.String(length=300), nullable=True, comment='项目基本情况'),
    sa.Column('thread_people', sa.String(length=30), nullable=True, comment='线索提供人'),
    sa.Column('thread_people_unity', sa.String(length=30), nullable=True, comment='线索提供人单位或职务'),
    sa.Column('thread_people_mobile', sa.String(length=30), nullable=True, comment='线索提供人联系方式'),
    sa.Column('thread_progress', sa.String(length=30), nullable=True, comment='线索（项目）进展'),
    sa.Column('upload_unity', sa.String(length=20), nullable=True, comment='上传部门'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='上传人'),
    sa.Column('upload_time', sa.DateTime(), nullable=True, comment='上传时间'),
    sa.Column('project_num', sa.String(length=30), nullable=True, comment='项目编号'),
    sa.Column('investment_volume1', sa.Float(), nullable=True, comment='拟引资额(万元)'),
    sa.Column('project_info1', sa.String(length=300), nullable=True, comment='项目方基本情况'),
    sa.Column('project_schedule', sa.String(length=20), nullable=True, comment='项目进展'),
    sa.Column('stop_reason', sa.String(length=20), nullable=True, comment='暂停或终止原因'),
    sa.Column('thread_source', sa.String(length=20), nullable=True, comment='线索来源'),
    sa.Column('cooperation_way', sa.String(length=20), nullable=True, comment='合作方式'),
    sa.Column('other_source', sa.String(length=200), nullable=True, comment='其他来源说明'),
    sa.Column('remark', sa.String(length=200), nullable=True, comment='备注'),
    sa.Column('project_to_area', sa.String(length=20), nullable=True, comment='拟落地区域'),
    sa.Column('development_area', sa.String(length=20), nullable=True, comment='开发区'),
    sa.Column('garden', sa.String(length=20), nullable=True, comment='园区'),
    sa.Column('project_address', sa.String(length=20), nullable=True, comment='项目详细地址'),
    sa.Column('joint_condition', sa.String(length=20), nullable=True, comment='项目对接情况'),
    sa.Column('project_problem', sa.String(length=20), nullable=True, comment='项目当前存在的问题'),
    sa.Column('project_stalker', sa.String(length=20), nullable=True, comment='项目跟踪人'),
    sa.Column('joint_person', sa.String(length=20), nullable=True, comment='对接人'),
    sa.Column('joint_person_unity', sa.String(length=20), nullable=True, comment='对接人单位及职务'),
    sa.Column('joint_person_mobile', sa.String(length=20), nullable=True, comment='对接人联系方式'),
    sa.Column('project_people', sa.String(length=30), nullable=True, comment='项目方联系人'),
    sa.Column('project_people_unity', sa.String(length=30), nullable=True, comment='项目方单位或职务'),
    sa.Column('project_people_mobile', sa.String(length=30), nullable=True, comment='项目方联系方式'),
    sa.Column('attract_name', sa.String(length=30), nullable=True, comment='引资方名称'),
    sa.Column('progress_condition', sa.String(length=20), nullable=True, comment='项目推进情况'),
    sa.Column('Party_A_name', sa.String(length=20), nullable=True, comment='签约甲方名称'),
    sa.Column('Party_A_people', sa.String(length=20), nullable=True, comment='签约甲方联系人'),
    sa.Column('Party_A_mobile', sa.String(length=20), nullable=True, comment='签约甲方联系方式'),
    sa.Column('Party_B_name', sa.String(length=20), nullable=True, comment='签约乙方名称'),
    sa.Column('Party_B_people', sa.String(length=20), nullable=True, comment='签约乙方联系人'),
    sa.Column('Party_B_mobile', sa.String(length=20), nullable=True, comment='签约乙方联系方式'),
    sa.Column('sign_time', sa.DateTime(), nullable=True, comment='签约时间'),
    sa.Column('sign_year', sa.Integer(), nullable=True, comment='签约年份'),
    sa.Column('sign_style', sa.String(length=20), nullable=True, comment='签约方式'),
    sa.Column('sign_explain', sa.String(length=255), nullable=True, comment='签约方式说明'),
    sa.Column('investment', sa.String(length=20), nullable=True, comment='到位资金'),
    sa.Column('project_to_area1', sa.String(length=20), nullable=True, comment='落地区域'),
    sa.Column('start_time', sa.DateTime(), nullable=True, comment='开工时间'),
    sa.Column('start_year', sa.Integer(), nullable=True, comment='开工年份'),
    sa.PrimaryKeyConstraint('id'),
    comment='四库管理-项目信息表'
    )
    op.create_table('video',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='视频主键id'),
    sa.Column('district', sa.String(length=32), nullable=False, comment='区县名称'),
    sa.Column('image_url', sa.String(length=255), nullable=True, comment='视频封面'),
    sa.Column('video_id1', sa.String(length=255), nullable=True, comment='视频链接'),
    sa.PrimaryKeyConstraint('id'),
    comment='招商驾驶舱-各区县视频表'
    )
    op.create_table('followers',
    sa.Column('follower_id', sa.Integer(), nullable=False),
    sa.Column('followed_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['followed_id'], ['government.id'], ),
    sa.ForeignKeyConstraint(['follower_id'], ['government.id'], ),
    sa.PrimaryKeyConstraint('follower_id', 'followed_id')
    )
    op.create_table('progress_condition',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='2为对接库，3为签约库，4为开工库'),
    sa.Column('add_time', sa.DateTime(), nullable=True, comment='添加时间'),
    sa.Column('info', sa.String(length=20), nullable=True, comment='项目对接情况'),
    sa.Column('project_id', sa.Integer(), nullable=True, comment='外键id，项目id'),
    sa.ForeignKeyConstraint(['project_id'], ['siku_project.id'], ),
    sa.PrimaryKeyConstraint('id'),
    comment='四库管理对接库-项目进展（项目对接情况/项目推进情况）'
    )
    op.create_table('project_file',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='2为对接库，3为签约库，4为开工库，其他5'),
    sa.Column('file_type', sa.Integer(), nullable=True, comment='1文件，2图片'),
    sa.Column('file_url', sa.String(length=300), nullable=True, comment='相关印证资料图片url'),
    sa.Column('file_name', sa.String(length=20), nullable=True, comment='相关印证资料图片名称'),
    sa.Column('upload_time', sa.String(length=20), nullable=True, comment='上传时间'),
    sa.Column('upload_people', sa.String(length=20), nullable=True, comment='上传人'),
    sa.Column('upload_people_id', sa.Integer(), nullable=True, comment='上传人id'),
    sa.Column('project_id', sa.Integer(), nullable=True, comment='外键id，项目id'),
    sa.Column('project_manager_id', sa.Integer(), nullable=True, comment='外键id，项目id'),
    sa.ForeignKeyConstraint(['project_id'], ['siku_project.id'], ),
    sa.ForeignKeyConstraint(['project_manager_id'], ['project_management.id'], ),
    sa.PrimaryKeyConstraint('id'),
    comment='四库管理对接库-相关印证资料图片'
    )
    op.create_table('section',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('pnums', sa.Integer(), nullable=True),
    sa.Column('charge', sa.String(length=255), nullable=True),
    sa.Column('charge_phone', sa.String(length=255), nullable=True),
    sa.Column('function', sa.Text(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('goverment_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['goverment_id'], ['government.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('sign_three',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='主键id'),
    sa.Column('name', sa.String(length=20), nullable=True, comment='第三方名称'),
    sa.Column('people', sa.String(length=20), nullable=True, comment='第三方联系人'),
    sa.Column('mobile', sa.String(length=20), nullable=True, comment='第三方联系方式'),
    sa.Column('project_id', sa.Integer(), nullable=True, comment='外键id，项目id'),
    sa.ForeignKeyConstraint(['project_id'], ['siku_project.id'], ),
    sa.PrimaryKeyConstraint('id'),
    comment='签约库-签约的第三方'
    )
    op.create_table('user',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False, comment='用户编号'),
    sa.Column('name', sa.String(length=32), nullable=True, comment='用户名'),
    sa.Column('password_hash', sa.String(length=128), nullable=True, comment='加密的密码'),
    sa.Column('real_name', sa.String(length=32), nullable=True, comment='姓名'),
    sa.Column('mobile', sa.String(length=11), nullable=True, comment='手机号'),
    sa.Column('flag', sa.Integer(), nullable=True, comment='普通1，政府2'),
    sa.Column('status', sa.Integer(), nullable=True, comment='0禁止，1通过，2再审，3驳回'),
    sa.Column('position', sa.String(length=30), nullable=True, comment='职务'),
    sa.Column('belong_organization', sa.String(length=30), nullable=True, comment='单位'),
    sa.Column('belong_department', sa.String(length=30), nullable=True, comment='部门'),
    sa.Column('group', sa.String(length=30), nullable=True, comment='所在组'),
    sa.Column('leader', sa.String(length=32), nullable=True, comment='领导（直属领导）'),
    sa.Column('vxopenid', sa.String(length=128), nullable=True, comment='微信openid'),
    sa.Column('vxunionid', sa.String(length=128), nullable=True, comment='微信unionid'),
    sa.Column('org_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['org_id'], ['organization_chart.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('mobile'),
    sa.UniqueConstraint('name'),
    sa.UniqueConstraint('vxopenid'),
    sa.UniqueConstraint('vxunionid'),
    comment='用户信息表'
    )
    op.create_table('group',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('pnums', sa.Integer(), nullable=True),
    sa.Column('charge', sa.String(length=255), nullable=True),
    sa.Column('charge_phone', sa.String(length=255), nullable=True),
    sa.Column('function', sa.Text(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('section_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['section_id'], ['section.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('user_build',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('build_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['build_id'], ['carrier_build.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'build_id')
    )
    op.create_table('user_company',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('company_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['company_id'], ['company.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'company_id')
    )
    op.create_table('user_enterprise',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('enterprise_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['enterprise_id'], ['enterprise.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'enterprise_id')
    )
    op.create_table('user_factory',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('factory_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['factory_id'], ['carrier_factory.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'factory_id')
    )
    op.create_table('user_industry',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('industry_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['industry_id'], ['industry.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'industry_id')
    )
    op.create_table('user_land',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('land_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['land_id'], ['carrier_land.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'land_id')
    )
    op.create_table('user_policy',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('policy_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['policy_id'], ['indu_policy.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'policy_id')
    )
    op.create_table('user_project',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('project_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['project_id'], ['project.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'project_id')
    )
    op.create_table('user_zone',
    sa.Column('create_time', sa.DateTime(), nullable=True, comment='创建时间'),
    sa.Column('update_time', sa.DateTime(), nullable=True, comment='更新时间'),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('zone_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.ForeignKeyConstraint(['zone_id'], ['induzone.id'], ),
    sa.PrimaryKeyConstraint('user_id', 'zone_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_zone')
    op.drop_table('user_project')
    op.drop_table('user_policy')
    op.drop_table('user_land')
    op.drop_table('user_industry')
    op.drop_table('user_factory')
    op.drop_table('user_enterprise')
    op.drop_table('user_company')
    op.drop_table('user_build')
    op.drop_table('group')
    op.drop_table('user')
    op.drop_table('sign_three')
    op.drop_table('section')
    op.drop_table('project_file')
    op.drop_table('progress_condition')
    op.drop_table('followers')
    op.drop_table('video')
    op.drop_table('siku_project')
    op.drop_table('shanxi_target')
    op.drop_table('scientific')
    op.drop_table('role')
    op.drop_table('property')
    op.drop_table('project_management')
    op.drop_table('project_dynamic_log')
    op.drop_table('project')
    op.drop_table('organization_chart')
    op.drop_table('operation_log')
    op.drop_table('newproject')
    op.drop_table('money_arrive')
    op.drop_table('labor_cost')
    op.drop_table('lab')
    op.drop_table('jc_target')
    op.drop_table('investment_information')
    op.drop_table('introduction_meet')
    op.drop_table('induzone')
    op.drop_table('industry_distribute')
    op.drop_table('industry_chain1')
    op.drop_table('industry_chain')
    op.drop_table('industry')
    op.drop_table('indu_policy')
    op.drop_index(op.f('ix_government_name'), table_name='government')
    op.drop_table('government')
    op.drop_table('examine')
    op.drop_index(op.f('ix_evaluation_node_data_province'), table_name='evaluation_node_data')
    op.drop_index(op.f('ix_evaluation_node_data_product'), table_name='evaluation_node_data')
    op.drop_index(op.f('ix_evaluation_node_data_district'), table_name='evaluation_node_data')
    op.drop_index(op.f('ix_evaluation_node_data_city'), table_name='evaluation_node_data')
    op.drop_index(op.f('ix_evaluation_node_data_c_type'), table_name='evaluation_node_data')
    op.drop_table('evaluation_node_data')
    op.drop_table('enterprise_tax_info')
    op.drop_table('enterprise_supplier')
    op.drop_table('enterprise_punish')
    op.drop_table('enterprise_patent')
    op.drop_table('enterprise_licence')
    op.drop_table('enterprise_inout_info')
    op.drop_table('enterprise_equity')
    op.drop_table('enterprise_client')
    op.drop_table('enterprise_certificate')
    op.drop_index(op.f('ix_enterprise_yearid'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_scale_range'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_roundid'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_public_id'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_province'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_f_type'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_entypeid'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_district'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_company_name'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_company_id'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_city'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_c_type2'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_c_type1'), table_name='enterprise')
    op.drop_index(op.f('ix_enterprise_c_type'), table_name='enterprise')
    op.drop_table('enterprise')
    op.drop_table('district_resource')
    op.drop_table('customer_consultation')
    op.drop_table('company_tax_info')
    op.drop_table('company_supplier')
    op.drop_table('company_punish')
    op.drop_table('company_patent')
    op.drop_table('company_licence')
    op.drop_table('company_inout_info')
    op.drop_table('company_industry_point')
    op.drop_table('company_equity')
    op.drop_table('company_client')
    op.drop_table('company_certificate')
    op.drop_index(op.f('ix_company_company_id'), table_name='company')
    op.drop_table('company')
    op.drop_table('college')
    op.drop_table('city')
    op.drop_table('carrier_land')
    op.drop_table('carrier_factory')
    op.drop_table('carrier_energy')
    op.drop_table('carrier_build')
    op.drop_table('bstage')
    # ### end Alembic commands ###
