import json
import os
import sys

import requests
# from aliyunsdkcore.client import AcsClient
# from aliyunsdkcore.acs_exception.exceptions import ClientException
# from aliyunsdkcore.acs_exception.exceptions import ServerException
# from aliyunsdkvod.request.v20170321.GetPlayInfoRequest import GetPlayInfoRequest
from flask import request, jsonify, session, current_app
from lxml import etree
from sqlalchemy import func, desc, or_
from apps.models import *
from apps.view_index import api_attract
from apps.utils.response_code import RET
from apps import db, constants, redis_store


# 获取左上角经济指标数据
from apps.util import verify_token


# 招商驾驶舱开工项目产业分布数据
@api_attract.route("/IndustryDistribute", methods=["POST"])
def industry_distribute():
    req_dic = request.get_json()
    flag = req_dic['flag']

    try:
        indu_obj_list = IndustryDistribute.query.all()
        industry_num_list = []
        data_list = []
        if flag == 1:
            for i in indu_obj_list:
                if i.industry_num:
                    industry_num_list.append(i.industry_num)
                data_dic = {
                    "industry_name": i.industry_name,
                    "industry_num": i.industry_num if i.industry_num else 0
                }
                data_list.append(data_dic)
            # data = {"data": data_list, "total": sum(industry_num_list)}
        if flag == 2:
            for i in indu_obj_list:
                if i.industry_num:
                    industry_num_list.append(i.investment_volume)
                data_dic = {
                    "industry_name": i.industry_name,
                    "investment_volume": round(i.investment_volume, 2)
                }
                data_list.append(data_dic)
        data = {"data": data_list, "total": round(sum(industry_num_list), 2)}
        return jsonify(code=RET.OK, data=data, msg='查询成功!')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


def get_jjzb(district, flag):
    '''经济指标数据'''
    try:
        if not district or district == '满城区':
            datas = City.query.filter_by(area='满城区', flag=flag).first()
        else:
            datas = City.query.filter_by(area=district, flag=flag).first()
        df_dic = ''
        if datas:
            df_dic = {"GDP": '%.2f亿元' % (datas.GDP / 10000) if datas.GDP else "-亿元",  # 地区生产总值
                      "addscale": '%.2f' % datas.addscale + "%" if datas.addscale else "-%",  # 规上工业增加值增速
                      "investment": '%.2f亿元' % (datas.investment / 10000) if datas.investment else "-亿元",  # 固定资产投资
                      "retail": '%.2f亿元' % (datas.retail / 10000) if datas.retail else "-亿元",  # 社会消费品零售额
                      "limit_retail": '%.2f亿元' % (datas.limit_retail / 10000) if datas.limit_retail else "-亿元",  # 限额以上消费品零售额
                      "public_in": '%.2f亿元' % (datas.public_in / 10000) if datas.public_in else "-亿元",  # 一般公共预算收入
                      "in_out": '%.2f亿元' % (datas.in_out / 10000) if datas.in_out else "-亿元",  # 进出口总额
                      "public": '%.2f亿元' % (datas.public / 10000) if datas.public else "-亿元",  # 一般公共预算支出
                      "people_out": '%.f元' % datas.people_out if datas.people_out else "-元",  # 城镇居民人均可支配收入
                      "country_people_out": '%.f元' % datas.country_people_out if datas.country_people_out else "-元",  # 农村居民人均可支配收入
                      "people_per": '%.2f' % datas.people_per if datas.people_per else "-",
                      "question": datas.question,
                      # "year": str(datas.year) + '年',
                      "year": datas.question
                      }  # 居民消费价格指数
        else:
            df_dic = {
                "GDP": "",
                "addscale": "",
                "investment": "",
                "retail": "",
                "limit_retail": "",
                "public_in": "",
                "in_out": "",
                "public": "",
                "people_out": "",
                "country_people_out": "",
                "people_per": "",
                "question": "",
                # "year": str(datas.year) + '年'
                "year": datas.question
                      }  # 居民消费价格指数
        return df_dic
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 左上角企业数量各资质统计、左上角获取经济指标数据、产业机构分布饼状图数据统计
@api_attract.route("/menu", methods=["POST"])
def menu():
    '''左上角企业数量各资质统计、左上角获取经济指标数据、产业机构分布饼状图数据统计'''
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称

    if not district or district == '满城区':
        try:
            company = Company.query.filter_by(district="满城区")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")
    else:
        try:
            company = Company.query.filter(Company.district == district, Company.city == "保定市")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库错误")

    # 1. 左上角企业数量各资质统计
    try:
        # 晋城市
        t_c5 = company.filter_by(isfive="1").count()  # 500强
        ssqy = company.filter_by(quoted_company="1").count()  # 上市
        if district != "满城区":
            gmys = Company.query.filter(
                Company.induzone == district).filter_by(
                scale="1").count()  # 规模(2-5) 622
        else:
            gmys = Company.query.filter_by(scale="1").count()
        zjtx = company.filter_by(zjtg="1").count()  # 专精特新
        gxjs = company.filter_by(high_new="1").count()  # 高新
        kjzx = company.filter_by(tbe="1").count()  # 科技型中小企业
        dengl = company.filter_by(dengl="1").count()  # 瞪羚
        dujs = company.filter_by(unicorn="1").count()  # 独角兽

        tbe_sjmy = company.filter_by(tbe_sjmy="1").count()  # 省级民营科技企业
        zjtg_gjjxjr = company.filter_by(zjtg_gjjxjr="1").count()  # 国家级专精特新小巨人企业
        zjtg_sjxjr = company.filter_by(zjtg_sjxjr="1").count()  # 省级专精特新小巨人企业

        table_dic = {
                     "ssqy": ssqy,  # 上市企业
                     "gmys": gmys,  # 规模以上企业
                     "zjtx": zjtx,  # 专精特新企业
                     "gxjs": gxjs,  # 高新技术企业
                     "kjzx": kjzx,  # 科技型中小企业
                     "tbe_sjmy": tbe_sjmy,  # 省级民营科技企业
                     "zjtg_gjjxjr": zjtg_gjjxjr,  # 国家级专精特新小巨人企业
                     "zjtg_sjxjr": zjtg_sjxjr  # 省级专精特新小巨人企业
                     }

        # 2. 左上角获取经济指标数据
        jjzb_data = get_jjzb(district, 1)

        jjzb_data1 = get_jjzb(district, 2)

        # 3. 产业结构分布饼状图数据统计
        count_all = company.count()
        if count_all == 0:
            count_all = 1
        count_zzp = company.filter_by(f_type=1).count()  # 纸制品加工及卫品
        count_whly = company.filter_by(f_type=2).count()  # 文化旅游
        count_gdjt = company.filter_by(f_type=3).count()  # 轨道交通
        count_xcl = company.filter_by(f_type=4).count()  # 新材料及高端装备制造
        count_yy = company.filter_by(f_type=5).count()  # 生物医药大健康
        count_jy = company.filter_by(f_type=6).count()  # 教育和体育
        count_xdfwy = company.filter_by(f_type=7).count()  # 现代服务及商贸物流
        count_nycyh = company.filter_by(f_type=8).count()  # 农业产业化及食品加工
        count_dldq = company.filter_by(f_type=9).count()  # 电力电气

        # 产业结构分布
        indu_dic = [
            {"name": "纸制品加工及卫品", "value": count_zzp},
            {"name": "文化旅游", "value": count_whly},
            {"name": "轨道交通", "value": count_gdjt},
            {"name": "新材料及高端装备制造", "value": count_xcl},
            {"name": "生物医药大健康", "value": count_yy},
            {"name": "教育和体育", "value": count_jy},
            {"name": "现代服务及商贸物流", "value": count_xdfwy},
            {"name": "农业产业化及食品加工", "value": count_nycyh},
            {"name": "电力电气", "value": count_dldq},
        ]

        data = {
            "jjzb_dic": jjzb_data,  # 左上角经济指标数据
            "jjzb_dic1": jjzb_data1,  # 左上角经济指标数据
            "table_dic": table_dic,  # 左上角企业数据统计
            "industry_dic": indu_dic  # 产业结构分布饼状图数据
        }

        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取经济指标数据
@api_attract.route("/GetKfqEco", methods=["GET"])
def get_kfq_eco():
    try:
        kfq = KfqEco.query.filter(KfqEco.flag == 1).first()
        data1 = {
            "xzqsy": (str(kfq.xzqsy) if kfq.xzqsy else '-') + '%',
            "gyydlzs": (str(kfq.gyydlzs) if kfq.gyydlzs else '-') + '%',
            "yysrzs": (str(kfq.yysrzs) if kfq.yysrzs else '-') + '%',
            "yysrzl": (str(kfq.yysrzl) if kfq.yysrzl else '-') + '万元',
            "jckzs": (str(kfq.jckzs) if kfq.jckzs else '-') + '万元',
            "sjsyxmff": (str(kfq.sjsyxmff) if kfq.sjsyxmff else '-') + '分值',
            "sjsywzzs": (str(kfq.sjsywzzs) if kfq.sjsywzzs else '-') + '%',
            "sjsywzzl": (str(kfq.sjsywzzl) if kfq.sjsywzzl else '-') + '万元',
            "year": kfq.question
        }
        kfq = KfqEco.query.filter(KfqEco.flag == 2).first()
        data2 = {
            "xzqsy": (str(kfq.xzqsy) if kfq.xzqsy else '-') + '%',
            "gyydlzs": (str(kfq.gyydlzs) if kfq.gyydlzs else '-') + '%',
            "yysrzs": (str(kfq.yysrzs) if kfq.yysrzs else '-') + '%',
            "yysrzl": (str(kfq.yysrzl) if kfq.yysrzl else '-') + '万元',
            "jckzs": (str(kfq.jckzs) if kfq.jckzs else '-') + '万元',
            "sjsyxmff": (str(kfq.sjsyxmff) if kfq.sjsyxmff else '-') + '分值',
            "sjsywzzs": (str(kfq.sjsywzzs) if kfq.sjsywzzs else '-') + '%',
            "sjsywzzl": (str(kfq.sjsywzzl) if kfq.sjsywzzl else '-') + '万元',
            "year": kfq.question
        }
        data = [data1, data2]
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商引资作战图、已开工项目产业分布/已开工项目到位资金产业分布
@api_attract.route("/project", methods=["POST"])
def project():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称
    try:
        project_map = []
        industry_money = []
        industry_nums = []
        list1 = ["满城区", "满城镇", "神星镇", "方顺桥镇", "南韩村镇", "大册营镇", "于家庄镇", "要庄乡", "石井乡", "坨南乡", "白龙乡", "刘家台乡"]

        # 晋城市，点击区县之前默认数据
        if not district or district == '满城区':
            for i in list1:
                # 1.招商引资作战图数据
                ss = Examine.query.filter_by(district=i).first()
                project_map.append({"name": i,
                                    "nums1": "{}".format(ss.sign_finnish),
                                    "add1": ss.sign_grade,
                                    "nums2": "{}".format(ss.start_finish),
                                    "add2": ss.start_grade,
                                    "nums3": "{}".format(ss.invest_finish),
                                    "add3": ss.invest_grade,
                                    "nums4": "{}".format(ss.start_num),
                                    "add4": ss.start_num_grade,
                                    "time": ss.time
                                    })

            # 已开工项目产业分布/已开工项目到位资金产业分布
            # types_list = []
            # industry_dic = {}
            project_list = NewProject.query.filter_by(district="满城区").all()
            i = 0
            for project in project_list:
                i += 1
                if i > 7:
                    pass
                else:
                    industry_money.append({"name": project.type,
                                           "value": project.money})
                    industry_nums.append({"name": project.type,
                                          "value": project.number})

        # 点击区县后的联动数据
        else:
            # 1.招商引资作战图数据
            ss = Examine.query.filter_by(district=district).first()
            project_map.append({"name": district,
                                "nums1": "{}亿元".format(ss.sign_finnish),
                                "add1": ss.sign_grade,
                                "nums2": "{}亿元".format(ss.start_finish),
                                "add2": ss.start_grade,
                                "nums3": "{}亿元".format(ss.invest_finish),
                                "add3": ss.invest_grade,
                                "nums4": "{}个".format(ss.start_num),
                                "add4": ss.start_num_grade
                                })
            # 已开工项目产业分布/已开工项目到位资金产业分布
            i = 0
            project_list = NewProject.query.filter_by(district=district).all()
            for project in project_list:
                i += 1
                if i > 7:
                    pass
                else:
                    industry_money.append({"name": project.type,
                                           "value": project.money})
                    industry_nums.append({"name": project.type,
                                          "value": project.number})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    data = {
        "project_map": project_map,  # 招商引资作战图
        "industry_nums": industry_nums,  # 已开工项目产业分布
        "industry_money": industry_money,  # 已开工项目产业分布
    }
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 政策和重点招商项目
@api_attract.route("/propol", methods=["POST"])
def propol():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 县区

    try:
        if not district or district == "满城区":
            # name_query = "project-propol"
            # if redis_store.get(name_query) is not None:
            #     data = json.loads(redis_store.get(name_query))
            #     return jsonify(code=RET.OK, msg="获取成功", data=data)

            project = Project.query.all()
            # policy = InduPolicy.query.filter_by(district="满城区").order_by(InduPolicy.pubdate.desc())
            policy = InduPolicy.query.all()
            # data_policy = [{"name": i.name, "id": i.id, "distict": "满城区"} for i in policy.all()]
            data_policy = [{"name": i.name, "id": i.id, "distict": "满城区"} for i in policy]

            data_project1 = [{"name": i.name, "id": i.id} for i in project if i.project_stage_id == 1]
            data_project2 = [{"name": i.name, "id": i.id} for i in project if i.project_stage_id == 2]

            data = {
                "project1": data_project1,  # 落地项目
                "project2": data_project2,  # 招商项目
                "policy": data_policy,
            }
            # redis缓存
            # redis_store.set(name_query, json.dumps(data))
            # redis_store.expire(name_query, 1 * 24 * 3600)
        else:  # 区县、开发区
            project = Project.query.filter_by(district=district)
            policy = InduPolicy.query.filter_by(district=district).order_by(InduPolicy.pubdate.desc())
            data_policy = [{"name": i.name, "id": i.id, "distict": district} for i in policy.all()]

            data_project1 = [{"name": i.name, "id": i.id} for i in project if i.project_stage_id == 1]
            data_project2 = [{"name": i.name, "id": i.id} for i in project if i.project_stage_id == 2]

            data = {
                "project1": data_project1,  # 落地项目
                "project2": data_project2,  # 招商项目
                "policy": data_policy,
            }

        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="数据库错误")


# 获取区县的详情
@api_attract.route("/getInfo", methods=["POST"])
def get_info():
    req_dic = request.get_json()
    district = req_dic.get("district")  # 地区

    if not district:
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        city = City.query.filter_by(area=district).first()
        info = city.info
        detail_dic = {
            "detail_data": info
        }
        return jsonify(code=RET.OK, msg="查询成功", data=detail_dic)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取区县视频url
@api_attract.route("/video", methods=["POST"])
def attract_video():
    req_dic = request.get_json()
    district = req_dic.get("district")

    if not district:
        return jsonify(code=RET.PARAMERR, msg="参数不全")
    try:
        video = Video.query.filter_by(district=district).first()
    except Exception as e:
        current_app.logger.error(e)
    if video:
        video_url = video.video_id1
        image_url = (video.image_url).strip()
        # print(video_url)
        # print(image_url)
        if video_url:
            return jsonify(code=RET.OK, msg="查询成功", data={"video_url": video_url, "image_url": image_url})
    else:
        return jsonify(code=RET.DATAERR, msg="区县名称有误，没有相关视频")
    return jsonify(code=RET.NODATA, msg="暂无视频", data={"url": ""})


# 获取重点项目的详情，详情页
@api_attract.route("/keyProject", methods=["POST"])
def keyproject():
    req_dic = request.get_json()
    id = req_dic.get("id")
    if not id:
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        project = Project.query.get(id)
        data = {
            "id": project.id,  # 工程名
            "name": project.name,  # 工程名
            "district": project.district,  # 区县名称
            "type": project.type,  # 工程类型
            "money": project.money,  # 项目投资金额
            "background": project.background,  # 项目背景
            "content": project.content,  # 项目的具体内容
            "way": project.way,  # 拟引资方式及内容
            "company": project.company,  # 招商单位
            "contact": project.contact,  # 联系方式
            "email": project.email  # 电子邮箱
        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 政策详情
@api_attract.route("/policyDetails", methods=["POST"])
def policy_details():
    req_dic = request.get_json()
    _id = req_dic.get("id")
    if not _id:
        return jsonify(code=RET.PARAMERR, msg="参数不全")
    try:
        _id1 = int(_id) + 1
        _id2 = int(_id) - 1
        if _id2 < 1:
            _id2 = ''
        policy_len = InduPolicy.query.count()
        if _id1 > policy_len:
            _id1 = ''

        policy = InduPolicy.query.get(_id)
        policy1 = InduPolicy.query.get(str(_id1))
        policy2 = InduPolicy.query.get(str(_id2))
        if policy:
            data = {"name": policy.name,  # 政策名
                    "file": policy.file if policy.file else "-",  # 本地文件位置
                    "category": policy.category if policy.category else "-",  # 政策类型
                    "org": policy.org if policy.org else "-",  # 政策发布机构
                    "industry": policy.industry if policy.industry else "-",  # 行业名称
                    "district": policy.district if policy.district else "-",  # 政策发布地区
                    "pubdate": str(policy.pubdate)[0:10] if policy.pubdate else "-",  # 发布时间
                    "url": policy.url if policy.pubdate else "-",  # 外链接
                    "post_num": policy.post_num if policy.post_num else "",  # 发文字号
                    "next": [policy1.name, _id1] if policy1 else "",
                    "last": [policy2.name, _id2] if policy2 else ""}
            return jsonify(code=RET.OK, msg="查找成功", data=data)
        else:
            return jsonify(code=RET.OK, msg="查找成功,无数据", data='')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 列表展示左上角企业
@api_attract.route("/showListb", methods=["POST"])
def showListb():
    req_dic = request.get_json()  # 企业列表选择 1234567 500强企业-上市企业-高新技术企业-专精特新企业-独角兽企业--瞪羚企业-科技型中小企业
    type = req_dic.get("type")  # 12345678 （500强-上市-规模-专精特新-高新-科技中小-瞪羚-独角兽）
    district = req_dic.get("district")
    page = req_dic.get("page")
    per_page = req_dic.get("per_page")

    if not all([type, district]):
        return jsonify(code=RET.PARAMERR, msg="参数错误")

    if not page:
        page = 1
    try:
        # 企业
        if district == "晋城市":
            company = Company.query.filter_by(city="晋城市")
        else:
            company = Company.query.filter_by(city="晋城市", district=district)
        size = company.count()
        if type == 1:
            company = company.filter_by(quoted_company=1)
            size = company.count()

        if type == 2:
            if district == "晋城市":
                company = Company.query.filter_by(scale="1")
            else:
                company = Company.query.filter_by(district=district, scale="1")
            size = company.count()
        if type == 3:
            company = company.filter_by(high_new=1)
            size = company.count()
        if type == 4:
            company = company.filter_by(zjtg=1)
            size = company.count()
        if type == 5:
            company = company.filter_by(tbe=1)
            size = company.count()
        if type == 6:
            company = company.filter_by(tbe_sjmy=1)
            size = company.count()
        if type == 7:
            company = company.filter_by(zjtg_gjjxjr=1)
            size = company.count()
        if type == 8:
            company = company.filter_by(zjtg_sjxjr=1)
            size = company.count()
        company = company.paginate(page, per_page=int(per_page)).items
        data = [{
            "id": i.id,
            "name": i.company_name,
            "industry": i.company_industry if i.company_industry else "",
            "product": i.product if i.product else "",
            # "build_date": "",
            "build_date": (i.build_date).strftime("%Y-%m-%d"),
            "capital": i.capital if i.capital else "",
            "isfive": "中国500强企业" if i.isfive == "1" else "",
            # "quoted_company": "上市企业" if i.public_sector != "空" else "",
            "quoted_company": "上市企业" if i.quoted_company == "1" else "",
            "scale": "规模以上企业" if i.scale == "1" else "",
            "zjtg": "专精特新企业" if i.zjtg == "1" else "",
            "high_new": "高新技术企业" if i.high_new == "1" else "",
            "tbe": "科技型中小企业" if i.tbe == "1" else "",
            "dengl": "瞪羚企业" if i.dengl == "1" else "",
            "unicorn": "独角兽企业" if i.unicorn == "1" else "",
            "zjtg_gjjxjr": '国家级专精特新小巨人企业' if i.zjtg_gjjxjr == '1' else "",
            "zjtg_sjxjr": '省级专精特新小巨人企业' if i.zjtg_sjxjr == '1' else "",
            "tbe_sjmy": '省级民营科技企业' if i.tbe_sjmy == '1' else "",
        } for i in company]
        data = {"data_list": data, "size": size}
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 晋城企业信息详情(招商驾驶舱左上角各类企业详情)
@api_attract.route('/companyDetail', methods=['POST'])
def company_detail():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_id = user_obj.id
    except:
        return jsonify(code=RET.SESSIONERR, msg="请重新登录！")

    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        company = Company.query.get(id)
        user = User.query.get(user_id)  # 获取关注列表
        if user:
            company_ids = [coms.id for coms in user.company]
        else:
            company_ids = []
        if company:
            province = company.province if company.province else ""
            city = company.city if company.city else ""
            if city == province:
                city = ''
            district = company.district if company.district else ""
            data = {"id": company.id,
                     "name": company.company_name,  # 企业名
                     "telephone": company.telephone if company.telephone else "",  # 电话
                     "web_site": company.web_site if company.web_site else "",  # 网址
                     "email": company.email if company.email else "",  # 邮箱
                     "address": company.address if company.address else "",  # 地址
                     "collect": "1" if company.id in company_ids else "2",  # 关注状态码1关注，2未关注
                     "choice": "1",  # 1太原企业，2全国企业

                     "location": province + city + district,
                     "jwd": {"lng": company.lng if company.lng else "",  # 经度
                             "lat": company.lat if company.lat else ""},  # 维度
                     "info": company.company_info if company.company_info else "",  # 企业信息
                     "business_scope": company.business_scope if company.business_scope else "",
                     # 经营范围
                     # "high_new": "高新技术企业" if company.high_new else "",  # 高新技术企业
                     "legal": company.legal if company.legal else "",  # 法定代表人
                     "status": company.status if company.status else "",  # 状态
                     "build_date": str(company.build_date)[:10] if company.build_date else "",  # 创建时间
                     "capital": company.capital if company.capital else "",  # 注册资本
                     "social_code": company.social_code if company.social_code else "",  # 统一社会信用代码
                     # "taking": company.takingn if company.takingn else "",  # 营收 (万元)
                     "bao": company.bao_num if company.bao_num else "",  # 参保人数
                     "entype": company.entype if company.entype else "",  # 企业类型
                     "industry": company.company_industry if company.company_industry else "",  # 所属行业
                     "scope": company.business_scope if company.business_scope else "",  # 企业经营范围
                     # "collect": "1",
                     # "choice": "3"
                     "tax_code": company.tax_code if company.tax_code else "",
                     "register_code": company.register_code if company.register_code else "",

                     "high_new": '高新技术企业' if company.high_new == '1' else "",
                     "tbe": '科技型中小企业' if company.tbe == '1' else "",
                     # "fianacing": '融资企业' if company.fianacing == '1'' else "",
                     "quoted_company": '上市企业' if company.quoted_company == '1' else "",
                     # "patent": '专利企业' if company.patent == '1'' else "",
                     "unicorn": '独角兽企业' if company.unicorn == '1' else "",
                     "dengl": '瞪羚企业' if company.dengl == '1' else "",
                     "isfive": '中国500强' if company.isfive == '1' else "",
                     "zjtg": '专精特新企业' if company.zjtg == '1' else "",
                     "zjtg_gjjxjr": '国家级专精特新小巨人企业' if company.zjtg_gjjxjr == '1' else "",
                     "zjtg_sjxjr": '省级专精特新小巨人企业' if company.zjtg_sjxjr == '1' else "",
                     "tbe_sjmy": '省级民营科技企业' if company.tbe_sjmy == '1' else "",
                     "scale": '规模以上企业' if company.scale == '1' else "",
                     "chain_master": '链主企业' if company.chain_master == '1' else "",
                    }

        else:
            return jsonify(code=RET.NODATA, msg="查无数据")
    except Exception as e:
        exc_type, exc_obj, exc_tb = sys.exc_info()
        fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
        print(exc_type, fname, exc_tb.tb_lineno)
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 全国企业信息详情(招商雷达、产业招商地图、360企业画像用到的企业详情)
@api_attract.route('/EnterpriseDetail', methods=['POST'])
def enterprise_detail():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_id = user_obj.id
    except:
        return jsonify(code=RET.SESSIONERR, msg="请重新登录！")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        enterprise = Enterprise.query.get(id)
        # company_id = enterprise.company_id
        user = User.query.get(user_id)  # 获取关注列表
        if user:
            enterprise_ids = [enter.id for enter in user.enterprise]
        else:
            enterprise_ids = []
        if enterprise:
            province = enterprise.province if enterprise.province else ""
            city = enterprise.city if enterprise.city else ""
            if city == province:
                city = ''
            district = enterprise.district if enterprise.district else ""
            data = {"id": enterprise.id,
                     "name": enterprise.company_name,  # 企业名
                     "telephone": enterprise.telephone if enterprise.telephone else "",  # 电话
                     "web_site": enterprise.web_site if enterprise.web_site else "",  # 网址
                     "email": enterprise.email if enterprise.email else "",  # 邮箱
                     "address": enterprise.address if enterprise.address else "",  # 地址
                     "collect": "1" if enterprise.id in enterprise_ids else "2",  # 关注状态码1关注，2未关注
                     "choice": "2",  # 1太原企业，2全国企业
                     "location": province + city + district,
                     "jwd": {"lng": enterprise.lng if enterprise.lng else "",  # 经度
                             "lat": enterprise.lat if enterprise.lat else ""},  # 维度
                     "info": enterprise.company_info if enterprise.company_info else "",  # 企业信息
                     "business_scope": enterprise.business_scope if enterprise.business_scope else "",
                     # 经营范围
                     "legal": enterprise.legal if enterprise.legal else "",  # 法定代表人
                     "status": enterprise.status if enterprise.status else "",  # 状态
                     "build_date": str(enterprise.build_date)[:10] if enterprise.build_date else "",  # 创建时间
                     "capital": enterprise.capital if enterprise.capital else "",  # 注册资本
                     "social_code": enterprise.social_code if enterprise.social_code else "",  # 统一社会信用代码
                     "taking": enterprise.takingn if enterprise.takingn else "",  # 营收 (万元)
                     "bao": enterprise.bao_num if enterprise.bao_num else "",  # 参保人数
                     "entype": enterprise.entype if enterprise.entype else "",  # 企业类型
                     "industry": enterprise.company_industry if enterprise.company_industry else "",  # 所属行业
                     "register_org": enterprise.register_org if enterprise.register_org else "",  # 企业经营范围
                     "tax_code": enterprise.tax_code if enterprise.tax_code else "",
                     "register_code": enterprise.register_code if enterprise.register_code else "",
                     "high_new": '高新技术企业' if enterprise.high_new == '1' else "",
                     "tbe": '科技型中小企业' if enterprise.tbe == '1' else "",
                     "fianacing": '融资企业' if enterprise.fianacing == '1' else "",
                     "quoted_enterprise": '上市企业' if enterprise.quoted_company == '1' else "",
                     "patent": '专利企业' if enterprise.patent == '1' else "",
                     "unicorn": '独角兽企业' if enterprise.unicorn == '1' else "",
                     "dengl": '瞪羚企业' if enterprise.dengl == '1' else "",
                     "isfive": '中国500强' if enterprise.isfive == '1' else "",
                     "zjtg": '专精特新企业' if enterprise.zjtg == '1' else "",
                     "zjtg_gjjxjr": '国家级专精特新小巨人企业' if enterprise.zjtg_gjjxjr == '1' else "",
                     "zjtg_sjxjr": '省级专精特新小巨人企业' if enterprise.zjtg_sjxjr == '1' else "",
                     "tbe_sjmy": '省级民营科技企业' if enterprise.tbe_sjmy == '1' else "",
                     "chain_master": '链主企业' if enterprise.chain_master == '1' else "",
                     }
            return jsonify(code=RET.OK, msg="获取成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 行政许可
@api_attract.route('/GetEnterpriseLicence', methods=['POST'])
def get_enterprise_licence():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    name_query = "GetEnterpriseLicence" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)

    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info1 = EnterpriseLicence.query.filter_by(ent_id=company_id).all()
        if not data_info1:
            return jsonify(code=RET.NODATA, msg="行政许可无数据")

        data = [{
            "label1_name": '行政许可',
            "licence_no": data.licence_no,
            "licence_name": data.licence_name,
            "from_date": data.from_date,
            "end_date": data.end_date,
            "license_org": data.license_org,
            "licence_content": data.licence_content,
            "source": data.source} for data in data_info1 if data_info1]

        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 税务信用
@api_attract.route('/GetEnterpriseTaxInfo', methods=['POST'])
def get_enterprise_taxInfo():
    '''
    企业信息详情
    :return:
    '''
    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseTaxInfo" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info2 = EnterpriseTaxInfo.query.filter_by(ent_id=company_id).all()
        if not data_info2:
            return jsonify(code=RET.NODATA, NODATA="税务信用无数据")

        data = [{
                "label2_name": '税务信用',
                "name": data.name,
                "year": data.year,
                "id_number": data.id_number,
                "grade": data.grade,
                "eval_department": data.eval_department,
                "type": data.type,
                "business_id": data.business_id} for data in data_info2 if data_info2]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 进出口信用
@api_attract.route('/GetEnterpriseInoutInfo', methods=['POST'])
def get_enterprise_inoutInfo():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseInoutInfo" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        # 工商状况-查询行政许可数据
        data_info3 = EnterpriseInoutInfo.query.filter_by(ent_id=company_id).all()
        if data_info3:
            return jsonify(code=RET.NODATA, msg="进出口信用无数据")
        data = [{
                "label3_name": '进出口信用',
                "customs_registered_address": data.customs_registered_address,
                "management_category": data.management_category,
                "record_date": data.record_date,
                "industry_category": data.industry_category} for data in data_info3 if data_info3]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 供应商
@api_attract.route('/GetEnterpriseSupplier', methods=['POST'])
def get_enterprise_supplier():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseSupplier" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info4 = EnterpriseSupplier.query.filter_by(ent_id=company_id).all()
        if not data_info4:
            return jsonify(code=RET.NODATA, msg="供应商无数据")
        data = [{
                "label4_name": '供应商',
                "supplier_name": data.supplier_name,
                "ratio": data.ratio,
                "amount": data.amount,
                "pub_date": data.pub_date,
                "sources": data.sources,
                "relation": data.relation} for data in data_info4 if data_info4]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 客户
@api_attract.route('/GetEnterpriseClient', methods=['POST'])
def get_enterprise_client():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseClient" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info5 = EnterpriseClient.query.filter_by(ent_id=company_id).all()
        if not data_info5:
            return jsonify(code=RET.NODATA, msg="客户无数据")
        data = [{
                "label5_name": '客户',
                "client_name": data.client_name,
                "ratio": data.ratio,
                "amount": data.amount,
                "pub_date": data.pub_date,
                "sources": data.sources,
                "relation": data.relation} for data in data_info5 if data_info5]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 股权出质
@api_attract.route('/GetEnterpriseEquity', methods=['POST'])
def get_enterprise_equity():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseEquity" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info6 = EnterpriseEquity.query.filter_by(ent_id=company_id).all()
        if not data_info6:
            return jsonify(code=RET.NODATA, msg="股权出质无数据")
        data = [{
                "label1_name": '股权出质',
                "reg_number": data.reg_number,
                "pledgor": data.pledgor,
                "target_company": data.target_company,
                "pledgee": data.pledgee,
                "amount": data.amount,
                "pub_date": data.pub_date,
                "status": data.status
            } for data in data_info6 if data_info6]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 行政处罚
@api_attract.route('/GetEnterprisePunish', methods=['POST'])
def get_enterprise_punish():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterprisePunish" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        # 工商状况-查询行政许可数据
        data_info7 = EnterprisePunish.query.filter_by(ent_id=company_id).all()
        if data_info7:
            return jsonify(code=RET.NODATA, msg="行政处罚无数据")
        data = [{
                "label5_name": '行政处罚',
                "pub_date": data.pub_date,
                "punish_no": data.punish_no,
                "punish_reason": data.punish_reason,
                "punish_content": data.punish_content,
                "punish_org": data.punish_org,
                "sources": data.sources} for data in data_info7 if data_info7]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 资质证书
@api_attract.route('/GetEnterpriseCertificate', methods=['POST'])
def get_enterprise_certificate():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterpriseCertificate" + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info8 = EnterpriseCertificate.query.filter_by(ent_id=company_id).all()
        if not data_info8:
            return jsonify(code=RET.NODATA, msg="资质证书无数据")
        data = [{
                "label5_name": '资质证书',
                "start_date": data.start_date,
                "type": data.type,
                "cert_name": data.cert_name,
                "cert_no": data.cert_no,
                "end_date": data.end_date} for data in data_info8 if data_info8]
        # redis缓存
        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 专利信息
@api_attract.route('/GetEnterprisePatent', methods=['POST'])
def get_enterprise_patent():
    '''
    企业信息详情
    :return:
    '''

    req_dict = request.get_json()
    id = req_dict.get("id")  # 企业id
    type = req_dict.get("type")
    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    name_query = "GetEnterprisePatent" + type + str(id)
    if redis_store.get(name_query) is not None:
        data = json.loads(redis_store.get(name_query))
        return jsonify(code=RET.OK, msg="获取成功", data=data)
    try:
        if type == 'enterprise':
            enterprise = Enterprise.query.get(id)
        else:
            enterprise = Company.query.get(id)
        company_id = enterprise.company_id
        if not company_id:
            return jsonify(code=RET.NODATA, msg='无关联信息')
        data_info9 = EnterprisePatent.query.filter_by(ent_id=company_id).limit(10)
        if not data_info9:
            return jsonify(code=RET.NODATA, msg="专利信息无数据")
        data = [{
                "label_name": '专利信息',
                "name": data.name,
                "type": data.type,
                "status": data.status,
                "apply_number": data.apply_number,
                "apply_date": data.apply_date,
                "pub_number": data.pub_number,
                "pub_date": data.pub_date,
                "inventor": data.inventor
                } for data in data_info9 if data_info9]
        # redis缓存

        redis_store.setex(name_query, 30 * 24 * 3600, json.dumps(data))
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)
