import json

from flask import current_app, jsonify, request

from apps.models import *
from apps.models import ProjectManagement
from apps.utils.response_code import RET
from apps.big_data import api_bigdata
from apps.import_project import api_import
from apps.util import verify_identity


def record_log(token, operation_message):
    try:
        section, user_name, operation_mobile, user_id, belong_unit = verify_identity(token, '')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    upload_time = datetime.now()
    log = OperationLog(read_type=0, operation_people_id=user_id, operation_people_belong=belong_unit,
                       operation_time=upload_time,
                       operation_people=user_name, operation_message=operation_message,
                       operation_mobile=operation_mobile, section=section)
    db.session.add(log)
    db.session.commit()


# TODO 项目流程图--新增
@api_import.route("/keyproject/keyproject/api/adds", methods=["POST"])
def adds():
    req_dic = json.loads(request.data)
    token = request.headers['token']
    tProjectFlows = req_dic['tProjectFlows']
    try:
        obj = TKeyproject(
            advance_requirement=req_dic["advanceRequirement"],
            clogging_point=req_dic["cloggingPoint"],
            construction_address=req_dic["constructionAddress"],
            county=req_dic["county"],
            deadline_completion=req_dic["deadlineCompletion"],
            floor_space=req_dic["floorSpace"],
            investment_commitment=req_dic["investmentCommitment"],
            investment_entity=req_dic["investmentEntity"],
            leading_department=req_dic["leadingDepartment"],
            policy_statement=req_dic["policyStatement"],
            project_day=req_dic["projectDay"],
            project_introduce=req_dic["projectIntroduce"],
            project_leader=req_dic["projectLeader"],
            project_name=req_dic["projectName"],
            project_progress=req_dic["projectProgress"],
            project_status=req_dic["projectStatus"],
            responsible_department=req_dic["responsibleDepartment"],
            total_money=req_dic["totalMoney"])
        db.session.add(obj)
        db.session.commit()
        project_id = obj.id
        print(project_id)

        for i in tProjectFlows:
            flow_obj = TProjectFlow(
                end_time=i["endTime"],
                process_schedule=i["processSchedule"],
                project_id=project_id,
                start_time=i["startTime"],
                status=i["status"])
            db.session.add(flow_obj)
            db.session.commit()
            flow_id = flow_obj.id
            print(flow_id)

            if len(i) == 14 and i["tProjectFlowStopList"]:
                flow_stop_li = i["tProjectFlowStopList"]
                for flow_stop in flow_stop_li:
                    stop_obj = TProjectFlowStop(
                        f_id=flow_id,
                        content=flow_stop["content"],
                        department=flow_stop["department"],
                        requirements=flow_stop["requirements"],
                        success_time=flow_stop["successTime"]
                    )
                    db.session.add(stop_obj)
                    db.session.commit()

        record_log(token, "项目台账新增了{}".format(req_dic['projectName']))
        return jsonify(msg="操作成功", code=200)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 重点、顺利、堵点数量
@api_import.route("/keyproject/keyproject/api/selectProjectCount", methods=["GET"])
def selectProjectCount():
    try:
        count1 = TKeyproject.query.count()
        count2 = TKeyproject.query.filter(TKeyproject.project_status == '顺利推进').count()
        count3 = TKeyproject.query.filter(TKeyproject.project_status == '遇到堵点').count()
        data = [{
            "name": "重点项目",
            "count": count1
        },
            {
            "name": "进展顺利项目",
            "count": count2
        },
            {
            "name": "存在堵点的项目",
            "count": count3
        }
        ]
        return jsonify(code=200, data=data, msg="查询成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


def get_flow_stop(id, pageNum, pageSize):
    try:
        res = TProjectFlowStop.query.filter(TProjectFlowStop.f_id == id).paginate(pageNum, pageSize).items
        flows_li = [{
                "content": i.content,
                # "createBy": i.createBy,
                # "createTime": i.createTime,
                "createBy": '',
                "createTime": '',
                "department": i.department,
                "fid": i.f_id,
                "id": i.id,
                "pageNum": pageNum,
                "pageSize": pageSize,
                # "remark": i.remark,
                "remark": '',
                "requirements": i.requirements,
                "successTime": i.success_time,
                # "updateBy": i.updateBy,
                # "updateTime": i.updateTime
                "updateBy": '',
                "updateTime": ''
            } for i in res]
        return flows_li
    except Exception as e:
        return []


def get_flow(id, pageNum, pageSize):
    try:
        res = TProjectFlow.query.filter(TProjectFlow.project_id == id).paginate(pageNum, pageSize).items
        flows_li = [{
                # "createBy": i.createBy,
                # "createTime": i.createime,
                "createBy": '',
                "createTime": '',
                "endTime": i.end_time.strftime("%Y-%m-%d") if i.end_time and type(i.end_time) != str else '',
                "id": i.id,
                "pageNum": pageNum,
                "pageSize": pageSize,
                "processSchedule": i.process_schedule,
                "projectId": i.project_id,
                # "remark": i.remark,
                "remark": '',
                "startTime": i.start_time.strftime("%Y-%m-%d") if i.start_time and type(i.start_time) != str else '',
                "status": i.status,
                "tProjectFlowStopList": get_flow_stop(i.id, pageNum, pageSize),
                # "updateBy": i.updateBy,
                # "updateTime": i.updateTime
                "updateBy": '',
                "updateTime": ''
            } for i in res]
        return flows_li
    except Exception as e:
        return []


# 项目流程图--搜索
@api_import.route("/flow/flow/selectProjectFlow", methods=["POST"])
def selectProjectFlow():
    req_dic = request.get_json()
    leadingDepartment = req_dic['leadingDepartment']
    pageNum = req_dic['pageNum']
    pageSize = req_dic['pageSize']
    projectLeader = req_dic['projectLeader']
    projectName = req_dic['projectName']

    try:
        res = TKeyproject.query.filter(
            TKeyproject.leading_department == leadingDepartment if leadingDepartment else text(""),
            TKeyproject.project_leader == projectLeader if projectLeader else text(""),
            TKeyproject.project_name == projectName if projectName else text("")
        )
        total = res.count()
        res = res.paginate(pageNum, pageSize).items
        rows = [{
            "advanceRequirement": i.advance_requirement,
            "cloggingPoint": i.clogging_point,
            "constructionAddress": i.construction_address,
            "county": i.county,
            # "createBy": i.createBy,
            # "createTime": i.createTime,
            "createBy": '',
            "createTime": '',
            "deadlineCompletion": i.deadline_completion,
            "floorSpace": i.floor_space,
            "id": i.id,
            "investmentCommitment": i.investment_commitment,
            "investmentEntity": i.investment_entity,
            "leadingDepartment": i.leading_department,
            "pageNum": pageNum,
            "pageSize": pageSize,
            "policyStatement": i.policy_statement,
            "projectDay": i.project_day,
            "projectIntroduce": i.project_introduce,
            "projectLeader": i.project_leader,
            "projectName": i.project_name,
            "projectProgress": i.project_progress,
            "projectStatus": i.project_status,
            # "remark": i.remark,
            "remark": '',
            "responsibleDepartment": i.responsible_department,
            "totalMoney": i.total_money,
            # "updateBy": i.updateBy,
            # "updateTime": i.updateTime,
            "updateBy": '',
            "updateTime": '',
            "tProjectFlows": get_flow(i.id, pageNum, pageSize)
        } for i in res]
        return jsonify(code=200, rows=rows, total=total, msg="查询成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目流程图--项目详情
@api_import.route("/keyproject/keyproject/api/findById", methods=["POST"])
def findById():
    req_dic = request.get_json()
    id = req_dic['id']
    pageNum = 1
    pageSize = 10
    try:
        i = TKeyproject.query.get(id)
        rows = {
            "advanceRequirement": i.advance_requirement,
            "cloggingPoint": i.clogging_point,
            "constructionAddress": i.construction_address,
            "county": i.county,
            # "createBy": i.createBy,
            # "createTime": i.createTime,
            "createBy": '',
            "createTime": '',
            "deadlineCompletion": i.deadline_completion,
            "floorSpace": i.floor_space,
            "id": i.id,
            "investmentCommitment": i.investment_commitment,
            "investmentEntity": i.investment_entity,
            "leadingDepartment": i.leading_department,
            "pageNum": pageNum,
            "pageSize": pageSize,
            "policyStatement": i.policy_statement,
            "projectDay": i.project_day,
            "projectIntroduce": i.project_introduce,
            "projectLeader": i.project_leader,
            "projectName": i.project_name,
            "projectProgress": i.project_progress,
            "projectStatus": i.project_status,
            # "remark": i.remark,
            "remark": '',
            "responsibleDepartment": i.responsible_department,
            "totalMoney": i.total_money,
            # "updateBy": i.updateBy,
            # "updateTime": i.updateTime,
            "updateBy": '',
            "updateTime": '',
            "tProjectFlows": get_flow(i.id, pageNum, pageSize)
        }
        return jsonify(code=200, data=rows, msg="操作成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目流程图-工作动态
@api_import.route("/dynamics/dynamics/api/list", methods=["POST"])
def lsit1():
    req_dic = request.get_json()
    id = req_dic['id']  # ture or false
    try:
        log_obj_list = OperationLog.query.filter(OperationLog.operation_message.like(f"%{'项目台账'}%"))
        total = log_obj_list.count()
        data = [{
            "createBy": "",
            "createTime": "",
            "date": log_obj.operation_time.strftime("%Y-%m-%d %H:%M:%S"),
            "id": log_obj.id,
            "pageNum": 1,
            "pageSize": 10,
            "remark": "",
            "text": log_obj.operation_message,
            "uname": log_obj.operation_people,
            "updateBy": "",
            "updateTime": "",
        } for log_obj in log_obj_list.all()]
        return jsonify(code=200, rows=data, total=total, msg='操作日志信息获取成功！')
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg='操作日志信息获取失败！')


# 项目流程图--编辑更新重点项目
@api_import.route("/keyproject/keyproject/api/updates", methods=["POST"])
def updates():
    req_dic = json.loads(request.data)
    token = request.headers['token']
    id = req_dic['id']
    if req_dic['tProjectFlows']:
        tProjectFlows = req_dic['tProjectFlows']
        for i in tProjectFlows:
            flow_obj = TProjectFlow.query.get(i["id"])
            flow_obj.end_time = i["endTime"]
            flow_obj.process_schedule = i["processSchedule"]
            flow_obj.project_id = i["projectId"]
            flow_obj.remark = i["remark"]
            flow_obj.start_time = i["startTime"]
            flow_obj.status = i["status"]
            db.session.commit()

            if len(i) == 14 and i["tProjectFlowStopList"]:
                flow_stop_li = i["tProjectFlowStopList"]
                for flow_stop in flow_stop_li:
                    stop_obj = TProjectFlowStop.query.get(flow_stop["id"])
                    stop_obj.content = flow_stop["content"]
                    stop_obj.department = flow_stop["department"]
                    stop_obj.requirements = flow_stop["requirements"]
                    stop_obj.success_time = flow_stop["successTime"]
                    db.session.commit()

    try:
        obj = TKeyproject.query.get(id)
        obj.advance_requirement = req_dic["advanceRequirement"]
        obj.clogging_point = req_dic["cloggingPoint"]
        obj.construction_address = req_dic["constructionAddress"]
        obj.county = req_dic["county"]
        obj.deadline_completion = req_dic["deadlineCompletion"]
        obj.floor_space = req_dic["floorSpace"]
        obj.investment_commitment = req_dic["investmentCommitment"]
        obj.investment_entity = req_dic["investmentEntity"]
        obj.leading_department = req_dic["leadingDepartment"]
        obj.policy_statement = req_dic["policyStatement"]
        obj.project_day = req_dic["projectDay"]
        obj.project_introduce = req_dic["projectIntroduce"]
        obj.project_leader = req_dic["projectLeader"]
        obj.project_name = req_dic["projectName"]
        obj.project_progress = req_dic["projectProgress"]
        obj.project_status = req_dic["projectStatus"]
        obj.remark = req_dic["remark"]
        obj.responsible_department = req_dic["responsibleDepartment"]
        obj.total_money = req_dic["totalMoney"]
        db.session.commit()
        record_log(token, "项目台账更新了{}".format(req_dic['projectName']))
        return jsonify(msg="操作成功", code=200)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


"""项目表"""


# 搜索--项目表
@api_import.route("/keyproject/keyproject/api/list", methods=["POST"])
def list():
    req_dic = request.get_json()
    leadingDepartment = req_dic['leadingDepartment']
    pageNum = req_dic['pageNum']
    pageSize = req_dic['pageSize']
    projectLeader = req_dic['projectLeader']
    projectName = req_dic['projectName']

    try:
        res = TKeyproject.query.filter(
            TKeyproject.leading_department == leadingDepartment if leadingDepartment else text(""),
            TKeyproject.project_leader == projectLeader if projectLeader else text(""),
            TKeyproject.project_name == projectName if projectName else text("")
        )
        total = res.count()
        res = res.paginate(pageNum, pageSize).items
        rows = [{
            "advanceRequirement": i.advance_requirement,
            "cloggingPoint": i.clogging_point,
            "constructionAddress": i.construction_address,
            "county": i.county,
            # "createBy": i.createBy,
            # "createTime": i.createTime,
            "createBy": '',
            "createTime": '',
            "deadlineCompletion": i.deadline_completion,
            "floorSpace": i.floor_space,
            "id": i.id,
            "investmentCommitment": i.investment_commitment,
            "investmentEntity": i.investment_entity,
            "leadingDepartment": i.leading_department,
            "pageNum": pageNum,
            "pageSize": pageSize,
            "policyStatement": i.policy_statement,
            "projectDay": i.project_day,
            "projectIntroduce": i.project_introduce,
            "projectLeader": i.project_leader,
            "projectName": i.project_name,
            "projectProgress": i.project_progress,
            "projectStatus": i.project_status,
            # "remark": i.remark,
            "remark": '',
            "responsibleDepartment": i.responsible_department,
            "totalMoney": i.total_money,
            # "updateBy": i.updateBy,
            # "updateTime": i.updateTime,
            "updateBy": '',
            "updateTime": '',
            "tProjectFlows": ''
        } for i in res]
        return jsonify(code=200, rows=rows, total=total, msg="查询成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 导出数据
@api_import.route("/keyproject/keyproject/export", methods=["POST"])
def export():
    pass
