from flask import current_app, jsonify, request
from apps.models import *
from apps.models import ProjectManagement
from apps.utils.response_code import RET
from apps.big_data import api_bigdata


# 获取经济指标数据
@api_bigdata.route("/GetJjzb", methods=["POST"])
def get_jjzb():
    '''获取经济指标数据'''
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称
    year = req_dict.get("year")
    # 区县名称转换字典
    district_dict = {
        '沁水县': '沁水县',
        '高平市': '高平市',
        '陵川县': '陵川县',
        '阳城县': '阳城县',
        '泽州县': '泽州县',
        '城区': '城区',
        '晋城经济技术开发区': '晋城经济技术开发区'
    }
    try:
        if not district or district == '晋城市':
            datas = City.query.filter(City.area == '晋城市',
                                      City.year == year if year else text('')).first()
        else:
            datas = City.query.filter(City.area == district,
                                      City.year == year if year else text('')).first()
        df_dic = ''
        if datas:
            df_dic = {"GDP": '%.2f亿元' % (datas.GDP / 10000) if datas.GDP else "-亿元",  # 地区生产总值
                      "addscale": '%.2f' % datas.addscale + "%" if datas.addscale else "-%",  # 规上工业增加值增速
                      "investment": '%.2f亿元' % (datas.investment / 10000) if datas.investment else "-亿元",  # 固定资产投资
                      "retail": '%.2f亿元' % (datas.retail / 10000) if datas.retail else "-亿元",  # 社会消费品零售额
                      "limit_retail": '%.2f亿元' % (datas.limit_retail / 10000) if datas.limit_retail else "-亿元",  # 限额以上消费品零售额
                      "public_in": '%.2f亿元' % (datas.public_in / 10000) if datas.public_in else "-亿元",  # 一般公共预算收入
                      "in_out": '%.2f亿元' % (datas.in_out / 10000) if datas.in_out else "-亿元",  # 进出口总额
                      "public": '%.2f亿元' % (datas.public / 10000) if datas.public else "-亿元",  # 一般公共预算支出
                      "people_out": '%.2f元' % datas.people_out if datas.people_out else "-元",  # 城镇居民人均可支配收入
                      "country_people_out": '%.2f元' % datas.country_people_out if datas.country_people_out else "-元",  # 农村居民人均可支配收入
                      "people_per": '%.2f' % datas.people_per if datas.people_per else "-",
                      "question": datas.question,
                      "year": str(datas.year) + '年'
                      }  # 居民消费价格指数
        else:
            df_dic = {
                "GDP": "",
                "addscale": "",
                "investment": "",
                "retail": "",
                "limit_retail": "",
                "public_in": "",
                "in_out": "",
                "public": "",
                "people_out": "",
                "country_people_out": "",
                "people_per": "",
                "question": "",
                "year": str(datas.year) + '年'
              }  # 居民消费价格指数
        return jsonify(code=RET.OK, msg="查找成功", data=df_dic)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 产业结构分布
@api_bigdata.route("/GetCyjg", methods=["POST"])
def get_cyjg():
    '''产业机构分布饼状图数据'''
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称
    year = req_dict.get("year")

    # 区县名称转换字典
    district_dict = {
        '沁水县': '沁水县',
        '高平市': '高平市',
        '陵川县': '陵川县',
        '阳城县': '阳城县',
        '泽州县': '泽州县',
        '城区': '城区',
        '晋城经济技术开发区': '晋城经济技术开发区'
    }

    # 1. 左上角企业数量各资质统计
    try:
        if not district or district == '晋城市':
            company = Company.query.filter(
                Company.city == "晋城市",
                Company.build_date.like('%{}%'.format(year)))
        else:
            company = Company.query.filter(
                Company.district == district_dict[district],
                Company.city == "晋城市",
                Company.build_date.like('%{}%'.format(year))
            )

        count_gt = company.filter_by(f_type=1).count()  # 钢铁
        count_gjd = company.filter_by(f_type=2).count()  # 光机电
        count_mcq = company.filter_by(f_type=7).count()  # 煤层气
        count_zbzz = company.filter_by(f_type=8).count()  # 装备制造
        count_zz = company.filter_by(f_type=9).count()  # 铸造
        count_mhg = company.filter_by(f_type=10).count()  # 煤化工
        count_xcl = company.filter_by(f_type=11).count()  # 新材料
        count_lsjc = company.filter_by(f_type=12).count()  # 绿色建材
        count_yy = company.filter_by(f_type=13).count()  # 医药
        count_smfz = company.filter_by(f_type=14).count()  # 丝麻纺织服装
        count_xdfwy = company.filter_by(f_type=15).count()  # 现代服务业
        count_szjj = company.filter_by(f_type=16).count()  # 数字经济
        count_whly = company.filter_by(f_type=17).count()  # 文化旅游

        # 产业结构分布
        indu_dic = [
            {"name": "钢铁", "value": count_gt},  # {百分比，value}
            {"name": "光机电", "value": count_gjd},
            {"name": "煤层气", "value": count_mcq},
            {"name": "装备制造", "value": count_zbzz},
            {"name": "铸造", "value": count_zz},
            {"name": "煤化工", "value": count_mhg},
            {"name": "新材料", "value": count_xcl},
            {"name": "绿色建材", "value": count_lsjc},
            {"name": "医药", "value": count_yy},
            {"name": "丝麻纺织服装", "value": count_smfz},
            {"name": "现代服务业", "value": count_xdfwy},
            {"name": "数字经济", "value": count_szjj},
            {"name": "文化旅游", "value": count_whly}
        ]
        return jsonify(code=RET.OK, msg="查找成功", data=indu_dic)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 招商引资作战图
@api_bigdata.route("/GetZzt", methods=["POST"])
def get_zzt():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称
    year = req_dict.get("year")

    try:
        project_map = []
        industry_money = []
        industry_nums = []
        list1 = ["晋城市", "沁水县", "高平市", "陵川县", "阳城县", "泽州县", "城区", "晋城经济技术开发区"]

        # 晋城市，点击区县之前默认数据
        if not district or district == '晋城市':
            for i in list1:
                # 1.招商引资作战图数据
                ss = Examine.query.filter(Examine.district == i,
                                          Examine.year.like('%{}%'.format(year))).first()
                project_map.append({"name": i,
                                    "nums1": "{}亿元".format(ss.sign_finnish),
                                    "add1": ss.sign_grade,
                                    "nums2": "{}亿元".format(ss.start_finish),
                                    "add2": ss.start_grade,
                                    "nums3": "{}亿元".format(ss.invest_finish),
                                    "add3": ss.invest_grade,
                                    "nums4": "{}个".format(ss.start_num),
                                    "add4": ss.start_num_grade
                                    })
        # 点击区县后的联动数据
        else:
            # 1.招商引资作战图数据
            ss = Examine.query.filter_by(district=district, year=year).first()
            project_map.append({"name": district,
                                "nums1": "{}亿元".format(ss.sign_finnish),
                                "add1": ss.sign_grade,
                                "nums2": "{}亿元".format(ss.start_finish),
                                "add2": ss.start_grade,
                                "nums3": "{}亿元".format(ss.invest_finish),
                                "add3": ss.invest_grade,
                                "nums4": "{}个".format(ss.start_num),
                                "add4": ss.start_num_grade
                                })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")
    return jsonify(code=RET.OK, msg="获取成功", data=project_map)


# 已开工项目分布
@api_bigdata.route("/GetKgxm", methods=["POST"])
def get_kgxm():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 区县或者开发区名称
    # year = req_dict.get("year")

    try:
        industry_money = []
        industry_nums = []

        # 晋城市，点击区县之前默认数据
        if not district or district == '晋城市':
            # 已开工项目产业分布/已开工项目到位资金产业分布
            project_list = NewProject.query.filter_by(district="晋城市").all()
            i = 0
            for project in project_list:
                i += 1
                if i > 7:
                    pass
                else:
                    industry_money.append({"name": project.type,
                                           "value": project.money})
                    industry_nums.append({"name": project.type,
                                          "value": project.number})

        else:
            # 已开工项目产业分布/已开工项目到位资金产业分布
            i = 0
            project_list = NewProject.query.filter_by(district=district).all()
            for project in project_list:
                i += 1
                if i > 7:
                    pass
                else:
                    industry_money.append({"name": project.type,
                                           "value": project.money})
                    industry_nums.append({"name": project.type,
                                          "value": project.number})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    data = {
        "industry_nums": industry_nums,  # 已开工项目产业分布
        "industry_money": industry_money,  # 已开工项目产业分布
    }
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 晋城项目总览
@api_bigdata.route("/GetProject", methods=["POST"])
def get_project():
    req_dic = request.get_json()
    page = req_dic['page']
    per_page = req_dic['per_page']
    year = req_dic['year']

    try:

        project_obj = ProjectManagement.query.filter(
            ProjectManagement.is_delete == 0,
            ProjectManagement.sign_time.like("%{}%".format(year)) if year else text('')
        )

        if not project_obj.all():
            return jsonify(code=RET.NODATA, msg='没有符合条件的数据！')
        project_size = project_obj.count()

        project_obj_list = project_obj.order_by(ProjectManagement.sign_time.desc()).paginate(page, per_page).items
        if project_obj_list:
            data = [{
                "id": project_obj.id,
                "sign_time": project_obj.sign_time,
                "project_stalker": project_obj.project_stalker,
                "project_name": project_obj.project_name,
                "district": project_obj.district,
                "development_area": project_obj.development_area,
                "attract_name": project_obj.attract_name,
                "investor_name": project_obj.investor_name,
                "investor_district": project_obj.investor_district,
                "industry": project_obj.industry,
                "investment_volume": project_obj.investment_volume,
                "construction_content": project_obj.construction_content,
                "project_address": project_obj.project_address,
                "project_progress": project_obj.project_progress,
                "project_problem": project_obj.project_problem,
                "project_year": project_obj.project_year
            } for project_obj in project_obj_list]
            return jsonify(code=RET.OK, data={"data": data, "size": project_size, "msg": "数据获取成功！"})

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 重点招商项目
@api_bigdata.route("/MajorProject", methods=["POST"])
def major_project():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 县区
    year = req_dict['year']

    try:
        if not district or district == "晋城市":
            project = Project.query.filter(Project.year == year if year else text('')).all()
            data_project = [{"name": i.name, "id": i.id} for i in project]
            return jsonify(code=RET.OK, msg="查询成功", data=data_project)

        else:  # 区县、开发区
            project = Project.query.filter(
                Project.district == district,
                Project.year == year if year else text('')
            ).all()
            data_project = [{"name": i.name, "id": i.id} for i in project]
            return jsonify(code=RET.OK, msg="查询成功", data=data_project)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="数据库错误")


# 获取重点项目的详情，详情页
@api_bigdata.route("/MajorProjectDetail", methods=["POST"])
def major_project_detail():
    req_dic = request.get_json()
    id = req_dic.get("id")
    if not id:
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        project = Project.query.get(id)
        data = {
            "id": project.id,  # 工程名
            "name": project.name if project.name else '',  # 工程名
            "district": project.district if project.district else '',  # 区县名称
            "type": project.type if project.type else '',  # 工程类型
            "money": project.money if project.money else '',  # 项目投资金额
            "background": project.background if project.background else '',  # 项目背景
            "content": project.content if project.content else '',  # 项目的具体内容
            "way": project.way if project.way else '',  # 拟引资方式及内容
            "company": project.company if project.company else '',  # 招商单位
            "contact": project.contact if project.contact else '',  # 联系方式
            "email": project.email if project.email else '',  # 电子邮箱
            "progress": '落地项目' if project.project_stage_id == 1 else '招商项目' if project.project_stage_id == 2 else ''

        }
        return jsonify(code=RET.OK, msg="查找成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 项目详情
@api_bigdata.route("/CheckProjectDetail1", methods=["POST"])
def check_project_detail1():
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    if not project_id:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    try:
        industry = ''
        project_obj = ProjectManagement.query.filter_by(id=project_id, is_delete=0).first()
        if project_obj.industry and project_obj.industry2:
            industry = project_obj.industry + '/' + project_obj.industry2
        if project_obj.industry and not project_obj.industry2:
            industry = project_obj.industry
        project_data = {"id": project_obj.id,
                        "project_stalker": project_obj.project_stalker,  # 项目跟踪
                        "project_name": project_obj.project_name,  # 项目名称
                        "district": project_obj.district,  # 项目所在地
                        "development_area": project_obj.development_area,  # 开发区
                        "attract_name": project_obj.attract_name,  # 引资方名称
                        "investor_name": project_obj.investor_name,  # 投资方名称(万元)
                        "investor_district": project_obj.investor_district,  # 投资方所在地(亩)
                        "industry": industry,
                        "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                        "construction_content": project_obj.construction_content,  # 建设内容
                        "project_address": project_obj.project_address,  # 项目选址
                        "project_progress": project_obj.project_progress,  # 项目进展
                        "project_problem": project_obj.project_problem,  # 难点情况
                        "project_year": project_obj.project_year,  # 项目年份
                        "upload_unity": project_obj.upload_unity,  # 上传部门
                        "upload_people": project_obj.upload_people,  # 上传人
                        "upload_time": project_obj.upload_time.strftime("%Y-%m-%d %H:%M:%S"),  # 上传时间
                        "project_num": project_obj.project_num,  # 项目编号
                        "project_source": project_obj.project_source,  # 项目来源
                        "project_unity": project_obj.project_unity,  # 项目申报单位
                        "is_development_project": project_obj.is_development_project,  # 是否属于开发区项目
                        # "sign_time": project_obj.sign_time.strftime("%Y/%m/%d") if project_obj.sign_time and project_obj.sign_time != '0000-00-00 00:00:00' else '',  # 签约时间
                        # "start_time": project_obj.start_time.strftime("%Y/%m/%d") if project_obj.start_time and project_obj.start_time != '0000-00-00 00:00:00' else '',  # 开工时间
                        # "end_time": project_obj.end_time.strftime("%Y/%m/%d") if project_obj.end_time and project_obj.end_time != '0000-00-00 00:00:00' else '',  # 竣工时间
                        "sign_time": project_obj.sign_time,
                        # 签约时间
                        "start_time": project_obj.start_time,
                        # 开工时间
                        "end_time": project_obj.end_time,
                        # 竣工时间
                        "investor_rank": project_obj.investor_rank,  # 投资方排名
                        "is_transf_project": project_obj.is_transf_project,  # 是否转型项目
                        "country": project_obj.country,  # 投资方国别
                        "provence": project_obj.provence,  # 投资方省份
                        "city": project_obj.city,  # 投资方市
                        "job_num": project_obj.job_num,  # 带动就业岗位（个）
                        "new_value": project_obj.new_value,  # 新增产值（亿元）
                        "revenue": project_obj.revenue,  # 贡献税收（亿元）
                        "use_land": project_obj.use_land,  # 项目用地情况（亩）
                        "new_land": project_obj.new_land,  # 其中新增用地（亩）
                        "construction_nature": project_obj.construction_nature,  # 建设性质（亩）
                        "is_fixed_investment": project_obj.is_fixed_investment,  # 固定资产投资项目
                        "investment_year": project_obj.investment_year,  # 资金到位本年累计（万元）
                        "investment_history": project_obj.investment_history,  # 资金到位历史累计（万元）
                        "cooperation_way": project_obj.cooperation_way,  # 合作方式
                        "set_project_status": project_obj.set_project_status,  # 项目立项状态
                        "investor_people": project_obj.investor_people,  # 投资方联系人
                        "investor_mobile": project_obj.investor_mobile,  # 投资方电话
                        "investor_address": project_obj.investor_address,  # 投资方联系地址
                        }
        file_obj_list = project_obj.project_files1
        file_data = [{
            "id": file_obj.id,
            "file_url": file_obj.file_url,
            "file_name": file_obj.file_name,
        } for file_obj in file_obj_list]
        return jsonify(code=RET.OK, data={"data": project_data, "file_data": file_data, "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")