import os
import json
import base64
import requests
import hashlib
from Crypto.Hash import SHA256
from Crypto.PublicKey import RSA
from Crypto.Signature import PKCS1_v1_5 as Signature_pkcs1_v1_5


# 签名类
class Signature:
    '''
        爱城市网扫码登录
        https://open.icity24.cn/
    '''

    def __init__(self, params):
        # self.url = "https://auth.icity24.cn/icity/auth2.0/token"
        self.params = params
        self.privetkey_file_path = os.path.dirname(os.path.dirname(__file__)) + "/utils/json/ty_rsa"
        self.privetkey = self.read_privet_key()
        self.unsign_data = self.generate_sign(self.params)

    # 读取私钥
    def read_privet_key(self):
        with open(self.privetkey_file_path, mode="r", encoding="utf-8") as f:
            privetkey = "".join(f.readlines()[1:-1])
        privetkey = privetkey.encode(encoding='utf-8')
        return privetkey

    # HASH-sha256
    def generate_sign(self, param):
        '''生成hash'''
        # 按ASCII拼接字符串
        stringA = "&".join([f"{k}={param[k]}" for k in sorted(param)])
        # SHA256加密
        hash_sha256 = hashlib.sha256(stringA.encode('utf8')).hexdigest()
        return hash_sha256

    # 生成签名
    def gen_sign(self, secret=None):
        """
        生成签名：是直接读取私钥的方式和未加签的数据
        :return: 签名数据
        """
        rsaKey = RSA.importKey(base64.b64decode(self.privetkey), passphrase=secret)
        signer = Signature_pkcs1_v1_5.new(rsaKey)
        digest = SHA256.new()
        digest.update(self.unsign_data.encode('utf8'))
        sign = signer.sign(digest)
        signature = base64.b64encode(sign)
        return signature.decode()


'''1、获取token'''
appid = "fea79d4c-9906-408c-86a5-8a092fda49b3"
code = "c417598b-5892-4217-81be-c3b6080e9fa1"
# code换取token
params = {
    'appid': appid,  # 爱城市网appID
    'code': code,  # 授权成功后产生的code
    'grant_type': "authorization_code"
}
# 获取签名sign
s = Signature(params)
sign_value = s.gen_sign()
params["sign"] = sign_value
# 认证获取token
resp = requests.post(url="https://auth.icity24.cn/icity/auth2.0/token", data=params)
resp = json.loads(resp.text)
token = resp["token"]

'''2、token获取baseinfo'''
params = {
    'appid': appid,  # 爱城市网appID
    'auth_token': token,  # token
}
# 获取新签名sign
s = Signature(params)
sign_value = s.gen_sign()
params["sign"] = sign_value
# 获取基本信息
user_info = requests.post(url="https://auth.icity24.cn/icity/auth2.0/get_base_info", data=params)
user_info = json.loads(user_info.text)
mobile_phon = user_info["mobile_phon"]  # 手机号
