import os
import json
from elasticsearch import Elasticsearch
from flask import request, jsonify, current_app
from apps.models import *
from apps.view_360company import api_portraits
from apps.util import login_required, verify_token
from apps.utils.response_code import RET
from apps import redis_store


# 默认显示全国企业数据功能接口
@api_portraits.route('/GetAllEnterprise', methods=['POST'])
def get_all_enterprise():
    '''
    默认显示全国企业数据功能接口
    :return:
    '''

    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    # 校验参数完整性
    if not all([id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    try:
        enterprise_all_counts = Enterprise.query.count()
        enterprise_list = Enterprise.query.paginate(page, perpage).items
        if enterprise_list:
            data_list = []
            for enterprise in enterprise_list:
                province = enterprise.province if enterprise.province else ''
                city = enterprise.city if enterprise.city else ''
                district = enterprise.district if enterprise.district else ''
                area = province + city + district
                data = {
                    "id": enterprise.id,
                    "company": enterprise.company_name,  # 企业名
                    "area": area,
                    "createtime": (enterprise.build_date).strftime("%Y-%m-%d") if enterprise.build_date else '',

                    "legal": enterprise.legal,
                    "capital": enterprise.capital,
                    "entype": enterprise.entype,
                    "address": enterprise.address,
                    "telephone": enterprise.telephone,
                    "fianacing": '融资企业' if enterprise.fianacing == "1" else '',
                    "quoted_company": '上市企业' if enterprise.quoted_company == "1" else '',

                    "high_new": '高新技术企业' if enterprise.high_new == '1' else "",
                    "tbe": '科技型中小企业' if enterprise.tbe == '1' else "",
                    "quoted_enterprise": '上市企业' if enterprise.quoted_company == '1' else "",
                    "unicorn": '独角兽企业' if enterprise.unicorn == '1' else "",
                    "dengl": '瞪羚' if enterprise.dengl == '1' else "",
                    "isfive": '中国500强' if enterprise.isfive == '1' else "",
                    "zjtg": '专精特新企业' if enterprise.zjtg == '1' else "",
                    "zjtg_gjjxjr": '国家级专精特新小巨人企业' if enterprise.zjtg_gjjxjr == '1' else "",
                    "zjtg_sjxjr": '省级专精特新小巨人企业' if enterprise.zjtg_sjxjr == '1' else "",
                    "tbe_sjmy": '省级民营科技企业' if enterprise.tbe_sjmy == '1' else "",
                    "chain_master": '链主企业' if enterprise.chain_master == '1' else "",
                }
                data_list.append(data)
            data = {"data": data_list, "size": enterprise_all_counts}
            # data = {"data": [{"id": enterprise.id,
            #                   "company": enterprise.company_name,  # 企业名
            #                   "area": enterprise.province if enterprise.province else '' + enterprise.city if enterprise.city else '' + enterprise.district if enterprise.district else '',
            #                   "createtime": (enterprise.build_date).strftime("%Y-%m-%d") if enterprise.build_date else '',
            #
            #
            #                   "legal": enterprise.legal,
            #                   "capital": enterprise.capital,
            #                   "entype": enterprise.entype,
            #                   "address": enterprise.address,
            #                   "telephone": enterprise.telephone,
            #                   "fianacing": '融资企业' if enterprise.fianacing == "1" else '',
            #                   "quoted_company": '上市企业' if enterprise.quoted_company == "1" else '',
            #
            #                   "high_new": '高新技术企业' if enterprise.high_new == '1' else "",
            #                   "tbe": '科技型中小企业' if enterprise.tbe == '1' else "",
            #                   "quoted_enterprise": '上市企业' if enterprise.quoted_company == '1' else "",
            #                   "unicorn": '独角兽企业' if enterprise.unicorn == '1' else "",
            #                   "dengl": '瞪羚' if enterprise.dengl == '1' else "",
            #                   "isfive": '中国500强' if enterprise.isfive == '1' else "",
            #                   "zjtg": '专精特新企业' if enterprise.zjtg == '1' else "",
            #                   "zjtg_gjjxjr": '国家级专精特新小巨人企业' if enterprise.zjtg_gjjxjr == '1' else "",
            #                   "zjtg_sjxjr": '省级专精特新小巨人企业' if enterprise.zjtg_sjxjr == '1' else "",
            #                   "tbe_sjmy": '省级民营科技企业' if enterprise.tbe_sjmy == '1' else "",
            #                   } for enterprise in enterprise_list], "size": enterprise_all_counts}
        else:
            return jsonify(code=RET.NODATA, msg="查无数据")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 360企业画像--筛选条件下拉框
@api_portraits.route('/DropDownBox', methods=['GET'])
# @login_required
def field():
    '''
    全国企业条件选择导航获取:
    所属行业/企业资质/注册资本/上市状态/成立时间/融资轮次/企业状态/企业规模/企业类型
    :return:
    '''
    try:
        property = Property.query.filter_by(statu=1)
        # 所属行业
        industry_list = property.filter_by(sid=1, statu=1).all()
        # 企业资质
        zizhi_list = property.filter_by(sid=2, statu=1).all()
        # 注册资本
        capital_list = property.filter_by(sid=3, statu=1).all()
        # 上市状态
        quoted_list = property.filter_by(sid=4, statu=1).all()
        # 成立年限
        build_list = property.filter_by(sid=5, statu=1).all()
        # 融资轮次
        financ_list = property.filter_by(sid=6, statu=1).all()
        # 企业状态
        status_list = property.filter_by(sid=7, statu=1).all()
        # 企业规模
        scale_list = property.filter_by(sid=8, statu=1).all()
        # 企业类型
        type_list = property.filter_by(sid=9, statu=1).all()

        data = {"com_industry": [{"label": i.name, "value": i.nid} for i in industry_list],
                "com_zizhi": [{"label": i.name, "value": i.nid} for i in zizhi_list],
                "com_capital": [{"label": i.name, "value": i.nid} for i in capital_list],
                "com_quoted": [{"label": i.name, "value": i.nid} for i in quoted_list],
                "com_build": [{"label": i.name, "value": i.nid} for i in build_list],
                "com_financ": [{"label": i.name, "value": i.nid} for i in financ_list],
                "com_status": [{"label": i.name, "value": i.nid} for i in status_list],
                "com_scale": [{"label": i.name, "value": i.nid} for i in scale_list],
                "com_type": [{"label": i.name, "value": i.nid} for i in type_list],
                }

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")
    return jsonify(code=RET.OK, msg="获取成功", data=data)


# 地域层级数据分级获取
@api_portraits.route('/GetRegion', methods=['GET'])
def get_region():
    try:
        data = open_dists()
        if len(data) > 0:
            return jsonify(code=200, msg="查找成功", data=data)
        else:
            return jsonify(code=201, msg="暂时没有数据")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查找错误")


def open_dists():
    upload_path = os.path.dirname(os.path.dirname(__file__)) + "/utils/json/city.json"
    with open(upload_path, encoding="utf-8") as f:
        data = json.load(f)

    return data


# 搜索接口
@api_portraits.route("/EsSearch", methods=["POST"])
@login_required
def search():
    """
    获取用户信息
    """
    # 参数获取
    req_dict = request.get_json()
    company = req_dict.get("company_name")  # 搜索企业名称
    f_name = req_dict.get("industry")  # 所属行业
    qualificat = req_dict.get("qualificat")  # 企业资质
    capital_id = req_dict.get("capital_id")  # 注册资本
    public_id = req_dict.get("public_id")  # 上市状态
    # area = req_dict.get("area")  # 所在地区
    province = req_dict.get("province")
    city = req_dict.get("city")
    district = req_dict.get("district")
    yearid = req_dict.get("yearid")  # 成立时间
    roundid = req_dict.get("financ_id")  # 融资轮次
    status = req_dict.get("status")  # 企业状态
    scale_range = req_dict.get("scale_range")  # 企业规模
    entypeid = req_dict.get("entypeid")  # 企业类型

    page = req_dict.get("page")  # 页码
    per_page = req_dict.get("per_page")  # 每页大小

    # 页数
    if not page:
        page = 1
    page = int(page)
    page = (page - 1) * per_page

    args_query = dict()  # 查询字段
    args_term = dict()  # 条件字典

    args_query["company_name"] = "公司"
    # 搜索框
    if company:
        args_query["company_name"] = company

    if f_name:
        args_term['f_name'] = f_name
    # 公司资质
    if qualificat:
        if qualificat == 1:
            args_term['isfive'] = 1
        if qualificat == 2:
            args_term['quoted_company'] = 1
        if qualificat == 3:
            args_term['fianacing'] = 1
        if qualificat == 4:
            args_term['high_new'] = 1
        if qualificat == 5:
            args_term['tbe'] = 1
        if qualificat == 6:
            args_term['dengl'] = 1
        if qualificat == 7:
            args_term['unicorn'] = 1
    # 注册资本
    if capital_id:
        args_term['capital_id'] = capital_id
    # 上市状态
    if public_id:
        args_term['public_id'] = public_id
    # 省
    if province:
        args_term['province'] = province
    # 市
    if city:
        args_term['city'] = city
    # 区
    if district:
        args_term['district'] = district

    # 成立时间
    if yearid:
        args_term['yearid'] = yearid
    # 融资轮次
    if roundid:
        args_term['roundid'] = roundid
    # 企业状态
    if status:
        args_term['status'] = status
    # 企业规模
    if scale_range:
        args_term['scale_range'] = scale_range
        # 公司类型
    if entypeid:
        args_term['entypeid'] = entypeid

    body = create_body(page, per_page, args_query, args_term)
    if not company:
        del body["query"]["bool"]["must"][0]

    try:
        es = Elasticsearch([{'host': '39.100.39.50', 'port': 9200}])

        # data = es.search(index="jincheng_pictext_index_202303161620_76c624b8", body=body)
        data = es.search(index="jc_enterperise1", body=body)
        data_list = []
        # print(data_list)
        size = data["hits"]['total']

        # 数据的列表添加进去
        for i in data["hits"]['hits']:
            if company:
                # 判断高亮，然后添加
                data_list.append({
                    "id": i["_source"]["mysql_id"],
                    "company": i["highlight"]["company_name"][0] if "company_name" in i["highlight"] else i["_source"][
                        "company_name"],
                    "area": i["_source"]["province"] + i["_source"]["city"] + i["_source"]["district"],
                    "createtime": i["_source"]["build_date"],
                    "legal": i["_source"]["legal"],
                    "capital": i["_source"]["capital"],
                    "entype": i["_source"]["entype"],
                    "address": i["_source"]["address"],
                    "telephone": i["_source"]["telephone"],
                    "high_new": '高新技术企业' if i["_source"]["high_new"] == "1" else '',
                    "tbe": '科技型中小企业' if i["_source"]["tbe"] == "1" else '',
                    "fianacing": '融资企业' if i["_source"]["fianacing"] == "1" else '',
                    "quoted_company": '上市企业' if i["_source"]["quoted_company"] == "1" else '',
                    "dengl": '瞪羚企业' if i["_source"]["dengl"] == "1" else '',
                    "unicorn": '独角兽企业' if i["_source"]["unicorn"] == "1" else '',
                    "isfive": '500强企业' if i["_source"]["isfive"] == '1' else '',
                    # "serve": '限额以上服务业' if i["_source"]["serve"] == '1' else '',
                    # "chain_master": '链主企业' if i["_source"]["chain_master"] == '1' else '',
                })
            else:
                data_list.append({
                    "id": i["_source"]["mysql_id"],
                    "company": i["_source"]["company_name"],
                    "area": i["_source"]["province"] + i["_source"]["city"] + i["_source"]["district"],
                    "createtime": i["_source"]["build_date"],
                    "legal": i["_source"]["legal"],
                    "capital": i["_source"]["capital"],
                    "entype": i["_source"]["entype"],
                    "address": i["_source"]["address"],
                    "telephone": i["_source"]["telephone"],
                    "high_new": '高新技术企业' if i["_source"]["high_new"] == "1" else '',
                    "tbe": '科技型中小企业' if i["_source"]["tbe"] == "1" else '',
                    "fianacing": '融资企业' if i["_source"]["fianacing"] == "1" else '',
                    "quoted_company": '上市企业' if i["_source"]["quoted_company"] == "1" else '',
                    "dengl": '瞪羚企业' if i["_source"]["dengl"] == "1" else '',
                    "unicorn": '独角兽企业' if i["_source"]["unicorn"] == "1" else '',
                    "isfive": '500强企业' if i["_source"]["isfive"] == '1' else '',
                    # "serve": '限额以上服务业' if i["_source"]["serve"] == '1' else '',
                    # "chain_master": '链主企业' if i["_source"]["chain_master"] == '1' else '',
                })
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="es数据库错误")
    data = {
        "data": data_list, "size": size
    }
    return jsonify(code=RET.OK, msg="查找成功", data=data)


def body_qualificat(s, j):
    body = {
        "query": {
            "bool": {
                "must": {"match": {"{}": "{}".format(s, j)}}
            }
        }
    }
    return body


def create_body(page, page_size, args_query, args_term):
    body = {
        "query": {
            "bool": {
                "must": [
                    {"match": {
                        "company_name": "{}".format(args_query["company_name"]),
                    }
                    },
                ]
            }
        },
        "from": page,
        "size": page_size,
        "sort": [{"host": {"order": "desc"}}],
        # "sort": [],

        "aggs": {},
        "_source": [
            "mysql_id", 'province', 'company_name', 'city', 'district', 'build_date', 'legal', 'capital', 'entype', 'address',
            'telephone',
            "high_new", "tbe", "fianacing", "quoted_company", "foreign_investment", "patent", "dengl", "unicorn",
            "isfive"
        ],
        "highlight": {
            "fields": {
                "company_name": {},
                "entype": {},
            },
            "pre_tags": "<font color='red'>",
            "post_tags": "</font>",
            "fragment_size": 10
        }
    }

    for k, v in args_term.items():
        body["query"]["bool"]["must"].append({"match": {"{}".format(k): "{}".format(v)}})
    # print(body)
    return body

# 原始
# def create_body(page, page_size, args_query, args_term):
#     body = {
#         "query": {
#             "bool": {
#                 "filter": {
#                     "range": {
#                         "build_date": {
#                         }
#                     }
#                 },
#                 "must": [
#                     {"multi_match": {
#                         "query": "{}".format(args_query["query"]),
#                         "type": "best_fields",
#                         "fields": [
#                             "product^1.0",
#                             "company_name^1.0",
#                             "industry^1.0"
#                         ],
#                         "tie_breaker": 0.3
#                     }
#                     },
#                 ]
#             }
#         },
#         "from": page,
#         "size": page_size,
#         "sort": [],
#         "aggs": {},
#         "_source": [
#             # 'all_info',
#             'industry', 'build_date', 'register_money_nums', 'product',
#             'company_name', "mysql_id"
#         ],
#         "highlight": {
#             "fields": {
#                 "product": {"type": "plain"},
#                 "company_name": {"type": "plain"},
#                 "industry": {"type": "plain"}
#             }
#         }
#     }
#
#     for k, v in args_term.items():
#         body["query"]["bool"]["must"].append({"term": {"{}".format(k): "{}".format(v)}})
#
#     return body
