from sqlalchemy import func, desc, or_
from flask import current_app, request, jsonify
from apps.models import Induzone, Industry, CompanyIndustryPoint
from apps.utils.response_code import RET
from apps.view_choose import api_address


#  获取某个行政区的全部园区信息
@api_address.route("/DefaultAddress", methods=["POST"])
def default_address():
    req_dict = request.get_json()
    district = req_dict.get("district")  # 获取区县参数
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    # 查询出该区县的所有园区列表
    try:
        if district=="晋城市":
            result = Induzone.query.filter_by(upper_district=district, cate='产业园区').all()
            all_jwd = [{"id": i.id, "name": i.name, "lng": i.lng, "lat": i.lat} for i in result]
            size = len(result)
            result = Induzone.query.filter_by(upper_district=district, cate='产业园区')
            result = result.paginate(page, perpage).items
        else:
            result = Induzone.query.filter_by(district=district, cate='产业园区').all()
            all_jwd = [{"id": i.id, "name": i.name, "lng": i.lng, "lat": i.lat} for i in result]
            size = len(result)
            result = Induzone.query.filter_by(district=district, cate='产业园区')
            result = result.paginate(page, perpage).items
        if not result:
            # 在第一条建议显示
            data = [{"name": "没有找到合适的园区！"}]
            return jsonify(code=RET.OK, msg="选址成功", data=data)

        # 遍历园区，获取详细信息
        data = {"data": [{"id": i.id,
                          "name": i.name,  # 园区名称
                          "level": i.level,  # 园区级别
                          "type": i.industry_type,  # 园区类别
                          "charge": i.charge if i.charge else "-",  # 园区负责人
                          "phone": i.phone if i.phone else "-",  # 园区电话
                          "address": i.address,  # 园区地址
                          # "address": i.region,  # 园区地址
                          "jwd": {"lng": i.lng, "lat": i.lat}} for i in result], "all_jwd": all_jwd, "size": size}
        if not result:
            # 在第一条建议显示
            data = [{"name": "没有找到合适的园区！"}]
        return jsonify(code=RET.OK, msg="选址成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 选址评估，选择建议
@api_address.route("/ChooseAddress", methods=["POST"])
def advice():
    req_dict = request.get_json()
    industry_id = req_dict.get("industry_id")  # 所属行业选择 nid（必填）
    product = req_dict.get("product")  # 主营产品 "药" （必填）
    budget = req_dict.get('budget')  # 落地投资预算 "22" # 大于 （必填）
    preference = req_dict.get("preference")  # 选址偏好 [f,f,t,f,f,f]
    revenue = req_dict.get("revenue")  # 去年营收 "2" （非必填）
    tax = req_dict.get("tax")  # 去年税收 "1" （非必填）
    address = req_dict.get("address")  # 意向选址 （非必填）

    page = req_dict.get("page")
    perpage = req_dict.get("perpage")
    # print(address)
    if not all([industry_id, product, budget, preference]):
        return jsonify(code=RET.DATAERR, msg="数据不全")
    try:
        indu = Industry.query.filter_by(nid=industry_id).first()
        if not indu:
            return jsonify(code=RET.DATAERR, msg="参数错误")
        # 获取产业名称
        industry_name = indu.oname
        # 根据产业名称查询园区
        zone = Induzone.query.filter(or_(Induzone.navigat.like("%{}%".format(industry_name)),
                                         Induzone.navigator.like("%{}%".format(industry_name))))
        print(zone.all())
        # 根据投资预算过滤
        if budget:
            zone = zone.filter(Induzone.invest_power < float(budget))
        if address and address == '晋城市':  # 如果有选址
            # zone = zone.filter(or_(Induzone.upper_district == address, Induzone.development_zone == address))
            zone = zone.filter(or_(Induzone.upper_district == address))
        if address and address != '晋城市':  # 如果有选址
            # zone = zone.filter(or_(Induzone.region == address, Induzone.development_zone == address))
            zone = zone.filter(or_(Induzone.region == address))

        if tax:  # 如果有税收
            zone = zone.filter(Induzone.tax < tax)
        if preference[0] == "true":  # 如果有政府扶持力度 --- 政策数的打分
            zone = zone.order_by(Induzone.policy_point.desc())
        if preference[1] == "true":  # 产业聚集度 --- 产业的打分
            zone = zone.outerjoin(CompanyIndustryPoint, Induzone.name == CompanyIndustryPoint.district).filter(
                CompanyIndustryPoint.f_type == industry_id).order_by(CompanyIndustryPoint.point.desc()).all()
        if preference[2] == "true":  # 园区配套服务 ----园区的学校，商业街，宾馆打分
            zone = zone.order_by(Induzone.mall_point.desc(), Induzone.hotel_point.desc(), Induzone.school_point.desc())

        if preference[3] == "true":  # 生活配套服务
            zone = zone.order_by(Induzone.live_point.desc())
        if preference[4] == "true":  # 交通 -----交通打分
            zone = zone.order_by(Induzone.traffic_point.desc())
        size = zone.count()
        result = zone.paginate(page, perpage).items
        zone = zone.all()
        all_jwd = [{"id": i.id, "name": i.name, "lng": i.lng, "lat": i.lat} for i in zone]
        data = {"data": [{"id": i.id,
                          "name": i.name,  # 园区名称
                          "level": i.level,  # 园区级别
                          "type": i.industry_type,  # 园区类别
                          "charge": i.charge if i.charge else "-",  # 园区负责人
                          "phone": i.phone if i.phone else "-",  # 园区电话
                          "address": i.address,  # 园区地址
                          # "address": i.region,  # 园区地址
                          "jwd": {"lng": i.lng, "lat": i.lat}} for i in result], "all_jwd": all_jwd, "size": size}
        if not result:
            # 在第一条建议显示
            data = [{"name": "没有找到合适的园区！"}]
        return jsonify(code=RET.OK, msg="选址成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 获取筛选条件的行业
@api_address.route("/DownList", methods=["GET"])
def downlist():  # 一级二级行业分类
    try:
        industry = Industry.query.filter_by(statu=1).all()
        data = [{
            "name": i.name,
            "id": i.nid,
        } for i in industry]
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")

    return jsonify(code=RET.OK, msg="查找成功", data=data)
