import re
from flask import request, jsonify, current_app
from sqlalchemy import func, desc, or_, and_
from apps.manage import api_power
from apps.models import *
from apps.utils.response_code import RET
from apps.util import login_required

"""局内用户"""


# 获取角色
@api_power.route("/getRole", methods=["GET"])
@login_required
def roleinfo():
    try:
        chart_obj_list = OrganizationChart.query.all()
        data_li = []
        for chart_obj in chart_obj_list:
            # if chart_obj.id > 43:
            data_dic = {}
            data_dic.update({"id": chart_obj.id, "three_role": chart_obj.three_role})
            data_li.append(data_dic)
        return jsonify(code=RET.OK, data=data_li, msg="查询成功！")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 构造当前机构部门的层级下拉框数据,用于新增/编辑角色接口
@api_power.route("/OrgDownBox", methods=["GET"])
# @login_required
def org_downbox():
    # 获取固定
    # 1. 获取第一级(机构数据)
    gover = Government.query.all()
    gover_data = [{"label": i.name, "value": i.id} for i in gover]
    for gover in gover_data:
        gover_id = gover['value']

        # 2. 获取该机构下的部门
        goverment = Government.query.get(gover_id)
        sections = goverment.sections  # 查询当前机构下的部门list
        if not sections:
            continue
        sec_data = [{"label": sec.name, "value": sec.id} for sec in sections]
        # 把部门数据作为children添加到 gover_data
        gover.update({"children": sec_data})

        # 3. 获取该机构下的部门
        for sec in sec_data:
            sec_id = sec['value']
            section = Section.query.get(sec_id)
            groups = section.groups  # 查询当前部门下的组list
            if not groups:
                continue
            groups_data = [{"id": group.id, "name": group.name} for group in groups]
            sec.update({"children": groups_data})
            # print(sec)
    return jsonify(code=RET.OK, data=gover_data, msg="查询成功！")


# 局内用户新增
@api_power.route("/AddUser", methods=["POST"])
@login_required
def add_user():
    req_dict = request.get_json()
    real_name = req_dict.get("real_name")  # 真实姓名
    position = req_dict.get("position")  # 职务
    one_org = req_dict.get("one_org")  # 机构
    two_department = req_dict.get("two_department")  # 部门
    three_role = req_dict.get("three_role")  # 角色
    mobile = req_dict.get("mobile")
    password = req_dict.get("password")
    password1 = req_dict.get("password1")

    # 校验参数完整性
    if not all([real_name, position, one_org,
                three_role, mobile, password, password1]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")

    # 判断手机号
    try:
        user = User.query.filter_by(mobile=mobile).first()
        if user:
            return jsonify(code=RET.DATAEXIST, msg="手机号已存在")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="手机号已存在")

    try:
        if not any([password, password1]):
            return jsonify(code=RET.PARAMERR, msg="密码和确认密码都不能为空！")
        if password != password1:
            return jsonify(code=RET.PARAMERR, msg="两次输入的密码不一致，请确认！")

        user = User(real_name=real_name, mobile=mobile, belong_organization=one_org, position=position,
                    flag=2, status=2, belong_department=two_department)
        user.password = password

        org_obj = OrganizationChart.query.filter(
            OrganizationChart.three_role == three_role).first()
        user.org_id = org_obj.id
        db.session.add(user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="添加成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库错误")


# 局内用户列表
@api_power.route("/userListOfInside", methods=["POST"])
@login_required
def user_list_inside():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    key = req_dict.get("key")  # 查询条件
    status = req_dict.get("status")  # 1通过，2在审，3驳回
    one_org = req_dict.get("one_org")
    two_department = req_dict.get("two_department")

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.filter_by(flag=2)
        if key:
            user = user.filter(or_(User.real_name.like("%{}%".format(key)), User.name.like("%{}%".format(key))))
        if status:
            user = user.filter_by(status=status)
        if one_org:
            org_obj = OrganizationChart.query.filter_by(one_org=one_org).first()
            if org_obj:
                org_id = org_obj.id
                user = user.filter_by(org_id=org_id)
        if two_department:
            org_obj = OrganizationChart.query.filter_by(two_department=two_department).first()
            if org_obj:
                org_id = org_obj.id
                user = user.filter_by(org_id=org_id)

        size = user.count()
        result = user.paginate(page, perpage).items
        df = [{"id": i.id,
               "real_name": i.real_name if i.real_name else "-",
               "position": i.position if i.position else "-",
               "unit": i.belong_organization if i.belong_organization else "-",
               "section": i.belong_department if i.belong_department else "-",
               "role": i.org.three_role if i.org.three_role else "-",
               "mobile": i.mobile if i.mobile else "-",
               # "status": "通过" if i.status == 1 else "在审" if i.status == 2 else "驳回"
               "status": i.status
               } for i in result]
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 局内用户信息
@api_power.route("/userInsideInfo", methods=["POST"])
@login_required
def user_inside_info():
    req_dict = request.get_json()
    _id = req_dict.get("id")

    try:
        i = User.query.get(_id)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="用户信息查询失败")
    try:
        data = {"id": i.id,
                "real_name": i.real_name if i.real_name else "-",
                "position": i.position if i.position else "-",
                "unit": i.belong_organization if i.belong_organization else "-",
                "section": i.belong_department if i.belong_department else "-",
                "role": i.org.three_role if i.org.three_role else "-",
                "mobile": i.mobile if i.mobile else "-",
                # "status": "通过" if i.status == 1 else "在审" if i.status == 2 else "驳回"
                }
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 编辑用户账号详情信息
@api_power.route("/updateUser", methods=["POST"])
@login_required
def update_user():
    req_dict = request.get_json()
    _id = req_dict.get("id")  # 当亲用户id
    real_name = req_dict.get("real_name")  # 真名
    position = req_dict.get("position")  # 职务
    one_org = req_dict.get("one_org")  # 机构
    two_department = req_dict.get("two_department")  # 部门
    three_role = req_dict.get("three_role")  # 角色
    mobile = req_dict.get("mobile")
    password = req_dict.get("password")
    password1 = req_dict.get("password1")

    # # 校验参数完整性
    # if not all([_id, real_name, three_role, mobile]):
    #     return jsonify(code=RET.PARAMERR, msg="姓名、角色、手机号必填！")
    try:
        org_obj = OrganizationChart.query.filter_by(
            three_role=three_role).first()
        if not org_obj:
            return jsonify(code=RET.NODATA, msg="选择的角色不存在！")

        user = User.query.get(_id)
        user.org_id = org_obj.id
        user.position = position
        user.belong_organization = one_org
        user.belong_department = two_department
        user.mobile = mobile
        user.real_name = real_name
        if password and not password1:
            return jsonify(code=RET.PARAMERR, msg="请填写确认密码！")
        if password1 and not password:
            return jsonify(code=RET.PARAMERR, msg="请填写密码！")
        if password and password1:
            if password != password1:
                return jsonify(code=RET.PARAMERR, msg="密码和确认密码不一致！")
            else:
                user.password = password

        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 账号状态编辑（通过，在审，驳回）
@api_power.route("/updateAccount", methods=["POST"])
@login_required
def update_account():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    status = req_dict.get("status")  # 1通过，2在审，3驳回

    # 校验参数完整性
    if not all([_id, status]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(_id)
        user.status = status
        db.session.commit()
        dict_zh = {1: "通过", 2: "在审", 3: "驳回"}
        data = dict_zh[status]
        return jsonify(code=RET.OK, msg="修改成功", info=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 删除用户(批量删除，单个删除)
@api_power.route("/deleteUser", methods=["POST"])
@login_required
def delete_user():
    req_dict = request.get_json()
    id_list = req_dict.get("id_list")  # list[1,2,3]

    # 校验参数完整性
    if not all([id_list]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        for i in id_list:
            user = User.query.get(i)
            db.session.delete(user)
        db.session.commit()
        return jsonify(code=RET.OK, msg="删除成功")
    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="删除失败")


"""外部访客"""


# 外部访客列表
@api_power.route("/userListOfExternal", methods=["POST"])
@login_required
def user_list_external():
    req_dict = request.get_json()
    page = req_dict.get("page")
    perpage = req_dict.get("perpage")

    # 校验参数完整性
    if not all([page, perpage]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.filter_by(flag=1)
        result = user.paginate(page, perpage).items
        size = user.count()
        df = [{"id": i.id,
               "real_name": i.real_name if i.real_name else "-",
               "mobile": i.mobile if i.mobile else "-",
               "create_time": str(i.create_time) if i.create_time else "-",
               "status": i.status  # 0禁止，1启动
               } for i in result]
        data = {"df": df, "size": size}
        return jsonify(code=RET.OK, msg="查询成功", data=data)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库查询错误")


# 外部访客状态修改(禁用、启用)
@api_power.route("/updateStatus", methods=["POST"])
@login_required
def update_status():
    req_dict = request.get_json()
    _id = req_dict.get("id")
    status = req_dict.get("status")  # 0禁止，1在用

    # 校验参数完整性
    if not all([_id]):
        return jsonify(code=RET.PARAMERR, msg="参数不完整")
    try:
        user = User.query.get(_id)
        if status == 1:
            user.status = 1
        else:
            user.status = 0
        db.session.commit()
        return jsonify(code=RET.OK, msg="修改成功")
    except Exception as e:
        # 操作失败，操作返回
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据库操作错误")
