import os
import time
import datetime
import random
import re

import oss2
import pandas as pd
import xlrd
import xlsxwriter
import xlwt
from flask import jsonify, request, current_app
from sqlalchemy import or_, and_, desc
from apps.models import *
from apps.util import login_required, verify_token
from apps.inves_manage import api_manage
from apps.utils.response_code import RET
from dateutil.relativedelta import relativedelta


# 构造项目编号序号
from apps. view_choose.choose_view import get_district_name


def get_num(num):
    if len(str(int(num))) == 1:
        if int(num) == 9:
            num = '0' + str(int(num) + 1)
        else:
            num = '00' + str(int(num) + 1)
    elif len(str(int(num))) == 2:
        if int(num) == 99:
            num = '100'
        else:
            num = '0' + str(int(num) + 1)
    elif len(str(int(num))) == 3:
        num = str(int(num) + 1)
    else:
        num = 'error'
    return num


# 上传线索库
def upload_xiansuo_project(row_content, time_strf, upload_time, upload_unity, upload_people):
    try:
        project_name = row_content[1]  # 项目名称
        investor_name = row_content[2]  # 投资方名称
        investor_district1 = row_content[3]  # 投资方所在地,sheng
        investor_district2 = row_content[4]  # 投资方所在地,市
        if investor_district2:
            if investor_district2 in ['北京市', '上海市', '天津市', '重庆市']:
                # return jsonify(code=RET.DATAERR, msg='{} 项目，请按照表格要求填写直辖市和行政区'.format(project_name))
                return 'error2'
            investor_district = investor_district1 + '/' + investor_district2
        else:
            investor_district = investor_district1

        project_type1 = row_content[5]  # 项目单位（投资方项目类型
        project_type2 = row_content[6]  # 项目单位（投资方项目类型
        if project_type2:
            project_type = project_type1 + '/' + project_type2
        else:
            project_type = project_type1

        investment_volume = row_content[7]  # 总投资额(万元)
        if investment_volume:
            investment_volume = float(investment_volume)
        investment_volume1 = row_content[8]  # 拟引资额(万元)
        if investment_volume1:
            investment_volume = float(investment_volume1)
        project_info = row_content[9]  # 项目基本情况
        project_info1 = row_content[10]  # 项目方基本情况
        thread_people = row_content[11]  # 线索提供人
        thread_people_unity = row_content[12]  # 线索提供人单位或职务
        thread_people_mobile = row_content[13]  # 线索提供人联系方式
        remark = row_content[14]  # 备注

        project_obj_list = SikuProject.query.all()  # 项目编号
        project_num_list = ''
        if project_obj_list:
            project_num_list = [project_obj.project_num for project_obj in
                        project_obj_list if (project_obj.project_num).startswith(time_strf)]
        if project_num_list:
            max_project_num = max(project_num_list)[8:]
            num = get_num(max_project_num)
            if num == 'error':
                return 'error'
            project_num = time_strf + num
        else:
            project_num = time_strf + '001'

        # 创建项目
        new_project_obj = SikuProject(
            flag=1,  # 表示线索库
            is_delete=0,
            thread_progress='待对接',
            provence=investor_district1,
            city=investor_district2,
            industry=project_type1,
            industry2=project_type2,
            upload_unity=upload_unity,
            upload_people=upload_people,
            upload_time=upload_time,
            project_year=upload_time.split('/')[0],
            project_name=project_name,
            project_num=int(project_num),
            investor_name=investor_name,
            investor_district=investor_district,
            project_type=project_type,
            investment_volume=investment_volume,
            investment_volume1=investment_volume1,
            project_info=project_info,
            project_info1=project_info1,
            thread_people=thread_people,
            thread_people_unity=thread_people_unity,
            thread_people_mobile=thread_people_mobile,
            remark=remark,
        )
        db.session.add(new_project_obj)
        db.session.commit()
        project_id = new_project_obj.id

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(upload_people, project_id, '导入了项目', time1)
        return 'continue'
    except Exception as e:
        return 'error1'


# 更新对接库
def update_joint_project(upload_people, row_content):
    try:
        project_num = row_content[0]  # 项目编号
        if not project_num:
            return 'error3'
        project_name = row_content[1]  # 项目名称
        investor_name = row_content[2]  # 投资方名称
        investor_district1 = row_content[3]  # 投资方所在地,省
        investor_district2 = row_content[4]  # 投资方所在地，市

        if investor_district2:
            if investor_district2 in ['北京市', '上海市', '天津市', '重庆市']:
                return 'error2'
            investor_district = investor_district1 + '/' + investor_district2
        else:
            investor_district = investor_district1

        project_type1 = row_content[5]  # 项目单位（项目类型），一级行业
        project_type2 = row_content[6]  # 项目单位（项目类型），二级行业
        project_type = project_type1 + '/' + project_type2
        investment_volume = row_content[7]  # 总投资额(万元总投资额(万元)
        if investment_volume:
            investment_volume = float(investment_volume)
        investment_volume1 = row_content[8]  # 拟引资额(万元拟引资额(万元)
        if investment_volume1:
            investment_volume = float(investment_volume1)
        project_to_area = row_content[9]  # 拟落地区域
        development_area = row_content[10]  # 开发区
        project_address = row_content[11]  # 项目详细地址
        joint_condition = row_content[12]  # 项目对接情况
        project_problem = row_content[13]  # 项目当前存在的问题
        project_stalker = row_content[14]  # 项目跟踪人
        joint_person = row_content[15]  # 对接人
        joint_person_unity = row_content[16]  # 对接人单位及职务
        joint_person_mobile = row_content[17]  # 对接人联系方式
        project_people = row_content[18]  # 项目方联系人
        project_people_unity = row_content[19]  # 项目方单位或职务
        project_people_mobile = row_content[20]  # 项目方联系方式
        remark = row_content[21]  # 备注

        project_obj = SikuProject.query.filter_by(
            project_num=project_num).first()  # 项目编号
        project_id = project_obj.id

        # 更新项目信息
        project_obj.thread_progress = '对接中',
        project_obj.project_name = project_name
        project_obj.provence = investor_district1
        project_obj.city = investor_district2
        project_obj.industry = project_type1
        project_obj.industry2 = project_type2
        project_obj.investor_name = investor_name
        project_obj.investor_district = investor_district
        project_obj.project_type = project_type
        project_obj.investment_volume = investment_volume
        project_obj.investment_volume1 = investment_volume1
        project_obj.remark = remark
        project_obj.project_to_area = project_to_area
        project_obj.development_area = development_area
        project_obj.project_address = project_address
        project_obj.joint_condition = joint_condition
        project_obj.project_problem = project_problem
        project_obj.project_stalker = project_stalker
        project_obj.joint_person = joint_person
        project_obj.joint_person_unity = joint_person_unity
        project_obj.joint_person_mobile = joint_person_mobile
        project_obj.project_people = project_people
        project_obj.project_people_unity = project_people_unity
        project_obj.project_people_mobile = project_people_mobile
        db.session.commit()

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(upload_people, project_id, '更新了对接库', time1)
        return 'continue'
    except Exception as e:
        return 'error1'


# 更新签约库
def update_sign_project(upload_people, row_content):
    try:
        project_num = row_content[0]  # 项目编号
        if not project_num:
            return 'error3'
        project_name = row_content[1]  # 项目名称
        attract_name = row_content[2]  # 引资方名称
        investor_name = row_content[3]  # 投资方名称
        investor_district1 = row_content[4]  # 投资方所在地,省
        investor_district2 = row_content[5]  # 投资方所在地，市
        if investor_district2:
            if investor_district2 in ['北京市', '上海市', '天津市', '重庆市']:
                return 'error2'
            investor_district = investor_district1 + '/' + investor_district2
        else:
            investor_district = investor_district1
        project_type1 = row_content[6]  # 项目单位（项目类型），一级行业
        project_type2 = row_content[7]  # 项目单位（项目类型），二级行业
        project_type = project_type1 + '/' + project_type2
        investment_volume = row_content[8]  # 总投资额(万元总投资额(万元)
        if investment_volume:
            investment_volume = float(investment_volume)
        investment_volume1 = row_content[9]  # 拟引资额(万元拟引资额(万元)
        if investment_volume1:
            investment_volume = float(investment_volume1)
        project_to_area = row_content[10]  # 拟落地区域
        development_area = row_content[11]  # 开发区
        project_address = row_content[12]  # 项目详细地址

        progress_condition = row_content[13]  # 项目推进情况
        Party_A_name = row_content[14]  # 签约甲方名称
        Party_A_people = row_content[15]  # 签约甲方联系人
        Party_A_mobile = row_content[16]  # 签约甲方联系方式
        Party_B_name = row_content[17]  # 签约乙方名称
        Party_B_people = row_content[18]  # 签约乙方联系人
        Party_B_mobile = row_content[19]  # 签约乙方联系方式
        sign_time = row_content[20]  # 签约时间

        project_stalker = row_content[21]  # 项目跟踪人
        joint_person = row_content[22]  # 对接人
        joint_person_unity = row_content[23]  # 对接人单位及职务
        joint_person_mobile = row_content[24]  # 对接人联系方式
        project_people = row_content[25]  # 项目方联系人
        project_people_unity = row_content[26]  # 项目方单位或职务
        project_people_mobile = row_content[27]  # 项目方联系方式
        remark = row_content[28]  # 备注

        project_obj = SikuProject.query.filter_by(
            project_num=project_num).first()  # 项目编号
        project_id = project_obj.id

        # 更新项目信息
        project_obj.project_name = project_name
        project_obj.provence = investor_district1
        project_obj.city = investor_district2
        project_obj.industry = project_type1
        project_obj.industry2 = project_type2
        project_obj.investor_name = investor_name
        project_obj.attract_name = attract_name
        project_obj.investor_district = investor_district
        project_obj.project_type = project_type
        project_obj.investment_volume = investment_volume
        project_obj.investment_volume1 = investment_volume1
        project_obj.remark = remark
        project_obj.project_to_area = project_to_area
        project_obj.development_area = development_area
        project_obj.project_address = project_address

        project_obj.progress_condition = progress_condition
        project_obj.Party_A_name = Party_A_name
        project_obj.Party_A_people = Party_A_people
        project_obj.Party_A_mobile = Party_A_mobile
        project_obj.Party_B_name = Party_B_name
        project_obj.Party_B_people = Party_B_people
        project_obj.Party_B_mobile = Party_B_mobile
        project_obj.sign_time = sign_time
        project_obj.sign_year = sign_time.split('-')[0]

        project_obj.project_stalker = project_stalker
        project_obj.joint_person = joint_person
        project_obj.joint_person_unity = joint_person_unity
        project_obj.joint_person_mobile = joint_person_mobile
        project_obj.project_people = project_people
        project_obj.project_people_unity = project_people_unity
        project_obj.project_people_mobile = project_people_mobile
        db.session.commit()

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(upload_people, project_id, '更新了签约库', time1)
        return 'continue'
    except Exception as e:
        return 'error1'


# 更新开工库
def update_start_project(upload_people, row_content):
    try:
        project_num = row_content[0]  # 项目编号
        if not project_num:
            return 'error3'
        project_name = row_content[1]  # 项目名称
        attract_name = row_content[2]  # 引资方名称
        investor_name = row_content[3]  # 投资方名称
        investor_district1 = row_content[4]  # 投资方所在地,省
        investor_district2 = row_content[5]  # 投资方所在地，市
        if investor_district2:
            if investor_district2 in ['北京市', '上海市', '天津市', '重庆市']:
                return 'error2'
            investor_district = investor_district1 + '/' + investor_district2
        else:
            investor_district = investor_district1
        project_type1 = row_content[6]  # 项目单位（项目类型），一级行业
        project_type2 = row_content[7]  # 项目单位（项目类型），二级行业
        project_type = project_type1 + '/' + project_type2
        investment_volume = row_content[8]  # 总投资额(万元总投资额(万元)
        if investment_volume:
            investment_volume = float(investment_volume)
        investment_volume1 = row_content[9]  # 拟引资额(万元拟引资额(万元)
        if investment_volume1:
            investment_volume = float(investment_volume1)
        investment = row_content[10]  # 到位资金
        project_to_area1 = row_content[11]  # 落地区域
        development_area = row_content[12]  # 开发区
        project_address = row_content[13]  # 项目详细地址

        progress_condition = row_content[14]  # 项目推进情况

        project_problem = row_content[15]  # 项目当前存在的问题
        sign_time = row_content[16]  # 签约时间

        start_time = row_content[17]  # 开工时间
        project_stalker = row_content[18]  # 项目跟踪人
        joint_person = row_content[19]  # 对接人
        joint_person_unity = row_content[20]  # 对接人单位及职务
        joint_person_mobile = row_content[21]  # 对接人联系方式
        project_people = row_content[22]  # 项目方联系人
        project_people_unity = row_content[23]  # 项目方单位或职务
        project_people_mobile = row_content[24]  # 项目方联系方式
        remark = row_content[25]  # 备注

        project_obj = SikuProject.query.filter_by(
            project_num=project_num).first()  # 项目编号
        project_id = project_obj.id

        # 更新项目信息
        project_obj.project_num = project_num
        project_obj.project_name = project_name
        project_obj.provence = investor_district1
        project_obj.city = investor_district2
        project_obj.industry = project_type1
        project_obj.industry2 = project_type2
        project_obj.investor_name = investor_name
        project_obj.attract_name = attract_name
        project_obj.investor_district = investor_district
        project_obj.project_type = project_type
        project_obj.investment_volume = investment_volume
        project_obj.investment_volume1 = investment_volume1
        project_obj.investment = investment

        project_obj.project_to_area1 = project_to_area1
        project_obj.development_area = development_area
        project_obj.project_address = project_address

        project_obj.progress_condition = progress_condition
        project_obj.project_problem = project_problem
        project_obj.sign_time = sign_time
        project_obj.start_time = start_time
        project_obj.start_year = start_time.split('/')[0]

        project_obj.project_stalker = project_stalker
        project_obj.joint_person = joint_person
        project_obj.joint_person_unity = joint_person_unity
        project_obj.joint_person_mobile = joint_person_mobile
        project_obj.project_people = project_people
        project_obj.project_people_unity = project_people_unity
        project_obj.project_people_mobile = project_people_mobile
        project_obj.remark = remark
        db.session.commit()

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(upload_people, project_id, '更新了开工库', time1)
        return 'continue'
    except Exception as e:
        return 'error1'


def upload_daily_picture(file_type, file_name, file):
    try:
        access_key_id = "LTAI4Fkgi7DUf6jCVW3KNGwT"
        access_key_secret = "ynr6TWWNOnpALn3YUICUaXwpp9w4er"
        auth = oss2.Auth(access_key_id, access_key_secret)
        bucket_name = "zysf-store"
        endpoint = "oss-cn-beijing.aliyuncs.com"
        bucket = oss2.Bucket(auth, endpoint, bucket_name)
        file_name = file_name.split('.')
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = file_name[0] + time_stamp + '.' + file_name[1]
        file_url = ''
        if file_type == 1:
            bucket.put_object('晋城招商图谱平台/四库管理文件/文件/' + file_name, file)
            file_url = "https://{}.{}/{}".format(bucket_name, endpoint, '/晋城招商图谱平台/四库管理文件/文件/' + file_name)
        if file_type == 2:
            bucket.put_object('晋城招商图谱平台/四库管理文件/图片/' + file_name, file)
            file_url = "https://{}.{}/{}".format(bucket_name, endpoint, '/晋城招商图谱平台/四库管理文件/图片/' + file_name)
        time.sleep(1)
        return file_url
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg='第三方系统(阿里云oss存储)出错！')


# 编辑页文件图片删除接口
def file_delete(file_del_list, img_del_list, project_id, flag):
    if file_del_list:
        try:
            for file_id in file_del_list:
                if file_id:
                    file_obj = ProjectFile.query.filter_by(flag=flag, id=file_id, project_id=project_id, file_type=1).first()
                    db.session.delete(file_obj)
                    db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return 'error'
    if img_del_list:
        try:
            for img_id in img_del_list:
                if img_id:
                    img_obj = ProjectFile.query.filter_by(flag=flag, id=img_id, project_id=project_id, file_type=2).first()
                    db.session.delete(img_obj)
                    db.session.commit()
        except Exception as e:
            db.session.rollback()
            current_app.logger.error(e)
            return 'error'
    return 'ok'


# 记录项目动态
def write_dynamic(user_name, project_id, item, time):
    dynamic_obj = ProjectDynamicLog(operation_people=user_name,
                                     project_id=project_id,
                                     item=item,
                                     time=time,
                                     )
    db.session.add(dynamic_obj)
    db.session.commit()


# 四库搜索接口
@api_manage.route("/SearchProject", methods=["POST"])
def search_project():
    req_dic = request.get_json()
    token = request.headers['token']
    flag = req_dic['flag']  # 1为线索库，2为对接库，3为签约库，4为开工库
    # 线索库
    distribute_condition = req_dic['distribute_condition']  # 分发情况
    project_name = req_dic['project_name']  # 项目名称
    investor_name = req_dic['investor_name']  # 投资方名称
    investor_district = req_dic['investor_district']  # 投资方所在地
    project_type = req_dic['project_type']  # 项目类型
    investment_volume = req_dic['investment_volume']  # 总投资额(万元)
    project_year = req_dic['project_year']  # 项目年份
    thread_progress = req_dic['thread_progress']  # 线索进展

    # 线索库高级筛选
    distribute_condition_list = req_dic['distribute_condition_list']  # 分发情况（列表形式）
    project_type_list = req_dic['project_type_list']  # 项目类型（列表形式）
    thread_progress_list = req_dic['thread_progress_list']  # 线索进展（列表形式）
    investment_volume_list = req_dic['investment_volume_list']  # 总投资额(万元)
    project_year_list = req_dic['project_year_list']  # 项目年份

    # 对接库
    project_to_area = req_dic['project_to_area']  # 拟落地区域
    development_area = req_dic['development_area']  # 开发区
    # 对接库高级筛选
    project_to_area_list = req_dic['project_to_area_list']  # 拟落地区域（列表形式）
    development_area_list = req_dic['development_area_list']  # 开发区（列表形式）

    # 签约库
    project_to_area1 = req_dic['project_to_area1']  # 落地区域
    # 签约库高级筛选
    project_to_area1_list = req_dic['project_to_area1_list']  # 落地区域（列表形式）
    sign_year_list = req_dic['sign_year_list']  # 签约年份区间（列表形式）

    # 开工库高级筛选
    start_year_list = req_dic['start_year_list']  # 开工年份区间（列表形式）

    page = req_dic['page']
    per_page = req_dic['per_page']

    try:
        user_obj = verify_token(token)
        user_district = get_district_name(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行操作时用户信息校验失败，请重新登陆后尝试！")

    try:
        project_obj = SikuProject.query.filter(
            SikuProject.flag >= flag if flag else text(''),  # 线索库包含所有阶段的项目
            SikuProject.is_delete == 0,
            SikuProject.project_to_area == user_district if flag in [2, 3, 4] and user_district != '晋城市' else text(''),
            # SikuProject.project_to_area1 == user_district if flag in [3, 4] and user_district != '晋城市' else text(''),
            SikuProject.distribute_condition.in_(distribute_condition_list) if distribute_condition_list
            else SikuProject.distribute_condition == distribute_condition if distribute_condition else text(''),
            SikuProject.project_name.like('%{}%'.format(project_name)) if project_name else text(''),
            SikuProject.investor_name.like('%{}%'.format(investor_name)) if investor_name else text(''),
            SikuProject.investor_district.like('%{}%'.format(investor_district)) if investor_district else text(''),
            SikuProject.project_type.in_(project_type_list) if project_type_list else SikuProject.project_type.like('%{}%'.format(project_type)) if project_type else text(''),
            SikuProject.investment_volume > float(investment_volume_list[0]) if investment_volume_list else text(''),
            SikuProject.investment_volume <= float(investment_volume_list[1]) if investment_volume_list else text(''),
            SikuProject.investment_volume > float(investment_volume[0]) if investment_volume and not investment_volume_list else text(''),
            SikuProject.investment_volume <= float(investment_volume[1]) if investment_volume and not investment_volume_list else text(''),
            SikuProject.project_year >= project_year_list[0] if project_year_list else text(''),
            SikuProject.project_year <= project_year_list[1] if project_year_list else text(''),
            SikuProject.project_year == project_year if project_year and not project_year_list else text(''),
            SikuProject.thread_progress.in_(thread_progress_list) if thread_progress_list else SikuProject.thread_progress == thread_progress if thread_progress else text(''),

            # 对接库
            SikuProject.project_to_area.in_(
                project_to_area_list) if project_to_area_list else SikuProject.project_to_area == project_to_area if project_to_area else text(''),
            SikuProject.development_area.in_(
                development_area_list) if development_area_list else SikuProject.development_area == development_area if development_area else text(''),

            # 签约库
            SikuProject.project_to_area1.in_(
                project_to_area1_list) if project_to_area1_list else SikuProject.project_to_area1 == project_to_area1 if project_to_area1 else text(''),
            SikuProject.sign_year > sign_year_list[0] if sign_year_list else text(''),
            SikuProject.sign_year < sign_year_list[1] if sign_year_list else text(''),

            # 开工库高级筛选
            SikuProject.start_year > start_year_list[0] if start_year_list else text(''),
            SikuProject.start_year < start_year_list[1] if start_year_list else text(''),

        )
        if not project_obj.all():
            return jsonify(code=RET.DATAERR, msg='没有符合条件的数据！')
        project_size = project_obj.count()

        project_obj_list = project_obj.order_by(SikuProject.upload_time.desc()).paginate(page, per_page).items
        data = ''

        if flag == 1:  # 线索库
            data = [{
                'id': project_obj.id,
                "distribute_condition": project_obj.distribute_condition,  # 分发情况
                "project_name": project_obj.project_name,  # 项目名称
                "investor_name": project_obj.investor_name,  # 投资方名称
                "investor_district": project_obj.investor_district,  # 投资方所在地
                "project_type": project_obj.project_type,  # 项目类型
                "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                "project_year": project_obj.project_year,  # 项目年份
                "project_info1": project_obj.project_info1,  # 项目基本情况
                "thread_people": project_obj.thread_people,  # 线索提供人
                "thread_people_mobile": project_obj.thread_people_mobile,  # 线索提供人联系方式
                "thread_progress": project_obj.thread_progress,  # 线索进展
                "stop_reason": project_obj.stop_reason,  # 暂停终止原因
            } for project_obj in project_obj_list]

        if flag == 2:  # 对接库
            data = [{
                'id': project_obj.id,
                "project_name": project_obj.project_name,  # 项目名称
                "investor_name": project_obj.investor_name,  # 投资方名称
                "investor_district": project_obj.investor_district,  # 投资方所在地
                "project_type": project_obj.project_type,  # 项目类型
                "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                "project_year": project_obj.project_year,  # 项目年份
                "project_schedule": project_obj.project_schedule,  # 项目进展
                "project_to_area": project_obj.project_to_area,  # 拟落地区域
                "development_area": project_obj.development_area,  # 开发区
                "joint_condition": project_obj.joint_condition,  # 项目对接情况
                "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                "joint_person": project_obj.joint_person,  # 对接人
                "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                "stop_reason": project_obj.stop_reason,  # 暂停终止原因
                "thread_progress": project_obj.thread_progress,
            } for project_obj in project_obj_list]

        if flag == 3:  # 签约库
            data = [{
                'id': project_obj.id,
                "project_name": project_obj.project_name,  # 项目名称
                "investor_name": project_obj.investor_name,  # 投资方名称
                "investor_district": project_obj.investor_district,  # 投资方所在地
                "project_type": project_obj.project_type,  # 项目类型
                "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                "project_year": project_obj.project_year,  # 项目年份
                "project_schedule": project_obj.project_schedule,  # 项目进展
                "development_area": project_obj.development_area,  # 开发区
                "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                "joint_person": project_obj.joint_person,  # 对接人
                "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                "attract_name": project_obj.attract_name,  # 引资方名称
                "progress_condition": project_obj.progress_condition,  # 项目推进情况
                "sign_time": project_obj.sign_time,  # 签约时间
                "project_to_area1": project_obj.project_to_area1,  # 落地区域
                "stop_reason": project_obj.stop_reason,  # 暂停终止原因
                "thread_progress": project_obj.thread_progress,
            } for project_obj in project_obj_list]

        if flag == 4:  # 开工库
            data = [{
                'id': project_obj.id,
                "project_name": project_obj.project_name,  # 项目名称
                "investor_name": project_obj.investor_name,  # 投资方名称
                "investor_district": project_obj.investor_district,  # 投资方所在地
                "project_type": project_obj.project_type,  # 项目类型
                "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                "project_year": project_obj.project_year,  # 项目年份
                "project_schedule": project_obj.project_schedule,  # 项目进展
                "development_area": project_obj.development_area,  # 开发区
                "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                "joint_person": project_obj.joint_person,  # 对接人
                "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                "attract_name": project_obj.attract_name,  # 引资方名称
                "progress_condition": project_obj.progress_condition,  # 项目推进情况
                "sign_year": project_obj.sign_year,  # 签约年份
                "project_to_area1": project_obj.project_to_area1,  # 落地区域
                "start_time": project_obj.start_time,  # 开工时间
                "thread_progress": project_obj.thread_progress,
            } for project_obj in project_obj_list]
        return jsonify(code=RET.OK, data={"data": data, "size": project_size, "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 新增线索
@api_manage.route("/AddProject", methods=["POST"])
def add_project():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        upload_people = user_obj.real_name
        user_id = user_obj.id
        upload_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行批量导入操作时用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    project_name = req_dic['project_name']
    investor_name = req_dic['investor_name']
    investor_district = req_dic['investor_district']
    if '/' in investor_district:
        investor_district1 = investor_district.split('/')[0]
        investor_district2 = investor_district.split('/')[1]
    else:
        investor_district1 = investor_district
        investor_district2 = ''
    project_type = req_dic['project_type']
    if '/' in project_type:
        project_type1 = project_type.split('/')[0]
        project_type2 = project_type.split('/')[1]
    else:
        project_type1 = project_type
        project_type2 = ''
    investment_volume = req_dic['investment_volume']
    project_info = req_dic['project_info']
    thread_people = req_dic['thread_people']
    thread_people_unity = req_dic['thread_people_unity']
    thread_people_mobile = req_dic['thread_people_mobile']
    thread_progress = req_dic['thread_progress']
    investment_volume1 = req_dic['investment_volume1']
    project_info1 = req_dic['project_info1']
    stop_reason = req_dic['stop_reason']
    thread_source = req_dic['thread_source']
    cooperation_way = req_dic['cooperation_way']
    other_source = req_dic['other_source']
    remark = req_dic['remark']
    if not all([project_name, investor_district, project_type]):
        return jsonify(code=RET.NODATA, msg='项目名称，投资方所在地，项目类型不可为空！')

    upload_time = datetime.now().strftime("%Y/%m/%d")
    time_strf = datetime.now().strftime("%Y%m%d")

    # 项目编号
    project_obj_list = SikuProject.query.all()
    project_num_list = ''
    if project_obj_list:
        project_num_list = [project_obj.project_num for project_obj in
                            project_obj_list if (project_obj.project_num).startswith(time_strf)]
    if project_num_list:
        max_project_num = max(project_num_list)[8:]
        num = get_num(max_project_num)
        if num == 'error':
            return 'error'
        project_num = time_strf + num
    else:
        project_num = time_strf + '001'

    # 创建项目
    try:
        new_project_obj = SikuProject(
            upload_unity=upload_unity,
            upload_people=upload_people,
            upload_time=upload_time,
            project_year=upload_time.split('/')[0],
            project_num=int(project_num),
            provence=investor_district1,
            city=investor_district2,
            industry=project_type1,
            industry2=project_type2,
            project_name=project_name,
            investor_name=investor_name,
            investor_district=investor_district,
            project_type=project_type,
            investment_volume=investment_volume,
            project_info=project_info,
            thread_people=thread_people,
            thread_people_unity=thread_people_unity,
            thread_people_mobile=thread_people_mobile,
            thread_progress=thread_progress,
            investment_volume1=investment_volume1,
            project_info1=project_info1,
            stop_reason=stop_reason,
            thread_source=thread_source,
            cooperation_way=cooperation_way,
            other_source=other_source,
            remark=remark,
            is_delete=0,
            flag=1
        )
        db.session.add(new_project_obj)
        db.session.commit()

        # 记录项目动态
        project_id = new_project_obj.id
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(upload_people, project_id, '新增了 {} 项目。'.format(project_name), time1)

        return jsonify(code=RET.OK, msg='新增成功！')
    except Exception as e:
        return jsonify(code=RET.DATAERR, msg='新增失败！')


# 批量删除
@api_manage.route("/BatchDelete", methods=["POST"])
def batch_del():
    req_dic = request.get_json()
    token = request.headers['token']

    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行批量导入操作时用户信息校验失败，请重新登陆后尝试！")

    select_id_list = req_dic["select_id_list"]
    try:
        for select_id in select_id_list:
            project_obj = SikuProject.query.get(select_id)
            project_name = project_obj.project_name
            if not project_obj:
                return jsonify(code=RET.NODATA, msg="查无此项目！")
            project_obj.is_delete = 1
            db.session.commit()

            # 记录项目动态
            for project_id in select_id_list:
                time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                write_dynamic(user_name, project_id, '删除了 {} 项目。'.format(project_name), time1)
            continue

        return jsonify(code=RET.OK, msg="批量删除成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DATAERR, msg="批量删除出错！")


# 线索库批量导入
@api_manage.route("/UploadProjectData", methods=["POST"])
def upload_project_data1():
    token = request.headers['token']
    data_type = request.form['data_type']  # 1为线索库，2为对接库，3为签约库，4为开工库
    try:
        user_obj = verify_token(token)
        upload_people = user_obj.real_name
        user_id = user_obj.id
        upload_unity = user_obj.belong_organization
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="进行批量导入操作时用户信息校验失败，请重新登陆后尝试！")

    # 上传的文件
    file = request.files['file']
    file_name = file.filename
    if file_name[0:3] not in ['线索库', '对接库', '签约库', '开工库']:
        return jsonify(code=RET.DBERR, msg="请使用指定文件格式上传！")

    upload_time = datetime.now().strftime("%Y/%m/%d")
    time_strf = datetime.now().strftime("%Y%m%d")

    try:
        f = file.read()  # 文件内容
        data = xlrd.open_workbook(file_contents=f)
        table = data.sheets()[0]
        names = data.sheet_names()  # 返回book中所有工作表的名字
        status = data.sheet_loaded(names[0])  # 检查sheet1是否导入完毕
        # print(status)
        nrows = table.nrows  # 获取该sheet中的有效行数
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.THIRDERR, msg="读取文件失败！")

    update_num = 0
    old_num = 0
    add_num = 0
    rep_project_li = []
    rep_project_num = 0
    if int(data_type) == 1:  # 上传线索库
        row_list = [table.row_values(i) for i in range(4, nrows)]
        rows = len(row_list)
        total_num = rows
        for i in range(0, rows):
            row_content = row_list[i]
            if not row_content:
                return jsonify(code=RET.NODATA,
                               msg="表格内无有效数据！")

            ret = upload_xiansuo_project(row_content, time_strf, upload_time, upload_unity, upload_people)
            if ret == 'continue':
                add_num += 1
                continue
            elif ret == 'error':
                return jsonify(code=RET.DATAERR, msg='编号超出三位的规定范围，请联系管理员！')
            elif ret == 'error1':
                return jsonify(code=RET.DATAERR, msg='数据入库出错，错误位置为第【{}】行！'.format(i + 1))
            elif ret == 'error2':
                return jsonify(code=RET.DATAERR, msg='数据入库出错，错误位置为第【{}】行！请按照表格要求填写直辖市和行政区。'.format(i + 1))
            else:
                pass
    if int(data_type) == 2:  # 更新对接库
        row_list = [table.row_values(i) for i in range(1, nrows)]
        rows = len(row_list)
        total_num = rows
        for i in range(0, rows):
            row_content = row_list[i]
            if not row_content:
                return jsonify(code=RET.NODATA,
                               msg="表格内无有效数据！")

            ret = update_joint_project(upload_people, row_content)
            if ret == 'continue':
                update_num += 1
                continue
            elif ret == 'error1':
                return jsonify(code=RET.DATAERR, msg='数据更新出错，错误位置为第【{}】行！'.format(i + 1))
            elif ret == 'error2':
                return jsonify(code=RET.DATAERR, msg='数据入库出错，错误位置为第【{}】行！请按照表格要求填写直辖市和行政区。'.format(i + 1))
            elif ret == 'error3':
                return jsonify(code=RET.DATAERR, msg='项目编号不能为空！')
            else:
                pass
    if int(data_type) == 3:  # 更新签约库
        row_list = [table.row_values(i) for i in range(1, nrows)]
        rows = len(row_list)
        total_num = rows
        for i in range(0, rows):
            row_content = row_list[i]
            if not row_content:
                return jsonify(code=RET.NODATA,
                               msg="表格内无有效数据！")

            ret = update_sign_project(upload_people, row_content)
            if ret == 'continue':
                update_num += 1
                continue
            elif ret == 'error1':
                return jsonify(code=RET.DATAERR, msg='数据更新出错，错误位置为第【{}】行！'.format(i + 1))
            elif ret == 'error2':
                return jsonify(code=RET.DATAERR, msg='数据入库出错，错误位置为第【{}】行！请按照表格要求填写直辖市和行政区。'.format(i + 1))
            elif ret == 'error3':
                return jsonify(code=RET.DATAERR, msg='项目编号不能为空！')
            else:
                pass
    if int(data_type) == 4:  # 更新开工库
        row_list = [table.row_values(i) for i in range(1, nrows)]
        rows = len(row_list)
        total_num = rows
        for i in range(0, rows):
            row_content = row_list[i]
            if not row_content:
                return jsonify(code=RET.NODATA,
                               msg="表格内无有效数据！")

            ret = update_start_project(upload_people, row_content)
            if ret == 'continue':
                update_num += 1
                continue
            elif ret == 'error1':
                return jsonify(code=RET.DATAERR, msg='数据更新出错，错误位置为第【{}】行！'.format(i + 1))
            elif ret == 'error2':
                return jsonify(code=RET.DATAERR, msg='数据入库出错，错误位置为第【{}】行！请按照表格要求填写直辖市和行政区。'.format(i + 1))
            elif ret == 'error3':
                return jsonify(code=RET.DATAERR, msg='项目编号不能为空！')
            else:
                pass
    if int(data_type) == 1 and rep_project_li:
        return jsonify(code=RET.OK,
                       list=rep_project_li,
                       msg='本次导入项目信息共{}个，新增项目信息{}个，其中包含重复名称项目{}个，'
                            '请在以下重复名称项目列表选择相应操作项并提交！'.format(total_num, add_num, rep_project_num))
    elif int(data_type) == 1:
        return jsonify(code=RET.OK,
                       list=rep_project_li,
                       msg='成功新增项目共{}个。'.format(add_num))
    else:
        return jsonify(code=RET.OK,
                       msg='成功更新项目共{}个。'.format(update_num))


# 下载模板
@api_manage.route("/DownloadTemplate", methods=["GET"])
def download_xlsx():
    # req_dic = request.get_json()
    # token = request.headers['token']
    # action_name = '下载模板'
    # try:
    #     section, user_name, operation_mobile, user_id, role_id, belong_unit = verify_identity(token, action_name)
    # except Exception as e:
    #     current_app.logger.error(e)
    #     return jsonify(code=RET.DBERR, msg="进行{}操作时用户信息校验失败，请重新登陆后尝试！".format(action_name))
    build_template = "http://39.100.39.50:8008/aaa_statics/template_file/线索库上传模板.xlsx"
    return jsonify(code=RET.OK, data=build_template, msg="链接获取成功！")


# 分发功能
@api_manage.route("/DistributeProject", methods=["POST"])
def distribute_project():
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    district_list = req_dic['district_list']
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    district_list1 = []  # 成功被分发到的区县
    try:
        for district in district_list:
            old_project_obj = SikuProject.query.get(project_id)
            if not old_project_obj:
                return jsonify(code=RET.NODATA, msg="查无此项目！")
            old_distribute_condition = old_project_obj.distribute_condition
            if old_distribute_condition and old_distribute_condition == district:
                continue

            if not old_distribute_condition:
                old_project_obj.distribute_condition = district
                old_project_obj.thread_progress = '对接中'
                old_project_obj.flag = 2
                old_project_obj.project_to_area = district
                write_dynamic(user_name, old_project_obj.id, '分发至 {} 对接库'.format(district), time1)

                db.session.commit()
                district_list1.append(district)
                continue

            # 构造项目编号
            time_strf = datetime.now().strftime("%Y%m%d")
            project_obj_list = SikuProject.query.all()
            flag = False
            for project_obj in project_obj_list:
                if project_obj.project_name == old_project_obj.project_name and \
                   project_obj.distribute_condition == district:
                    flag = True
                    break
            if flag:
                continue
            max_project_num = ''
            if project_obj_list:
                max_project_num = max([project_obj.project_num for project_obj in project_obj_list])
            if max_project_num:
                max_project_num = max_project_num[8:]
                num = get_num(max_project_num)
                if num == 'error':
                    return jsonify(code=RET.DATAERR, msg='编号超出三位的规定范围，请联系管理员')
                    # return 'error'
                project_num = time_strf + num
            else:
                project_num = time_strf + '001'
            new_project = SikuProject(
                thread_progress='对接中',
                is_delete=0,
                flag=2,
                distribute_condition=district,
                project_to_area=district,
                project_name=old_project_obj.project_name,
                investor_name=old_project_obj.investor_name,
                investor_district=old_project_obj.investor_district,
                project_type=old_project_obj.project_type,
                provence=old_project_obj.provence,
                city=old_project_obj.city,
                industry=old_project_obj.industry,
                industry2=old_project_obj.industry2,
                investment_volume=old_project_obj.investment_volume,
                project_year=old_project_obj.project_year,
                project_info=old_project_obj.project_info,
                thread_people=old_project_obj.thread_people,
                thread_people_unity=old_project_obj.thread_people_unity,
                thread_people_mobile=old_project_obj.thread_people_mobile,
                # thread_progress=old_project_obj.thread_progress,
                upload_unity=old_project_obj.upload_unity,
                upload_people=old_project_obj.upload_people,
                upload_time=old_project_obj.upload_time,
                project_num=project_num,
                investment_volume1=old_project_obj.investment_volume1,
                project_info1=old_project_obj.project_info1,
                project_schedule=old_project_obj.project_schedule,
                stop_reason=old_project_obj.stop_reason,
                thread_source=old_project_obj.thread_source,
                cooperation_way=old_project_obj.cooperation_way,
                other_source=old_project_obj.other_source,
                remark=old_project_obj.remark,
            )
            db.session.add(new_project)
            db.session.commit()
            write_dynamic(user_name, new_project.id, '分发至 {} 对接库'.format(district), time1)
            district_list1.append(district)

        if district_list1:
            # 记录项目动态
            # time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            # write_dynamic(user_name, project_id, '分发至 {} 对接库'.format(district_list1), time1)

            return jsonify(code=RET.OK, msg="该项目已分发至 {} 对接库。".format(district_list1))
        else:
            return jsonify(code=RET.DATAEXIST, msg="已分发至{}，不可重复分发！".format(district_list1))

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="分发操作出错！")


# 获取项目详情
@api_manage.route("/GetProjectDetail", methods=["POST"])
def get_project_detail():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    req_dic = request.get_json()
    project_id = req_dic['project_id']

    try:
        project_obj = SikuProject.query.get(project_id)
        if not project_obj:
            return jsonify(code=RET.NODATA, msg="查无此项目！")

        data = {
            "project_name": project_obj.project_name,
            "investor_name": project_obj.investor_name,
            "investor_district": project_obj.investor_district,
            "project_type": project_obj.project_type,
            "investment_volume": project_obj.investment_volume,
            "project_info": project_obj.project_info,
            "thread_people": project_obj.thread_people,
            "thread_people_unity": project_obj.thread_people_unity,
            "thread_people_mobile": project_obj.thread_people_mobile,
            "thread_progress": project_obj.thread_progress,
            "upload_unity": project_obj.upload_unity,
            "upload_people": project_obj.upload_people,
            "upload_time": project_obj.upload_time.strftime("%Y/%m/%d"),
            "project_num": project_obj.project_num,
            "investment_volume1": project_obj.investment_volume1,
            "project_info1": project_obj.project_info1,
            "stop_reason": project_obj.stop_reason,
            "thread_source": project_obj.thread_source,
            "cooperation_way": project_obj.cooperation_way,
            "other_source": project_obj.other_source,
            "remark": project_obj.remark,
        }
        return jsonify(code=RET.OK, data=data, msg="项目详情获取成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="数据查询失败！")


# 编辑项目详情
@api_manage.route("/EditProjectDetail", methods=["POST"])
def edit_project_detail():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    investor_district = req_dic['investor_district']
    if '/' in investor_district:
        investor_district1 = investor_district.split('/')[0]
        investor_district2 = investor_district.split('/')[1]
    else:
        investor_district1 = investor_district
        investor_district2 = ''
    project_type = req_dic['project_type']
    if '/' in project_type:
        project_type1 = project_type.split('/')[0]
        project_type2 = project_type.split('/')[1]
    else:
        project_type1 = project_type
        project_type2 = ''
    try:
        project_obj = SikuProject.query.get(project_id)
        if not project_obj:
            return jsonify(code=RET.NODATA, msg="查无此项目！")
        project_obj.project_name = req_dic['project_name']
        project_obj.investor_name = req_dic['investor_name']
        project_obj.investor_district = req_dic['investor_district']
        project_obj.project_type = req_dic['project_type']
        project_obj.provence = investor_district1
        project_obj.city = investor_district2
        project_obj.industry = project_type1
        project_obj.industry2 = project_type2
        project_obj.investment_volume = req_dic['investment_volume']
        project_obj.project_info = req_dic['project_info']
        project_obj.thread_people = req_dic['thread_people']
        project_obj.thread_people_unity = req_dic['thread_people_unity']
        project_obj.thread_people_mobile = req_dic['thread_people_mobile']
        project_obj.thread_progress = req_dic['thread_progress']
        project_obj.investment_volume1 = req_dic['investment_volume1']
        project_obj.project_info1 = req_dic['project_info1']
        project_obj.stop_reason = req_dic['stop_reason']
        project_obj.thread_source = req_dic['thread_source']
        project_obj.cooperation_way = req_dic['cooperation_way']
        project_obj.other_source = req_dic['other_source']
        project_obj.remark = req_dic['remark']
        db.session.commit()
        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '编辑了项目', time1)

        return jsonify(code=RET.OK, msg="编辑成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="编辑操作出错！")


# 转办功能(转办个其他区县，改变拟落地区域字段内容)
@api_manage.route("/ProjectTransition", methods=["POST"])
def project_transition():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    flag = req_dic['flag']  # 当前位置：2为对接库，3为签约库
    district = req_dic['district']

    try:
        project_obj = SikuProject.query.filter_by(id=project_id, flag=flag).first()
        if not project_obj:
            return jsonify(code=RET.NODATA, msg="查无此项目！")

        if flag == 2:
            # 对接库  转办：把选定的项目转给其它县区，此项目的拟落地区域，变为新的县区
            project_obj.project_to_area = district
            db.session.commit()
        if flag == 3:
            # 签约库  转办：把选定的项目转给其它县区，
            # 此项目从签约库消除，由其它县区在对接库重新对接，此项目的拟落地区域，变为新的县区
            project_obj.project_to_area = district
            project_obj.flag = 2
            db.session.commit()
        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '将项目转办至{}。'.format(district), time1)
        return jsonify(code=RET.OK, msg="转办成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="转办操作出错！")


# 流转功能
@api_manage.route("/ProjectMove", methods=["POST"])
def project_move():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    try:
        req_dic = request.get_json()
        project_id = req_dic['project_id']
        flag = req_dic['flag']  # 流转到：3为签约库, 4为开工库
        project_obj = SikuProject.query.get(project_id)
        if not project_obj:
            return jsonify(code=RET.NODATA, msg="查无此项目！")
        if project_obj.flag == flag:
            return jsonify(code=RET.PARAMERR, msg="参数错误！")

        project_obj.flag = flag
        if flag == 3:
            project_obj.thread_progress = '已签约'
        if flag == 4:
            project_obj.thread_progress = '已开工'
        db.session.commit()
        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '将项目流转至 {} 。'.format('签约库' if flag == 3 else '开工库' if flag == 4 else ''), time1)

        return jsonify(code=RET.OK, msg="流转成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="流转操作出错！")


# 新增项目对接/推进情况(进展)
@api_manage.route("/AddProgress", methods=["POST"])
def add_progress():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    add_time = datetime.now()
    try:
        req_dic = request.get_json()
        project_id = req_dic['project_id']
        info = req_dic['info']
        flag = req_dic['flag']  # 2为对接库，3为签约库，4为开工库
        progress_obj = ProgressCondition(
            flag=flag,
            add_time=add_time,
            info=info,
            project_id=project_id
        )
        db.session.add(progress_obj)
        db.session.commit()

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '新增了进展情况。', time1)

        return jsonify(code=RET.OK, msg="进展情况新增成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="进展情况新增失败！")


# 编辑项目对接/推进情况(进展)
@api_manage.route("/EditProgress", methods=["POST"])  # 对接库-编辑项目对接情况(进展)
def edit_progress():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")

    try:
        req_dic = request.get_json()
        progress_id = req_dic['progress_id']
        info = req_dic['info']
        if not info:
            return jsonify(code=RET.NODATA, msg="无变更内容！")

        progress_obj = ProgressCondition.query.get(progress_id)
        project_id = progress_obj.project_id
        progress_obj.info = info
        db.session.commit()

        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '编辑了进展情况。', time1)

        return jsonify(code=RET.OK, msg="进展情况编辑成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="进展情况编辑失败！")


# 获取项目详情信息(对接库、签约库、开工库)
@api_manage.route("/CheckProjectDetail", methods=["POST"])
def check_project_detail():
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")


    try:
        project_obj = SikuProject.query.get(project_id)
        flag = project_obj.flag
        if flag == 2:
            project_data = {"id": project_obj.id,
                            "project_name": project_obj.project_name,  # 项目名称
                            "investor_name": project_obj.investor_name,  # 投资方名称
                            "investor_district": project_obj.investor_district,  # 投资方所在地
                            "project_type": project_obj.project_type,  # 项目类型
                            "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                            "project_num": project_obj.project_num,  # 项目编号
                            "investment_volume1": project_obj.investment_volume1,  # 拟引资额(万元)
                            "project_schedule": project_obj.thread_progress,  # 项目进展
                            "stop_reason": project_obj.stop_reason,  # 暂停或终止原因
                            "remark": project_obj.remark,  # 备注
                            "project_to_area": project_obj.project_to_area,  # 拟落地区域
                            "development_area": project_obj.development_area,  # 开发区
                            "garden": project_obj.garden,  # 园区
                            "project_address": project_obj.project_address,  # 项目详细地址
                            # "joint_condition": project_obj.joint_condition,  # 项目对接情况
                            "project_problem": project_obj.project_problem,  # 项目当前存在的问题
                            "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                            "joint_person": project_obj.joint_person,  # 对接人
                            "joint_person_unity": project_obj.joint_person_unity,  # 对接人单位及职务
                            "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                            "project_people": project_obj.project_people,  # 项目方联系人
                            "project_people_unity": project_obj.project_people_unity,  # 项目方单位或职务
                            "project_people_mobile": project_obj.project_people_mobile,  # 项目方联系方式
                            }
        if flag == 3:
            project_data = {"id": project_obj.id,
                            "project_name": project_obj.project_name,  # 项目名称
                            "investor_name": project_obj.investor_name,  # 投资方名称
                            "investor_district": project_obj.investor_district,  # 投资方所在地
                            "project_type": project_obj.project_type,  # 项目类型
                            "investment_volume": project_obj.investment_volume,  # 总投资额(万元总投资额(万元)
                            "project_num": project_obj.project_num,  # 项目编号
                            "investment_volume1": project_obj.investment_volume1,  # 拟引资额(万元拟引资额(万元)
                            "project_schedule": project_obj.thread_progress,  # 项目进展
                            "stop_reason": project_obj.stop_reason,  # 暂停或终止原因
                            "remark": project_obj.remark,  # 备注
                            "development_area": project_obj.development_area,  # 开发区
                            "garden": project_obj.garden,  # 园区
                            "project_address": project_obj.project_address,  # 项目详细地址
                            # "joint_condition": project_obj.joint_condition,  # 项目对接情况
                            "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                            "joint_person": project_obj.joint_person,  # 对接人
                            "joint_person_unity": project_obj.joint_person_unity,  # 对接人单位及职务
                            "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                            "project_people": project_obj.project_people,  # 项目方联系人
                            "project_people_unity": project_obj.project_people_unity,  # 项目方单位或职务
                            "project_people_mobile": project_obj.project_people_mobile,  # 项目方联系方式
                            "attract_name": project_obj.attract_name,  # 引资方名称
                            "Party_A_name": project_obj.Party_A_name,  # 签约甲方名称
                            "Party_A_people": project_obj.Party_A_people,  # 签约甲方联系人
                            "Party_A_mobile": project_obj.Party_A_mobile,  # 签约甲方联系方式
                            "Party_B_name": project_obj.Party_B_name,  # 签约乙方名称
                            "Party_B_people": project_obj.Party_B_people,  # 签约乙方联系人
                            "Party_B_mobile": project_obj.Party_B_mobile,  # 签约乙方联系方式
                            "sign_time": project_obj.sign_time.strftime("%Y-%m-%d") if project_obj.sign_time else '',  # 签约时间
                            "project_to_area1": project_obj.project_to_area,  # 落地区域
                            "sign_style": project_obj.sign_style,  # 签约方式
                            "sign_explain": project_obj.sign_explain,  # 其他签约说明
                            }
        if flag == 4:
            project_data = {"id": project_obj.id,
                            "project_name": project_obj.project_name,  # 项目名称
                            "investor_name": project_obj.investor_name,  # 投资方名称
                            "investor_district": project_obj.investor_district,  # 投资方所在地
                            "project_type": project_obj.project_type,  # 项目类型
                            "investment_volume": project_obj.investment_volume,  # 总投资额(万元)
                            "project_num": project_obj.project_num,  # 项目编号
                            "investment_volume1": project_obj.investment_volume1,  # 拟引资额(万元)
                            "project_schedule": project_obj.thread_progress,  # 项目进展
                            "development_area": project_obj.development_area,  # 开发区
                            "garden": project_obj.garden,  # 园区
                            "project_address": project_obj.project_address,  # 项目详细地址
                            "project_problem": project_obj.project_problem,  # 项目当前存在的问题
                            "project_stalker": project_obj.project_stalker,  # 项目跟踪人
                            "joint_person": project_obj.joint_person,  # 对接人
                            "joint_person_unity": project_obj.joint_person_unity,  # 对接人单位及职务
                            "joint_person_mobile": project_obj.joint_person_mobile,  # 对接人联系方式
                            "project_people": project_obj.project_people,  # 项目方联系人
                            "project_people_unity": project_obj.project_people_unity,  # 项目方单位或职务
                            "project_people_mobile": project_obj.project_people_mobile,  # 项目方联系方式
                            "attract_name": project_obj.attract_name,  # 引资方名称
                            "progress_condition": project_obj.progress_condition,  # 项目推进情况
                            "sign_time": project_obj.sign_time.strftime("%Y-%m-%d") if project_obj.sign_time else '',  # 签约时间
                            "investment": project_obj.investment,  # 到位资金
                            "project_to_area1": project_obj.project_to_area,  # 落地区域
                            "start_time": project_obj.start_time.strftime("%Y-%m-%d") if project_obj.start_time else '',  # 开工时间
                            "remark": project_obj.remark,  # 备注
                            }
        # 项目进展
        progress_obj_list = project_obj.progress_conditions
        progress_data = []
        if progress_obj_list:
            progress_data = [{
                "id": progress_obj.id,
                "time": progress_obj.add_time.strftime("%Y-%m-%d %H:%M:%S"),
                "info": progress_obj.info
            } for progress_obj in progress_obj_list]

            progress_data = sorted(progress_data, key=lambda x: x['time'], reverse=True)

        file_obj_list = project_obj.project_files
        file_data = []
        three_data = []
        if flag == 3:
            # 文件
            if file_obj_list:
                file_data = [{
                    "id": file_obj.id,
                    "file_url": file_obj.file_url,
                    "name": file_obj.file_name,
                    "project_id": file_obj.project_id,
                    "file_type": file_obj.file_type
                } for file_obj in file_obj_list if file_obj.file_type == 1 and file_obj.flag == flag]
            # 第三方联系人
            three_list = project_obj.sign_threes
            three_data = [{
                "id": three_obj.id,
                "name": three_obj.name,
                "people": three_obj.people,
                "mobile": three_obj.mobile,
            } for three_obj in three_list]

        # 图片
        img_data = []
        if file_obj_list:
            img_data = [{
                "id": img_obj.id,
                "file_url": img_obj.file_url,
                "name": img_obj.file_name,
                "project_id": img_obj.project_id,
                "file_type": img_obj.file_type
            } for img_obj in file_obj_list if img_obj.file_type == 2 and img_obj.flag == flag]
        return jsonify(code=RET.OK, data={"project_data": project_data,
                                          "three_data": three_data,
                                          "file_data": file_data,
                                          "img_data": img_data,
                                          "progress_data": progress_data,
                                          "msg": "数据获取成功！"})
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="操作失败！数据库查询错误")


# 新增第三方
@api_manage.route("/AddThree", methods=["POST"])
def add_three():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_id = user_obj.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    name = req_dic['name']
    people = req_dic['people']
    mobile = req_dic['mobile']
    project_id = req_dic['project_id']
    try:
        three_obj = SignThree(
            name=name,
            people=people,
            mobile=mobile,
            project_id=project_id
        )
        db.session.add(three_obj)
        db.session.commit()
        return jsonify(code=RET.OK, msg="第三方保存成功")

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="第三方保存出错，编辑失败！")


# 编辑第三方
@api_manage.route("/EditThree", methods=["POST"])
def edit_three():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()

    req_dic = request.get_json()
    three_id = req_dic['three_id']
    name = req_dic['name']
    people = req_dic['people']
    mobile = req_dic['mobile']
    try:
        three_obj = SignThree.query.get(three_id)
        three_obj.name = name
        three_obj.people = people
        three_obj.mobile = mobile
        db.session.commit()
        return jsonify(code=RET.OK, msg="第三方编辑成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="第三方编辑出错，编辑失败！")


# 删除第三方
@api_manage.route("/DeleteThree", methods=["POST"])
def delete_three():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_id = user_obj.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    req_dic = request.get_json()
    three_id = req_dic['three_id']
    try:
        three_obj = SignThree.query.get(three_id)
        db.session.delete(three_obj)
        db.session.commit()
        return jsonify(code=RET.OK, msg="第三方删除成功")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="第三方删除出错！")


# 编辑对接库、签约库、开工库
@api_manage.route("/EditProject", methods=["POST"])
def edit_project():
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
        user_id = user_obj.id
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    # 三库共有的
    project_id = request.form['project_id']
    # flag = request.form['flag']  # 2为对接库，3为签约库，4为开工库

    img_list = request.files.getlist('img_list')
    file_list = request.files.getlist('file_list')
    file_del_list = request.form.getlist('file_del_list')
    img_del_list = request.form.getlist('img_del_list')
    project_name = request.form["project_name"]
    investor_name = request.form["investor_name"]
    investor_district = request.form["investor_district"]
    project_type = request.form["project_type"]
    if '/' in investor_district:
        investor_district1 = investor_district.split('/')[0]
        investor_district2 = investor_district.split('/')[1]
    else:
        investor_district1 = investor_district
        investor_district2 = ''
    if '/' in project_type:
        project_type1 = project_type.split('/')[0]
        project_type2 = project_type.split('/')[1]
    else:
        project_type1 = project_type
        project_type2 = ''
    investment_volume = request.form["investment_volume"]
    investment_volume1 = request.form["investment_volume1"]
    project_schedule = request.form["project_schedule"]
    stop_reason = request.form["stop_reason"]
    remark = request.form["remark"]
    development_area = request.form["development_area"]
    garden = request.form["garden"]
    project_address = request.form["project_address"]
    project_problem = request.form["project_problem"]
    project_stalker = request.form["project_stalker"]
    joint_person = request.form["joint_person"]
    joint_person_unity = request.form["joint_person_unity"]
    joint_person_mobile = request.form["joint_person_mobile"]
    project_people = request.form["project_people"]
    project_people_unity = request.form["project_people_unity"]
    project_people_mobile = request.form["project_people_mobile"]
    # 个别的
    project_to_area = request.form["project_to_area"]
    attract_name = request.form["attract_name"]
    investment = request.form["investment"]
    project_to_area1 = request.form["project_to_area1"]
    sign_time = request.form["sign_time"]
    start_time = request.form["start_time"]
    Party_A_name = request.form["Party_A_name"]
    Party_A_people = request.form["Party_A_people"]
    Party_A_mobile = request.form["Party_A_mobile"]
    Party_B_name = request.form["Party_B_name"]
    Party_B_people = request.form["Party_B_people"]
    Party_B_mobile = request.form["Party_B_mobile"]
    sign_style = request.form["sign_style"]
    sign_explain = request.form["sign_explain"]

    try:
        project_obj = SikuProject.query.get(project_id)
        flag = project_obj.flag
        project_obj.project_name = project_name
        project_obj.investor_name = investor_name
        project_obj.investor_district = investor_district
        project_obj.project_type = project_type
        project_obj.provence = investor_district1
        project_obj.city = investor_district2
        project_obj.industry = project_type1
        project_obj.industry2 = project_type2
        project_obj.investment_volume = investment_volume
        project_obj.investment_volume1 = investment_volume1
        project_obj.project_schedule = project_schedule
        project_obj.stop_reason = stop_reason
        project_obj.remark = remark
        project_obj.development_area = development_area
        project_obj.garden = garden
        project_obj.project_address = project_address
        project_obj.project_problem = project_problem
        project_obj.project_stalker = project_stalker
        project_obj.joint_person = joint_person
        project_obj.joint_person_unity = joint_person_unity
        project_obj.joint_person_mobile = joint_person_mobile
        project_obj.project_people = project_people
        project_obj.project_people_unity = project_people_unity
        project_obj.project_people_mobile = project_people_mobile
        if project_to_area and flag == 2:
            project_obj.project_to_area = project_to_area
        if attract_name and flag in [3, 4]:
            project_obj.attract_name = attract_name
        if investment and flag == 4:
            project_obj.investment = investment
        if project_to_area1 and flag in [3, 4]:
            project_obj.project_to_area = project_to_area1
        if sign_time and flag in [3, 4]:
            project_obj.sign_time = sign_time
        if start_time and flag in [3, 4]:
            project_obj.start_time = start_time
        if Party_A_name and flag == 3:
            project_obj.Party_A_name = Party_A_name
        if Party_A_people and flag == 3:
            project_obj.Party_A_people = Party_A_people
        if Party_A_mobile and flag == 3:
            project_obj.Party_A_mobile = Party_A_mobile
        if Party_B_name and flag == 3:
            project_obj.Party_B_name = Party_B_name
        if Party_B_people and flag == 3:
            project_obj.Party_B_people = Party_B_people
        if Party_B_mobile and flag == 3:
            project_obj.Party_B_mobile = Party_B_mobile
        if sign_style and flag == 3:
            project_obj.sign_style = sign_style
        if sign_explain and flag == 3:
            project_obj.sign_explain = sign_explain

        # 删除文件和图片
        if file_del_list or img_del_list:
            result = file_delete(file_del_list, img_del_list, project_id, flag)
            if result == 'error':
                return jsonify(code=RET.DBERR, msg="附件删除异常，编辑失败！")

        edit_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        # flag1 = 0
        # flag2 = 0
        try:
            # 上传文件
            if file_list:
                for file_obj in file_list:
                    file_name = file_obj.filename
                    file_url = upload_daily_picture(1, file_name, file_obj)

                    # 存入数据库
                    file_obj = ProjectFile(project_id=project_id,
                                           flag=flag,
                                           file_type=1,
                                           file_name=file_name,
                                           file_url=file_url,
                                           upload_time=edit_time,
                                           upload_people=user_name,
                                           upload_people_id=user_id
                                           )
                    db.session.add(file_obj)
                    db.session.commit()
                    flag1 = 1
            # 上传图片
            if img_list:
                for img_obj in img_list:
                    img_name = img_obj.filename
                    img_url = upload_daily_picture(2, img_name, img_obj)

                    # 存入数据库
                    img_obj = ProjectFile(project_id=project_id,
                                          flag=flag,
                                          file_type=2,
                                          file_name=img_name,
                                          file_url=img_url,
                                          upload_time=edit_time,
                                          upload_people=user_name,
                                          upload_people_id=user_id
                                          )
                    db.session.add(img_obj)
                    db.session.commit()
                    flag2 = 1
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="文件/图片上传出错，编辑失败！")
        db.session.commit()
        # 记录项目动态
        time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        write_dynamic(user_name, project_id, '编辑了项目详情信息。', time1)

        return jsonify(code=RET.OK, msg="编辑成功！")

    except Exception as e:
        db.session.rollback()
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="查询数据库错误！")


# 批量导出-线索库数据
@api_manage.route("/BatchExportProject1", methods=["POST"])
def batch_export_project1():
    req_dic = request.get_json()
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    select_id_list = req_dic["select_id_list"]
    path = './apps/static/project_file/'
    # pro_path = 'D:/中研项目代码/flask_jincheng/apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:5050/static/project_file/'  # 项目路径
    if not select_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    for select_id in select_id_list:
        try:
            project_obj = SikuProject.query.filter_by(id=select_id).first()
            # 提取数据，写入xslx表格
            data_list = []
            project_num = project_obj.project_num  # 项目编号
            data_list.append(project_num)
            project_name = project_obj.project_name  # 项目名称
            data_list.append(project_name)
            investor_name = project_obj.investor_name  # 投资方名称
            data_list.append(investor_name)
            investor_district_provence = project_obj.provence  # 投资方所在地，省
            data_list.append(investor_district_provence)
            investor_district_city = project_obj.city  # 投资方所在地，市
            data_list.append(investor_district_city)
            industry = project_obj.industry  # 一级行业
            data_list.append(industry)
            industry2 = project_obj.industry2  # 二级行业
            data_list.append(industry2)
            investment_volume = project_obj.investment_volume  # 总投资额(万元)
            data_list.append(investment_volume)
            investment_volume1 = project_obj.investment_volume1  # ni投资额(万元)
            data_list.append(investment_volume1)

            project_info = project_obj.project_info  # 项目基本情况
            data_list.append(project_info)
            project_info1 = project_obj.project_info1  # 项目方基本情况
            data_list.append(project_info1)
            thread_people = project_obj.thread_people  # 线索提供人
            data_list.append(thread_people)
            thread_people_unity = project_obj.thread_people_unity  # 线索提供人单位
            data_list.append(thread_people_unity)
            thread_people_mobile = project_obj.thread_people_mobile  # 线索提供人联系方式
            data_list.append(thread_people_mobile)
            remark = project_obj.remark  # 备注
            data_list.append(remark)
            target_data_list.append(data_list)
            # 记录项目动态
            time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    try:
        sheet_name_titles = {
            "sheet1": ["项目编号（自动生成）", "项目名称", "投资方名称",
                       "投资方所在省（自治区、直辖市、特别行政区）", "投资方所在市（州、盟、区）",
                       "项目类型一级行业", "项目类型二级行业",
                       "总投资额（万元）", "拟引资额（万元）", "项目基本情况",
                       "项目方基本情况", "线索提供人", "单位及职务", "联系方式", "备注"]}
        head_list = ''
        sheet = ''

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "线索库数据{}.xlsx".format(time_stamp)
        excel.save(path + file_name)

        # 记录项目动态
        for project_id in select_id_list:
            time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            write_dynamic(user_name, project_id, '导出了项目文件。', time1)

        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 批量导出-对接库数据
@api_manage.route("/BatchExportProject2", methods=["POST"])
def batch_export_project2():
    req_dic = request.get_json()
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    select_id_list = req_dic["select_id_list"]
    path = './apps/static/project_file/'
    # pro_path = 'D:/中研项目代码/flask_jincheng/apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:5050/static/project_file/'  # 项目路径
    if not select_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    for select_id in select_id_list:
        try:
            project_obj = SikuProject.query.filter_by(id=select_id).first()
            # 提取数据，写入xslx表格
            data_list = []
            project_num = project_obj.project_num  # 项目名称
            data_list.append(project_num)
            project_name = project_obj.project_name  # 项目名称
            data_list.append(project_name)
            investor_name = project_obj.investor_name  # 投资方名称
            data_list.append(investor_name)
            investor_district_provence = project_obj.provence  # 投资方所在地，省
            data_list.append(investor_district_provence)
            investor_district_city = project_obj.city  # 投资方所在地，市
            data_list.append(investor_district_city)
            industry = project_obj.industry  # 一级行业
            data_list.append(industry)
            industry2 = project_obj.industry2  # 二级行业
            data_list.append(industry2)
            investment_volume = project_obj.investment_volume  # 总投资额(万元)
            data_list.append(investment_volume)
            investment_volume1 = project_obj.investment_volume1  # ni投资额(万元)
            data_list.append(investment_volume1)
            project_to_area1 = project_obj.project_to_area1  # ni投资额(万元)
            data_list.append(project_to_area1)
            development_area = project_obj.development_area  # ni投资额(万元)
            data_list.append(development_area)
            project_address = project_obj.project_address  # ni投资额(万元)
            data_list.append(project_address)

            joint_condition = project_obj.joint_condition  # ni投资额(万元)
            data_list.append(joint_condition)
            project_problem = project_obj.project_problem  # ni投资额(万元)
            data_list.append(project_problem)
            project_stalker = project_obj.project_stalker  # ni投资额(万元)
            data_list.append(project_stalker)
            joint_person = project_obj.joint_person  # ni投资额(万元)
            data_list.append(joint_person)
            joint_person_unity = project_obj.joint_person_unity  # ni投资额(万元)
            data_list.append(joint_person_unity)
            joint_person_mobile = project_obj.joint_person_mobile  # ni投资额(万元)
            data_list.append(joint_person_mobile)
            project_people = project_obj.project_people  # ni投资额(万元)
            data_list.append(project_people)
            project_people_unity = project_obj.project_people_unity  # ni投资额(万元)
            data_list.append(project_people_unity)
            project_people_mobile = project_obj.project_people_mobile  # ni投资额(万元)
            data_list.append(project_people_mobile)
            remark = project_obj.remark  # 备注
            data_list.append(remark)
            target_data_list.append(data_list)
            # 记录项目动态
            time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    try:
        sheet_name_titles = {
            "sheet1": ["项目编号（自动生成）", "项目名称", "投资方名称",
                       "投资方所在省（自治区、直辖市、特别行政区）", "投资方所在市（州、盟、区）",
                       "项目类型一级行业", "项目类型二级行业",
                       "总投资额（万元）", "拟投资额（万元）", "拟落地区域", "开发区", "项目详细地址", "项目对接情况",
                       "项目当前存在问题", "项目跟踪人",
                       "对接人", "对接人单位及职务", "对接人联系方式", "项目方联系人",
                       "项目方单位及职务","项目方联系方式","备注",]}
        head_list = ''
        sheet = ''

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "对接库数据{}.xlsx".format(time_stamp)
        excel.save(path + file_name)

        # 记录项目动态
        for project_id in select_id_list:
            time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            write_dynamic(user_name, project_id, '导出了项目文件。', time1)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 批量导出-签约库数据
@api_manage.route("/BatchExportProject3", methods=["POST"])
def batch_export_project3():
    req_dic = request.get_json()
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    select_id_list = req_dic["select_id_list"]
    path = './apps/static/project_file/'
    # pro_path = 'D:/中研项目代码/flask_jincheng/apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:5050/static/project_file/'  # 项目路径
    if not select_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    for select_id in select_id_list:
        try:
            project_obj = SikuProject.query.filter_by(id=select_id).first()
            # 提取数据，写入xslx表格
            data_list = []
            project_num = project_obj.project_num  # 项目名称
            data_list.append(project_num)
            project_name = project_obj.project_name  # 项目名称
            data_list.append(project_name)
            attract_name = project_obj.attract_name  # 投资方名称
            data_list.append(attract_name)
            investor_name = project_obj.investor_name  # 投资方名称
            data_list.append(investor_name)
            investor_district_provence = project_obj.provence  # 投资方所在地，省
            data_list.append(investor_district_provence)
            investor_district_city = project_obj.city  # 投资方所在地，市
            data_list.append(investor_district_city)
            industry = project_obj.industry  # 一级行业
            data_list.append(industry)
            industry2 = project_obj.industry2  # 二级行业
            data_list.append(industry2)
            investment_volume = project_obj.investment_volume  # 总投资额(万元)
            data_list.append(investment_volume)
            investment_volume1 = project_obj.investment_volume1  # ni投资额(万元)
            data_list.append(investment_volume1)
            project_to_area = project_obj.project_to_area  # ni投资额(万元)
            data_list.append(project_to_area)
            development_area = project_obj.development_area  # ni投资额(万元)
            data_list.append(development_area)
            project_address = project_obj.project_address  # ni投资额(万元)
            data_list.append(project_address)

            progress_condition = project_obj.progress_condition  # ni投资额(万元)
            data_list.append(progress_condition)
            Party_A_name = project_obj.Party_A_name  # ni投资额(万元)
            data_list.append(Party_A_name)
            Party_A_people = project_obj.Party_A_people  # ni投资额(万元)
            data_list.append(Party_A_people)
            Party_A_mobile = project_obj.Party_A_mobile  # ni投资额(万元)
            data_list.append(Party_A_mobile)
            Party_B_name = project_obj.Party_B_name  # ni投资额(万元)
            data_list.append(Party_B_name)
            Party_B_people = project_obj.Party_B_people  # ni投资额(万元)
            data_list.append(Party_B_people)
            Party_B_mobile = project_obj.Party_B_mobile  # ni投资额(万元)
            data_list.append(Party_B_mobile)
            sign_time = project_obj.sign_time  # ni投资额(万元)
            data_list.append(sign_time)
            project_stalker = project_obj.project_stalker  # ni投资额(万元)
            data_list.append(project_stalker)
            joint_person = project_obj.joint_person  # ni投资额(万元)
            data_list.append(joint_person)
            joint_person_unity = project_obj.joint_person_unity  # ni投资额(万元)
            data_list.append(joint_person_unity)
            joint_person_mobile = project_obj.joint_person_mobile  # ni投资额(万元)
            data_list.append(joint_person_mobile)
            project_people = project_obj.project_people  # ni投资额(万元)
            data_list.append(project_people)
            project_people_unity = project_obj.project_people_unity  # ni投资额(万元)
            data_list.append(project_people_unity)
            project_people_mobile = project_obj.project_people_mobile  # ni投资额(万元)
            data_list.append(project_people_mobile)
            remark = project_obj.remark  # 备注
            data_list.append(remark)
            target_data_list.append(data_list)
            # 记录项目动态
            time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    try:
        sheet_name_titles = {
            "sheet1": ["项目编号（自动生成）", "项目名称", "引资方名称",
                       "投资方所在省（自治区、直辖市、特别行政区）", "投资方所在市（州、盟、区）",
                       "项目类型一级行业", "项目类型二级行业",
                       "项目类型", "总投资额（万元）", "拟投资额（万元）", "落地区域", "开发区", "项目详细地址",
                       "项目推进情况", "签约甲方名称", "签约甲方联系人", "签约甲方联系方式", "签约乙方名称",
                       "签约乙方联系人", "签约乙方联系方式", "签约时间", "项目跟踪人", "对接人", "对接人单位及职务",
                       "对接人联系方式",  "项目方联系人", "项目方单位及职务", "项目方联系方式", "备注"]}
        head_list = ''
        sheet = ''

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "签约库数据{}.xlsx".format(time_stamp)
        excel.save(path + file_name)

        # 记录项目动态
        for project_id in select_id_list:
            time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            write_dynamic(user_name, project_id, '导出了项目文件。', time1)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 批量导出-开工库数据
@api_manage.route("/BatchExportProject4", methods=["POST"])
def batch_export_project4():
    req_dic = request.get_json()
    token = request.headers['token']
    try:
        user_obj = verify_token(token)
        user_name = user_obj.real_name
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.SESSIONERR, msg="用户信息校验失败，请重新登陆后尝试！")
    select_id_list = req_dic["select_id_list"]
    path = './apps/static/project_file/'
    # pro_path = 'D:/中研项目代码/flask_jincheng/apps/statics/project_file/'
    pro_path = 'http://39.100.39.50:5050/static/project_file/'  # 项目路径
    if not select_id_list:
        return jsonify(code=RET.PARAMERR, msg="参数不能为空！")
    target_data_list = []
    for select_id in select_id_list:
        try:
            project_obj = SikuProject.query.filter_by(id=select_id).first()
            # 提取数据，写入xslx表格
            data_list = []
            project_num = project_obj.project_num  # 项目名称
            data_list.append(project_num)
            project_name = project_obj.project_name  # 项目名称
            data_list.append(project_name)
            attract_name = project_obj.attract_name  # 投资方名称
            data_list.append(attract_name)
            investor_name = project_obj.investor_name  # 投资方名称
            data_list.append(investor_name)
            investor_district_provence = project_obj.provence  # 投资方所在地，省
            data_list.append(investor_district_provence)
            investor_district_city = project_obj.city  # 投资方所在地，市
            data_list.append(investor_district_city)
            industry = project_obj.industry  # 一级行业
            data_list.append(industry)
            industry2 = project_obj.industry2  # 二级行业
            data_list.append(industry2)
            investment_volume = project_obj.investment_volume  # 总投资额(万元)
            data_list.append(investment_volume)
            investment_volume1 = project_obj.investment_volume1  # ni投资额(万元)
            data_list.append(investment_volume1)

            investment = project_obj.investment  # ni投资额(万元)
            data_list.append(investment)

            project_to_area = project_obj.project_to_area  # ni投资额(万元)
            data_list.append(project_to_area)
            development_area = project_obj.development_area  # ni投资额(万元)
            data_list.append(development_area)
            project_address = project_obj.project_address  # ni投资额(万元)
            data_list.append(project_address)

            progress_condition = project_obj.progress_condition  # ni投资额(万元)
            data_list.append(progress_condition)
            project_problem = project_obj.project_problem  # ni投资额(万元)
            data_list.append(project_problem)
            sign_time = project_obj.sign_time  # ni投资额(万元)
            data_list.append(sign_time)
            start_time = project_obj.start_time  # ni投资额(万元)
            data_list.append(start_time)
            project_stalker = project_obj.project_stalker  # ni投资额(万元)
            data_list.append(project_stalker)
            joint_person = project_obj.joint_person  # ni投资额(万元)
            data_list.append(joint_person)
            joint_person_unity = project_obj.joint_person_unity  # ni投资额(万元)
            data_list.append(joint_person_unity)
            joint_person_mobile = project_obj.joint_person_mobile  # ni投资额(万元)
            data_list.append(joint_person_mobile)
            project_people = project_obj.project_people  # ni投资额(万元)
            data_list.append(project_people)
            project_people_unity = project_obj.project_people_unity  # ni投资额(万元)
            data_list.append(project_people_unity)
            project_people_mobile = project_obj.project_people_mobile  # ni投资额(万元)
            data_list.append(project_people_mobile)
            remark = project_obj.remark  # 备注
            data_list.append(remark)
            target_data_list.append(data_list)
            # 记录项目动态
            time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        except Exception as e:
            current_app.logger.error(e)
            return jsonify(code=RET.DBERR, msg="数据库查询错误！")
    try:
        sheet_name_titles = {
            "sheet1": ["项目编号（自动生成）", "项目名称", "引资方名称", "投资方名称",
                       "投资方所在省（自治区、直辖市、特别行政区）", "投资方所在市（州、盟、区）",
                       "项目类型一级行业", "项目类型二级行业", "总投资额（万元）", "拟投资额（万元）", "到位资金（万元）", "落地区域", "开发区",
                       "项目详细地址", "项目推进情况", "项目当前存在问题", "签约时间", "开工时间",
                       "项目跟踪人", "对接人", "对接人单位及职务", "对接人联系方式", "项目方联系人", "项目方单位及职务",
                       "项目方联系方式",  "备注"]}
        head_list = ''
        sheet = ''

        excel = xlwt.Workbook(encoding='utf-8')
        # 写入表头
        for i in range(len(sheet_name_titles)):
            for k, v in sheet_name_titles.items():
                sheet_name = k
                sheet = excel.add_sheet(sheet_name)
                head_list = v
                print(head_list)
                for j in range(len(head_list)):
                    sheet.write(0, j, head_list[j])
        # 写入数据，从第二行(i+1)
        rows = len(target_data_list)
        cols = len(head_list)
        for i in range(rows):
            for j in range(cols):
                sheet.write(i + 1, j, target_data_list[i][j])
        time_stamp = '{0:%Y%m%d%H%M%S}'.format(datetime.now())
        file_name = "开工库数据{}.xlsx".format(time_stamp)
        excel.save(path + file_name)

        # 记录项目动态
        for project_id in select_id_list:
            time1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
            write_dynamic(user_name, project_id, '导出了项目文件。', time1)
        return jsonify(code=RET.OK, url=pro_path + file_name, msg="导出/下载成功！")
    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="批量导出操作失败！")


# 获取项目动态
@api_manage.route("/GetProjectLog", methods=["POST"])
def get_project_log():
    req_dic = request.get_json()
    project_id = req_dic['project_id']
    page = req_dic['page']
    per_page = req_dic['per_page']
    try:
        log_obj_list = ProjectDynamicLog.query.filter(ProjectDynamicLog.project_id == project_id)
        size = len(log_obj_list.all())
        log_obj_list = log_obj_list.order_by(ProjectDynamicLog.time.desc()).paginate(page, per_page).items
        data = [{
            "id": log_obj.id,
            "item": log_obj.operation_people + log_obj.item,
            "time": log_obj.time,
        } for log_obj in log_obj_list]
        return jsonify(code=RET.OK, data={'data': data, 'size': size, 'msg': '项目动态信息获取成功！'})

    except Exception as e:
        current_app.logger.error(e)
        return jsonify(code=RET.DBERR, msg="项目动态信息获取失败！")


































