from werkzeug.routing import BaseConverter
from apps.utils.response_code import RET
from itsdangerous import TimedJSONWebSignatureSerializer as Serializer
from itsdangerous import SignatureExpired, BadSignature
from flask import request, jsonify, current_app
from config import Config
# from apps.models import User, Bstage
import functools
# from flask_httpauth import HTTPBasicAuth
#
# auth = HTTPBasicAuth


class RegexConverter(BaseConverter):
    def __init__(self, url_map, regex):
        super(RegexConverter, self).__init__(url_map)
        self.regex = regex


def create_token(api_user):
    '''
    生成token
    :param api_user:用户id
    :return: token
    '''
    # 第一个参数是内部的私钥,第二个参数是有效期(秒)
    s = Serializer(current_app.config["SECRET_KEY"], expires_in=Config.TOKEN_EXPIRATION)
    # 接收用户id转换与编码
    token = s.dumps({"id": api_user,"type":"登录验证"}).decode("ascii")
    return token


def verify_token(token):
    '''
    校验token
    :param token:
    :return: 用户信息 or None
    '''
    s = Serializer(current_app.config["SECRET_KEY"])
    # try:
    #     s = s.loads(token)
    # except BadSignature:
    #     raise AuthFailed(msg="token is invalid", error_code=1004)
    # except SignatureExpired:
    #     raise AuthFailed(msg="token is expired", error_code=1004)
    try:
        data = s.loads(token)
    except SignatureExpired:  # 签名错误，签名被修改
        print("签名错误")
        return None  # valid token,but expired
    except BadSignature:  # 签名已过期
        print("签名过期")
        return None  # invalid token
    # 拿到转换后的数据，根据模型类去数据库查询用户信息
    user = User.query.get(data["id"])
    return user


# 后台验证
def verify_btoken(token):
    '''
    校验token
    :param token:
    :return: 用户信息 or None
    '''
    s = Serializer(current_app.config["SECRET_KEY"])
    try:
        # 转换为字典
        data = s.loads(token)
    except Exception:
        return None
    # 拿到转换后的数据，根据模型类去数据库查询用户信息
    user = Bstage.query.get(data["id"])
    return user


def login_required(view_func):
    @functools.wraps(view_func)
    def verify_token(*args, **kwargs):
        try:
            # 在请求头上拿到token
            token = request.headers["token"]
        except Exception:
            # 没接收的到token,给前端抛出错误
            return jsonify(code=RET.NODATA, msg='缺少参数token')

        s = Serializer(current_app.config["SECRET_KEY"])
        try:
            s.loads(token)
        except Exception:
            return jsonify(code=RET.SESSIONERR, msg="未登录，或者登录已过期")

        return view_func(*args, **kwargs)

    return verify_token
